<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * View class 
 */
class TaxibookingViewCoupon extends JViewLegacy
{
	protected $item;
    
	protected $state;
    
	/**
	* Display the view
	*
	* @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	*
	* @return  void
	*/
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		$config = JFactory::getConfig();
		
		$this->elsettings 	= booking_helper::config();
		$this->item	= $this->get('Item');
		$this->state	= $this->get('State');
		$isNew		= ($this->item->id == 0);
		$this->editor =  JFactory::getEditor();
	
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		// process array data
		$this->item->coupon_user_group = ($this->item->coupon_user_group=="") ? array() : explode(',', $this->item->coupon_user_group);
		$this->item->special_routes = ($this->item->special_routes=="") ? array() : explode(',', $this->item->special_routes);
		$this->item->booking_types = ($this->item->booking_types=="") ? array() : explode(',', $this->item->booking_types);
		
		$this->has_app_coupon = $this->_hasAnyAppCoupon();
		//build selectlists
		$this->lists = $this->_buildEditLists($this->item);
		
		$this->addToolbar();

		parent::display($tpl);
	}
	
	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		JFactory::getApplication()->input->set('hidemainmenu', true);
	
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();
	
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
	    
		JToolbarHelper::title($isNew ? JText::_('COM_TAXIBOOKING_MANAGER_COUPON_NEW') : JText::_('COM_TAXIBOOKING_MANAGER_COUPON_EDIT'), 'generic');
		
		// If not checked out, can save the item.
		if (!$checkedOut)
		{
			JToolbarHelper::apply();
			JToolbarHelper::save();
		}
		
		JToolbarHelper::cancel();
	}
	
	/**
	 * Check if there is an app coupon already added, if yes, hide the app sharing radio
	 *
	 * @since 1.0
	 */
	private function _hasAnyAppCoupon()
	{
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('COUNT(id)');
		$query->from('#__taxibooking_coupons');
		$query->where('published = 1');
		$query->where('for_company_share = 1');
		$db->setQuery((string)$query);
		$result = $db->loadResult();
		
		if($result>0){
			return TRUE;
		}
		return FALSE;
	}
	/**
	 * Creates list
	 *
	 * @since 1.0
	 */
	private function _buildEditLists($item)
	{
                $db = JFactory::getDBO();
		
		$options = array();
                $options[] = JHTML::_('select.option',  '*', JText::_( 'JALL' ) );
		$rows = JHtml::_('contentlanguage.existing');
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->value, $row->text);
			}
                }
                $lists['languages'] = JHTML::_('select.genericlist', $options, 'language', '', 'value', 'text', $item->language );
		
		$options = array();
		if((int)$this->elsettings->show_address_tab==1){
			$options[] = JHTML::_('select.option',  'address', JText::_( 'SEARCHURL_BOOKING_TYPE_ADDRESS_SEARCH' ) );
		}
		if((int)$this->elsettings->show_offers_tab==1){
			$options[] = JHTML::_('select.option',  'offers', JText::_( 'SEARCHURL_BOOKING_TYPE_SPECIAL_OFFERS' ) );
		}
		if((int)$this->elsettings->show_hourly_tab==1 && booking_helper::is_hourly_rate_enabled()){
			$options[] = JHTML::_('select.option',  'hourly', JText::_( 'SEARCHURL_BOOKING_TYPE_HOURLY_HIRE' ) );
		}
		if((int)$this->elsettings->show_shuttles_tab==1 && booking_helper::is_shuttles_enabled()){
			$options[] = JHTML::_('select.option',  'shuttle', JText::_( 'SEARCHURL_BOOKING_TYPE_SHUTTLES' ) );
		}
                $lists['booking_types'] = JHTML::_('select.genericlist', $options, 'booking_types[]', ' size="4" multiple="multiple" class="inputbox"', 'value', 'text', $item->booking_types );
		
		// special routes list
		$query = $db->getQuery(true);
     
		// Select the required fields from the table.
		$query->select('a.id AS value, a.title AS text' );
		$query->from($db->quoteName('#__taxibooking_routes') . ' AS a');
		$query->where('a.published = 1');
		$query->order($db->escape('title ASC'));
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
		
		$options = array();
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->value, $row->text);
			}
                }
		
                $lists['special_routes'] = JHTML::_('select.genericlist', $options, 'special_routes[]', ' size="4" multiple="multiple" class="inputbox"', 'value', 'text', $item->special_routes );
		
		return $lists;
	}
}