<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$frontend_orders_data = array();
foreach($this->frontend_orders as $k => $v)
{
    $datetime = strtotime($k)*1000; // convert from Unix timestamp to JavaScript time
    $frontend_orders_data[] = "[$datetime, $v]";
}
$drivenot_orders_data = array();
foreach($this->drivenot_orders as $k => $v)
{
    $datetime = strtotime($k)*1000; // convert from Unix timestamp to JavaScript time
    $drivenot_orders_data[] = "[$datetime, $v]";
}
?>

<?php if(version_compare(JVERSION,'3.1.5','le')) {?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<?php } ?>
<script src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/highcharts.js"></script>

<script type="text/javascript">
var tbjQuery = jQuery.noConflict( );
var BASE_URL = '<?php echo JURI::root();?>';
var d = new Date();
tbjQuery(function () {
    tbjQuery('#chart_container').highcharts({
        chart: {
            type: 'column',
            spacingLeft: 0
        },
        title: {
            text: '<?php echo JText::_('DRIVENOT_BOOKING_CHART_HEADER');?>'
        },
        subtitle: {
            text: null
        },
        xAxis: {
            type: 'datetime',
            dateTimeLabelFormats: {
                day: '%b %e',
                week: '%b %e'
            }
        },
        yAxis: {
            min: 0,
            title: {
                text: null
            }
        },
        tooltip: {
            headerFormat: '<table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                '<td style="padding:0"><b>{point.y}</b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true
        },
        legend: {
            enabled: false
        },
        credits: {
            enabled: false							
        },
        plotOptions: {
            column: {
                pointPadding: 0.2,
                borderWidth: 0
            }
        },
        series: [{
            name: '<?php echo JText::_('DRIVENOT_BOOKING_CHART_TYPE_WEB');?>',
            data: [<?php echo join($frontend_orders_data, ',') ?>]
        },
        {
            name: '<?php echo JText::_('DRIVENOT_BOOKING_CHART_TYPE_DRIVENOT');?>',
            data: [<?php echo join($drivenot_orders_data, ',') ?>]
        }]
    });
});
</script>

<?php 
JHtml::_('behavior.tooltip');
?>

<div class="taxibooking-drivenot">
    <button class="btn btn-small" onclick="location.href='index.php?option=com_taxibooking&view=drivenot&layout=edit';">
    <?php echo JText::_('DRIVENOT_APPLY_BTN');?>
    </button>
</div>

<!-- Booking by months Chart -->
<div id="chart_container" style="min-width: 200px; height: 400px; margin: 0 auto"></div>

<div class="taxibooking-drivenot" style="margin-top:20px;">
    <label for="title">
        <span class="hasTip control-label" title="<?php echo JText::_('DRIVENOT_COUPON_URL_ANALYTICS_EXPLAIN'); ?>">
            <?php echo JText::sprintf('DRIVENOT_COUPON_URL_ANALYTICS', $this->shortUrl_clicked);?>
        </span>
    </label>
    
</div>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>

<!--

URL Analytics Response:

stdClass Object
(
    [kind] => urlshortener#url
    [id] => http://goo.gl/mzB6uA
    [longUrl] => http://qucksite.com/share/media/taxibooking/qucksite-j3-android-coupon.html
    [status] => OK
    [created] => 2014-11-20T14:56:24.781+00:00
    [analytics] => stdClass Object
        (
            [allTime] => stdClass Object
                (
                    [shortUrlClicks] => 5
                    [longUrlClicks] => 5
                    [referrers] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => unknown
                                )

                        )

                    [countries] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => BD
                                )

                        )

                    [browsers] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 2
                                    [id] => Chrome
                                )

                            [1] => stdClass Object
                                (
                                    [count] => 2
                                    [id] => Firefox
                                )

                            [2] => stdClass Object
                                (
                                    [count] => 1
                                    [id] => MSIE
                                )

                        )

                    [platforms] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => Windows
                                )

                        )

                )

            [month] => stdClass Object
                (
                    [shortUrlClicks] => 5
                    [longUrlClicks] => 5
                    [referrers] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => unknown
                                )

                        )

                    [countries] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => BD
                                )

                        )

                    [browsers] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 2
                                    [id] => Chrome
                                )

                            [1] => stdClass Object
                                (
                                    [count] => 2
                                    [id] => Firefox
                                )

                            [2] => stdClass Object
                                (
                                    [count] => 1
                                    [id] => MSIE
                                )

                        )

                    [platforms] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => Windows
                                )

                        )

                )

            [week] => stdClass Object
                (
                    [shortUrlClicks] => 5
                    [longUrlClicks] => 5
                    [referrers] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => unknown
                                )

                        )

                    [countries] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => BD
                                )

                        )

                    [browsers] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 2
                                    [id] => Chrome
                                )

                            [1] => stdClass Object
                                (
                                    [count] => 2
                                    [id] => Firefox
                                )

                            [2] => stdClass Object
                                (
                                    [count] => 1
                                    [id] => MSIE
                                )

                        )

                    [platforms] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => Windows
                                )

                        )

                )

            [day] => stdClass Object
                (
                    [shortUrlClicks] => 5
                    [longUrlClicks] => 5
                    [referrers] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => unknown
                                )

                        )

                    [countries] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => BD
                                )

                        )

                    [browsers] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 2
                                    [id] => Chrome
                                )

                            [1] => stdClass Object
                                (
                                    [count] => 2
                                    [id] => Firefox
                                )

                            [2] => stdClass Object
                                (
                                    [count] => 1
                                    [id] => MSIE
                                )

                        )

                    [platforms] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 5
                                    [id] => Windows
                                )

                        )

                )

            [twoHours] => stdClass Object
                (
                    [shortUrlClicks] => 5
                    [longUrlClicks] => 5
                    [referrers] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 1
                                    [id] => unknown
                                )

                        )

                    [countries] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 1
                                    [id] => BD
                                )

                        )

                    [browsers] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 1
                                    [id] => MSIE
                                )

                        )

                    [platforms] => Array
                        (
                            [0] => stdClass Object
                                (
                                    [count] => 1
                                    [id] => Windows
                                )

                        )

                )

        )

)
-->
