<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
/**
 * View class for the Drivenot screen
 */
class TaxibookingViewDrivenot extends JViewLegacy
{
	function display($tpl = null)
	{
		$mainframe	= JFactory::getApplication();
		//initialise variables
		$document 	=  JFactory::getDocument();
		$acl		=  JFactory::getACL();
		$uri 		= JFactory::getURI();
		$current_uri = $uri->toString();
		$user 		= JFactory::getUser();
                $editor 	= JFactory::getEditor();
		$this->lang 	= JFactory::getLanguage();
		$elsettings =  booking_helper::config();
		
		//get data from model
		$this->data =  $this->get( 'Data');
		
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		TaxibookingHelper::addSubmenu('drivenot');
		
		$app_sharing_coupon_exists = FALSE;
		$layout = JFactory::getApplication()->input->get('layout', 'default', 'string');
		if($layout=='default')
		{
			$this->shortUrl_clicked = 0;
			if($this->data->app_sharing_coupon_code != "" && $this->data->app_sharing_coupon_url != "")
			{
				$app_sharing_coupon_exists = TRUE;
				
				$params = JComponentHelper::getParams('com_taxibooking');
				$url_shortner_api_key = $params->get('url_shortner_api_key', '');
				
				// If TB admin does not add URL Shortner API key, we will use our own key (taxibookingpro@gmail.com)
				// to get the short URL click info always
				if($url_shortner_api_key==""){
					$url_shortner_api_key = 'AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o';
				}
				
				require_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'google_url.php');
				$api = new GoogleURL();
				$shortUrl = $this->data->app_sharing_coupon_url;
				$params = array('shortUrl' => $shortUrl, 'key' => $url_shortner_api_key,'projection' => "FULL");
				$coupon_url_analytics_response = $api->httpGet($params);
				
				if($coupon_url_analytics_response->status=='OK'){
					$this->shortUrl_clicked = $coupon_url_analytics_response->analytics->allTime->shortUrlClicks;
				}
				else {
					if(isset($coupon_url_analytics_response->error)){
						$app->enqueueMessage('Google URL Shortener API error code - '.$coupon_url_analytics_response->error->code.', message - '.$coupon_url_analytics_response->error->message.', reason - '.$coupon_url_analytics_response->error->errors[0]->reason, 'warning');
					}
				}
			}
		}
		
		list($frontend_orders,$drivenot_orders) = $this->_getChartBookingData();
		$this->frontend_orders = $frontend_orders;
		$this->drivenot_orders = $drivenot_orders;
		
		$this->addToolbar();

		parent::display($tpl);
	}
	
	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
	
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();
	
		JToolbarHelper::title(JText::_('SUBMENU_BOOKING_DRIVENOT'), 'generic');
		
		$layout = JFactory::getApplication()->input->get('layout', 'default', 'string');
	}
	
	private function _getChartBookingData()
	{
		$db= JFactory::getDBO();
		
		$frontend_orders = array();
		
		$months = array();
		for ($i = 11; $i >=0; $i--) {
			$months[] = date("Y-m-d", strtotime( date( 'Y-m-01' )." -$i months"));
		}

		$sql = 'SELECT DATE_FORMAT(created,"%Y-%m-01") AS date, YEAR(created) as year, MONTH(created) as month, 1 AS day, COUNT(id) AS total_orders 
			FROM #__taxibooking_orders
			WHERE created > DATE_SUB(now(), INTERVAL 12 MONTH)
			AND source = "frontend"
			GROUP BY year, month';
		$db->setQuery($sql);
		$rows = $db->loadObjectList();
		
		foreach($months as $key => $val)
		{
			$frontend_orders[$val] = 0;
			foreach($rows as $k => $v)
			{
				if($val==$v->date){
					$frontend_orders[$val] = $v->total_orders;
				}
			}
		}
		
		$drivenot_orders = array();
		$sql = 'SELECT DATE_FORMAT(created,"%Y-%m-01") AS date, YEAR(created) as year, MONTH(created) as month, 1 AS day, COUNT(id) AS total_orders 
			FROM #__taxibooking_orders
			WHERE created > DATE_SUB(now(), INTERVAL 12 MONTH)
			AND source = "drivenot"
			GROUP BY year, month';
		$db->setQuery($sql);
		$rows = $db->loadObjectList();
		
		foreach($months as $key => $val)
		{
			$drivenot_orders[$val] = 0;
			foreach($rows as $k => $v)
			{
				if($val==$v->date){
					$drivenot_orders[$val] = $v->total_orders;
				}
			}
		}
		
		/*echo '<pre>';
		print_r($months);
		print_r($rows);
		print_r($data);
		echo '</pre>';*/
		
		return array($frontend_orders,$drivenot_orders);
	}
}