<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/calendar.css" />

<?php
$ynoptions = array();
$ynoptions[] = JHTML::_('select.option', 1, JText::_('JYES'));
$ynoptions[] = JHTML::_('select.option', 0, JText::_('JNO'));

JHtml::_('behavior.tooltip');

?>

<style type="text/css">
.map-canvas-wrapper {
    margin: 20px 10px 10px 0px;
    padding: 10px 10px 10px 0px;
    min-height: 450px;
    height: 450px;
    width: 100%;
}
#map-canvas {
    width: 100%;
    height: 100%;
}

</style>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o&v=3.exp"></script>
<script src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/google.maps.Polygon.getBounds.js"></script>
<script src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/google.maps.Polygon.moveTo.js"></script>

<?php

// returns array
function getCars()
{
	$cars = [];
	
	$orders = getOrders();
	// echo "<pre>";
	// print_r($orders);

	// same as above but different approach
	// foreach($orders_raw as $order_raw) $out[$order_raw['driver_id']] = $order_raw;

	if (count($orders) > 0) {
		foreach($orders as $order) {
			if ($carPosition = getPositionforDriver($order['driver_id'])) {
				$carPosition['driver_name'] = getDriverNamefromId($order['driver_id']);
				$carPosition['trip'] = $order['begin'] . ' > ' . $order['end'];
				$carPosition['order_id'] = $order['id'];
				$cars[] = $carPosition;
			}
		}
	}
	// echo "<pre>";
	// print_r($cars);

	return $cars;
	// return ['cars' => $cars, 'orders' => $orders];
}

// returns array
function getOrders()
{
	$orders = [];
	$time_3hours = strtotime("+3 hours");
	$time_now = strtotime("now");

	$db = JFactory::getDbo();

	$query = $db->getQuery(true);

	$query->select($db->quoteName(array('driver_id', 'id', 'datetime1', 'datetime2', 'begin', 'end')));
	$query->from($db->quoteName('#__taxibooking_orders'));
	$query->where($db->quoteName('datetime1')." < ".$db->quote($time_3hours));
	$query->where($db->quoteName('datetime1')." > ".$db->quote($time_now));
	$query->where($db->quoteName('driver_id')." != ".$db->quote('0'));
	$query->order('datetime1 DESC');
	$query->setLimit(200);

	$db->setQuery($query);
	$orders_raw = $db->loadAssocList();
	return array_column($orders_raw, null, 'driver_id');
}

// returns string or null
function getCarPosition($driver)
{
	if ($carPosition = getPositionforDriver($driver)) {
		return $carPosition;
	}
	return null;
}

function getPositionforDriver($driver) 
{
	if ($driver > 0)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('latitude', 'longitude', 'driver_id')));
		$query->from($db->quoteName('#__driver_position'));
		$query->where($db->quoteName('driver_id')." = ".$db->quote($driver));
		$query->order('id DESC');
		$query->setLimit(1);

		$db->setQuery($query);
		return $db->loadAssoc();
	}
	return null;
}

function getDriverNamefromId($driver_id) 
{
	$db = JFactory::getDbo();
	$query = $db->getQuery(true);
	$query->select($db->quoteName(array('name')));
	$query->from($db->quoteName('#__taxibooking_users'));
	$query->where($db->quoteName('user_id')." = ".$db->quote($driver_id));
	$query->setLimit(1);

	$db->setQuery($query);
	return $db->loadResult();
}


$cars = getCars();
$orders = getOrders();
?>
<script type="text/javascript">
var map,areaOfOperation,geocoder;

function initialize() {

// Create a LatLng object
// We use this LatLng object to center the map and position the marker
var center = new google.maps.LatLng(51.5074,0.1278);

// Declare your map options
var mapOptions = {
	zoom: 7,
	center: center,
	mapTypeId: google.maps.MapTypeId.ROADMAP
};

// Create a map in the #map HTML element, using the declared options
var map = new google.maps.Map(document.getElementById("map-canvas"), mapOptions);

<?php 
if (count($cars) > 0) 
{ 
	foreach($cars as $car) {
	?>
// Create a marker and place it on the map
const carLatLong_<?php echo $car['order_id']; ?> = { lat: <?php echo $car['latitude']; ?>, lng: <?php echo $car['longitude']; ?> };
const marker_title_<?php echo $car['order_id']; ?> = "<?php echo $car['driver_name'] . '\n\n' . $car['trip']; ?>"
const marker_link_<?php echo $car['order_id']; ?> = "https://kabsky.co.uk/administrator/index.php?option=com_taxibooking&view=order&layout=default&id=<?php echo $car['order_id']; ?>"
var marker_<?php echo $car['order_id']; ?> = new google.maps.Marker({
	position: carLatLong_<?php echo $car['order_id']; ?>,
	map: map,
	url: marker_link_<?php echo $car['order_id']; ?>,
	title: marker_title_<?php echo $car['order_id']; ?>
});
google.maps.event.addListener(marker_<?php echo $car['order_id']; ?>, 'click', function() {
      window.location.href = marker_<?php echo $car['order_id']; ?>.url;
    });
<?php 
	}
} 
?>
}

google.maps.event.addDomListener(window, 'load', initialize);


</script>


<?php 
// echo "count of orders: " . count($orders);
// echo "<br>count of cars: " . count($cars); 
if (count($cars) > 0)
{
?>

	<div class="map-canvas-wrapper">
		<div id="map-canvas"></div>
	</div>

<?php 
} 
	elseif ((count($orders) > 0)) { ?>
	<h2>There are <?php echo count($orders); ?> upcoming trips</h2>
	<ul>
		<?php foreach ($orders as $order)
		{ ?>
			<li><a href="https://kabsky.co.uk/administrator/index.php?option=com_taxibooking&view=order&layout=default&id=<?php echo $order['id']; ?>">From: <?php echo $order['begin']; ?> >> To: <?php echo $order['end']; ?></a></li>
		<?php 
		} ?>
		</ul>
		<p>* Seeing orders here instead of the map means that none of the drivers assigned to these orders has the GPS position saved. </p>
<?php
	} else { ?>
	<h2>There are no upcoming trips in the next 3 hours.</h2>
<?php }
?>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>
