<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * View class 
 */
class TaxibookingViewField extends JViewLegacy
{
	protected $item;
    
	protected $state;
    
	/**
	* Display the view
	*
	* @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	*
	* @return  void
	*/
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		$config = JFactory::getConfig();
		
		//get vars
		$cid 		= JRequest::getVar( 'cid' );
		$this->type 	= JRequest::getVar( 'type' );
		
		$this->elsettings 	= booking_helper::config();
		$this->item	= $this->get('Item');
		$this->category     = $this->get( 'Category' );
		$this->state	= $this->get('State');
		$isNew		= ($this->item->id == 0);
		$this->editor =  JFactory::getEditor();
	
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		//build selectlists
		$this->lists = $this->_buildEditLists($this->item);
		$this->item->field_options = unserialize($this->item->field_options);
		
		$this->addToolbar();

		parent::display($tpl);
	}
	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		JFactory::getApplication()->input->set('hidemainmenu', true);
	
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();
	
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
	    
		JToolbarHelper::title($isNew ? JText::_('COM_TAXIBOOKING_MANAGER_FIELD_NEW') : JText::_('COM_TAXIBOOKING_MANAGER_FIELD_EDIT'), 'generic');
		
		// If not checked out, can save the item.
		if (!$checkedOut)
		{
			JToolbarHelper::apply();
			JToolbarHelper::save();
		}
		
		JToolbarHelper::cancel();
	}
	
	/**
	 * Creates list
	 *
	 * @since 1.0
	 */
	private function _buildEditLists($item)
	{
		$type 		= JRequest::getVar( 'type' );
                $db = JFactory::getDBO();
		
		// now list cars
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_poicats');
		$query->where('published = "1"');
		$query->order('ordering ASC');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
                
		$sel_cats = explode(',', $item->catid);
		$options = array();
                $options[] = JHTML::_('select.option',  '', JText::_( 'CATEGORY' ) );
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->id, $row->title );
			}
                }
                $lists['categories'] = JHTML::_('select.genericlist', $options, 'catid[]', 'multiple="multiple" size="5"', 'value', 'text', $sel_cats );
		
		$field_id = !empty($item->id) ? $item->id : 0;
		
		$field_type_options = array();
		$field_type_options[] = JHTML::_('select.option', '', '- ' . JText::_('Select Type') . ' -');
		$field_type_options[] = JHTML::_('select.option', 'input', JText::_('INPUT_TYPE'));
		$field_type_options[] = JHTML::_('select.option', 'textarea', JText::_('CUSTOM_FIELD_EDIT_TYPE_TEXTAREA'));
		$field_type_options[] = JHTML::_('select.option', 'extra', JText::_('EXTRA_TYPE'));
		$field_type_options[] = JHTML::_('select.option', 'optionlist', JText::_('OPTION_LIST_TYPE'));
		$lists['field_type_list'] = JHTML::_('select.genericlist', $field_type_options, 'field_type', 'class="inputbox" size="1" onchange="load_type_fields('.$field_id.', this.value);"', 'value', 'text', $type);
		
		// lang list
		$options = array();
                $options[] = JHTML::_('select.option',  '*', JText::_( 'JALL' ) );
		$rows = JHtml::_('contentlanguage.existing');
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->value, $row->text);
			}
                }
                $lists['languages'] = JHTML::_('select.genericlist', $options, 'language', '', 'value', 'text', $item->language );
		
		return $lists;
	}
}