<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');
?>

<?php if(version_compare(JVERSION,'3.1.5','le')) {?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<?php } ?>

<script language="javascript" type="text/javascript">
var xhr = null;
var tbjQuery = jQuery.noConflict();
var BASE_URL = '<?php echo JURI::root();?>';
var page_mode = '<?php echo ($this->item->id > 0) ? 'edit' : 'add' ?>';

tbjQuery(document).ready(function(){

    tbjQuery('a.send_notes').click(function(){
	tbjQuery('input[name="task"]').val('send_notes');
	Joomla.submitform('send_notes', document.getElementById('adminForm'));
    })
    tbjQuery('a.change_property_trigger').click(function(){
	tbjQuery(this).next('div.change_property_wrap').show();
	tbjQuery(this).hide();
    })
    tbjQuery('a.cancel_trigger').click(function(){
	tbjQuery(this).parent('div.change_property_wrap').siblings('a.change_property_trigger').show();
	tbjQuery(this).parent('div.change_property_wrap').hide();
    })
    tbjQuery('#state').change(function(){
	if( xhr != null ) {
		xhr.abort();
		xhr = null;
	}
	xhr = tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&controller=orders&task=changeStatusAjax'
	    , data: 'id=<?php echo $this->item->id; ?>&new_status='+tbjQuery(this).val()
	    , dataType: 'json'
	    //, async: false
	    , beforeSend: function(){
		tbjQuery('#state').after('<img src="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/images/ajax-loader.gif" alt="Loading.." id="ajax_loader" />');
	    }
	    , complete: function(){
	    }
	    , success: function(response){
		tbjQuery('img#ajax_loader').remove();
		if(response.error==1)
		{
		    alert(response.msg);
		    return false;
		}
		else {
		    window.location.reload();
		}
	    }
	})
    })
    tbjQuery('#driver_id').change(function(){
	if( xhr != null ) {
		xhr.abort();
		xhr = null;
	}
	xhr = tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&controller=orders&task=changeDriverAjax'
	    , data: 'id=<?php echo $this->item->id; ?>&new_driver='+tbjQuery(this).val()
	    , dataType: 'json'
	    //, async: false
	    , beforeSend: function(){
		tbjQuery('#driver_id').after('<img src="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/images/ajax-loader.gif" alt="Loading.." id="ajax_loader" />');
	    }
	    , complete: function(){
	    }
	    , success: function(response){
		tbjQuery('img#ajax_loader').remove();
		if(response.error==1)
		{
		    alert(response.msg);
		    return false;
		}
		else {
			alert('Driver has been assigned to the job, but please note, the driver can refuse the job in which case he will be removed from the job.');
		    // window.location.reload();
		}
	    }
	})
    })
})
</script>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/orders.css" />

<form action="<?php echo JRoute::_('index.php' ); ?>" method="post" name="adminForm" id="adminForm">
    <div class="adminlist" width="100%">

	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
	    <?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'panel_1')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'panel_1', JText::_('ORDER_DETAILS_USER_DETAILS_HEADER')); ?>
	    <?php } else { ?>
	    <?php echo JHtml::_('tabs.start', 'tab_group_id', array('useCookie'=>0)); ?>

		<?php echo JHtml::_('tabs.panel', JText::_('ORDER_DETAILS_USER_DETAILS_HEADER'), 'panel_1'); ?>
	    <?php } ?>

<div class="adminform tab1">
	<div class="adminlist_left" valign="top">

	    <div class="admin_list_item clearfix">
		<div class="admin_list_item_one"><?php echo JText::_('ORDER_LIST_ORDER_NUMBER');?>:</div>
		<div class="admin_list_item_two"><?php echo $this->item->order_number; ?></div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one"><?php echo JText::_('DRIVER');?>:</div>
		<div class="admin_list_item_two">
		    <?php
		    // get assigned driver details
		    if((int)$this->item->driver_id > 0){
			$driverObj = booking_helper::getDriverInfo($this->item->driver_id);
			if($driverObj){
			    echo $driverObj->name;
			}
			else {
			    echo JText::_('ORDER_DETAILS_NO_DRIVER_ASSIGNED');
			}
		    }
		    else {
			echo JText::_('ORDER_DETAILS_NO_DRIVER_ASSIGNED');
		    }
		    ?>
		    &nbsp;<a href="javascript:void(0);" class="change_property_trigger"><?php echo JText::_('COM_TAXIBOOKING_CHANGE_LABEL');?></a>
		    <div class="change_property_wrap" style="display:none;">
			<?php echo $this->lists['driver']; ?>
			&nbsp;<a href="javascript:void(0);" class="cancel_trigger"><?php echo JText::_('COM_TAXIBOOKING_CANCEL_LABEL');?></a>
		    </div>
		</div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('STATE');?>:</div>
		    <div class="admin_list_item_two">
			<?php echo booking_helper::get_order_status_text($this->item); ?>
			&nbsp;<a href="javascript:void(0);" class="change_property_trigger"><?php echo JText::_('COM_TAXIBOOKING_CHANGE_LABEL');?></a>
			<div class="change_property_wrap" style="display:none;">
			<?php echo $this->lists['state']; ?>
			&nbsp;<a href="javascript:void(0);" class="cancel_trigger"><?php echo JText::_('COM_TAXIBOOKING_CANCEL_LABEL');?></a>
			</div>

			<?php
			$pdf_invoice_url = "index.php?option=com_taxibooking&controller=orders&task=pdf_invoice&cid=". $this->item->id;
			$invoice_link = "<a href=\"javascript:void window.open('$pdf_invoice_url', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');\">";
                        $pdf_invoice = JPATH_COMPONENT . DS . "documents".DS.$this->item->invoice_title;
                        if ($this->item->state == 1 && ($this->item->invoice_title!="") && file_exists($pdf_invoice)):
                            echo $invoice_link;
                            ?>
                                <img src="<?php echo JURI::base();?>components/com_taxibooking/assets/images/pdf.png" width="25" height="25" />
                            </a>
                        <?php endif; ?>
		    </div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('NAME');?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->names; ?></div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('EMAIL');?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->email; ?></div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('PHONE');?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->phone; ?></div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('PASSENGERS');?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->selpassengers; ?></div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('CHECK_IN_LAGUAGE');?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->selluggage; ?></div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('INFANT_SEATS');?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->selinfantseats; ?></div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('CHILD_SEATS');?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->selchildseats; ?></div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('BOOSTER_SEATS');?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->selboosterseats; ?></div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('VEHICLE_TYPE');?>:</div>
		    <div class="admin_list_item_two">
			<?php if($this->item->vehicletype > 0){ ?>
			<a href="<?php echo JRoute::_('index.php?option=com_taxibooking&amp;controller=cars&amp;task=show&amp;cid[]='. $this->item->vehicletype);?>" target="_blank">
			    <?php echo booking_helper::get_order_car($this->item); ?>
			</a>
			<?php } else {?>
			<?php echo booking_helper::get_order_car($this->item); ?>
			<?php } ?>
		    </div>
	    </div>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('TRIP_DURATION');?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->duration_text; ?></div>
	    </div>
	    <?php if($this->item->booking_type!='hourly'){ ?>
	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one"><?php echo JText::_('FROM'); ?>:</div>
		<div class="admin_list_item_two"><?php echo trim($this->item->begin); ?></div>
	    </div>
	    <?php } ?>

	    <?php
	    if($this->item->poi_additional_charges != '')
	    {
		    $poi_additional_charges = unserialize($this->item->poi_additional_charges);
		    if(!empty($poi_additional_charges['pickup']))
		    {
	    ?>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo $poi_additional_charges['pickup']['fld_label'];?>:</div>
		    <div class="admin_list_item_two"><?php echo booking_helper::price_display($poi_additional_charges['pickup']['charge'], $this->elsettings);?></div>
	    </div>
	    <?php
		    }
	    }
	    ?>

	    <?php
	    if($this->item->extras != '')
	    {
		$extras = unserialize($this->item->extras);
		if(!empty($extras['pickup']))
		{
			$counter = 0;
			foreach($extras['pickup'] as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			?>
			<div class="admin_list_item clearfix">
				<div class="admin_list_item_one"><?php echo $extra['name'];?>:</div>
				<div class="admin_list_item_two">
					<?php echo $extra['value'];?>
					<?php if($extra['price']>0){
					    echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
					}?>
				</div>
			</div>
			<?php
			$counter++;
			}
		}
	    }
	    ?>

	    <?php if($this->item->booking_type!='hourly' && $this->item->PickupAddr1!=""){ ?>
	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one"><?php echo JText::_('STREET'); ?>:</div>
		<div class="admin_list_item_two"><?php echo $this->item->PickupAddr1; ?></div>
	    </div>
	    <?php } ?>

	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one"><?php echo JText::_('ORDER_DETAILS_PICKUP_DATE');?>:</div>
		<div class="admin_list_item_two">
		    <?php echo booking_helper::get_order_pickup_date($this->item, $this->elsettings); ?>
		</div>
	    </div>

	    <?php if($this->item->booking_type=='hourly'){ ?>

		<div class="admin_list_item clearfix tr_col_from">
		    <div class="admin_list_item_one"><?php echo JText::_('HOURLY_HIRE_VEHICLE_HIRED_FOR'); ?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->hourly_hr.':'.$this->item->hourly_min;?> hours</div>
	    </div>
	    <?php } ?>

	    <?php
	    $stops = unserialize($this->item->stops);
	    if(!empty($stops))
	    {
	    ?>
	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one"><?php echo JText::_('STOPS'); ?>:</div>
		<div class="admin_list_item_two">
		    <table border="0" width="100%">
			<?php foreach($stops as $key => $stop_row) { ?>
			<tr width="100%">
			    <td width="100%"><?php echo $stop_row['stop'].' - '.$stop_row['stop_interval'].' mins';?></td>
			</tr>
			<?php } ?>
		    </table>
		</div>
	    </div>
	    <?php } ?>

	    <?php if($this->item->booking_type!='hourly'){ ?>

	    <div class="admin_list_item clearfix tr_col_to">
		<div class="admin_list_item_one"><?php echo JText::_('TO'); ?>:</div>
		<div class="admin_list_item_two"><?php echo trim($this->item->end); ?></div>
	    </div>
	    <?php } ?>

	    <?php
	    if($this->item->poi_additional_charges != '')
	    {
		    $poi_additional_charges = unserialize($this->item->poi_additional_charges);
		    if(!empty($poi_additional_charges['dropoff']))
		    {
	    ?>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo $poi_additional_charges['dropoff']['fld_label'];?>:</div>
		    <div class="admin_list_item_two"><?php echo booking_helper::price_display($poi_additional_charges['dropoff']['charge'], $this->elsettings);?></div>
	    </div>
	    <?php
		    }
	    }
	    ?>

	    <?php
	    if($this->item->extras != '')
	    {
		$extras = unserialize($this->item->extras);
		if(!empty($extras['dropoff']))
		{
			$counter = 0;
			foreach($extras['dropoff'] as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			?>
			<div class="admin_list_item clearfix">
				<div class="admin_list_item_one"><?php echo $extra['name'];?>:</div>
				<div class="admin_list_item_two">
					<?php echo $extra['value'];?>
					<?php if($extra['price']>0){
					    echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
					}?>
				</div>
			</div>
			<?php
			$counter++;
			}
		}
	    }
	    ?>


	    <?php
	    if($this->item->booking_type=='hourly')
	    {
		if($this->item->extras != '')
		{
		    $extras = unserialize($this->item->extras);
		    if(!empty($extras['hourly_hire']))
		    {
			    $counter = 0;
			    foreach($extras['hourly_hire'] as $extra)
			    {
				    $addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			    ?>
			    <div class="admin_list_item clearfix">
				    <div class="admin_list_item_one"><?php echo $extra['name'];?>:</div>
				    <div class="admin_list_item_two">
					    <?php echo $extra['value'];?>
					    <?php if($extra['price']>0){
						echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
					    }?>
				    </div>
			    </div>
			    <?php
			    $counter++;
			    }
		    }
		}
	    }
	    ?>

	    <?php if($this->item->booking_type!='hourly' && $this->item->PickupAddr4!=""){ ?>
	    <div class="admin_list_item clearfix">
		<div class="admin_list_item_one"><?php echo JText::_('STREET'); ?>:</div>
		<div class="admin_list_item_two"><?php echo $this->item->PickupAddr4; ?></div>
	    </div>
	    <?php } ?>

	    <?php
	    if($this->item->extras != '')
	    {
		$extras = unserialize($this->item->extras);
		if(!empty($extras['user_details']))
		{
			$counter = 0;
			foreach($extras['user_details'] as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			?>
			<div class="admin_list_item clearfix">
				<div class="admin_list_item_one"><?php echo $extra['name'];?>:</div>
				<div class="admin_list_item_two">
					<?php echo $extra['value'];?>
					<?php if($extra['price']>0){
					    echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
					}?>
				</div>
			</div>
			<?php
			$counter++;
			}
		}
	    }
	    ?>

	    <?php if($this->item->booking_type!='hourly'){ ?>
	    <div class="admin_list_item clearfix">
					<div class="admin_list_item_one"><?php echo JText::_('RETURN_TRIP'); ?>:</div>
					<div class="admin_list_item_two"><?php echo ($this->item->returntrip ? 'YES' : 'NO'); ?></div>
				</div>
	    <?php } ?>

	    <?php if ($this->item->returntrip) { ?>
		<div class="admin_list_item clearfix">
		    <?php
		    if($this->item->return_wait_hr==-1 && $this->item->datetime2!=""){
		    ?>
		    <div class="admin_list_item_one"><?php echo JText::_('DATE_RETURN_TRIP'); ?>:</div>
		    <div class="admin_list_item_two">
			<?php echo booking_helper::get_order_return_date($this->item, $this->elsettings); ?>
		    <?php
		    }
		    else {
		    ?>
		    <div class="admin_list_item_one"><?php echo JText::_('RETURN_TRIP_WAIT_TIME'); ?>:</div>
		    <div class="admin_list_item_two">
		    <?php
			echo JText::sprintf('NEW_ORDER_EMAIL_RETURN_WAIT_TIME', $this->item->return_wait_hr, $this->item->return_wait_discount.'%');
		    }
		    ?>
		    </div>
		</div>

		<?php
		if($this->item->extras != '')
		{
		    $extras = unserialize($this->item->extras);
		    if(!empty($extras['return_pickup']))
		    {
			$counter = 0;
			foreach($extras['return_pickup'] as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			?>
			<div class="admin_list_item clearfix">
				<div class="admin_list_item_one"><?php echo $extra['name'];?>:</div>
				<div class="admin_list_item_two">
					<?php echo $extra['value'];?>
					<?php if($extra['price']>0){
					    echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
					}?>
				</div>
			</div>
			<?php
			$counter++;
			}
		    }
		    if(!empty($extras['return_dropoff']))
		    {
			$counter = 0;
			foreach($extras['return_dropoff'] as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			?>
			<div class="admin_list_item clearfix">
				<div class="admin_list_item_one"><?php echo $extra['name'];?>:</div>
				<div class="admin_list_item_two">
					<?php echo $extra['value'];?>
					<?php if($extra['price']>0){
					    echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
					}?>
				</div>
			</div>
			<?php
			$counter++;
			}
		    }
		}
		?>

	    <?php } ?>

	    <?php if($this->item->message!=""){ ?>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('TBMESSAGE');?>:</div>
		    <div class="admin_list_item_two"><?php echo $this->item->message; ?></div>
	    </div>
	    <?php } ?>

	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('SUB_TOTAL');?>:</div>
		    <div class="admin_list_item_two"><?php echo booking_helper::price_display($this->item->sub_total, $this->elsettings);?></div>
	    </div>

	    <?php if($this->item->flat_cost>0){ ?>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('FLAT_COST');?>:</div>
		    <div class="admin_list_item_two"><?php echo booking_helper::price_display($this->item->flat_cost, $this->elsettings);?></div>
	    </div>
	    <?php } ?>

	    <?php if($this->item->percentage_cost>0){ ?>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('PERCENTAGE_COST');?>:</div>
		    <div class="admin_list_item_two"><?php echo booking_helper::price_display($this->item->percentage_cost, $this->elsettings);?></div>
	    </div>
	    <?php } ?>

	    <?php
	    if($this->item->coupon_used > 0) {
		    $coupon = booking_helper::coupon_details($this->item->coupon_used);
		    if($coupon->discount_type=='fixed'){
			$discount_type = booking_helper::price_display($coupon->discount_value, $this->elsettings).' '.JText::_('COUPON_CODE_DISCOUNT_TYPE_OPTION_FIXED');
		    }
		    else {
			$discount_type = $coupon->discount_value.'% '.JText::_('COUPON_CODE_DISCOUNT_TYPE_OPTION_PERCENT');
		    }
	    ?>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('COUPON_CODE');?>:</div>
		    <div class="admin_list_item_two"><?php echo $coupon->code.' ('.$discount_type.')';?></div>
	    </div>
	    <?php } ?>

	    <?php
	    if($this->item->gratuity_amt > 0) {
		$gratuity_price = booking_helper::price_display($this->item->gratuity_amt, $this->elsettings);
		if($this->item->gratuity_amttype=='percent'){
		    $gratuity_price .= ' (' .$this->item->gratuity_percent_value.'%)';
		}
	    ?>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('BOOKING_FORM_GRATUITY_LABEL');?>:</div>
		    <div class="admin_list_item_two"><?php echo $gratuity_price;?></div>
	    </div>
	    <?php } ?>

	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('GRAND_TOTAL');?>:</div>
		    <div class="admin_list_item_two"><?php echo booking_helper::price_display($this->item->cprice, $this->elsettings);?></div>
	    </div>

	    <?php if($this->item->custom_payment!=''){ ?>
	    <div class="admin_list_item clearfix">
		    <div class="admin_list_item_one"><?php echo JText::_('PAYMENT');?>:</div>
		    <div class="admin_list_item_two"><?php echo booking_helper::get_order_payment($this->item);?></div>
	    </div>
	    <?php } ?>

	<?php echo $this->payment_data;?>
         <div class="admin_list_item clearfix">
 		    <div class="admin_list_item_one">Operator:</div>
 		    <div class="admin_list_item_two"><?php echo booking_helper::get_order_operator($this->item);?></div>
 	    </div>
    </div>

</div>

	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'panel_2', JText::_('ORDER_DETAILS_CUSTOMER_NOTES_HEADER')); ?>
	    <?php } else { ?>

		    <?php echo JHtml::_('tabs.panel', JText::_('ORDER_DETAILS_CUSTOMER_NOTES_HEADER'), 'panel_2'); ?>
	    <?php } ?>

    <div class="adminform tab2">

            <div valign="top" class="adminlist_right">
		<div class="note">
		    <div id="admin_note_div" style="height:150px;min-height:100px;overflow-y: auto;width:96%; border: 1px solid #9e9e9e; padding:10px;">
			<?php
			if(!empty($this->order_notes))
			{
			    foreach($this->order_notes as $order_note)
			    {
				$user_details = JFactory::getUser($order_note->created_by);
			?>
			<div class="comment" style="margin-bottom:30px;">
			    <div class="maincomment" style="background-color:#EEE;"><?php echo changeEditorImageUrl($order_note->text); ?></div>
			    <div class="comment_user" style="float:right;">
				<?php
				echo '<b>'.$user_details->name.'</b> on '.$order_note->created_date;
				?>
			    </div>
			</div>
			<?php
			    }
			}
			?>
		    </div>
		</div>
		<div class="editor" style="margin-top: 25px;">
		    <div class="notes_area">
		    <?php
		    // parameters : areaname, content, hidden field, width, height, rows, cols
		    echo $this->editor->display( 'admin_notes',  '', '100%;', '100', '25', '20', array('article', 'image', 'pagebreak', 'readmore') ) ;
		    ?>
		    </div>
		</div>
		<div class="">
		    <a href="javascript:void(0);" class="send_notes btn"><?php echo JText::_('ORDER_EDIT_SEND_NOTES_BUTTON'); ?></a>
		</div>
            </div>
    </div>
</div>


<?php echo JHTML::_('form.token'); ?>
    <input type="hidden" name="option" value="com_taxibooking" />
    <input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
    <input type="hidden" name="cid[]" value="<?php echo $this->item->id; ?>" />
    <input type="hidden" name="controller" value="orders" />
    <input type="hidden" name="view" value="order" />
    <input type="hidden" name="task" value="" />
</form>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>
