<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

// Load the modal behavior script.
JHtml::_('behavior.modal', 'a.modal_custom_field');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');

$max_stop_time = $this->elsettings->max_stop_time;
$stop_duration_interval = $this->elsettings->stop_duration_interval;

?>
<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o&v=3.exp&libraries=places"></script>

<?php if(version_compare(JVERSION,'3.1.5','le')) {?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<?php } ?>

<script type="text/javascript">
var xhr = null;
var tbjQuery = jQuery.noConflict();
var BASE_URL = '<?php echo JURI::root();?>';
var page_mode = '<?php echo ($this->item->id > 0) ? 'edit' : 'add' ?>';
var car_type = '<?php echo ($this->item->custom_car=="") ? 'system' : 'custom' ?>';
var loader = '<img id="loading" src="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/images/ajax-loader.gif" alt="Loading.." />';
var show_return_extras = '<?php echo $this->elsettings->show_return_extras;?>';
var booking_type = '<?php echo $this->item->booking_type;?>';

if(booking_type=='shuttle'){
    var selected_shuttle_dropoff_poi = <?php echo (int)$this->item->dropoff_poi;?>;
    var selected_shuttle_pickup_time = '<?php echo $this->pickup_hr.':'.$this->pickup_min.':00';?>';
    var selected_shuttle_passengers = '<?php echo (int)$this->item->selpassengers;?>';
}

function reloadShuttleDropoff()
{
    tbjQuery.ajax({
	type: "POST"
	, url: 'index.php?option=com_taxibooking&controller=searchurls&task=getShuttleTimeOptions'
	, data: tbjQuery('#shuttle_pickup_date').serialize()+'&shuttle_pickup_poi='+tbjQuery('#shuttle_pickup_poi').val()+'&shuttle_dropoff_poi='+tbjQuery('#shuttle_dropoff_poi').val()+'&shuttle_pickup_time='+selected_shuttle_pickup_time
	, dataType: 'json'
	, async: false
	, beforeSend: function(){
	    tbjQuery('#shuttle_pickup_date').after(loader);
	}
	, complete: function(){
	}
	, success: function(response){
	    tbjQuery('#shuttle_pickup_date').next('#loading').remove();
	    if(response.error==0)
	    {
		tbjQuery('div#shuttle_time_wrapper').html(response.msg);

		    var available_seats = tbjQuery('input:radio[name="shuttletime"]:checked').parent().data('seats');
		    var passenger_list = tbjQuery('<select class="shuttle-passengers-list" name="shuttle_passengers">');
		    passenger_list.append(jQuery("<option>").attr({value: 0}).text('<?php echo JText::_('JSELECT');?>'));
		    for(var i = 1; i <= parseInt(available_seats); i++){
			var selected = (i==selected_shuttle_passengers) ? true : false;
			passenger_list.append(jQuery("<option>").attr({value: i, selected: selected}).text(i));
		    }
		    tbjQuery('div#shuttle_passengers_wrap').html(passenger_list);

		    var shuttle_route_id=tbjQuery('input:radio[name="shuttletime"]:checked').parent('div.shuttletime_wrap').data('routeid');
		    tbjQuery('#shuttle_route_id').val(shuttle_route_id);
	    }
	}
    })
}

tbjQuery(document).ready(function(){
    tbjQuery.fn.getAvailableCars = function(scrolltocars,setcarprice) {
	if( xhr != null ) {
		xhr.abort();
		xhr = null;
	}
	if (typeof scrolltocars == 'undefined') {
	    scrolltocars = true;
	}
	if (typeof setcarprice == 'undefined') {
	    setcarprice = true;
	}

	// don't scroll to cars on first load
	if(scrolltocars){
	    tbjQuery('html, body').animate({ scrollTop: tbjQuery('div#custom_fields_wrap').offset().top-200 }, 'fast');
	}

	tbjQuery('input[name="task"]').val('getAvailableCarsAjax');
	var passingData = tbjQuery('#adminForm').serialize();
	xhr = tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&task=getAvailableCarsAjax'
	    , data: passingData
	    , dataType: 'json'
	    //, async: false
	    , beforeSend: function(){
		tbjQuery('div#available_cars_wrap').html("");
		tbjQuery('#available_cars_loader').show();
		tbjQuery('input[name="custom_car"]').val("");
		tbjQuery('input[name="price_override"]').val("");
	    }
	    , complete: function(){

	    }
	    , success: function(response){
		tbjQuery('#available_cars_loader').hide();
		tbjQuery('div#available_cars_wrap').show();
		if(setcarprice){
		    tbjQuery('input[name="price"]').val(response.selected_car_price);
		}

		if(response.error==0)
		{
		    tbjQuery('input#selected_car_id').val(0);
		    tbjQuery('div#available_cars_wrap').html(response.msg);
		}
		else {
		    tbjQuery('div#available_cars_wrap').html('<span id="available_cars_error" style="color:red;font-size:15px;">'+response.msg+'</span>');
		}
	    }
	})
    }
    // collect extra list
    tbjQuery.fn.getExtras = function(type, poiid) {
	if (typeof poiid == 'undefined') {
	    poiid = 0;
	}
        var passingData = 'scope=orderedit&type='+type+'&poiid='+poiid;

	if(page_mode=='edit'){
	    passingData += '&id=<?php echo $this->item->id;?>';
	}
        tbjQuery.ajax({
	    type: "POST",
	    url: 'index.php?option=com_taxibooking&controller=searchurls&task=getExtraListAjax',
	    data: passingData,
	    dataType: 'json',
	    async: false,
	    beforeSend: function(){
		// load the ajax loading image
		if(type=='pickup' || type=='address_pickup'){
		    tbjQuery('div#pickup_extra_wrapper').html(loader);
		}
		else if(type=='dropoff' || type=='address_dropoff'){
		    tbjQuery('div#dropoff_extra_wrapper').html(loader);
		}
		else if(type=='route_pickup'){
		    tbjQuery('div#routefrom_extra_wrapper').html(loader);
		}
		else if(type=='route_dropoff'){
		    tbjQuery('div#routeto_extra_wrapper').html(loader);
		}
		else if(type=='hourly_hire'){
		    tbjQuery('div#hourly_extra_wrapper').html(loader);
		}
		else if(type=='user_details'){
		    tbjQuery('div#user_details_extra_wrapper').html(loader);
		}
	    },
	    complete: function(){
	    },
	    success: function(response){
		// clear out the ajax loading image
		tbjQuery('#loading').remove();
		if(response.error==0)
		{
		    if(type=='pickup' || type=='address_pickup'){
			tbjQuery('div#pickup_extra_wrapper').html(response.msg);
		    }
		    else if(type=='dropoff' || type=='address_dropoff'){
			tbjQuery('div#dropoff_extra_wrapper').html(response.msg);
		    }
		    else if(type=='route_pickup'){
			tbjQuery('div#routefrom_extra_wrapper').html(response.msg);
		    }
		    else if(type=='route_dropoff'){
			tbjQuery('div#routeto_extra_wrapper').html(response.msg);
		    }
		    else if(type=='hourly_hire'){
			tbjQuery('div#hourly_extra_wrapper').html(response.msg);
		    }
		    else if(type=='user_details'){
			tbjQuery('div#user_details_extra_wrapper').html(response.msg);
		    }
		}
	    }
        });
    }

    tbjQuery('div.inputWrap.address_feature,div.inputWrap.offers_feature,div.inputWrap.hourly_feature,div.inputWrap.shuttle_feature').hide();
    tbjQuery('div.inputWrap.'+booking_type+'_feature').show();
    if(booking_type=='shuttle'){
	tbjQuery('#selpassengers,#selluggage,#selinfantseats,#selchildseats,#selboosterseats').val(0);
	tbjQuery('div.inputWrap.nonshuttle_feature,div.inputWrap.return_feature,div.inputWrap.nonshuttle_date').hide();
	tbjQuery('div.inputWrap.shuttle_date').show();
    }
    else {
	if(booking_type=='hourly'){
	    tbjQuery('div.inputWrap.return_feature').hide();
	}
	else {
	    tbjQuery('div.inputWrap.return_feature').show();
	    if(parseInt(tbjQuery('input[name="returntrip"]:checked').val())==0){
		tbjQuery('div.inputWrap#returnWrap').hide();
	    }
	    else {
		tbjQuery('div.inputWrap#returnWrap').show();
		// if show return extras is set to YES
		if(show_return_extras==1)
		{
		    var passingData = 'scope=orderedit&booking_type='+booking_type;
		    if(booking_type=='address'){
			passingData += '&pickup_type='+tbjQuery('#pickup_type').val()+'&pickup_poi='+tbjQuery('#pickup_poi').val()+'&pickup_address='+tbjQuery('#pickup_address').val();
			passingData += '&dropoff_type='+tbjQuery('#dropoff_type').val()+'&dropoff_poi='+tbjQuery('#dropoff_poi').val()+'&dropoff_address='+tbjQuery('#dropoff_address').val();
		    }
		    else if(booking_type=='offers'){
			var route_pickup_poi = tbjQuery('#route_id').find(':selected').data('pickup');
			var route_dropoff_poi = tbjQuery('#route_id').find(':selected').data('dropoff');
			passingData += '&route_from='+route_pickup_poi+'&route_to='+route_dropoff_poi;
		    }
		    if(page_mode=='edit'){
			passingData += '&id=<?php echo $this->item->id;?>';
		    }
		    tbjQuery.ajax({
			type: "POST",
			url: 'index.php?option=com_taxibooking&controller=searchurls&task=getReturnExtraListAjax',
			data: passingData,
			dataType: 'json',
			async: false,
			beforeSend: function(){
			    tbjQuery('div#return_extra_wrapper').html(loader);
			},
			complete: function(){
			},
			success: function(response){
			    tbjQuery('#loading').remove();
			    if(response.error==0)
			    {
				tbjQuery('div#return_extra_wrapper').html(response.msg);
			    }
			}
		    });
		}
	    }
	}
	tbjQuery('div.inputWrap.nonshuttle_feature').show();
	tbjQuery('div.inputWrap.shuttle_date').hide();
	tbjQuery('div.inputWrap.nonshuttle_date').show();
    }

    if(booking_type=='address'){
	if(tbjQuery('#pickup_type').val()=='poi'){
	    tbjQuery('#pickup_poi').closest('div.inputWrap').show();
	    tbjQuery('#pickup_address').closest('div.inputWrap').hide();
	}
	else {
	    tbjQuery('#pickup_poi').closest('div.inputWrap').hide();
	    tbjQuery('#pickup_address').closest('div.inputWrap').show();
	}
	if(tbjQuery('#dropoff_type').val()=='poi'){
	    tbjQuery('#dropoff_poi').closest('div.inputWrap').show();
	    tbjQuery('#dropoff_address').closest('div.inputWrap').hide();
	}
	else {
	    tbjQuery('#dropoff_poi').closest('div.inputWrap').hide();
	    tbjQuery('#dropoff_address').closest('div.inputWrap').show();
	}
    }
    // show custom fields on edit more
    if(page_mode=='edit'){
	if(booking_type=='address'){
	    if(tbjQuery('#pickup_type').val()=='poi' && parseInt(tbjQuery('#pickup_poi').val()) > 0){
		//tbjQuery.fn.getExtras('pickup', tbjQuery('#pickup_poi').val());
	    }
	    else if(tbjQuery('#pickup_type').val()=='address' && tbjQuery('#pickup_address').val()!="") {
		//tbjQuery.fn.getExtras('address_pickup');
	    }
	    if(tbjQuery('#dropoff_type').val()=='poi' && parseInt(tbjQuery('#dropoff_poi').val()) > 0){
		//tbjQuery.fn.getExtras('dropoff', tbjQuery('#dropoff_poi').val());
	    }
	    else if(tbjQuery('#dropoff_type').val()=='address' && tbjQuery('#dropoff_address').val()!="") {
		//tbjQuery.fn.getExtras('address_dropoff');
	    }
	}
	else if(booking_type=='offers'){
	    var route_pickup_poi = tbjQuery('#route_id').find(':selected').data('pickup');
	    var route_dropoff_poi = tbjQuery('#route_id').find(':selected').data('dropoff');
	    //tbjQuery.fn.getExtras('route_pickup', route_pickup_poi);
	    //tbjQuery.fn.getExtras('route_dropoff', route_dropoff_poi);
	}
	else if(booking_type=='hourly'){
	    if(parseInt(tbjQuery('#hourly_hr').val()) > 0 || parseInt(tbjQuery('#hourly_min').val()) > 0){
		//tbjQuery.fn.getExtras('hourly_hire');
	    }
	}
    }



	//tbjQuery('div.inputWrap.address_feature,div.inputWrap.offers_feature,div.inputWrap.hourly_feature,div.inputWrap.shuttle_feature').find('input').val("");
	//tbjQuery('div.inputWrap.address_feature,div.inputWrap.offers_feature,div.inputWrap.hourly_feature,div.inputWrap.shuttle_feature').find('select').val(0);
	tbjQuery('div.inputWrap.address_feature,div.inputWrap.offers_feature,div.inputWrap.hourly_feature,div.inputWrap.shuttle_feature').hide();
	tbjQuery('div.inputWrap.'+booking_type+'_feature').show();

    tbjQuery('.schoolweek').hide();
    tbjQuery('.schoolweek_return').hide();
  tbjQuery('#booking_type').change(function(){
var booking_type = tbjQuery(this).val();

if(booking_type=='schooldays') {
  tbjQuery('div.inputWrap.address_feature,div.inputWrap.offers_feature,div.inputWrap.hourly_feature,div.inputWrap.shuttle_feature').show();
  tbjQuery('.schoolweek').show();
  // tbjQuery('.schoolweek_return').show();
}

    if(booking_type=='schooldays') {
        if(parseInt(tbjQuery('input[name="returntrip"]:checked').val())==0) {
            // tbjQuery('.schoolweek_return').show();
        }
    }

	if(booking_type=='shuttle'){
	    tbjQuery('#selpassengers,#selluggage,#selinfantseats,#selchildseats,#selboosterseats').val(0);
	    tbjQuery('div.inputWrap.nonshuttle_feature,div.inputWrap.return_feature,div.inputWrap.nonshuttle_date').hide();
	    tbjQuery('div.inputWrap.shuttle_date').show();
	}
	else {
	    if(booking_type=='hourly'){
		tbjQuery('div.inputWrap.return_feature').hide();
	    }
	    else {
		tbjQuery('div.inputWrap.return_feature').show();
		if(parseInt(tbjQuery('input[name="returntrip"]:checked').val())==0){
		    tbjQuery('div.inputWrap#returnWrap').hide();
		}
		else {
		    tbjQuery('div.inputWrap#returnWrap').show();
		}
	    }

	    if(booking_type=='address'){
		if(tbjQuery('#pickup_type').val()=='poi'){
		    tbjQuery('#pickup_poi').closest('div.inputWrap').show();
		    tbjQuery('#pickup_address,#pickup_lat,#pickup_lng').val('');
		    tbjQuery('#pickup_address').closest('div.inputWrap').hide();
		}
		else {
		    tbjQuery('#pickup_poi').val(0);
		    tbjQuery('#pickup_poi').closest('div.inputWrap').hide();
		    tbjQuery('#pickup_address').closest('div.inputWrap').show();
		}
		if(tbjQuery('#dropoff_type').val()=='poi'){
		    tbjQuery('#dropoff_poi').closest('div.inputWrap').show();
		    tbjQuery('#dropoff_address,#dropoff_lat,#dropoff_lng').val('');
		    tbjQuery('#dropoff_address').closest('div.inputWrap').hide();
		}
		else {
		    tbjQuery('#dropoff_poi').val(0);
		    tbjQuery('#dropoff_poi').closest('div.inputWrap').hide();
		    tbjQuery('#dropoff_address').closest('div.inputWrap').show();
		}
	    }
	    tbjQuery('div.inputWrap.nonshuttle_feature,div.inputWrap.nonshuttle_date').show();
	    tbjQuery('div.inputWrap.shuttle_date').hide();
	    tbjQuery('#shuttle_pickup_date').val('');
	    tbjQuery('div#shuttle_time_wrap').html('');
	}

	// clears out all extras
	tbjQuery('div#pickup_extra_wrapper,div#dropoff_extra_wrapper,div#routefrom_extra_wrapper,div#routeto_extra_wrapper,div#hourly_extra_wrapper').html("");
    })

    tbjQuery('#pickup_type').change(function(){
	if(tbjQuery(this).val()=='poi'){
	    tbjQuery('#pickup_poi').closest('div.inputWrap').show();
	    tbjQuery('#pickup_address').closest('div.inputWrap').hide();
	}
	else {
	    tbjQuery('#pickup_poi').closest('div.inputWrap').hide();
	    tbjQuery('#pickup_address').closest('div.inputWrap').show();
	}
	tbjQuery('div#pickup_extra_wrapper').html("");
    })
    tbjQuery('#dropoff_type').change(function(){
	if(tbjQuery(this).val()=='poi'){
	    tbjQuery('#dropoff_poi').closest('div.inputWrap').show();
	    tbjQuery('#dropoff_address').closest('div.inputWrap').hide();
	}
	else {
	    tbjQuery('#dropoff_poi').closest('div.inputWrap').hide();
	    tbjQuery('#dropoff_address').closest('div.inputWrap').show();
	}
	tbjQuery('div#dropoff_extra_wrapper').html("");
    })
    tbjQuery('#pickup_poi').change(function(){
	tbjQuery.fn.getExtras('pickup', tbjQuery(this).val());
    })
    tbjQuery('#dropoff_poi').change(function(){
	tbjQuery.fn.getExtras('dropoff', tbjQuery(this).val());
    })

    tbjQuery(document).on("change", '#route_id', function (e) {
	var route_pickup_poi = tbjQuery(this).find(':selected').data('pickup');
	var route_dropoff_poi = tbjQuery(this).find(':selected').data('dropoff');
	tbjQuery.fn.getExtras('route_pickup', route_pickup_poi);
	tbjQuery.fn.getExtras('route_dropoff', route_dropoff_poi);
    })
    tbjQuery("#hourly_hr, #hourly_min").change(function(){
	tbjQuery.fn.getExtras('hourly_hire');
    })
    tbjQuery.fn.getShuttleDropoffPOIs = function() {
	tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&controller=searchurls&task=getShuttleDropoffPOIs'
	    , data: tbjQuery('#shuttle_pickup_poi').serialize()+'&shuttle_dropoff_poi='+selected_shuttle_dropoff_poi
	    , dataType: 'json'
	    , async: false
	    , beforeSend: function(){
		tbjQuery('#shuttle_pickup_poi').after(loader);
	    }
	    , complete: function(){
	    }
	    , success: function(response){
		tbjQuery('#shuttle_pickup_poi').next('#loading').remove();
		if(response.error==0)
		{
		    tbjQuery('div#shuttle_dropoff_poi_wrap').html(response.msg);
		}
	    }
	})
    }
    tbjQuery('#shuttle_pickup_poi').change(function(){
	tbjQuery.fn.getShuttleDropoffPOIs();
    })
    if(booking_type=='shuttle'){
	tbjQuery.fn.getShuttleDropoffPOIs();
	reloadShuttleDropoff();
    }
    tbjQuery(document).on("change", 'input[name="shuttletime"]', function (e) {
	var shuttle_route_id=tbjQuery('input[name="shuttletime"]:checked').parent('div.shuttletime_wrap').data('routeid');
	tbjQuery('#shuttle_route_id').val(shuttle_route_id);
    })
    tbjQuery('input[name="returntrip"]').click(function(){
	var returntrip = tbjQuery(this).val();

	if(returntrip==1){
        if(tbjQuery('#booking_type').val()!='schooldays') {
            tbjQuery('div.inputWrap#returnWrap').show();
            tbjQuery('.schoolweek_return').hide();
        }
        if(tbjQuery('#booking_type').val()=='schooldays') {
            tbjQuery('.schoolweek_return').show();
            tbjQuery('div.inputWrap#returnWrap').hide();
        }

	    // if show return extras is set to YES
	    if(show_return_extras==1)
	    {
		var passingData = 'scope=orderedit&booking_type='+booking_type;
		if(booking_type=='address'){
		    passingData += '&pickup_type='+tbjQuery('#pickup_type').val()+'&pickup_poi='+tbjQuery('#pickup_poi').val()+'&pickup_address='+tbjQuery('#pickup_address').val();
		    passingData += '&dropoff_type='+tbjQuery('#dropoff_type').val()+'&dropoff_poi='+tbjQuery('#dropoff_poi').val()+'&dropoff_address='+tbjQuery('#dropoff_address').val();
		}
		else if(booking_type=='offers'){
		    var route_pickup_poi = tbjQuery('#route_id').find(':selected').data('pickup');
		    var route_dropoff_poi = tbjQuery('#route_id').find(':selected').data('dropoff');
		    passingData += '&route_from='+route_pickup_poi+'&route_to='+route_dropoff_poi;
		}
		if(page_mode=='edit'){
		    passingData += '&id=<?php echo $this->item->id;?>';
		}
		tbjQuery.ajax({
		    type: "POST",
		    url: BASE_URL+'index.php?option=com_taxibooking&controller=searchurls&task=getReturnExtraListAjax',
		    data: passingData,
		    dataType: 'json',
		    async: false,
		    beforeSend: function(){
			tbjQuery('div#return_extra_wrapper').html(loader);
		    },
		    complete: function(){
		    },
		    success: function(response){
			tbjQuery('#loading').remove();
			if(response.error==0)
			{
			    tbjQuery('div#return_extra_wrapper').html(response.msg);
			}
		    }
		});
	    }
	}
	else {
	    tbjQuery('div#return_extra_wrapper').html("");
	    tbjQuery('div.inputWrap#returnWrap').hide();
	}
    })
    tbjQuery(document).on("click", 'input:radio[name="shuttletime"]', function (e) {
	var available_seats = tbjQuery('input:radio[name="shuttletime"]:checked').parent().data('seats');

	var passenger_list = tbjQuery('<select class="shuttle-passengers-list" name="shuttle_passengers">');
	passenger_list.append(jQuery("<option>").attr({value: 0}).text('<?php echo JText::_('JSELECT');?>'));
	for(var i = 1; i <= parseInt(available_seats); i++){
	    passenger_list.append(jQuery("<option>").attr({value: i}).text(i));
	}
	tbjQuery('div#shuttle_passengers_wrap').html(passenger_list);
    })

    // bind google map autocomplete to waypoints
    var stops_counter = tbjQuery('div#stops_wrapper').children('div.admin_list_item_two').length;
    if(stops_counter>0){
	for(var i = 0; i < stops_counter; i++){
	    var waypoint_field = document.getElementById('waypoint_'+i);
	    var waypoint_autocomplete = new google.maps.places.Autocomplete(waypoint_field, options);
	    google.maps.event.addListener(waypoint_autocomplete, 'place_changed', function() {
		var place = waypoint_autocomplete.getPlace();
		if (place.geometry) {
		    tbjQuery(waypoint_field).siblings('#waypoint_lat').val(place.geometry.location.lat());
		    tbjQuery(waypoint_field).siblings('#waypoint_lng').val(place.geometry.location.lng());
		}
	    });
	}
    }
    tbjQuery('a.addstop').click(function(){

	var stops_counter = tbjQuery('div#stops_wrapper').children('div.admin_list_item_two').length;
	if(stops_counter > 7){
	    alert("<?php echo JText::_('ORDER_EDIT_MAXIMUM_NUMBER_STOPS');?>");
	    return false;
	}

	var html = '<div class="admin_list_item_two">'+
			'<input type="text" class="inputbox waypoints" name="waypoints['+stops_counter+']" id="waypoint_'+stops_counter+'" value="" placeholder="<?php echo JText::_('ORDER_EDIT_ENTER_ADDRESS'); ?>" />'+
			'<select name="waypoints_stop_duration['+stops_counter+']" class="stop_interval_options">'+
			    '<option value="0"><?php echo JText::_('ORDER_EDIT_TIME_AT_STOP'); ?></option>'+
			    '<?php for($i = $stop_duration_interval; $i <= ($max_stop_time*60); $i = $i + $stop_duration_interval){?>'+
			    '<option value="<?php echo $i;?>"><?php echo $i;?> mins</option>'+
			    '<?php } ?>'+
			'</select>'+
			'<a href="javascript:void(0);" class="remove_stop btn"><?php echo JHtml::_('image', 'admin/trash.png', '', null, true);?></a>'+
			'<input type="hidden" name="waypoints_lat['+stops_counter+']" id="waypoint_lat" value="" />'+
			'<input type="hidden" name="waypoints_lng['+stops_counter+']" id="waypoint_lng" value="" />'+
		    '</div>';

	tbjQuery('#stops_wrapper').append(html);

	var waypoint_field = document.getElementById('waypoint_'+stops_counter);
	var waypoint_autocomplete = new google.maps.places.Autocomplete(waypoint_field, options);
	google.maps.event.addListener(waypoint_autocomplete, 'place_changed', function() {
	    var place = waypoint_autocomplete.getPlace();
	    if (place.geometry) {
		tbjQuery(waypoint_field).siblings('#waypoint_lat').val(place.geometry.location.lat());
		tbjQuery(waypoint_field).siblings('#waypoint_lng').val(place.geometry.location.lng());

		// change in value should trigger updated car list for edit order only
		if(tbjQuery('div#available_cars_wrap').is(":visible")){
		    tbjQuery.fn.getAvailableCars();
		}
		tbjQuery('#changed').val(1);
	    }
	});
    })
    tbjQuery(document).on("click", '.remove_stop', function (e) {
	var r = confirm("Are you sure?");
	if (r == true) {
	    tbjQuery(this).closest('div.admin_list_item_two').remove();
	    // change in value should trigger updated car list for edit order only
	    if(tbjQuery('div#available_cars_wrap').is(":visible")){
		tbjQuery.fn.getAvailableCars();
	    }
	    tbjQuery('#changed').val(1);
	}
    })
    tbjQuery(document).on("click", '.remove_custom_field', function (e) {
	var r = confirm("Are you sure?");
	if (r == true) {
	    tbjQuery(this).closest('div.admin_list_item').remove();
	    // change in value should trigger updated car list for edit order only
	    if(tbjQuery('div#available_cars_wrap').is(":visible")){
		tbjQuery.fn.getAvailableCars();
	    }
	    tbjQuery('#changed').val(1);
	}
    })

    tbjQuery('a.get_cars').click(function(){
	tbjQuery.fn.getAvailableCars();
    })
    // if this is edit order, show previously selected car with list of all cars available
    if(page_mode=='edit' && car_type=='system'){
	tbjQuery.fn.getAvailableCars(false,false);
    }
    tbjQuery(document).on("click", '.assign_car', function (e) {
	var car_price = tbjQuery(this).closest('.car_row').data('price');
	tbjQuery('[name="price"]').val(car_price);
	tbjQuery('#changed').val(1);
    })
    tbjQuery('input[name="returntrip"]').click(function(){
	if(tbjQuery(this).val()==1){
	    tbjQuery('#return_date').closest('div.admin_list_item').show();
	}
	else {
	    tbjQuery('#return_date').closest('div.admin_list_item').find('input, select').val('');
	    tbjQuery('#return_date').closest('div.admin_list_item').hide();

	    // change in value should trigger updated car list for edit order only
	    if(tbjQuery('div#available_cars_wrap').is(":visible")){
		tbjQuery.fn.getAvailableCars();
	    }
	}
	tbjQuery('#changed').val(1);
    })
    tbjQuery(document).on("change", 'select:not(#driver_id,#state)', function (e) {
	if(tbjQuery('div#available_cars_wrap').is(":visible")){
	    tbjQuery.fn.getAvailableCars();
	}
    })
    tbjQuery(document).on("change", 'input,select', function (e) {
	tbjQuery('#changed').val(1);
    })
    // if custom car is added, hide the system cars and reset price to zero
    tbjQuery('input[name="custom_car"]').change(function(){
	tbjQuery('input#selected_car_id').val(0);
	tbjQuery('div#available_cars_wrap').html("").hide();
	tbjQuery('[name="price"]').val(0);
	tbjQuery('#changed').val(1);
    })
    tbjQuery('input#user_id').change(function(){
	tbjQuery('input#user_name').val(tbjQuery('input#user_id').val());
    })
    tbjQuery('a.cancel_payment').click(function(){
	var r = confirm("Are you sure? This cannot be undone.");
	if (r == true) {
	    if( xhr != null ) {
		xhr.abort();
		xhr = null;
	    }
	    tbjQuery('input[name="task"]').val('cancelFrontPaymentAjax');
	    var passingData = tbjQuery('#adminForm').serialize();
	    xhr = tbjQuery.ajax({
		type: "POST"
		, url: 'index.php?option=com_taxibooking&task=cancelFrontPaymentAjax'
		, data: passingData
		, dataType: 'json'
		, async: false
		, beforeSend: function(){
		}
		, complete: function(){
		}
		, success: function(response){
		    if(response.error==0){
			tbjQuery('input#payment_name').val("");
			tbjQuery('input#frontend_payment').val(0);
			tbjQuery('a.cancel_payment').hide();
		    }
		    else {
			alert(response.msg);
			return false;
		    }
		}
	    })
	}
    })
})

function selectCustomField(field_id){
    if( xhr != null ) {
	xhr.abort();
	xhr = null;
    }
    tbjQuery('input[name="task"]').val('getCustomFieldHtmlAjax');
    var passingData = tbjQuery('#adminForm').serialize()+'&field_id='+field_id;

    xhr = tbjQuery.ajax({
	type: "POST"
	, url: 'index.php?option=com_taxibooking&task=getCustomFieldHtmlAjax'
	, data: passingData
	, dataType: 'json'
	, async: false
	, beforeSend: function(){
	}
	, complete: function(){

	}
	, success: function(response){
	    SqueezeBox.close();
	    tbjQuery('#changed').val(1);
	    if(response.error==0)
	    {
		tbjQuery('div#custom_fields_wrap').append(response.msg);
	    }
	}
    })
}
function reloadAvailableCars(){
    if(tbjQuery('div#available_cars_wrap').is(":visible")){
	tbjQuery.fn.getAvailableCars();
    }
    tbjQuery('#changed').val(1);
}
</script>

<script language="javascript" type="text/javascript">
Joomla.submitbutton = function(task)
{
    if (task == 'cancel' || document.formvalidator.isValid(document.id('adminForm')))
    {
	Joomla.submitform(task, document.getElementById('adminForm'));
    }
}

<?php  if($this->elsettings->default_country!="") {?>
var options = {
    componentRestrictions: {country: '<?php echo $this->default_country;?>'}
};
<?php } else { ?>
var options = {};
<?php } ?>
var map;

function initialize() {
    var pickup_input = document.getElementById('pickup_address');
    var pickup_autocomplete = new google.maps.places.Autocomplete(pickup_input, options);
    google.maps.event.addListener(pickup_autocomplete, 'place_changed', function() {
	    var place = pickup_autocomplete.getPlace();
	    if (place.geometry) {
		    document.getElementById('pickup_lat').value = place.geometry.location.lat();
		    document.getElementById('pickup_lng').value = place.geometry.location.lng();
		    tbjQuery.fn.getExtras('address_pickup');

		    // change in value should trigger updated car list for edit order only
		    if(tbjQuery('div#available_cars_wrap').is(":visible")){
			tbjQuery.fn.getAvailableCars();
		    }
		    tbjQuery('#changed').val(1);
	    }
    });

    var dropoff_input = document.getElementById('dropoff_address');
    var dropoff_autocomplete = new google.maps.places.Autocomplete(dropoff_input, options);
    google.maps.event.addListener(dropoff_autocomplete, 'place_changed', function() {
	    var place = dropoff_autocomplete.getPlace();
	    if (place.geometry) {
		    document.getElementById('dropoff_lat').value = place.geometry.location.lat();
		    document.getElementById('dropoff_lng').value = place.geometry.location.lng();
		    tbjQuery.fn.getExtras('address_dropoff');

		    // change in value should trigger updated car list for edit order only
		    if(tbjQuery('div#available_cars_wrap').is(":visible")){
			tbjQuery.fn.getAvailableCars();
		    }
		    tbjQuery('#changed').val(1);
	    }
    });
}
google.maps.event.addDomListener(window, 'load', initialize);
</script>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/orders.css" />

<?php
$hr_options = array();
for($i = 0; $i <= 23; $i++){
	$value = str_pad($i, 2, '0', STR_PAD_LEFT);
    $hr_options[$value] = $value;
}

$min_options = array();
for($i = 0; $i <= 59; $i=$i+5){
	$value = str_pad($i, 2, '0', STR_PAD_LEFT);
    $min_options[$value] = $value;
}

$ynoptions = array(
	JHtml::_('select.option', 1, JText::_('JYES')),
	JHtml::_('select.option', 0, JText::_('JNO'))
);

$return_date = $return_hr = $return_min = '';
if($this->item->datetime2!=""){
    $return_date = booking_helper::date_format($this->item->datetime2, 'Y-m-d', $this->elsettings);
    $return_hr = booking_helper::date_format($this->item->datetime2, 'H', $this->elsettings);
    $return_min = booking_helper::date_format($this->item->datetime2, 'i', $this->elsettings);

    if($this->elsettings->date_format=='mm-dd-yy') {
	$date2_temp = explode('-',$return_date);
	$return_date = $date2_temp[2].'-'.$date2_temp[0].'-'.$date2_temp[1];
    }
}
?>

<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="adminform form-validate">
    <div class="adminlist order_edit" width="100%">

	<div class="adminlist_left" valign="top">

	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one"><b><?php echo JText::_('ORDER_EDIT_USER_DETAILS');?></b></div>
		<div class="admin_list_item_two">&nbsp;</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one">
		    <label for="">
		    <span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_USER_NAME_EXPLAIN'); ?>">
			<?php echo JText::_( 'ORDER_EDIT_USER_NAME' ); ?>
		    </span>
		</label>
		</div>
		<div class="admin_list_item_two">
		    <?php
		    if (!class_exists('TbUser')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbuser.php');
		    $config = array('name' => 'user_id',
				    'id' => 'user_id',
				    'value' => $this->item->names,
				    'class' => 'inputbox required',
				    'readonly' => false,
				    'disabled' => false,
				    'scope' => 'orderedit',
				    'onchange' => 'var jsonRequest = new Request.JSON({url: "'.JURI::root().'administrator/index.php?option=com_taxibooking&task=getUserDetailsAjax", onSuccess: function(userObj){document.getElementById("user_name").value= userObj.name;document.getElementById("email").value= userObj.email;}}).get({"user_id": juser_id});'
				    );
		    $tbUser = new TbUser($config);
		    echo $tbUser->getInput();
		    ?>
		    <input type="hidden" name="user_name" id="user_name" value="<?php echo $this->item->names; ?>" />
		</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from">
		    <div class="admin_list_item_one">
			<label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_USER_EMAIL_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_USER_EMAIL' ); ?>
			</span>
		    </label>
		    </div>
		    <div class="admin_list_item_two small">
			<input class="inputbox required" type="text" name="email" id="email" value="<?php echo $this->item->email; ?>" />
		    </div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from">
		    <div class="admin_list_item_one">
			<label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_USER_PHONE_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_USER_PHONE' ); ?>
			</span>
		    </label>
		    </div>
		    <div class="admin_list_item_two small">
			<input class="inputbox" type="text" size="45" name="phone" value="<?php echo $this->item->phone; ?>" />
		    </div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one"><b><?php echo JText::_('ORDER_EDIT_ORDER_DETAILS');?></b></div>
		<div class="admin_list_item_two">&nbsp;</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from inputWrap">
		    <div class="admin_list_item_one">
			<label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_BOOKING_TYPE_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_BOOKING_TYPE' ); ?>
			</span>
		    </label>
		    </div>
   
		    <div class="admin_list_item_two"><?php //echo $this->lists['booking_types']; ?>
          <select id="booking_type" name="booking_type" class="inputbox">
          	<option value="address" selected="selected">Address Search</option>
          	<option value="offers">Special Offers</option>
          	<option value="hourly">Hourly Hire</option>
          	<option value="schooldays">School Run</option>
          </select>
        </div>
	    </div>

      <div class="admin_list_item clearfix tr_col_from schoolweek inputWrap">
		    <div class="admin_list_item_one">
    			<label for="">
    			    <span class="hasTip control-label" title="">Select days of week to book</span>
    		    </label>
		    </div>
        <style media="screen">
          .weekday {
            width: 14%;
            display: inline-block;
          }
          .weekday label input {
            margin-right: 5px;
            margin-top: -5px;
          }
        </style>

		<div class="admin_list_item_two"  style="width:80% !important"><?php //echo $this->lists['booking_types']; ?>
          <?php
              $date = new DateTime();
              $monday = $date->modify('next monday');
              // clone start date
              $endDate = clone $monday;
              // Add 7 days to start date
              $endDate->modify('+7 days');
              // Increase with an interval of one day
              $dateInterval = new DateInterval('P1D');
              $dateRange = new DatePeriod($monday, $dateInterval, $endDate);
               $dateRange;
               foreach ($dateRange as $day) { ?>
                  <div class="weekday">
                    <label><input type="checkbox" name="schoolweek[]" value="<?php echo $day->format('Y-m-d'); ?>"><?php echo $day->format('l'); ?></label> <br>
                    <select id="school_hr" name="school_hr[]" class="pickup_time" style="width:70px;">
                    <option value="">--</option>
                  	<option value="00">00</option>
                  	<option value="01">01</option>
                  	<option value="02">02</option>
                  	<option value="03">03</option>
                  	<option value="04">04</option>
                  	<option value="05">05</option>
                  	<option value="06">06</option>
                  	<option value="07">07</option>
                  	<option value="08">08</option>
                  	<option value="09">09</option>
                  	<option value="10">10</option>
                  	<option value="11">11</option>
                  	<option value="12">12</option>
                  	<option value="13">13</option>
                  	<option value="14">14</option>
                  	<option value="15">15</option>
                  	<option value="16">16</option>
                  	<option value="17">17</option>
                  	<option value="18">18</option>
                  	<option value="19">19</option>
                  	<option value="20">20</option>
                  	<option value="21">21</option>
                  	<option value="22">22</option>
                  	<option value="23">23</option>
                  </select>
                    :
            	<select id="school_min" name="school_min[]" class="pickup_time" style="width:70px;">
                    <option value="">--</option>
                  	<option value="00">00</option>
                  	<option value="05">05</option>
                  	<option value="10">10</option>
                  	<option value="15">15</option>
                  	<option value="20">20</option>
                  	<option value="25">25</option>
                  	<option value="30">30</option>
                  	<option value="35">35</option>
                  	<option value="40">40</option>
                  	<option value="45">45</option>
                  	<option value="50">50</option>
                  	<option value="55">55</option>
                </select>
                </div>
              <?php }
           ?>
        </div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from inputWrap nonshuttle_date">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_PICKUP_DATETIME_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_PICKUP_DATETIME' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <?php echo JHtml::_('calendar', $this->pickup_date, 'pickup_date', "pickup_date", '%Y-%m-%d' , array('size'=>20, 'class'=>"inputbox pickup_date required", 'onchange'=>'reloadAvailableCars();'));?>
		    <div class="pick_hr_min">
			<?php
			echo JHTML::_('select.genericlist', $hr_options, "pickup_hr", 'class="pickup_time" style="width:70px;"', 'value', 'text', $this->pickup_hr );
			?> :
			<?php
			echo JHTML::_('select.genericlist', $min_options, "pickup_min", 'class="pickup_time" style="width:70px;"', 'value', 'text', $this->pickup_min);
			?>
		    </div>
		</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from address_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_PICKUP_TYPE_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_PICKUP_TYPE' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <?php echo $this->lists['pickup_type'];?>
		</div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from address_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_PICKUP_POI_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_PICKUP_POI' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <?php echo $this->lists['pickup_poi'];?>
		</div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from address_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_PICKUP_ADDRESS_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_PICKUP_ADDRESS' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <input type="text" name="pickup_address" id="pickup_address" size="50" value="<?php echo $this->item->begin;?>" class="inputbox" />
		    <input type="hidden" name="pickup_lat" id="pickup_lat" value="<?php echo $this->item->pickup_lat;?>" />
		    <input type="hidden" name="pickup_lng" id="pickup_lng" value="<?php echo $this->item->pickup_lng;?>" />
		</div>
	    </div>

	    <div id="pickup_extra_wrapper"></div>

	    <?php if($this->elsettings->enable_stops==1){ ?>
	    <div class="admin_list_item clearfix tr_col_from stop address_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_STOPS_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_STOPS' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		    <div id="stops_wrapper">

		    <?php
		    $stops = unserialize($this->item->stops);
		    if(!empty($stops))
		    {
			    foreach($stops as $key => $stop_row) { ?>
		    <div class="admin_list_item_two">
			<input type="text" class="inputbox waypoints" name="waypoints[<?php echo $key;?>]" id="waypoint_<?php echo $key;?>" value="<?php echo $stop_row['stop'];?>" placeholder="<?php echo JText::_('ORDER_EDIT_ENTER_ADDRESS');?>" />
			<select name="waypoints_stop_duration[<?php echo $key;?>]" class="stop_interval_options">
			    <option value="0"><?php echo JText::_('ORDER_EDIT_TIME_AT_STOP'); ?></option>
			    <?php
			    for($i = $stop_duration_interval; $i <= ($max_stop_time*60); $i = $i + $stop_duration_interval){
				$selected = ($i==$stop_row['stop_interval']) ? ' selected="selected"' : '';
			    ?>
			    <option value="<?php echo $i;?>"<?php echo $selected;?>><?php echo $i;?> mins</option>
			    <?php } ?>
			</select>
			<a href="javascript:void(0);" class="remove_stop btn"><?php echo JHtml::_('image', 'admin/trash.png', '', null, true);?></a>
			<input type="hidden" name="waypoints_lat[<?php echo $key;?>]" id="waypoint_lat" value="<?php echo $stop_row['stop_lat'];?>" />
			<input type="hidden" name="waypoints_lng[<?php echo $key;?>]" id="waypoint_lng" value="<?php echo $stop_row['stop_lng'];?>" />
		    </div>
		    <?php }
		    }
		    ?>
		    </div>
		    <div class="clearfix"></div>
		    <a href="javascript:void(0);" class="addstop btn"><?php echo JText::_('ORDER_EDIT_ADD_STOPS');?></a>
		</div>
	    </div>
	    <?php } ?>

	    <div class="admin_list_item clearfix tr_col_from address_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DROPOFF_TYPE_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_DROPOFF_TYPE' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <?php echo $this->lists['dropoff_type'];?>
		</div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from address_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DROPOFF_POI_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_DROPOFF_POI' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <?php echo $this->lists['dropoff_poi'];?>
		</div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from address_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DROPOFF_ADDRESS_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_DROPOFF_ADDRESS' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <input type="text" name="dropoff_address" id="dropoff_address" size="50" value="<?php echo $this->item->end;?>" class="inputbox" />
		    <input type="hidden" name="dropoff_lat" id="dropoff_lat" value="<?php echo $this->item->dropoff_lat;?>" />
		    <input type="hidden" name="dropoff_lng" id="dropoff_lng" value="<?php echo $this->item->dropoff_lng;?>" />
		</div>
	    </div>

	    <div id="dropoff_extra_wrapper"></div>

	    <div class="admin_list_item clearfix tr_col_from offers_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SPECIAL_ROUTE_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_SPECIAL_ROUTE' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <?php echo $this->lists['route_list'];?>
		</div>
	    </div>

	    <div id="routefrom_extra_wrapper"></div>

	    <div id="routeto_extra_wrapper"></div>

	    <div class="admin_list_item clearfix tr_col_from hourly_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_HOURLY_HOUR_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_HOURLY_HOUR' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		<?php
		echo $this->lists['hourly_hr_list'];
		?>
		</div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from hourly_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_HOURLY_MIN_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_HOURLY_MIN' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		<?php
		echo $this->lists['hourly_min_list'];
		?>
		</div>
	    </div>

	    <div id="hourly_extra_wrapper"></div>

	    <div class="admin_list_item clearfix tr_col_from shuttle_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHUTTLE_PICKUP_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_SHUTTLE_PICKUP' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <?php echo $this->lists['shuttle_pickup_poi'];?>
		</div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from shuttle_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHUTTLE_DROPOFF_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_SHUTTLE_DROPOFF' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <div id="shuttle_dropoff_poi_wrap"><?php echo $this->lists['shuttle_dropoff_poi'];?></div>
		</div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from shuttle_date inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHUTTLE_PICKUP_DATE_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_SHUTTLE_PICKUP_DATE' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">

		    <div class="datetimeWrap">
			<?php echo JHtml::_('calendar', $this->pickup_date, 'shuttle_pickup_date', "shuttle_pickup_date", '%Y-%m-%d' , array('class'=>"inputbox pickup_date booking_param", 'onchange'=>'reloadShuttleDropoff();'));?>
		    </div>
		</div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from shuttle_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHUTTLE_TIMES_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_SHUTTLE_TIMES' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		    <div id="shuttle_time_wrapper" class="clearfix"></div>
		</div>
	    </div>
	    <div class="admin_list_item clearfix tr_col_from shuttle_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHUTTLE_PASSENGER_SEATS_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_SHUTTLE_PASSENGER_SEATS' ).':'; ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
		<div id="shuttle_passengers_wrap"><?php echo $this->lists['shuttle_passengers'];?></div>
		<input type="hidden" name="shuttle_route_id" id="shuttle_route_id" value="" />
		</div>
	    </div>


	    <div class="admin_list_item clearfix tr_col_from return_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_RETURN_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_RETURN' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		    <?php
		    echo JHtml::_('select.radiolist', $ynoptions, 'returntrip', '', 'value', 'text', $this->item->returntrip) ;
		    ?>
		</div>
	    </div>








        <div class="admin_list_item clearfix tr_col_from schoolweek_return inputWrap">
  		    <div class="admin_list_item_one">
      			<label for="">
      			    <span class="hasTip control-label" title="">Select days of week to book</span>
      		    </label>
  		    </div>
          <style media="screen">
            .weekday_return {
              width: 14%;
              display: inline-block;
            }
            .weekday_return label input {
              margin-right: 5px;
              margin-top: -5px;
            }
          </style>

  		<div class="admin_list_item_two"  style="width:80% !important"><?php //echo $this->lists['booking_types']; ?>
            <?php
                $date = new DateTime();
                $monday = $date->modify('next monday');
                // clone start date
                $endDate = clone $monday;
                // Add 7 days to start date
                $endDate->modify('+7 days');
                // Increase with an interval of one day
                $dateInterval = new DateInterval('P1D');
                $dateRange = new DatePeriod($monday, $dateInterval, $endDate);
                 $dateRange;
                 foreach ($dateRange as $day) { ?>
                    <div class="weekday_return">
                      <label><input type="checkbox" name="schoolweek_return[]" value="<?php echo $day->format('Y-m-d'); ?>"><?php echo $day->format('l'); ?></label> <br>
                      <select id="school_hr_return" name="school_hr_return[]" class="pickup_time" style="width:70px;">
                      <option value="">--</option>
                    	<option value="00">00</option>
                    	<option value="01">01</option>
                    	<option value="02">02</option>
                    	<option value="03">03</option>
                    	<option value="04">04</option>
                    	<option value="05">05</option>
                    	<option value="06">06</option>
                    	<option value="07">07</option>
                    	<option value="08">08</option>
                    	<option value="09">09</option>
                    	<option value="10">10</option>
                    	<option value="11">11</option>
                    	<option value="12">12</option>
                    	<option value="13">13</option>
                    	<option value="14">14</option>
                    	<option value="15">15</option>
                    	<option value="16">16</option>
                    	<option value="17">17</option>
                    	<option value="18">18</option>
                    	<option value="19">19</option>
                    	<option value="20">20</option>
                    	<option value="21">21</option>
                    	<option value="22">22</option>
                    	<option value="23">23</option>
                    </select>
                      :
              	<select id="school_min_return" name="school_min_return[]" class="pickup_time" style="width:70px;">
                      <option value="">--</option>
                    	<option value="00">00</option>
                    	<option value="05">05</option>
                    	<option value="10">10</option>
                    	<option value="15">15</option>
                    	<option value="20">20</option>
                    	<option value="25">25</option>
                    	<option value="30">30</option>
                    	<option value="35">35</option>
                    	<option value="40">40</option>
                    	<option value="45">45</option>
                    	<option value="50">50</option>
                    	<option value="55">55</option>
                  </select>
                  </div>
                <?php }
             ?>
          </div>
  	    </div>






        

	    <div class="admin_list_item clearfix tr_col_from nonhourly_feature return_feature inputWrap" id="returnWrap" style="<?php echo ((int)$this->item->returntrip==1) ? 'display:block':'display:none';?>">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_RETURN_DATETIME_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_RETURN_DATETIME' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two pick_up_wrap">
			    <?php echo JHtml::_('calendar', $return_date, 'return_date', "return_date", '%Y-%m-%d' , array('size'=>20, 'class'=>"inputbox return_date", 'onchange'=>'reloadAvailableCars();'));?>
			    <div class="pick_hr_min">
			    <?php
			    echo JHTML::_('select.genericlist', $hr_options, "return_hr", 'class="return_time" style="width:70px;"', 'value', 'text', $return_hr );
			    ?> :
			    <?php
			    echo JHTML::_('select.genericlist', $min_options, "return_min", 'class="return_time" style="width:70px;"', 'value', 'text', $return_min);
			    ?>
			    </div>
		</div>
	    </div>

	    <div id="return_extra_wrapper"></div>

	    <div class="admin_list_item clearfix tr_col_from nonshuttle_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_PASSENGERS_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_PASSENGERS' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		    <?php echo $this->lists['passengers']; ?>
		</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from nonshuttle_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_SUITCASES_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_SUITCASES' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		    <?php echo $this->lists['suitcases']; ?>
		</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from nonshuttle_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_CHILD_SEATS_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_CHILD_SEATS' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		    <?php echo $this->lists['childseats']; ?>
		</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from nonshuttle_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_INFANT_SEATS_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_INFANT_SEATS' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		    <?php echo $this->lists['infantseats']; ?>
		</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from nonshuttle_feature inputWrap">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_BOOSTER_SEATS_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_BOOSTER_SEATS' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		    <?php echo $this->lists['boosterseats']; ?>
		</div>
	    </div>

	    <!--div class="admin_list_item clearfix tr_col_from inputWrap">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_CUSTOM_FIELDS_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_CUSTOM_FIELDS' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		    <a class="btn btn-primary modal_custom_field" rel="{handler: 'iframe', size: {x: 800, y: 500}}" href="index.php?option=com_taxibooking&view=fields&layout=modal&tmpl=component" title="Select Field">
			<?php echo JText::_('ORDER_EDIT_CUSTOM_FIELDS_SELECT_LABEL'); ?>
		    </a>
		</div>
	    </div-->

	    <div class="admin_list_item clearfix tr_col_from" id="custom_fields_wrap">
		<?php
		if($this->item->extras != '')
		{
		    $extras = unserialize($this->item->extras);
		    if(!empty($extras['pickup']))
		    {
			$counter = 0;
			foreach($extras['pickup'] as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			?>
			<div class="admin_list_item clearfix tr_col_from">
			    <div class="admin_list_item_one"><label><?php echo $extra['name'];?></label></div>
			    <div class="admin_list_item_two">
				<?php echo $extra['value'];?>
				<?php if($extra['price']>0){
				    echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
				}?>
				<a href="javascript:void(0);" class="remove_custom_field btn"><?php echo JText::_('REMOVE');?></a>
				<input type="hidden" name="extras[pickup][<?php echo $extra['id'];?>]" value="<?php echo $extra['value'];?>" />
			    </div>

			</div>
			<?php
			$counter++;
			}
		    }
		    if(!empty($extras['dropoff']))
		    {
			$counter = 0;
			foreach($extras['dropoff'] as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			?>
			<div class="admin_list_item clearfix tr_col_from">
			    <div class="admin_list_item_one"><label><?php echo $extra['name'];?></label></div>
			    <div class="admin_list_item_two">
				<?php echo $extra['value'];?>
				<?php if($extra['price']>0){
				    echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
				}?>
				<a href="javascript:void(0);" class="remove_custom_field btn"><?php echo JText::_('REMOVE');?></a>
				<input type="hidden" name="extras[dropoff][<?php echo $extra['id'];?>]" value="<?php echo $extra['value'];?>" />
			    </div>

			</div>
			<?php
			$counter++;
			}
		    }
		    if(!empty($extras['hourly_hire']))
		    {
			$counter = 0;
			foreach($extras['hourly_hire'] as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			?>
			<div class="admin_list_item clearfix tr_col_from">
			    <div class="admin_list_item_one"><label><?php echo $extra['name'];?></label></div>
			    <div class="admin_list_item_two">
				<?php echo $extra['value'];?>
				<?php if($extra['price']>0){
				    echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
				}?>
				<a href="javascript:void(0);" class="remove_custom_field btn"><?php echo JText::_('REMOVE');?></a>
				<input type="hidden" name="extras[hourly_hire][<?php echo $extra['id'];?>]" value="<?php echo $extra['value'];?>" />
			    </div>

			</div>
			<?php
			$counter++;
			}
		    }
		    if(!empty($extras['user_details']))
		    {
			$counter = 0;
			foreach($extras['user_details'] as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			?>
			<div class="admin_list_item clearfix tr_col_from">
			    <div class="admin_list_item_one"><label><?php echo $extra['name'];?></label></div>
			    <div class="admin_list_item_two">
				<?php echo $extra['value'];?>
				<?php if($extra['price']>0){
				    echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
				}?>
				<a href="javascript:void(0);" class="remove_custom_field btn"><?php echo JText::_('REMOVE');?></a>
				<input type="hidden" name="extras[user_details][<?php echo $extra['id'];?>]" value="<?php echo $extra['value'];?>" />
			    </div>

			</div>
			<?php
			$counter++;
			}
		    }
		}
		?>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_SELECT_CAR_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_SELECT_CAR' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two small">
		    <input class="inputbox" type="text" name="custom_car" value="<?php echo $this->item->custom_car; ?>" placeholder="<?php echo JText::_('ORDER_EDIT_TYPE_CAR_NAME'); ?>" />
		    OR
		    <a href="javascript:void(0);" class="get_cars btn"><?php echo JText::_('ORDER_EDIT_GET_AVAILABLE_CARS'); ?></a>
		</div>
	    </div>

	    <div id="available_cars_loader" style="display:none;margin:20px;">
		    <img src="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/images/ajax-loader-bar.gif" alt="Loading.." />
	    </div>
	    <!-- shuttles will be listed by ajax -->
	    <input type="hidden" name="car_id" id="selected_car_id" value="<?php echo $this->item->vehicletype;?>" />
	    <div id="available_cars_wrap" class="no-more-tables_style2" style="margin: 20px 0;display:none;"></div>

	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_PRICE_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_PRICE' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two small">
		    <input class="inputbox" type="text" name="price" value="<?php echo $this->item->sub_total; ?>" />
		    OR
		    <input class="inputbox" type="text" name="price_override" value="<?php echo $this->item->price_override; ?>" placeholder="<?php echo JText::_('ORDER_EDIT_PRICE_OVERRIDE'); ?>" />
		</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_PAYMENT_NAME_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_PAYMENT_NAME' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two small">
		    <?php
		    $payment_name = "";
		    $payment_id = 0;
		    if($this->item->source!="backend" && is_numeric($this->item->payment) && $this->item->custom_payment==""){
			$paymentObj = booking_helper::get_payment_details($this->item->payment);
			if($paymentObj){
			    $payment_name = $paymentObj->title;
			    $payment_id = $paymentObj->id;
			}
		    }
		    else {
			$payment_name = $this->item->custom_payment;
			$payment_id = 0;
		    }
		    ?>
		    <input class="inputbox" type="text" name="custom_payment" id="payment_name" value="<?php echo $payment_name; ?>" />
		    <input type="hidden" name="payment" id="frontend_payment" value="<?php echo $payment_id;?>" />
		    <?php
		    // if this order comes from frontend and has a payment associated
		    // admin should be able to clear that payment and add custom payment instead
		    if($this->item->source!="backend" && is_numeric($this->item->payment) && $this->item->custom_payment==""){
		    ?>
		    <a href="javascript:void(0);" class="cancel_payment btn"><?php echo JText::_('ORDER_EDIT_CANCEL_PAYMENT_BUTTON'); ?></a>
		    <?php
		    }
		    ?>
		</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_PAYMENT_NOTES_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_PAYMENT_NOTES' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		    <textarea class="inputbox" name="payment_notes"><?php echo $this->item->payment_notes; ?></textarea>
		</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_DRIVER_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_DRIVER' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		<?php echo $this->lists['driver']; ?>
		</div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from">
		    <div class="admin_list_item_one">
			<label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_STATUS_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_STATUS' ); ?>
			</span>
		    </label>
		    </div>
		    <div class="admin_list_item_two"><?php echo $this->lists['state']; ?></div>
	    </div>

	    <div class="admin_list_item clearfix tr_col_from">
		<div class="admin_list_item_one">
		    <label for="">
			<span class="hasTip control-label" title="<?php echo JText::_('ORDER_EDIT_MESSAGE_EXPLAIN'); ?>">
			    <?php echo JText::_( 'ORDER_EDIT_MESSAGE' ); ?>
			</span>
		    </label>
		</div>
		<div class="admin_list_item_two">
		    <textarea class="inputbox" name="message"><?php echo $this->item->message; ?></textarea>
		</div>
	    </div>
        </div>
    </div>

    <?php echo JHTML::_('form.token'); ?>
    <input type="hidden" name="option" value="com_taxibooking" />
    <input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
    <input type="hidden" name="old_state" value="<?php echo $this->item->state; ?>" />
    <input type="hidden" name="old_driver" value="<?php echo $this->item->driver_id; ?>" />
    <input type="hidden" name="controller" value="orders" />
    <input type="hidden" name="view" value="order" />
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="source" value="<?php echo $this->item->source; ?>" />
    <input type="hidden" name="flat_cost" value="<?php echo $this->item->flat_cost; ?>" />
    <input type="hidden" name="percentage_cost" value="<?php echo $this->item->percentage_cost; ?>" />
    <input type="hidden" name="coupon_used" value="<?php echo $this->item->coupon_used; ?>" />
    <input type="hidden" name="gratuity_amt" value="<?php echo $this->item->gratuity_amt; ?>" />
    <input type="hidden" name="gratuity_amttype" value="<?php echo $this->item->gratuity_amttype; ?>" />
    <input type="hidden" name="gratuity_percent_value" value="<?php echo $this->item->gratuity_percent_value; ?>" />
    <input type="hidden" name="changed" id="changed" value="0" />
</form>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>
