<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * View to edit an order.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.5
 */
class TaxiBookingViewOrder extends JViewLegacy
{
    protected $item;

    protected $state;

    /**
    * Display the view
    *
    * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
    *
    * @return  void
    */
    public function display($tpl = null)
    {
        $app = JFactory::getApplication();
        $editor =  JFactory::getEditor();
        $document =  JFactory::getDocument();
        $user =  JFactory::getUser();
        $db =  JFactory::getDBO();
        $lang =  JFactory::getLanguage();
        $elsettings 	= booking_helper::config();
        $config   = JFactory::getConfig();
        $siteOffset = $config->get('offset');
        date_default_timezone_set($siteOffset);
        $dtnow = JFactory::getDate('now', $siteOffset);
        $now = strtotime($dtnow->format('Y-m-d H:i:s', true));
        
        JHTML::_('behavior.tooltip');
        
        $this->item	= $this->get('Item');
        $this->state	= $this->get('State');
        $this->elsettings 	= $elsettings;
        $isNew		= ($this->item->id == 0);

        // Check for errors.
        if (count($errors = $this->get('Errors')))
        {
                JError::raiseError(500, implode("\n", $errors));

                return false;
        }

        $this->addToolbar();
        
        $lists = array();
        
        $available_booking_types = $available_booking_types_arr = array();
        if((int)$elsettings->show_address_tab==1){
            $available_booking_types_arr[] = 'address';
            $available_booking_types[] = JHTML::_('select.option', 'address', JText::_('ADDRESS_SEARCH_TAB_LABEL'));
        }
        if((int)$elsettings->show_offers_tab==1){
            $available_booking_types_arr[] = 'offers';
            $available_booking_types[] = JHTML::_('select.option', 'offers', JText::_('SPECIAL_OFFERS_TAB_LABEL'));
        }
        if((int)$elsettings->show_hourly_tab==1 && booking_helper::is_hourly_rate_enabled()){
            $available_booking_types_arr[] = 'hourly';
            $available_booking_types[] = JHTML::_('select.option', 'hourly', JText::_('HOURLY_HIRE_TAB_LABEL'));
        }
        if((int)$elsettings->show_shuttles_tab==1 && booking_helper::is_shuttles_enabled()){
            $available_booking_types_arr[] = 'shuttle';
            $available_booking_types[] = JHTML::_('select.option', 'shuttle', JText::_('SHUTTLES_TAB_LABEL'));
        }
        
        $this->total_available_booking_types = count($available_booking_types_arr);
        $this->default_tab_index = 0;
        $this->default_tab_title = 'address';
        
        if(!empty($available_booking_types_arr)){
            if($this->total_available_booking_types==1){
                $this->default_tab_title = $available_booking_types_arr[0];
            }
            else {
                foreach($available_booking_types_arr as $k => $v){
                    if($v==$elsettings->default_tab){
                        $this->default_tab_index = $k;
                        $this->default_tab_title = $v;
                        break;
                    }
                }
            }
        }
        
        //build state list
        $state = array();
        
        if($isNew)
        {
            $this->item->booking_type = $this->default_tab_title;
            $this->item->source = 'backend';
            $this->item->returntrip = 0;
            $this->item->user_id = 0;
            $this->item->vehicletype = 0;
            $this->item->custom_car = "";
            $this->order_notes = array();
            
            $default_time = $now+10*60;
            $this->pickup_date = date('Y-m-d', $default_time);
            $this->pickup_hr = date('H', $default_time);
            $this->pickup_min = date('i', $default_time);
            
            $state[] = JHTML::_('select.option', 1, JText::_('NEW_ORDER_STATUS_ACCEPTED'));
            $state[] = JHTML::_('select.option', 0, JText::_('NEW_ORDER_STATUS_REJECTED'));
            $state[] = JHTML::_('select.option', -1, JText::_('NEW_ORDER_STATUS_ARCHIVED'));
            $state[] = JHTML::_('select.option', -2, JText::_('NEW_ORDER_STATUS_WAITING'));
            
            $lists['booking_types'] = JHTML::_('select.genericlist', $available_booking_types, 'booking_type', 'class="inputbox"', 'value', 'text', $this->item->booking_type);
        }
        else {
            if($this->item->booking_type=='address'){
                $lists['booking_types'] = '<strong>'.JText::_('ADDRESS_SEARCH_TAB_LABEL').'</strong>';
            }
            elseif($this->item->booking_type=='offers'){
                $lists['booking_types'] = '<strong>'.JText::_('SPECIAL_OFFERS_TAB_LABEL').'</strong>';
            }
            elseif($this->item->booking_type=='hourly'){
                $lists['booking_types'] = '<strong>'.JText::_('HOURLY_HIRE_TAB_LABEL').'</strong>';
            }
            elseif($this->item->booking_type=='shuttle'){
                $lists['booking_types'] = '<strong>'.JText::_('SHUTTLES_TAB_LABEL').'</strong>';
            }
            $lists['booking_types'] .= '<input type="hidden" name="booking_type" value="'.$this->item->booking_type.'" />';
            
            $this->pickup_date = booking_helper::date_format($this->item->datetime1, 'Y-m-d', $elsettings);
            $this->pickup_hr = booking_helper::date_format($this->item->datetime1, 'H', $elsettings);
            $this->pickup_min = booking_helper::date_format($this->item->datetime1, 'i', $elsettings);
            
            if($elsettings->date_format=='mm-dd-yy') {
                $date1_temp = explode('-',$this->pickup_date);
                $this->pickup_date = $date1_temp[2].'-'.$date1_temp[0].'-'.$date1_temp[1];
            }
            
            // get user id by user email
            $query = $db->getQuery(true)
                    ->select($db->quoteName('id'))
                    ->from($db->quoteName('#__users'))
                    ->where($db->quoteName('email') . ' = ' . $db->quote($this->item->email));
            $db->setQuery($query, 0, 1);

            $this->item->user_id = $db->loadResult();
            
            $query = $db->getQuery(true)
                    ->select('*')
                    ->from($db->quoteName('#__taxibooking_order_notes'))
                    ->where($db->quoteName('order_id') . ' = ' . $db->quote($this->item->id));
            $db->setQuery($query);
            $this->order_notes = $db->loadObjectList();
                
            if ( $this->item->datetime1 > $now || $this->item->datetime2 > $now )
            {
                $state[] = JHTML::_('select.option', 1, JText::_('NEW_ORDER_STATUS_ACCEPTED'));
                $state[] = JHTML::_('select.option', 0, JText::_('NEW_ORDER_STATUS_REJECTED'));
                $state[] = JHTML::_('select.option', -1, JText::_('NEW_ORDER_STATUS_ARCHIVED'));
                $state[] = JHTML::_('select.option', -2, JText::_('NEW_ORDER_STATUS_WAITING'));
            }
            else // for past periods - only Reject or Archive
            {
                $state[] = JHTML::_('select.option', 0, JText::_('NEW_ORDER_STATUS_REJECTED'));
                $state[] = JHTML::_('select.option', -1, JText::_('NEW_ORDER_STATUS_ARCHIVED'));
            }
        }
        
        $lists['state'] = JHTML::_('select.genericlist', $state, 'state', '', 'value', 'text', $this->item->state);
        
        $lists = array_merge($lists, $this->_buildEditLists());
        
        // get country 2 code for google autocomplete
        $country_2_code = booking_helper::get_country_field($elsettings->default_country, 'country_2_code');
        $country_2_code = ($country_2_code == '') ? 'US' : $country_2_code;
        $this->assignRef('default_country', $country_2_code);
                
        //assign data to template
        $this->assignRef('lists', $lists);
        $this->assignRef('editor', $editor);
        $this->assignRef('elsettings', $elsettings);
        
        $payment_data = '';
        JPluginHelper::importPlugin('tbpayment');
        $_dispatcher = JDispatcher::getInstance();
        $_returnValues = $_dispatcher->trigger('plgTbOnShowOrderBEPayment',array( $this->item->id,$this->item->payment));
        foreach ($_returnValues as $_returnValue) {
                if ($_returnValue !== null) {
                        $payment_data .= $_returnValue;
                }
        }
        $this->assignRef('payment_data', $payment_data);

        parent::display($tpl);
    }
    
    /**
    * Add the page title and toolbar.
    *
    * @return  void
    *
    * @since   1.6
    */
    protected function addToolbar()
    {
        require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
        JFactory::getApplication()->input->set('hidemainmenu', true);

        $canDo = TaxibookingHelper::getActions();
        $user = JFactory::getUser();

        // Get the toolbar object instance
        $bar = JToolBar::getInstance('toolbar');
        $userId		= $user->get('id');
        $isNew		= ($this->item->id == 0);
        $checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
        
        $layout = JFactory::getApplication()->input->get('layout', 'default', 'string');
        
        if($layout == 'edit')
        {
            JToolbarHelper::title($isNew ? JText::_('COM_TAXIBOOKING_MANAGER_ORDER_NEW') : JText::_('COM_TAXIBOOKING_MANAGER_ORDER_EDIT'), 'generic');
            
            // If not checked out, can save the item.
            if (!$checkedOut)
            {
                JToolbarHelper::save();
            }
            
            JToolbarHelper::cancel();
        }
        else {
            JToolbarHelper::title(JText::_('COM_TAXIBOOKING_MANAGER_ORDER_DETAILS'), 'generic');
            
            if (($canDo->get('core.edit')))
            {
                JToolbarHelper::custom('edit', 'edit', '', 'JTOOLBAR_EDIT', false);
            }
            
            JToolbarHelper::cancel('cancel', 'JTOOLBAR_BACK');
            
            if (($canDo->get('core.delete')))
            {
		// Add a delete button.
		$bar->appendButton('Confirm', 'Are you sure?', 'delete', 'JTOOLBAR_DELETE', 'remove', false);
            }
            
        }
    }
    
    /**
    * Creates list
    *
    * @since 1.0
    */
    private function _buildEditLists()
    {
        $db = JFactory::getDBO();
        $user = JFactory::getUser();
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();
        
        $lists = array();
        
        $options = array();
        $options[] = JHTML::_('select.option',  'poi', JText::_( 'SEARCHURL_PICKUP_TYPE_POI' ) );
        $options[] = JHTML::_('select.option',  'address', JText::_( 'SEARCHURL_PICKUP_TYPE_ADDRESS' ) );
        
        $lists['pickup_type'] = JHTML::_('select.genericlist', $options, 'pickup_type', 'class="booking_param"', 'value', 'text', ($this->item->pickup_poi==0) ? 'address' : 'poi');
        $lists['dropoff_type'] = JHTML::_('select.genericlist', $options, 'dropoff_type', 'class="booking_param"', 'value', 'text', ($this->item->dropoff_poi==0) ? 'address' : 'poi' );
                
        $pickup_poi = array();
        $pickup_poi[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
        
        $dropoff_poi = array();
        $dropoff_poi[] = JHTML::_('select.option', 0, JText::_('JSELECT'));

        // get all the points of interest
        $query = 'SELECT poi.id, poi.title, poi.lat, poi.long, poi.show_on_pickup, poi.show_on_dropoff, poi_cat.image'
                . ' FROM #__taxibooking_points AS poi'
                . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                . ' WHERE poi.published = 1';
        if($lang_tag!="*"){
        $query .= ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")';
        }
        $query .= ' ORDER BY poi.title ASC';
        $db->setQuery($query);
        $db->query();
        $places = $db->loadObjectList();
           
        if (!empty($places))
        {
                foreach ($places as $place)
                {
                        // enlist pickup poi
                        if($place->show_on_pickup)
                        {
                                $pickup_poi[] = JHTML::_('select.option', $place->id, $place->title);
                        }
                        // enlist dropoff poi
                        if($place->show_on_dropoff)
                        {
                                $dropoff_poi[] = JHTML::_('select.option', $place->id, $place->title);
                        }
                }
        }
        
        $lists['pickup_poi'] = JHTML::_('select.genericlist', $pickup_poi, 'pickup_poi', 'class="booking_param"', 'value', 'text', (int)$this->item->pickup_poi );
        $lists['dropoff_poi'] = JHTML::_('select.genericlist', $dropoff_poi, 'dropoff_poi', 'class="booking_param"', 'value', 'text', (int)$this->item->dropoff_poi );
           
        // list of all special routes
        $routes = array();
        $routes[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
        $query = 'SELECT r.*,'
                . ' (SELECT catid FROM #__taxibooking_points WHERE id = r.route_from) AS pickup_poicat,'
                . ' (SELECT catid FROM #__taxibooking_points WHERE id = r.route_to) AS dropoff_poicat'
                . ' FROM #__taxibooking_routes AS r'
                . ' WHERE r.published = 1'
                . ' ORDER BY r.title ASC';
        $db->setQuery($query);
        $db->query();
        $rows = $db->loadObjectList();
           
        $html = '<select id="route_id" class="booking_param" name="route_id">';
        $html .= '<option value="0" data-pickup="0" data-dropoff="0" data-pickuppoicat="0" data-dropoffpoicat="0">'.JText::_('JSELECT').'</option>';
        if (!empty($rows))
        {
            foreach ($rows as $row)
            {
                $row->title = htmlspecialchars($row->title);
                $row->title = str_replace(array("'", '"'), array("&#39;", "&quot;"), $row->title);
                
                if($this->item->pickup_poi==$row->route_from && $this->item->dropoff_poi==$row->route_to){
                    $selected = ' selected="selected"';
                }
                else {
                    $selected = '';
                }
                
                $html .= '<option value="'.$row->id.'" data-pickup="'.$row->route_from.'" data-dropoff="'.$row->route_to.'" data-pickuppoicat="'.$row->pickup_poicat.'" data-dropoffpoicat="'.$row->dropoff_poicat.'"'.$selected.'>'.$row->title.'</option>';
            }
        }
        $html .= '</select>';
        $lists['route_list'] = $html;
               
        // get the maximum passengers
        $query = 'SELECT MAX(passenger_no) AS max_passenger, MAX(suitcase_no) AS max_suitcase, '
                . ' MAX(booster_seat_no) AS max_booster, MAX(child_seat_no) AS max_child, MAX(infant_seat_no) AS max_infant'
                . ' FROM #__taxibooking_cars'
        ;
        $db->setQuery($query);
        $db->query();
        $max = $db->loadObject();
        $max_passenger = isset($max->max_passenger) ? $max->max_passenger : 8;
        $max_suitcase = isset($max->max_suitcase) ? $max->max_suitcase : 9;
        $max_booster = isset($max->max_booster) ? $max->max_booster : 5;
        $max_child = isset($max->max_child) ? $max->max_child : 5;
        $max_infant = isset($max->max_infant) ? $max->max_infant : 5;
        
        $passenger_options = array('0' => JText::_('ORDER_EDIT_SELECT_OPTION'));
        for ($i = 1; $i <= $max_passenger; $i++) {
            $passenger_options[] = JHTML::_('select.option', $i, $i);
        }
        
        $suitcases_options = array('0' => JText::_('ORDER_EDIT_SELECT_OPTION'));
        for ($i = 1; $i <= $max_suitcase; $i++) {
            $suitcases_options[] = JHTML::_('select.option', $i, $i);
        }
        
        $lists['passengers'] = JHTML::_('select.genericlist', $passenger_options, 'selpassengers', 'class="seat_options required" tabindex="1"', 'value', 'text',  $this->item->selpassengers);
        $lists['suitcases'] = JHTML::_('select.genericlist', $suitcases_options, 'selluggage', 'class="seat_options" tabindex="1"', 'value', 'text',  $this->item->selluggage);
        
        $infantseats_options = array('0' => JText::_('ORDER_EDIT_SELECT_OPTION'));
        for ($i = 1; $i <= $max_infant; $i++) {
            $infantseats_options[] = JHTML::_('select.option', $i, $i);
        }
        
        $chseats_options = array('0' => JText::_('ORDER_EDIT_SELECT_OPTION'));
        for ($i = 1; $i <= $max_child; $i++) {
            $chseats_options[] = JHTML::_('select.option', $i, $i);
        }
        
        $boosterseats_options = array('0' => JText::_('ORDER_EDIT_SELECT_OPTION'));
        for ($i = 1; $i <= $max_booster; $i++) {
            $boosterseats_options[] = JHTML::_('select.option', $i, $i);
        }
        
        $lists['has_infant_seats'] = ($max_infant > 0) ? true : false;
        $lists['has_chseats'] = ($max_child > 0) ? true : false;
        $lists['has_booster_seats'] = ($max_booster > 0) ? true : false;
        
        $lists['infantseats'] = JHTML::_('select.genericlist', $infantseats_options, 'selinfantseats', 'class="seat_options" tabindex="1"', 'value', 'text',  $this->item->selinfantseats);
        $lists['childseats'] = JHTML::_('select.genericlist', $chseats_options, 'selchildseats', 'class="seat_options" tabindex="1"', 'value', 'text',  $this->item->selchildseats);
        $lists['boosterseats'] = JHTML::_('select.genericlist', $boosterseats_options, 'selboosterseats', 'class="seat_options" tabindex="1"', 'value', 'text',  $this->item->selboosterseats);
        
        $query = 'SELECT MIN(hourly_hire_min_hr) AS min_hourly_hr, MAX(hourly_hire_max_hr) AS max_hourly_hr'
                . ' FROM #__taxibooking_cars'
                . ' WHERE hourly_hire_enabled = 1'
        ;
        $db->setQuery($query);
        $db->query();
        $max = $db->loadObject();
        $min_hourly_hr = isset($max->min_hourly_hr) ? $max->min_hourly_hr : 1;
        $max_hourly_hr = isset($max->max_hourly_hr) ? $max->max_hourly_hr : 10;
        
        $options = array('0' => JText::_('JSELECT'));
        for ($i = $min_hourly_hr; $i <= $max_hourly_hr; $i++) {
            $options[] = JHTML::_('select.option', $i, $i);
        }
        $lists['hourly_hr_list'] = JHTML::_('select.genericlist', $options, 'hourly_hr', 'class="booking_param"', 'value', 'text', (int)$this->item->hourly_hr);
        
        $options = array();
        $options[] = JHTML::_('select.option', 0, '00');
        $options[] = JHTML::_('select.option', 15, 15);
        $options[] = JHTML::_('select.option', 30, 30);
        $options[] = JHTML::_('select.option', 45, 45);
        $lists['hourly_min_list'] = JHTML::_('select.genericlist', $options, 'hourly_min', 'class="booking_param"', 'value', 'text', (int)$this->item->hourly_min);

        // get shuttle start points
        $shuttle_pickup_poi = $shuttle_dropoff_poi = array();
        $shuttle_pickup_poi[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
        $shuttle_dropoff_poi[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
        
        $query = 'SELECT DISTINCT p.title AS poi_title, p.id AS poiid, p.lat AS poilat, p.long AS poilng, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image'
                . ' FROM #__taxibooking_shuttle_route_stops AS rs'
                . ' LEFT JOIN #__taxibooking_shuttle_routes AS r ON r.id = rs.route_id'
                . ' LEFT JOIN #__taxibooking_points AS p ON p.id = rs.poi_id'
                . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = p.catid'
                . ' WHERE rs.is_end = 0'
                . ' AND r.published = 1'
                . ' AND (r.language = "*" OR r.language = "'.$lang_tag.'")'
                . ' ORDER BY p.title ASC';
        $db->setQuery($query);
        $db->query();
        $rows = $db->loadObjectList();
           
        if (!empty($rows))
        {
                $i = 0;
                foreach ($rows as $row)
                {
                        $shuttle_pickup_poi[] = JHTML::_('select.option', $row->poiid, $row->poi_title);
                        $i++;
                }
        }
        $lists['shuttle_pickup_poi'] = JHTML::_('select.genericlist', $shuttle_pickup_poi, 'shuttle_pickup_poi', 'class="booking_param" style="float:left;"', 'value', 'text', (int)$this->item->pickup_poi);
        $lists['shuttle_dropoff_poi'] = JHTML::_('select.genericlist', $shuttle_dropoff_poi, 'shuttle_dropoff_poi', 'class="booking_param"', 'value', 'text', (int)$this->item->dropoff_poi);
        $lists['shuttle_passengers'] = JHTML::_('select.genericlist', $shuttle_dropoff_poi, 'shuttle_passengers', 'class="booking_param"', 'value', 'text', (int)$this->item->selpassengers);
        
        /**
        *Prapring dropdown to Drivers select box 
        */
        $Alldrivers = booking_helper::getDrivers();
        $drivers = booking_helper::getAvailableDrivers($Alldrivers, $this->item->datetime1, $this->item->datetime2);
        $driver_options = array();
        $driver_options[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
        if (count($drivers) > 0) {
            foreach ($drivers As $d) {
                $driver_options[] = JHTML::_('select.option', $d->user_id, $d->name);
            }
        }
        else {
            $driver_options[] = JHTML::_('select.option', "", JText::_('ORDER_DETAILS_DRIVER_CREATE_GROUP'));
        }
        $lists['driver'] = JHTML::_('select.genericlist', $driver_options, 'driver_id', '', 'value', 'text', $this->item->driver_id);
        
        return $lists;
    }
}