<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$params		= (isset($this->state->params)) ? $this->state->params : new JObject();

$fromdate = $this->state->get('filter.from_date');
$fromtime = $this->state->get('filter.from_time', '00:00');
$todate = $this->state->get('filter.to_date');
$totime = $this->state->get('filter.to_time', '23:59');

$from_time_str = $this->state->get('filter.from_time_str', '');
$to_time_str = $this->state->get('filter.to_time_str', '');

$elsettings = booking_helper::config();
if($elsettings->date_format=='mm-dd-yy') {
    $format = '%m-%d-%Y';
}
else {
    $format = '%d-%m-%Y';
}
$format = '%Y-%m-%d';
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/orders.css" />

<div class="booking">
    <form action="<?php echo JRoute::_('index.php?option=com_taxibooking&view=orders'); ?>" method="post" name="adminForm" id="adminForm">

        <div class="adminform">
            <div class="row_one clearfix">
		<h5 style="margin: 0px;"><span style="vertical-align: top; margin-top: 4px; margin-right: 5px; display: inline-block; float: left;"><b><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></b></span></h5>
		<div class="fromwrap clearfix">
			<span style="width: 90px; vertical-align: top; margin-top: 4px; margin-right: 5px; display: inline-block; float: left;">From (d/m/y):</span>
			<?php echo JHTML::_('calendar', ($from_time_str!="")? date('Y-m-d', $from_time_str) : '', "fromdate", "fromdate", $format); ?>
			<input name="fromtime" class="text_area"  size="5" maxlength='5' value="<?php echo $fromtime; ?>" />&nbsp;&nbsp;
		</div>
		<div class="towrap clearfix">
			<span style="width: 90px; vertical-align: top; margin-top: 4px; margin-right: 5px; display: inline-block; float: left;">To (d/m/y):</span>
			<?php echo JHTML::_('calendar', ($to_time_str!="")? date('Y-m-d', $to_time_str) : '', "todate", "todate", $format); ?>
			<input name="totime" class="text_area"  size="5" value="<?php echo $totime; ?>" maxlength='5' />
		</div>
		<div class="buttonWrap">
			<button class="btn" onclick="this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
			<button class="btn" onclick="this.form.getElementById('fromdate').value='';this.form.getElementById('todate').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			<!--button class="btn" type="button" onclick="window.location.href='index.php?option=com_taxibooking&view=orders&csv=1';"><?php echo JText::_('EXPORT_CSV'); ?></button-->
		</div>
	    </div>
	    <div class="row_two">
		<?php echo $this->lists['car_list']; ?>
		<?php echo $this->lists['driver']; ?>
		<?php echo $this->lists['payment']; ?>
        <?php echo $this->lists['state']; ?>
        <!-- new -->
        <?php echo $this->lists['operators']; ?>
        <!-- endnew -->
            </div>
        </div>

        <?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
	<table class="table table-striped no-more-tables" id="articleList">
	<?php } else { ?>
	<table class="adminlist">
	<?php } ?>

            <thead>
                <tr>
                    <th width="5"><input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" /></th>
		    <th width="5%">
                        <?php echo JText::_('ORDER_LIST_ORDER_NUMBER'); ?>
                    </th>
                    <th width="15%">
                        <?php echo JHTML::_('grid.sort', 'NAME', 'a.names', $listDirn, $listOrder); ?>
                    </th>
                    <th class="numeric" width="5%">
                        <?php echo JHTML::_('grid.sort', 'PICK_UP', 'a.datetime1', $listDirn, $listOrder); ?>
                    </th>
                    <!-- NEW: -->
                    <th class="numeric" width="7%">
                        <?php echo JHTML::_('grid.sort', 'Orderdate', 'a.datetime1', $listDirn, $listOrder); ?>
                    </th>
                    <!-- endnew -->
		    <th class="numeric" width="15%">
                        <?php echo JHTML::_('grid.sort', 'FROM', 'a.begin', $listDirn, $listOrder); ?>
		    </th>
                    <th class="numeric" width="15%">
                        <?php echo JHTML::_('grid.sort', 'TO', 'a.end', $listDirn, $listOrder); ?>
                    </th>
                    <th class="numeric" width="8%">
                        <?php echo JHTML::_('grid.sort', 'ORDER_LIST_RETURN_DATE', 'a.datetime2', $listDirn, $listOrder); ?>
                    </th>
		    <th class="numeric" width="5%">
                        <?php echo JText::_('CAR'); ?>
                    </th>
		    <th class="numeric" width="1%">
                            <?php echo JHtml::_('grid.sort', 'PASSENGERS', 'a.selpassengers', $listDirn, $listOrder); ?>
                    </th>
                    <th class="numeric" width="10%">
                        <?php echo JHTML::_('grid.sort', 'ORDER_LIST_DRIVERID', 'drivername', $listDirn, $listOrder); ?>
                    </th>
		    <th class="numeric" width="10%">
                        <?php echo JHTML::_('grid.sort', 'PRICE', 'a.cprice', $listDirn, $listOrder); ?>
                    </th>
                    <th class="numeric" width="10%">
                        <?php echo JText::_('PAYMENT'); ?>
                    </th>
                    <th class="numeric" width="5%"><?php echo JText::_('JSTATUS'); ?></th>

                    <th class="numeric" width="1%">
                            <?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                    </th>
                    <th class="numeric" width="1%"><?php echo JText::_('INVOICE'); ?></th>
                </tr>
            </thead>

            <tbody>
                <?php
                $k = 0;
                for ($i = 0, $n = count($this->items); $i < $n; $i++) {
                    $row = $this->items[$i];

                    $pdf_invoice_url = "index.php?option=com_taxibooking&controller=orders&task=pdf_invoice&cid=". $row->id;
                    $invoice_link = "<a href=\"javascript:void window.open('$pdf_invoice_url', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');\">";

                    $link = 'index.php?option=com_taxibooking&amp;controller=orders&amp;task=show&amp;cid[]=' . $row->id;
                    $checked 	= JHTML::_('grid.id', $i, $row->id);

                    $car_obj = booking_helper::get_car_details($row->vehicletype);

                    if ($row->state == 1) {
                        $img = 'icon-16-allow.png';
                        $alt = JText::_('ACCEPTED');
                        $state = 1;
                    } else if ($row->state == 0) {
                        $img = 'publish_r.png';
                        $alt = JText::_('REJECTED');
                        $state = 0;
                    } else if ($row->state == -1) {
                        $img = 'disabled.png';
                        $alt = JText::_('ARCHIVED');
                        $state = -1;
                    } else if ($row->state == -2) {
                        $img = 'publish_x.png';
                        $alt = JText::_('WAITING');
                        $state = -2;
                    }
                    ?>
                    <tr class="<?php echo "row$k"; ?>">
                        <td data-title="&nbsp;"><?php echo $checked; ?></td>
			<td data-title="<?php echo JText::_('ORDER_LIST_ORDER_NUMBER'); ?>" align="center">
			    <a href="<?php echo $link; ?>"><?php echo $row->order_number; ?></a>
			</td>
                        <td data-title="<?php echo JText::_('NAME'); ?>" align="center"><?php echo $row->names; ?></td>
                        <td data-title="<?php echo JText::_('PICK_UP');?>" class="numeric" align="center">
			    <?php echo booking_helper::get_order_pickup_date($row, $elsettings); ?>
			</td>

            <!-- NEW: -->
            <td data-title="<?php echo 'Order date'; ?>" class="numeric" align="center">
    <?php echo booking_helper::get_order_place_date($row, $elsettings); ?>
</td>
            <!-- endnew -->

			<td data-title="<?php echo JText::_('FROM');?>" class="numeric" align="center">
			    <?php echo ($row->begin=="") ? "&nbsp;" : $row->begin; ?>
			</td>
                        <td data-title="<?php echo JText::_('TO');?>" class="numeric" align="center">
			    <?php echo ($row->end=="") ? "&nbsp;" : $row->end; ?>
			</td>
                        <td data-title="<?php echo JText::_('ORDER_LIST_RETURN_DATE');?>" class="numeric" align="center">
			    <?php echo ($row->datetime2=="") ? JText::_('JNO') : booking_helper::get_order_return_date($row, $elsettings); ?>
			</td>
                        <td data-title="<?php echo JText::_('CAR'); ?>" class="numeric" align="center">
			    <?php if($row->vehicletype > 0){ ?>
			    <a href="<?php echo JRoute::_('index.php?option=com_taxibooking&amp;controller=cars&amp;task=show&amp;cid[]='. $row->vehicletype);?>" target="_blank">
				<?php echo booking_helper::get_order_car($row); ?>
			    </a>
			    <?php } else {?>
			    <?php echo booking_helper::get_order_car($row); ?>
			    <?php } ?>
			</td>
			<td data-title="<?php echo JText::_('PASSENGERS');?>" class="numeric" align="center"><?php echo $row->selpassengers; ?></td>
                        <td data-title="<?php echo JText::_('ORDER_LIST_DRIVERID');?>" class="numeric" align="center">
			    <?php echo ($row->drivername=="") ? "&nbsp;" : $row->drivername; ?>
			</td>
                        <td data-title="<?php echo JText::_('PRICE');?>" class="numeric" align="center"><?php echo booking_helper::price_display($row->cprice, $elsettings); ?></td>
                        <td data-title="<?php echo JText::_('PAYMENT'); ?>" class="numeric" align="center">
			    <?php echo booking_helper::get_order_payment($row); ?>
			</td>
                        <td data-title="<?php echo JText::_('JSTATUS');?>" class="numeric" align="center">
			    <?php echo JHtml::_('image', 'admin/' . $img, $alt, 'title="'.$alt.'"', true);?>
			</td>
                        <td data-title="<?php echo JText::_('JGRID_HEADING_ID');?>" class="numeric" align="center"><?php echo $row->id; ?></td>
                        <td data-title="<?php echo JText::_('INVOICE'); ?>" class="numeric" align="center">&nbsp;
                        <?php
                        $order_id = $row->id;
                        $pdf_invoice = JPATH_COMPONENT . DS . "documents".DS.$row->invoice_title;
                        if ($row->state == 1 && ($row->invoice_title!="") && file_exists($pdf_invoice)):
                            echo $invoice_link;
                            ?>
                                <img src="<?php echo JURI::base();?>components/com_taxibooking/assets/images/pdf.png" width="25" height="25" alt="Invoice" />
                            </a>
                        <?php endif; ?>
                        </td>
                    </tr>
                            <?php $k = 1 - $k;
                        }
                        ?>
            </tbody>
	    <tfoot>
		<tr>
		    <td colspan="15" style="text-align:center;">
			<?php echo $this->pagination->getLimitBox(); ?>
			<?php echo $this->pagination->getListFooter(); ?>
		    </td>
		</tr>
	    </tfoot>
        </table>

        <input type="hidden" name="boxchecked" value="0" />
        <input type="hidden" name="option" value="com_taxibooking" />
        <input type="hidden" name="controller" value="orders" />
        <input type="hidden" name="view" value="orders" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
        <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn;?>" />
<?php echo JHTML::_('form.token'); ?>
    </form>
</div>
