<?php

$filename = "components/com_taxibooking/documents/taxibooking_order_export_" . $this->user->username.".csv";
$fp = fopen($filename , 'w');
$k = 0;
$csv_header = array('NUMBER','CUSTOMER NAME','PICK UP','RETURN DATE','CAR','DRIVER','FROM','TO','PRICE','PAYMENT','ID','STATE');
    fputcsv($fp, $csv_header);
for ($i = 0, $n = count($this->items); $i < $n; $i++) {
    $row = $this->items[$i];
    if ($row->state == 1) {
        $state = JText::_('ACCEPTED');
    } else if ($row->state == 0) {
        $state = JText::_('REJECTED');
    } else if ($row->state == -1) {
        $state = JText::_('ARCHIVED');
    } else if ($row->state == -2) {
        $state = JText::_('WAITING');
    }

    $csv_array = array(($i+1),
                       $row->names,
                       booking_helper::get_order_pickup_date($row),
                       booking_helper::get_order_return_date($row),
                       booking_helper::get_order_car($row),
                       $row->drivername,
                        $row->begin,
                        $row->end,
                        number_format($row->cprice, 2, '.', ','),
                        booking_helper::get_order_payment($row),
                        $row->id,
                        $state
                        );
    fputcsv($fp, $csv_array);
}
fclose($fp);
header('location:'.$filename);

?>