<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * View class for a list of orders.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.6
 */
class TaxibookingViewOrders extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Method to display the view.
	 *
	 * @param   string  $tpl  A template file to load. [optional]
	 *
	 * @return  mixed  A string if successful, otherwise a JError object.
	 *
	 * @since   1.6
	 */
	public function display($tpl = null)
	{
                $csv = JRequest::getVar('csv', false);

                //Get data from the model
                if ($csv === false) {
                    $this->items = $this->get('Items');
                }
		else {
                    $this->items = $this->get('CSVData');
                }

                $this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');

                // Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$payment_methods = $this->get('PaymentMethods');
		// new
		$operators = $this->get('Operators');
		// endnew


                $lists = array();

                $state = array();
                $state[] = JHTML::_('select.option', '', '- ' . JText::_('Select State') . ' -');
                $state[] = JHTML::_('select.option', 'P', JText::_('Accepted'));
                $state[] = JHTML::_('select.option', 'U', JText::_('Rejected '));
                $state[] = JHTML::_('select.option', 'A', JText::_('Archived'));
                $state[] = JHTML::_('select.option', 'W', JText::_('Waiting'));
                $lists['state'] = JHTML::_('select.genericlist', $state, 'filter_state', 'class="inputbox" size="1" onchange="this.form.submit()"', 'value', 'text', $this->state->get('filter.state'));

                $payment_method_options = array();
                $payment_method_options[] = JHTML::_('select.option', 0, JText::_('ORDER_LIST_FILTER_PAYMENT'));
                if(!empty($payment_methods)){
                    foreach($payment_methods as $payment_method){
                        $payment_method_options[] = JHTML::_('select.option', (int)$payment_method->value, $payment_method->text);
                    }
                }
                $lists['payment'] = JHTML::_('select.genericlist', $payment_method_options, 'filter_payment', 'class="inputbox" size="1" onchange="this.form.submit()"', 'value', 'text', $this->state->get('filter.payment'));

				// new
				$operators_list = array();
                $operators_list[] = JHTML::_('select.option', 0, 'Select operator');
                if(!empty($operators)){
                    foreach($operators as $operator){
                        $operators_list[] = JHTML::_('select.option', (int)$operator->id, $operator->name);
                    }
                }
                $lists['operators'] = JHTML::_('select.genericlist', $operators_list, 'filter_operator', 'class="inputbox" size="1" onchange="this.form.submit()"', 'value', 'text', $this->state->get('filter.operator'));
				// endnew

                /**
                 * Prapring dropdown to Drivers select box
                 */
		$drivers = booking_helper::getDrivers();
                $driver_options = array();
                $driver_options[] = JHTML::_('select.option', 0, JText::_('ORDER_LIST_FILTER_DRIVER'));
                if (count($drivers) > 0) {
                    foreach ($drivers As $d) {
                        $driver_options[] = JHTML::_('select.option', $d->user_id, $d->name);
                    }
                } else {
                    $driver_options[] = JHTML::_('select.option', "", JText::_('ORDER_DETAILS_DRIVER_CREATE_GROUP'));
                }
                $lists['driver'] = JHTML::_('select.genericlist', $driver_options, 'filter_driver', 'class="inputbox" size="1" onchange="this.form.submit()"', 'value', 'text', $this->state->get('filter.driver'));

                // get available cars
                $cars = booking_helper::get_available_cars();
                $car_option = array();
                $car_option[] = JHTML::_('select.option', 0, JText::_('Select Car'));
                if (!empty($cars)) {
                    foreach ($cars AS $car) {
                        $car_option[] = JHTML::_('select.option', $car->id, $car->title);
                    }
                }
                $lists['car_list'] = JHTML::_('select.genericlist', $car_option, 'filter_car', 'class="inputbox" size="1" onchange="this.form.submit()"', 'value', 'text', $this->state->get('filter.car'));

                $this->lists = $lists;

		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		TaxibookingHelper::addSubmenu('orders');

		$this->addToolbar();

		if ($csv === false) {
                    parent::display($tpl);
                }
		else {
                    parent::display('csv');
                }
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();

		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('ITEMS'), 'generic');

		if ($canDo->get('core.create'))
		{
			JToolbarHelper::addNew();
		}

		if (($canDo->get('core.edit')))
		{
			JToolbarHelper::editList();
			JToolBarHelper::custom('export', 'save', '', JText::_('EXPORT_CSV'));
		}

		if ($canDo->get('core.edit.state'))
		{
			//JToolbarHelper::checkin();
		}

		if ($canDo->get('core.delete'))
		{
			JToolbarHelper::deleteList('Are you sure?', 'remove', 'JTOOLBAR_DELETE');
		}

		if ($user->authorise('core.admin', 'com_taxibooking'))
		{
			JToolbarHelper::preferences('com_taxibooking');
		}
	}
}
