<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
?>

<script language="javascript" type="text/javascript">
Joomla.submitbutton = function(task)
{
    if (task == 'cancel' || document.formvalidator.isValid(document.id('adminForm')))
    {
	Joomla.submitform(task, document.getElementById('adminForm'));
    }
}
</script>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/payment.css" />

<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="adminform form-validate">
	
	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
	<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'panel_1')); ?>
	
	    <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'panel_1', JText::_('PMETHOD_INFORMATION')); ?>
	<?php } else { ?>
	<?php echo JHtml::_('tabs.start', 'tab_group_id', array('useCookie'=>1)); ?>
     
	<?php echo JHtml::_('tabs.panel', JText::_('PMETHOD_INFORMATION'), 'panel_1'); ?>
	<?php } ?>
	

	<div class="payment_details_adminform">
		<div class="payment_details_inputwrap clearfix">
			<label for="title">
				<?php echo JText::_( 'TITLE' ).':'; ?>
			</label>
			<input type="text" name="title" value="<?php echo $this->item->title; ?>" size="50" maxlength="100" />
		</div>
		<div class="payment_details_inputwrap clearfix">
			<label for="title">
				<?php echo JText::_( 'ALIAS' ).':'; ?>
			</label>
			<input type="text" name="alias" value="<?php echo $this->item->alias; ?>" class="inputbox" placeholder="<?php echo JText::_('JFIELD_ALIAS_PLACEHOLDER');?>" />
		</div>
		<div class="payment_details_inputwrap clearfix">
			<label for="published">
				<?php echo JText::_( 'PUBLISHED' ).':'; ?>
			</label>
			<?php
			$showdets = array();
			$showdets[] = JHTML::_('select.option', 1, JText::_('JYES'));
			$showdets[] = JHTML::_('select.option', 0, JText::_('JNO'));
			echo JHTML::_('select.genericlist', $showdets, 'published', 'size="1" class="inputbox"', 'value', 'text', $this->item->published);
			?>
		</div>
		
		<div class="payment_details_inputwrap clearfix">
			<label for="title">
				<?php echo JText::_( 'JFIELD_LANGUAGE_LABEL' ).':'; ?>
			</label>
			<?php 
			echo $this->lists['languages'];
			?>
		</div>	

		<div class="payment_details_inputwrap clearfix">
			<label for="published">
				<?php echo JText::_( 'PAYMENT_METHOD_LIST' ).':'; ?>
			</label>
			<?php echo $this->tbPaymentList;?>
		</div>
	</div>
	
	<div class="payment_details_adminform">
		<label for="body">
			<?php echo JText::_( 'Description' ).':'; ?>
		</label>
		<div class="editor">
		<?php
		// parameters : areaname, content, hidden field, width, height, rows, cols
		echo $this->editor->display( 'text',  $this->item->text, '100%;', '300', '75', '20', array('pagebreak','article','image') ) ;
		?>
		</div>
	</div>
	
	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
	<?php echo JHtml::_('bootstrap.endTab'); ?>
    
	<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'panel_2', JText::_('PMETHOD_CONFIGURATION')); ?>
    <?php } else { ?>
	    
	    <?php echo JHtml::_('tabs.panel', JText::_('PMETHOD_CONFIGURATION'), 'panel_2'); ?>
    <?php } ?>
    
    <div class="config">
	    <?php
	    if($this->item->payment_plugin_id)
	    {
		    require(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'parameterparser.php' );
		    $parameters = new TbParameters($this->item,  $this->item->payment_element , 'plugin' ,'tbpayment');
		    echo $rendered = $parameters->render('params', 'tbpayment');
	    }
	    else {
		    echo JText::_('SELECT_PAYMENT_METHOD' );
	    }
	    ?>
	</div>
        
	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>
	    <?php } else { ?>
		    
		    <?php echo JHtml::_('tabs.end'); ?>
	    <?php } ?>
	    
	<?php echo JHTML::_( 'form.token' ); ?>
	<input type="hidden" name="option" value="com_taxibooking" />
	<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
	<input type="hidden" name="controller" value="paymentmethods" />
	<input type="hidden" name="view" value="paymentmethod" />
	<input type="hidden" name="task" value="" />
</form>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>