<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 * View class 
 */
class TaxibookingViewPaymentmethod extends JViewLegacy
{
	protected $item;
    
	protected $state;
    
	/**
	* Display the view
	*
	* @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	*
	* @return  void
	*/
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		$config = JFactory::getConfig();
		
		$this->elsettings 	= booking_helper::config();
		$this->item	= $this->get('Item');
		$this->state	= $this->get('State');
		$isNew		= ($this->item->id == 0);
		$this->editor =  JFactory::getEditor();
	
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		//build selectlists
		$this->lists = $this->_buildEditLists($this->item);
		
		$this->tbPaymentList = $this->renderInstalledPaymentPlugins($this->item->payment_plugin_id);
		
		$this->addToolbar();
		parent::display($tpl);
	}
	
	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		JFactory::getApplication()->input->set('hidemainmenu', true);
	
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();
	
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
	    
		JToolbarHelper::title($isNew ? JText::_('COM_TAXIBOOKING_MANAGER_PAYMENTMETHOD_NEW') : JText::_('COM_TAXIBOOKING_MANAGER_PAYMENTMETHOD_EDIT'), 'generic');
		
		// If not checked out, can save the item.
		if (!$checkedOut)
		{
			JToolbarHelper::apply();
			JToolbarHelper::save();
		}
		
		JToolbarHelper::cancel();
	}
	
	private function renderInstalledPaymentPlugins($selected){
		
		$table = '#__extensions';
		$ext_id = 'extension_id';
		$enable = 'enabled';

		$db = JFactory::getDBO();
		$q = 'SELECT * FROM `'.$table.'` WHERE `folder` = "tbpayment" AND `'.$enable.'`="1" ';
		$db->setQuery($q);
		$result = $db->loadAssocList($ext_id);
		if(empty($result)){
			$app = JFactory::getApplication();
			$app->enqueueMessage(JText::_('NO_PAYMENT_PLUGINS_INSTALLED'));
		}
		$listHTML='<select id="payment_plugin_id" name="payment_plugin_id">';
		
		foreach($result as $paym){
			
			if($paym[$ext_id]==$selected) $checked='selected="selected"'; else $checked='';
			// Get plugin info
			$id = 'pam_type';
			$listHTML .= '<option id="'.$id.'" '.$checked.' value="'.$paym[$ext_id].'">'.JText::_($paym['name']).'</option>';
		}
		$listHTML .= '</select>';

		return $listHTML;
	}
	
	/**
	 * Creates list
	 *
	 * @since 1.0
	 */
	private function _buildEditLists($item)
	{
                $db = JFactory::getDBO();
		
		$options = array();
                $options[] = JHTML::_('select.option',  '*', JText::_( 'JALL' ) );
		$rows = JHtml::_('contentlanguage.existing');
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->value, $row->text);
			}
                }
                $lists['languages'] = JHTML::_('select.genericlist', $options, 'language', '', 'value', 'text', $item->language );
		
		return $lists;
	}
}