<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
?>

<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o&v=3.exp&libraries=places"></script>
<script language="javascript" type="text/javascript">
Joomla.submitbutton = function(task)
{
    if (task == 'cancel' || document.formvalidator.isValid(document.id('adminForm')))
    {
	Joomla.submitform(task, document.getElementById('adminForm'));
    }
}

var map;

function initialize() {
	
	<?php  if($this->elsettings->default_country!="") {?>
	var options = {
	    componentRestrictions: {country: '<?php echo $this->default_country;?>'}
	};
	<?php } else { ?>
	var options = {};
	<?php } ?>
    
	var address_to_input = document.getElementById('poi_title');
	var address_to_autocomplete = new google.maps.places.Autocomplete(address_to_input, options);
	
	google.maps.event.addListener(address_to_autocomplete, 'place_changed', function() {
		var place = address_to_autocomplete.getPlace();
		if (place.geometry) {
			document.getElementById('poi_lat').value = place.geometry.location.lat();
			document.getElementById('poi_lng').value = place.geometry.location.lng();
		}
	});
}

google.maps.event.addDomListener(window, 'load', initialize);
</script>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/point.css" />

<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="adminform form-validate">

<div class="poi_int_single_adminform">
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'TITLE' ).':'; ?>
		</label>
		<input type="text" name="title" id="poi_title" value="<?php echo $this->item->title; ?>" class="inputbox required" size="50" />
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'ALIAS' ).':'; ?>
		</label>
		<input type="text" name="alias" value="<?php echo $this->item->alias; ?>" class="inputbox" placeholder="<?php echo JText::_('JFIELD_ALIAS_PLACEHOLDER');?>" />
	</div>
	<div class="inputWrap published clearfix">							
		<label for="published">
			<?php echo JText::_( 'PUBLISHED' ).':'; ?>
		</label>
		<?php echo JHTML::_('select.booleanlist', 'published', 'class="inputbox"', $this->item->published );?>
	</div>							
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'LATITUDE' ).':'; ?>
		</label>
		<input type="text" name="lat" id="poi_lat" value="<?php echo $this->item->lat; ?>" class="inputbox required" maxlength="100" />
	</div>	
	<div class="inputWrap clearfix">						
		<label for="published">
			<?php echo JText::_( 'LONGTITUDE' ).':'; ?>
		</label>
		<input type="text" name="long" id="poi_lng" value="<?php echo $this->item->long; ?>" class="inputbox required" maxlength="100" />
	</div>	
	<div class="inputWrap clearfix">
		<label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('POI_CATEGORY_EXPLAIN'); ?>">
			<?php echo JText::_( 'POI_CATEGORY' ).':'; ?>
			</span>
		</label>
		<?php
		echo $this->lists['categories'];
		?>
	</div>	
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'JFIELD_LANGUAGE_LABEL' ).':'; ?>
		</label>
		<?php 
		echo $this->lists['languages'];
		?>
	</div>	
	<div class="inputWrap clearfix">
		<label for="published">
			<span class="hasTip control-label" title="<?php echo JText::_('POI_ADDITIONAL_FIELD_EXPLAIN'); ?>">
			<?php echo JText::_( 'POI_ADDITIONAL_FIELD_LABEL' ).':'; ?>
			</span>
		</label>
		<input type="text" name="additional_fld_label" value="<?php echo $this->item->additional_fld_label; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap clearfix">					
		<label for="published">
			<span class="hasTip control-label" title="<?php echo JText::_('POI_ADDITIONAL_CHARGE_EXPLAIN'); ?>">
			<?php echo JText::_( 'POI_ADDITIONAL_CHARGE' ).':'; ?>
			</span>
		</label>
		<input type="text" name="additional_charge" value="<?php echo $this->item->additional_charge; ?>" size="50" maxlength="100" />
	</div>
	<div class="inputWrap published clearfix">
		<label for="published">
			<span class="hasTip control-label" title="<?php echo JText::_('POI_SHOW_ON_PICKUP_EXPLAIN'); ?>">
			<?php echo JText::_( 'SHOW_ON_PICKUP' ).':'; ?>
			</span>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'show_on_pickup', 'class="inputbox"', $this->item->show_on_pickup );
		?>
	</div>
	<div class="inputWrap published clearfix">
		<label for="published">
			<span class="hasTip control-label" title="<?php echo JText::_('POI_SHOW_ON_DROPOFF_EXPLAIN'); ?>">
			<?php echo JText::_( 'SHOW_ON_DROPOFF' ).':'; ?>
			</span>
		</label>
		<?php echo JHTML::_('select.booleanlist', 'show_on_dropoff', 'class="inputbox"', $this->item->show_on_dropoff );?>
	</div>
	<div class="inputWrap published clearfix">
		<label for="published">
			<span class="hasTip control-label" title="<?php echo JText::_('POI_SHOW_ON_OFFERS_PICKUP_EXPLAIN'); ?>">
			<?php echo JText::_( 'POI_SHOW_ON_OFFERS_PICKUP' ).':'; ?>
			</span>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'show_on_offers_pickup', 'class="inputbox"', $this->item->show_on_offers_pickup );
		?>
	</div>
	<div class="inputWrap published clearfix">
		<label for="published">
			<span class="hasTip control-label" title="<?php echo JText::_('POI_SHOW_ON_OFFERS_DROPOFF_EXPLAIN'); ?>">
			<?php echo JText::_( 'POI_SHOW_ON_OFFERS_DROPOFF' ).':'; ?>
			</span>
		</label>
		<?php echo JHTML::_('select.booleanlist', 'show_on_offers_dropoff', 'class="inputbox"', $this->item->show_on_offers_dropoff );?>
	</div>
	<div class="inputWrap editor clearfix">
		<label for="body">
			<?php echo JText::_( 'Description' ).':'; ?>
		</label>
		<?php
		// parameters : areaname, content, hidden field, width, height, rows, cols
		echo $this->editor->display( 'text',  $this->item->text, '100%;', '350', '75', '20', array('pagebreak') ) ;
		?>
	</div>
</div>

<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="option" value="com_taxibooking" />
<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
<input type="hidden" name="controller" value="points" />
<input type="hidden" name="view" value="point" />
<input type="hidden" name="task" value="" />
</form>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>