<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
?>

<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o&v=3.exp&libraries=places"></script>

<?php if(version_compare(JVERSION,'3.1.5','le')) {?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<?php } ?>

<script language="javascript" type="text/javascript">
var xhr = null;
var tbjQuery = jQuery.noConflict();
var BASE_URL = '<?php echo JURI::base();?>';

tbjQuery(document).ready(function(){
	tbjQuery("#route_from").change(function(){
		if(tbjQuery(this).val()==tbjQuery("#route_to").val()){
			tbjQuery(this).val(0);
			alert('<?php echo JText::_('SELECT_DIFFERENT_FROM_TO_POI');?>');
			return false;
		}
	})
	tbjQuery("#route_to").change(function(){
		if(tbjQuery(this).val()==tbjQuery("#route_from").val()){
			tbjQuery(this).val(0);
			alert('<?php echo JText::_('SELECT_DIFFERENT_FROM_TO_POI');?>');
			return false;
		}
	})
	tbjQuery('input[name="separate_car_price"]').click(function(){
		if(tbjQuery('input[name="separate_car_price"]:checked').val()==1){
			tbjQuery('table#cars_wrapper').show();
		}
		else {
			tbjQuery('table#cars_wrapper').hide();
		}
	})
	tbjQuery('a.route_new_poi_trigger').click(function(){
		tbjQuery(this).parent().next('div.new_poi_wrapper').show();
	})
	tbjQuery('.new_poi_cancel_btn').click(function(){
		tbjQuery(this).closest('div.new_poi_wrapper').find('input').val('');
		tbjQuery(this).closest('div.new_poi_wrapper').find('select').val(0);
		tbjQuery(this).closest('div.new_poi_wrapper').hide();
	})
	tbjQuery('a.new_poi_save_btn').click(function(){
		if( xhr != null ) {
			xhr.abort();
			xhr = null;
		}
		var btnObj = this;
		var postData = tbjQuery(this).parent('div.new_poi_wrapper').find('input').serialize();
		postData += "&"+tbjQuery(this).parent('div.new_poi_wrapper').find('select').serialize();
		
		if(tbjQuery(btnObj).hasClass('from')){
			postData += "&scope=from";
		}
		if(tbjQuery(btnObj).hasClass('to')){
			postData += "&scope=to";
		}
		
		xhr = tbjQuery.ajax({
			type: "POST"
			, url: BASE_URL+'index.php?option=com_taxibooking&controller=routes&task=addPOIAjax'
			, data: postData
			, dataType: 'json'
			//, async: false
			, beforeSend: function(){
				tbjQuery(btnObj).next('a.new_poi_cancel_btn').after('<img src="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/images/ajax-loader.gif" alt="Loading.." id="ajax_loader" />');
			}
			, complete: function(){
			}
			, success: function(response){
				tbjQuery('#ajax_loader').remove();
				
				if(response.error==0){
					tbjQuery(btnObj).closest('div.new_poi_wrapper').find('input').val('');
					tbjQuery(btnObj).closest('div.new_poi_wrapper').find('select').val(0);
					tbjQuery(btnObj).closest('div.new_poi_wrapper').hide();
					
					if(tbjQuery(btnObj).hasClass('from')){
						tbjQuery('#route_from').append(tbjQuery('<option>', {
							value: parseInt(response.poiObj.id),
							text: response.poiObj.title
						}));
						tbjQuery('#route_from').val(parseInt(response.poiObj.id));
					}
					if(tbjQuery(btnObj).hasClass('to')){
						tbjQuery('#route_to').append(tbjQuery('<option>', {
							value: parseInt(response.poiObj.id),
							text: response.poiObj.title
						}));
						tbjQuery('#route_to').val(parseInt(response.poiObj.id));
					}
				}
				else {
					alert(response.msg);
					return false;
				}
			}
		})
	})
})
Joomla.submitbutton = function(task)
{
    if (task == 'cancel' || document.formvalidator.isValid(document.id('adminForm')))
    {
	Joomla.submitform(task, document.getElementById('adminForm'));
    }
}

var map;
function initialize() {
	
	<?php  if($this->elsettings->default_country!="") {?>
	var options = {
	    componentRestrictions: {country: '<?php echo $this->default_country;?>'}
	};
	<?php } else { ?>
	var options = {};
	<?php } ?>
    
	var from_poi_input = document.getElementById('from_poi_title');
	var from_poi_autocomplete = new google.maps.places.Autocomplete(from_poi_input, options);
	google.maps.event.addListener(from_poi_autocomplete, 'place_changed', function() {
		var place = from_poi_autocomplete.getPlace();
		if (place.geometry) {
			document.getElementById('from_poi_lat').value = place.geometry.location.lat();
			document.getElementById('from_poi_lng').value = place.geometry.location.lng();
		}
	});
	
	var to_poi_input = document.getElementById('to_poi_title');
	var to_poi_autocomplete = new google.maps.places.Autocomplete(to_poi_input, options);
	google.maps.event.addListener(to_poi_autocomplete, 'place_changed', function() {
		var place = to_poi_autocomplete.getPlace();
		if (place.geometry) {
			document.getElementById('to_poi_lat').value = place.geometry.location.lat();
			document.getElementById('to_poi_lng').value = place.geometry.location.lng();
		}
	});
}

google.maps.event.addDomListener(window, 'load', initialize);
</script>
<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/routes.css" />

<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="adminform form-validate">

<div class="adminformWrap clearfix">
	<div class="adminform">
		<div class="inputWrap clearfix">
			<label for="title">
				<?php echo JText::_( 'TITLE' ).':'; ?>
			</label>
			<input type="text" name="title" value="<?php echo $this->item->title; ?>" class="inputbox required" maxlength="100" />
		</div>
		<div class="inputWrap clearfix">
			<label for="title">
				<?php echo JText::_( 'ALIAS' ).':'; ?>
			</label>
			<input type="text" name="alias" value="<?php echo $this->item->alias; ?>" class="inputbox" placeholder="<?php echo JText::_('JFIELD_ALIAS_PLACEHOLDER');?>" />
		</div>
		<div class="inputWrap clearfix">
			<label for="title">
				<span class="hasTip control-label" title="<?php echo JText::_('SPECIAL_ROUTES_FROM_POI_EXPLAIN'); ?>">
				<?php echo JText::_( 'FROM' ).':'; ?>
				</span>
			</label>
			<?php echo $this->lists['from_pois'];?> Or 
			<a href="javascript:void(0);" class="route_new_poi_trigger">
				<span class="hasTip control-label btn btn-small" title="<?php echo JText::_('SPECIAL_ROUTES_CREATE_NEW_POI_EXPLAIN'); ?>">
					<?php echo JText::_('SPECIAL_ROUTES_CREATE_NEW_POI');?>
				</span>
			</a>
		</div>
		
		<div class="new_poi_wrapper" style="display:none;">
			<div class="inputWrap clearfix">
				<label for="title">
					<?php echo JText::_( 'TITLE' ).':'; ?>
				</label>
				<input type="text" name="from_poi_title" id="from_poi_title" value="" class="inputbox" size="50" />
			</div>							
			<div class="inputWrap clearfix">
				<label for="title">
					<?php echo JText::_( 'LATITUDE' ).':'; ?>
				</label>
				<input type="text" name="from_poi_lat" id="from_poi_lat" value="" class="inputbox" />
			</div>	
			<div class="inputWrap clearfix">						
				<label for="published">
					<?php echo JText::_( 'LONGTITUDE' ).':'; ?>
				</label>
				<input type="text" name="from_poi_lng" id="from_poi_lng" value="" class="inputbox" />
			</div>	
			<div class="inputWrap clearfix">
				<label for="title">
					<span class="hasTip control-label" title="<?php echo JText::_('POI_CATEGORY_EXPLAIN'); ?>">
					<?php echo JText::_( 'POI_CATEGORY' ).':'; ?>
					</span>
				</label>
				<?php echo $this->lists['from_categories'];?>
			</div>	
			<div class="inputWrap clearfix">
				<label for="title">
					<?php echo JText::_( 'JFIELD_LANGUAGE_LABEL' ).':'; ?>
				</label>
				<?php echo $this->lists['from_languages'];?>
			</div>
			<div class="inputWrap clearfix">
				<label for="published">
					<span class="hasTip control-label" title="<?php echo JText::_('POI_ADDITIONAL_FIELD_EXPLAIN'); ?>">
					<?php echo JText::_( 'POI_ADDITIONAL_FIELD_LABEL' ).':'; ?>
					</span>
				</label>
				<input type="text" name="from_additional_fld_label" value="" class="inputbox" />
			</div>
			<div class="inputWrap clearfix">					
				<label for="published">
					<span class="hasTip control-label" title="<?php echo JText::_('POI_ADDITIONAL_CHARGE_EXPLAIN'); ?>">
					<?php echo JText::_( 'POI_ADDITIONAL_CHARGE' ).':'; ?>
					</span>
				</label>
				<input type="text" name="from_additional_charge" value="" class="inputbox" />
			</div>
			<div class="inputWrap published clearfix">
				<label for="published">
					<span class="hasTip control-label" title="<?php echo JText::_('POI_SHOW_ON_PICKUP_EXPLAIN'); ?>">
					<?php echo JText::_( 'SHOW_ON_PICKUP' ).':'; ?>
					</span>
				</label>
				<?php echo JHTML::_('select.booleanlist', 'from_show_on_pickup', 'class="inputbox"', 1 );?>
			</div>
			<div class="inputWrap published clearfix">
				<label for="published">
					<span class="hasTip control-label" title="<?php echo JText::_('POI_SHOW_ON_DROPOFF_EXPLAIN'); ?>">
					<?php echo JText::_( 'SHOW_ON_DROPOFF' ).':'; ?>
					</span>
				</label>
				<?php echo JHTML::_('select.booleanlist', 'from_show_on_dropoff', 'class="inputbox"', 1 );?>
			</div>
			
			<a class="btn btn-small new_poi_save_btn from" href="javascript:void(0);">
			<?php echo JText::_('JAPPLY');?>
			</a>
			<a class="btn btn-small new_poi_cancel_btn" href="javascript:void(0);">
			<?php echo JText::_('JCANCEl');?>
			</a>
		</div>
		
		<div class="inputWrap clearfix">
			<label for="published">
				<span class="hasTip control-label" title="<?php echo JText::_('SPECIAL_ROUTES_TO_POI_EXPLAIN'); ?>">
				<?php echo JText::_( 'TO' ).':'; ?>
				</span>
			</label>
			<?php echo $this->lists['to_pois'];?> Or 
			<a href="javascript:void(0);" class="route_new_poi_trigger">
				<span class="hasTip control-label btn btn-small" title="<?php echo JText::_('SPECIAL_ROUTES_CREATE_NEW_POI_EXPLAIN'); ?>">
					<?php echo JText::_('SPECIAL_ROUTES_CREATE_NEW_POI');?>
				</span>
			</a>
		</div>
		<div class="new_poi_wrapper" style="display:none;">
			<div class="inputWrap clearfix">
				<label for="title">
					<?php echo JText::_( 'TITLE' ).':'; ?>
				</label>
				<input type="text" name="to_poi_title" id="to_poi_title" value="" class="inputbox" size="50"  />
			</div>							
			<div class="inputWrap clearfix">
				<label for="title">
					<?php echo JText::_( 'LATITUDE' ).':'; ?>
				</label>
				<input type="text" name="to_poi_lat" id="to_poi_lat" value="" class="inputbox" />
			</div>	
			<div class="inputWrap clearfix">						
				<label for="published">
					<?php echo JText::_( 'LONGTITUDE' ).':'; ?>
				</label>
				<input type="text" name="to_poi_lng" id="to_poi_lng" value="" class="inputbox" />
			</div>	
			<div class="inputWrap clearfix">
				<label for="title">
					<span class="hasTip control-label" title="<?php echo JText::_('POI_CATEGORY_EXPLAIN'); ?>">
					<?php echo JText::_( 'POI_CATEGORY' ).':'; ?>
					</span>
				</label>
				<?php echo $this->lists['to_categories'];?>
			</div>	
			<div class="inputWrap clearfix">
				<label for="title">
					<?php echo JText::_( 'JFIELD_LANGUAGE_LABEL' ).':'; ?>
				</label>
				<?php echo $this->lists['to_languages'];?>
			</div>
			<div class="inputWrap clearfix">
				<label for="published">
					<span class="hasTip control-label" title="<?php echo JText::_('POI_ADDITIONAL_FIELD_EXPLAIN'); ?>">
					<?php echo JText::_( 'POI_ADDITIONAL_FIELD_LABEL' ).':'; ?>
					</span>
				</label>
				<input type="text" name="to_additional_fld_label" value="" class="inputbox" />
			</div>
			<div class="inputWrap clearfix">					
				<label for="published">
					<span class="hasTip control-label" title="<?php echo JText::_('POI_ADDITIONAL_CHARGE_EXPLAIN'); ?>">
					<?php echo JText::_( 'POI_ADDITIONAL_CHARGE' ).':'; ?>
					</span>
				</label>
				<input type="text" name="to_additional_charge" value="" class="inputbox" />
			</div>
			<div class="inputWrap published clearfix">
				<label for="published">
					<span class="hasTip control-label" title="<?php echo JText::_('POI_SHOW_ON_PICKUP_EXPLAIN'); ?>">
					<?php echo JText::_( 'SHOW_ON_PICKUP' ).':'; ?>
					</span>
				</label>
				<?php echo JHTML::_('select.booleanlist', 'to_show_on_pickup', 'class="inputbox"', 1 );?>
			</div>
			<div class="inputWrap published clearfix">
				<label for="published">
					<span class="hasTip control-label" title="<?php echo JText::_('POI_SHOW_ON_DROPOFF_EXPLAIN'); ?>">
					<?php echo JText::_( 'SHOW_ON_DROPOFF' ).':'; ?>
					</span>
				</label>
				<?php echo JHTML::_('select.booleanlist', 'to_show_on_dropoff', 'class="inputbox"', 1 );?>
			</div>
			
			<a class="btn btn-small new_poi_save_btn to" href="javascript:void(0);">
			<?php echo JText::_('JAPPLY');?>
			</a>
			<a class="btn btn-small new_poi_cancel_btn" href="javascript:void(0);">
			<?php echo JText::_('JCANCEl');?>
			</a>
		</div>
		
		<div class="inputWrap clearfix">
			<label for="title">
				<span class="hasTip control-label" title="<?php echo JText::_('SPECIAL_ROUTES_PRICE_EXPLAIN'); ?>">
				<?php echo JText::_( 'ROUTE_PRICE' ).':'; ?>
				</span>
			</label>
			<input type="text" name="price" value="<?php echo $this->item->price; ?>" class="inputbox"  maxlength="100" />
		</div>
		<div class="inputWrap clearfix">
			<label for="published">
				<?php echo JText::_( 'PUBLISHED' ).':'; ?>
			</label>
			<?php echo JHTML::_('select.booleanlist', 'published', 'class="inputbox"', $this->item->published );?>
		</div>
		<div class="inputWrap clearfix">
			<label for="published">
				<span class="hasTip control-label" title="<?php echo JText::_('SPECIAL_ROUTES_SEPARATE_PRICE_CARS_EXPLAIN'); ?>">
				<?php echo JText::_( 'SEPARATE_PRICE_CARS' ).':'; ?>
				</span>
			</label>
			<?php echo JHTML::_('select.booleanlist', 'separate_car_price', 'class="inputbox"', $this->item->separate_car_price );?>
		</div>					
	</div>
	<table class="adminform" id="cars_wrapper" style="display: <?php echo ($this->item->separate_car_price==1)?'block':'none';?>">
		<tr>
			<td colspan="2">
				
				<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
				<table class="table table-striped no-more-tables">
				<?php } else { ?>
				<table class="adminlist">
				<?php } ?>
				
					<thead>
						<tr>
							<th width="5"><?php echo JText::_( 'Num' ); ?></th>
							<th class="title"><?php echo JText::_('TITLE');?></th>
							<th class="numeric" width="20%"><?php echo JText::_( 'IMAGE' ); ?></th>
							<th class="numeric" width="5%"><?php echo JText::_( 'CAR_EDIT_MINIMUM_PASSENGERS' );?></th>
							<th class="numeric" width="5%"><?php echo JText::_( 'CAR_EDIT_MAXIMUM_PASSENGERS' );?></th>
							<th class="numeric" width="5%"><?php echo JText::_( 'SUITCASE_NO' );?></th>
							<th class="numeric" width="20%"><?php echo JText::_( 'PRICE' );?></th>
						</tr>
					</thead>
					<tbody>
						<?php 
						$k = 0;
						for ($i=0, $n=count($this->cars); $i < $n; $i++) {
							$row = $this->cars[$i];
						?>
						<tr class="<?php echo "row$k"; ?>">
							<td data-title="Number"><?php echo $i+1; ?></td>
							<td data-title="<?php echo JText::_('TITLE');?>" align="left">
							    <span><?php echo htmlspecialchars($row->title, ENT_QUOTES, 'UTF-8'); ?></span>
							</td>
							<td data-title="<?php echo JText::_( 'IMAGE' ); ?>" class="numeric" align="center">
							    <img src="<?php echo JURI::root().$row->image;?>" alt="<?php echo $row->title;?>" width="50" />
							</td>
							<td data-title="<?php echo JText::_( 'CAR_EDIT_MINIMUM_PASSENGERS' );?>" class="numeric" align="center">
								<?php echo $row->min_passenger_no; ?>
							</td>
							<td data-title="<?php echo JText::_( 'CAR_EDIT_MAXIMUM_PASSENGERS' );?>" class="numeric" align="center">
								<?php echo $row->passenger_no; ?>
							</td>
							<td data-title="<?php echo JText::_( 'SUITCASE_NO' );?>" class="numeric" align="center">
								<?php echo $row->suitcase_no; ?>
							</td>
							<td data-title="<?php echo JText::_( 'PRICE' );?>" class="numeric" align="center">
								<input type="text" name="car_prices[<?php echo $row->id;?>]" value="<?php echo isset($this->car_prices[$row->id]) ? $this->car_prices[$row->id] : 0;?>" />
							</td>
						</tr>
						<?php $k = 1 - $k; } ?>
					</tbody>
				</table>
			</td>
		</tr>
	</table>
	
	<div class="adminform editor">
		<label for="body">
			<?php echo JText::_( 'Description' ).':'; ?>
		</label>
		<?php
		// parameters : areaname, content, hidden field, width, height, rows, cols
		echo $this->editor->display( 'text',  $this->item->text, '100%;', '300', '35', '10', array('pagebreak') ) ;
		?>
	</div>
</div>

<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="option" value="com_taxibooking" />
<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
<input type="hidden" name="controller" value="routes" />
<input type="hidden" name="view" value="route" />
<input type="hidden" name="task" value="" />
</form>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>