<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * View class 
 */
class TaxibookingViewRoute extends JViewLegacy
{
	protected $item;
    
	protected $state;

	/**
	* Display the view
	*
	* @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	*
	* @return  void
	*/
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		$config = JFactory::getConfig();
		
		$this->elsettings 	= booking_helper::config();
		$this->item	= $this->get('Item');
		$this->cars     = $this->get( 'Cars' );
		$this->state	= $this->get('State');
		$isNew		= ($this->item->id == 0);
		$this->editor =  JFactory::getEditor();
	
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		//build selectlists
		$this->lists = $this->_buildEditLists($this->item);
		
		$this->car_prices = unserialize($this->item->car_prices);
		
		// get country 2 code for google autocomplete
		$country_2_code = booking_helper::get_country_field($this->elsettings->default_country, 'country_2_code');
		$country_2_code = ($country_2_code == '') ? 'US' : $country_2_code;
		$this->assignRef('default_country', $country_2_code);
		
		$this->addToolbar();

		parent::display($tpl);
	}
	
	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		JFactory::getApplication()->input->set('hidemainmenu', true);
	
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();
	
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
	    
		JToolbarHelper::title($isNew ? JText::_('COM_TAXIBOOKING_MANAGER_ROUTE_NEW') : JText::_('COM_TAXIBOOKING_MANAGER_ROUTE_EDIT'), 'generic');
		
		// If not checked out, can save the item.
		if (!$checkedOut)
		{
			JToolbarHelper::apply();
			JToolbarHelper::save();
		}
		
		JToolbarHelper::cancel();
	}
	
	/**
	 * Creates list
	 *
	 * @since 1.0
	 */
	private function _buildEditLists($item)
	{
                $db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_points');
		$query->where('published = "1"');
		$query->where('show_on_offers_pickup = 1');
		$query->order('title ASC');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
                
		$options = array();
                $options[] = JHTML::_('select.option',  0, JText::_( 'SELECT_POI' ) );
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option', (int) $row->id, $row->title );
			}
                }
                $lists['from_pois'] = JHTML::_('select.genericlist', $options, 'route_from', '', 'value', 'text', (int)$item->route_from );
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_points');
		$query->where('published = "1"');
		$query->where('show_on_offers_dropoff = 1');
		$query->order('title ASC');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
                
		$options = array();
                $options[] = JHTML::_('select.option',  0, JText::_( 'SELECT_POI' ) );
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option', (int) $row->id, $row->title );
			}
                }
		$lists['to_pois'] = JHTML::_('select.genericlist', $options, 'route_to', '', 'value', 'text', (int)$item->route_to );
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_poicats');
		$query->where('published = "1"');
		$query->order('ordering ASC');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
                
		$options = array();
                $options[] = JHTML::_('select.option',  '', JText::_( 'CATEGORY' ) );
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->id, $row->title );
			}
                }
                $lists['from_categories'] = JHTML::_('select.genericlist', $options, 'from_poi_catid', '', 'value', 'text', 0 );
		$lists['to_categories'] = JHTML::_('select.genericlist', $options, 'to_poi_catid', '', 'value', 'text', 0 );
		
		$options = array();
                $options[] = JHTML::_('select.option',  '*', JText::_( 'JALL' ) );
		$rows = JHtml::_('contentlanguage.existing');
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->value, $row->text);
			}
                }
                $lists['from_languages'] = JHTML::_('select.genericlist', $options, 'from_poi_language', '', 'value', 'text', '*' );
		$lists['to_languages'] = JHTML::_('select.genericlist', $options, 'to_poi_language', '', 'value', 'text', '*' );
		
		return $lists;
	}
}