<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('behavior.calendar');
?>
<style type="text/css">
    
    /* Tooltips */
    .tip-wrap {max-width: 300px !important}  
</style>
<script language="javascript" type="text/javascript">
Joomla.submitbutton = function(task)
{
    if (task == 'cancel' || document.formvalidator.isValid(document.id('adminForm')))
    {
	Joomla.submitform(task, document.getElementById('adminForm'));
    }
}
</script>

<?php
$hr_options = array();
for($i = 0; $i <= 23; $i++){
	$value = str_pad($i, 2, '0', STR_PAD_LEFT);
    $hr_options[$value] = $value;
}

$min_options = array();
for($i = 0; $i <= 59; $i=$i+5){
	$value = str_pad($i, 2, '0', STR_PAD_LEFT);
    $min_options[$value] = $value;
}

$ynoptions = array(
	JHtml::_('select.option', 1, JText::_('JYES')),
	JHtml::_('select.option', 0, JText::_('JNO'))
);
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/searchurls.css" />
<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o&v=3.exp&libraries=places"></script>
<?php if(version_compare(JVERSION,'3.1.5','le')) {?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<?php } ?>

<script type="text/javascript">
var xhr = null;
var tbjQuery = jQuery.noConflict( );
var BASE_URL = '<?php echo JURI::base();?>';
var page_mode = '<?php echo ($this->item->id > 0) ? 'edit' : 'add' ?>';
var loader = '<img id="loading" src="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/images/ajax-loader.gif" alt="Loading.." />';
var selected_shuttle_dropoff_poi = <?php echo $this->item->shuttle_dropoff_poi;?>;
var selected_shuttle_pickup_time = '<?php echo $this->item->shuttletime;?>';
var selected_shuttle_passengers = '<?php echo $this->item->shuttle_passengers;?>';
var show_return_extras = '<?php echo $this->elsettings->show_return_extras;?>';

function reloadShuttleDropoff()
{
    tbjQuery.ajax({
	type: "POST"
	, url: 'index.php?option=com_taxibooking&controller=searchurls&task=getShuttleTimeOptions'
	, data: tbjQuery('#shuttle_pickup_date').serialize()+'&shuttle_pickup_poi='+tbjQuery('#shuttle_pickup_poi').val()+'&shuttle_dropoff_poi='+tbjQuery('#shuttle_dropoff_poi').val()+'&shuttle_pickup_time='+selected_shuttle_pickup_time
	, dataType: 'json'
	, async: false
	, beforeSend: function(){
	    tbjQuery('#shuttle_pickup_date').after(loader);
	}
	, complete: function(){
	}
	, success: function(response){
	    tbjQuery('#shuttle_pickup_date').next('#loading').remove();
	    if(response.error==0)
	    {
		tbjQuery('div#shuttle_time_wrapper').html(response.msg);
		
		if(selected_shuttle_passengers>0){
		    var available_seats = tbjQuery('input:radio[name="shuttletime"]:checked').parent().data('seats');
		    var passenger_list = tbjQuery('<select class="shuttle-passengers-list" name="shuttle_passengers">');
		    passenger_list.append(jQuery("<option>").attr({value: 0}).text('<?php echo JText::_('JSELECT');?>'));
		    for(var i = 1; i <= parseInt(available_seats); i++){
			var selected = (i==selected_shuttle_passengers) ? true : false;
			passenger_list.append(jQuery("<option>").attr({value: i, selected: selected}).text(i));
		    }
		    tbjQuery('div#shuttle_passengers_wrap').html(passenger_list);
		}
	    }
	}
    })
}

function generateDynamicParamsURL()
{
    var temp_params = '';
    tbjQuery('div#dynamic_params_wrapper div.date_price').each(function(index){
	if(tbjQuery(this).find('.dynamic_param_key').val()!="" && tbjQuery(this).find('.dynamic_param_value').val()!=""){
	    temp_params += tbjQuery.trim(tbjQuery(this).find('.dynamic_param_key').val())+'='+tbjQuery.trim(tbjQuery(this).find('.dynamic_param_value').val())+'&';
	}
    })
    temp_params = temp_params.substring(0, temp_params.length - 1);
    return temp_params;
}
function generateCustomFieldParamsURL()
{
    var temp_params = '';
    tbjQuery('input.extra, select.extra').each(function(index){
	if(tbjQuery(this).val()!="" && tbjQuery(this).val()!="0"){
	    temp_params += tbjQuery.trim(tbjQuery(this).attr('name'))+'='+tbjQuery.trim(encodeURIComponent(tbjQuery(this).val()))+'&';
	}
    })
    temp_params = temp_params.substring(0, temp_params.length - 1);
    return temp_params;
}
function regenerateURL()
{
    var generated_url = '<?php echo $this->booking_form_url;?>';
    var booking_type = tbjQuery('#booking_type').val();
    
    <?php if($this->sef_enabled==1){ ?>
    generated_url += '?';
    <?php } else{ ?>
    generated_url += '&';
    <?php } ?>
    
    generated_url += 'booking_type='+booking_type;
    
    if(booking_type=="address"){
	generated_url += '&pickup_type='+tbjQuery('#pickup_type').val();
	if(tbjQuery('#pickup_type').val()=='poi'){
	    generated_url += '&pickup_poi='+tbjQuery('#pickup_poi').val();
	}
	else {
	    generated_url += '&pickup_address='+encodeURIComponent(tbjQuery('#pickup_address').val());
	    generated_url += '&pickup_lat='+tbjQuery('#pickup_lat').val();
	    generated_url += '&pickup_lng='+tbjQuery('#pickup_lng').val();
	}
	generated_url += '&dropoff_type='+tbjQuery('#dropoff_type').val();
	if(tbjQuery('#dropoff_type').val()=='poi'){
	    generated_url += '&dropoff_poi='+tbjQuery('#dropoff_poi').val();
	}
	else {
	    generated_url += '&dropoff_address='+encodeURIComponent(tbjQuery('#dropoff_address').val());
	    generated_url += '&dropoff_lat='+tbjQuery('#dropoff_lat').val();
	    generated_url += '&dropoff_lng='+tbjQuery('#dropoff_lng').val();
	}
    }
    else if(booking_type=="offers"){
	//generated_url += '&route_pickup_category='+tbjQuery('#route_pickup_category').val();
	//generated_url += '&route_pickup_poi='+tbjQuery('#route_pickup_poi').val();
	//generated_url += '&route_dropoff_category='+tbjQuery('#route_dropoff_category').val();
	//generated_url += '&route_dropoff_poi='+tbjQuery('#route_dropoff_poi').val();
	generated_url += '&route_pickup_category='+tbjQuery('#route_id').find(':selected').data('pickuppoicat');
	generated_url += '&route_pickup_poi='+tbjQuery('#route_id').find(':selected').data('pickup');
	generated_url += '&route_dropoff_category='+tbjQuery('#route_id').find(':selected').data('dropoffpoicat');
	generated_url += '&route_dropoff_poi='+tbjQuery('#route_id').find(':selected').data('dropoff');
    }
    else if(booking_type=="hourly"){
	generated_url += '&hourly_hr='+tbjQuery('#hourly_hr').val();
	generated_url += '&hourly_min='+tbjQuery('#hourly_min').val();
    }
    else if(booking_type=="shuttle"){
	var pickup_time = 0;
	if(tbjQuery('[name="shuttletime"]:checked').length>0){
	    pickup_time = tbjQuery('[name="shuttletime"]:checked').val();
	}
	generated_url += '&shuttle_pickup_poi='+tbjQuery('#shuttle_pickup_poi').val();
	generated_url += '&shuttle_dropoff_poi='+tbjQuery('#shuttle_dropoff_poi').val();
	generated_url += '&shuttle_pickup_date='+tbjQuery('#shuttle_pickup_date').val();
	generated_url += '&pickup_time='+pickup_time;
	generated_url += '&shuttle_passengers='+tbjQuery('[name="shuttle_passengers"]').val();
    }
    if(booking_type!="shuttle"){
	generated_url += '&pickup_date='+tbjQuery('#pickup_date').val();
	generated_url += '&pickup_hr='+tbjQuery('#pickup_hr').val();
	generated_url += '&pickup_min='+tbjQuery('#pickup_min').val();
	generated_url += '&passenger='+tbjQuery('#passengers').val();
	generated_url += '&suitcases='+tbjQuery('#suitcases').val();
	generated_url += '&infantseats='+tbjQuery('#infantseats').val();
	generated_url += '&childseats='+tbjQuery('#childseats').val();
	generated_url += '&boosterseats='+tbjQuery('#boosterseats').val();
    }
    if(booking_type!="hourly"&&booking_type!="shuttle"){
	generated_url += '&return='+tbjQuery('[name="returntrip"]:checked').val();
	generated_url += '&return_date='+tbjQuery('#return_date').val();
	generated_url += '&return_hr='+tbjQuery('#return_hr').val();
	generated_url += '&return_min='+tbjQuery('#return_min').val();
    }
    
    generated_url += '&coupons='+tbjQuery('#coupons').val();
    
    // append dynamic params
    var temp_params = generateDynamicParamsURL();
    var field_params = generateCustomFieldParamsURL();
    
    tbjQuery('#generated_url').val(generated_url+'&'+field_params+'&'+temp_params);
}

tbjQuery(document).ready(function(){
    
    tbjQuery('#generate-anchor-html-btn').click(function(){
	if(page_mode=='add'){
	    var html = '&lt;a href=&quot;'+tbjQuery('#generated_url').val()+'&quot; target=&quot;blank&quot;&gt;';
	}
	else {
	    if(tbjQuery('#short_url').val()!=""){
		var html = '&lt;a href=&quot;'+tbjQuery('#short_url').val()+'&quot; target=&quot;blank&quot;&gt;';
	    }
	    else {
		var html = '&lt;a href=&quot;'+tbjQuery('#generated_url').val()+'&quot; target=&quot;blank&quot;&gt;';
	    }
	}
	if(tbjQuery('#anchor_text').val()!=""){
	    html += tbjQuery('#anchor_text').val()+'&lt;/a&gt;';
	}
	else if(tbjQuery('input[name="title"]').val()!="") {
	    html += tbjQuery('input[name="title"]').val()+'&lt;/a&gt;';
	}
	else {
	    html += 'Anchor&lt;/a&gt;';
	}
	tbjQuery('#anchor_text_html').html(html);
    })
    // collect extra list
    tbjQuery.fn.getExtras = function(type, poiid) {
	if (typeof poiid == 'undefined') {
	    poiid = 0;
	}
        var passingData = 'type='+type+'&poiid='+poiid+'&lang='+tbjQuery('#language').val();
	
	if(page_mode=='edit'){
	    passingData += '&id=<?php echo $this->item->id;?>';
	}
        tbjQuery.ajax({
	    type: "POST",
	    url: BASE_URL+'index.php?option=com_taxibooking&controller=searchurls&task=getExtraListAjax',
	    data: passingData,
	    dataType: 'json',
	    async: false,
	    beforeSend: function(){
		// load the ajax loading image
		if(type=='pickup' || type=='address_pickup'){
		    tbjQuery('div#pickup_extra_wrapper').html(loader);   
		}
		else if(type=='dropoff' || type=='address_dropoff'){
		    tbjQuery('div#dropoff_extra_wrapper').html(loader);
		}
		else if(type=='route_pickup'){
		    tbjQuery('div#routefrom_extra_wrapper').html(loader);   
		}
		else if(type=='route_dropoff'){
		    tbjQuery('div#routeto_extra_wrapper').html(loader);
		}
		else if(type=='hourly_hire'){
		    tbjQuery('div#hourly_extra_wrapper').html(loader);
		}
		else if(type=='user_details'){
		    tbjQuery('div#user_details_extra_wrapper').html(loader);
		}
	    },
	    complete: function(){
	    },
	    success: function(response){
		// clear out the ajax loading image
		tbjQuery('#loading').remove();
		if(response.error==0)
		{
		    if(type=='pickup' || type=='address_pickup'){
			tbjQuery('div#pickup_extra_wrapper').html(response.msg);   
		    }
		    else if(type=='dropoff' || type=='address_dropoff'){
			tbjQuery('div#dropoff_extra_wrapper').html(response.msg);
		    }
		    else if(type=='route_pickup'){
			tbjQuery('div#routefrom_extra_wrapper').html(response.msg);   
		    }
		    else if(type=='route_dropoff'){
			tbjQuery('div#routeto_extra_wrapper').html(response.msg);
		    }
		    else if(type=='hourly_hire'){
			tbjQuery('div#hourly_extra_wrapper').html(response.msg);
		    }
		    else if(type=='user_details'){
			tbjQuery('div#user_details_extra_wrapper').html(response.msg);
		    }
		}
	    }
        });
    }
    
    // collect coupons
    tbjQuery.fn.getCoupons = function() {
	
        var passingData = 'booking_type='+tbjQuery('#booking_type').val()+'&lang='+tbjQuery('#language').val();
	
	if(page_mode=='edit'){
	    passingData += '&id=<?php echo $this->item->id;?>';
	}
        tbjQuery.ajax({
	    type: "POST",
	    url: BASE_URL+'index.php?option=com_taxibooking&controller=searchurls&task=getCouponsAjax',
	    data: passingData,
	    dataType: 'json',
	    async: false,
	    beforeSend: function(){
		// load the ajax loading image
		tbjQuery('div#coupons_wrapper').html(loader);
	    },
	    complete: function(){
	    },
	    success: function(response){
		// clear out the ajax loading image
		tbjQuery('#loading').remove();
		if(response.error==0)
		{
		    tbjQuery('div#coupons_wrapper').html(response.msg);
		}
	    }
        });
    }
    
    tbjQuery.fn.getCoupons();
    tbjQuery('#language').change(function(){
	window.location="<?php echo $this->edit_url;?>&lang="+tbjQuery(this).val();
    })
    
    // not allowing language swtiching while editing for now, we will think more later
    if(page_mode=='edit'){
	tbjQuery('#language').attr('disabled', true);
    }
    
    var booking_type = tbjQuery('#booking_type').val();
    tbjQuery('div.inputWrap.address_feature,div.inputWrap.offers_feature,div.inputWrap.hourly_feature,div.inputWrap.shuttle_feature').hide();
    tbjQuery('div.inputWrap.'+booking_type+'_feature').show();
    
    if(booking_type=='shuttle'){
	tbjQuery('#passengers,#suitcases,#infantseats,#childseats,#boosterseats').val(0);
	tbjQuery('div.inputWrap.nonshuttle_feature,div.inputWrap.return_feature,div.inputWrap.nonshuttle_date').hide();
	tbjQuery('div.inputWrap.shuttle_date').show();
    }
    else {
	if(booking_type=='hourly'){
	    tbjQuery('div.inputWrap.return_feature').hide();
	}
	else {
	    tbjQuery('div.inputWrap.return_feature').show();
	    if(parseInt(tbjQuery('input[name="returntrip"]:checked').val())==0){
		tbjQuery('div.inputWrap#returnWrap').hide();
	    }
	    else {
		// if show return extras is set to YES
		if(show_return_extras==1)
		{
		    var passingData = 'booking_type='+tbjQuery('#booking_type').val()+'&lang='+tbjQuery('#language').val();
		    if(tbjQuery('#booking_type').val()=='address'){
			passingData += '&pickup_type='+tbjQuery('#pickup_type').val()+'&pickup_poi='+tbjQuery('#pickup_poi').val()+'&pickup_address='+tbjQuery('#pickup_address').val();
			passingData += '&dropoff_type='+tbjQuery('#dropoff_type').val()+'&dropoff_poi='+tbjQuery('#dropoff_poi').val()+'&dropoff_address='+tbjQuery('#dropoff_address').val();
		    }
		    else if(tbjQuery('#booking_type').val()=='offers'){
			passingData += '&route_from='+tbjQuery('#route_pickup_poi').val()+'&route_to='+tbjQuery('#route_dropoff_poi').val();
		    }
		    if(page_mode=='edit'){
			passingData += '&id=<?php echo $this->item->id;?>';
		    }
		    tbjQuery.ajax({
			type: "POST",
			url: BASE_URL+'index.php?option=com_taxibooking&controller=searchurls&task=getReturnExtraListAjax',
			data: passingData,
			dataType: 'json',
			async: false,
			beforeSend: function(){
			    tbjQuery('div#return_extra_wrapper').html(loader);
			},
			complete: function(){
			},
			success: function(response){
			    tbjQuery('#loading').remove();
			    if(response.error==0)
			    {
				tbjQuery('div#return_extra_wrapper').html(response.msg);   
			    }
			}
		    });
		}
	    }
	}
	tbjQuery('div.inputWrap.nonshuttle_feature').show();
	tbjQuery('div.inputWrap.shuttle_date').hide();
	tbjQuery('div.inputWrap.nonshuttle_date').show();
    }
    
    if(booking_type=='address'){
	if(tbjQuery('#pickup_type').val()=='poi'){
	    tbjQuery('#pickup_poi').parent('div.inputWrap').show();
	    tbjQuery('#pickup_address,#pickup_lat,#pickup_lng').parent('div.inputWrap').hide();
	}
	else {
	    tbjQuery('#pickup_poi').parent('div.inputWrap').hide();
	    tbjQuery('#pickup_address,#pickup_lat,#pickup_lng').parent('div.inputWrap').show();
	}
	if(tbjQuery('#dropoff_type').val()=='poi'){
	    tbjQuery('#dropoff_poi').parent('div.inputWrap').show();
	    tbjQuery('#dropoff_address,#dropoff_lat,#dropoff_lng').parent('div.inputWrap').hide();
	}
	else {
	    tbjQuery('#dropoff_poi').parent('div.inputWrap').hide();
	    tbjQuery('#dropoff_address,#dropoff_lat,#dropoff_lng').parent('div.inputWrap').show();
	}
    }
    // show custom fields on edit more
    if(page_mode=='edit'){
	if(booking_type=='address'){
	    if(tbjQuery('#pickup_type').val()=='poi' && parseInt(tbjQuery('#pickup_poi').val()) > 0){
		tbjQuery.fn.getExtras('pickup', tbjQuery('#pickup_poi').val());
	    }
	    else if(tbjQuery('#pickup_type').val()=='address' && tbjQuery('#pickup_address').val()!="") {
		tbjQuery.fn.getExtras('address_pickup');
	    }
	    if(tbjQuery('#dropoff_type').val()=='poi' && parseInt(tbjQuery('#dropoff_poi').val()) > 0){
		tbjQuery.fn.getExtras('dropoff', tbjQuery('#dropoff_poi').val());
	    }
	    else if(tbjQuery('#dropoff_type').val()=='address' && tbjQuery('#dropoff_address').val()!="") {
		tbjQuery.fn.getExtras('address_dropoff');
	    }
	}
	else if(booking_type=='offers'){
		var route_pickup_poi = tbjQuery('#route_id').find(':selected').data('pickup');
		var route_dropoff_poi = tbjQuery('#route_id').find(':selected').data('dropoff');
		tbjQuery.fn.getExtras('route_pickup', route_pickup_poi);
		tbjQuery.fn.getExtras('route_dropoff', route_dropoff_poi);
	}
	else if(booking_type=='hourly'){
	    if(parseInt(tbjQuery('#hourly_hr').val()) > 0 || parseInt(tbjQuery('#hourly_min').val()) > 0){
		tbjQuery.fn.getExtras('hourly_hire');
	    }
	}
    }
    tbjQuery('#booking_type').change(function(){
	var booking_type = tbjQuery(this).val();
	
	//tbjQuery('div.inputWrap.address_feature,div.inputWrap.offers_feature,div.inputWrap.hourly_feature,div.inputWrap.shuttle_feature').find('input').val("");
	//tbjQuery('div.inputWrap.address_feature,div.inputWrap.offers_feature,div.inputWrap.hourly_feature,div.inputWrap.shuttle_feature').find('select').val(0);
	tbjQuery('div.inputWrap.address_feature,div.inputWrap.offers_feature,div.inputWrap.hourly_feature,div.inputWrap.shuttle_feature').hide();
	tbjQuery('div.inputWrap.'+booking_type+'_feature').show();
	
	if(booking_type=='shuttle'){
	    tbjQuery('#passengers,#suitcases,#infantseats,#childseats,#boosterseats').val(0);
	    tbjQuery('div.inputWrap.nonshuttle_feature,div.inputWrap.return_feature,div.inputWrap.nonshuttle_date').hide();
	    tbjQuery('div.inputWrap.shuttle_date').show();
	}
	else {
	    if(booking_type=='hourly'){
		tbjQuery('div.inputWrap.return_feature').hide();
	    }
	    else {
		tbjQuery('div.inputWrap.return_feature').show();
		tbjQuery('div.inputWrap#returnWrap').hide();
	    }
	    
	    if(booking_type=='address'){
		if(tbjQuery('#pickup_type').val()=='poi'){
		    tbjQuery('#pickup_poi').parent('div.inputWrap').show();
		    tbjQuery('#pickup_address,#pickup_lat,#pickup_lng').parent('div.inputWrap').hide();
		}
		else {
		    tbjQuery('#pickup_poi').parent('div.inputWrap').hide();
		    tbjQuery('#pickup_address,#pickup_lat,#pickup_lng').parent('div.inputWrap').show();
		}
		if(tbjQuery('#dropoff_type').val()=='poi'){
		    tbjQuery('#dropoff_poi').parent('div.inputWrap').show();
		    tbjQuery('#dropoff_address,#dropoff_lat,#dropoff_lng').parent('div.inputWrap').hide();
		}
		else {
		    tbjQuery('#dropoff_poi').parent('div.inputWrap').hide();
		    tbjQuery('#dropoff_address,#dropoff_lat,#dropoff_lng').parent('div.inputWrap').show();
		}
	    }
	    tbjQuery('div.inputWrap.nonshuttle_feature,div.inputWrap.nonshuttle_date').show();
	    tbjQuery('div.inputWrap.shuttle_date').hide();
	    tbjQuery('#shuttle_pickup_date').val('');
	    tbjQuery('div#shuttle_time_wrap').html('');
	}
	
	// clears out all extras
	tbjQuery('div#pickup_extra_wrapper,div#dropoff_extra_wrapper,div#routefrom_extra_wrapper,div#routeto_extra_wrapper,div#hourly_extra_wrapper').html("");
	
	tbjQuery.fn.getCoupons();
    })
    
    tbjQuery('#pickup_type').change(function(){
	if(tbjQuery(this).val()=='poi'){
	    tbjQuery('#pickup_poi').parent('div.inputWrap').show();
	    tbjQuery('#pickup_address,#pickup_lat,#pickup_lng').parent('div.inputWrap').hide();
	}
	else {
	    tbjQuery('#pickup_poi').parent('div.inputWrap').hide();
	    tbjQuery('#pickup_address,#pickup_lat,#pickup_lng').parent('div.inputWrap').show();
	}
	tbjQuery('div#pickup_extra_wrapper').html("");   
    })
    tbjQuery('#dropoff_type').change(function(){
	if(tbjQuery(this).val()=='poi'){
	    tbjQuery('#dropoff_poi').parent('div.inputWrap').show();
	    tbjQuery('#dropoff_address,#dropoff_lat,#dropoff_lng').parent('div.inputWrap').hide();
	}
	else {
	    tbjQuery('#dropoff_poi').parent('div.inputWrap').hide();
	    tbjQuery('#dropoff_address,#dropoff_lat,#dropoff_lng').parent('div.inputWrap').show();
	}
	tbjQuery('div#dropoff_extra_wrapper').html("");  
    })
    tbjQuery('#pickup_poi').change(function(){
	tbjQuery.fn.getExtras('pickup', tbjQuery(this).val());
    })
    tbjQuery('#dropoff_poi').change(function(){
	tbjQuery.fn.getExtras('dropoff', tbjQuery(this).val());
    })
    tbjQuery('#route_pickup_category').change(function(){
	if( xhr != null ) {
		xhr.abort();
		xhr = null;
	}
	xhr = tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&controller=searchurls&task=getRoutePOIList'
	    , data: tbjQuery(this).serialize()+'&lang='+tbjQuery('#language').val()
	    , dataType: 'json'
	    , async: false
	    , beforeSend: function(){
		tbjQuery('div#routefrom_extra_wrapper,div#routeto_extra_wrapper').html("");   
		tbjQuery('#route_pickup_category').after(loader);
		tbjQuery('#route_pickup_poi').val(0);
		tbjQuery('#route_dropoff_category').val(0);
		tbjQuery('#route_dropoff_poi').val(0);
	    }
	    , complete: function(){
	    }
	    , success: function(response){
		tbjQuery('#route_pickup_category').next('#loading').remove();
		if(response.error==0)
		{
		    tbjQuery('div#route_pickup_wrap').html(response.msg);
		}
	    }
	})
    })
    tbjQuery(document).on("change", '#route_pickup_poi', function (e) {
	if( xhr != null ) {
		xhr.abort();
		xhr = null;
	}
	var route_pickup_poi = tbjQuery(this).val();
	xhr = tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&controller=searchurls&task=getRouteDropoffCategory'
	    , data: tbjQuery(this).serialize()+'&lang='+tbjQuery('#language').val()
	    , dataType: 'json'
	    , async: false
	    , beforeSend: function(){
		tbjQuery('div#routefrom_extra_wrapper,div#routeto_extra_wrapper').html("");
		tbjQuery('#route_pickup_poi').after(loader);
		tbjQuery('#route_dropoff_category').val(0);
		tbjQuery('#route_dropoff_poi').val(0);
	    }
	    , complete: function(){
	    }
	    , success: function(response){
		tbjQuery('#route_pickup_poi').next('#loading').remove();
		if(response.error==0)
		{
		    tbjQuery.fn.getExtras('route_pickup', route_pickup_poi);
		    tbjQuery('div#route_dropoff_category_wrap').html(response.msg);
		}
	    }
	})
    })
    tbjQuery(document).on("change", '#route_dropoff_category', function (e) {
	if( xhr != null ) {
		xhr.abort();
		xhr = null;
	}
	xhr = tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&controller=searchurls&task=getRoutePOIList'
	    , data: tbjQuery(this).serialize()+'&route_from='+tbjQuery('#route_pickup_poi').val()+'&lang='+tbjQuery('#language').val()
	    , dataType: 'json'
	    , async: false
	    , beforeSend: function(){
		tbjQuery('div#routeto_extra_wrapper').html("");   
		tbjQuery('#route_dropoff_category').after(loader);
		tbjQuery('#route_dropoff_poi').val(0);
	    }
	    , complete: function(){
	    }
	    , success: function(response){
		tbjQuery('#route_dropoff_category').next('#loading').remove();
		if(response.error==0)
		{
		    tbjQuery('div#route_dropoff_wrap').html(response.msg);
		}
	    }
	})
    })
    tbjQuery(document).on("change", '#route_dropoff_poi', function (e) {
	var route_dropoff_poi = tbjQuery(this).val();
	tbjQuery.fn.getExtras('route_dropoff', route_dropoff_poi);
    })
    tbjQuery(document).on("change", '#route_id', function (e) {
	var route_pickup_poi = tbjQuery(this).find(':selected').data('pickup');
	var route_dropoff_poi = tbjQuery(this).find(':selected').data('dropoff');
	tbjQuery.fn.getExtras('route_pickup', route_pickup_poi);
	tbjQuery.fn.getExtras('route_dropoff', route_dropoff_poi);
    })
    tbjQuery("#hourly_hr, #hourly_min").change(function(){
	tbjQuery.fn.getExtras('hourly_hire');
    })
    tbjQuery(document).on("change", 'input.extra, select.extra', function (e) {
	regenerateURL();
    })
    tbjQuery.fn.getShuttleDropoffPOIs = function() { 
	tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&controller=searchurls&task=getShuttleDropoffPOIs'
	    , data: tbjQuery('#shuttle_pickup_poi').serialize()+'&shuttle_dropoff_poi='+selected_shuttle_dropoff_poi
	    , dataType: 'json'
	    , async: false
	    , beforeSend: function(){
		tbjQuery('#shuttle_pickup_poi').after(loader);
	    }
	    , complete: function(){
	    }
	    , success: function(response){
		tbjQuery('#shuttle_pickup_poi').next('#loading').remove();
		if(response.error==0)
		{
		    tbjQuery('div#shuttle_dropoff_poi_wrap').html(response.msg);
		}
	    }
	})
    }
    tbjQuery('#shuttle_pickup_poi').change(function(){
	tbjQuery.fn.getShuttleDropoffPOIs();
    })
    if(booking_type=='shuttle'){
	tbjQuery.fn.getShuttleDropoffPOIs();
	reloadShuttleDropoff();
    }
    tbjQuery('input[name="returntrip"]').click(function(){
	var returntrip = tbjQuery(this).val();
	if(returntrip==1){
	    tbjQuery('div.inputWrap#returnWrap').show();
	    
	    // if show return extras is set to YES
	    if(show_return_extras==1)
	    {
		var passingData = 'booking_type='+tbjQuery('#booking_type').val()+'&lang='+tbjQuery('#language').val();
		if(tbjQuery('#booking_type').val()=='address'){
		    passingData += '&pickup_type='+tbjQuery('#pickup_type').val()+'&pickup_poi='+tbjQuery('#pickup_poi').val()+'&pickup_address='+tbjQuery('#pickup_address').val();
		    passingData += '&dropoff_type='+tbjQuery('#dropoff_type').val()+'&dropoff_poi='+tbjQuery('#dropoff_poi').val()+'&dropoff_address='+tbjQuery('#dropoff_address').val();
		}
		else if(tbjQuery('#booking_type').val()=='offers'){
		    passingData += '&route_from='+tbjQuery('#route_pickup_poi').val()+'&route_to='+tbjQuery('#route_dropoff_poi').val();
		}
		if(page_mode=='edit'){
		    passingData += '&id=<?php echo $this->item->id;?>';
		}
		tbjQuery.ajax({
		    type: "POST",
		    url: BASE_URL+'index.php?option=com_taxibooking&controller=searchurls&task=getReturnExtraListAjax',
		    data: passingData,
		    dataType: 'json',
		    async: false,
		    beforeSend: function(){
			tbjQuery('div#return_extra_wrapper').html(loader);
		    },
		    complete: function(){
		    },
		    success: function(response){
			tbjQuery('#loading').remove();
			if(response.error==0)
			{
			    tbjQuery('div#return_extra_wrapper').html(response.msg);   
			}
		    }
		});
	    }
	}
	else {
	    tbjQuery('div#return_extra_wrapper').html("");
	    tbjQuery('div.inputWrap#returnWrap').hide();
	}
    })
    tbjQuery(document).on("click", 'input:radio[name="shuttletime"]', function (e) {
	var available_seats = tbjQuery('input:radio[name="shuttletime"]:checked').parent().data('seats');
	
	var passenger_list = tbjQuery('<select class="shuttle-passengers-list" name="shuttle_passengers">');
	passenger_list.append(jQuery("<option>").attr({value: 0}).text('<?php echo JText::_('JSELECT');?>'));
	for(var i = 1; i <= parseInt(available_seats); i++){
	    passenger_list.append(jQuery("<option>").attr({value: i}).text(i));
	}
	tbjQuery('div#shuttle_passengers_wrap').html(passenger_list);
    })
    tbjQuery(document).on("change", '[name="shuttle_passengers"]', function (e) {
	regenerateURL();
    })
    tbjQuery(document).on("change", '.booking_param', function (e) {
	regenerateURL();
    })
    tbjQuery(document).on("change", 'input.dynamic_param_key,input.dynamic_param_value', function (e) {
	var generated_url = tbjQuery('#generated_url').val();
	
	if (generated_url.indexOf("booking_type") >= 0){
	    regenerateURL();
	}
	else {
	    generated_url = '<?php echo $this->booking_form_url;?>';
	    <?php if($this->sef_enabled==1){ ?>
	    generated_url += '?';
	    <?php } else{ ?>
	    generated_url += '&';
	    <?php } ?>
	    
	    // append dynamic params
	    var temp_params = generateDynamicParamsURL();
	    var field_params = generateCustomFieldParamsURL();
	    tbjQuery('#generated_url').val(generated_url+field_params+'&'+temp_params);
	}
    })
    
    tbjQuery('#add_param').click(function(){
	var i = tbjQuery('div#dynamic_params_wrapper div.date_price').length;
	var html = '';
	
html += '<div class="date_price row'+i+' clearfix">'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DYNAMIC_PARAM_KEY_EXPLAIN'); ?>">'+
			'<?php echo JText::_( 'SEARCHURL_DYNAMIC_PARAM_KEY' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox dynamic_param_key" type="text" name="dynamic_param_key['+i+']" value="" />'+
	    '</div>'+
	    '<div class="inputwrap clearfix">'+
		'<label>'+
		    '<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DYNAMIC_PARAM_VALUE_EXPLAIN'); ?>">'+
			'<?php echo JText::_( 'SEARCHURL_DYNAMIC_PARAM_VALUE' ).':'; ?>'+
		    '</span>'+
		'</label>'+
		'<input class="inputbox dynamic_param_value" type="text" name="dynamic_param_value['+i+']" value="" />'+
	    '</div>'+
	    '<div class="button2-left">'+
		    '<div class="blank">'+
			    '<a href="javascript:void(0);" class="btn btn-small remove_param"><?php echo JText::_('REMOVE'); ?></a>'+
		    '</div>'+
	    '</div>'+
    '</div>';
    
	tbjQuery('div#dynamic_params_wrapper').append(html);
	tbjQuery('html, body').animate({ scrollTop: tbjQuery('div#dynamic_params_wrapper div.date_price:last-child').offset().top-80 }, 'fast');
	tbjQuery('div#dynamic_params_wrapper div.date_price:last-child .dynamic_param_key').focus();
	
	$$('.hasTip').each(function(el) {
		var title = el.get('title');
		if (title) {
			var parts = title.split('::', 2);
			el.store('tip:title', parts[0]);
			el.store('tip:text', parts[1]);
		}
	});
	var JTooltips = new Tips($$('.hasTip'), {"maxTitleChars": 50,"fixed": false});
    })
    tbjQuery(document).on("click", '.remove_param', function (e) {
	var r = confirm("Are you sure?");
	if (r == true) {
	    tbjQuery(this).closest('div.date_price').remove();
	    
	    var generated_url = tbjQuery('#generated_url').val();
	    if (generated_url.indexOf("booking_type") >= 0){
		regenerateURL();
	    }
	    else {
		generated_url = '<?php echo $this->booking_form_url;?>';
		<?php if($this->sef_enabled==1){ ?>
		generated_url += '?';
		<?php } else{ ?>
		generated_url += '&';
		<?php } ?>
		
		// append dynamic params
		var temp_params = generateDynamicParamsURL();
		var field_params = generateCustomFieldParamsURL();
		tbjQuery('#generated_url').val(generated_url+field_params+'&'+temp_params);
	    }
	}
    })
})


var map;
function initialize() {
    <?php  if($this->elsettings->default_country!="") {?>
    var options = {
	componentRestrictions: {country: '<?php echo $this->default_country;?>'}
    };
    <?php } else { ?>
    var options = {};
    <?php } ?>
    
    var pickup_input = document.getElementById('pickup_address');
    var pickup_autocomplete = new google.maps.places.Autocomplete(pickup_input, options);
    google.maps.event.addListener(pickup_autocomplete, 'place_changed', function() {
	    var place = pickup_autocomplete.getPlace();
	    if (place.geometry) {
		    document.getElementById('pickup_lat').value = place.geometry.location.lat();
		    document.getElementById('pickup_lng').value = place.geometry.location.lng();
		    tbjQuery.fn.getExtras('address_pickup');
		    regenerateURL();
	    }
    });

    var dropoff_input = document.getElementById('dropoff_address');
    var dropoff_autocomplete = new google.maps.places.Autocomplete(dropoff_input, options);
    google.maps.event.addListener(dropoff_autocomplete, 'place_changed', function() {
	    var place = dropoff_autocomplete.getPlace();
	    if (place.geometry) {
		    document.getElementById('dropoff_lat').value = place.geometry.location.lat();
		    document.getElementById('dropoff_lng').value = place.geometry.location.lng();
		    tbjQuery.fn.getExtras('address_dropoff');
		    regenerateURL();
	    }
    });
}

google.maps.event.addDomListener(window, 'load', initialize);
</script>

<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="adminform form-validate">

<div class="details_car_adminform">
	<div class="inputWrap clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_LANGUAGE_EXPLAIN'); ?>">
		    <?php echo JText::_( 'JFIELD_LANGUAGE_LABEL' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['languages'];?>
	</div>
	
	<div class="inputWrap clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_TITLE_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_TITLE' ).':'; ?>
		</span>
	    </label>
	    <input type="text" name="title" value="<?php echo $this->item->title; ?>" class="inputbox required" />
	</div>
	<div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'ALIAS' ).':'; ?>
		</label>
		<input type="text" name="alias" value="<?php echo $this->item->alias; ?>" class="inputbox" />
	</div>
	<div class="inputWrap published clearfix">
		<label for="published">
			<?php echo JText::_( 'PUBLISHED' ).':'; ?>
		</label>
		<?php
		echo JHTML::_('select.booleanlist', 'published', 'class="inputbox"', $this->item->published );
		?>
	</div>
	
	<div class="inputWrap clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_BOOKING_TYPE_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_BOOKING_TYPE' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['booking_type']; ?>
	</div>
	
	<div class="inputWrap nonshuttle_date clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_PICKUP_DATETIME_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_PICKUP_DATETIME' ).':'; ?>
		</span>
	    </label>
	    
	    <div class="datetimeWrap">
		<?php echo JHtml::_('calendar', $this->item->pickup_date, 'pickup_date', "pickup_date", '%Y-%m-%d' , array('class'=>"inputbox pickup_date booking_param", 'onchange'=>"regenerateURL();"));?>
		<div class="pick_hr_min">
		    <?php
		    echo JHTML::_('select.genericlist', $hr_options, "pickup_hr", 'class="pickup_time booking_param" style="width:70px;"', 'value', 'text', $this->item->pickup_hr );
		    ?> : 
		    <?php
		    echo JHTML::_('select.genericlist', $min_options, "pickup_min", 'class="pickup_time booking_param" style="width:70px;"', 'value', 'text', $this->item->pickup_min);
		    ?>
		</div>
	    </div>
	</div>
	
	<div class="inputWrap address_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_PICKUP_TYPE_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_PICKUP_TYPE' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['pickup_type'];?>
	</div>
	<div class="inputWrap address_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_PICKUP_POI_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_PICKUP_POI' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['pickup_poi'];?>
	</div>
	<div class="inputWrap address_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_PICKUP_ADDRESS_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_PICKUP_ADDRESS' ).':'; ?>
		</span>
	    </label>
	    <input type="text" name="pickup_address" id="pickup_address" size="50" value="<?php echo $this->item->pickup_address;?>" class="inputbox" />
	</div>
	<div class="inputWrap address_feature clearfix">
	    <label for="title">
		<span>
		    <?php echo JText::_( 'SEARCHURL_PICKUP_ADDRESS_LAT' ).':'; ?>
		</span>
	    </label>
	    <input type="text" name="pickup_lat" id="pickup_lat" value="<?php echo $this->item->pickup_lat;?>" class="inputbox" readonly="readonly" />
	</div>
	<div class="inputWrap address_feature clearfix">
	    <label for="title">
		<span>
		    <?php echo JText::_( 'SEARCHURL_PICKUP_ADDRESS_LNG' ).':'; ?>
		</span>
	    </label>
	    <input type="text" name="pickup_lng" id="pickup_lng" value="<?php echo $this->item->pickup_lng;?>" class="inputbox" readonly="readonly" />
	</div>
	
	<div id="pickup_extra_wrapper"></div>
	
	<div class="inputWrap address_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DROPOFF_TYPE_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_DROPOFF_TYPE' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['dropoff_type'];?>
	</div>
	<div class="inputWrap address_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DROPOFF_POI_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_DROPOFF_POI' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['dropoff_poi'];?>
	</div>
	<div class="inputWrap address_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DROPOFF_ADDRESS_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_DROPOFF_ADDRESS' ).':'; ?>
		</span>
	    </label>
	    <input type="text" name="dropoff_address" id="dropoff_address" size="50" value="<?php echo $this->item->dropoff_address;?>" class="inputbox" />
	</div>
	<div class="inputWrap address_feature clearfix">
	    <label for="title">
		<span>
		    <?php echo JText::_( 'SEARCHURL_PICKUP_ADDRESS_LAT' ).':'; ?>
		</span>
	    </label>
	    <input type="text" name="dropoff_lat" id="dropoff_lat" value="<?php echo $this->item->dropoff_lat;?>" class="inputbox" readonly="readonly" />
	</div>
	<div class="inputWrap address_feature clearfix">
	    <label for="title">
		<span>
		    <?php echo JText::_( 'SEARCHURL_PICKUP_ADDRESS_LNG' ).':'; ?>
		</span>
	    </label>
	    <input type="text" name="dropoff_lng" id="dropoff_lng" value="<?php echo $this->item->dropoff_lng;?>" class="inputbox" readonly="readonly" />
	</div>
	
	<div id="dropoff_extra_wrapper"></div>
	
	<div class="inputWrap offers_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SPECIAL_ROUTE_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_SPECIAL_ROUTE' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['route_list'];?>
	</div>
	<!--div class="inputWrap offers_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php //echo JText::_('SEARCHURL_ROUTE_PICKUP_CATEGORY_EXPLAIN'); ?>">
		    <?php //echo JText::_( 'SEARCHURL_ROUTE_PICKUP_CATEGORY' ).':'; ?>
		</span>
	    </label>
	    <?php //echo $this->lists['route_pickup_category'];?>
	</div>
	<div class="inputWrap offers_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php //echo JText::_('SEARCHURL_ROUTE_PICKUP_EXPLAIN'); ?>">
		    <?php //echo JText::_( 'SEARCHURL_ROUTE_PICKUP' ).':'; ?>
		</span>
	    </label>
	    <div id="route_pickup_wrap"><?php //echo $this->lists['route_pickup'];?></div>
	</div-->
	
	<div id="routefrom_extra_wrapper"></div>
	
	<!--div class="inputWrap offers_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php //echo JText::_('SEARCHURL_ROUTE_DROPOFF_CATEGORY_EXPLAIN'); ?>">
		    <?php //echo JText::_( 'SEARCHURL_ROUTE_DROPOFF_CATEGORY' ).':'; ?>
		</span>
	    </label>
	    <div id="route_dropoff_category_wrap"><?php //echo $this->lists['route_dropoff_category'];?></div>
	</div>
	<div class="inputWrap offers_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php //echo JText::_('SEARCHURL_ROUTE_DROPOFF_EXPLAIN'); ?>">
		    <?php //echo JText::_( 'SEARCHURL_ROUTE_DROPOFF' ).':'; ?>
		</span>
	    </label>
	    <div id="route_dropoff_wrap"><?php //echo $this->lists['route_dropoff'];?></div>
	</div-->
	
	<div id="routeto_extra_wrapper"></div>
	
	<div class="inputWrap hourly_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_HOURLY_HOUR_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_HOURLY_HOUR' ).':'; ?>
		</span>
	    </label>
	    <?php 
	    echo $this->lists['hourly_hr_list'];
	    ?>
	</div>
	<div class="inputWrap hourly_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_HOURLY_MIN_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_HOURLY_MIN' ).':'; ?>
		</span>
	    </label>
	    <?php 
	    echo $this->lists['hourly_min_list'];
	    ?>
	</div>
	
	<div id="hourly_extra_wrapper"></div>
	
	<div class="inputWrap shuttle_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHUTTLE_PICKUP_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_SHUTTLE_PICKUP' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['shuttle_pickup_poi'];?>
	</div>
	<div class="inputWrap shuttle_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHUTTLE_DROPOFF_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_SHUTTLE_DROPOFF' ).':'; ?>
		</span>
	    </label>
	    <div id="shuttle_dropoff_poi_wrap"><?php echo $this->lists['shuttle_dropoff_poi'];?></div>
	</div>
	<div class="inputWrap shuttle_date clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHUTTLE_PICKUP_DATE_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_SHUTTLE_PICKUP_DATE' ).':'; ?>
		</span>
	    </label>
	    
	    <div class="datetimeWrap">
		<?php echo JHtml::_('calendar', $this->item->shuttle_pickup_date, 'shuttle_pickup_date', "shuttle_pickup_date", '%Y-%m-%d' , array('class'=>"inputbox pickup_date booking_param", 'onchange'=>'reloadShuttleDropoff();'));?>
	    </div>
	</div>
	<div class="inputWrap shuttle_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHUTTLE_TIMES_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_SHUTTLE_TIMES' ).':'; ?>
		</span>
	    </label>
	    <div id="shuttle_time_wrapper" class="clearfix"></div>
	</div>
	<div class="inputWrap shuttle_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHUTTLE_PASSENGER_SEATS_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_SHUTTLE_PASSENGER_SEATS' ).':'; ?>
		</span>
	    </label>
	    <div id="shuttle_passengers_wrap"><?php echo $this->lists['shuttle_passengers'];?></div>
	</div>
	
	
	<div class="inputWrap nonshuttle_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_PASSENGER_SEATS_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_PASSENGER_SEATS' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['passengers'];?>
	</div>
	<div class="inputWrap nonshuttle_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SUITCASES_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_SUITCASES' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['suitcases'];?>
	</div>
	<div class="inputWrap nonshuttle_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_INFANT_SEATS_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_INFANT_SEATS' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['infantseats'];?>
	</div>
	<div class="inputWrap nonshuttle_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_CHILD_SEATS_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_CHILD_SEATS' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['childseats'];?>
	</div>
	<div class="inputWrap nonshuttle_feature clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_BOOSTER_SEATS_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_BOOSTER_SEATS' ).':'; ?>
		</span>
	    </label>
	    <?php echo $this->lists['boosterseats'];?>
	</div>
	
	<div class="inputWrap return_feature published clearfix">
	    <label for="">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_RETURN_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_RETURN' ); ?>
		</span>
	    </label>
	    <?php echo JHTML::_('select.booleanlist', 'returntrip', 'class="inputbox booking_param"', $this->item->returntrip ); ?>
	</div>
	
	<div class="inputWrap nonhourly_feature return_feature clearfix" id="returnWrap" style="<?php echo ((int)$this->item->returntrip==1) ? 'display:block':'display:none';?>">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_RETURN_DATETIME_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_RETURN_DATETIME' ).':'; ?>
		</span>
	    </label>
	    <?php echo JHtml::_('calendar', $this->item->return_date, 'return_date', "return_date", '%Y-%m-%d' , array('class'=>"inputbox pickup_date booking_param", 'onchange'=>"regenerateURL();"));?>
	    <div class="pick_hr_min">
		    <?php
		    echo JHTML::_('select.genericlist', $hr_options, "return_hr", 'class="pickup_time booking_param" style="width:70px;"', 'value', 'text', $this->item->return_hr );
		    ?> : 
		    <?php
		    echo JHTML::_('select.genericlist', $min_options, "return_min", 'class="pickup_time booking_param" style="width:70px;"', 'value', 'text', $this->item->return_min);
		    ?>
	    </div>
	</div>
	<div id="return_extra_wrapper"></div>
	
	<div class="inputWrap clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_COUPON_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_COUPON' ).':'; ?>
		</span>
	    </label>
	    <div id="coupons_wrapper"></div>
	</div>
	
	<div class="inputWrap clearfix">
	    <label class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DYNAMIC_PARAMS_EXPLAIN'); ?>">
		<?php echo JText::_('SEARCHURL_DYNAMIC_PARAMS'); ?>
	    </label>
	    <div class="date_price clearfix">
		<div class="button2-left">
			<div class="blank">
				<a href="javascript:void(0);" class="btn btn-small" id="add_param"><?php echo JText::_('ADD_NEW'); ?></a>
			</div>
		</div>
	    </div>
	    <div id="dynamic_params_wrapper" class="clearfix">
		
		<?php
		if(!empty($this->item->dynamic_params)){
		    for($param_couter=0;$param_couter<count($this->item->dynamic_params);$param_couter++){
			$param = $this->item->dynamic_params[$param_couter];
		    ?>
		<div class="date_price row<?php echo $param_couter;?> clearfix">
		    <div class="inputwrap clearfix">
			<label>
			    <span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DYNAMIC_PARAM_KEY_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_DYNAMIC_PARAM_KEY' ).':'; ?>
			    </span>
			</label>
			<input class="inputbox dynamic_param_key" type="text" name="dynamic_param_key[<?php echo $param_couter;?>]" value="<?php echo $param[0];?>" />
		    </div>
		    <div class="inputwrap clearfix">
			<label>
			    <span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_DYNAMIC_PARAM_VALUE_EXPLAIN'); ?>">
			    <?php echo JText::_( 'SEARCHURL_DYNAMIC_PARAM_VALUE' ).':'; ?>
			    </span>
			</label>
			<input class="inputbox dynamic_param_value" type="text" name="dynamic_param_value[<?php echo $param_couter;?>]" value="<?php echo $param[1];?>" />
		    </div>
		    <div class="button2-left" style="margin:0;">
			    <div class="blank">
				<a href="javascript:void(0);" class="btn btn-small remove_param"><?php echo JText::_('REMOVE'); ?></a>
			    </div>
		    </div>
		</div>
		<?php
		    }
		} ?>
	    </div>
	</div>
	
	<!--div class="inputWrap clearfix">
		<label for="title">
			<?php echo JText::_( 'JFIELD_LANGUAGE_LABEL' ).':'; ?>
		</label>
		<?php echo $this->lists['languages'];?>
	</div-->
	
	<div class="inputWrap clearfix" style="margin-top:30px;">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_GENERATED_URL_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_GENERATED_URL' ).':'; ?>
		</span>
	    </label>
	    <textarea name="generated_url" id="generated_url" readonly="readonly" style="height:120px;width:250px;"><?php echo $this->item->generated_url;?></textarea><br/>
	    <button class="btn btn-small" id="target-to-copy" data-clipboard-target="generated_url" onclick="return false;"><?php echo JText::_('SEARCHURL_GENERATED_URL_COPY_CLIPBOARD'); ?></button>
	</div>
	<div class="inputWrap clearfix">
	    <label for="title">
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_SHORT_URL_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_SHORT_URL' ).':'; ?>
		</span>
	    </label>
	    <input type="text" name="short_url" id="short_url" value="<?php echo $this->item->short_url;?>" class="inputbox" readonly="readonly" />
	    
	    <?php
	    if($this->item->short_url!=""){
	    ?>
	    <button class="btn btn-small" id="short-url-to-copy" data-clipboard-target="short_url" onclick="return false;"><?php echo JText::_('SEARCHURL_GENERATED_URL_COPY_CLIPBOARD'); ?></button>
	    <?php
		echo JText::sprintf('SEARCHURL_SHORT_URL_ANALYTICS', $this->shortUrl_clicked);
	    }
	    ?>
	</div>
	
	<div class="inputWrap clearfix">
	    <label>
		<span class="hasTip control-label" title="<?php echo JText::_('SEARCHURL_ANCHOR_TEXT_EXPLAIN'); ?>">
		    <?php echo JText::_( 'SEARCHURL_ANCHOR_TEXT' ).':'; ?>
		</span>
	    </label>
	    <input type="text" name="anchor_text" id="anchor_text" value="<?php echo $this->item->anchor_text; ?>" class="inputbox" /><br/>
	    <button class="btn btn-small" id="generate-anchor-html-btn" onclick="return false;"><?php echo JText::_('SEARCHURL_GENERATE_ANCHOR_TEXT_HTML_BTN'); ?></button>
	</div>
	
	<div class="inputWrap clearfix">
	    <label>&nbsp;</label>
	    <textarea name="anchor_text_html" id="anchor_text_html" readonly="readonly" style="height:120px;width:250px;"><?php echo $this->item->anchor_text_html;?></textarea><br/>
	    <button class="btn btn-small" id="anchor-text-target-to-copy" data-clipboard-target="anchor_text_html" onclick="return false;"><?php echo JText::_('SEARCHURL_GENERATED_URL_COPY_CLIPBOARD'); ?></button>
	</div>
	
</div>

<div class="details_car_adminform">
	<label for="body"><?php echo JText::_( 'Description' ).':'; ?></label>
	<div class="editor">
		<?php
		// parameters : areaname, content, hidden field, width, height, rows, cols
		echo $this->editor->display( 'text',  $this->item->text, '100%;', '350', '75', '20', array('pagebreak') ) ;
		?>
	</div>
</div>

<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="option" value="com_taxibooking" />
<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
<input type="hidden" name="controller" value="searchurls" />
<input type="hidden" name="view" value="searchurl" />
<input type="hidden" name="task" value="" />
</form>

<script type="text/javascript" src="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/js/ZeroClipboard.min.js"></script>
<script type="text/javascript">
var client = new ZeroClipboard( document.getElementById("target-to-copy") );
client.on( "ready", function( readyEvent ) {
    // alert( "ZeroClipboard SWF is ready!" );
    client.on( "aftercopy", function( event ) {
	// `this` === `client`
	// `event.target` === the element that was clicked
	//event.target.style.display = "none";
	//alert("Copied text to clipboard: " + event.data["text/plain"] );
	return false;
    });
});
var client = new ZeroClipboard( document.getElementById("short-url-to-copy") );
client.on( "ready", function( readyEvent ) {
    // alert( "ZeroClipboard SWF is ready!" );
    client.on( "aftercopy", function( event ) {
	// `this` === `client`
	// `event.target` === the element that was clicked
	//event.target.style.display = "none";
	//alert("Copied text to clipboard: " + event.data["text/plain"] );
	return false;
    });
});
var client = new ZeroClipboard( document.getElementById("anchor-text-target-to-copy") );
client.on( "ready", function( readyEvent ) {
    // alert( "ZeroClipboard SWF is ready!" );
    client.on( "aftercopy", function( event ) {
	// `this` === `client`
	// `event.target` === the element that was clicked
	//event.target.style.display = "none";
	//alert("Copied text to clipboard: " + event.data["text/plain"] );
	return false;
    });
});
</script>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>