<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * View to edit an searchurl.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.5
 */
class TaxiBookingViewSearchurl extends JViewLegacy
{
	protected $item;
    
	protected $state;
    
	/**
	* Display the view
	*
	* @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	*
	* @return  void
	*/
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		$config = JFactory::getConfig();
		
		$this->elsettings 	= booking_helper::config();
		$this->item	= $this->get('Item');
		$this->state	= $this->get('State');
		$isNew		= ($this->item->id == 0);
		$this->editor =  JFactory::getEditor();
	
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
	
			return false;
		}
		
		$this->booking_form_url = $this->getBookingFormURL($this->item);
		
		if($config->get('sef') == 1){
			$this->sef_enabled = 1;
		}
		else {
			$this->sef_enabled = 0;
		}
		
		//echo '<pre>';print_r(unserialize($this->item->url_params));echo '</pre>';
		if($isNew){
			$this->item->booking_type = 'address';
			$this->item->pickup_date = $this->item->return_date  = '';
			$this->item->pickup_hr = $this->item->pickup_min = 0;
			$this->item->returntrip = $this->item->return_hr = $this->item->return_min = $this->item->coupons = 0;
			
			$this->item->pickup_type = $this->item->dropoff_type = 'poi';
			$this->item->pickup_poi = $this->item->dropoff_poi = 0;
			$this->item->pickup_address = $this->item->pickup_lat = $this->item->pickup_lng = '';
			$this->item->dropoff_address = $this->item->dropoff_lat = $this->item->dropoff_lng = '';
			
			$this->item->route_pickup_category = $this->item->route_dropoff_category = 0;
			$this->item->route_pickup_poi = $this->item->route_dropoff_poi = 0;
			
			$this->item->hourly_hr = $this->item->hourly_min = 0;
			
			$this->item->shuttle_pickup_poi = $this->item->shuttle_dropoff_poi = $this->item->shuttle_passengers = 0;
			$this->item->shuttle_pickup_date = $this->item->shuttletime = '';
			
			$this->item->passengers = $this->item->suitcases = $this->item->infantseats = $this->item->childseats = $this->item->boosterseats = 0;
			
			$this->item->generated_url = $this->booking_form_url;
			$this->item->short_url = "";
			$this->shortUrl_clicked = 0;
			
			$this->edit_url = 'index.php?option=com_taxibooking&view=searchurl&layout=edit';
			$this->shortUrl_clicked = 0;
		}
		else {
			if($this->item->booking_type !='shuttle'){
				$this->item->shuttletime = '';
			}
			
			$this->edit_url = 'index.php?option=com_taxibooking&view=searchurl&layout=edit&id='.$this->item->id;
			
			// check if URL shortner API key is present
			$params = JComponentHelper::getParams('com_taxibooking');
			$url_shortner_api_key = $params->get('url_shortner_api_key', '');
			
			if($url_shortner_api_key==""){
				$this->shortUrl_clicked = 0;
				$app->enqueueMessage(JText::_('COM_TAXIBOOKING_URLAPIKEY_MISSING_MSG').'<br>'.JText::_('COM_TAXIBOOKING_FIELD_URLAPIKEY_DESC'), 'warning');
			}
			else {
				if($this->item->short_url!="")
				{
					require_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'google_url.php');
					$api = new GoogleURL();
					$shortUrl = $this->item->short_url;
					$params = array('shortUrl' => $shortUrl, 'key' => $url_shortner_api_key,'projection' => "FULL");
					$analytics_response = $api->httpGet($params);
					
					if($analytics_response->status=='OK'){
						$this->shortUrl_clicked = isset($analytics_response->analytics->allTime->shortUrlClicks) ? $analytics_response->analytics->allTime->shortUrlClicks : 0;
					}
					else {
						if(isset($analytics_response->error)){
							$app->enqueueMessage('Google URL Shortener API error code - '.$analytics_response->error->code.', message - '.$analytics_response->error->message.', reason - '.$analytics_response->error->errors[0]->reason, 'warning');
						}
					}
				}
			}
		}
		
		//build selectlists
		$this->lists = $this->_buildEditLists($this->item);
		
		$country_2_code = booking_helper::get_country_field($this->elsettings->default_country, 'country_2_code');
		$this->default_country = ($country_2_code == '') ? 'US' : $country_2_code;
	
		$this->addToolbar();
		parent::display($tpl);
	}
	
	/**
	* Return Booking URL
	*/
	protected function getBookingFormURL($item)
	{
		$config = JFactory::getConfig();
		$isNew		= ($this->item->id == 0);
		
		if($isNew){
			$lang_tag = JRequest::getVar( 'lang', '*' );
		}
		else {
			$lang_tag = $item->language;
		}
		
		if($lang_tag=="*"){ // get default frontend language
			$lang_tag =  JComponentHelper::getParams('com_languages')->get('site', 'en-GB');
		}
		
		// Non SEF URL
		require_once (JPATH_COMPONENT_SITE.DS.'helpers'.DS.'route.php');
		$bookingURL = TaxibookingHelperRoute::getBookingFormRoute($lang_tag);
		
		if($config->get('sef') == 1){
			
			$lang_codes 	= JLanguageHelper::getLanguages('lang_code');
			$lang_sef 	= $lang_codes[$lang_tag]->sef;
			
			$app    = JApplication::getInstance('site');
			$router = $app->getRouter();
			$uri = $router->build($bookingURL);
			$uri->delVar('lang');
			$parsed_url = $uri->toString();

			// add lang sef code exmample: en, fr, gl etc. if Multilingual is enabled
			if(JLanguageMultilang::isEnabled()){
				$path  = JString::trim($parsed_url, '/ ');
				$parts = explode('/', $path);
				$adminkey = array_search('administrator', $parts);
				
				if ($app->getCfg('sef_rewrite')){
					array_splice($parts, $adminkey+1, 0, $lang_sef);
				}
				else{ // index.php exists
					array_splice($parts, $adminkey+2, 0, $lang_sef);
				}
				$parsed_url = implode('/', $parts);
			}
			
			$temp = explode('administrator/', $parsed_url);
			// SEF URL !
			$result = JURI::root().$temp[1];
			
			return $result;
		}
		else {
			return JURI::root().$bookingURL;
		}
	}
	
	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		JFactory::getApplication()->input->set('hidemainmenu', true);
	
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();
	
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
	    
		JToolbarHelper::title($isNew ? JText::_('COM_TAXIBOOKING_MANAGER_SEARCHURL_NEW') : JText::_('COM_TAXIBOOKING_MANAGER_SEARCHURL_EDIT'), 'generic');
		
		// If not checked out, can save the item.
		if (!$checkedOut)
		{
			JToolbarHelper::apply();
			JToolbarHelper::save();
		}
		
		JToolbarHelper::cancel();
	}
	
	/**
	 * Creates list
	 *
	 * @since 1.0
	 */
	private function _buildEditLists($item)
	{
                $db = JFactory::getDBO();
		$elsettings = booking_helper::config();
		
		$isNew		= ($this->item->id == 0);
		
		if($isNew){
			$lang_tag = JRequest::getVar( 'lang', '*' );
		}
		else {
			$lang_tag = $item->language;
		}
		
		$options = array();
                $options[] = JHTML::_('select.option',  '*', JText::_( 'JALL' ) );
		$rows = JHtml::_('contentlanguage.existing');
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->value, $row->text);
			}
                }
                $lists['languages'] = JHTML::_('select.genericlist', $options, 'language', '', 'value', 'text', $lang_tag );
		
		$options = array();
		if((int)$elsettings->show_address_tab==1){
			$options[] = JHTML::_('select.option',  'address', JText::_( 'SEARCHURL_BOOKING_TYPE_ADDRESS_SEARCH' ) );
		}
		if((int)$elsettings->show_offers_tab==1){
			$options[] = JHTML::_('select.option',  'offers', JText::_( 'SEARCHURL_BOOKING_TYPE_SPECIAL_OFFERS' ) );
		}
		if((int)$elsettings->show_hourly_tab==1 && booking_helper::is_hourly_rate_enabled()){
			$options[] = JHTML::_('select.option',  'hourly', JText::_( 'SEARCHURL_BOOKING_TYPE_HOURLY_HIRE' ) );
		}
		if((int)$elsettings->show_shuttles_tab==1 && booking_helper::is_shuttles_enabled()){
			$options[] = JHTML::_('select.option',  'shuttle', JText::_( 'SEARCHURL_BOOKING_TYPE_SHUTTLES' ) );
		}
                $lists['booking_type'] = JHTML::_('select.genericlist', $options, 'booking_type', 'class="booking_param"', 'value', 'text', $item->booking_type );
		
		$options = array();
		$options[] = JHTML::_('select.option',  'poi', JText::_( 'SEARCHURL_PICKUP_TYPE_POI' ) );
		$options[] = JHTML::_('select.option',  'address', JText::_( 'SEARCHURL_PICKUP_TYPE_ADDRESS' ) );
		
		$lists['pickup_type'] = JHTML::_('select.genericlist', $options, 'pickup_type', 'class="booking_param"', 'value', 'text', $item->pickup_type);
		$lists['dropoff_type'] = JHTML::_('select.genericlist', $options, 'dropoff_type', 'class="booking_param"', 'value', 'text', $item->dropoff_type );
			
		$pickup_poi = array();
		$pickup_poi[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
		
		$dropoff_poi = array();
		$dropoff_poi[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
	
		// get all the points of interest
		$query = 'SELECT poi.id, poi.title, poi.lat, poi.long, poi.show_on_pickup, poi.show_on_dropoff, poi_cat.image'
			. ' FROM #__taxibooking_points AS poi'
			. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
			. ' WHERE poi.published = 1';
		if($lang_tag!="*"){
		$query .= ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")';
		}
		$query .= ' ORDER BY poi.title ASC';
		$db->setQuery($query);
		$db->query();
		$places = $db->loadObjectList();
		
		if (!empty($places))
		{
			foreach ($places as $place)
			{
				// enlist pickup poi
				if((int)$place->show_on_pickup==1)
				{
					$pickup_poi[] = JHTML::_('select.option', $place->id, $place->title);
				}
				// enlist dropoff poi
				if((int)$place->show_on_dropoff==1)
				{
					$dropoff_poi[] = JHTML::_('select.option', $place->id, $place->title);
				}
			}
		}
		
		$lists['pickup_poi'] = JHTML::_('select.genericlist', $pickup_poi, 'pickup_poi', 'class="booking_param"', 'value', 'text', (int)$item->pickup_poi );
		$lists['dropoff_poi'] = JHTML::_('select.genericlist', $dropoff_poi, 'dropoff_poi', 'class="booking_param"', 'value', 'text', (int)$item->dropoff_poi );
		
		// Get special offers data
		/*$route_pickup_category = $route_pickup_catarr = $route_dropoff_category = $route_dropoff_catarr = $route_pickup = $route_dropoff = array();
		$route_pickup_category[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
		$route_dropoff_category[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
		$route_pickup[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
		$route_dropoff[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
		
		$has_any_route = false;
		
		// route pickup category
		$query = 'SELECT DISTINCT poi.title, poi.id, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image, poi_cat.language AS cat_language'
                        . ' FROM #__taxibooking_points AS poi'
                        . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                        . ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_from'
                        . ' WHERE r.published = 1'
			. ' AND poi.published = 1'
                        . ' AND poi.show_on_pickup = 1'
			. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
                        . ' ORDER BY r.ordering ASC'
                ;
                $db->setQuery($query);
                $db->query();
                $rows = $db->loadObjectList();
                
                if (!empty($rows))
                {
			foreach ($rows as $row)
			{
				$route_pickup_catarr[$row->catid] = array('cattitle' => $row->cattitle);
			}
                }
		if(!empty($route_pickup_catarr))
		{
			foreach($route_pickup_catarr as $catid => $catobj)
			{
				$route_pickup_category[] = JHTML::_('select.option', $catid, $catobj['cattitle']);
			}
		}
		
		// route pickup pois
		$query = 'SELECT DISTINCT poi.title, poi.id, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image'
			. ' FROM #__taxibooking_points AS poi'
			. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
			. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_from'
			. ' WHERE r.published = 1'
			. ' AND poi.published = 1'
                        . ' AND poi.show_on_pickup = 1';
		
		if((int)$item->route_pickup_category>0) {
		    $query .= ' AND poi_cat.id = '.(int)$item->route_pickup_category;
		}
		$query .= ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
			. ' ORDER BY r.ordering ASC'
		;
		$db->setQuery($query);
		$db->query();
		$rows = $db->loadObjectList();
		
		if (!empty($rows))
		{
			$has_any_route = true;
			foreach ($rows as $row)
			{
				$route_pickup[] = JHTML::_('select.option', $row->id, $row->title);
			}
		}
		
		if((int)$item->route_pickup_poi > 0)
		{
			// route dropoff category
			$query = 'SELECT DISTINCT poi.title, poi.id, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image, poi_cat.language AS cat_language'
				. ' FROM #__taxibooking_points AS poi'
				. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
				. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
				. ' WHERE r.published = 1'
				. ' AND poi.published = 1'
				. ' AND poi.show_on_dropoff = 1'
				. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
				. ' AND r.route_from = '.(int)$item->route_pickup_poi
				. ' ORDER BY r.ordering ASC'
			;
			$db->setQuery($query);
			$db->query();
			$rows = $db->loadObjectList();
			
			if (!empty($rows))
			{
				foreach ($rows as $row)
				{
					$route_dropoff_catarr[$row->catid] = array('cattitle' => $row->cattitle,
									    'catimage' => $row->cat_image);
				}
			}
			
			// route dropoff pois
			$query = 'SELECT DISTINCT poi.id, poi.title, poi_cat.image AS cat_image, poi_cat.title AS cattitle'
				. ' FROM #__taxibooking_points AS poi'
				. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
				. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
				. ' WHERE r.published = 1'
				. ' AND poi.published = 1'
				. ' AND poi.show_on_dropoff = 1'
				. ' AND r.route_from = '.(int)$item->route_pickup_poi
				. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")';
			
			if((int)$item->route_dropoff_category>0) {
			    $query .= ' AND poi_cat.id = '.(int)$item->route_dropoff_category;
			}
			$query .= ' ORDER BY r.ordering ASC';
			$db->setQuery($query);
			$db->query();
			$rows = $db->loadObjectList();
			
			if (!empty($rows)) {
				foreach ($rows as $row)
				{
					$route_dropoff[] = JHTML::_('select.option', $row->id, $row->title);
				}
			}
		}
		
		if(!empty($route_dropoff_catarr))
		{
			foreach($route_dropoff_catarr as $catid => $catobj)
			{
				$route_dropoff_category[] = JHTML::_('select.option', $catid, $catobj['cattitle']);
			}
		}
		
		$lists['route_pickup_category'] = JHTML::_('select.genericlist', $route_pickup_category, 'route_pickup_category', 'class="booking_param"', 'value', 'text', (int)$item->route_pickup_category );
		$lists['route_dropoff_category'] = JHTML::_('select.genericlist', $route_dropoff_category, 'route_dropoff_category', 'class="booking_param"', 'value', 'text', (int)$item->route_dropoff_category);
		$lists['route_pickup'] = JHTML::_('select.genericlist', $route_pickup, 'route_pickup_poi', 'class="booking_param"', 'value', 'text', (int)$item->route_pickup_poi);
		$lists['route_dropoff'] = JHTML::_('select.genericlist', $route_dropoff, 'route_dropoff_poi', 'class="booking_param"', 'value', 'text', (int)$item->route_dropoff_poi);*/
		
		// list of all special routes
		$routes = array();
		$routes[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
		$query = 'SELECT r.*,'
			. ' (SELECT catid FROM #__taxibooking_points WHERE id = r.route_from) AS pickup_poicat,'
			. ' (SELECT catid FROM #__taxibooking_points WHERE id = r.route_to) AS dropoff_poicat'
                        . ' FROM #__taxibooking_routes AS r'
                        . ' WHERE r.published = 1'
                        . ' ORDER BY r.title ASC'
                ;
                $db->setQuery($query);
                $db->query();
                $rows = $db->loadObjectList();
		
		// Get special route id for previously created Special Offer Search URLs
		$selected_route_id = 0;
		if(isset($item->route_id)){
			$selected_route_id = $item->route_id;
		}
		else {
			if((int)$item->route_pickup_poi > 0 && (int)$item->route_dropoff_poi > 0){
				$query = 'SELECT r.id'
					. ' FROM #__taxibooking_routes AS r'
					. ' WHERE r.route_from = '.(int)$item->route_pickup_poi
					. ' AND r.route_to = '.(int)$item->route_dropoff_poi
				;
				$db->setQuery($query);
				$selected_route_id = $db->loadResult();
			}
		}
                
		$html = '<select id="route_id" class="booking_param" name="route_id">';
		$html .= '<option value="0" data-pickup="0" data-dropoff="0" data-pickuppoicat="0" data-dropoffpoicat="0">'.JText::_('JSELECT').'</option>';
                if (!empty($rows))
                {
			foreach ($rows as $row)
			{
				$row->title = htmlspecialchars($row->title);
				$row->title = str_replace(array("'", '"'), array("&#39;", "&quot;"), $row->title);
				
				$selected = ($selected_route_id==$row->id) ? ' selected="selected"' : '';
				$html .= '<option value="'.$row->id.'" data-pickup="'.$row->route_from.'" data-dropoff="'.$row->route_to.'" data-pickuppoicat="'.$row->pickup_poicat.'" data-dropoffpoicat="'.$row->dropoff_poicat.'"'.$selected.'>'.$row->title.'</option>';
			}
                }
		$html .= '</select>';
		$lists['route_list'] = $html;
		
		$query = 'SELECT MAX(passenger_no) AS max_passenger, MAX(suitcase_no) AS max_suitcase, '
			. ' MAX(booster_seat_no) AS max_booster, MAX(child_seat_no) AS max_child, MAX(infant_seat_no) AS max_infant'
			. ' FROM #__taxibooking_cars'
		;
		$db->setQuery($query);
		$db->query();
		$max = $db->loadObject();
		$max_passenger = isset($max->max_passenger) ? $max->max_passenger : 8;
		$max_suitcase = isset($max->max_suitcase) ? $max->max_suitcase : 9;
		$max_booster = isset($max->max_booster) ? $max->max_booster : 5;
		$max_child = isset($max->max_child) ? $max->max_child : 5;
		$max_infant = isset($max->max_infant) ? $max->max_infant : 5;
		
		$passenger_options = array('0' => JText::_('JSELECT'));
		for ($i = 1; $i <= $max_passenger; $i++) {
		    $passenger_options[] = JHTML::_('select.option', $i, $i);
		}
		
		$suitcases_options = array('0' => JText::_('JSELECT'));
		for ($i = 1; $i <= $max_suitcase; $i++) {
		    $suitcases_options[] = JHTML::_('select.option', $i, $i);
		}
		
		$lists['passengers'] = JHTML::_('select.genericlist', $passenger_options, 'passengers', 'class="booking_param"', 'value', 'text', (int)$item->passengers);
		$lists['suitcases'] = JHTML::_('select.genericlist', $suitcases_options, 'suitcases', 'class="booking_param"', 'value', 'text', (int)$item->suitcases);
		
		$infantseats_options = array('0' => JText::_('JSELECT'));
		for ($i = 1; $i <= $max_infant; $i++) {
		    $infantseats_options[] = JHTML::_('select.option', $i, $i);
		}
		
		$chseats_options = array('0' => JText::_('JSELECT'));
		for ($i = 1; $i <= $max_child; $i++) {
		    $chseats_options[] = JHTML::_('select.option', $i, $i);
		}
		
		$boosterseats_options = array('0' => JText::_('JSELECT'));
		for ($i = 1; $i <= $max_booster; $i++) {
		    $boosterseats_options[] = JHTML::_('select.option', $i, $i);
		}
		
		$lists['has_infant_seats'] = ($max_infant > 0) ? true : false;
		$lists['has_chseats'] = ($max_child > 0) ? true : false;
		$lists['has_booster_seats'] = ($max_booster > 0) ? true : false;
		
		$lists['infantseats'] = JHTML::_('select.genericlist', $infantseats_options, 'infantseats', 'class="booking_param"', 'value', 'text', (int)$item->infantseats);
		$lists['childseats'] = JHTML::_('select.genericlist', $chseats_options, 'childseats', 'class="booking_param"', 'value', 'text', (int)$item->childseats);
		$lists['boosterseats'] = JHTML::_('select.genericlist', $boosterseats_options, 'boosterseats', 'class="booking_param"', 'value', 'text', (int)$item->boosterseats);
        
		$query = 'SELECT MIN(hourly_hire_min_hr) AS min_hourly_hr, MAX(hourly_hire_max_hr) AS max_hourly_hr'
			. ' FROM #__taxibooking_cars'
			. ' WHERE hourly_hire_enabled = 1'
		;
		$db->setQuery($query);
		$db->query();
		$max = $db->loadObject();
		$min_hourly_hr = isset($max->min_hourly_hr) ? $max->min_hourly_hr : 1;
		$max_hourly_hr = isset($max->max_hourly_hr) ? $max->max_hourly_hr : 10;
		
		$options = array('0' => JText::_('JSELECT'));
		for ($i = $min_hourly_hr; $i <= $max_hourly_hr; $i++) {
		    $options[] = JHTML::_('select.option', $i, $i);
		}
		$lists['hourly_hr_list'] = JHTML::_('select.genericlist', $options, 'hourly_hr', 'class="booking_param"', 'value', 'text', (int)$item->hourly_hr);
		
		$options = array();
		$options[] = JHTML::_('select.option', 0, '00');
		$options[] = JHTML::_('select.option', 15, 15);
		$options[] = JHTML::_('select.option', 30, 30);
		$options[] = JHTML::_('select.option', 45, 45);
		$lists['hourly_min_list'] = JHTML::_('select.genericlist', $options, 'hourly_min', 'class="booking_param"', 'value', 'text', (int)$item->hourly_min);
        
		// get shuttle start points
		$shuttle_pickup_poi = $shuttle_dropoff_poi = array();
		$shuttle_pickup_poi[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
		$shuttle_dropoff_poi[] = JHTML::_('select.option', 0, JText::_('JSELECT'));
		
		$query = 'SELECT DISTINCT p.title AS poi_title, p.id AS poiid, p.lat AS poilat, p.long AS poilng, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image'
			. ' FROM #__taxibooking_shuttle_route_stops AS rs'
			. ' LEFT JOIN #__taxibooking_shuttle_routes AS r ON r.id = rs.route_id'
			. ' LEFT JOIN #__taxibooking_points AS p ON p.id = rs.poi_id'
			. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = p.catid'
			. ' WHERE rs.is_end = 0'
			. ' AND r.published = 1'
			. ' AND (r.language = "*" OR r.language = "'.$lang_tag.'")'
			. ' ORDER BY p.title ASC'
		;
		$db->setQuery($query);
		$db->query();
		$rows = $db->loadObjectList();
	    
		if (!empty($rows))
		{
			$i = 0;
			foreach ($rows as $row)
			{
				$shuttle_pickup_poi[] = JHTML::_('select.option', $row->poiid, $row->poi_title);
				$i++;
			}
		}
		$lists['shuttle_pickup_poi'] = JHTML::_('select.genericlist', $shuttle_pickup_poi, 'shuttle_pickup_poi', 'class="booking_param"', 'value', 'text', (int)$item->shuttle_pickup_poi);
		$lists['shuttle_dropoff_poi'] = JHTML::_('select.genericlist', $shuttle_dropoff_poi, 'shuttle_dropoff_poi', 'class="booking_param"', 'value', 'text', (int)$item->shuttle_dropoff_poi);
		$lists['shuttle_passengers'] = JHTML::_('select.genericlist', $shuttle_dropoff_poi, 'shuttle_passengers', 'class="booking_param"', 'value', 'text', (int)$item->shuttle_passengers);
		
		
		return $lists;
	}
}