<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$saveOrder	= $listOrder=='ordering';
$params		= (isset($this->state->params)) ? $this->state->params : new JObject();

if(version_compare(JVERSION,'3.1.5','ge'))
{
	if ($saveOrder)
	{
		$saveOrderingUrl = 'index.php?option=com_taxibooking&task=saveOrderAjax&tmpl=component';
		JHtml::_('sortablelist.sortable', 'articleList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
	}
}
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/searchurls.css" />

<div>
<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&view=searchurls'); ?>" method="post" name="adminForm" id="adminForm">

	<div class="cars_adminform clearfix">
		<div class="cars_adminform_left clearfix">
			<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
			<label><?php echo JText::_( 'SEARCH' ); ?></label>
			<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" class="hasTooltip" />
			<button type="submit" class="btn hasTooltip"><i class="icon-search"></i></button>
			<button type="button" class="btn hasTooltip" onclick="document.id('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
			<?php } else { ?>
			<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
			<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" />
			<button type="submit"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
			<button type="button" onclick="document.id('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			<?php } ?>
		</div>
		<div class="cars_adminform_right">
			<select name="filter_state" class="inputbox" onchange="this.form.submit()">
				<option value=""><?php echo JText::_('JOPTION_SELECT_PUBLISHED');?></option>
				<?php echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.state'), true);?>
			</select>
		</div>
	</div>

	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
	<table class="table table-striped no-more-tables" id="articleList">
	<?php } else { ?>
	<table class="adminlist">
	<?php } ?>
	
	<thead>
		<tr>
			<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
			<th width="1%" class="nowrap center hidden-phone numeric">
				<?php echo JHtml::_('grid.sort', '<i class="icon-menu-2"></i>', 'ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING'); ?>
			</th>
			<th width="5" class="numeric">
				<?php echo JHtml::_('grid.checkall'); ?>
			</th>
			<?php } else { ?>
			<th width="1%" class="numeric">
				<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
			</th>
			<?php } ?>
			
			<th class="title numeric"><?php echo JHTML::_('grid.sort', 'SEARCHURL_TITLE', 'a.title', $listDirn, $listOrder ); ?></th>
			
			<th class="title numeric"><?php echo JText::_('SEARCHURL_PREVIEW'); ?></th>
			<th width="5%" class="nowrap center"><?php echo JText::_('SEARCHURL_SHORTURL_CLICKED'); ?></th>
			
                        <th width="5%" class="nowrap center">
				<?php echo JHtml::_('grid.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
			</th>
			
			<?php if(!version_compare(JVERSION,'3.1.5','ge')) {?>
			<th width="10%" class="numeric">
				<?php echo JHTML::_('grid.sort',  'JGRID_HEADING_ORDERING', 'ordering', $listDirn, $listOrder); ?>
				<?php if ($saveOrder): ?>
					<?php echo JHtml::_('grid.order',  $this->items, 'filesave.png', 'saveorder'); ?>
				<?php endif;?>
			</th>
			<?php } ?>
			
			<th width="10%" class="numeric">
				<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_LANGUAGE', 'language', $listDirn, $listOrder); ?>
			</th>
			<th width="1%" class="nowrap numeric">
				<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
			</th>
		</tr>
	</thead>
	<tbody>
		<?php
		$k = 0;
		$img1 = 'icon-16-allow.png';
		$img0 = 'publish_r.png';
		for ($i=0, $n=count($this->items); $i < $n; $i++) {
			$row = $this->items[$i];
			$ordering	= ($listOrder == 'ordering');

			$link 		= 'index.php?option=com_taxibooking&amp;controller=searchurls&amp;task=edit&amp;cid[]='. $row->id;
			$checked 	= JHTML::_('grid.id', $i, $row->id);
                        $published 	= JHTML::_('jgrid.published', $row->published, $i );
   		?>
		<tr class="<?php echo "row$k"; ?>">
			<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
			<td class="order nowrap center hidden-phone" data-title="Ordering">
				<?php
				$iconClass = '';
				if (!$saveOrder)
				{
					$iconClass = ' inactive tip-top hasTooltip" title="' . JHtml::tooltipText('JORDERINGDISABLED');
				}
				?>
				<span class="sortable-handler <?php echo $iconClass ?>">
					<i class="icon-menu"></i>
				</span>
				<?php if ($saveOrder) : ?>
					<input type="text" style="display:none" name="order[]" size="5"
						value="<?php echo $row->ordering; ?>" class="width-20 text-area-order " />
				<?php endif; ?>
			</td>
			<?php } ?>
			
			<td class="" data-title="&nbsp;"><?php echo $checked; ?></td>
			<td align="left" data-title="<?php echo JText::_( 'SEARCHURL_TITLE' );?>" class="numeric">
				<?php if ($row->checked_out) : ?>
					<?php echo JHtml::_('jgrid.checkedout', $i, $row->checked_out, $row->checked_out_time, '', true); ?>
				<?php endif; ?>
                            <span>
                            <a href="<?php echo $link; ?>">
                            <?php echo htmlspecialchars($row->title, ENT_QUOTES, 'UTF-8'); ?>
                            </a>
			    </span>
			</td>
			
			<td align="left" class="numeric" data-title="<?php echo JText::_('SEARCHURL_PREVIEW');?>">
                            <span>
                            <a href="<?php echo $row->short_url; ?>" target="blank" class="hasTooltip" title="<?php echo $row->short_url; ?>">
                            <?php echo $row->short_url; ?>
                            </a>
			    </span>
			</td>
			<td align="left" class="numeric" data-title="<?php echo JText::_('SEARCHURL_SHORTURL_CLICKED');?>">
                            <span><a href="<?php echo $row->short_url; ?>+" target="blank"><?php echo $row->shortUrl_clicked; ?></a></span>
			</td>
			
                        <td class="numeric" align="center" data-title="<?php echo JText::_('JSTATUS');?>"><?php echo $published; ?></td>
			
			<?php if(!version_compare(JVERSION,'3.1.5','ge')) {?>
			<td class="order numeric" data-title="&nbsp;">
			<?php if ($saveOrder) : ?>
				<?php if ($listDirn == 'asc') : ?>
					<span><?php echo $this->pagination->orderUpIcon( $i, true, 'orderup', 'JLIB_HTML_MOVE_UP', $ordering ); ?></span>
					<span><?php echo $this->pagination->orderDownIcon( $i, $n, true, 'orderdown', 'JLIB_HTML_MOVE_DOWN', $ordering );?></span>
					
				<?php elseif ($listDirn == 'desc') : ?>
					<span><?php echo $this->pagination->orderUpIcon( $i, true, 'orderdown', 'JLIB_HTML_MOVE_UP', $ordering ); ?></span>
					<span><?php echo $this->pagination->orderDownIcon( $i, $n, true, 'orderup', 'JLIB_HTML_MOVE_DOWN', $ordering );?></span>
				<?php endif; ?>
			<?php endif; ?>
				<?php $disabled = $saveOrder ?  '' : 'disabled="disabled"'; ?>
				<input type="text" name="order[]" size="5" value="<?php echo $row->ordering;?>" <?php echo $disabled; ?> class="text-area-order" />
			</td>
			<?php } ?>
			
			<td data-title="<?php echo JText::_('JGRID_HEADING_LANGUAGE');?>" class="numeric">
				<?php if ($row->language=='*'):?>
					<?php echo JText::alt('JALL', 'language'); ?>
				<?php else:?>
					<?php echo $row->language_title ? $this->escape($row->language_title) : JText::_('JUNDEFINED'); ?>
				<?php endif;?>
			</td>
			
			<td align="center" class="numeric" data-title="<?php echo JText::_('JGRID_HEADING_ID');?>"><?php echo $row->id; ?></td>
		</tr>
		<?php $k = 1 - $k; } ?>
	</tbody>
	<tfoot>
		<tr>
			<td colspan="8">
				<?php echo $this->pagination->getListFooter(); ?>
			</td>
		</tr>
	</tfoot>	

	</table>

	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="option" value="com_taxibooking" />
	<input type="hidden" name="controller" value="searchurls" />
	<input type="hidden" name="view" value="searchurls" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
</div>