<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * View class for a list of search URLs.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.6
 */
class TaxibookingViewSearchurls extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Method to display the view.
	 *
	 * @param   string  $tpl  A template file to load. [optional]
	 *
	 * @return  mixed  A string if successful, otherwise a JError object.
	 *
	 * @since   1.6
	 */
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');
		$this->elsettings 	= booking_helper::config();

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		// fetch short URL clicked information from Google
		if(!empty($this->items))
		{
			// check if URL shortner API key is present
			$params = JComponentHelper::getParams('com_taxibooking');
			$url_shortner_api_key = $params->get('url_shortner_api_key', '');
			
			if($url_shortner_api_key==""){
				foreach($this->items as $item){
					$item->shortUrl_clicked = 0;
				}
				$app->enqueueMessage(JText::_('COM_TAXIBOOKING_URLAPIKEY_MISSING_MSG').'<br>'.JText::_('COM_TAXIBOOKING_FIELD_URLAPIKEY_DESC'), 'warning');
			}
			else {
				require_once (JPATH_COMPONENT_SITE.DS.'classes'.DS.'google_url.php');
				foreach($this->items as $item)
				{
					$item->shortUrl_clicked = 0;
					if($item->short_url!="")
					{
						$api = new GoogleURL();
						$shortUrl = $item->short_url;
						$params = array('shortUrl' => $shortUrl, 'key' => $url_shortner_api_key,'projection' => "FULL");
						$analytics_response = $api->httpGet($params);
						
						if($analytics_response->status=='OK'){
							$item->shortUrl_clicked = isset($analytics_response->analytics->allTime->shortUrlClicks) ? $analytics_response->analytics->allTime->shortUrlClicks : 0;
						}
						else {
							if(isset($analytics_response->error)){
								$app->enqueueMessage('Google URL Shortener API error code - '.$analytics_response->error->code.', message - '.$analytics_response->error->message.', reason - '.$analytics_response->error->errors[0]->reason, 'warning');
							}
						}
					}
				}
			}
		}
		
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		TaxibookingHelper::addSubmenu('searchurls');
		
		$this->addToolbar();
		
		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();

		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('DASHBOARD_SEARCHURLS'), 'generic');

		if ($canDo->get('core.create'))
		{
			JToolbarHelper::addNew();
		}
		if (($canDo->get('core.edit')))
		{
			JToolbarHelper::editList();
		}
		if ($canDo->get('core.edit.state'))
		{
			JToolbarHelper::checkin();
			JToolbarHelper::publish('publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('unpublish', 'JTOOLBAR_UNPUBLISH', true);
		}
		if ($canDo->get('core.delete'))
		{
			JToolbarHelper::deleteList('Are you sure?', 'remove', 'JTOOLBAR_DELETE');
		}
		if ($canDo->get('core.create'))
		{
			JToolBarHelper::custom('duplicate', 'copy.png', 'copy_f2.png', 'JTOOLBAR_DUPLICATE', true);
		}
		if ($user->authorise('core.admin', 'com_taxibooking'))
		{
			JToolbarHelper::preferences('com_taxibooking');
		}
	}
}