<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
?>

<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o&v=3.exp&libraries=places"></script>

<script language="javascript" type="text/javascript">

<?php  if($this->elsettings->default_country!="") {?>
var mapOptions = {
    componentRestrictions: {country: '<?php echo $this->default_country;?>'}
};
<?php } else { ?>
var mapOptions = {};
<?php } ?>

Joomla.submitbutton = function(task)
{
    if (task == 'cancel' || document.formvalidator.isValid(document.id('adminForm')))
    {
	Joomla.submitform(task, document.getElementById('adminForm'));
    }
}
</script>

<?php
$hr_options = array();
for($i = 0; $i <= 23; $i++){
	$value = str_pad($i, 2, '0', STR_PAD_LEFT);
    $hr_options[$value] = $value;
}
$min_options = array();
for($i = 0; $i <= 59; $i++){
	$value = str_pad($i, 2, '0', STR_PAD_LEFT);
    $min_options[$value] = $value;
}
?>

<?php if(version_compare(JVERSION,'3.1.5','le')) {?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<?php } ?>

<script type="text/javascript">
var xhr = null;
var tbjQuery = jQuery.noConflict( );
var BASE_URL = '<?php echo JURI::base();?>';
var page_mode = '<?php echo ($this->item->id > 0) ? 'edit' : 'add' ?>';

tbjQuery(document).ready(function(){
	tbjQuery('#add_stop').click(function(){
		var i = tbjQuery('div.date_price').length;
		
		var html = '';
html += '<div class="date_price clearfix row'+i+'">'+
		'<div class="fltlft">'+
			'<div class="poi_select">'+
				'<label>'+
					'<span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_STOPS_POI_EXPLAIN'); ?>">'+
					'<?php echo JText::_( 'SHUTTLE_ROUTE_STOPS_POI_LABEL' ).':'; ?>'+
					'</span>'+
				    '</label>';
html += '<select class="stop_poi" id="stop_poi_'+i+'" name="stop_poi['+i+']">';
html 	+= '<option value="0">'+"<?php echo JText::_( 'SELECT_POI' );?>"+'</option>';
<?php for($i = 0; $i < count($this->availablepois); $i++){ ?>
html 	+= '<option value="<?php echo $this->availablepois[$i]->id;?>">'+"<?php echo $this->availablepois[$i]->title;?>"+'</option>';
<?php } ?>
html += '</select>';
html += ' Or <a href="javascript:void(0);" class="route_new_poi_trigger" onclick="collectNewPOIBlockHtml(this);">'
	+'<span class="hasTip control-label btn btn-small" title="'+"<?php echo JText::_('SHUTTLE_ROUTES_CREATE_NEW_POI_EXPLAIN'); ?>"+'">'
		+"<?php echo JText::_('SHUTTLE_ROUTES_CREATE_NEW_POI');?>"
	+'</span>'
+'</a>';
html += 		'</div>'+
				'<div class="poi_select">'+
				    '<label>'+
					'<span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_STOPS_PRICE_PASSENGER_EXPLAIN'); ?>">'+
					'<?php echo JText::_( 'SHUTTLE_ROUTE_STOPS_PRICE_PASSENGER_LABEL' ).':'; ?>'+
					'</span>'+
				    '</label>'+
				    '<input type="text" class="inputbox" name="stop_price['+i+']" size="20" value="0" />'+
				'</div>'+
				'<div class="poi_select_time clearfix">'+
				    '<label>'+
					'<span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_STOPS_ARRIVAL_EXPLAIN'); ?>">'+
					'<?php echo JText::_( 'SHUTTLE_ROUTE_STOPS_ARRIVAL_LABEL' ).':'; ?>'+
					'</span>'+
				    '</label>';
html += '<select class="arrival_time" id="stop_arrival_hr_'+i+'" name="stop_arrival_hr['+i+']">';
<?php for($i = 0; $i <= 23; $i++){ $value = str_pad($i, 2, '0', STR_PAD_LEFT); ?>
html 	+= '<option value="<?php echo $value;?>">'+"<?php echo $value;?>"+'</option>';
<?php } ?>
html += '</select>';

html += '<select class="arrival_time" id="stop_arrival_min_'+i+'" name="stop_arrival_min['+i+']">';
<?php for($i = 0; $i <= 59; $i++){ $value = str_pad($i, 2, '0', STR_PAD_LEFT); ?>
html 	+= '<option value="<?php echo $value;?>">'+"<?php echo $value;?>"+'</option>';
<?php } ?>
html += '</select>';
	html +=			'</div>'+
			    '</div>'+
			    '<div class="button2-left">'+
				'<div class="blank">'+
				    '<a href="javascript:void(0);" class="remove_stop btn btn-small"><?php echo JText::_('REMOVE'); ?></a>'+
				'</div>'+
			    '</div>'+
			'</div>';
		
		tbjQuery('div#stops_wrapper').append(html);
		
		tbjQuery('html, body').animate({ scrollTop: tbjQuery('div#stops_wrapper div.date_price:last-child').offset().top-80 }, 'fast');
		tbjQuery('div#stops_wrapper div.date_price:last-child .stop_poi').focus();
	})
	tbjQuery.fn.getAvailableShuttles = function() {
		if( xhr != null ) {
			xhr.abort();
			xhr = null;
		}
		tbjQuery('input[name="task"]').val('getAvailableShuttlesAjax');
		var passingData = tbjQuery('#adminForm').serialize();
		    
		xhr = tbjQuery.ajax({
			type: "POST"
			, url: 'index.php?option=com_taxibooking&task=getAvailableShuttlesAjax'
			, data: passingData
			, dataType: 'json'
			, beforeSend: function(){
				tbjQuery('div#available_shuttles_wrap').html("");
				tbjQuery('#available_shuttles_loader').show();
			}
			, complete: function(){
			    
			}
			, success: function(response){
				tbjQuery('#available_shuttles_loader').hide();
				if(response.error==0)
				{
					tbjQuery('div#available_shuttles_wrap').html(response.msg);
				}
				else {
					tbjQuery('div#available_shuttles_wrap').html('<span style="color:red;font-size:15px;">'+response.msg+'</span>');
				}
			}
		})
	}
	tbjQuery(document).on("click", '.remove_stop', function (e) {
		var r = confirm("Are you sure?");
		if (r == true) {
		    tbjQuery(this).closest('div.date_price').remove();
		    tbjQuery('#is_stops_changed').val(1);
			tbjQuery.fn.getAvailableShuttles();
		}
	})
	tbjQuery('div#start_wrapper, div#stops_wrapper').on("change", 'input,select', function (e) {
		tbjQuery('#is_stops_changed').val(1);
	})
	tbjQuery('div#start_wrapper, div#stops_wrapper').on("change", 'select.arrival_time', function (e) {
		if(page_mode=='add'){
			if(tbjQuery('div#stops_wrapper div.date_price').length > 0){
				tbjQuery.fn.getAvailableShuttles();	
			}
		}
		else {
			tbjQuery.fn.getAvailableShuttles();
		}
	})
	tbjQuery('a.get_cars').click(function(){
		tbjQuery.fn.getAvailableShuttles();
	})
	// collect shuttle for route edit mode only
	if(page_mode=='edit'){
		tbjQuery.fn.getAvailableShuttles();
	}
})

function collectNewPOIBlockHtml(btnObj){
	// first all other poi block
	tbjQuery('div.new_poi_wrapper').remove();
	
	if( xhr != null ) {
		xhr.abort();
		xhr = null;
	}
	
	xhr = tbjQuery.ajax({
		type: "POST"
		, url: BASE_URL+'index.php?option=com_taxibooking&controller=shuttles&task=getNewPOIBlockAjax'
		, data: 'stopId=0'
		, dataType: 'json'
		//, async: false
		, beforeSend: function(){
			tbjQuery(btnObj).after('<img src="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/images/ajax-loader.gif" alt="Loading.." id="ajax_loader" />');
		}
		, complete: function(){
		}
		, success: function(response){
			tbjQuery('#ajax_loader').remove();
			
			if(response.error==0){
				tbjQuery(btnObj).parent().after(response.msg);
				
				var poi_input = document.getElementById('poi_title');
				var poi_autocomplete = new google.maps.places.Autocomplete(poi_input, mapOptions);
				google.maps.event.addListener(poi_autocomplete, 'place_changed', function() {
					var place = poi_autocomplete.getPlace();
					if (place.geometry) {
						document.getElementById('poi_lat').value = place.geometry.location.lat();
						document.getElementById('poi_lng').value = place.geometry.location.lng();
					}
				});
			}
			else {
				alert(response.msg);
				return false;
			}
		}
	})
}
function cancelNewPOI(btnObj){
	tbjQuery(btnObj).parent('div.new_poi_wrapper').remove();
}
function saveNewPOI(btnObj){
	if( xhr != null ) {
		xhr.abort();
		xhr = null;
	}
	var postData = tbjQuery(btnObj).parent('div.new_poi_wrapper').find('input').serialize();
	postData += "&"+tbjQuery(btnObj).parent('div.new_poi_wrapper').find('select').serialize();
	
	xhr = tbjQuery.ajax({
		type: "POST"
		, url: BASE_URL+'index.php?option=com_taxibooking&controller=shuttles&task=addPOIAjax'
		, data: postData
		, dataType: 'json'
		//, async: false
		, beforeSend: function(){
			tbjQuery(btnObj).next('a.new_poi_cancel_btn').after('<img src="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/images/ajax-loader.gif" alt="Loading.." id="ajax_loader" />');
		}
		, complete: function(){
		}
		, success: function(response){
			tbjQuery('#ajax_loader').remove();
			
			if(response.error==0){
				tbjQuery(btnObj).parent('div.new_poi_wrapper').prev('div.poi_select').find('.stop_poi').append(tbjQuery('<option>', {
					value: parseInt(response.poiObj.id),
					text: response.poiObj.title
				}));
				tbjQuery(btnObj).parent('div.new_poi_wrapper').prev('div.poi_select').find('.stop_poi').val(parseInt(response.poiObj.id));
				tbjQuery(btnObj).closest('div.new_poi_wrapper').remove();
			}
			else {
				alert(response.msg);
				return false;
			}
		}
	})
}
</script>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/shuttles.css" />

<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="adminform form-validate">

<div class="adminformWrap clearfix">
	<div class="adminform">
	
		<div class="inutWrap clearfix">
			<label for="title">
				<span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_TITLE_EXPLAIN'); ?>">
					<?php echo JText::_( 'SHUTTLE_ROUTE_TITLE_LABEL' ).':'; ?>
				</span>
			</label>
			<input type="text" name="title" value="<?php echo $this->item->title; ?>" class="inputbox required" maxlength="100" />
		</div>
		<div class="inutWrap clearfix">
			<label for="title">
				<?php echo JText::_( 'ALIAS' ).':'; ?>
			</label>
			<input type="text" name="alias" value="<?php echo $this->item->alias; ?>" class="inputbox" placeholder="<?php echo JText::_('JFIELD_ALIAS_PLACEHOLDER');?>" />
		</div>
		<div class="inutWrap clearfix">
			<label for="language">
				<span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_LANGUAGE_EXPLAIN'); ?>">
					<?php echo JText::_( 'JFIELD_LANGUAGE_LABEL' ).':'; ?>
				</span>
			</label>
			<?php 
			echo $this->lists['languages'];
			?>
		</div>	
		<div class="inutWrap clearfix">
			<label for="published">
				<span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_PUBLISHED_EXPLAIN'); ?>">
					<?php echo JText::_( 'SHUTTLE_ROUTE_PUBLISHED_LABEL' ).':'; ?>
				</span>
			</label>
			<?php
			echo JHTML::_('select.booleanlist', 'published', 'class="inputbox"', $this->item->published );
			?>
		</div>
		
		<div class="inutWrap clearfix">
			<label class="start hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_START_EXPLAIN'); ?>">
			    <?php echo JText::_('SHUTTLE_ROUTE_START_LABEL'); ?>
			</label>
			<?php 
			$poi_id = !empty($this->addedstops[0]->poi_id) ? $this->addedstops[0]->poi_id : 0;
			$price_per_passenger = 0;
			$arrival_time = !empty($this->addedstops[0]->arrival_time) ? explode(':',$this->addedstops[0]->arrival_time) : 0;
			?>
			<div id="start_wrapper">
				<div class="date_price row0 clearfix">
				   <div class="fltlft">
				       <div class="poi_select">
					   <label>
					       <span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_STOPS_POI_EXPLAIN'); ?>">
					       <?php echo JText::_( 'SHUTTLE_ROUTE_STOPS_POI_LABEL' ).':'; ?>
					       </span>
					   </label>
					   <select class="stop_poi" id="stop_poi_0" name="stop_poi[0]">
						<option value="0"><?php echo JText::_( 'SELECT_POI' );?></option>
					<?php
					for($i = 0; $i < count($this->availablepois); $i++){
						$selected = ($this->availablepois[$i]->id==$poi_id) ? ' selected="selected"' : '';
						?>
					<option value="<?php echo $this->availablepois[$i]->id;?>"<?php echo $selected;?>><?php echo $this->availablepois[$i]->title;?></option>
					<?php } ?>
					</select> Or 
					<a href="javascript:void(0);" class="route_new_poi_trigger" onclick="collectNewPOIBlockHtml(this);">
						<span class="hasTip control-label btn btn-small" title="<?php echo JText::_('SHUTTLE_ROUTES_CREATE_NEW_POI_EXPLAIN'); ?>">
							<?php echo JText::_('SHUTTLE_ROUTES_CREATE_NEW_POI');?>
						</span>
					</a>
				       </div>
				       
					   <input type="hidden" name="stop_price[0]" value="0" />
				       <div class="poi_select_time clearfix">
					   <label>
					       <span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_STOPS_ARRIVAL_EXPLAIN'); ?>">
					       <?php echo JText::_( 'SHUTTLE_ROUTE_STOPS_ARRIVAL_LABEL' ).':'; ?>
					       </span>
					   </label>
					   <?php
					   echo JHTML::_('select.genericlist', $hr_options, "stop_arrival_hr[0]", 'class="arrival_time"', 'value', 'text', $arrival_time[0] );
					   ?> : 
					   <?php
					   echo JHTML::_('select.genericlist', $min_options, "stop_arrival_min[0]", 'class="arrival_time"', 'value', 'text', $arrival_time[1] );
					   ?>
				       </div>
				   </div>
			       </div>
			</div>
		</div>
		
		<div class="inutWrap clearfix">
			<label class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_STOPS_EXPLAIN'); ?>">
			    <?php echo JText::_('SHUTTLE_ROUTE_STOPS_LABEL'); ?>
			</label>
			<div id="stops_wrapper">
				<div class="date_price_add clearfix">
					<div class="button2-left">
						<div class="blank">
							<a class="btn btn-small" href="javascript:void(0);" id="add_stop"><?php echo JText::_('ADD_NEW'); ?></a>
						</div>
					</div>
				</div>
				
				<?php
				for($i = 1; $i < count($this->addedstops); $i++)
				{
					$poi_id = !empty($this->addedstops[$i]->poi_id) ? $this->addedstops[$i]->poi_id : 0;
					$price_per_passenger = !empty($this->addedstops[$i]->price_per_passenger) ? $this->addedstops[$i]->price_per_passenger : 0;
					$arrival_time = !empty($this->addedstops[$i]->arrival_time) ? explode(':',$this->addedstops[$i]->arrival_time) : 0;
				?>    
				<div class="date_price clearfix <?php echo 'row'.$i;?>">
				    <div class="fltlft">
					<div class="poi_select">
					    <label>
						<span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_STOPS_POI_EXPLAIN'); ?>">
						<?php echo JText::_( 'SHUTTLE_ROUTE_STOPS_POI_LABEL' ).':'; ?>
						</span>
					    </label>
					    <select class="stop_poi" id="stop_poi_<?php echo $i;?>" name="stop_poi[<?php echo $i;?>]">
						<option value="0"><?php echo JText::_( 'SELECT_POI' );?></option>
					<?php
					for($counter = 0; $counter < count($this->availablepois); $counter++){
						$selected = ($this->availablepois[$counter]->id==$poi_id) ? ' selected="selected"' : '';
						?>
					<option value="<?php echo $this->availablepois[$counter]->id;?>"<?php echo $selected;?>><?php echo $this->availablepois[$counter]->title;?></option>
					<?php } ?>
					</select> Or 
					<a href="javascript:void(0);" class="route_new_poi_trigger" onclick="collectNewPOIBlockHtml(this);">
						<span class="hasTip control-label btn btn-small" title="<?php echo JText::_('SHUTTLE_ROUTES_CREATE_NEW_POI_EXPLAIN'); ?>">
							<?php echo JText::_('SHUTTLE_ROUTES_CREATE_NEW_POI');?>
						</span>
					</a>
					</div>
					<div class="poi_select">
					    <label>
						<span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_STOPS_PRICE_PASSENGER_EXPLAIN'); ?>">
						<?php echo JText::_( 'SHUTTLE_ROUTE_STOPS_PRICE_PASSENGER_LABEL' ).':'; ?>
						</span>
					    </label>
					    <input type="text" class="inputbox" name="stop_price[<?php echo $i;?>]" size="20" value="<?php echo $price_per_passenger;?>" />
					</div>
					<div class="poi_select_time clearfix">
					    <label>
						<span class="hasTip control-label" title="<?php echo JText::_('SHUTTLE_ROUTE_STOPS_ARRIVAL_EXPLAIN'); ?>">
						<?php echo JText::_( 'SHUTTLE_ROUTE_STOPS_ARRIVAL_LABEL' ).':'; ?>
						</span>
					    </label>
					    <?php
					    echo JHTML::_('select.genericlist', $hr_options, "stop_arrival_hr[$i]", 'class="arrival_time"', 'value', 'text', $arrival_time[0] );
					    ?> : 
					    <?php
					    echo JHTML::_('select.genericlist', $min_options, "stop_arrival_min[$i]", 'class="arrival_time"', 'value', 'text', $arrival_time[1] );
					    ?>
					</div>
				    </div>
				    <div class="button2-left">
					<div class="blank">
					    <a href="javascript:void(0);" class="remove_stop btn btn-small"><?php echo JText::_('REMOVE'); ?></a>
					</div>
				    </div>
				</div>
				<?php 
				}
				?>
			</div>
		</div>
		
		<div class="no-more-tables_style2">
			<div class="button2-left">
				<div class="blank">
					<a href="javascript:void(0);" class="get_cars btn"><?php echo JText::_('SHUTTLE_ROUTE_ASSIGN_CAR_LABEL'); ?></a>
				</div>
			</div>			
			<div class="clearfix"></div>
			<div id="available_shuttles_loader" style="display:none;margin:20px;">
				<img src="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/images/ajax-loader-bar.gif" alt="Loading.." />
			</div>
			<!-- shuttles will be listed by ajax -->
			<div id="available_shuttles_wrap" style="margin: 20px 0;">
				<input type="hidden" name="car_id" value="0" />
			</div>
		</div>			
	
	</div>
	
	<div class="adminform editor">
		<label for="body">
			<?php echo JText::_( 'SHUTTLE_ROUTE_DESCRIPTION_LABEL' ).':'; ?>
		</label>
		<?php
		// parameters : areaname, content, hidden field, width, height, rows, cols
		echo $this->editor->display( 'text',  $this->item->text, '100%;', '300', '35', '10', array('pagebreak') ) ;
		?>
	</div>
</div>

<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="option" value="com_taxibooking" />
<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
<input type="hidden" name="controller" value="shuttles" />
<input type="hidden" name="view" value="shuttle" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="is_stops_changed" id="is_stops_changed" value="0" />
</form>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>