<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * View class 
 */
class TaxibookingViewShuttle extends JViewLegacy
{
	protected $item;
    
	protected $state;
    
	/**
	* Display the view
	*
	* @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	*
	* @return  void
	*/
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		$config = JFactory::getConfig();
		
		$this->elsettings 	= booking_helper::config();
		$this->item	= $this->get('Item');
		$this->state	= $this->get('State');
		$isNew		= ($this->item->id == 0);
		$this->editor =  JFactory::getEditor();
	
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		//build selectlists
		$this->lists = $this->_buildEditLists($this->item);
		$this->addedstops = $this->_getAddedStops($this->item);
		$this->availablepois = $this->_getAvailablePOIs();
		
		// get country 2 code for google autocomplete
		$country_2_code = booking_helper::get_country_field($this->elsettings->default_country, 'country_2_code');
		$country_2_code = ($country_2_code == '') ? 'US' : $country_2_code;
		$this->assignRef('default_country', $country_2_code);
		
		$this->addToolbar();

		parent::display($tpl);
	}
	
	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		JFactory::getApplication()->input->set('hidemainmenu', true);
	
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();
	
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
	    
		JToolbarHelper::title($isNew ? JText::_('COM_TAXIBOOKING_MANAGER_SHUTTLE_NEW') : JText::_('COM_TAXIBOOKING_MANAGER_SHUTTLE_EDIT'), 'generic');
		
		// If not checked out, can save the item.
		if (!$checkedOut)
		{
			JToolbarHelper::apply();
			JToolbarHelper::save();
		}
		
		JToolbarHelper::cancel();
	}
	
	/**
	 * Creates list
	 *
	 * @since 1.0
	 */
	private function _buildEditLists($item)
	{
		$db = JFactory::getDBO();
		
		$options = array();
                $options[] = JHTML::_('select.option',  '*', JText::_( 'JALL' ) );
		$rows = JHtml::_('contentlanguage.existing');
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->value, $row->text);
			}
                }
                $lists['languages'] = JHTML::_('select.genericlist', $options, 'language', '', 'value', 'text', $item->language );
		
		return $lists;
	}
	
	private function _getAvailablePOIs()
	{
                $db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_points');
		$query->where('published = "1"');
		$query->order('title ASC');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
		
		return $rows;
	}
	
	private function _getAddedStops($item)
	{
                $db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_shuttle_route_stops');
		$query->where('route_id = '.$db->Quote($item->id));
		$query->where('published = "1"');
		$query->order('id ASC');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
		
		return $rows;
	}
}