<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$saveOrder	= $listOrder=='ordering';
$params		= (isset($this->state->params)) ? $this->state->params : new JObject();

if(version_compare(JVERSION,'3.1.5','ge'))
{
	if ($saveOrder)
	{
		$saveOrderingUrl = 'index.php?option=com_taxibooking&task=saveOrderAjax&tmpl=component';
		JHtml::_('sortablelist.sortable', 'articleList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
	}
}
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/shuttles.css" />

<div>
<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&view=shuttles'); ?>" method="post" name="adminForm" id="adminForm">

	<div class="routes_adminform clearfix">
		<div class="routes_left_adminform clearfix">
			<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
			<label><?php echo JText::_( 'SEARCH' ); ?></label>
			<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" class="hasTooltip inputbox" />
			<button type="submit" class="btn hasTooltip"><i class="icon-search"></i></button>
			<button type="button" class="btn hasTooltip" onclick="document.id('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
			<?php } else { ?>
			<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
			<input type="text" name="filter_search" id="filter_search" class="inputbox" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" />
			<button type="submit"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
			<button type="button" onclick="document.id('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			<?php } ?>
		</div>
		<div class="routes_right_adminform clearfix">				
			<select name="filter_state" class="inputbox" onchange="this.form.submit()">
				<option value=""><?php echo JText::_('JOPTION_SELECT_PUBLISHED');?></option>
				<?php echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.state'), true);?>
			</select>
		</div>
	</div>

	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
	<table class="table table-striped no-more-tables" id="articleList">
	<?php } else { ?>
	<table class="adminlist">
	<?php } ?>
	
	<thead>
		<tr>
			<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
			<th width="1%" class="nowrap center hidden-phone">
				<?php echo JHtml::_('grid.sort', '<i class="icon-menu-2"></i>', 'ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING'); ?>
			</th>
			<th width="5">
				<?php echo JHtml::_('grid.checkall'); ?>
			</th>
			<?php } else { ?>
			<th width="1%">
				<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
			</th>
			<?php } ?>
			
			<th class="title numeric"><?php echo JHTML::_('grid.sort', 'TITLE', 'a.title', $listDirn, $listOrder ); ?></th>
			<th class="title numeric"><?php echo JText::_('HEADER_ASSIGNED_SHUTTLE'); ?></th>
			<th class="title numeric"><?php echo JText::_('HEADER_ASSIGNED_STOPS'); ?></th>
			<th width="5%" class="nowrap center numeric">
				<?php echo JHtml::_('grid.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
			</th>
			<th width="10%" class="numeric">
				<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_LANGUAGE', 'language', $listDirn, $listOrder); ?>
			</th>
			
			<?php if(!version_compare(JVERSION,'3.1.5','ge')) {?>
			<th width="10%" class="numeric">
				<?php echo JHTML::_('grid.sort',  'JGRID_HEADING_ORDERING', 'ordering', $listDirn, $listOrder); ?>
				<?php if ($saveOrder): ?>
					<?php echo JHtml::_('grid.order',  $this->items, 'filesave.png', 'saveorder'); ?>
				<?php endif;?>
			</th>
			<?php } ?>
			
			<th width="1%" class="nowrap numeric">
				<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
			</th>
		</tr>
	</thead>

	<tbody>
		<?php
		$k = 0;
		for ($i=0, $n=count($this->items); $i < $n; $i++) {
			$row = $this->items[$i];
			$ordering	= ($listOrder == 'ordering');

			$link 		= 'index.php?option=com_taxibooking&amp;controller=shuttles&amp;task=edit&amp;cid[]='. $row->id;
			$checked 	= JHTML::_('grid.id', $i, $row->id);
                        $published 	= JHTML::_('jgrid.published', $row->published, $i );
			
   		?>
		<tr class="<?php echo "row$k"; ?>">
			<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
			<td data-title="one" class="order nowrap center hidden-phone hidden-tablet">
				<?php
				$iconClass = '';
				if (!$saveOrder)
				{
					$iconClass = ' inactive tip-top hasTooltip" title="' . JHtml::tooltipText('JORDERINGDISABLED');
				}
				?>
				<span class="sortable-handler <?php echo $iconClass ?>">
					<i class="icon-menu"></i>
				</span>
				<?php if ($saveOrder) : ?>
					<input type="text" style="display:none" name="order[]" size="5"
						value="<?php echo $row->ordering; ?>" class="width-20 text-area-order " />
				<?php endif; ?>
			</td>
			<?php } ?>
			
			<td data-title="&nbsp;" class=""><?php echo $checked; ?></td>
			<td data-title="<?php echo JText::_('TITLE');?>" class="numeric" align="left">
				<?php if ($row->checked_out) : ?>
					<?php echo JHtml::_('jgrid.checkedout', $i, $row->checked_out, $row->checked_out_time, '', true); ?>
				<?php endif; ?>
                            <span>
                            <a href="<?php echo $link; ?>">
                            <?php echo htmlspecialchars($row->title, ENT_QUOTES, 'UTF-8'); ?>
                            </a>
			    </span>
				
			</td>
			<td data-title="<?php echo JText::_('HEADER_ASSIGNED_SHUTTLE');?>" class="numeric" align="center">
				<a href="<?php echo 'index.php?option=com_taxibooking&amp;controller=cars&amp;task=show&amp;cid[]='. $row->car_id; ?>" target="blank">
					<?php echo $row->shuttle_car; ?>
				</a>
			</td>
			<td data-title="<?php echo JText::_('HEADER_ASSIGNED_STOPS');?>" class="numeric" align="center"><?php echo $row->stops_txt; ?></td>
			<td data-title="<?php echo JText::_('JSTATUS');?>" class="numeric" align="center"><?php echo $published; ?></td>
			<td data-title="<?php echo JText::_('JGRID_HEADING_LANGUAGE');?>" class="numeric">
				<?php if ($row->language=='*'):?>
					<?php echo JText::alt('JALL', 'language'); ?>
				<?php else:?>
					<?php echo $row->language_title ? $this->escape($row->language_title) : JText::_('JUNDEFINED'); ?>
				<?php endif;?>
			</td>
			
			<?php if(!version_compare(JVERSION,'3.1.5','ge')) {?>
			<td class="order">
			<?php if ($saveOrder) : ?>
				<?php if ($listDirn == 'asc') : ?>
					<span><?php echo $this->pagination->orderUpIcon( $i, true, 'orderup', 'JLIB_HTML_MOVE_UP', $ordering ); ?></span>
					<span><?php echo $this->pagination->orderDownIcon( $i, $n, true, 'orderdown', 'JLIB_HTML_MOVE_DOWN', $ordering );?></span>
					
				<?php elseif ($listDirn == 'desc') : ?>
					<span><?php echo $this->pagination->orderUpIcon( $i, true, 'orderdown', 'JLIB_HTML_MOVE_UP', $ordering ); ?></span>
					<span><?php echo $this->pagination->orderDownIcon( $i, $n, true, 'orderup', 'JLIB_HTML_MOVE_DOWN', $ordering );?></span>
				<?php endif; ?>
			<?php endif; ?>
				<?php $disabled = $saveOrder ?  '' : 'disabled="disabled"'; ?>
				<input type="text" name="order[]" size="5" value="<?php echo $row->ordering;?>" <?php echo $disabled; ?> class="text-area-order" />
			</td>
			<?php } ?>
			
			<td data-title="<?php echo JText::_('JGRID_HEADING_ID');?>" class="numeric" align="center"><?php echo $row->id; ?></td>
		</tr>
		<?php $k = 1 - $k; } ?>
	</tbody>
	
	<tfoot>
		<tr>
			<td colspan="8">
				<?php echo $this->pagination->getListFooter(); ?>
			</td>
		</tr>
	</tfoot>	

	</table>
	

	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="option" value="com_taxibooking" />
	<input type="hidden" name="controller" value="shuttles" />
	<input type="hidden" name="view" value="shuttles" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
</div>