<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * View class for a list of shuttle.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.6
 */
class TaxibookingViewShuttles extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Method to display the view.
	 *
	 * @param   string  $tpl  A template file to load. [optional]
	 *
	 * @return  mixed  A string if successful, otherwise a JError object.
	 *
	 * @since   1.6
	 */
	public function display($tpl = null)
	{
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		// prepare stops html for each route
		if(!empty($this->items)){
			foreach($this->items as $item){
				$item->stops_txt = $this->_getStops($item);
			}
		}
		
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		TaxibookingHelper::addSubmenu('shuttles');

		$this->addToolbar();
		
		parent::display($tpl);
	}
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();

		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('SHUTTLE_ROUTES'), 'generic');

		if ($canDo->get('core.create'))
		{
			JToolbarHelper::addNew();
		}
		if (($canDo->get('core.edit')))
		{
			JToolbarHelper::editList();
		}
		if ($canDo->get('core.edit.state'))
		{
			JToolbarHelper::checkin();
			JToolbarHelper::publish('publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('unpublish', 'JTOOLBAR_UNPUBLISH', true);
		}
		if ($canDo->get('core.delete'))
		{
			JToolbarHelper::deleteList('Are you sure?', 'remove', 'JTOOLBAR_DELETE');
		}
		if ($canDo->get('core.create'))
		{
			JToolBarHelper::custom('duplicate', 'copy.png', 'copy_f2.png', 'JTOOLBAR_DUPLICATE', true);
		}
		
		if ($user->authorise('core.admin', 'com_taxibooking'))
		{
			JToolbarHelper::preferences('com_taxibooking');
		}
	}
	private function _getStops($item)
	{
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('p.id, p.title, rs.arrival_time');
		$query->from('#__taxibooking_shuttle_route_stops AS rs');
		$query->join('LEFT', $db->quoteName('#__taxibooking_points') . ' AS p ON rs.poi_id = p.id');
		$query->where('rs.route_id = '.(int)$item->id);
		$query->order('rs.ordering');
		
		$db->setQuery((string)$query);
		$stops = $db->loadObjectList();
		
		$stops_txt = '';
		if(!empty($stops)){
			foreach($stops as $stop){
				$stops_txt .= $stop->title.' on '.$stop->arrival_time.'<br>';
			}
		}
		
		return $stops_txt;
	}
}