<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * View to edit an tariff.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.5
 */
class TaxiBookingViewTariff extends JViewLegacy
{
	protected $item;
    
	protected $state;
    
	/**
	* Display the view
	*
	* @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	*
	* @return  void
	*/
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		
		$this->item	= $this->get('Item');
		$this->cars     = $this->get( 'Cars' );
		$this->state	= $this->get('State');
		$isNew		= ($this->item->id == 0);
		$this->editor =  JFactory::getEditor();
	
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
	
			return false;
		}
		
		if($isNew){
			$this->blocked_dates_arr = array();
			$this->days_availability = unserialize('a:7:{i:0;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:1;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:2;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:3;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:4;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:5;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}i:6;a:4:{s:11:"opening_hrs";s:2:"-1";s:12:"opening_mins";s:2:"-1";s:11:"closing_hrs";s:2:"-1";s:12:"closing_mins";s:2:"-1";}}');
		}
		else {
			$this->blocked_dates_arr = unserialize($this->item->special_dates);
			$this->days_availability = unserialize($this->item->days_availability);
		}
		
		//build selectlists
		$this->lists = $this->_buildEditLists($this->item);
	
		$this->addToolbar();
		parent::display($tpl);
	}
	
	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		JFactory::getApplication()->input->set('hidemainmenu', true);
	
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();
	
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
	    
		JToolbarHelper::title($isNew ? JText::_('COM_TAXIBOOKING_MANAGER_TARIFF_NEW') : JText::_('COM_TAXIBOOKING_MANAGER_TARIFF_EDIT'), 'generic');
		
		// If not checked out, can save the item.
		if (!$checkedOut)
		{
			JToolbarHelper::apply();
			JToolbarHelper::save();
		}
		
		JToolbarHelper::cancel();
	}
	
	/**
	 * Creates list
	 *
	 * @since 1.0
	 */
	private function _buildEditLists($item)
	{
                $db = JFactory::getDBO();
		
		// now list cars
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_cars');
		$query->where('published = 1');
		$query->where('use_as_shuttle != 2');
		$query->where('use_in_address = 1');
		$query->order('title ASC');
		$db->setQuery((string)$query);
		$rows = $db->loadObjectList();
                
		$options = array();
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->id, $row->title );
			}
                }
                $lists['cars'] = JHTML::_('select.genericlist', $options, 'car_ids[]', 'multiple="multiple" size="8"', 'value', 'text', explode(',',$item->assigned_cars) );
		
		$options = array();
                $options[] = JHTML::_('select.option',  '*', JText::_( 'JALL' ) );
		$rows = JHtml::_('contentlanguage.existing');
                if(!empty($rows)){
			foreach ($rows as $row){
				$options[] = JHTML::_('select.option',  $row->value, $row->text);
			}
                }
                $lists['languages'] = JHTML::_('select.genericlist', $options, 'language', '', 'value', 'text', $item->language );
		
		return $lists;
	}
}