<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * View class for a list of tariffs.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.6
 */
class TaxibookingViewTariffs extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Method to display the view.
	 *
	 * @param   string  $tpl  A template file to load. [optional]
	 *
	 * @return  mixed  A string if successful, otherwise a JError object.
	 *
	 * @since   1.6
	 */
	public function display($tpl = null)
	{
		$db = JFactory::getDBO();
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		if(!empty($this->items)){
			foreach($this->items as $item){
				if($item->assigned_cars!=""){
					$query = $db->getQuery(true);
					$query->select('*');
					$query->from('#__taxibooking_cars');
					$query->where('id IN ('.$item->assigned_cars.')');
					$query->order('title ASC');
					$db->setQuery((string)$query);
					$cars = $db->loadObjectList();
					
					$assigned_cars = array();
					if(!empty($cars)){
						foreach($cars as $car){
							$assigned_cars[] = '<a href="index.php?option=com_taxibooking&amp;controller=cars&amp;task=show&amp;cid[]='. $car->id.'">'.$car->title.'</a>';
						}
					}
					
					$item->assigned_cars = implode(', ', $assigned_cars);
				}
			}
		}
		
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		TaxibookingHelper::addSubmenu('tariffs');
		
		$this->addToolbar();
		
		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();

		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('DASHBOARD_TARIFFS'), 'generic');

		if ($canDo->get('core.create'))
		{
			JToolbarHelper::addNew();
		}
		if (($canDo->get('core.edit')))
		{
			JToolbarHelper::editList();
		}
		if ($canDo->get('core.edit.state'))
		{
			JToolbarHelper::checkin();
			JToolbarHelper::publish('publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('unpublish', 'JTOOLBAR_UNPUBLISH', true);
		}
		if ($canDo->get('core.delete'))
		{
			JToolbarHelper::deleteList('Are you sure?', 'remove', 'JTOOLBAR_DELETE');
		}
		if ($canDo->get('core.create'))
		{
			JToolBarHelper::custom('duplicate', 'copy.png', 'copy_f2.png', 'JTOOLBAR_DUPLICATE', true);
		}
		if ($user->authorise('core.admin', 'com_taxibooking'))
		{
			JToolbarHelper::preferences('com_taxibooking');
		}
	}
}