<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

if(version_compare(JVERSION,'3.1.5','le')) {?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<?php } ?>
<script type="text/javascript">
var tbjQuery = jQuery.noConflict();
var BASE_URL = '<?php echo JURI::root();?>';
var total_order = '<?php echo $this->total_order;?>';
<?php echo $this->order_ids_fixing;?>
</script>

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-ui.js"></script>
<link rel="stylesheet" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery-ui.css" />
<script type="text/javascript">
tbjQuery(document).ready(function(){
	tbjQuery( "#fixorder-progressbar" ).progressbar({
		value: 0,
		max: parseInt(total_order),
		complete: function( event, ui ) {
			tbjQuery.ajax({
				type: "POST"
				, url: 'index.php?option=com_taxibooking&task=completeFixingOrderAjax'
				, data: ''
				, dataType: 'json'
				, beforeSend: function(){
				}
				, complete: function(){
					location.reload();
				}
				, success: function(response){
				}
			})
		}
	});
	tbjQuery.fn.fixOrder = function(counter) {
		tbjQuery.ajax({
		    type: "POST"
		    , url: 'index.php?option=com_taxibooking&task=fixOrderAjax'
		    , data: 'order_id='+order_ids_fixing[counter]
		    , dataType: 'json'
		    , beforeSend: function(){
		    }
		    , complete: function(){
			if(counter<parseInt(total_order)){
				tbjQuery.fn.fixOrder(counter);
			}
		    }
		    , success: function(response){
			counter = counter+1;
			tbjQuery( "#fixorder-progressbar" ).progressbar( "value", counter );
			
		    }
		})
	}
	tbjQuery('a.startfix').click(function(){
		tbjQuery('div.fixorder-progress-wrap').show();
		tbjQuery.fn.fixOrder(0);
	})
	tbjQuery('a.startdatabasefix').click(function(){
		tbjQuery.ajax({
			type: "POST"
			, url: 'index.php?option=com_taxibooking&task=fixDatabaseAjax'
			, data: ''
			, dataType: 'json'
			, beforeSend: function(){
			}
			, complete: function(){
				location.reload();
			}
			, success: function(response){
			}
		})
	})
})
</script>
<table cellspacing="0" cellpadding="0" border="0" width="100%">
	<tr>
		<td valign="top">
		<table class="adminlist">
			<tr>
				<td>
					<div id="cpanel">
					<?php
					$option = 'com_taxibooking';
					
					if ($this->user->authorise('core.config', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=configs';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'settings.png', JText::_('SETTINGS') );
					}
					
					if ($this->user->authorise('core.manage.payments', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=paymentmethods';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'payment-methods.png', JText::_( 'PAYMENT_METHODS') );
					}
					
					if ($this->user->authorise('core.manage.poicats', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=poicats';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'poi-categories.png', JText::_( 'INTEREST_POINTS_CATEGORIES') );
					}
					
					if ($this->user->authorise('core.manage.pois', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=points';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'poi.png', JText::_( 'INTEREST_POINTS') );
					}
					
					if ($this->user->authorise('core.manage.cars', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=cars';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'cars.png', JText::_( 'CARS') );
					}
					
					if ($this->user->authorise('core.manage.tariffs', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=tariffs';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'tariffs.png', JText::_( 'DASHBOARD_TARIFFS') );
					}
					
					if ($this->user->authorise('core.manage.specialroutes', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=routes';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'special-routes.png', JText::_( 'ROUTES') );
					}
					
					if ($this->user->authorise('core.manage.shuttles', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=shuttles';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'shuttles.png', JText::_( 'SHUTTLE_ROUTES') );
					}
					
					if ($this->user->authorise('core.manage.customfields', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=fields';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'custom-fields.png', JText::_( 'CUSTOM_FIELDS') );
					}
					
					if ($this->user->authorise('core.manage.coupons', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=coupons';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'coupon-code.png', JText::_( 'COUPONS') );
					}
					
					if ($this->user->authorise('core.manage.calendar', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=calendar';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'calendar.png', JText::_('SUBMENU_BOOKING_CALENDAR') );
					}
					
					if ($this->user->authorise('core.manage.orders', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=orders';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'orders.png', JText::_( 'ORDERS') );
					}
					
					if ($this->user->authorise('core.manage.users', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=tbusers';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'users.png', JText::_('SUBMENU_BOOKING_USERS') );
					}
					
					
					
					if ($this->user->authorise('core.manage.searchurls', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=searchurls';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'url-building.png', JText::_('SUBMENU_BOOKING_SEARCHURLS') );
					}

					if ($this->user->authorise('core.manage.searchurls', 'com_taxibooking'))
					{
						$link = 'index.php?option='.$option.'&amp;view=drivers';
						TaxiBookingViewTaxiBooking::quickiconButton( $link, 'cars.png', 'Upcoming trips' );
					}
					
					
					?>
					
					
					
					</div>
				</td>
			</tr>
		</table>
		</td>
	</tr>
</table>

<?php
$order_fixing_used = $this->params->get('order_fixing_used', 0);
if($this->total_order > 0 && $order_fixing_used==0){ ?>
<div class="fixorder" style="text-align: center;">
	<div class="fixorder-explain"><?php echo JText::_('DASHBOARD_FIX_ORDER_EXPLAIN');?></div>
	<a href="javascript:void(0);" class="startfix btn"><?php echo JText::_('DASHBOARD_FIX_ORDER_BUTTON');?></a>
	<div class="fixorder-progress-wrap" style="display:none;"><div id="fixorder-progressbar"></div></div>
</div>
<?php } ?>

<?php
if($this->has_database_fix){ ?>
<div class="fixorder" style="text-align: center;">
	<div class="fixorder-explain"><?php echo JText::_('DASHBOARD_FIX_DATABASE_EXPLAIN');?></div>
	<a href="javascript:void(0);" class="startdatabasefix btn"><?php echo JText::_('DASHBOARD_FIX_DATABASE_BUTTON');?></a>
</div>
<?php } ?>