<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 * View class for dashboard.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 * @since       1.6
 */
class TaxiBookingViewTaxiBooking extends JViewLegacy
{
	/**
	 * Creates the Entrypage
	 *
	 * @since 1.0
	 */
	function display( $tpl = null )
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		TaxibookingHelper::addSubmenu('taxibooking');
		
		$this->user = JFactory::getUser();
		$this->params = JComponentHelper::getParams('com_taxibooking');
		
		list($total_order, $orders) = $this->getTotalOrder();
		$this->total_order = $total_order;
		
		$temp = array();
		for($i = 0; $i < $total_order; $i++){
			$temp[] = $orders[$i]->id;
		}
		$js_array = json_encode($temp);
		$temp = "var order_ids_fixing = ".$js_array . ";\n";
		
		$this->order_ids_fixing = $temp;
		
		$this->has_database_fix = $this->isDatabaseFixingRequired();
		
		$this->addToolbar();
		
		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function getTotalOrder()
	{
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_orders');
		$query->where('(pickup_lat = 0 OR pickup_lng = 0 OR dropoff_lat = 0 OR dropoff_lng = 0)');
		//$query->where('booking_type != "hourly"');
		$query->where('`begin` != ""');
		$query->where('`end` != ""');
		$query->order('id ASC');
		$db->setQuery((string)$query);
		$db->execute();
		$total = (int) $db->getNumRows();
		$rows = $db->loadObjectList();
		
		return array($total, $rows);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();

		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('Taxi Booking'), 'generic');
		
		if ($user->authorise('core.admin', 'com_taxibooking'))
		{
			JToolbarHelper::preferences('com_taxibooking');
		}
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function isDatabaseFixingRequired()
	{
		$fixing_needed = FALSE;
		$db = JFactory::getDBO();
		$tablename = '#__taxibooking_orders';
		
		$missing_fields = array(
			'shuttle_route_id'  => 'INT NOT NULL DEFAULT \'0\' AFTER `coupon_used`',
			'gratuity_amt'  => 'FLOAT( 10, 2 ) NOT NULL DEFAULT \'0\'',
			'gratuity_amttype'  => 'CHAR( 10 ) NOT NULL DEFAULT \'flat\'',
			'gratuity_percent_value' => 'FLOAT( 10, 2 ) NOT NULL DEFAULT \'0\''
		);
		
		$current_fields = array();
		$db->setQuery('SHOW COLUMNS FROM '.$db->quoteName($tablename));
		$rows = $db->loadObjectList();
		if(!empty($rows))
		{
			foreach($rows as $row){
				$current_fields[] = $row->Field;
			}
		}
		
		foreach ($missing_fields as $fieldname => $fieldtype)
		{
			if(!in_array($fieldname,$current_fields))
			{
				$fixing_needed = TRUE;
				break;
			}
		}
		return $fixing_needed;
	}
	
	/**
	 * Creates the buttons view
	 *
	 * @param string $link targeturl
	 * @param string $image path to image
	 * @param string $text image description
	 * @param boolean $modal 1 for loading in modal
	 */
	public static function quickiconButton( $link, $image, $text, $modal = 0 )
	{
		//initialise variables
		$lang 		=  JFactory::getLanguage();
  		?>

		<div style="float:<?php echo ($lang->isRTL()) ? 'right' : 'left'; ?>;width:120px;text-align:center;">
			<div class="icon">
				<?php
				if ($modal == 1) {
					JHTML::_('behavior.modal');
				?>
					<a href="<?php echo $link.'&amp;tmpl=component'; ?>" style="cursor:pointer" class="modal" rel="{handler: 'iframe', size: {x: 650, y: 400}}">
				<?php
				} else {
				?>
					<a href="<?php echo $link; ?>">
				<?php
				}
				
				if(version_compare(JVERSION,'3.1.5','ge')) {
					$img_attr = '';
				}
				else {
					$img_attr = 'style="width:80px;"';
				}

					echo JHTML::_('image', JURI::base().'components/com_taxibooking/assets/images/'.$image, $text, $img_attr );
				?>
					<span><?php echo $text; ?></span>
				</a>
			</div>
		</div>
		<?php
	}
}