<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

// Load the modal behavior script.
JHtml::_('behavior.modal', 'a.modal');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');

$input     = JFactory::getApplication()->input;
$field     = $input->getCmd('field');
?>

<script language="javascript" type="text/javascript">
var xhr = null;
var BASE_URL = '<?php echo JURI::root();?>';
var page_mode = '<?php echo ($this->item->id > 0) ? 'edit' : 'add' ?>';

Joomla.submitbutton = function(task)
{
    if(page_mode=='edit' && task != 'cancel'){
	var r = confirm("<?php echo JText::_('TBUSERS_SAVE_USER_WARNING');?>");
	if (r == false) {
	    return false;
	}
    }
    if (task == 'cancel' || document.formvalidator.isValid(document.id('adminForm')))
    {
	Joomla.submitform(task, document.getElementById('adminForm'));
    }
}
</script>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/tbusers.css" />

<script type="text/javascript">
var tbjQuery = jQuery.noConflict( );
tbjQuery(document).ready(function(){
    if(page_mode=='edit'){
	tbjQuery('input[name="email"]').attr('readonly', true);
    }
    tbjQuery('input[name="is_driver"]').click(function(){
	if(tbjQuery(this).val()==1){ // YES
	    tbjQuery('div.driver_option').show();
	    tbjQuery('div#user_phone_wrap').hide();
	}
	else {
	    tbjQuery('div.driver_option').hide();
	    tbjQuery('div#user_phone_wrap').show();
	}
    })
    tbjQuery('input[name="is_corporate_client"]').click(function(){
	if(tbjQuery(this).val()==1){ // YES
	    tbjQuery('div.client_option').show();
	}
	else {
	    tbjQuery('div.client_option').hide();
	}
    })
    tbjQuery(document).on("click", '.remove_child_user', function (e) {
	var r = confirm("Are you sure?");
	if (r == true) {
	    tbjQuery(this).closest('div.inputWrap').remove();
	}
    })
    // user email exists check
    tbjQuery('input[name="email"]').change(function(){
	tbjQuery('input[name="task"]').val('checkEmailAjax');
	var passingData = tbjQuery('#adminForm').serialize();
	xhr = tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&task=checkEmailAjax'
	    , data: passingData
	    , dataType: 'json'
	    , async: false
	    , beforeSend: function(){
	    }
	    , complete: function(){
	    }
	    , success: function(response){
		if(response.error==0){
		}
		else {
		    tbjQuery('input[name="email"]').val('');
		    alert(response.msg);
		    return false;
		}
	    }
	})
    })
})
</script>

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-ui.js"></script>
<link rel="stylesheet" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery-ui.css" />

<!-- CSS to style the file input field as button and adjust the Bootstrap progress bars -->
<link rel="stylesheet" type="text/css" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery.fileupload.css">
<!-- The basic File Upload plugin -->
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.fileupload.js"></script>
<!-- The File Upload processing plugin -->
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.fileupload-process.js"></script>
<!-- The File Upload validation plugin -->
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.fileupload-validate.js"></script>

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.Jcrop.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery.Jcrop.css">

<script type="text/javascript">

/*jslint unparam: true */
/*global window, $ */
tbjQuery(function () {
    'use strict';
    // Change this to the location of your server-side upload handler:
    var url = BASE_URL+ 'components/com_taxibooking/upload.php';
    
    // Create variables (in this scope) to hold the API and image size
    var jcrop_api,
    boundx,
    boundy,

    // Grab some information about the preview pane
    $preview = tbjQuery('#preview-pane'),
    $pcnt = tbjQuery('#preview-pane .preview-container'),
    $pimg = tbjQuery('#preview-pane .preview-container img'),

    xsize = $pcnt.width(),
    ysize = $pcnt.height();
    
    tbjQuery('#fileupload').fileupload({
        url: url,
        dataType: 'json',
        autoUpload: true,
        acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
        maxFileSize: 2000000, // 2 MB
        // Enable image resizing, except for Android and Opera,
        // which actually support image resizing, but fail to
        // send Blob objects via XHR requests:
        //disableImageResize: /Android(?!.*Chrome)|Opera/
            //.test(window.navigator.userAgent),
        //previewMaxWidth: 150,
        //previewMaxHeight: 150,
        //previewCrop: true,
	formData: [
	    {
		name: 'userid',
		value: 'user_<?php echo $this->item->user_id;?>'
	    }
	]
    }).on('fileuploadadd', function (e, data) {
        tbjQuery('div#progress, div#photoPreviewWrap, div#preview-pane').show();
	if (typeof jcrop_api !== 'undefined') {
		jcrop_api.destroy();
	}
	data.context = tbjQuery('<div/>').appendTo('#files');
	tbjQuery.each(data.files, function (index, file) {
	    var node = tbjQuery('<p/>');
	    /*if (!index) {
		node
		    .append('<br>')
		    .append(uploadButton.clone(true).data(data));
	    }*/
	    node.appendTo(data.context);
	});
    }).on('fileuploadprocessalways', function (e, data) {
        var index = data.index,
	    file = data.files[index],
	    node = tbjQuery(data.context.children()[index]);
	/*if (file.preview) {
	    node
		.prepend('<br>')
		.prepend(file.preview);
	}*/
	if (file.error) {
	    tbjQuery('div#files').html(tbjQuery('<span class="text-danger"/>').text(file.error));
	}
	/*if (index + 1 === data.files.length) {
	    data.context.find('button')
		.text('Upload')
		.prop('disabled', !!data.files.error);
	}*/
    }).on('fileuploadprogressall', function (e, data) {
        var progress = parseInt(data.loaded / data.total * 100, 10);
        tbjQuery('#progress .progress-bar').css(
            'width',
            progress + '%'
        );
    }).on('fileuploaddone', function (e, data) {
	var file = data.result.files[0];
        //tbjQuery.each(data.result.files, function (index, file) {
            if (file.url) {
		tbjQuery('#new_photo').val(file.name);
		tbjQuery("#crop-target").attr("src",file.mediumUrl+"?d="+ (new Date()).getTime()  );
		$pimg.attr("src",file.mediumUrl+"?d="+ (new Date()).getTime());
		tbjQuery('.jcrop-holder img').attr('src', file.mediumUrl+"?d="+ (new Date()).getTime() );
		tbjQuery('#is_photo_changed').val(1);
		tbjQuery( "#preview-pane" ).draggable({
			cursor: "move"
		});
		
		setTimeout(function() {
		    initJcrop();
		    tbjQuery('span#reupload-button').show();
		    tbjQuery('span#upload-button').hide();
		    
		    function initJcrop()
		    {
			//var oImage = new Image();
			//oImage.src = tbjQuery("#crop-target").attr("src");
			//console.log('width: ' + oImage.naturalWidth + ' and height: ' + oImage.naturalHeight);

			tbjQuery('#crop-target').Jcrop({
				onChange: updatePreview,
				onSelect: updatePreview,
				aspectRatio: xsize / ysize,
				setSelect: [ 0, 0, 300, 300 ],
				minSize: [ 100, 100 ]
			},function(){
				// Use the API to get the real image size
				var bounds = this.getBounds();
				boundx = bounds[0];
				boundy = bounds[1];
				console.log('boundx: ' + boundx + ' and boundy: ' + boundy);
				
				// Store the API in the jcrop_api variable
				jcrop_api = this;
				
				// Sets a random selection
				jcrop_api.animateTo([0, 0, 300, 300]);
				jcrop_api.setImage(file.mediumUrl+"?d="+ (new Date()).getTime());
			  
				// Move the preview into the jcrop container for css positioning
				$preview.appendTo(jcrop_api.ui.holder);
				$pimg.removeAttr( 'style' );
			});
		    };
		    function updatePreview(c)
		    {
			if (parseInt(c.w) > 0)
			{
			    var rx = xsize / c.w;
			    var ry = ysize / c.h;
			    
			    tbjQuery('#x1').val(c.x);
			    tbjQuery('#y1').val(c.y);
			    tbjQuery('#x2').val(c.x2);
			    tbjQuery('#y2').val(c.y2);
			    tbjQuery('#w').val(c.w);
			    tbjQuery('#h').val(c.h);
		    
			    $pimg.css({
				    width: Math.round(rx * boundx) + 'px',
				    height: Math.round(ry * boundy) + 'px',
				    marginLeft: '-' + Math.round(rx * c.x) + 'px',
				    marginTop: '-' + Math.round(ry * c.y) + 'px'
			    });
			}
		    };
		}, 100);
		
                /*var link = $('<a>')
                    .attr('target', '_blank')
                    .prop('href', file.url);
                $(data.context.children()[index])
                    .wrap(link);*/
            } else if (file.error) {
                var error = tbjQuery('<span class="text-danger"/>').text(file.error);
                tbjQuery(data.context.children()[index])
                    .append('<br>')
                    .append(error);
            }
        //});
	
    }).on('fileuploadfail', function (e, data) {
        /*$.each(data.files, function (index) {
            var error = $('<span class="text-danger"/>').text('File upload failed.');
            $(data.context.children()[index])
                .append('<br>')
                .append(error);
        });*/
    }).prop('disabled', !tbjQuery.support.fileInput)
        .parent().addClass(tbjQuery.support.fileInput ? undefined : 'disabled');
	
});

function selectUser(tbuserid, user_id, user_name){
    var html = '<div class="inputWrap clearfix">'+
		    '<label for="title">&nbsp;</label>'+
		    '<a href="'+BASE_URL+'administrator/index.php?option=com_taxibooking&amp;controller=tbusers&amp;task=edit&amp;cid[]='+tbuserid+'" target="blank">'+user_name+'</a>'+
		    '&nbsp;&nbsp;<a href="javascript:void(0);" class="remove_child_user btn btn-small"><?php echo JText::_('REMOVE');?></a>'+
		    '<input type="hidden" name="child_clients[]" value="'+user_id+'" />'+
		'</div>';
    tbjQuery('div#child_users_wrap').append(html);
    SqueezeBox.close();
}
</script>

<style type="text/css">

/* Apply these styles only when #preview-pane has
   been placed within the Jcrop widget */
.jcrop-holder #preview-pane {
  display: block;
  position: absolute;
  z-index: 2000;
  top: 10px;
  right: -280px;
  padding: 6px;
  border: 1px rgba(0,0,0,.4) solid;
  background-color: white;
cursor: all-scroll;
  -webkit-border-radius: 6px;
  -moz-border-radius: 6px;
  border-radius: 6px;

  -webkit-box-shadow: 1px 1px 5px 2px rgba(0, 0, 0, 0.2);
  -moz-box-shadow: 1px 1px 5px 2px rgba(0, 0, 0, 0.2);
  box-shadow: 1px 1px 5px 2px rgba(0, 0, 0, 0.2);
}

/* The Javascript code will set the aspect ratio of the crop
   area based on the size of the thumbnail preview,
   specified here */
#preview-pane {
  width: 300px;
}
#preview-pane .preview-container {
  width: 300px;
  height: 300px;
  overflow: hidden;
}
.fileinput-button {
	margin-bottom: 10px;
}

.progress {
	margin-bottom: 10px;
}

.progress-bar-success {
    background-color: #5cb85c;
}

.progress-bar {
    box-shadow: 0 -1px 0 rgba(0, 0, 0, 0.15) inset;
    color: #fff;
    float: left;
    font-size: 12px;
    height: 100%;
    line-height: 20px;
    text-align: center;
    transition: width 0.6s ease 0s;
}
</style>

<div class="adminform tab1">
    
    <h3><?php echo JText::_('com_taxibooking_MANAGER_USER_NEW'); ?></h3>
    
<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="adminform form-validate">

	<div class="poicat_adminform">
	
	    <div class="inputWrap clearfix">
		    <label for="title"><?php echo JText::_( 'TBUSERS_HEADER_USER_NAME' ).':'; ?></label>
		    <input type="text" name="name" value="<?php echo $this->item->name; ?>" class="inputbox required" size="30" />
	    </div>
	    
	    <div class="inputWrap clearfix">
		    <label for="title"><?php echo JText::_( 'TBUSERS_HEADER_USER_EMAIL' ).':'; ?></label>
		    <input type="text" name="email" value="<?php echo $this->item->email; ?>" class="inputbox required" size="30" />
	    </div>
	    
	    <div class="inputWrap clearfix" id="user_phone_wrap" style="<?php echo ($this->item->is_driver==1)?'display:none' : 'display:block';?>">
		<label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_HEADER_USER_PHONE_EXPLAIN'); ?>">
			<?php echo JText::_( 'TBUSERS_HEADER_USER_PHONE' ).':'; ?>
			</span>
		</label>
		<input type="text" name="phone" value="<?php echo $this->item->phone; ?>" class="inputbox" size="30" />
	    </div>
	    
	    <div class="inputWrap published clearfix">
		<label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_HEADER_USER_IS_CLIENT_EXPLAIN'); ?>">
			<?php echo JText::_( 'TBUSERS_HEADER_USER_IS_CLIENT' ).':'; ?>
			</span>
		</label>
		<?php echo JHTML::_('select.booleanlist', 'is_corporate_client', 'class="inputbox"', $this->item->is_corporate_client );?>
	    </div>
	    <?php
	    if($this->item->is_corporate_client==0){
		$client_option_style_display = 'display:none;';
	    }
	    else {
		$client_option_style_display = 'display:block;';
	    }
	    ?>
	    <div class="inputWrap client_option clearfix" style="<?php echo $client_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_CLIENT_ORGANIZATION_NAME_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_CLIENT_ORGANIZATION_NAME' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="client_organization_name" value="<?php echo $this->item->client_organization_name; ?>" class="inputbox" size="30" />
	    </div>
	    <div class="inputWrap client_option clearfix" style="<?php echo $client_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_CLIENT_ORGANIZATION_ADDRESS_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_CLIENT_ORGANIZATION_ADDRESS' ).':'; ?>
		    </span>
		</label>
		<textarea name="client_organization_address" class="inputbox"><?php echo $this->item->client_organization_address; ?></textarea>
	    </div>
	    <div class="inputWrap client_option clearfix" style="<?php echo $client_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_CLIENT_REGISTRATION_NUMBER_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_CLIENT_REGISTRATION_NUMBER' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="client_registration_number" value="<?php echo $this->item->client_registration_number; ?>" class="inputbox" size="30" />
	    </div>
	    <div class="inputWrap client_option clearfix" style="<?php echo $client_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_CLIENT_VAT_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_CLIENT_VAT' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="client_vat" value="<?php echo $this->item->client_vat; ?>" class="inputbox" size="30" />
	    </div>
	    
	    <div class="inputWrap client_option clearfix" style="<?php echo $client_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_CLIENT_ASSIGNED_USERS_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_CLIENT_ASSIGNED_USERS' ).':'; ?>
		    </span>
		</label>
		<a class="btn modal" rel="{handler: 'iframe', size: {x: 800, y: 500}}" href="index.php?option=com_taxibooking&view=tbusers&layout=modal&tmpl=component&editing_uid=<?php echo $this->item->user_id; ?>" title="Select User">
		    <?php echo JText::_('TBUSERS_CLIENT_ASSIGNED_USERS_SELECT_LABEL'); ?>
		</a>
	    </div>
	    
	    <div class="inputWrap client_option clearfix" style="<?php echo $client_option_style_display;?>" id="child_users_wrap">
		<?php
		if(!empty($this->child_clients))
		{
		    foreach($this->child_clients as $child_client)
		    {
		?>
		<div class="inputWrap clearfix">
		    <label for="title">&nbsp;</label>
		    <a href="<?php echo JURI::base();?>index.php?option=com_taxibooking&amp;controller=tbusers&amp;task=edit&amp;cid[]=<?php echo $child_client->tbuserid;?>" target="blank"><?php echo $child_client->user_name;?></a>
		    &nbsp;<a href="javascript:void(0);" class="remove_child_user btn btn-small"><?php echo JText::_('REMOVE');?></a>
		    <input type="hidden" name="child_clients[]" value="<?php echo $child_client->child_user_id;?>" />
		</div>
		<?php
		    }
		}
		?>
	    </div>
	    
	    <div class="inputWrap published clearfix">
		<label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_HEADER_USER_IS_DRIVER_EXPLAIN'); ?>">
			<?php echo JText::_( 'TBUSERS_HEADER_USER_IS_DRIVER' ).':'; ?>
			</span>
		</label>
		<?php echo JHTML::_('select.booleanlist', 'is_driver', 'class="inputbox"', $this->item->is_driver );?>
	    </div>
	    
	    <?php
	    if($this->item->is_driver==0){
		$driver_option_style_display = 'display:none;';
	    }
	    else {
		$driver_option_style_display = 'display:block;';
	    }
	    ?>
	    <div class="inputWrap driver_option clearfix" style="<?php echo $driver_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_DRIVER_BADGE_NUMBER_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_DRIVER_BADGE_NUMBER' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="driver_badge_number" value="<?php echo $this->item->driver_badge_number; ?>" class="inputbox" size="30" />
	    </div>
	    <div class="inputWrap driver_option published clearfix" style="<?php echo $driver_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_DRIVER_SHOW_BADGE_NUMBER_EMAIL_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_DRIVER_SHOW_BADGE_NUMBER_EMAIL' ).':'; ?>
		    </span>
		</label>
		<?php echo JHTML::_('select.booleanlist', 'show_badge_number_email', 'class="inputbox"', $this->item->show_badge_number_email );?>
	    </div>
	    <div class="inputWrap driver_option clearfix" style="<?php echo $driver_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_DRIVER_PHONE_NUMBER_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_DRIVER_PHONE_NUMBER' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="driver_phone_number" value="<?php echo $this->item->phone; ?>" class="inputbox" size="30" />
	    </div>
	    <div class="inputWrap driver_option published clearfix" style="<?php echo $driver_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_DRIVER_SHOW_PHONE_EMAIL_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_DRIVER_SHOW_PHONE_EMAIL' ).':'; ?>
		    </span>
		</label>
		<?php echo JHTML::_('select.booleanlist', 'show_phone_number_email', 'class="inputbox"', $this->item->show_phone_number_email );?>
	    </div>
	    <div class="inputWrap driver_option clearfix" style="<?php echo $driver_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_DRIVER_ADDRESS_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_DRIVER_ADDRESS' ).':'; ?>
		    </span>
		</label>
		<textarea name="driver_address" class="inputbox"><?php echo $this->item->driver_address; ?></textarea>
	    </div>
	    <div class="inputWrap driver_option clearfix" style="<?php echo $driver_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_DRIVER_DATE_EMPLOYMENT_COMMENCED_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_DRIVER_DATE_EMPLOYMENT_COMMENCED' ).':'; ?>
		    </span>
		</label>
		<?php
		echo JHtml::_('calendar', $this->item->driver_date_employment_commenced, 'driver_date_employment_commenced', "driver_date_employment_commenced", '%Y-%m-%d' , array('size'=>20, 'class'=>"inputbox"));
		?>
	    </div>
	    <div class="inputWrap driver_option clearfix" style="<?php echo $driver_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_DRIVER_DATE_EMPLOYMENT_TERMINATED_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_DRIVER_DATE_EMPLOYMENT_TERMINATED' ).':'; ?>
		    </span>
		</label>
		<?php
		echo JHtml::_('calendar', $this->item->driver_date_employment_terminated, 'driver_date_employment_terminated', "driver_date_employment_terminated", '%Y-%m-%d' , array('size'=>20, 'class'=>"inputbox"));
		?>
	    </div>
	    <div class="inputWrap driver_option clearfix" style="<?php echo $driver_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_DRIVER_INSURANCE_END_DATE_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_DRIVER_INSURANCE_END_DATE' ).':'; ?>
		    </span>
		</label>
		<?php
		echo JHtml::_('calendar', $this->item->driver_date_insurance_end, 'driver_date_insurance_end', "driver_date_insurance_end", '%Y-%m-%d' , array('size'=>20, 'class'=>"inputbox"));
		?>
	    </div>
	    <div class="inputWrap driver_option clearfix" style="<?php echo $driver_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_DRIVER_RENT_AMOUNT_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_DRIVER_RENT_AMOUNT' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="driver_rent_amount" value="<?php echo $this->item->driver_rent_amount; ?>" class="inputbox" />
	    </div>
	    <div class="inputWrap driver_option clearfix" style="<?php echo $driver_option_style_display;?>">
		<label for="title">
		    <span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_DRIVER_RENT_PAYABLE_DATE_EXPLAIN'); ?>">
		    <?php echo JText::_( 'TBUSERS_DRIVER_RENT_PAYABLE_DATE' ).':'; ?>
		    </span>
		</label>
		<input type="text" name="driver_rent_payable_date" value="<?php echo $this->item->driver_rent_payable_date; ?>" class="inputbox" size="30" />
	    </div>
	    
	    <div class="inputWrap clearfix">
		<label for="title">
			<span class="hasTip control-label" title="<?php echo JText::_('TBUSERS_HEADER_USER_PHOTO_EXPLAIN'); ?>">
			<?php echo JText::_( 'TBUSERS_HEADER_USER_PHOTO' ).':'; ?>
			</span>
		</label>
		
		<div>
		<?php
		    echo $this->imageselect;
		?>
		</div>

		<?php if($this->item->photo!=""){ ?>
		<div>
		<img src="<?php echo JURI::root().$this->item->photo;?>?d=<?php echo time();?>" alt="<?php echo htmlspecialchars($this->item->name);?>" />
		</div>
		<?php } ?>
		
		<!-- The fileinput-button span is used to style the file input field as button -->
		<span class="btn btn-success fileinput-button" id="upload-button">
		    <i class="glyphicon glyphicon-plus"></i>
		    <span><?php echo JText::_('TBUSERS_SELECT_FILE');?></span>
		    <!-- The file input field used as target for the file upload widget -->
		    <input id="fileupload" type="file" name="files[]" accept="image/*" />
		</span>
		
		<span class="btn btn-success fileinput-button" id="reupload-button" style="display:none;">
		    <i class="glyphicon glyphicon-plus"></i>
		    <span onclick="window.location.reload(true);"><?php echo JText::_('TBUSERS_IMAGE_REUPLOAD');?></span>
		</span>
		
		<!-- The global progress bar -->
		<div id="progress" class="progress" style="display:none;">
		    <div class="progress-bar progress-bar-success"></div>
		</div>
		
		<!-- The container for the uploaded files -->
		<div id="files" class="files"></div>
		
		<div id="photoPreviewWrap" style="display:none;">
		    <img src="" id="crop-target" />
		    <input type="hidden" name="is_photo_changed" id="is_photo_changed" value="0" />
		    <input type="hidden" name="new_photo" id="new_photo" value="" />
		    <input type="hidden" name="cropped_data[x1]" id="x1" value="0" />
		    <input type="hidden" name="cropped_data[y1]" id="y1" value="0" />
		    <input type="hidden" name="cropped_data[x2]" id="x2" value="300" />
		    <input type="hidden" name="cropped_data[y2]" id="y2" value="300" />
		    <input type="hidden" name="cropped_data[w]" id="w" value="300" />
		    <input type="hidden" name="cropped_data[h]" id="h" value="300" />
		</div>
		
		<div id="preview-pane" style="display:none;">
		    <div class="preview-container">
			<img src="" class="jcrop-preview" alt="Preview" />
		    </div>
		</div>
	    </div>
	</div>

<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="field" value="<?php echo $this->escape($field); ?>" />
<input type="hidden" name="option" value="com_taxibooking" />
<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
<input type="hidden" name="controller" value="tbusers" />
<input type="hidden" name="view" value="tbuser" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="layout" value="modal" />
<input type="hidden" name="tmpl" value="component" />
</form>

<div class="btn-toolbar">
	<div class="btn-group">
	    <button type="submit" class="btn btn-primary" id="submitbtn" onclick="Joomla.submitbutton('save')">
		    <span class="icon-ok"></span>&#160;<?php echo JText::_('JTOOLBAR_SAVE') ?>
	    </button>
	    
	    <input class="btn" type="button" value="<?php echo JText::_('JCANCEL') ?>" onclick="window.location.href='<?php echo JRoute::_('index.php?option=com_taxibooking&view=tbusers&layout=modal&tmpl=component', false);?>'" />
	</div>
</div>

</div>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>