<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

/**
 * View class 
 */
class TaxibookingViewTbuser extends JViewLegacy
{
	public $item;
    
	protected $state;
    
	/**
	* Display the view
	*
	* @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	*
	* @return  void
	*/
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$user =  JFactory::getUser();
		$this->days_off2 = [1, 2, 3, 4];
		$this_user = $this->getUserFromId($_GET['id']);
		$this->days_off = $this->getDaysOff($this_user);
		$lang =  JFactory::getLanguage();
		$config = JFactory::getConfig();
		
		$this->elsettings 	= booking_helper::config();
		$this->item	= $this->get('Item');
		$this->state	= $this->get('State');
		$isNew		= ($this->item->id == 0);
		$this->editor =  JFactory::getEditor();
		$this->child_clients = $this->_getChildClients();
	
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		// Load the modal behavior script for image select
                JHtml::_('behavior.modal');

                // Build the script.
                $script = array();
                $script[] = '	function jInsertFieldValue(value, id) {';
                $script[] = '		var old_id = document.id(id).value;';
                $script[] = '		if (old_id != id) {';
                $script[] = '			var elem = document.id(id)';
                $script[] = '			elem.value = value;';
                $script[] = '			elem.fireEvent("change");';
                $script[] = '		}';
                $script[] = '	}';

                // Add the script to the document head.
                JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));

		$html[] = '<div class="fltlft">';
		$html[] = '	<input type="text" name="photo" id="user_image" value="'
			. htmlspecialchars($this->item->photo, ENT_COMPAT, 'UTF-8') . '" size="40" readonly="readonly" />';
		$html[] = '</div>';

		$directory = 'taxibooking/userphoto';
		if (file_exists(JPATH_ROOT . '/' . JComponentHelper::getParams('com_media')->get('image_path', 'images') . '/' . $directory))
		{
			$folder = $directory;
		}
		else
		{
			$folder = '';
		}
		// The button.
		$html[] = '<div class="button2-left">';
		$html[] = '	<div class="blank">';
		$html[] = '		<a class="modal btn" title="' . JText::_('JLIB_FORM_BUTTON_SELECT') . '"' . ' href="'
			. 'index.php?option=com_media&amp;view=images&amp;tmpl=component&amp;asset=com_taxibooking'
                        . '&amp;author='.$user->get('id').'&amp;fieldid=user_image&amp;folder=' . $folder . '"'
			. ' rel="{handler: \'iframe\', size: {x: 800, y: 500}}">';
		$html[] = JText::_('JLIB_FORM_BUTTON_SELECT') . '</a>';
		$html[] = '	</div>';
		$html[] = '</div>';

		$html[] = '<div class="button2-left">';
		$html[] = '	<div class="blank">';
		$html[] = '		<a class="btn" title="' . JText::_('JLIB_FORM_BUTTON_CLEAR') . '"' . ' href="#" onclick="';
		$html[] = 'document.id(\'user_image\').value=\'\';';
		$html[] = 'document.id(\'user_image\').fireEvent(\'change\');';
		$html[] = 'return false;';
		$html[] = '">';
		$html[] = JText::_('JLIB_FORM_BUTTON_CLEAR') . '</a>';
		$html[] = '	</div>';
		$html[] = '</div>';
                
                $this->imageselect = implode("\n", $html);
		
		$this->addToolbar();
		parent::display($tpl);
	}
	
	/**
	* Add the page title and toolbar.
	*
	* @return  void
	*
	* @since   1.6
	*/
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/taxibooking.php';
		JFactory::getApplication()->input->set('hidemainmenu', true);
	
		$canDo = TaxibookingHelper::getActions();
		$user = JFactory::getUser();
	
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
	    
		JToolbarHelper::title($isNew ? JText::_('COM_TAXIBOOKING_MANAGER_USER_NEW') : JText::_('COM_TAXIBOOKING_MANAGER_USER_EDIT'), 'generic');
		
		// If not checked out, can save the item.
		if (!$checkedOut)
		{
			JToolbarHelper::apply();
			JToolbarHelper::save();
		}
		
		JToolbarHelper::cancel();
	}
	
	private function _getChildClients()
	{
		$db = JFactory::getDBO();
		
		$child_clients = array();
		
		$isNew		= ($this->item->id == 0);
		if(!$isNew)
		{
			$query = $db->getQuery(true);
			$query->select('DISTINCT uc.child_user_id');
			$query->from('#__taxibooking_user_childs AS uc');
			$query->select('u.id AS tbuserid, u.name AS user_name')
				->join('LEFT', $db->quoteName('#__taxibooking_users') . ' AS u ON u.user_id = uc.child_user_id');
			$query->where('uc.parent_user_id = '.(int) $this->item->user_id);
			$query->order('u.name');
			$db->setQuery((string)$query);
			$child_clients = $db->loadObjectList();
		}
		
		return $child_clients;
	}

	private function getDaysOff($userid) 
	{
		$db = JFactory::getDBO();

		$query = $db->getQuery(true);
		$query = 'SELECT day
			FROM #__taxibooking_driver_unavailable
			WHERE ( driver_id = ' . $userid . ')';
		$db->setQuery((string)$query);

		$rows = $db->loadRowList();
		$rows2 = [];
		foreach ($rows as $key => $value) {
			$rows2[] = $value[0];
		}
	
		return $rows2;

	}

	private function getUserFromId($id) 
	{
		$db = JFactory::getDBO();

		$query = $db->getQuery(true);
		$query = 'SELECT user_id
			FROM #__taxibooking_users
			WHERE ( id = ' . $id . ')';
		$db->setQuery((string)$query);

		return $db->loadResult();
	}
	
}