<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$saveOrder	= $listOrder=='ordering';
$params		= (isset($this->state->params)) ? $this->state->params : new JObject();

if(version_compare(JVERSION,'3.1.5','ge'))
{
	if ($saveOrder)
	{
		$saveOrderingUrl = 'index.php?option=com_taxibooking&task=saveOrderAjax&tmpl=component';
		JHtml::_('sortablelist.sortable', 'articleList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
	}
}
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>administrator/components/com_taxibooking/assets/css/tbusers.css" />

<div>
<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&view=tbusers'); ?>" method="post" name="adminForm" id="adminForm">

	<div class="poicats_adminform clearfix">
		<div class="poicats_adminform_left clearfix">
			<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
			<label><?php echo JText::_( 'SEARCH' ); ?></label>
			<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" class="hasTooltip inputbox" />
			<button type="submit" class="btn hasTooltip"><i class="icon-search"></i></button>
			<button type="button" class="btn hasTooltip" onclick="document.id('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
			<?php } else { ?>
			<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
			<input type="text" class="inputbox" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" />
			<button type="submit"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
			<button type="button" onclick="document.id('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			<?php } ?>
		</div>
		<div class="poicats_adminform_right">
			<!--select name="filter_state" class="inputbox" onchange="this.form.submit()">
				<option value=""><?php echo JText::_('JOPTION_SELECT_PUBLISHED');?></option>
				<?php //echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.state'), true);?>
			</select-->
		</div>
	</div>
	

	<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
	<table class="table table-striped no-more-tables" id="articleList">
	<?php } else { ?>
	<table class="adminlist no-more-tables">
	<?php } ?>
	
	<thead>
		<tr>
			<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
			<th width="5">
				<?php echo JHtml::_('grid.checkall'); ?>
			</th>
			<?php } else { ?>
			<th width="1%">
				<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
			</th>
			<?php } ?>
			
			<th class="title numeric"><?php echo JHTML::_('grid.sort', 'TBUSERS_HEADER_USER_NAME', 'a.name', $listDirn, $listOrder ); ?></th>
			<th class="title numeric"><?php echo JHTML::_('grid.sort', 'TBUSERS_HEADER_USER_EMAIL', 'a.email', $listDirn, $listOrder ); ?></th>
			<th width="20%" class="numeric"><?php echo JText::_( 'TBUSERS_HEADER_USER_PHONE' ); ?></th>
			<th width="10%" class="numeric"><?php echo JText::_( 'TBUSERS_HEADER_USER_IS_CLIENT' ); ?></th>
			<th width="10%" class="numeric"><?php echo JText::_( 'TBUSERS_HEADER_USER_IS_DRIVER' ); ?></th>
                        
			<th width="1%" class="nowrap numeric">
				<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
			</th>
		</tr>
	</thead>

	<tbody>
		<?php
		$k = 0;
		$img1 = 'icon-16-allow.png';
		$img0 = 'publish_r.png';
		for ($i=0, $n=count($this->items); $i < $n; $i++) {
			$row = $this->items[$i];
			$ordering	= ($listOrder == 'ordering');

			$link 		= 'index.php?option=com_taxibooking&amp;controller=tbusers&amp;task=edit&amp;cid[]='. $row->id;
			$checked 	= JHTML::_('grid.id', $i, $row->id);
                        $published 	= JHTML::_('jgrid.published', $row->published, $i );
			
			$is_client_img = $row->is_corporate_client ? $img1 : $img0;
			$is_driver_img = $row->is_driver ? $img1 : $img0;
   		?>
		<tr class="<?php echo "row$k"; ?>">
			
			<td data-title="&nbsp;" class=""><?php echo $checked; ?></td>
			<td data-title="<?php echo JText::_('TBUSERS_HEADER_USER_NAME');?>" class="numeric" align="left">
				<?php if ($row->checked_out) : ?>
					<?php echo JHtml::_('jgrid.checkedout', $i, $row->checked_out, $row->checked_out_time, '', true); ?>
				<?php endif; ?>
                            <span>
                            <a href="<?php echo $link; ?>">
                            <?php echo htmlspecialchars($row->name, ENT_QUOTES, 'UTF-8'); ?>
			    &nbsp;<span style="font-size: smaller;font-style: italic;">[<?php echo $row->user_id;?>]</span>
                            </a>
			    </span>
				
			</td>
                        <td data-title="<?php echo JText::_('TBUSERS_HEADER_USER_EMAIL');?>" class="numeric" align="center">
				<?php echo $row->email;?>
                        </td>
			<td data-title="<?php echo JText::_('TBUSERS_HEADER_USER_PHONE');?>" class="numeric" align="center">
				<?php echo ($row->phone=="") ? '&nbsp;' : $row->phone;?>
                        </td>
			<td data-title="<?php echo JText::_('TBUSERS_HEADER_USER_IS_CLIENT');?>" class="numeric" align="center">
				<?php echo JHtml::_('image', 'admin/' . $is_client_img, '', null, true);?>
                        </td>
			<td data-title="<?php echo JText::_('TBUSERS_HEADER_USER_IS_DRIVER');?>" class="numeric" align="center">
				<?php echo JHtml::_('image', 'admin/' . $is_driver_img, '', null, true);?>
                        </td>
			<td data-title="<?php echo JText::_('JGRID_HEADING_ID');?>" class="numeric" align="center"><?php echo $row->id; ?></td>
		</tr>
		<?php $k = 1 - $k; } ?>
	</tbody>
	
	<tfoot>
		<tr>
			<td colspan="7">
				<?php echo $this->pagination->getListFooter(); ?>
			</td>
		</tr>
	</tfoot>	

	</table>
	

	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="option" value="com_taxibooking" />
	<input type="hidden" name="controller" value="tbusers" />
	<input type="hidden" name="view" value="tbusers" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
</div>