<?php
/**
* @title				Minitek FAQ Book
* @copyright   	Copyright (C) 2011-2020 Minitek, All rights reserved.
* @license   		GNU General Public License version 3 or later.
* @author url   https://www.minitek.gr/
* @developers   Minitek.gr
*/

defined('_JEXEC') or die;

class FaqBookProControllerQuestion extends JControllerForm
{
	protected $view_item = 'form';
	protected $view_list = 'section';
	protected $urlVar = 'a.id';

 	function __construct()
	{
		parent::__construct();

		$this->registerTask('faqThumbsUp', 'ajaxFaqThumbUp');
		$this->registerTask('faqThumbsDown', 'ajaxFaqThumbDown');
		$this->registerTask('faqVoteReason', 'ajaxFaqVoteReason');
		$this->registerTask('addHit', 'ajaxAddHit');
	}

	function ajaxFaqThumbUp()
	{
		$this->ajaxFaqRating(1);
	}

	function ajaxFaqThumbDown()
	{
		$this->ajaxFaqRating(0);
	}

	function ajaxFaqVoteReason()
	{
		$this->ajaxFaqReason();
	}

	private function ajaxFaqRating($type)
	{
		// Get input
		$app = JFactory::getApplication();
		$jinput = $app->input;

		$id = $jinput->get('id', 0, 'INT');

		if ($id)
		{
			$model = $this->getModel('question');
			$data = $model->FaqVoting($id, $type);

			if ($data)
			{
				echo $data;
			}
			else
			{
				$error = $model->getError();
			}
		}

		jexit();
	}

	private function ajaxFaqReason()
	{
		// Get input
		$app = JFactory::getApplication();
		$jinput = $app->input;

		$rid = $jinput->get('rid', 0, 'INT');
		$fid = $jinput->get('fid', 0, 'INT');

		if ($rid && $fid)
		{
			$model = $this->getModel('question');
			$data = $model->FaqVotingReason($rid, $fid);

			if ($data)
			{
				echo $data;
			}
			else
			{
				$error = $model->getError();
			}
		}

		jexit();
	}

	function ajaxAddHit()
	{
		// Get input
		$app = JFactory::getApplication();
		$jinput = $app->input;

		$id = $jinput->get('id', 0, 'INT');

		if ($id)
		{
			$model = $this->getModel('question');
			$data = $model->addHit($id);

			if ($data)
			{
				echo $data;
			}
			else
			{
				$error = $model->getError();
			}
		}

		jexit();
	}
}
