<?php
/**
* @title				Minitek FAQ Book
* @copyright   	Copyright (C) 2011-2020 Minitek, All rights reserved.
* @license   		GNU General Public License version 3 or later.
* @author url   https://www.minitek.gr/
* @developers   Minitek.gr
*/

defined('_JEXEC') or die;

use Joomla\Registry\Registry;

class FaqBookProModelQuestion extends JModelItem
{
	protected $_context = 'com_faqbookpro.question';

	var $utilities = null;
	var $navigation = null;

	function __construct()
	{
		$this->utilities = $this->getUtilitiesLib();
		$this->navigation = $this->getNavigationLib();

		parent::__construct();
	}

	public function getUtilitiesLib()
	{
		$utilities = new FAQBookProLibUtilities;

		return $utilities;
	}

	public function getNavigationLib()
	{
		$navigation = new FAQBookProLibUtilitiesNavigation;

		return $navigation;
	}

	protected function populateState()
	{
		$app = JFactory::getApplication('site');

		// Load state from the request.
		$pk = $app->input->getInt('id');
		$this->setState('question.id', $pk);

		$offset = $app->input->getUInt('limitstart');
		$this->setState('list.offset', $offset);

		// Load the parameters.
		$params = $app->getParams();
		$this->setState('params', $params);

		// TODO: Tune these values based on other permissions.
		$user = JFactory::getUser();

		if ((!$user->authorise('core.edit.state', 'com_faqbookpro')) && (!$user->authorise('core.edit', 'com_faqbookpro')))
		{
			$this->setState('filter.published', 1);
			$this->setState('filter.archived', 2);
		}

		$this->setState('filter.language', JLanguageMultilang::isEnabled());
	}

	public function getItem($pk = null)
	{
		$user = JFactory::getUser();

		$pk = (!empty($pk)) ? $pk : (int) $this->getState('question.id');

		if ($this->_item === null)
		{
			$this->_item = array();
		}

		if (!isset($this->_item[$pk]))
		{
			try
			{
				$db = $this->getDbo();
				$query = $db->getQuery(true)
					->select(
						$this->getState(
							'item.select', 'a.id, a.asset_id, a.title, a.alias, a.introtext, a.fulltext, a.state, ' .
							'a.topicid, a.created, a.created_by, a.created_by_alias, ' .
							// Use created if modified is 0
							'CASE WHEN a.modified = ' . $db->quote($db->getNullDate()) . ' THEN a.created ELSE a.modified END as modified, ' .
							'a.modified_by, a.checked_out, a.checked_out_time, a.publish_up, a.publish_down, ' .
							'a.images, a.attribs, a.ordering, ' .
							'a.metakey, a.metadesc, a.access, a.hits, a.metadata, a.featured, a.language'
						)
					);
				$query->from('#__minitek_faqbook_questions AS a');

				// Join on topic table.
				$query->select('c.title AS topic_title, c.alias AS topic_alias, c.access AS topic_access')
					->join('LEFT', '#__minitek_faqbook_topics AS c on c.id = a.topicid');

				// Join over the sections
				$query->select('section.title as section_title, section.id as section_id, section.access as section_access')
					->join('LEFT', '#__minitek_faqbook_sections as section ON section.id = c.section_id');

				// Join on user table.
				$query->select('u.name AS author')
					->join('LEFT', '#__users AS u on u.id = a.created_by');

				// Filter by language
				if ($this->getState('filter.language'))
				{
					$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
				}

				// Join over the topics to get parent topic titles
				$query->select('parent.title as parent_title, parent.id as parent_id, parent.path as parent_route, parent.alias as parent_alias')
					->join('LEFT', '#__minitek_faqbook_topics as parent ON parent.id = c.parent_id');

				$query->where('a.id = ' . (int) $pk);

				if ((!$user->authorise('core.edit.state', 'com_faqbookpro')) && (!$user->authorise('core.edit', 'com_faqbookpro')))
				{
					// Filter by start and end dates.
					$nullDate = $db->quote($db->getNullDate());
					$date = JFactory::getDate();

					$nowDate = $db->quote($date->toSql());

					$query->where('(a.publish_up = ' . $nullDate . ' OR a.publish_up <= ' . $nowDate . ')')
						->where('(a.publish_down = ' . $nullDate . ' OR a.publish_down >= ' . $nowDate . ')');
				}

				// Filter by published state.
				$query->where('(a.state = ' . $db->quote('1') . ' OR a.state = ' . $db->quote('0') . ')');

				// Filter by topic/section published state
				$query->where('c.published = ' . $db->quote('1') . '');
				$query->where('section.state = ' . $db->quote('1') . '');

				// Access
				$query->where('a.access IN (' . implode(',', $user->getAuthorisedViewLevels()) . ')');
				$query->where('c.access IN (' . implode(',', $user->getAuthorisedViewLevels()) . ')');
				$query->where('section.access IN (' . implode(',', $user->getAuthorisedViewLevels()) . ')');

				$db->setQuery($query);

				$data = $db->loadObject();

				if (empty($data))
				{
					JError::raiseError(404, JText::_('COM_FAQBOOKPRO_ERROR_QUESTION_NOT_FOUND'));

					return false;
				}

				// Convert parameter fields to objects.
				$registry = new Registry($data->attribs);
				$data->attribs = $registry;

				$data->params = clone $this->getState('params');
				$data->params->merge($registry);

				$registry = new Registry($data->metadata);
				$data->metadata = $registry;

				$this->_item[$pk] = $data;
			}
			catch (Exception $e)
			{
				if ($e->getCode() == 404)
				{
					// Need to go thru the error handler to allow Redirect to work.
					JError::raiseError(404, $e->getMessage());

					return false;
				}
				else
				{
					$this->setError($e);
					$this->_item[$pk] = false;
				}
			}
		}

		return $this->_item[$pk];
	}

	public function getQuestionSection($topicId)
	{
		$db = JFactory::getDbo();
		$user = JFactory::getUser();

		$query = $db->getQuery(true);

		$query->select('a.section_id');
		$query->from('#__minitek_faqbook_topics AS a');

		// Join over the sections
		$query->select('section.id as section_id')
			->join('LEFT', '#__minitek_faqbook_sections as section ON section.id = a.section_id');

		$query->where('a.id = ' . $db->quote($topicId));

		// Get the results
		$db->setQuery($query);
		$sectionId = $db->loadObject()->section_id;

		return $sectionId;
	}

	public static function FaqVoting($id, $type)
	{
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
		$jinput = $app->input;
		$reason = $jinput->get('reason', 0, 'INT');
		$user = JFactory::getUser();
  	$user_id = $user->id;
		$user_ip = $_SERVER['REMOTE_ADDR'];
		$jnow = JFactory::getDate();
		$date = $jnow->toSql();

		$output = '';

		// Add controls for existing votes
		if ($user_id)
		{
			$query	= ' SELECT a.* FROM ' . $db->quoteName('#__minitek_faqbook_votes') . ' AS a '
				. ' WHERE a.'.$db->quoteName('question_id').'=' . $db->Quote($id)
				. ' AND a.'.$db->quoteName('user_id').'=' . $db->Quote($user_id);
			$db->setQuery( $query );
	  	$user_vote_exists = $db->loadObject();

			if (!$user_vote_exists)
			{
  			if ($type == 1)
				{
		  		$query = " INSERT INTO "
    				.$db->quoteName("#__minitek_faqbook_votes")
    				." (question_id, user_id, user_ip, vote_up, creation_date) "
        		." VALUES ('".$id."','".$user_id."','".$user_ip."','1','".$date."') ";
  				$db->setQuery($query);
  				$db->execute();

					// Get sum
		  		$query = "SELECT COUNT(*) FROM "
      			.$db->quoteName("#__minitek_faqbook_votes")
      			." WHERE " . $db->quoteName("question_id") . "=" . $db->Quote($id)
      			." AND " . $db->quoteName("vote_up") . "=" . $db->Quote('1');
					$db->setQuery($query);
					$vote_sum = $db->loadResult();
    		}

  			if ($type == 0)
				{
		  		$query = " INSERT INTO `#__minitek_faqbook_votes` (question_id, user_id, user_ip, vote_down, reason, creation_date) "
        		." VALUES ('".$id."','".$user_id."','".$user_ip."','1','".$reason."','".$date."') ";
  				$db->setQuery($query);
  				$db->execute();

					// Get sum
		  		$query = "SELECT COUNT(*) FROM "
      			.$db->quoteName("#__minitek_faqbook_votes")
      			." WHERE " . $db->quoteName("question_id") . "=" . $db->Quote($id)
      			." AND " . $db->quoteName("vote_down") . "=" . $db->Quote('1');
					$db->setQuery($query);
					$vote_sum = $db->loadResult();
    		}

				$output = $vote_sum;
			}
		}
		else
		{
	  	$query = ' SELECT a.* FROM ' . $db->quoteName('#__minitek_faqbook_votes') . ' AS a '
				. ' WHERE a.'.$db->quoteName('question_id').'=' . $db->Quote($id)
			. ' AND a.'.$db->quoteName('user_ip').'=' . $db->Quote($user_ip);
			$db->setQuery( $query );
	  	$ip_vote_exists = $db->loadObject();

			if (!$ip_vote_exists)
			{
  			if ($type == 1)
				{
  		  	$query = " INSERT INTO `#__minitek_faqbook_votes` (question_id, user_id, user_ip, vote_up, creation_date) "
          	." VALUES ('".$id."','".$user_id."','".$user_ip."','1','".$date."') ";
					$db->setQuery($query);
					$db->execute();

					// Get sum
			  	$query = "SELECT COUNT(*) FROM "
        		.$db->quoteName("#__minitek_faqbook_votes")
        		." WHERE " . $db->quoteName("question_id") . "=" . $db->Quote($id)
        		." AND " . $db->quoteName("vote_up") . "=" . $db->Quote('1');
					$db->setQuery($query);
					$vote_sum = $db->loadResult();
      	}

    		if ($type == 0)
				{
  		  	$query = " INSERT INTO `#__minitek_faqbook_votes` (question_id, user_id, user_ip, vote_down, reason, creation_date) "
          	." VALUES ('".$id."','".$user_id."','".$user_ip."','1','".$reason."','".$date."') ";
    			$db->setQuery($query);
    			$db->execute();

					// Get sum
  			 	$query = "SELECT COUNT(*) FROM "
        		.$db->quoteName("#__minitek_faqbook_votes")
        		." WHERE " . $db->quoteName("question_id") . "=" . $db->Quote($id)
        		." AND " . $db->quoteName("vote_down") . "=" . $db->Quote('1');
  				$db->setQuery($query);
  				$vote_sum = $db->loadResult();
      	}

				$output = $vote_sum;
			}
		}

		echo $output;
	}

	public static function FaqVotingReason($rid, $fid)
	{
		$db = JFactory::getDBO();
		$user = JFactory::getUser();
  	$user_id = $user->id;
		$user_ip = $_SERVER['REMOTE_ADDR'];
		$jnow = JFactory::getDate();
		$date = $jnow->toSql();

		if ($user_id)
		{
  		$query = " UPDATE `#__minitek_faqbook_votes` "
				." SET reason = ".$db->Quote($rid)." "
				." WHERE question_id = ".$db->Quote($fid)." "
				." AND user_id = ".$db->Quote($user_id)." ";

  		$db->setQuery($query);
  		$db->execute();

			$output = $rid;
		}
		else
		{
  		$query = " UPDATE `#__minitek_faqbook_votes` "
				." SET reason = ".$db->Quote($rid)." "
				." WHERE question_id = ".$db->Quote($fid)." "
				." AND user_ip = ".$db->Quote($user_ip)." ";

  		$db->setQuery($query);
  		$db->execute();

			$output = $rid;
		}

		return $output;
	}

	static function getFaqVotes($faq_id, $type)
	{
  	$db = JFactory::getDBO();
  	$query = "SELECT COUNT(*) FROM "
    	.$db->quoteName("#__minitek_faqbook_votes")
      ." WHERE " . $db->quoteName("question_id") . "=" . $db->Quote($faq_id)
      ." AND " . $db->quoteName($type) . "=" . $db->Quote('1');
		$db->setQuery($query);
		$vote_sum = $db->loadResult();

		return $vote_sum;
	}

	public static function addHit($id)
	{
    $db = JFactory::getDBO();
		$query = " UPDATE `#__minitek_faqbook_questions` "
			." SET hits = hits + 1 "
			." WHERE id = ".$db->Quote($id)." ";
  	$db->setQuery($query);
  	$db->execute();
	}
}
