<?php
/**
* @title				Minitek FAQ Book
* @copyright   	Copyright (C) 2011-2020 Minitek, All rights reserved.
* @license   		GNU General Public License version 3 or later.
* @author url   https://www.minitek.gr/
* @developers   Minitek.gr
*/

defined('_JEXEC') or die;

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.tabstate');
JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');

$user = JFactory::getUser();
$userId = $user->get('id');

if (!is_null($this->item->id))
{
	JFactory::getDocument()->addScriptDeclaration("
		Joomla.submitbutton = function(task)
		{
			if (task == 'myquestion.cancel' || document.formvalidator.isValid(document.getElementById('adminForm')))
			{
				" . $this->form->getField('articletext')->save() . "
				Joomla.submitform(task);
			}
		}
	");
}
else
{
	JFactory::getDocument()->addScriptDeclaration("
		Joomla.submitbutton = function(task)
		{
			if (task == 'myquestion.cancel' || document.formvalidator.isValid(document.getElementById('adminForm')))
			{
				Joomla.submitform(task);
			}
		}
	");
}
?>

<div id="fbpExtended" class="fbpFormExtended fbpFormMyQuestion">

	<div id="fbpcontent" class="fbpContent_core noleftnav">

		<div class="fbpContent_root">

			<div class="fbpContent_myquestion">

				<?php if (!$user->id && $this->params->get('question_guest_message', 1)) { ?>
				<div class="alert alert-warning">
					<?php echo JText::_('COM_FAQBOOKPRO_ANONYMOUS_QUESTION_MESSAGE'); ?>
				</div>
				<?php } ?>

				<form action="<?php echo JRoute::_('index.php?option=com_faqbookpro&a_id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="form-validate form-vertical">

					<?php echo $this->getToolbar(); ?>

					<fieldset>
						<?php echo JHtml::_('bootstrap.startTabSet', 'fbp-myquestion', array('active' => 'editor')); ?>

						<?php echo JHtml::_('bootstrap.addTab', 'fbp-myquestion', 'editor', JText::_('COM_FAQBOOKPRO_QUESTION_CONTENT')); ?>

							<?php echo $this->form->renderField('title'); ?>

							<?php if (!is_null($this->item->id)) : ?>
								<?php echo $this->form->renderField('alias'); ?>
							<?php endif; ?>

							<?php if ($this->params->get('select_topic')) { ?>
								<?php echo $this->form->renderField('topicid'); ?>
							<?php } else { ?>
								<input type="hidden" name="jform[topicid]" value="<?php echo $this->params->get('static_topic'); ?>" />
							<?php } ?>

							<?php if ($this->canDo->get('core.edit.state')) { ?>
								<?php echo $this->form->renderField('state'); ?>
							<?php } else { ?>
								<?php if ($this->params->get('auto_publish')) { ?>
									<?php if (is_null($this->item->id)) { ?>
										<input type="hidden" name="jform[state]" value="1" />
									<?php } else { ?>
										<input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>" />
									<?php } ?>
								<?php } else { ?>
									<?php if (is_null($this->item->id)) { ?>
										<input type="hidden" name="jform[state]" value="0" />
									<?php } else { ?>
										<input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>" />
									<?php } ?>
								<?php } ?>
							<?php } ?>

							<?php if (!is_null($this->item->id)) : ?>
								<?php echo $this->form->renderField('featured'); ?>
							<?php endif; ?>

							<?php if ($this->params->get('select_access') == 1 || ($this->params->get('select_access') == 2 && !is_null($this->item->id))) : ?>
								<?php echo $this->form->renderField('access'); ?>
							<?php endif; ?>

							<?php if ($this->params->get('select_language') == 1 || ($this->params->get('select_language') == 2 && !is_null($this->item->id))) { ?>
								<?php echo $this->form->renderField('language'); ?>
							<?php } else { ?>
								<input type="hidden" name="jform[language]" value="*" />

							<?php } ?>

							<?php if (!is_null($this->item->id)) : ?>
								<?php echo $this->form->renderField('articletext'); ?>
							<?php endif; ?>

							<?php if ($this->params->get('request_guest_email') && !$userId) : ?>
								<?php echo $this->form->renderField('created_by_email'); ?>
							<?php endif; ?>

							<?php if ($this->params->get('question_captcha')) :?>
								<?php echo $this->form->renderField('captcha'); ?>
							<?php endif; ?>

							<?php echo $this->form->renderField('id'); ?>

						<?php echo JHtml::_('bootstrap.endTab'); ?>

						<?php if ($this->params->get('select_images', '2') == 1 || ($this->params->get('select_images', '2') == 2 && !is_null($this->item->id))) : ?>
							<?php echo JHtml::_('bootstrap.addTab', 'fbp-myquestion', 'images', JText::_('COM_FAQBOOKPRO_QUESTION_IMAGES')); ?>
								<?php echo $this->form->renderField('image_intro', 'images'); ?>
								<?php echo $this->form->renderField('image_intro_alt', 'images'); ?>
								<?php echo $this->form->renderField('image_fulltext', 'images'); ?>
								<?php echo $this->form->renderField('image_fulltext_alt', 'images'); ?>
							<?php echo JHtml::_('bootstrap.endTab'); ?>
						<?php endif; ?>

						<?php if ($this->params->get('question_metadata') == 1 || ($this->params->get('question_metadata') == 2 && !is_null($this->item->id))) : ?>
							<?php echo JHtml::_('bootstrap.addTab', 'fbp-myquestion', 'metadata', JText::_('COM_FAQBOOKPRO_QUESTION_METADATA')); ?>
								<?php echo $this->form->renderField('metadesc'); ?>
								<?php echo $this->form->renderField('metakey'); ?>
							<?php echo JHtml::_('bootstrap.endTab'); ?>
						<?php endif; ?>

						<?php echo JHtml::_('bootstrap.endTabSet'); ?>

						<input type="hidden" name="task" value="" />
						<input type="hidden" name="return" value="<?php echo $this->return_page; ?>" />

						<?php echo JHtml::_('form.token'); ?>

					</fieldset>
				</form>

			</div>

		</div>

	</div>

</div>

<div class="clearfix"> </div>
