<?php
/**
* @title				Minitek FAQ Book
* @copyright   	Copyright (C) 2011-2020 Minitek, All rights reserved.
* @license   		GNU General Public License version 3 or later.
* @author url   https://www.minitek.gr/
* @developers   Minitek.gr
*/

defined('_JEXEC') or die;

class FAQBookProViewMyQuestion extends JViewLegacy
{
	protected $form;
	protected $item;
	protected $state;
	protected $return_page = '';

	public function display($tpl = null)
	{
		$user = JFactory::getUser();
		$app = JFactory::getApplication();
		$this->model = $this->getModel();
		$this->utilities = $this->model->utilities;
		$this->return_page = $app->input->get('return', null, 'base64');

		// Get model data.
		$this->form  = $this->get('Form');
		$this->item  = $this->get('Item');
		$this->state = $this->get('State');
		$this->canDo = $this->utilities->getActions('com_faqbookpro', 'question', $this->item->id);

		// Don't allow guests to edit
		if (!$user->id && $this->item->id)
		{
			JError::raiseError(403, JText::_('JLIB_APPLICATION_ERROR_EDIT_NOT_PERMITTED'));

			return false;
		}

		// Check for existing question.
		if (!empty($this->item->id))
		{
			$authorised = $user->authorise('core.edit', 'com_faqbookpro.question.' . (int) $this->item->id)
				|| ($user->authorise('core.edit.own', 'com_faqbookpro.question.' . (int) $this->item->id)
				&& $this->item->created_by == $user->get('id'));

			if (!$authorised)
			{
				JError::raiseError(403, JText::_('JERROR_ALERTNOAUTHOR'));

				return false;
			}
		}
		// New question, so check against the global permissions.
		else
		{
			if (!$user->authorise('core.create', 'com_faqbookpro'))
			{
				JError::raiseError(403, JText::_('JERROR_ALERTNOAUTHOR'));

				return false;
			}
		}

		// Create a shortcut to the parameters.
		$this->params = &$this->state->params;

		// Propose current language as default when creating new question
		if (JLanguageMultilang::isEnabled() && empty($this->item->id))
		{
			$lang = JFactory::getLanguage()->getTag();
			$this->form->setFieldAttribute('language', 'default', $lang);
		}

		// Bind images
		if (!empty($this->item) && isset($this->item->id))
		{
			$tmp = new stdClass;
			$tmp->images = $this->item->images;
			$this->form->bind($tmp);
		}

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		// Get Toolbar
		$this->getToolbar();

		parent::display($tpl);
	}

	protected function getToolbar()
	{
		jimport('cms.html.toolbar');
		$bar = new JToolBar( 'toolbar' );

		JFactory::getApplication()->input->set('hidemainmenu', true);
		$user       = JFactory::getUser();
		$userId     = $user->get('id');
		$isNew      = ($this->item->id == 0);
		$checkedOut = !($this->item->checked_out == 0 || $this->item->checked_out == $userId);

		// Built the actions for new and existing records.
		$canDo = $this->canDo;

		// For new records, check the create permission.
		if ($isNew && (count($this->utilities->getAuthorisedTopics('core.create')) > 0))
		{
			//$bar->appendButton( 'Standard', 'apply', 'COM_FAQBOOKPRO_MYQUESTION_APPLY', 'myquestion.apply', false );
			$bar->appendButton( 'Standard', 'apply', 'COM_FAQBOOKPRO_MYQUESTION_SAVE', 'myquestion.save', false );
			$bar->appendButton( 'Standard', 'cancel', 'COM_FAQBOOKPRO_MYQUESTION_CANCEL', 'myquestion.cancel', false );
		}
		else
		{
			// Can't save the record if it's checked out.
			if (!$checkedOut)
			{
				// Since it's an existing record, check the edit permission, or fall back to edit own if the owner.
				if ($canDo->get('core.edit') || ($canDo->get('core.edit.own') && $this->item->created_by == $userId))
				{
					$bar->appendButton( 'Standard', 'apply', 'COM_FAQBOOKPRO_MYQUESTION_SAVE', 'myquestion.save', false );
				}
			}

			$bar->appendButton( 'Standard', 'cancel', 'COM_FAQBOOKPRO_MYQUESTION_CANCEL', 'myquestion.cancel', false );
		}

		// Generate the html and return
		return $bar->render();
	}
}
