// detect mobile devices that support touch screen feature
// including windows mobile devices
var isTouchSupported = 'ontouchstart' in window,
    isTouchSupportedIE10 = navigator.userAgent.match(/Touch/i) != null;
    
tbjQuery(document).ready(function(){
    var xhr;
    // remove base tag in iframe mode as suddenly whole website loads inside the tab.
    // also when any parameter exists in URL, remove base tag
    if(tbjQuery('#tmpl').val()=='component' || tbjQuery('#url_booking_type').val()!='' || tbConfig.url_consists_dynamic_param==1){
	tbjQuery('base').remove();
    }
    tbjQuery( "#onepage_booking_accordion" ).accordion({
	header: "h3.onepage_booking_accordion_header",
	heightStyle: "content",
	active: 0,
	beforeActivate: function( event, ui ) {
	    if ( ui.newHeader.hasClass('ui-state-disabled') ){
		event.preventDefault();        
	    }    
	}
    });
    tbjQuery( "#myorders_accordion" ).accordion({
	header: "h3.myorders_accordion_header",
	heightStyle: "content",
	collapsible: true,
	active: 0
    });
    tbjQuery('div#payment_selectors').on( 'click', 'a#invoice_later_login', function(){
	tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 0 );
	tbjQuery( "#verticle_booking_wrap" ).tabs('option', 'active', -1); //  Activate the last one
	tbjQuery( "#myorders_accordion" ).accordion( "option", "active", 0 );
    })
    tbjQuery('.back_previous').click(function(){
	if(tbjQuery(this).hasClass('one')){
	    tbjQuery('#ui-accordion-onepage_booking_accordion-panel-0').animate({ scrollTop: 0 }, 'fast');
	    tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 0 );
	}
	else if(tbjQuery(this).hasClass('two')){
	    tbjQuery('#ui-accordion-onepage_booking_accordion-panel-1').animate({ scrollTop: 0 }, 'fast');
	    tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 1 );
	}
	else if(tbjQuery(this).hasClass('three')){
	    tbjQuery('#ui-accordion-onepage_booking_accordion-panel-2').animate({ scrollTop: 0 }, 'fast');
	    tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 2 );
	}
    })
    tbjQuery.fn.disableReturnBooking = function() {
        tbjQuery('#orderdatereturn').val(ORDER_RETURN_DATE_TXT);
	tbjQuery('#selPtHr2').selectbox('detach').val(HRS_TXT).selectbox('attach');
	tbjQuery('#selPtMn2').selectbox('detach').val(MINS_TXT).selectbox('attach');
	tbjQuery('#return_selPtHr2').val(HRS_TXT);
	tbjQuery('#return_selPtMn2').val(MINS_TXT);
	tbjQuery('#return_label').hide();
	tbjQuery('#returnjurney').attr('checked', false);		
	tbjQuery('#return_date_wrapper').hide();
	tbjQuery('div#return_extra_wrapper').html('').hide();
    }
    // return should not be there for hourly and shuttle booking
    if(tbjQuery('#booking_type').val()=='hourly' || tbjQuery('#booking_type').val()=='shuttle'){
	tbjQuery.fn.disableReturnBooking();
    }
    tbjQuery( "#verticle_booking_wrap" ).tabs({
	active: tbConfig.default_tab,
	create: function( event, ui ) {
	    var selectedTabTitle = tbjQuery(ui.tab).text();
	    if(selectedTabTitle==MYORDERS_TAB_LABEL){
		tbjQuery('div.verticl_booking_midpart, div.verticl_booking_bottompart, div.separator, input.see_price').hide();
	    }
	    else {
		tbjQuery('div.verticl_booking_midpart, div.verticl_booking_bottompart, div.separator, input.see_price').show();
		if(selectedTabTitle==HOURLY_HIRE_TAB_LABEL || selectedTabTitle==SHUTTLES_TAB_LABEL){
		    //tbjQuery.fn.disableReturnBooking();
		    if(selectedTabTitle==HOURLY_HIRE_TAB_LABEL){
			tbjQuery('#hourly_hr').addClass('required');
			tbjQuery('div.verticl_booking_midpart.nonshuttle, div.date_input.nonshuttle, div.separator.nonshuttle, div.date_input.hr_min.nonshuttle').show();
			tbjQuery('div.verticl_booking_bottompart.shuttle, div.date_input.shuttle, div.date_input.hr_min.shuttle').hide();
		    }
		    else if(selectedTabTitle==SHUTTLES_TAB_LABEL){
			tbjQuery('div.verticl_booking_midpart.nonshuttle, div.verticl_booking_bottompart.shuttle, div.date_input.nonshuttle, div.separator.nonshuttle, div.date_input.hr_min.nonshuttle').hide();
			tbjQuery('div.date_input.shuttle, div.date_input.hr_min.shuttle').show();
		    }
		}
		else {
		    tbjQuery('div.verticl_booking_midpart.nonshuttle, div.separator.nonshuttle, div.date_input.nonshuttle, div.date_input.hr_min.nonshuttle').show();
		    tbjQuery('div.verticl_booking_bottompart.shuttle, div.date_input.shuttle, div.date_input.hr_min.shuttle').hide();
			
		    tbjQuery('#return_label').show();
		    tbjQuery('#hourly_hr').removeClass('required');
		}
	    }
	},
	select: function(event, ui) {
	    tbjQuery('#booking_type').val(tbjQuery(ui.tab).attr('id'));
            var selectedTabTitle = tbjQuery(ui.tab).text();
	    if(selectedTabTitle==MYORDERS_TAB_LABEL){
		tbjQuery('div.verticl_booking_midpart, div.verticl_booking_bottompart, div.separator, input.see_price').hide();
	    }
	    else {
		tbjQuery('div.verticl_booking_midpart, div.verticl_booking_bottompart, div.separator, input.see_price').show();
		if(selectedTabTitle==HOURLY_HIRE_TAB_LABEL || selectedTabTitle==SHUTTLES_TAB_LABEL){
		    tbjQuery.fn.disableReturnBooking();
		    if(selectedTabTitle==HOURLY_HIRE_TAB_LABEL){
			tbjQuery('#hourly_hr').addClass('required');
			tbjQuery('div.verticl_booking_midpart.nonshuttle, div.date_input.nonshuttle, div.separator.nonshuttle, div.date_input.hr_min.nonshuttle').show();
			tbjQuery('div.verticl_booking_bottompart.shuttle, div.date_input.shuttle, div.date_input.hr_min.shuttle').hide();
		    }
		    else if(selectedTabTitle==SHUTTLES_TAB_LABEL){
			tbjQuery('div.verticl_booking_midpart.nonshuttle, div.verticl_booking_bottompart.shuttle, div.date_input.nonshuttle, div.separator.nonshuttle, div.date_input.hr_min.nonshuttle').hide();
			tbjQuery('div.date_input.shuttle, div.date_input.hr_min.shuttle').show();
		    }
		}
		else {
		    tbjQuery('div.verticl_booking_midpart.nonshuttle, div.date_input.nonshuttle, div.separator.nonshuttle, div.date_input.hr_min.nonshuttle').show();
		    tbjQuery('div.verticl_booking_bottompart.shuttle, div.date_input.shuttle, div.date_input.hr_min.shuttle').hide();
			
		    tbjQuery('#return_label').show();
		    tbjQuery('#hourly_hr').removeClass('required');
		}
	    }
	}
    });
    tbjQuery(".seat_options").selectbox();
    tbjQuery(".stop_interval_options").selectbox();    
    tbjQuery(".hrs, .mins").selectbox();
    tbjQuery.fn.unsetPoiAddress = function() {
        tbjQuery('input#address_from,input#address_from_lat,input#address_from_lng').val('');
        tbjQuery('div#pickup_extra_wrapper').html('');
	tbjQuery('div#stops_wrapper').html('');
        tbjQuery('input#address_to,input#address_to_lat,input#address_to_lng').val('');
        tbjQuery('div#dropoff_extra_wrapper').html('');
	tbjQuery('input#pickup_poi,input#dropoff_poi').val(0);
    }
    tbjQuery.fn.unsetRoute = function() {
        var route_swapped = tbjQuery('#route_swapped').val();
        if(route_swapped==1){ // routes are already swapped, so normalize them
	    tbjQuery('#route_category_fld').attr('readonly', false);
	    tbjQuery('#route_category_dropoff_fld').attr('readonly', false);
            tbjQuery('#route_from_fld').attr('readonly', false);
            tbjQuery('#route_to_fld').attr('readonly', false);
            tbjQuery('#route_swapped').val(0);
        }
	tbjQuery('#route_category_fld').val('');
        tbjQuery('#route_from_fld').val('');
        tbjQuery('#route_to_fld').val('');
	tbjQuery('#route_category_dropoff').val(0);
	tbjQuery('#route_category_dropoff_fld').val('');	
	tbjQuery('#route_category').val(0);
        tbjQuery('#route_from').val(0);
	if(tbjQuery('#show_poi_categories').val()==1){
	    tbjQuery('div.routes_wrapper_from div.routes_from_inner').hide();
	}
	tbjQuery('div.routes_wrapper_to').hide();
	tbjQuery('div.routes_indicator').hide();	
        tbjQuery('div#routefrom_extra_wrapper').html('');   
        tbjQuery('div#routeto_extra_wrapper').html('');
    }
    tbjQuery.fn.unsetHourlyHire = function() {
	tbjQuery('#hourly_hr').selectbox('detach');
	tbjQuery('#hourly_hr').val(0);
	tbjQuery('#hourly_hr').selectbox({
	    onOpen: function (inst) {},
	    onClose: function (inst) {},
	    onChange: function (val, inst) {
		tbjQuery('#hourly_hr').selectbox('close');
		tbjQuery('#booking_type').val('hourly');
		tbjQuery.fn.unsetPoiAddress();
		tbjQuery.fn.unsetRoute();
		tbjQuery.fn.unsetShuttle();
		tbjQuery.fn.getExtras('hourly_hire');
	    }
	});
	tbjQuery('#hourly_min').selectbox('detach').val(0).selectbox('attach');
	tbjQuery('div#hourly_extra_wrapper').html('');
    }
    tbjQuery.fn.unsetShuttle = function() {
	tbjQuery('#shuttle_pickup').val("");
	tbjQuery('#shuttle_pickup_poi').val(0);
	tbjQuery('#shuttle_dropoff').val("");
	tbjQuery('#shuttle_dropoff_poi').val(0);
	tbjQuery('input[name="shuttletime"]').attr('checked', false);
	tbjQuery("div.date_input.hr_min.shuttle").html('').hide();
	tbjQuery('#shuttle_passengers').val(0);
    }
    tbjQuery( 'a.field_desc, a.addstop' ).tooltip({
        track: true
    });
    tbjQuery('div#directions_panel').hide(); // hide the direction panel at first load
    // show dropdown div of poi1
    tbjQuery("div.pickup_wrap .poi_options_trigger").click(function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    tbjQuery(this).removeClass("Open");
	}
	else {
	    tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).next('.poi_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.pickup_wrap div.poi_dropdown_wrapper div.poi_link").click(function(){
	var poiObj = this;
	// first check if this POI is in Area of Operation
	areaOfOperation = new google.maps.Polygon({
	    paths: triangleCoords
	});
	if( tbConfig.pickup_in_area_operation==1 || tbConfig.pickup_dropoff_in_area_operation==1) {
	    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(tbjQuery(this).data('poilat'),tbjQuery(this).data('poilng')), areaOfOperation)) {
		tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').hide();
		tbjQuery('div.pickup_wrap .poi_options_trigger').removeClass('Open');
		
		showAreaOperationPopup();
		return false;
	    }
	}
	tbjQuery('#address_from').val(tbjQuery(this).children('span').html());
        tbjQuery('#address_from_lat').val(tbjQuery(this).data('poilat'));
	tbjQuery('#address_from_lng').val(tbjQuery(this).data('poilng'));
	tbjQuery('input#pickup_poi').val(tbjQuery(this).data('poiid'));
        tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').hide();
	tbjQuery('div.pickup_wrap .poi_options_trigger').removeClass('Open');
        // first unset route options
        tbjQuery.fn.unsetRoute();
        tbjQuery.fn.unsetHourlyHire();
	tbjQuery.fn.unsetShuttle();
        tbjQuery.fn.getExtras('pickup', tbjQuery(poiObj).data('poiid'));
        // set booking type
        tbjQuery('#booking_type').val('address');
	// regenerate return route with extra if Return Journey is selected
	if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
	    tbjQuery.fn.getReturnExtras();
	}
    })
    // show dropdown div of poi2
    tbjQuery("div.dropoff_wrap div.nonstop_wrap .poi_options_trigger").click(function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    tbjQuery(this).removeClass("Open");
	}
	else {
	    tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).next('.poi_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.dropoff_wrap div.nonstop_wrap div.poi_dropdown_wrapper div.poi_link").click(function(){
	var poiObj = this;
	// first check if this POI is in Area of Operation
	areaOfOperation = new google.maps.Polygon({
	    paths: triangleCoords
	});
	if( tbConfig.dropoff_in_area_operation==1 || tbConfig.pickup_dropoff_in_area_operation==1) {
	    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(tbjQuery(this).data('poilat'),tbjQuery(this).data('poilng')), areaOfOperation)) {
		tbjQuery("div.dropoff_wrap div.nonstop_wrap div.poi_dropdown_wrapper").hide();
		tbjQuery('div.dropoff_wrap div.nonstop_wrap .poi_options_trigger').removeClass('Open');
		
		showAreaOperationPopup();
		return false;
	    }
	}
	tbjQuery('#address_to').val(tbjQuery(this).children('span').html());
        tbjQuery('#address_to_lat').val(tbjQuery(this).data('poilat'));
	tbjQuery('#address_to_lng').val(tbjQuery(this).data('poilng'));
	tbjQuery('input#dropoff_poi').val(tbjQuery(this).data('poiid'));
        tbjQuery("div.dropoff_wrap div.nonstop_wrap div.poi_dropdown_wrapper").hide();
        tbjQuery('div.dropoff_wrap div.nonstop_wrap .poi_options_trigger').removeClass('Open');
        // first unset route options
        tbjQuery.fn.unsetRoute();
        tbjQuery.fn.unsetHourlyHire();
	tbjQuery.fn.unsetShuttle();
        tbjQuery.fn.getExtras('dropoff', tbjQuery(poiObj).data('poiid'));
        // set booking type
        tbjQuery('#booking_type').val('address');
	// regenerate return route with extra if Return Journey is selected
	if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
	    tbjQuery.fn.getReturnExtras();
	}
    })
    // show dropdown div of route category if show_poi_category is enabled
    if(tbjQuery('#show_poi_categories').val()==1)
    {
	// collect pickup route for this selected category
	tbjQuery.fn.collectRouteFrom = function() {
	    if(tbjQuery('#route_category').val() > 0)
	    {
		tbjQuery.ajax({
		    type: "POST",
		    url: 'index.php?option=com_taxibooking&task=getRouteList',
		    data: tbjQuery('#price_form').serialize(),
		    dataType: 'json',
		    async: false,
		    beforeSend: function(){
			tbjQuery('div.routes_wrapper_from div#routefrom_loader').html(tbjQuery('#route_loader').html());
			tbjQuery('div.routes_wrapper_to').hide();
			tbjQuery('div#routefrom_extra_wrapper').html('');   
			tbjQuery('div#routeto_extra_wrapper').html('');
			tbjQuery('#route_category_dropoff_fld').val('');
			tbjQuery('#route_category_dropoff').val(0);
		    },
		    complete: function(){
		    },
		    success: function(response){
			//tbjQuery('#route_to_wrap').html(response.msg);
			tbjQuery('div.routes_wrapper_from div#routefrom_loader').html('');
			tbjQuery('div.routes_wrapper_from').show();
			tbjQuery('div.routes_wrapper_from div.routes_from_inner').show();
			tbjQuery('div.routefrom_dropdown_wrapper').html(response.route_options_html);
			tbjQuery("#route_from_fld").autocomplete({
			    source: response.route_poi_data,		
			    minLength: 2,
			    open: function( event, ui ) {
				tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').hide();
			    },
			    select: function(event, ui) {
				tbjQuery('#route_from').val(ui.item.id);
				tbjQuery('#route_from_fld').val(ui.item.value);
				tbjQuery.fn.getExtras('route_pickup');
				// if show_route_category enabled, collect dropoff route category
				if(tbjQuery('#show_poi_categories').val()==1) {
				    tbjQuery.fn.collectDropoffRouteCategory();
				}
				else { // if show_route_category disabled, collect dropoff routes list
				    tbjQuery.fn.collectRouteTo();
				}
				tbjQuery('#booking_type').val('offers');
			    }
			})
			var mouseOverRouteFrom = false;
			tbjQuery('div.routes_wrapper .routefrom_options_trigger').mouseenter(function(){
			    mouseOverRouteFrom = true; 
			}).mouseleave(function(){ 
			    mouseOverRouteFrom = false; 
			})
			tbjQuery("html").click(function(){
			    if (!mouseOverRouteFrom) {
				tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').slideUp(250);
			    }
			});
		    }
		})
	    }
	    else {
		tbjQuery('div#routefrom_extra_wrapper').html('');   
		tbjQuery('div#routeto_extra_wrapper').html('');
		tbjQuery('div.routes_wrapper_to').hide();
	    }
	}
	tbjQuery("div.routecategory_wrapper_from .routecategory_options_trigger").click(function(){
	    if(tbjQuery(this).hasClass('Open') == true){
		tbjQuery(this).removeClass("Open");
	    }
	    else {
		tbjQuery(this).addClass("Open");
	    }
	    if (tbjQuery(this).prev('.routecategory_dropdown_wrapper').is(":visible") == true){
		tbjQuery(this).prev('.routecategory_dropdown_wrapper').slideUp(250);
	    }
	    else {
		tbjQuery(this).prev('.routecategory_dropdown_wrapper').slideDown(250);
	    }        
	})
	tbjQuery("div.routecategory_wrapper_from div.routecategory_dropdown_wrapper div.poi_link").click(function(){
	    tbjQuery('#route_category_dropoff').val(0);
	    tbjQuery('#route_category_dropoff_fld').val('');
	    tbjQuery('#route_from').val(0);
	    tbjQuery('#route_from_fld').val('');
	    tbjQuery('#route_to').val(0);
	    tbjQuery('#route_to_fld').val('');
	    tbjQuery('div#routefrom_extra_wrapper').html('');
	    tbjQuery('div#routeto_extra_wrapper').html('');
	    tbjQuery('#route_category').val(tbjQuery(this).attr('id'));
	    tbjQuery('#route_category_fld').val(tbjQuery(this).children('span').html());
	    tbjQuery('div.routecategory_wrapper_from div.routecategory_dropdown_wrapper').hide();
	    tbjQuery('div.routecategory_wrapper_from .routecategory_options_trigger').removeClass('Open');
	    
	    // unset all the poi/address selection below
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery.fn.unsetShuttle();
	    tbjQuery.fn.collectRouteFrom();
	    tbjQuery('#booking_type').val('offers');
	})
    }
    tbjQuery("div.routes_wrapper .routefrom_options_trigger").die("click").live('click', function(event){
	if(tbjQuery(this).hasClass('Open') == true){
	    //tbjQuery(this).removeClass("Open");
	}
	else {
	    //tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).prev('.routefrom_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).prev('.routefrom_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).prev('.routefrom_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.routes_wrapper div.routefrom_dropdown_wrapper div.poi_link").die("click").live('click', function(){
	tbjQuery('#route_from').val(tbjQuery(this).attr('id'));
	tbjQuery('#route_from_fld').val(tbjQuery(this).children('span').html());
	tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').hide();
	tbjQuery('div.routes_wrapper .routefrom_options_trigger').removeClass('Open');
	// unset all the poi/address selection below
	tbjQuery.fn.unsetPoiAddress();
	tbjQuery.fn.unsetHourlyHire();
	tbjQuery.fn.unsetShuttle();
	tbjQuery.fn.getExtras('route_pickup');
	// if show_route_category enabled, collect dropoff route category
	if(tbjQuery('#show_poi_categories').val()==1) {
	    tbjQuery.fn.collectDropoffRouteCategory();
	}
	else { // if show_route_category disabled, collect dropoff routes list
	    tbjQuery.fn.collectRouteTo();
	}
	tbjQuery('#booking_type').val('offers');
    })
    // show dropdown div of route from initially if show_poi_category is disabled
    if(tbjQuery('#show_poi_categories').val()==0)
    {
	var mouseOverRouteFrom = false;
	tbjQuery('div.routes_wrapper .routefrom_options_trigger').mouseenter(function(){
	    mouseOverRouteFrom = true; 
	}).mouseleave(function(){ 
	    mouseOverRouteFrom = false; 
	})
    }
    tbjQuery.fn.collectDropoffRouteCategory = function() {
        if(tbjQuery('#route_from').val() > 0) {
            tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&task=getRouteCategory',
                data: tbjQuery('#price_form').serialize(),
                dataType: 'json',
                async: false,
                beforeSend: function(){
                    tbjQuery('div.routes_wrapper_to').hide();
                    tbjQuery.fn.unsetPoiAddress();
                    tbjQuery.fn.unsetHourlyHire();
		    tbjQuery.fn.unsetShuttle();
                },
                complete: function(){
                },
                success: function(response){
		    tbjQuery('div.routes_wrapper_to').show();
		    tbjQuery('div.routes_to_inner').hide();
                    tbjQuery('div.routecategory_dropoff_dropdown_wrapper').html(response.route_categories_html);
                    tbjQuery("#route_category_dropoff_fld").autocomplete({
                        source: response.route_categories_data,		
                        minLength: 2,
                        open: function( event, ui ) {
                            tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').hide();
                        },
                        select: function(event, ui) {
                            tbjQuery('#route_category_dropoff').val(ui.item.id);
                            tbjQuery('#route_category_dropoff_fld').val(ui.item.value);
                            tbjQuery.fn.unsetPoiAddress();
                            tbjQuery.fn.unsetHourlyHire();
			    tbjQuery.fn.unsetShuttle();
                            tbjQuery.fn.collectRouteTo();
                            tbjQuery('#booking_type').val('offers');
                        }
                    })
                    // show dropdown div of route from
		    var mouseOverRouteCategoryDropoff = false;
		    tbjQuery('div.routecategory_dropoff_options_trigger').mouseenter(function(){
			mouseOverRouteCategoryDropoff = true; 
		    }).mouseleave(function(){ 
			mouseOverRouteCategoryDropoff = false; 
		    })
                    var mouseOverRouteTo = false;
                    tbjQuery('div.routes_wrapper .routeto_options_trigger').mouseenter(function(){
                        mouseOverRouteTo = true; 
                    }).mouseleave(function(){ 
                        mouseOverRouteTo = false; 
                    })
                    tbjQuery("html").click(function(){
			if (!mouseOverRouteCategoryDropoff) {
			    tbjQuery('div.routecategory_dropoff_dropdown_wrapper').slideUp(250);
			}
                        if (!mouseOverRouteTo) {
                            tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').slideUp(250);
                        }
                    });
                }
            })
        }
        else {
            tbjQuery('div.routes_wrapper_to').hide();
        }
    }
    tbjQuery("div.routecategory_dropoff_options_trigger").die("click").live('click', function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    tbjQuery(this).removeClass("Open");
	}
	else {
	    tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).prev('div.routecategory_dropoff_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).prev('div.routecategory_dropoff_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).prev('div.routecategory_dropoff_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.routecategory_dropoff_dropdown_wrapper div.poi_link").die("click").live('click', function(){
	tbjQuery('#route_to').val(0);
	tbjQuery('#route_to_fld').val('');
	tbjQuery('div#routeto_extra_wrapper').html('');
	tbjQuery('#route_category_dropoff').val(tbjQuery(this).attr('id'));
	tbjQuery('#route_category_dropoff_fld').val(tbjQuery(this).children('span').html());
	tbjQuery('div.routecategory_dropoff_dropdown_wrapper').hide();
	tbjQuery('div.routecategory_dropoff_options_trigger').removeClass('Open');
	tbjQuery.fn.unsetPoiAddress();
	tbjQuery.fn.unsetHourlyHire();
	tbjQuery.fn.unsetShuttle();
	tbjQuery.fn.collectRouteTo();
	tbjQuery('#booking_type').val('offers');
    })
    tbjQuery.fn.collectRouteTo = function() {
        if(tbjQuery('#route_from').val() > 0) {
            tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&task=getRouteList',
                data: tbjQuery('#price_form').serialize(),
                dataType: 'json',
                async: false,
                beforeSend: function(){
		    tbjQuery('div.routes_wrapper_to div#routefrom_loader').html(tbjQuery('#route_loader').html());
                    // unset route to
                    tbjQuery('#route_to').val(0);
                    tbjQuery('#route_to_fld').val('');
                    
                    tbjQuery('div#routeto_extra_wrapper').html('');
                    tbjQuery.fn.unsetPoiAddress();
                    tbjQuery.fn.unsetHourlyHire();
		    tbjQuery.fn.unsetShuttle();
                },
                complete: function(){
                },
                success: function(response){
                    tbjQuery('div.routes_wrapper_to div#routefrom_loader').html('');
                    tbjQuery('div.routes_indicator, div.routes_wrapper_to').show();
		    tbjQuery('div.routes_wrapper_to div.routes_to_inner').show();
                    tbjQuery('div.routeto_dropdown_wrapper').html(response.route_options_html);
                    tbjQuery("#route_to_fld").autocomplete({
                        source: response.route_poi_data,		
                        minLength: 2,
                        open: function( event, ui ) {
                            tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').hide();
                        },
                        select: function(event, ui) {
                            tbjQuery('#route_to').val(ui.item.id);
                            tbjQuery('#route_to_fld').val(ui.item.value);
                            // unset all the poi/address selection below
                            tbjQuery.fn.unsetPoiAddress();
                            tbjQuery.fn.unsetHourlyHire();
			    tbjQuery.fn.unsetShuttle();
                            tbjQuery.fn.getExtras('route_dropoff');
                            tbjQuery('#booking_type').val('offers');
                        }
                    })
                    
                    // show dropdown div of route from
                    var mouseOverRouteTo = false;
                    tbjQuery('div.routes_wrapper .routeto_options_trigger').mouseenter(function(){
                        mouseOverRouteTo = true; 
                    }).mouseleave(function(){ 
                        mouseOverRouteTo = false; 
                    })
                    tbjQuery("html").click(function(){
                        if (!mouseOverRouteTo) {
                            tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').slideUp(250);
                        }
                    });
                }
            })
        }
        else {
            tbjQuery('div.routes_wrapper_to').hide();
            //tbjQuery('#route_to_wrap').html('');
            tbjQuery('div#routefrom_extra_wrapper').html('');   
            tbjQuery('div#routeto_extra_wrapper').html('');
        }
    }
    tbjQuery("div.routes_wrapper .routeto_options_trigger").die("click").live('click', function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    //tbjQuery(this).removeClass("Open");
	}
	else {
	    //tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).prev('.routeto_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).prev('.routeto_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).prev('.routeto_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.routes_wrapper div.routeto_dropdown_wrapper div.poi_link").die("click").live('click', function(){
        tbjQuery('#route_to').val(tbjQuery(this).attr('id'));
        tbjQuery('#route_to_fld').val(tbjQuery(this).children('span').html());
        tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').hide();
	tbjQuery('div.routes_wrapper .routeto_options_trigger').removeClass('Open');
        tbjQuery.fn.unsetPoiAddress();
        tbjQuery.fn.unsetHourlyHire();
	tbjQuery.fn.unsetShuttle();
        tbjQuery.fn.getExtras('route_dropoff');
        tbjQuery('#booking_type').val('offers');
    })
    
    /*tbjQuery('#route_to').live('change', function(){
        tbjQuery.fn.getExtras('route_dropoff');
    })*/

    // swap route with extras
    tbjQuery.fn.swapRoute = function() {
        var pickup_route_selected = tbjQuery('#route_from').val();
        var dropoff_route_selected = tbjQuery('#route_to').val();
        if(pickup_route_selected==0 || dropoff_route_selected==0){
            alert('Please choose both routes!');
            return false;
        }
        var pickup_route_html = tbjQuery('#route_from_fld').val();
        var dropoff_route_html = tbjQuery('#route_to_fld').val();
        tbjQuery('#route_from_fld').val(dropoff_route_html);
        tbjQuery('#route_to_fld').val(pickup_route_html);
        tbjQuery('#route_from').val(dropoff_route_selected);
        tbjQuery('#route_to').val(pickup_route_selected);
        return true;
    }
    
    tbjQuery('a.swap_routes').click(function(){
        
        var route_swapped = tbjQuery('#route_swapped').val();
        if(route_swapped==1){ // routes are already swapped, so normalize them
            
	    tbjQuery('#route_category_fld').attr('readonly', false);
	    tbjQuery('#route_category_dropoff_fld').attr('readonly', false);
	    tbjQuery('#route_from_fld').attr('readonly', false);
            tbjQuery('#route_to_fld').attr('readonly', false);
            
            if(tbjQuery.fn.swapRoute()){
                tbjQuery('#route_swapped').val(0);
                tbjQuery("div.routecategory_options_trigger, div.routecategory_dropoff_options_trigger, div.routefrom_options_trigger, div.routeto_options_trigger").show();
                tbjQuery.fn.getSwappedRouteExtras();
		tbjQuery.fn.getReturnExtras();
            }
        }
        else {
            if(tbjQuery.fn.swapRoute()){
                tbjQuery('#route_swapped').val(1);
		tbjQuery('#route_category_fld').attr('readonly', true);
		tbjQuery('#route_category_dropoff_fld').attr('readonly', true);
                tbjQuery('#route_from_fld').attr('readonly', true);
                tbjQuery('#route_to_fld').attr('readonly', true);
                
                tbjQuery("div.routecategory_options_trigger, div.routecategory_dropoff_options_trigger, div.routefrom_options_trigger, div.routeto_options_trigger").hide();
                tbjQuery.fn.getSwappedRouteExtras();
		tbjQuery.fn.getReturnExtras();
            }
        }
    });
    
    // Shuttles booking
    tbjQuery("div.shuttle_pickup_wrap .poi_options_trigger").click(function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    tbjQuery(this).removeClass("Open");
	}
	else {
	    tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).next('.poi_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.shuttle_pickup_wrap div.poi_dropdown_wrapper div.poi_link").click(function(){
	
	tbjQuery('#shuttle_pickup').val(tbjQuery(this).children('span').html());
        tbjQuery('#shuttle_pickup_poi').val(tbjQuery(this).data('poiid'));
        tbjQuery('div.shuttle_pickup_wrap div.poi_dropdown_wrapper').hide();
	tbjQuery('div.shuttle_pickup_wrap .poi_options_trigger').removeClass('Open');
        
        // first unset route options
	tbjQuery.fn.unsetPoiAddress();
        tbjQuery.fn.unsetRoute();
        tbjQuery.fn.unsetHourlyHire();
        
        // set booking type
        tbjQuery('#booking_type').val('shuttle');
	tbjQuery.fn.getExtras('shuttle_pickup', tbjQuery(this).data('poiid'));
	tbjQuery('#shuttle_dropoff').val("");
	tbjQuery('#shuttle_dropoff_poi').val(0);
	tbjQuery.fn.getShuttleDropoffPOIs(tbjQuery(this).data('poiid'));
	
    })
    tbjQuery("div.shuttle_dropoff_wrap .poi_options_trigger").click(function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    tbjQuery(this).removeClass("Open");
	}
	else {
	    tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).next('.poi_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.shuttle_dropoff_wrap div.poi_dropdown_wrapper div.poi_link").die("click").live('click', function(){
	
	tbjQuery('#shuttle_dropoff').val(tbjQuery(this).children('span').html());
        tbjQuery('#shuttle_dropoff_poi').val(tbjQuery(this).data('poiid'));
        tbjQuery('div.shuttle_dropoff_wrap div.poi_dropdown_wrapper').hide();
	tbjQuery('div.shuttle_dropoff_wrap .poi_options_trigger').removeClass('Open');
        
        // first unset route options
	tbjQuery.fn.unsetPoiAddress();
        tbjQuery.fn.unsetRoute();
        tbjQuery.fn.unsetHourlyHire();
        tbjQuery('#booking_type').val('shuttle');
	tbjQuery.fn.getExtras('shuttle_dropoff', tbjQuery(this).data('poiid'));
	tbjQuery.fn.getShuttleTimeOptions(1); // clear_previous_selection = 1
    })
    tbjQuery.fn.getShuttleDropoffPOIs = function(poiid) {
        
        // if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
	
        var passingData = tbjQuery('#price_form').serialize()+'&poiid='+poiid;
        
        xhr = tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&controller=onepage&task=getShuttleDropoffPOIs',
                data: passingData,
                dataType: 'json',
                async: false,
                beforeSend: function(){
                    // load the ajax loading image
		    tbjQuery("div.shuttle_dropoff_wrap div.poi_dropdown_wrapper").html('').hide();
		    tbjQuery("div.date_input.hr_min.shuttle").html('').hide();
		    tbjQuery('input#shuttle_passengers').val('');
		    tbjQuery('div.verticl_booking_bottompart.shuttle').hide();
                },
                complete: function(){
                },
                success: function(response){
                    if(response.error==0)
                    {
			tbjQuery("div.shuttle_dropoff_wrap div.poi_dropdown_wrapper").html(response.msg);
                    }
		    else {
			tbjQuery("div.shuttle_dropoff_wrap div.poi_dropdown_wrapper").html('');
		    }
                }
        });
    }
    tbjQuery.fn.getShuttleTimeOptions = function(clear_previous_selection) {
        // if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
	if (typeof clear_previous_selection == 'undefined') {
	    clear_previous_selection = 1;
	}
        var passingData = tbjQuery('#price_form').serialize()+'&clear_previous_selection='+clear_previous_selection;
        xhr = tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&controller=onepage&task=getShuttleTimeOptions',
                data: passingData,
                dataType: 'json',
                async: false,
                beforeSend: function(){
                    // load the ajax loading image
		    //tbjQuery('div#shuttle_dropoff_extra_wrapper').html(tbjQuery('#route_loader').html());
		    tbjQuery("div.date_input.hr_min.shuttle").html('').hide();
		    tbjQuery('input#shuttle_passengers').val('');
		    tbjQuery('div.verticl_booking_bottompart.shuttle').hide();
                },
                complete: function(){
                },
                success: function(response){
                    if(response.error==0)
                    {
			tbjQuery("div.date_input.hr_min.shuttle").html(response.msg).show();
			// prepare passenger list for selected route time if selected from module
			if(clear_previous_selection==0 && tbjQuery("#module_shuttle_passengers").val() > 0)
			{
			    tbjQuery('div.verticl_booking_bottompart.shuttle').show();
			    tbjQuery('span#selected_seat').html(tbjQuery("#module_shuttle_passengers").val());
			    tbjQuery('input#shuttle_passengers').val(tbjQuery("#module_shuttle_passengers").val());
			}
                    }
		    else {
			tbjQuery("div.date_input.hr_min.shuttle").html(response.msg).show();
		    }
                }
        });
    }
    tbjQuery(document).on("click", 'input:radio[name="shuttletime"]', function (e) {
	tbjQuery('div.verticl_booking_bottompart.shuttle').show();
    })
    var shuttlePassengerDialog;
    tbjQuery(document).on("focus", 'input#shuttle_passengers', function (e) {
	if(tbjQuery('input:radio[name="shuttletime"]:checked').length > 0){
	    tbjQuery('div#shuttle-passengers-wrapper ul.shuttle-passengers-list').remove();
	    var available_seats = tbjQuery('input:radio[name="shuttletime"]:checked').parent().data('seats');
	    var passenger_list = tbjQuery('<ul class="shuttle-passengers-list">');
	    for(var i = 1; i <= parseInt(available_seats); i++){
		passenger_list.append(tbjQuery("<li>").html('<input type="button" class="passenger-btn" value="'+i+'" />'));
	    }
	    tbjQuery('div#shuttle-passengers-wrapper').append(passenger_list);
	    shuttlePassengerDialog = tbjQuery( "#dialog-shuttle-passengers" ).dialog({
		autoOpen: false,
		height: 300,
		width: 250,
		modal: true,
		buttons: {},
		close: function() {
		    shuttlePassengerDialog.dialog( "close" );
		}
	    });
	    shuttlePassengerDialog.dialog( "open" );
	}
    })
    tbjQuery(document).on("click", 'input:button.passenger-btn', function (e) {
	var selected_seat = tbjQuery(this).val();
	tbjQuery('input#shuttle_passengers').val(selected_seat);
	shuttlePassengerDialog.dialog( "close" );
    })
    // collect map data
    tbjQuery.fn.getMaps = function() { 
        // if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
        var booking_type = tbjQuery('#booking_type').val();
        var passingData = tbjQuery('#price_form').serialize();
	if(booking_type=='shuttle'){
	    passingData += '&shuttle_route_id='+tbjQuery('input[name="shuttletime"]:checked').parent('div.shuttletime_wrap').data('routeid');
	}
        xhr = tbjQuery.ajax({
                type: "POST"
                , url: 'index.php?option=com_taxibooking&controller=onepage&task=getPrice'
                , data: passingData
                , dataType: 'json'
                , beforeSend: function(){
		    tbjQuery('#ui-accordion-onepage_booking_accordion-panel-1').animate({ scrollTop: 0 }, 'fast');
                    // hide map and direction panel
                    tbjQuery('#map_wrapper').show();
		    tbjQuery('#map_processing').css({'visibility':'visible'});
                    tbjQuery('div#directions_panel').html('').hide();
                    // hide bottom vehicle list
                    tbjQuery('div.messagewrap').hide();
                    tbjQuery('div#vehicle_wrapper').html('');                  
                }
                , complete: function(){
                }
                , success: function(response){
		    // clear out the ajax loading image
		    tbjQuery('#map_processing').css({'visibility':'hidden'});
                    if(response.error==1)
                    {
			tbjQuery('div#map_canvas').html('');
			tbjQuery('div#directions_panel').html('');
			tbjQuery('div#map_wrapper').hide();
                        tbjQuery('div#warning_msg').show();
			tbjQuery('div#warning_msg div.messagetext').html(response.msg);
                    }
                    else
                    {
                        if(response.msg.show_map==1) // for POI or Address 
                        {
                            tbjQuery('div#directions_panel').show();
                            tbjQuery('div#map_wrapper').show();
                            tbjQuery('div#journey_details').show();
                            tbjQuery('div#journey_details #journey_msg').show();
                            var directionDisplay;
                            var directionsService = new google.maps.DirectionsService();
                            directionsDisplay = new google.maps.DirectionsRenderer();
                            var myOptions = {
                                zoom: parseInt(response.msg.map_zoom),
                                mapTypeId: google.maps.MapTypeId.ROADMAP
                            };
                            var map = new google.maps.Map(document.getElementById('map_canvas'), myOptions);
                            directionsDisplay.setMap(map);
                            directionsDisplay.setPanel(document.getElementById('directions_panel'));
                            document.getElementById('directions_panel').innerHTML = '';
                            var start = new google.maps.LatLng(response.msg.lat_long_from[0], response.msg.lat_long_from[1]);
                            var end = new google.maps.LatLng(response.msg.lat_long_to[0], response.msg.lat_long_to[1]);
                            var distance_unit = google.maps.UnitSystem.IMPERIAL;
                            if(tbjQuery('#distance_unit').val() == "kM") {
                                distance_unit = google.maps.UnitSystem.METRIC;  
                            }
			    var waypts = [];
			    tbjQuery('.waypoints').each(function(){
				var waypt_lat = tbjQuery(this).siblings('#waypoint_lat').val();
				var waypt_lng = tbjQuery(this).siblings('#waypoint_lng').val();
				if (waypt_lat!="" && waypt_lng!="") {
				    waypts.push({
						location:new google.maps.LatLng(waypt_lat, waypt_lng),
						stopover:true
					    });
				}
			    })
                            var request = {
                                origin: start,
                                destination: end,
				waypoints: waypts,
				optimizeWaypoints: (tbConfig.optimize_stops==1) ? true : false,
                                travelMode: google.maps.DirectionsTravelMode.DRIVING,
                                unitSystem: distance_unit
                            };
                            directionsService.route(request, function(response, status) {
                                if (status == google.maps.DirectionsStatus.OK) {
                                    directionsDisplay.setDirections(response);
                                }
                            });
                        }
                        else  
                        {
                            tbjQuery('div#map_canvas').html('');
                            tbjQuery('div#directions_panel').html('');
                            tbjQuery('div#map_wrapper').hide();
			    if(booking_type=='shuttle' && tbConfig.show_maps_in_shuttle==0){
				tbjQuery('div#journey_details').hide();
			    }
			    else {
				tbjQuery('div#journey_details').show();
				tbjQuery('div#journey_details #journey_msg').show();
			    }
                        }
			tbjQuery('#origin').html(response.msg.begin);
			tbjQuery('#destination').html(response.msg.end);
			tbjQuery('#distance').html(response.msg.distance);
			tbjQuery.fn.getCars();
                    }                    
                }
        })
    }
    // collect cars
    tbjQuery.fn.getCars = function() {
        // if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
        var passingData = tbjQuery('#price_form').serialize();
	var booking_type = tbjQuery('#booking_type').val();
        xhr = tbjQuery.ajax({
                type: "POST"
                , url: 'index.php?option=com_taxibooking&controller=onepage&task=getVehicles'
                , data: passingData
                , dataType: 'json'
                , beforeSend: function(){
		    tbjQuery('#ui-accordion-onepage_booking_accordion-panel-1').animate({ scrollTop: 0 }, 'fast');
		    tbjQuery('#vehicle_wrapper_div').show();
		    tbjQuery('#vehicle_processing').css({'visibility':'visible'});
                    tbjQuery('#vehicle_wrapper').html('');
		    tbjQuery('div.messagewrap').hide();
                }
                , complete: function(){
                }
                , success: function(response){
                    // clear out the ajax loading image
                    tbjQuery('#vehicle_processing').css({'visibility':'hidden'});
                    if(response.error==1)
                    {
			tbjQuery('div#map_canvas').html('');
			tbjQuery('div#directions_panel').html('').hide();
			tbjQuery('div#map_wrapper').hide();
			tbjQuery('div#journey_details').hide();
                        tbjQuery('div#warning_msg').show();
			tbjQuery('div#warning_msg div.messagetext').html(response.msg);
                    }
                    else
                    {
			tbjQuery('div#journey_details').show();
			tbjQuery('div#journey_details #journey_msg').show();
                        if(booking_type=='hourly'){
                            tbjQuery('div#journey_details').hide();
			    tbjQuery('div#map_wrapper').hide();
			    tbjQuery('div#directions_panel').html('').hide();
                        }
			// hide direction panel for shuttle booking
			if(booking_type=='shuttle'){
			    if(tbConfig.show_maps_in_shuttle==0){
				tbjQuery('div#journey_details').hide();
			    }
			    tbjQuery('div#directions_panel').html('').hide();
                        }
                        tbjQuery('#vehicle_wrapper').html(response.msg);
                        // show car description in tooltips
                        tbjQuery( 'a.car_desc' ).tooltip({
                            track: true
                        });
			// remove book now href and add data attribute
			tbjQuery('a.car_booking').each(function(){
			    var href_val = tbjQuery(this).attr('href');
			})
			tbjQuery('a#edit_direction_trigger').click(function(){
			    tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 0 );
			})
			tbjQuery('a#edit_details_trigger').click(function(){
			    tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 2 );
			})
                    }
                }
        });
    }
    
    // on clicking book now, book a car
    tbjQuery('a.car_booking').die("click").live('click', function(){
	tbjQuery('#ui-accordion-onepage_booking_accordion-panel-2').animate({ scrollTop: 0 }, 'fast');
	var vehicle_id = tbjQuery(this).data('carid');
	var booking_btn = tbjQuery(this);
	// if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
        var passingData = 'vehicle_id='+vehicle_id;
        xhr = tbjQuery.ajax({
                type: "POST"
                , url: 'index.php?option=com_taxibooking&controller=onepage&task=bookNow'
                , data: passingData
                , dataType: 'json'
		, async: false
                , beforeSend: function(){
		    booking_btn.after('<img id="summary_loader" style="width:43px;display:inline-block;" alt="Loading" src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader2.gif">');
                }
                , complete: function(){
                }
                , success: function(response){
                    booking_btn.next('#summary_loader').remove();
                    if(response.error==1)
                    {
                        alert(response.msg);
			return false;
                    }
                    else
                    {
                        tbjQuery("#onepage_booking_accordion h3.onepage_booking_accordion_header").eq(2).removeClass('ui-state-disabled');
			tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 2 );
			//tbjQuery('body').animate({ scrollTop: 0 }, 'fast');
			//tbjQuery('#ui-accordion-onepage_booking_accordion-header-2').scrollTop( 1000 );
			//tbjQuery('body').scrollTo('#ui-accordion-onepage_booking_accordion-header-2',{duration:'fast', offsetTop : '100'});
			if(response.msg.booking_type == "hourly"){
			    tbjQuery('.begin_text').html('');
			    tbjQuery('.end_text').html('');
			    tbjQuery('.not_for_hourly').hide();
			}
			else {
			    tbjQuery('.begin_text').html(response.msg.begin);
			    tbjQuery('.end_text').html(response.msg.end);
			    tbjQuery('.not_for_hourly').show();
			    if(response.msg.show_stops=="1"){
				tbjQuery('span#summary_stops').show();
				tbjQuery('.summary_stop_text').html(response.msg.stop_text+'<br/>');
			    }
			    else {
				tbjQuery('.summary_stop_text').html('');
				tbjQuery('span#summary_stops').hide();
			    }
			    if(response.msg.returnjurney==1){
				tbjQuery('#return_text').show();
			    }
			    else {
				tbjQuery('#return_text').hide();
			    }
			}
			if(response.msg.show_price==1){
			    tbjQuery('span#price_wrap').html(response.msg.price);
			    tbjQuery('div#price').show();
			}
			if(response.msg.found_payment_method > 0){
			    tbjQuery('div#payment_found_wrapper').show();
			    tbjQuery('div#payment_selectors').html(response.msg.payment_html);
			    tbjQuery('div#payment_not_found_text').hide();
			    if(tbjQuery('div#payment_selectors').find('input.tb_paymentmethods').length==1){ // if only payment method available, mark it
				tbjQuery('div#payment_selectors').find('input.tb_paymentmethods').attr('checked', true);
			    }
			}
			else {
			    tbjQuery('div#payment_selectors').html('');
			    tbjQuery('div#payment_found_wrapper').hide();
			    tbjQuery('div#payment_not_found_text').show();
			}
			tbjQuery( '.label_tooltip' ).tooltip({
                            track: true
                        });
			tbjQuery.fn.getExtras('user_details');
			
			// execute javascript in response
			// for now, js will come from Stripe payment plugin only
			tbjQuery("div#payment_found_wrapper").find("script").each(function(i) {
			    eval(tbjQuery(this).text());
			});
                    }
                }
        });
    })
    var address_search_enabled = false;
    if(tbjQuery('#address_from').length > 0 && tbjQuery('#address_to').length > 0){
	address_search_enabled = true;
    }
    var special_route_enabled = false;
    if(tbjQuery('#route_from_fld').length > 0){
	special_route_enabled = true;
    }
    var hourly_hire_enabled = false;
    if(tbjQuery('#hourly_hr').length > 0){
	hourly_hire_enabled = true;
    }
    var shuttle_enabled = false;
    if(tbjQuery('#shuttle_pickup').length > 0 && tbjQuery('#shuttle_dropoff').length > 0){
	shuttle_enabled = true;
    }
    if( ( (special_route_enabled && tbjQuery('#route_from').val()!=0 && tbjQuery('#route_to').val()!=0) ||
            (hourly_hire_enabled && tbjQuery('#hourly_hr').val()!=0 ) ||
            (address_search_enabled
		&& ( tbjQuery('#address_from').length>0&&tbjQuery('#address_from').val()!="" )
		&& ( tbjQuery('#address_to').length>0&&tbjQuery('#address_to').val()!="" )
	    ) ||
	    (shuttle_enabled && tbjQuery('#shuttle_pickup_poi').val()>0 && tbjQuery('#shuttle_dropoff_poi').val()>0 )
        )
       && (tbjQuery('#passengers').val()!=0)
       && (tbjQuery('#orderdate').val()!="" && tbjQuery('#orderdate').val()!="Date")
       && (url_booking_type=="")
       //&& (tbjQuery('[name="selPtHr1"]').val()!="" && tbjQuery('[name="selPtMn1"]').val()!="")
    )
    {
	tbjQuery('#ui-accordion-onepage_booking_accordion-panel-1').animate({ scrollTop: 0 }, 'fast');
        tbjQuery("#onepage_booking_accordion h3.onepage_booking_accordion_header").eq(1).removeClass('ui-state-disabled');
	tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 1 );
	var booking_type = tbjQuery('#booking_type').val();
	if(booking_type=='hourly'){
	    tbjQuery.fn.getCars();
	}
	else if(booking_type=='shuttle'){
	    tbjQuery.fn.getShuttleDropoffPOIs(tbjQuery('#shuttle_pickup_poi').val());
	    tbjQuery.fn.getShuttleTimeOptions(0); // clear_previous_selection = 0
	    tbjQuery.fn.getMaps();
	}
	else {
	    tbjQuery.fn.getMaps();
	}
    }
    tbjQuery('#hourly_hr').selectbox({
	    onOpen: function (inst) {
	    },
	    onClose: function (inst) {
	    },
	    onChange: function (val, inst) {
		tbjQuery('#hourly_hr').selectbox('close');
		tbjQuery('#booking_type').val('hourly');
		tbjQuery.fn.unsetPoiAddress();
		tbjQuery.fn.unsetRoute();
		tbjQuery.fn.getExtras('hourly_hire');
	    }
    });
    
    tbjQuery(".see_price").click(function(){
	tbjQuery('#data_source').val('component');
	tbjQuery('#ui-accordion-onepage_booking_accordion-panel-1').animate({ scrollTop: 0 }, 'fast');
        var booking_type = tbjQuery('#booking_type').val();
        // first validate the required field
        var err = 0;
	// address field validation if user choose address radio
	tbjQuery("#address_from").closest('div.top_ver_input_wrap').removeClass('incorrect');
	tbjQuery("#address_to").closest('div.top_ver_input_wrap').removeClass('incorrect');
	if(booking_type=='address')
	{
	    var address_from_lat = tbjQuery('#address_from_lat').val();
	    var address_from_lng = tbjQuery('#address_from_lng').val();
	    if(address_from_lat=="" || address_from_lng==""){
		err = err+1;
		tbjQuery("#address_from").closest('div.top_ver_input_wrap').addClass('incorrect');
	    }
	    var address_to_lat = tbjQuery('#address_to_lat').val();
	    var address_to_lng = tbjQuery('#address_to_lng').val();
	    if(address_to_lat=="" || address_to_lng==""){
		err = err+1;
		tbjQuery("#address_to").closest('div.top_ver_input_wrap').addClass('incorrect');
	    }
	}
	// other required field validation
	if(booking_type!='shuttle')
	{
	    if(tbjQuery('#passengers').val()=="0"){
		err = err+1;
		tbjQuery('#passengers').next("div.sbHolder").addClass('required incorrect');
	    }
	    else {
		tbjQuery('#passengers').next("div.sbHolder").removeClass('required incorrect');
	    }
	}
	if(booking_type=='hourly')
	{
	    if(tbjQuery('#hourly_hr').hasClass('required')){
		if(tbjQuery('#hourly_hr').val()=="0"){
		    err = err+1;
		    tbjQuery('#hourly_hr').next("div.sbHolder").addClass('required incorrect');
		}
		else {
		    tbjQuery('#hourly_hr').next("div.sbHolder").removeClass('required incorrect');
		}
	    }
	}
        tbjQuery('form#price_form').find('.required').each(function(){
            if(tbjQuery(this).is(":visible") == true && (tbjQuery(this).val()=="" || tbjQuery(this).val()=="0" || tbjQuery(this).val()=="Date")){
                err = err+1;
		if(tbjQuery(this).attr('id')=='shuttle_pickup' || tbjQuery(this).attr('id')=='shuttle_dropoff'){
		    tbjQuery(this).closest('div.top_ver_input_wrap').addClass('incorrect');
		}
		else {
		    tbjQuery(this).addClass('incorrect');
		}
            }
	    else {
		if(tbjQuery(this).attr('id')=='shuttle_pickup' || tbjQuery(this).attr('id')=='shuttle_dropoff'){
		    tbjQuery(this).closest('div.top_ver_input_wrap').removeClass('incorrect');
		}
		else {
		    tbjQuery(this).removeClass('incorrect');
		}
	    }
        })
        if(err>0){
	    tbjQuery('html, body').animate({ scrollTop: tbjQuery('#verticle_booking_wrap').offset().top }, 'fast');
	    //tbjQuery('body').animate({ scrollTop: 0 }, 'fast');
	    //tbjQuery('body').scrollTo('#ui-accordion-onepage_booking_accordion-header-0',{duration:'fast', offsetTop : '100'});
        }
	else {
	    tbjQuery("#onepage_booking_accordion h3.onepage_booking_accordion_header").eq(1).removeClass('ui-state-disabled');
	    tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 1 );
	    //tbjQuery('body').animate({ scrollTop: 0 }, 'fast');
	    //tbjQuery('body').scrollTo('#ui-accordion-onepage_booking_accordion-header-1',{duration:'fast', offsetTop : '100'});
            if(booking_type=='hourly'){
                tbjQuery.fn.getCars();
            }
            else {
                tbjQuery.fn.getMaps();
            }
	}
    })
    
    tbjQuery.fn.isValidEmailAddress = function(email) {
	var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	return regex.test(email);
      }
    /*tbjQuery.fn.isValidEmailAddress = function(emailAddress) {
	var pattern = new RegExp(/^(("[\w-\s]+")|([\w-]+(?:\.[\w-]+)*)|("[\w-\s]+")([\w-]+(?:\.[\w-]+)*))(@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$)|(@\[?((25[0-5]\.|2[0-4][0-9]\.|1[0-9]{2}\.|[0-9]{1,2}\.))((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[0-9]{1,2})\.){2}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[0-9]{1,2})\]?$)/i);
	return pattern.test(emailAddress);
    }*/
    tbjQuery.fn.isValidPhone = function(value) {
	var regex=/^(NA|[0-9+-]+)$/;
	return regex.test(value);
    }
    tbjQuery('#user_form  .required').change(function(){
	if(tbjQuery(this).val().length == 0)
	{
	    tbjQuery(this).addClass('incorrect');
	    tbjQuery(this).next('span.error').html(ERR_MESSAGE_FIELD_REQUIRED);
	}
	else if(tbjQuery(this).hasClass('email') && !tbjQuery.fn.isValidEmailAddress(tbjQuery(this).val()))
	{
	    tbjQuery(this).addClass('incorrect');
	    tbjQuery(this).next('span.error').html(ERR_MESSAGE_VALID_EMAIL);
	}
	else if(tbjQuery(this).hasClass('phone') && !tbjQuery.fn.isValidPhone(tbjQuery(this).val()))
	{
	    tbjQuery(this).addClass('incorrect');
	    tbjQuery(this).next('span.error').html(ERR_MESSAGE_VALID_PHONE);
	}
	else if(tbjQuery(this).hasClass('numeric') && !tbjQuery.isNumeric(tbjQuery(this).val()))
	{
	    tbjQuery(this).addClass('incorrect');
	    tbjQuery(this).next('span.error').html(ERR_MESSAGE_VALID_NUMERIC);
	}
	else {
	    tbjQuery(this).removeClass('incorrect');
	    tbjQuery(this).next('span.error').html('');
	}
    });
    tbjQuery(".see_summary").click(function(){
        var err = 0;
        tbjQuery('#user_form .required').each(function(){
            if(tbjQuery(this).val().length == 0)
	    {
                err = err+1;
                tbjQuery(this).addClass('incorrect');
		tbjQuery(this).next('span.error').html(ERR_MESSAGE_FIELD_REQUIRED);
            }
	    else if(tbjQuery(this).hasClass('email') && !tbjQuery.fn.isValidEmailAddress(tbjQuery(this).val()))
	    {
		err = err+1;
		tbjQuery(this).addClass('incorrect');
		tbjQuery(this).next('span.error').html(ERR_MESSAGE_VALID_EMAIL);
	    }
	    else if(tbjQuery(this).hasClass('phone') && !tbjQuery.fn.isValidPhone(tbjQuery(this).val()))
	    {
		err = err+1;
		tbjQuery(this).addClass('incorrect');
		tbjQuery(this).next('span.error').html(ERR_MESSAGE_VALID_PHONE);
	    }
	    else if(tbjQuery(this).hasClass('numeric') && !tbjQuery.isNumeric(tbjQuery(this).val()))
	    {
		err = err+1;
		tbjQuery(this).addClass('incorrect');
		tbjQuery(this).next('span.error').html(ERR_MESSAGE_VALID_NUMERIC);
	    }
	    else {
                tbjQuery(this).removeClass('incorrect');
		tbjQuery(this).next('span.error').html('');
	    }
        })
	err = check_user_details_fields(err);
	err = check_order_copy_fields(err);
	// check payment selection
	if(tbjQuery('div#payment_selectors').find('input[type="radio"][name="tb_paymentmethod_id"]').is(':checked')){
	    tbjQuery('div#payment_selectors').next('span.error').hide();
	}
	else {
	    err = err+1;
	    tbjQuery('div#payment_selectors').next('span.error').show();
	}
        if(err==0){
	    // if there is a previous ajax search, then we abort it and then set xhr to null
	    if( xhr != null ) {
		xhr.abort();
		xhr = null;
	    }
	    var passingData = tbjQuery('#user_form').serialize();
	    xhr = tbjQuery.ajax({
		type: "POST"
		, url: 'index.php?option=com_taxibooking&controller=onepage&task=previewOrder'
		, data: passingData
		, dataType: 'json'
		, beforeSend: function(){
		    tbjQuery('#summary_loader').css('display','inline-block');
		}
		, complete: function(){
		    // apply coupon automatically if coupon id is present in URL, only for URL booking
		    if(url_booking_type!='' && url_coupon_id > 0)
		    {
			tbjQuery.ajax({
			    type: "POST",
			    url: 'index.php?option=com_taxibooking&task=coupon_is_valid',
			    data: 'coupon_id='+url_coupon_id,
			    dataType: 'json',
			    async: false,
			    beforeSend: function(){
				tbjQuery('#coupon_loader').css('display','inline-block');
			    },
			    complete: function(){
			    },
			    success: function(response){
				tbjQuery('#coupon_loader').hide();
				tbjQuery('div#coupon_code_msg').html('');
				tbjQuery('div#grand_total').html(response.new_total);
				if(response.error==1){
				    tbjQuery('div#coupon_code_msg').html(response.msg);
				}
				else {
				    tbjQuery('#coupon_code').val(response.code);
				}
				if(response.prepayment > 0 && response.prepayment < 100 && tbjQuery('div#payment_labels').find('div.check_box_wrap').length > 0){
				    tbjQuery('div#payment_labels').children().eq(0).find('div.check_desc').html(response.due_now);
				    tbjQuery('div#payment_labels').children().eq(1).find('div.check_desc').html(response.due_later);
				}
			    }
			});
		    }
		}
		, success: function(response){
		    tbjQuery('#ui-accordion-onepage_booking_accordion-panel-3').animate({ scrollTop: 0 }, 'fast');
		    tbjQuery('#summary_loader').hide();
		    tbjQuery('a#edit_details_trigger').click(function(){
			tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 2 );
		    })
		    if(response.error==0)
		    {
			tbjQuery("#onepage_booking_accordion h3.onepage_booking_accordion_header").eq(3).removeClass('ui-state-disabled');
			tbjQuery( "#onepage_booking_accordion" ).accordion( "option", "active", 3 );
			//tbjQuery('body').animate({ scrollTop: 0 }, 'fast');
			//tbjQuery('body').scrollTo('#ui-accordion-onepage_booking_accordion-header-3',{duration:'fast', offsetTop : '100'});
			tbjQuery('#user_name').html(response.msg.name);
			tbjQuery('#user_email').html(response.msg.email);
			tbjQuery('#user_phone').html(response.msg.phone);
			tbjQuery('#vehicle_type').html(response.msg.vehicle_type);
			tbjQuery('#message').html(response.msg.message);
			tbjQuery('div#pickup_date').html(response.msg.pickup_date);
			tbjQuery('div#user_details_extra_wrap').html(response.msg.user_details_extra_html);
			tbjQuery('div#additional_seats_wrap').html(response.msg.additional_seats_html);
			
			if(response.msg.booking_type=='hourly'){
			    tbjQuery('div#begin_wrap, div#pickup_extra_wrap, div#PickupAddr1_wrap, div#pickup_poi_additional').hide();
			    tbjQuery('div#summary_stops, div#end_wrap, div#dropoff_extra_wrap, div#PickupAddr4_wrap, div#dropoff_poi_additional').hide();
			    tbjQuery('div#hourly_hired_wrap').show();
			    tbjQuery('div#hourly_hired_text').html(response.msg.hourly_hired_text);
			    tbjQuery('div#return_trip_wrap,div#return_trip_info_wrap').hide();
			    tbjQuery('div#hourly_extra_wrap').html(response.msg.hourly_extra_html).show();
			    tbjQuery('div#return_date,div#return_extra_wrap').html('');
			}
			else {
			    tbjQuery('div#begin_wrap, div#pickup_extra_wrap, div#pickup_poi_additional').show();
			    tbjQuery('div#end_wrap, div#dropoff_extra_wrap, div#dropoff_poi_additional').show();
			    tbjQuery('div#hourly_hired_wrap').hide();
			    tbjQuery('div#return_trip_wrap').show();
			    tbjQuery('div#return_trip_text').html(response.msg.return_trip_text);
			    
			    if(response.msg.show_stops=="1"){
				tbjQuery('div#summary_stops').show();
				tbjQuery('.summary_stop_text').html(response.msg.stop_text+'<br/>');
			    }
			    else {
				tbjQuery('.summary_stop_text').html('');
				tbjQuery('div#summary_stops').hide();
			    }
			    if(response.msg.PickupAddr1!=""){
				tbjQuery('div#PickupAddr1_wrap').show();
				tbjQuery('div#PickupAddr1').html(response.msg.PickupAddr1);
			    }
			    if(response.msg.PickupAddr4!=""){
				tbjQuery('div#PickupAddr4_wrap').show();
				tbjQuery('div#PickupAddr4').html(response.msg.PickupAddr4);
			    }
			    if(response.msg.customer_note!=""){
				tbjQuery('div#customer_note_wrap').show();
				tbjQuery('div#customer_note').html(response.msg.customer_note);
			    }
			    tbjQuery('div#pickup_extra_wrap').html(response.msg.pickup_extra_html);
			    tbjQuery('div#dropoff_extra_wrap').html(response.msg.dropoff_extra_html);
			    tbjQuery('div#hourly_extra_wrap').html('').hide();
			    tbjQuery('div#pickup_poi_additional').html(response.msg.pickup_poi_additional_html);
			    tbjQuery('div#dropoff_poi_additional').html(response.msg.dropoff_poi_additional_html);
			    
			    if(response.msg.return_trip==1){
				tbjQuery('div#return_trip_info_wrap').show();
				
				if(response.msg.return_date==""){
				    tbjQuery('div#return_date').parent().hide();
				}
				else {
				    tbjQuery('div#return_date').parent().show();
				    tbjQuery('div#return_date').html(response.msg.return_date);    
				}
				
				if(response.msg.return_wait_hr=="-1"){
				    tbjQuery('div#return_wait_time').parent().hide();
				}
				else {
				    tbjQuery('div#return_wait_time').parent().show();
				    tbjQuery('div#return_wait_time').html(response.msg.return_wait_hr);    
				}
				if(response.msg.return_wait_discount=="0"){
				    tbjQuery('div#return_wait_discount').parent().hide();
				}
				else {
				    tbjQuery('div#return_wait_discount').parent().show();
				    tbjQuery('div#return_wait_discount').html(response.msg.return_wait_discount);    
				}
				tbjQuery('div#return_extra_wrap').html(response.msg.return_extra_html);
			    }
			    else {
				tbjQuery('div#return_trip_info_wrap').hide();
				tbjQuery('div#return_date').html('');
				tbjQuery('div#return_extra_wrap').html('');
			    }
			}
			// price display
			if(response.msg.show_price==1){
			    tbjQuery('div#sub_total_wrap').show();
			    tbjQuery('div#grand_total_wrap').show();
			    tbjQuery('div#sub_total').html(response.msg.sub_total);
			    tbjQuery('div#grand_total').html(response.msg.grand_total);
			    if(response.msg.show_flat_cost==1){
				tbjQuery('div#flat_cost_wrap').show();
				tbjQuery('div#flat_cost').html(response.msg.flat_cost);
			    }
			    else {
				tbjQuery('div#flat_cost').html("");
				tbjQuery('div#flat_cost_wrap').hide();
			    }
			    if(response.msg.show_percentage_cost==1){
				tbjQuery('div#percentage_cost_wrap').show();
				tbjQuery('div#percentage_cost').html(response.msg.percentage_cost);
			    }
			    else {
				tbjQuery('div#percentage_cost').html("");
				tbjQuery('div#percentage_cost_wrap').hide();
			    }
			}
			else {
			    tbjQuery('div#sub_total,div#grand_total,div#flat_cost,div#percentage_cost').html("");
			    tbjQuery('div#sub_total_wrap,div#flat_cost_wrap,div#percentage_cost_wrap,div#grand_total_wrap').hide();
			}
			tbjQuery('div#payment_method_name').html(response.msg.payment_method_name);
			tbjQuery('div#payment_labels').html(response.msg.payment_labels);
			tbjQuery('.checkb0').attr('checked', false);
			tbjQuery('#security_code').val('');
			tbjQuery('.security_code_error').html('');
			tbjQuery('#coupon_code').val("");
			tbjQuery('#coupon_code_msg').html("");
			if(response.msg.enable_captcha==1){
			    tbjQuery('div#captcha_wrap').show();
			    tbjQuery('span#captcha_image').html(response.msg.captcha_image);
			}
			else {
			    tbjQuery('div#captcha_wrap').hide();
			    tbjQuery('span#captcha_image').html("");
			}
			if(response.msg.enable_gratuity==1){
			    tbjQuery('div#gratuities_wrap').html(response.msg.gratuity_html);
			    tbjQuery( '.gratuity_lbl' ).tooltip({
				track: true
			    });
			}
			if(response.msg.order_copy_html==""){
			    tbjQuery('div#order_copy_summary_wrap').parent('div.check_box_wrap').hide();
			}
			else {
			    tbjQuery('div#order_copy_summary_wrap').parent('div.check_box_wrap').show();
			    tbjQuery('div#order_copy_summary_wrap').html(response.msg.order_copy_html);
			}
			if(response.msg.show_user_group_discount==1){
			    tbjQuery('div#user_group_discount_wrap').show();
			    tbjQuery('div#user_group_discount').html(response.msg.user_group_discount);
			}
			else {
			    tbjQuery('div#user_group_discount').html('');
			    tbjQuery('div#user_group_discount_wrap').hide();
			}
		    }
		}
	    })
	}
	else {
	    //tbjQuery('body').animate({ scrollTop: 0 }, 'fast');
	    //tbjQuery('body').scrollTo('#ui-accordion-onepage_booking_accordion-header-2',{duration:'fast', offsetTop : '100'});
	}
    })
    tbjQuery("#coupon_code").change(function(){
	// if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
	tbjQuery('div.gratuities_btn').removeClass('active');
	tbjQuery('#flat_gratuity').val("");
        var passingData = tbjQuery(this).serialize();
        xhr = tbjQuery.ajax({
	    type: "POST",
	    url: 'index.php?option=com_taxibooking&task=coupon_is_valid',
	    data: passingData,
	    dataType: 'json',
	    async: false,
	    beforeSend: function(){
		// load the ajax loading image
		tbjQuery('#coupon_loader').css('display','inline-block');
	    },
	    complete: function(){
	    },
	    success: function(response){
		// clear out the ajax loading image
		tbjQuery('#coupon_loader').hide();
		tbjQuery('div#coupon_code_msg').html('');
		tbjQuery('div#grand_total').html(response.new_total);
		if(response.error==1){
		    tbjQuery('div#coupon_code_msg').html(response.msg);
		}
		if(response.prepayment > 0 && response.prepayment < 100 && tbjQuery('div#payment_labels').find('div.check_box_wrap').length > 0){
		    tbjQuery('div#payment_labels').children().eq(0).find('div.check_desc').html(response.due_now);
		    tbjQuery('div#payment_labels').children().eq(1).find('div.check_desc').html(response.due_later);
		}
		if(response.aup_required>0){
		    tbjQuery('#aup_required').html(response.aup_required);
		}
	    }
        });
    });
    tbjQuery(document).on("click", 'div.gratuities_btn', function (e) {
	var btnObj = this;
	var amt = tbjQuery(btnObj).data('amt');
	var amttype = tbjQuery(btnObj).data('amttype');
	if(tbjQuery(btnObj).hasClass('active')){
	    var action = 'deduce';
	}
	else {
	    var action = 'add';
	}
	tbjQuery('div.gratuities_btn').removeClass('active');
	tbjQuery('#flat_gratuity').val("");
	// if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
        xhr = tbjQuery.ajax({
	    type: "POST",
	    url: 'index.php?option=com_taxibooking&task=applyGratuityAjax',
	    data: 'amt='+amt+'&amttype='+amttype+'&action='+action+'&'+tbjQuery("#coupon_code").serialize(),
	    dataType: 'json',
	    async: false,
	    beforeSend: function(){
		tbjQuery('#gratuities_wrap').after('<img src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" id="ajax_loader" title="Loader" />');
	    },
	    complete: function(){
	    },
	    success: function(response){
		tbjQuery('#ajax_loader').remove();
		if(response.error==1){
		    alert(response.msg);
		    return false;
		}
		tbjQuery('div#grand_total').html(response.new_total);
		if(response.prepayment > 0 && response.prepayment < 100 && tbjQuery('div#payment_labels').find('div.check_box_wrap').length > 0){
		    tbjQuery('div#payment_labels').children().eq(0).find('div.check_desc').html(response.due_now);
		    tbjQuery('div#payment_labels').children().eq(1).find('div.check_desc').html(response.due_later);
		}
		if(action=='add'){
		    tbjQuery(btnObj).addClass('active');
		}
		if(response.aup_required>0){
		    tbjQuery('#aup_required').html(response.aup_required);
		}
	    }
        });
    })
    tbjQuery(document).on("change", '#flat_gratuity', function (e) {
	var btnObj = this;
	var amt = tbjQuery(this).val();
	var amttype = 'flat';
	tbjQuery('div.gratuities_btn').removeClass('active');
	if(amt!="" && tbjQuery.isNumeric(amt)){
	    var action = 'add';
	}
	else {
	    var action = 'deduce';
	}
	// if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
        xhr = tbjQuery.ajax({
	    type: "POST",
	    url: 'index.php?option=com_taxibooking&task=applyGratuityAjax',
	    data: 'amt='+amt+'&amttype='+amttype+'&action='+action+'&'+tbjQuery("#coupon_code").serialize(),
	    dataType: 'json',
	    async: false,
	    beforeSend: function(){
		tbjQuery('#gratuities_wrap').after('<img src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" id="ajax_loader" title="Loader" />');
	    },
	    complete: function(){
	    },
	    success: function(response){
		tbjQuery('#ajax_loader').remove();
		if(response.error==1){
		    alert(response.msg);
		    return false;
		}
		tbjQuery('div#grand_total').html(response.new_total);
		if(response.prepayment > 0 && response.prepayment < 100 && tbjQuery('div#payment_labels').find('div.check_box_wrap').length > 0){
		    tbjQuery('div#payment_labels').children().eq(0).find('div.check_desc').html(response.due_now);
		    tbjQuery('div#payment_labels').children().eq(1).find('div.check_desc').html(response.due_later);
		}
		if(response.aup_required>0){
		    tbjQuery('#aup_required').html(response.aup_required);
		}
	    }
        });
    })
    tbjQuery("#terms_trigger").fancybox({
	'autoScale'			: true,
	'transitionIn'		: 'none',
	'transitionOut'		: 'none',
	'type'			: 'iframe'
    });
    tbjQuery('[name="cbox"]').click(function(){
	if(tbjQuery(this).is(':checked')){
	    tbjQuery('[name="submitCash"]').attr('disabled', false);
	}
	else {
	    tbjQuery('[name="submitCash"]').attr('disabled', true);
	}
    })
    tbjQuery('[name="submitCash"]').click(function(){
        // if there is a previous ajax search, then we abort it and then set xhr to null
	if( xhr != null ) {
	    xhr.abort();
	    xhr = null;
	}
	var passingData = tbjQuery('#captcha_form').serialize();
	xhr = tbjQuery.ajax({
	    type: "POST"
	    , url: 'index.php?option=com_taxibooking&controller=onepage&task=checkCaptcha'
	    , data: passingData
	    , dataType: 'json'
	    , beforeSend: function(){
		tbjQuery('#make_booking_loader').show();
	    }
	    , complete: function(){
	    }
	    , success: function(response){
		if(response.error==1)
		{
		    tbjQuery('#make_booking_loader').hide();
		    tbjQuery('.security_code_error').html(response.msg);
		    return false;
		}
		else {
		    tbjQuery('[name="submitCash"]').attr('disabled', true);
		    // submit order
		    xhr = tbjQuery.ajax({
			type: "POST"
			, url: 'index.php?option=com_taxibooking&controller=onepage&task=submitOrder'
			, data: tbjQuery('#captcha_form').serialize()
			, dataType: 'json'
			, beforeSend: function(){
			}
			, complete: function(){
 			}
			, success: function(response){
			    tbjQuery('#make_booking_loader').hide();
			    if(response.error==0)
			    {
				window.location = response.redirect_url;
			    }
			    else {
				alert(response.msg);
				return false;
			    }
			}
		    })
		}
	    }
	})
    })
    // hide all the dropdown if clicked outside of the arrow
    var mouseOverPoi1 = false;
    tbjQuery('div.pickup_wrap .poi_options_trigger').mouseenter(function(){
        mouseOverPoi1 = true; 
    }).mouseleave(function(){ 
        mouseOverPoi1 = false; 
    })
    var mouseOverPoi2 = false;
    tbjQuery('div.dropoff_wrap div.nonstop_wrap .poi_options_trigger').mouseenter(function(){
        mouseOverPoi2 = true; 
    }).mouseleave(function(){ 
        mouseOverPoi2 = false; 
    })
    var mouseOverRouteCategory = false;
    tbjQuery('div.routecategory_wrapper_from .routecategory_options_trigger').mouseenter(function(){
	mouseOverRouteCategory = true; 
    }).mouseleave(function(){ 
	mouseOverRouteCategory = false; 
    })
    var mouseOverRouteFrom = false;
    tbjQuery('div.routes_wrapper .routefrom_options_trigger').mouseenter(function(){
	mouseOverRouteFrom = true; 
    }).mouseleave(function(){ 
	mouseOverRouteFrom = false; 
    })
    var mouseOverRouteCategoryDropoff = false;
    tbjQuery('div.routecategory_dropoff_options_trigger').mouseenter(function(){
	mouseOverRouteCategoryDropoff = true; 
    }).mouseleave(function(){ 
	mouseOverRouteCategoryDropoff = false; 
    })
    var mouseOverRouteTo = false;
    tbjQuery('div.routes_wrapper .routeto_options_trigger').mouseenter(function(){
	mouseOverRouteTo = true; 
    }).mouseleave(function(){ 
	mouseOverRouteTo = false; 
    })
    var mouseOverShuttlePickupPoi = false;
    tbjQuery('div.shuttle_pickup_wrap .poi_options_trigger').mouseenter(function(){
        mouseOverShuttlePickupPoi = true; 
    }).mouseleave(function(){ 
        mouseOverShuttlePickupPoi = false; 
    })
    var mouseOverShuttleDropoffPoi = false;
    tbjQuery('div.shuttle_dropoff_wrap .poi_options_trigger').mouseenter(function(){
        mouseOverShuttleDropoffPoi = true; 
    }).mouseleave(function(){ 
        mouseOverShuttleDropoffPoi = false; 
    })
    tbjQuery("html").click(function(){
        if (!mouseOverPoi1) {
            tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').slideUp(250);
        }
        if (!mouseOverPoi2) {
            tbjQuery("div.dropoff_wrap div.nonstop_wrap div.poi_dropdown_wrapper").slideUp(250);
        }
	if (!mouseOverRouteFrom) {
	    tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').slideUp(250);
	}
	if (!mouseOverRouteCategory) {
	    tbjQuery('div.routecategory_wrapper_from div.routecategory_dropdown_wrapper').slideUp(250);
	}
	if (!mouseOverRouteCategoryDropoff) {
	    tbjQuery('div.routecategory_dropoff_dropdown_wrapper').slideUp(250);
	}
	if (!mouseOverRouteTo) {
	    tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').slideUp(250);
	}
	if (!mouseOverShuttlePickupPoi) {
            tbjQuery('div.shuttle_pickup_wrap div.poi_dropdown_wrapper').slideUp(250);
        }
	if (!mouseOverShuttleDropoffPoi) {
            tbjQuery('div.shuttle_dropoff_wrap div.poi_dropdown_wrapper').slideUp(250);
        }
    });
    tbjQuery(document).mouseup(function (e)
    {
	var container = tbjQuery("div.dropoff_wrap div.stops_wrap div.poi_dropdown_wrapper");
	if (!container.is(e.target) // if the target of the click isn't the container...
	    && container.has(e.target).length === 0) // ... nor a descendant of the container
	{
	    container.slideUp(250);
	}
    });
    // collect extra list
    tbjQuery.fn.getExtras = function(type, poiid) {
	if (typeof poiid == 'undefined') {
	    poiid = 0;
	}
        var passingData = tbjQuery('#price_form').serialize()+'&type='+type+'&poiid='+poiid;
        tbjQuery.ajax({
	    type: "POST",
	    url: 'index.php?option=com_taxibooking&controller=onepage&task=getExtraList',
	    data: passingData,
	    dataType: 'json',
	    async: false,
	    beforeSend: function(){
		// load the ajax loading image
		if(type=='pickup' || type=='address_pickup'){
		    tbjQuery('div#pickup_extra_wrapper').html(tbjQuery('#route_loader').html());   
		}
		else if(type=='dropoff' || type=='address_dropoff'){
		    tbjQuery('div#dropoff_extra_wrapper').html(tbjQuery('#route_loader').html());
		}
		else if(type=='route_pickup'){
		    tbjQuery('div#routefrom_extra_wrapper').html(tbjQuery('#route_loader').html());   
		}
		else if(type=='route_dropoff'){
		    tbjQuery('div#routeto_extra_wrapper').html(tbjQuery('#route_loader').html());
		}
		else if(type=='hourly_hire'){
		    tbjQuery('div#hourly_extra_wrapper').html(tbjQuery('#route_loader').html());
		}
		else if(type=='user_details'){
		    tbjQuery('div#user_details_extra_wrapper').html(tbjQuery('#route_loader').html());
		}
		else if(type=='shuttle_pickup'){
		    tbjQuery('div#shuttle_pickup_extra_wrapper').html(tbjQuery('#route_loader').html());   
		}
		else if(type=='shuttle_dropoff'){
		    tbjQuery('div#shuttle_dropoff_extra_wrapper').html(tbjQuery('#route_loader').html());
		}
	    },
	    complete: function(){
		// fill up the extras value from URL extras
		if (typeof url_extras != 'undefined') {
		    var url_extras_arr = JSON.parse(url_extras.toString());
		    if(url_booking_type=='address')
		    {
			for (var key in url_extras_arr['pickup'])
			{
			    if( tbjQuery('[name="extras[pickup]['+key+']"]').prop('type') == 'select-one' ) {
				tbjQuery('[name="extras[pickup]['+key+']"]').selectbox('detach').val(url_extras_arr['pickup'][key]).selectbox('attach');
			    }
			    else {
				tbjQuery('[name="extras[pickup]['+key+']"]').val(url_extras_arr['pickup'][key]);
			    }
			}
			for (var key in url_extras_arr['dropoff'])
			{
			    if( tbjQuery('[name="extras[dropoff]['+key+']"]').prop('type') == 'select-one' ) {
				tbjQuery('[name="extras[dropoff]['+key+']"]').selectbox('detach').val(url_extras_arr['dropoff'][key]).selectbox('attach');
			    }
			    else {
				tbjQuery('[name="extras[dropoff]['+key+']"]').val(url_extras_arr['dropoff'][key]);
			    }
			}
		    }
		    else if(url_booking_type=='offers')
		    {
			for (var key in url_extras_arr['route_pickup'])
			{
			    if( tbjQuery('[name="extras[route_pickup]['+key+']"]').prop('type') == 'select-one' ) {
				tbjQuery('[name="extras[route_pickup]['+key+']"]').selectbox('detach').val(url_extras_arr['route_pickup'][key]).selectbox('attach');
			    }
			    else {
				tbjQuery('[name="extras[route_pickup]['+key+']"]').val(url_extras_arr['route_pickup'][key]);
			    }
			}
			for (var key in url_extras_arr['route_dropoff'])
			{
			    if( tbjQuery('[name="extras[route_dropoff]['+key+']"]').prop('type') == 'select-one' ) {
				tbjQuery('[name="extras[route_dropoff]['+key+']"]').selectbox('detach').val(url_extras_arr['route_dropoff'][key]).selectbox('attach');
			    }
			    else {
				tbjQuery('[name="extras[route_dropoff]['+key+']"]').val(url_extras_arr['route_dropoff'][key]);
			    }
			}
		    }
		    else if(url_booking_type=='hourly')
		    {
			for (var key in url_extras_arr['hourly_hire'])
			{
			    if( tbjQuery('[name="extras[hourly_hire]['+key+']"]').prop('type') == 'select-one' ) {
				tbjQuery('[name="extras[hourly_hire]['+key+']"]').selectbox('detach').val(url_extras_arr['hourly_hire'][key]).selectbox('attach');
			    }
			    else {
				tbjQuery('[name="extras[hourly_hire]['+key+']"]').val(url_extras_arr['hourly_hire'][key]);
			    }
			}
		    }
		}
	    },
	    success: function(response){
		// clear out the ajax loading image
		tbjQuery('#route_loader').hide();
		if(response.error==0)
		{
		    if(type=='pickup' || type=='address_pickup'){
			tbjQuery('div#pickup_extra_wrapper').html(response.msg);   
		    }
		    else if(type=='dropoff' || type=='address_dropoff'){
			tbjQuery('div#dropoff_extra_wrapper').html(response.msg);
		    }
		    else if(type=='route_pickup'){
			tbjQuery('div#routefrom_extra_wrapper').html(response.msg);   
		    }
		    else if(type=='route_dropoff'){
			tbjQuery('div#routeto_extra_wrapper').html(response.msg);
		    }
		    else if(type=='hourly_hire'){
			tbjQuery('div#hourly_extra_wrapper').html(response.msg);
		    }
		    else if(type=='user_details'){
			tbjQuery('div#user_details_extra_wrapper').html(response.msg);
		    }
		    else if(type=='shuttle_pickup'){
			tbjQuery('div#shuttle_pickup_extra_wrapper').html(response.msg);   
		    }
		    else if(type=='shuttle_dropoff'){
			tbjQuery('div#shuttle_dropoff_extra_wrapper').html(response.msg);
		    }
		    // show car description in tooltips
		    tbjQuery( 'a.field_desc' ).tooltip({
			track: true
		    });
		    tbjQuery(".seat_options").selectbox();
		}
	    }
        });
    }
    // This function collects extras fir swapped routes
    tbjQuery.fn.getSwappedRouteExtras = function(type) {
        // if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
        var passingData = tbjQuery('#price_form').serialize();
        xhr = tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&task=getSwappedExtraList',
                data: passingData,
                dataType: 'json',
                async: false,
                beforeSend: function(){
                    // load the ajax loading image
                    tbjQuery('#route_loader').show();
                    tbjQuery('div#routefrom_extra_wrapper').html('');
                    tbjQuery('div#routeto_extra_wrapper').html('');
                },
                complete: function(){
                },
                success: function(response){
                    // clear out the ajax loading image
                    tbjQuery('#route_loader').hide();
                    if(response.error==0)
                    {
                        tbjQuery('div#routefrom_extra_wrapper').html(response.pickupextra);   
                        tbjQuery('div#routeto_extra_wrapper').html(response.dropoffextra);
                        // show car description in tooltips
                        tbjQuery( 'a.field_desc' ).tooltip({
                            track: true
                        });
			tbjQuery(".seat_options").selectbox();
                    }
                }
        });
    }
    tbjQuery.fn.getReturnExtras = function() {
	if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
	    tbjQuery.ajax({
                type: "POST",
		url: 'index.php?option=com_taxibooking&controller=onepage&task=getReturnExtraList',
		data: tbjQuery('#price_form').serialize(),
		dataType: 'json',
		async: false,
		beforeSend: function(){
		    tbjQuery('div#return_extra_wrapper').show().html(tbjQuery('#route_loader').html());
		},
		complete: function(){
		    // fill up the extras value from URL extras
		    if (typeof url_extras != 'undefined') {
			var url_extras_arr = JSON.parse(url_extras.toString());
			for (var key in url_extras_arr['return_pickup'])
			{
			    if( tbjQuery('[name="extras[return_pickup]['+key+']"]').prop('type') == 'select-one' ) {
				tbjQuery('[name="extras[return_pickup]['+key+']"]').selectbox('detach').val(url_extras_arr['return_pickup'][key]).selectbox('attach');
			    }
			    else {
				tbjQuery('[name="extras[return_pickup]['+key+']"]').val(url_extras_arr['return_pickup'][key]);
			    }
			}
			for (var key in url_extras_arr['return_dropoff'])
			{
			    if( tbjQuery('[name="extras[return_dropoff]['+key+']"]').prop('type') == 'select-one' ) {
				tbjQuery('[name="extras[return_dropoff]['+key+']"]').selectbox('detach').val(url_extras_arr['return_dropoff'][key]).selectbox('attach');
			    }
			    else {
				tbjQuery('[name="extras[return_dropoff]['+key+']"]').val(url_extras_arr['return_dropoff'][key]);
			    }
			}
		    }
		},
		success: function(response){
		    tbjQuery('#route_loader').hide();
		    if(response.error==0)
		    {
			tbjQuery('div#return_extra_wrapper').show().html(response.msg);   
			// show car description in tooltips
			tbjQuery( 'a.field_desc' ).tooltip({
			    track: true
			});
			tbjQuery(".seat_options").selectbox();
		    }
		}
	    });
	}
	else {
	    return false;
	}
    }
    // order date picker for jquery datepicker
    tbjQuery( "#orderdate_shuttle" ).datepicker({
	dateFormat: tbjQuery('#date_format').val(),
	minDate: new Date(),
	closeText: "X",
	showButtonPanel: true,
	beforeShowDay: function(date) {
	    var string = tbjQuery.datepicker.formatDate('yy-mm-dd', date);
	    var isDisabled = (disabledDates.indexOf(string) == -1); // used to disable if its an holiday or weekend
	    return [isDisabled];
	},
	onSelect: function(dateText, inst){
	    
	    // fetch available time options for shuttle booking
	    if(tbjQuery('#booking_type').val()=='shuttle'){
		tbjQuery.fn.getShuttleTimeOptions(1); // clear_previous_selection = 1
	    }
	}
    })
    if(tbjQuery('#datepicker_type').val()=='jquery')
    {
	var locale = tbjQuery('#locale').val();
	tbjQuery.datepicker.setDefaults( tbjQuery.datepicker.regional[ locale ] );
	tbjQuery( "#orderdatereturn" ).datepicker({
	    dateFormat: tbjQuery('#date_format').val(),
	    minDate: new Date(),
	    closeText: "X",
	    showButtonPanel: true,
	    beforeShowDay: function(date) {
		var string = tbjQuery.datepicker.formatDate('yy-mm-dd', date);
		var isDisabled = (disabledDates.indexOf(string) == -1); // used to disable if its an holiday or weekend
		return [isDisabled];
	    },
	    onSelect: function(dateText, inst){
		if(!tbjQuery.fn.compareDate()) {
		    if(tbjQuery('#datepicker_type').val()=='jquery'){
			if(tbjQuery("#selPtHr1").val() >= tbjQuery("#return_selPtHr2").val()) {
			    tbjQuery("#return_selPtHr2").val(HRS_TXT);
			    tbjQuery("#return_selPtMn2").val(MINS_TXT);
			}
		    }
		    else {
			if(tbjQuery("#selPtHr1").val() >= tbjQuery("#selPtHr2").val()) {
			    tbjQuery("#selPtHr2").val('');
			    tbjQuery("#selPtMin2").val('');
			}
		    }
		}
	    }
	})
	if(tbjQuery( "#orderdate" ).val()!=""&&tbjQuery( "#orderdate" ).val()!="Date") {
	    var dateText = tbjQuery( "#orderdate" ).val();
	    if(tbjQuery('#date_format').val()=='dd-mm-yy'){
		var order_date_day = dateText.substring(0, 2);
		var order_date_month = dateText.substring(3, 5);
	    }
	    else {
		var order_date_month = dateText.substring(0, 2);
		var order_date_day  = dateText.substring(3, 5);
	    }
	    var order_date_year = dateText.substring(6, 10);
	    tbjQuery( "#orderdatereturn" ).datepicker( "option", "minDate", new Date(order_date_year, parseInt(order_date_month)-1, order_date_day) );
	}
	tbjQuery( "#orderdate" ).datepicker({
	    dateFormat: tbjQuery('#date_format').val(),
	    minDate: new Date(),
	    closeText: "X",
	    showButtonPanel: true,
	    beforeShowDay: function(date) {
		var string = tbjQuery.datepicker.formatDate('yy-mm-dd', date);
		var isDisabled = (disabledDates.indexOf(string) == -1); // used to disable if its an holiday or weekend
		return [isDisabled];
	    },
	    onSelect: function(dateText, inst){
		if(tbjQuery('#date_format').val()=='dd-mm-yy'){
		    var order_date_day = dateText.substring(0, 2);
		    var order_date_month = dateText.substring(3, 5);
		}
		else {
		    var order_date_month = dateText.substring(0, 2);
		    var order_date_day  = dateText.substring(3, 5);
		}
		var order_date_year = dateText.substring(6, 10);
		tbjQuery( "#orderdatereturn" ).datepicker( "option", "minDate", new Date(order_date_year, parseInt(order_date_month)-1, order_date_day) ).val(ORDER_RETURN_DATE_TXT);
	    }
	})
	var hrsDialog;
	tbjQuery('input#selPtHr1').focus(function (e) {
	    tbjQuery('div#hrs-wrapper ul.hrs-list').remove();
	    var min_pickup_hr = tbjQuery('#min_pickup_hr').val();
	    var time_format = tbjQuery('#time_format').val();
	    if(time_format=='12hr'){
		var min = 1;
		var max = 12;
	    }
	    else {
		var min = 0;
		var max = 23;
	    }
	    var list = tbjQuery('<ul class="hrs-list">');
	    for(var i = min; i <= max; i++){
		var value = (i.toString().length<2) ? "0"+i : i;
		list.append(tbjQuery("<li>").html('<input type="button" class="hrs-btn" value="'+value+'" />'));
	    }
	    tbjQuery('div#hrs-wrapper').append(list);
	    hrsDialog = tbjQuery( "#dialog-hrs" ).dialog({
		autoOpen: false,
		height: 300,
		width: 250,
		modal: true,
		buttons: {},
		close: function() {
		    hrsDialog.dialog( "close" );
		}
	    });
	    hrsDialog.dialog( "open" );
	})
	tbjQuery(document).on("click", 'input:button.hrs-btn', function (e) {
	    tbjQuery('input#selPtHr1').val(tbjQuery(this).val());
	    hrsDialog.dialog( "close" );
	})
	var minsDialog;
	tbjQuery('input#selPtMn1').focus(function (e) {
	    tbjQuery('div#mins-wrapper ul.mins-list').remove();
	    var time_format = tbjQuery('#time_format').val();
	    var min = 0;
	    var max = 59;
	    var list = tbjQuery('<ul class="mins-list">');
	    for(var i = min; i <= max; i=i+5){
		var value = (i.toString().length<2) ? "0"+i : i;
		list.append(tbjQuery("<li>").html('<input type="button" class="mins-btn" value="'+value+'" />'));
	    }
	    tbjQuery('div#mins-wrapper').append(list);
	    minsDialog = tbjQuery( "#dialog-mins" ).dialog({
		autoOpen: false,
		height: 300,
		width: 250,
		modal: true,
		buttons: {},
		close: function() {
		    minsDialog.dialog( "close" );
		}
	    });
	    minsDialog.dialog( "open" );
	})
	tbjQuery(document).on("click", 'input:button.mins-btn', function (e) {
	    tbjQuery('input#selPtMn1').val(tbjQuery(this).val());
	    minsDialog.dialog( "close" );
	})
	var returnHrsDialog;
	tbjQuery('input#return_selPtHr2').focus(function (e) {
	    tbjQuery('div#return-hrs-wrapper ul.hrs-list').remove();
	    var min_pickup_hr = tbjQuery('#min_pickup_hr').val();
	    var time_format = tbjQuery('#time_format').val();
	    if(time_format=='12hr'){
		if(tbjQuery.fn.compareDate()) { // return date is greater than pickup date
		    var min = 1;
		}
		else {
		    var min = parseInt(tbjQuery('input#selPtHr1').val())+1;
		}
		var max = 12;
	    }
	    else {
		if(tbjQuery.fn.compareDate()) { // return date is greater than pickup date
		    var min = 0;
		}
		else {
		    var min = parseInt(tbjQuery('input#selPtHr1').val())+1;
		}
		var max = 23;
	    }
	    var list = tbjQuery('<ul class="hrs-list">');
	    for(var i = min; i <= max; i++){
		var value = (i.toString().length<2) ? "0"+i : i;
		list.append(tbjQuery("<li>").html('<input type="button" class="return-hrs-btn" value="'+value+'" />'));
	    }
	    tbjQuery('div#return-hrs-wrapper').append(list);
	    returnHrsDialog = tbjQuery( "#dialog-return-hrs" ).dialog({
		autoOpen: false,
		height: 300,
		width: 250,
		modal: true,
		buttons: {},
		close: function() {
		    returnHrsDialog.dialog( "close" );
		}
	    });
	    returnHrsDialog.dialog( "open" );
	})
	tbjQuery(document).on("click", 'input:button.return-hrs-btn', function (e) {
	    tbjQuery('input#return_selPtHr2').val(tbjQuery(this).val());
	    returnHrsDialog.dialog( "close" );
	})
	var returnMinsDialog;
	tbjQuery('input#return_selPtMn2').focus(function (e) {
	    tbjQuery('div#return-mins-wrapper ul.mins-list').remove();
	    var time_format = tbjQuery('#time_format').val();
	    var min = 0;
	    var max = 59;
	    var list = tbjQuery('<ul class="mins-list">');
	    for(var i = min; i <= max; i=i+5){
		var value = (i.toString().length<2) ? "0"+i : i;
		list.append(tbjQuery("<li>").html('<input type="button" class="return-mins-btn" value="'+value+'" />'));
	    }
	    tbjQuery('div#return-mins-wrapper').append(list);
	    returnMinsDialog = tbjQuery( "#dialog-return-mins" ).dialog({
		autoOpen: false,
		height: 300,
		width: 250,
		modal: true,
		buttons: {},
		close: function() {
		    returnMinsDialog.dialog( "close" );
		}
	    });
	    returnMinsDialog.dialog( "open" );
	})
	tbjQuery(document).on("click", 'input:button.return-mins-btn', function (e) {
	    tbjQuery('input#return_selPtMn2').val(tbjQuery(this).val());
	    returnMinsDialog.dialog( "close" );
	})
    }
    // Inline date functions
    tbjQuery.fn.attachPluginPickupMonth = function(){
	tbjQuery("#pickup_month").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var return_year = parseInt(tbjQuery('#return_year').val());
		var order_date_year = parseInt(tbjQuery('#pickup_year').val());
		tbjQuery.fn.setPickupDate();
		if(return_year > order_date_year){
		    tbjQuery.fn.resetReturnMonth();
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnMonth();
		    tbjQuery.fn.setReturnDay();
		}
	    }
	}).selectbox('attach');
    }
    tbjQuery.fn.attachPluginPickupDay = function(){
	tbjQuery("#pickup_day").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var order_date_month = parseInt(tbjQuery('#pickup_month').val());
		var return_month = parseInt(tbjQuery('#return_month').val());
		tbjQuery.fn.setPickupDate();
		if(return_month > order_date_month){
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnDay();
		}
	    }
	}).selectbox('attach');
    }
    tbjQuery.fn.attachPluginReturnYear = function(){
	tbjQuery("#return_year").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var return_year = parseInt(tbjQuery("#return_year").val());
		var order_date_year = parseInt(tbjQuery('#pickup_year').val());
		if(return_year > order_date_year){
		    tbjQuery.fn.resetReturnMonth();
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnMonth();
		    tbjQuery.fn.setReturnDay();
		}
	    }
	}).selectbox('attach');
    }
    tbjQuery.fn.attachPluginReturnMonth = function(){
	tbjQuery("#return_month").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var return_month = parseInt(tbjQuery("#return_month").val());
		var order_date_month = parseInt(tbjQuery('#pickup_month').val());
		if(return_month > order_date_month){
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnDay();
		}
	    }
	}).selectbox('attach');
    }
    tbjQuery.fn.setReturnYear = function() {
        var pickup_year = tbjQuery('#pickup_year').val();
	tbjQuery('#return_year').selectbox('detach');
        tbjQuery("#return_year option").each(function()
        {
            if(tbjQuery(this).val()<parseInt(pickup_year)){
                tbjQuery(this).attr('disabled', true);
            }
            else {
                tbjQuery(this).attr('disabled', false);
            }
        })
        tbjQuery('#return_year').val(pickup_year);
	tbjQuery.fn.attachPluginReturnYear();
    }
    tbjQuery.fn.setReturnMonth = function() {
        var pickup_month = tbjQuery('#pickup_month').val();
	tbjQuery('#return_month').selectbox('detach');
        tbjQuery("#return_month option").each(function()
        {
            if(tbjQuery(this).val()<parseInt(pickup_month)){
                tbjQuery(this).attr('disabled', true);
            }
            else {
                tbjQuery(this).attr('disabled', false);
            }
        })
        tbjQuery('#return_month').val(pickup_month);
	tbjQuery.fn.attachPluginReturnMonth();
    }
    tbjQuery.fn.resetReturnMonth = function() {
	tbjQuery('#return_month').selectbox('detach');
        tbjQuery("#return_month option").each(function()
        {
            tbjQuery(this).attr('disabled', false);
        })
        tbjQuery('#return_month').val(1);
	tbjQuery.fn.attachPluginReturnMonth();
    }
    tbjQuery.fn.setReturnDay = function() {
        var pickup_day = tbjQuery('#pickup_day').val();
	tbjQuery('#return_day').selectbox('detach');
        tbjQuery("#return_day option").each(function()
        {
            if(tbjQuery(this).val()<parseInt(pickup_day)){
                tbjQuery(this).attr('disabled', true);
            }
            else {
                tbjQuery(this).attr('disabled', false);
            }
        })
        tbjQuery('#return_day').val(pickup_day);
	tbjQuery('#return_day').selectbox({
	    classHolder: "sbHolder dateinline"
	}).selectbox('attach');
    }
    tbjQuery.fn.resetReturnDay = function() {
	tbjQuery('#return_day').selectbox('detach');
        tbjQuery("#return_day option").each(function()
        {
            tbjQuery(this).attr('disabled', false);
        })
        tbjQuery('#return_day').val(1);
	tbjQuery('#return_day').selectbox({
	    classHolder: "sbHolder dateinline"
	}).selectbox('attach');
    }
    tbjQuery.fn.setPickupDate = function() {
	var pickup_year = tbjQuery('#pickup_year').val();
        var pickup_month = tbjQuery('#pickup_month').val();
	var pickup_day = tbjQuery('#pickup_day').val();
	var currentDate = new Date();
        var day = currentDate.getDate();
        var month = currentDate.getMonth();
	var year = currentDate.getFullYear();
	// first detach the selectbox plugin
	tbjQuery('#pickup_month').selectbox('detach');
	tbjQuery('#pickup_day').selectbox('detach');
	if(pickup_year > year){
	    tbjQuery("#pickup_month option").each(function()
	    {
		tbjQuery(this).attr('disabled', false);
	    })
	    tbjQuery("#pickup_day option").each(function()
	    {
		tbjQuery(this).attr('disabled', false);
	    })
	}
	else {
	    tbjQuery("#pickup_month option").each(function()
	    {
		if(tbjQuery(this).val()<(parseInt(month)+1)){
		    tbjQuery(this).attr('disabled', true);
		}
		else {
		    tbjQuery(this).attr('disabled', false);
		}
	    })
	    if(pickup_month > (parseInt(month)+1)){
		tbjQuery("#pickup_day option").each(function()
		{
		    tbjQuery(this).attr('disabled', false);
		})
	    }
	    else {
		tbjQuery("#pickup_day option").each(function()
		{
		    if(tbjQuery(this).val()<day){
			tbjQuery(this).attr('disabled', true);
		    }
		    else {
			tbjQuery(this).attr('disabled', false);
		    }
		})
	    }
	}
	// attach the selectbox plugin again
	tbjQuery.fn.attachPluginPickupMonth();
	tbjQuery.fn.attachPluginPickupDay();
    }
    tbjQuery.fn.setReturnDate = function() {
	var pickup_day = parseInt(tbjQuery('#pickup_day').val());
	var pickup_month = parseInt(tbjQuery('#pickup_month').val());
	var pickup_year = parseInt(tbjQuery('#pickup_year').val());
	var return_day = parseInt(tbjQuery('#return_day').val());
	var return_month = parseInt(tbjQuery('#return_month').val());
	var return_year = parseInt(tbjQuery('#return_year').val());
	tbjQuery('#return_year').selectbox('detach');
	tbjQuery('#return_month').selectbox('detach');
	tbjQuery('#return_day').selectbox('detach');
	tbjQuery("#return_year option").each(function()
	{
	    if(tbjQuery(this).val()<pickup_year){
		tbjQuery(this).attr('disabled', true);
	    }
	    else {
		tbjQuery(this).attr('disabled', false);
	    }
	})
	if(return_year > pickup_year){
	    tbjQuery("#return_month option").each(function()
	    {
		tbjQuery(this).attr('disabled', false);
	    })
	    tbjQuery("#return_day option").each(function()
	    {
		tbjQuery(this).attr('disabled', false);
	    })
	}
	else {
	    tbjQuery("#return_month option").each(function()
	    {
		if(tbjQuery(this).val()<pickup_month){
		    tbjQuery(this).attr('disabled', true);
		}
		else {
		    tbjQuery(this).attr('disabled', false);
		}
	    })
	    if(return_month > pickup_month){
		tbjQuery("#return_day option").each(function()
		{
		    tbjQuery(this).attr('disabled', false);
		})
	    }
	    else {
		tbjQuery("#return_day option").each(function()
		{
		    if(tbjQuery(this).val()<pickup_day){
			tbjQuery(this).attr('disabled', true);
		    }
		    else {
			tbjQuery(this).attr('disabled', false);
		    }
		})
	    }
	}
	tbjQuery.fn.attachPluginReturnYear();
	tbjQuery.fn.attachPluginReturnMonth();
	
	tbjQuery('#return_day').selectbox({
	    classHolder: "sbHolder dateinline"
	}).selectbox('attach');
    }
    tbjQuery.fn.hidePastDays = function(){
        var currentDate = new Date();
        var day = currentDate.getDate();
        var month = currentDate.getMonth();
	tbjQuery('#pickup_month').selectbox('detach');
	tbjQuery('#pickup_day').selectbox('detach');
        tbjQuery("#pickup_day option").each(function()
        {
            if(tbjQuery(this).val()<parseInt(day)){
                tbjQuery(this).attr('disabled', true);
            }
            else {
                tbjQuery(this).attr('disabled', false);
            }
        })
        tbjQuery("#pickup_month option").each(function()
        {
            if(tbjQuery(this).val()<(parseInt(month)+1)){
                tbjQuery(this).attr('disabled', true);
            }
            else {
                tbjQuery(this).attr('disabled', false);
            }
        })
	// attach the selectbox plugin again
	tbjQuery.fn.attachPluginPickupMonth();
	tbjQuery.fn.attachPluginPickupDay();
        if(tbjQuery('#returnjurney').is(':checked'))
        {
            var pickup_day = parseInt(tbjQuery('#pickup_day').val());
            var pickup_month = parseInt(tbjQuery('#pickup_month').val());
	    var pickup_year = parseInt(tbjQuery('#pickup_year').val());
	    var return_day = parseInt(tbjQuery('#return_day').val());
            var return_month = parseInt(tbjQuery('#return_month').val());
	    var return_year = parseInt(tbjQuery('#return_year').val());
	    tbjQuery('#return_year').selectbox('detach');
	    tbjQuery('#return_month').selectbox('detach');
	    tbjQuery('#return_day').selectbox('detach');
	    tbjQuery("#return_year option").each(function()
	    {
		if(tbjQuery(this).val()<pickup_year){
		    tbjQuery(this).attr('disabled', true);
		}
		else {
		    tbjQuery(this).attr('disabled', false);
		}
	    })
	    if(return_year > pickup_year){
		
		tbjQuery("#return_month option").each(function()
		{
		    tbjQuery(this).attr('disabled', false);
		})
		tbjQuery("#return_day option").each(function()
		{
		    tbjQuery(this).attr('disabled', false);
		})
	    }
	    else {
		tbjQuery("#return_month option").each(function()
		{
		    if(tbjQuery(this).val()<pickup_month){
			tbjQuery(this).attr('disabled', true);
		    }
		    else {
			tbjQuery(this).attr('disabled', false);
		    }
		})
		if(return_month > pickup_month){
		    tbjQuery("#return_day option").each(function()
		    {
			tbjQuery(this).attr('disabled', false);
		    })
		}
		else {
		    tbjQuery("#return_day option").each(function()
		    {
			if(tbjQuery(this).val()<pickup_day){
			    tbjQuery(this).attr('disabled', true);
			}
			else {
			    tbjQuery(this).attr('disabled', false);
			}
		    })
		}
	    }
	    tbjQuery.fn.attachPluginReturnYear();
	    tbjQuery.fn.attachPluginReturnMonth();
	    
	    tbjQuery('#return_day').selectbox({
		classHolder: "sbHolder dateinline"
	    }).selectbox('attach');
        }
    }
    
    if(tbjQuery('#datepicker_type').val()=='inline')
    {
	// pickup section
	tbjQuery("#pickup_year").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		tbjQuery.fn.setPickupDate();
		tbjQuery.fn.setReturnYear();
		var pickup_year = parseInt(tbjQuery('#pickup_year').val());
		var currentDate = new Date();
		var day = currentDate.getDate();
		var month = currentDate.getMonth();
		var year = currentDate.getFullYear();
		tbjQuery('#pickup_month').selectbox('detach');
		tbjQuery('#pickup_day').selectbox('detach');
		if(pickup_year > year){
		    tbjQuery('#pickup_day').val(1);
		    tbjQuery('#pickup_month').val(1);
		}
		else {
		    tbjQuery('#pickup_day').val(day);
		    tbjQuery('#pickup_month').val(month+1);
		}
		tbjQuery.fn.attachPluginPickupMonth();
		tbjQuery.fn.attachPluginPickupDay();
	    }
	});
	tbjQuery("#pickup_month").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var return_year = parseInt(tbjQuery('#return_year').val());
		var order_date_year = parseInt(tbjQuery('#pickup_year').val());
		tbjQuery.fn.setPickupDate();
		if(return_year > order_date_year){
		    tbjQuery.fn.resetReturnMonth();
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnMonth();
		    tbjQuery.fn.setReturnDay();
		}
	    }
	});
	tbjQuery("#pickup_day").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var order_date_month = parseInt(tbjQuery('#pickup_month').val());
		var return_month = parseInt(tbjQuery('#return_month').val());
		tbjQuery.fn.setPickupDate();
		if(return_month > order_date_month){
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnDay();
		}
	    }
	});
	// return section
	tbjQuery("#return_year").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		    var return_year = parseInt(tbjQuery("#return_year").val());
		    var order_date_year = parseInt(tbjQuery('#pickup_year').val());
		    tbjQuery.fn.setReturnDate();
	    }
	});
	tbjQuery("#return_month").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		tbjQuery.fn.setReturnDate();
	    }
	});
	// hide all past dates
	tbjQuery.fn.hidePastDays();
    }
    tbjQuery("#return_wait_hr").selectbox({
	classHolder: "sbHolder medium",
	onChange: function (val, inst) {
	    if(val=='-1'){
		tbjQuery('div#return_datepicker_wrapper').show();
	    }
	    else{
		tbjQuery('div#return_datepicker_wrapper').hide();
		tbjQuery('#orderdatereturn').val(ORDER_RETURN_DATE_TXT);
		tbjQuery('#selPtHr2').selectbox('detach').val(HRS_TXT).selectbox('attach');
		tbjQuery('#selPtMn2').selectbox('detach').val(MINS_TXT).selectbox('attach');
		tbjQuery('#return_selPtHr2').val(HRS_TXT);
		tbjQuery('#return_selPtMn2').val(MINS_TXT);
	    }
	}
    });
    tbjQuery('#returnjurney').change(function(){
        if(tbjQuery(this).is(':checked'))
        {
	    if(tbjQuery('#datepicker_type').val()=='jquery')
	    {
		var orderdate = tbjQuery('#orderdate').val();
		if(orderdate=='' || orderdate=="Date")
		{
		    alert('Please select Departing Date first.');
		    tbjQuery(this).attr('checked', false);
		}
		else
		{
		    tbjQuery('div#return_date_wrapper').show();
		    if(tbjQuery('#date_format').val()=='dd-mm-yy'){
			var order_date_day = orderdate.substring(0, 2);
			var order_date_month = orderdate.substring(3, 5);
		    }
		    else {
			var order_date_month = orderdate.substring(0, 2);
			var order_date_day = orderdate.substring(3, 5);
		    }
		    var order_date_year = orderdate.substring(6, 10);
		    tbjQuery( "#orderdatereturn" ).datepicker( "option", "minDate", new Date(order_date_year, parseInt(order_date_month)-1, order_date_day) ).val(ORDER_RETURN_DATE_TXT);
		}
	    }
	    else if(tbjQuery('#datepicker_type').val()=='inline')
	    {
		tbjQuery('div#return_date_wrapper').show();
		
		tbjQuery.fn.setReturnYear();
                tbjQuery.fn.setReturnMonth();
                tbjQuery.fn.setReturnDay();
	    }
	    // collect return pickup and dropoff extras
	    if(tbjQuery('#show_return_extras').val()==1 && (tbjQuery('#booking_type').val()=='address' || tbjQuery('#booking_type').val()=='offers'))
	    {
		tbjQuery.fn.getReturnExtras();
	    }
        }
        else
        {
            tbjQuery('div#return_date_wrapper').hide();
            tbjQuery('#orderdatereturn').val(ORDER_RETURN_DATE_TXT);
	    
            tbjQuery('#selPtHr2').selectbox('detach').val('').selectbox('attach');
	    tbjQuery('#selPtMn2').selectbox('detach').val('').selectbox('attach');
            
	    // clear out the return extras
	    tbjQuery('div#return_extra_wrapper').html('').hide();
	    
            // call vehicle listing again
            tbjQuery.fn.getCars();
        }
    })
    // This function collects extras fir swapped routes
    tbjQuery.fn.compareDate = function() {
        
	if(tbjQuery('#datepicker_type').val()=='jquery')
	{
	    var order_date = tbjQuery('#orderdate').val();
	    var order_return_date = tbjQuery('#orderdatereturn').val();
	    
	    if(tbjQuery('#date_format').val()=='dd-mm-yy'){
		var order_date_day = order_date.substring(0, 2);
		var order_date_month = order_date.substring(3, 5);
	    }
	    else {
		var order_date_month = order_date.substring(0, 2);
		var order_date_day = order_date.substring(3, 5);
	    }
	    var order_date_year = order_date.substring(6, 10);
	    
	    if(tbjQuery('#date_format').val()=='dd-mm-yy'){
		var order_return_date_day = order_return_date.substring(0, 2);
		var order_return_date_month = order_return_date.substring(3, 5);
	    }
	    else {
		var order_return_date_month = order_return_date.substring(0, 2);
		var order_return_date_day = order_return_date.substring(3, 5);
	    }
	    
	    var order_return_date_year = order_return_date.substring(6, 10);
	}
	else if(tbjQuery('#datepicker_type').val()=='inline')
	{
	    var order_date_day = tbjQuery('#pickup_day').val();
	    var order_date_month = tbjQuery('#pickup_month').val();
	    var order_date_year = tbjQuery('#pickup_year').val();
	    
	    var order_return_date_day = tbjQuery('#return_day').val();
	    var order_return_date_month = tbjQuery('#return_month').val();
	    var order_return_date_year = tbjQuery('#return_year').val();
	}
	
        if(order_return_date_year>order_date_year) {
            return true;
        }
        else {
            if(order_return_date_month>order_date_month) {
                return true;
            }
            else {
                if(order_return_date_day>order_date_day) {
                    return true;
                }
                else {
                    return false;
                }
            }
        }
    }
    tbjQuery("#selPtHr2").selectbox({
	onChange: function (val, inst) {
	    if(!tbjQuery.fn.compareDate()) {
		if(tbjQuery('#datepicker_type').val()=='jquery'){
		    if(tbjQuery("#selPtHr1").val() >= tbjQuery("#return_selPtHr2").val()) {
			tbjQuery("#return_selPtHr2").val(HRS_TXT);
			tbjQuery("#return_selPtMn2").val(MINS_TXT);
		    }
		}
		else {
		    if(tbjQuery("#selPtHr1").val() >= tbjQuery("#selPtHr2").val()) {
			tbjQuery("#selPtHr2").val('');
			tbjQuery("#selPtMin2").val('');
		    }
		}
	    }
	}
    });
    tbjQuery('.tborders_login').click(function(){
	if(tbjQuery('input#tborders_username').val()==""){
	    tbjQuery('input#tborders_username').closest('div.top_ver_input_wrap').addClass('incorrect');
	}
	else if(tbjQuery('input#tborders_password').val()==""){
	    tbjQuery('input#tborders_password').closest('div.top_ver_input_wrap').addClass('incorrect');
	}
	else {
	    tbjQuery('input#tborders_username,input#tborders_password').closest('div.top_ver_input_wrap').removeClass('incorrect');
	    tbjQuery.ajax({
		type: "POST",
		url: 'index.php?option=com_taxibooking&task=loginAjax',
		data: tbjQuery('input#tborders_username').serialize()+'&'+tbjQuery('input#tborders_password').serialize(),
		dataType: 'json',
		async: false,
		beforeSend: function(){
		    tbjQuery('.tborders_login').after('<img src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" id="ajax_loader" title="Loader" />');
		},
		complete: function(){
		},
		success: function(response){
		    tbjQuery('#ajax_loader').remove();
		    if(response.error==0){
			window.location.reload();
		    }
		    else {
			alert(response.msg);
			return false;
		    }					    
		}
	    })
	}
    })
    if(parseInt(USER_LOGGED_IN) > 0){
	var orderTableOpt = {	
	    language: {
		processing:'<img src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader-bar.gif" width="128" height="15" alt="Processing..." />',
		search:  MYORDERS_TABLE_SEARCH_LABEL,
		lengthMenu: MYORDERS_TABLE_SHOW_LABEL,
		zeroRecords: MYORDERS_TABLE_ZERO_RECORDS_LABEL,
		info: MYORDERS_TABLE_SHOW_INFO_LABEL,
		infoEmpty: MYORDERS_TABLE_INFO_EMPTY_LABEL,
		infoFiltered: MYORDERS_TABLE_INFO_FILTERED_LABEL,
		paginate: {
		    first:      MYORDERS_TABLE_PAGINATE_START_LABEL,
		    previous:   MYORDERS_TABLE_PAGINATE_PREVIOUS_LABEL,
		    next:       MYORDERS_TABLE_PAGINATE_NEXT_LABEL,
		    last:       MYORDERS_TABLE_PAGINATE_END_LABEL
		}
	    },
	    lengthMenu: [[10, 20, 50, 100, 500, 1000, 2000], [10, 20, 50, 100, 500, 1000, 2000]],
	    iDisplayLength: 10,
	    processing: true,
	    serverSide: true,
	    ajax:{
		url: 'index.php?option=com_taxibooking&task=getOrdersAjax',
		type: 'POST',
		data: function ( d ) {
		    d.search.start_date = tbjQuery('#filter_start_date').val();
		    d.search.end_date = tbjQuery('#filter_end_date').val();
		}
	    },
	    aaSorting: [[0, 'desc']],
	    columnDefs: [
			 { orderable: false, targets: [3,7,9,10,11,12,13] },
			 { searchable: false, targets: [3,5,11,12,13] }
			],
	    fnRowCallback: function( nRow, aData, iDisplayIndex ){
		//console.log(aData[11]);
		if(url_booking_type=='orders'){
		    if(aData[11]==url_order_number){
			//console.log(nRow);
			tbjQuery(nRow).addClass('parent');
			tbjQuery('#orders_table').dataTable().fnOpen(nRow, '', 'details');
		    }
		}
		//tbjQuery(nRow).attr('data-cid', aData[12]);
		//tbjQuery('td:eq(1)', nRow).html('<a href="javascript:void(0);" class="myorders_order_details">'+aData[1]+'</a>');
		return nRow;
	    }
	};
	var oTable = tbjQuery('#orders_table').DataTable(orderTableOpt);
	tbjQuery('#orders_table tbody').on( 'click', 'a.myorders_btn_paynow.stripe', function () {
	    var order_id = tbjQuery(this).data('cid');
	    if (isTouchSupported || isTouchSupportedIE10) {
		// this is a mobile device
		tbjQuery.fancybox({
		    fitToView	: true,
		    autoCenter	: true,
		    autoSize	: false,
		    autoHeight	: false,
		    autoWidth	: false,
		    transitionIn	: 'none',
		    transitionOut	: 'none',
		    type		: 'iframe',
		    href		: BASE_URL+'index.php?option=com_taxibooking&view=payment&cid='+order_id+'&tmpl=component',
		    hideOnOverlayClick	: false,
		    onClosed          : function() {
			//oTable.ajax.reload();
			window.location.reload(true);
		    },
		    helpers: {
			    overlay: {
				    locked: true
			    }
		    }
		});
	    } else {
		// this is desktop device
		tbjQuery.fancybox({
			width		: '100%',
			height		: '100%',
			autoScale	: false,
			transitionIn	: 'none',
			transitionOut	: 'none',
			type		: 'iframe',
			href		: BASE_URL+'index.php?option=com_taxibooking&view=payment&cid='+order_id+'&tmpl=component',
			hideOnOverlayClick	: false,
			onClosed          : function() {
			    //oTable.ajax.reload();
			    window.location.reload(true);
			}
		});
	    }
	})
	tbjQuery('#orders_table tbody').on( 'click', 'a.myorders_order_details', function () {
	    var order_id = tbjQuery(this).data('cid');
	    if (isTouchSupported || isTouchSupportedIE10) {
		// this is a mobile device
		tbjQuery.fancybox({
		    fitToView	: true,
		    autoCenter	: true,
		    autoSize	: false,
		    autoHeight	: false,
		    autoWidth	: false,
		    transitionIn	: 'none',
		    transitionOut	: 'none',
		    type		: 'iframe',
		    href		: BASE_URL+'index.php?option=com_taxibooking&view=order&cid='+order_id+'&layout=modal&tmpl=component',
		    hideOnOverlayClick	: false,
		    onClosed          : function() {
			//oTable.ajax.reload();
			window.location.reload(true);
		    },
		    helpers: {
			    overlay: {
				    locked: true
			    }
		    }
		});
	    } else {
		// this is desktop device
		tbjQuery.fancybox({
			width		: '100%',
			height		: '100%',
			autoScale	: false,
			transitionIn	: 'none',
			transitionOut	: 'none',
			type		: 'iframe',
			href		: BASE_URL+'index.php?option=com_taxibooking&view=order&cid='+order_id+'&layout=modal&tmpl=component',
			hideOnOverlayClick	: false,
			onClosed          : function() {
			    //oTable.ajax.reload();
			    window.location.reload(true);
			}
		});
	    }
	})
	tbjQuery('#orders_table tbody').on( 'click', 'a.myorders_order_cancel', function () {
	    var btnObj = this;
	    var order_id = tbjQuery(btnObj).data('cid');
	    var r = confirm("Are you sure you want to Cancel this Order?");
	    if (r == true) {
		tbjQuery.ajax({
		    type: "POST",
		    url: 'index.php?option=com_taxibooking&task=cancelOrderAjax',
		    data: 'cid='+order_id,
		    dataType: 'json',
		    async: false,
		    beforeSend: function(){
			tbjQuery(btnObj).after('<img src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" id="ajax_loader" title="Loader" />');
		    },
		    complete: function(){
		    },
		    success: function(response){
			tbjQuery('#ajax_loader').remove();
			alert(response.msg);
			if(response.error==0){
			    tbjQuery(btnObj).remove();
			}
			else {
			    alert(response.msg);
			    return false;
			}					    
		    }
		})
	    }
	})
	tbjQuery( "#filter_start_date" ).datepicker({
	    dateFormat: 'yy-mm-dd',
	    closeText: "X",
	    showButtonPanel: true,
	    onSelect: function(dateText, inst){
		oTable.ajax.reload();
	    }
	})
	tbjQuery('a#filter_start_date_clear').click(function(){
	    tbjQuery( "#filter_start_date" ).datepicker( "setDate", "" );
	    oTable.ajax.reload();
	})
	tbjQuery( "#filter_end_date" ).datepicker({
	    dateFormat: 'yy-mm-dd',
	    closeText: "X",
	    showButtonPanel: true,
	    onSelect: function(dateText, inst){
		oTable.ajax.reload();
	    }
	})
	tbjQuery('a#filter_end_date_clear').click(function(){
	    tbjQuery( "#filter_end_date" ).datepicker( "setDate", "" );
	    oTable.ajax.reload();
	})
	tbjQuery('#orders_table tbody').on( 'click', 'a.invoice_download_trigger', function () {
	    var cid = tbjQuery(this).data('cid');
	    var formHtml = '<form action="'+BASE_URL+'index.php?option=com_taxibooking&task=pdf_invoice" method="POST" id="exportForm" name="exportForm" target="blank">';
	    formHtml += '<input type="hidden" name="cid" value="'+cid+'" />';
	    formHtml += '</form>';
	    jQuery('body').append(formHtml);
	    var exportForm = jQuery("#exportForm");
	    exportForm.submit();
	    exportForm.remove();
	})
	// corporate invoices fetch
	if(parseInt(USER_IS_CORPORATE_CLIENT)==1){
	    var invoiceTableOpt = {	
		language: {
		    processing:'<img src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader-bar.gif" width="128" height="15" alt="Processing..." />',
		    search:  MYORDERS_TABLE_SEARCH_LABEL,
		    lengthMenu: MYORDERS_TABLE_SHOW_LABEL,
		    zeroRecords: MYORDERS_TABLE_ZERO_RECORDS_LABEL,
		    info: MYORDERS_TABLE_SHOW_INFO_LABEL,
		    infoEmpty: MYORDERS_TABLE_INFO_EMPTY_LABEL,
		    infoFiltered: MYORDERS_TABLE_INFO_FILTERED_LABEL,
		    paginate: {
			first:      MYORDERS_TABLE_PAGINATE_START_LABEL,
			previous:   MYORDERS_TABLE_PAGINATE_PREVIOUS_LABEL,
			next:       MYORDERS_TABLE_PAGINATE_NEXT_LABEL,
			last:       MYORDERS_TABLE_PAGINATE_END_LABEL
		    }
		},
		lengthMenu: [[10, 20, 50, 100, 500, 1000, 2000], [10, 20, 50, 100, 500, 1000, 2000]],
		iDisplayLength: 10,
		processing: true,
		serverSide: true,
		ajax:{
		    url: 'index.php?option=com_taxibooking&task=getCorporateInvoicesAjax',
		    type: 'POST',
		    data: function ( d ) {
			//d.search.start_date = tbjQuery('#filter_start_date').val();
			//d.search.end_date = tbjQuery('#filter_end_date').val();
		    }
		},
		aaSorting: [[10, 'asc']],
		columnDefs: [
			     { orderable: true, targets: [10] },
			     { searchable: true, targets: [2] }
			    ],
		fnRowCallback: function( nRow, aData, iDisplayIndex ){
		    //tbjQuery(nRow).attr('data-cid', aData[12]);
		    //tbjQuery('td:eq(1)', nRow).html('<a href="javascript:void(0);" class="myorders_order_details">'+aData[1]+'</a>');
		    return nRow;
		}
	    };
	    var invoiceTable = tbjQuery('#invoices_table').DataTable(invoiceTableOpt);
	    tbjQuery('#invoices_table tbody').on( 'click', 'a.myorders_order_details', function () {
		var cid = tbjQuery(this).data('cid');
		if (isTouchSupported || isTouchSupportedIE10) {
		    // this is a mobile device
		    tbjQuery.fancybox({
			fitToView	: true,
			autoCenter	: true,
			autoSize	: false,
			autoHeight	: false,
			autoWidth	: false,
			transitionIn	: 'none',
			transitionOut	: 'none',
			type		: 'iframe',
			href		: BASE_URL+'index.php?option=com_tbcorporate&view=invoice&id='+cid+'&layout=modal&tmpl=component&print=1',
			hideOnOverlayClick	: false,
			onClosed          : function() {
			    invoiceTable.ajax.reload();
			},
			helpers: {
				overlay: {
					locked: true
				}
			}
		    });
		} else {
		    // this is desktop device
		    tbjQuery.fancybox({
			    width		: '100%',
			    height		: '100%',
			    autoScale	: false,
			    transitionIn	: 'none',
			    transitionOut	: 'none',
			    type		: 'iframe',
			    href		: BASE_URL+'index.php?option=com_tbcorporate&view=invoice&id='+cid+'&layout=modal&tmpl=component&print=1',
			    hideOnOverlayClick	: false,
			    onClosed          : function() {
				invoiceTable.ajax.reload();
			    }
		    });
		}
	    })
	}
	tbjQuery.fn.getUserAddressesAjax = function(postData) {
	    tbjQuery.ajax({
		type: "POST",
		url: 'index.php?option=com_taxibooking&task=getUserAddressesAjax',
		data: postData,
		dataType: 'json',
		//async: false,
		beforeSend: function(){
		    //tbjQuery('.tborders_login').after('<img src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" id="ajax_loader" title="Loader" />');
		},
		complete: function(){
		},
		success: function(response){
		    if(response.error==0){
			tbjQuery('div.address_table').html(response.msg);
		    }
		    else {
			alert(response.msg);
			return false;
		    }					    
		}
	    })
	}
	if((tbConfig.show_address_tab==1)){
	    tbjQuery.fn.getUserAddressesAjax('action=list');
	}
	tbjQuery('.tborders_address_submit_btn').click(function(){
	    if(tbjQuery('#new_address_title').val()==""){
		tbjQuery('#new_address_title').addClass('incorrect');
	    }
	    else if(tbjQuery('#new_address_username').val()==""){
		tbjQuery('#new_address_username').addClass('incorrect');
	    }
	    else if(tbjQuery('#new_address_lat').val()==""){
		tbjQuery('#new_address_lat').addClass('incorrect');
	    }
	    else if(tbjQuery('#new_address_lng').val()==""){
		tbjQuery('#new_address_lng').addClass('incorrect');
	    }
	    else {
		tbjQuery('#new_address_title,#new_address_username,#new_address_lat,#new_address_lng').removeClass('incorrect');
		var address_id = tbjQuery('#new_address_id').val();
		if(parseInt(address_id) > 0){
		    tbjQuery.fn.getUserAddressesAjax('action=update&'+tbjQuery('#myorders_new_address_form input').serialize());
		}
		else {
		    tbjQuery.fn.getUserAddressesAjax('action=add&'+tbjQuery('#myorders_new_address_form input').serialize());
		}
		tbjQuery.fancybox.close();
	    }
	})
	tbjQuery('div.address_table').on( 'click', 'a.tborders_address_edit', function () {
	    var address_id = tbjQuery(this).closest('tr').data('cid');
	    tbjQuery.ajax({
		type: "POST",
		url: 'index.php?option=com_taxibooking&task=getAddressDetailsAjax',
		data: 'address_id='+address_id,
		dataType: 'json',
		async: false,
		beforeSend: function(){
		    //tbjQuery('.tborders_login').after('<img src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" id="ajax_loader" title="Loader" />');
		},
		complete: function(){
		},
		success: function(response){
		    //tbjQuery('#ajax_loader').remove();
		    if(response.error==0){
			tbjQuery('#new_address_id').val(response.msg.id);
			tbjQuery('#new_address_title').val(response.msg.title);
			tbjQuery('#new_address_username').val(response.msg.user_name);
			tbjQuery('#new_address_organization').val(response.msg.organization);
			tbjQuery('#new_address_lat').val(response.msg.lat);
			tbjQuery('#new_address_lng').val(response.msg.lng);
			
			if (isTouchSupported || isTouchSupportedIE10) {
				// this is a mobile device
				tbjQuery("a#myorders_new_address_trigger").fancybox({
					maxWidth	: 800,
					maxHeight	: 600,
					fitToView	: true,
					autoCenter	: true,
					autoSize	: false,
					autoHeight	: false,
					autoWidth	: false,
					scrolling	: 'auto',
					closeClick	: false,
					openEffect	: 'none',
					closeEffect	: 'none',
					onClosed	: function(){
					    tbjQuery('#myorders_new_address_form input').not(':input[type=button], :input[type=submit], :input[type=reset]').val("");
					},
					helpers: {
						overlay: {
							locked: true
						}
					}
				}).trigger('click');
			} else {
				// this is desktop device
				tbjQuery("a#myorders_new_address_trigger").fancybox({
					maxWidth	: 800,
					maxHeight	: 600,
					fitToView	: true,
					autoSize	: false,
					height	: '50%',
					width	: '40%',
					scrolling	: 'auto',
					closeClick	: false,
					openEffect	: 'none',
					closeEffect	: 'none',
					onClosed	: function(){
					    tbjQuery('#myorders_new_address_form input').not(':input[type=button], :input[type=submit], :input[type=reset]').val("");
					}
				}).trigger('click');
			}
		    }					    
		}
	    })
	})
	tbjQuery('div.address_table').on( 'click', 'a.tborders_address_delete', function () {
	    var address_id = tbjQuery(this).closest('tr').data('cid');
	    var r = confirm("Are you sure?");
	    if (r == true) {
		tbjQuery.fn.getUserAddressesAjax('action=delete&address_id='+address_id);
	    }
	})
	tbjQuery('div#tabs_address').on( 'click', 'a.select_addressbook', function(){
	    if(tbjQuery(this).hasClass('pickup')){
		var section = 'pickup';
	    }
	    else if(tbjQuery(this).hasClass('dropoff')){
		var section = 'dropoff';
	    }
	    else if(tbjQuery(this).hasClass('stops')){
		tbjQuery(this).closest('div.stops_wrap').addClass('addressbook-active');
		var section = 'stops';
	    }
	    if (isTouchSupported || isTouchSupportedIE10) {
		// this is a mobile device
		tbjQuery.fancybox({
		    fitToView	: true,
		    autoCenter	: true,
		    autoSize	: false,
		    autoHeight	: false,
		    autoWidth	: false,
		    transitionIn	: 'none',
		    transitionOut	: 'none',
		    type		: 'iframe',
		    href		: BASE_URL+'index.php?option=com_taxibooking&view=addresses&layout=modal&tmpl=component&section='+section,
		    hideOnOverlayClick	: false,
		    onClosed          : function() {
			tbjQuery('div.stops_wrap').removeClass('addressbook-active');
		    },
		    helpers: {
			    overlay: {
				    locked: true
			    }
		    }
		});
	    } else {
		// this is desktop device
		tbjQuery.fancybox({
			width		: '100%',
			height		: '100%',
			autoScale	: false,
			transitionIn	: 'none',
			transitionOut	: 'none',
			type		: 'iframe',
			href		: BASE_URL+'index.php?option=com_taxibooking&view=addresses&layout=modal&tmpl=component&section='+section,
			hideOnOverlayClick	: false,
			onClosed          : function() {
			    tbjQuery('div.stops_wrap').removeClass('addressbook-active');
			}
		});
	    }
	})
    }
    if (isTouchSupported || isTouchSupportedIE10) {
	    // this is a mobile device
	    tbjQuery("a#myorders_new_address_trigger").fancybox({
		    maxWidth	: 800,
		    maxHeight	: 600,
		    fitToView	: true,
		    autoCenter	: true,
		    autoSize	: false,
		    autoHeight	: false,
		    autoWidth	: false,
		    scrolling	: 'auto',
		    closeClick	: false,
		    openEffect	: 'none',
		    closeEffect	: 'none',
		    onClosed	: function(){
			tbjQuery('#myorders_new_address_form input').not(':input[type=button], :input[type=submit], :input[type=reset]').val("");
		    },
		    helpers: {
			    overlay: {
				    locked: true
			    }
		    }
	    });
    } else {
	    // this is desktop device
	    // run init for desktops here
	    tbjQuery("a#myorders_new_address_trigger").fancybox({
		    maxWidth	: 800,
		    maxHeight	: 600,
		    fitToView	: true,
		    autoSize	: false,
		    height	: '50%',
		    width	: '40%',
		    scrolling	: 'auto',
		    closeClick	: false,
		    openEffect	: 'none',
		    closeEffect	: 'none',
		    onClosed	: function(){
			tbjQuery('#myorders_new_address_form input').not(':input[type=button], :input[type=submit], :input[type=reset]').val("");
		    }
	    });
    }
    tbjQuery('a#change_photo_trigger').click(function(){
	tbjQuery('span#upload-button').show();
    })
    tbjQuery('.saveimage').click(function(){
	// if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
	xhr = tbjQuery.ajax({
	    type: "POST",
	    url: 'index.php?option=com_taxibooking&task=saveProfilePictureAjax',
	    data: tbjQuery('div#photoPreviewWrap input').serialize(),
	    dataType: 'json',
	    async: false,
	    beforeSend: function(){
		tbjQuery('.saveimage').after('<img src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" id="loader" />');
	    },
	    complete: function(){
	    },
	    success: function(response){
		tbjQuery('#loader').remove();
		if(response.error==0){
		    window.location.reload(true);
		}
	    }
	})
    })
    tbjQuery('div.profile-title').click(function(){
	tbjQuery(this).hide();
	tbjQuery('div.profile-title-edit').show();
    })
    tbjQuery('div.profile-phone').click(function(){
	tbjQuery(this).hide();
	tbjQuery('div.profile-phone-edit').show();
    })
    tbjQuery('div.profile-title-wrap a.save_profile_trigger').click(function(){
	// if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
	var btnObj = tbjQuery(this);
	var field_value = tbjQuery(btnObj).parent().parent().find('input').val();
	if(field_value!=""){
	    xhr = tbjQuery.ajax({
		type: "POST",
		url: 'index.php?option=com_taxibooking&task=updateProfileAjax',
		data: tbjQuery(btnObj).parent().parent().find('input').serialize(),
		dataType: 'json',
		async: false,
		beforeSend: function(){
		},
		complete: function(){
		},
		success: function(response){
		    if(response.error==0){
			tbjQuery(btnObj).parent().parent().find('input').val(response.msg);
			tbjQuery(btnObj).parent().parent().prev('div').html(response.msg).show();
			tbjQuery(btnObj).parent().parent().hide();
		    }
		}
	    })
	}
    })
    tbjQuery('div.profile-title-wrap a.cancel_edit_trigger').click(function(){
	tbjQuery(this).parent().parent().hide();
	tbjQuery(this).parent().parent().prev('div').show();
    })
    tbjQuery( '.cancel_booking_tooltip' ).tooltip({
	track: true
    });
    tbjQuery('.cancel_booking_btn').click(function(){
	var btnObj = this;
	var order_number = tbjQuery('#cancel_cid').val();
	if(order_number!=""){
	    var r = confirm("Are you sure you want to Cancel this Order?");
	    if (r == true) {
		tbjQuery.ajax({
		    type: "POST",
		    url: 'index.php?option=com_taxibooking&task=cancelOrderAjax',
		    data: 'code='+order_number,
		    dataType: 'json',
		    async: false,
		    beforeSend: function(){
			tbjQuery(btnObj).after('<img src="'+BASE_URL+'components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" id="ajax_loader" title="Loader" />');
		    },
		    complete: function(){
		    },
		    success: function(response){
			tbjQuery('#ajax_loader').remove();
			tbjQuery('#cancel_cid').val("");
			alert(response.msg);
			return false;			    
		    }
		})
	    }
	}
    })
})

/*jslint unparam: true */
/*global window, $ */
tbjQuery(function () {
    'use strict';
    // Change this to the location of your server-side upload handler:
    var url = BASE_URL+ 'components/com_taxibooking/upload.php';
    
    // Create variables (in this scope) to hold the API and image size
    var jcrop_api,
    boundx,
    boundy,

    // Grab some information about the preview pane
    $preview = tbjQuery('#preview-pane'),
    $pcnt = tbjQuery('#preview-pane .preview-container'),
    $pimg = tbjQuery('#preview-pane .preview-container img'),

    xsize = $pcnt.width(),
    ysize = $pcnt.height();
    
    tbjQuery('#fileupload').fileupload({
        url: url,
        dataType: 'json',
        autoUpload: true,
        acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
        maxFileSize: 2000000, // 2 MB
        // Enable image resizing, except for Android and Opera,
        // which actually support image resizing, but fail to
        // send Blob objects via XHR requests:
        //disableImageResize: /Android(?!.*Chrome)|Opera/
            //.test(window.navigator.userAgent),
        //previewMaxWidth: 150,
        //previewMaxHeight: 150,
        //previewCrop: true,
	formData: [
	    {
		name: 'userid',
		value: 'user_'+USER_LOGGED_IN
	    }
	]
    }).on('fileuploadadd', function (e, data) {
        tbjQuery('div#progress').show();
	if (typeof jcrop_api !== 'undefined') {
		jcrop_api.destroy();
	}
	data.context = tbjQuery('<div/>').appendTo('#files');
	tbjQuery.each(data.files, function (index, file) {
	    var node = tbjQuery('<p/>');
	    /*if (!index) {
		node
		    .append('<br>')
		    .append(uploadButton.clone(true).data(data));
	    }*/
	    node.appendTo(data.context);
	});
    }).on('fileuploadprocessalways', function (e, data) {
        var index = data.index,
	    file = data.files[index],
	    node = tbjQuery(data.context.children()[index]);
	/*if (file.preview) {
	    node
		.prepend('<br>')
		.prepend(file.preview);
	}*/
	if (file.error) {
	    tbjQuery('div#files').html(tbjQuery('<span class="text-danger"/>').text(file.error));
	}
	/*if (index + 1 === data.files.length) {
	    data.context.find('button')
		.text('Upload')
		.prop('disabled', !!data.files.error);
	}*/
    }).on('fileuploadprogressall', function (e, data) {
        var progress = parseInt(data.loaded / data.total * 100, 10);
        tbjQuery('#progress .progress-bar').css(
            'width',
            progress + '%'
        );
    }).on('fileuploaddone', function (e, data) {
	tbjQuery('div#photoPreviewWrap, div#preview-pane, div#save_image_wrap').show();
	var file = data.result.files[0];
        //tbjQuery.each(data.result.files, function (index, file) {
            if (file.url) {
		tbjQuery('#new_photo').val(file.name);
		tbjQuery("#crop-target").attr("src",file.mediumUrl+"?d="+ (new Date()).getTime()  );
		$pimg.attr("src",file.mediumUrl+"?d="+ (new Date()).getTime());
		tbjQuery('.jcrop-holder img').attr('src', file.mediumUrl+"?d="+ (new Date()).getTime() );
		tbjQuery('#is_logo_changed').val(1);
		tbjQuery( "#preview-pane" ).draggable({
			cursor: "move"
		});
		
		setTimeout(function() {
		    initJcrop();
		    tbjQuery('span#reupload-button').show();
		    tbjQuery('span#upload-button').hide();
		    
		    function initJcrop()
		    {
			//var oImage = new Image();
			//oImage.src = tbjQuery("#crop-target").attr("src");
			//console.log('width: ' + oImage.naturalWidth + ' and height: ' + oImage.naturalHeight);

			tbjQuery('#crop-target').Jcrop({
				onChange: updatePreview,
				onSelect: updatePreview,
				aspectRatio: xsize / ysize,
				setSelect: [ 0, 0, 300, 300 ],
				minSize: [ 100, 100 ]
			},function(){
				// Use the API to get the real image size
				var bounds = this.getBounds();
				boundx = bounds[0];
				boundy = bounds[1];
				console.log('boundx: ' + boundx + ' and boundy: ' + boundy);
				
				// Store the API in the jcrop_api variable
				jcrop_api = this;
				
				// Sets a random selection
				jcrop_api.animateTo([0, 0, 300, 300]);
				jcrop_api.setImage(file.mediumUrl+"?d="+ (new Date()).getTime());
			  
				// Move the preview into the jcrop container for css positioning
				$preview.appendTo(jcrop_api.ui.holder);
				$pimg.removeAttr( 'style' );
				tbjQuery( ".jcrop-preview" ).css( "max-width", "none" );
			});
		    };
		    function updatePreview(c)
		    {
			if (parseInt(c.w) > 0)
			{
			    var rx = xsize / c.w;
			    var ry = ysize / c.h;
			    
			    tbjQuery('#x1').val(c.x);
			    tbjQuery('#y1').val(c.y);
			    tbjQuery('#x2').val(c.x2);
			    tbjQuery('#y2').val(c.y2);
			    tbjQuery('#w').val(c.w);
			    tbjQuery('#h').val(c.h);
		    
			    $pimg.css({
				    width: Math.round(rx * boundx) + 'px',
				    height: Math.round(ry * boundy) + 'px',
				    marginLeft: '-' + Math.round(rx * c.x) + 'px',
				    marginTop: '-' + Math.round(ry * c.y) + 'px'
			    });
			}
		    };
		}, 100);
		
                /*var link = $('<a>')
                    .attr('target', '_blank')
                    .prop('href', file.url);
                $(data.context.children()[index])
                    .wrap(link);*/
            } else if (file.error) {
                var error = tbjQuery('<span class="text-danger"/>').text(file.error);
                tbjQuery(data.context.children()[index])
                    .append('<br>')
                    .append(error);
            }
        //});
	
    }).on('fileuploadfail', function (e, data) {
        /*$.each(data.files, function (index) {
            var error = $('<span class="text-danger"/>').text('File upload failed.');
            $(data.context.children()[index])
                .append('<br>')
                .append(error);
        });*/
    }).prop('disabled', !tbjQuery.support.fileInput)
        .parent().addClass(tbjQuery.support.fileInput ? undefined : 'disabled');
	
});

function get_user_location(scope, obj)
{
    areaOfOperation = new google.maps.Polygon({
	paths: triangleCoords
    });
    var geocoder = new google.maps.Geocoder();
    if(scope=='pickup'){
	if(navigator.geolocation) {
	    navigator.geolocation.getCurrentPosition(function(position) {
		if( tbConfig.pickup_in_area_operation==1 || tbConfig.pickup_dropoff_in_area_operation==1) {
		    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(position.coords.latitude,position.coords.longitude), areaOfOperation)) {
			showAreaOperationPopup();
			return false;
		    }
		}
		tbjQuery('#address_from_lat').val(position.coords.latitude);
		tbjQuery('#address_from_lng').val(position.coords.longitude);
		tbjQuery.fn.unsetRoute();
		tbjQuery.fn.unsetHourlyHire();
		// set booking type
		tbjQuery('div#pickup_extra_wrapper').html('');
		tbjQuery('#booking_type').val('address');
		tbjQuery("#address_from").removeClass('incorrect');
		// regenerate return route with extra if Return Journey is selected
		if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
		    tbjQuery.fn.getReturnExtras();
		}
		tbjQuery.fn.getExtras('address_pickup');
		var latlng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
		geocoder.geocode({'latLng': latlng}, function(results, status) {
		    if (status == google.maps.GeocoderStatus.OK) {
			if (results[0]) {
			    tbjQuery('#address_from').val(results[0].formatted_address);
			} else {
			    alert('We could not detect your location');
			}
		    } else {
			alert('Geocoder failed due to: ' + status);
		    }
		});
	    }, function() {
	    });
	}
    }
    if(scope=='dropoff'){
	if(navigator.geolocation) {
	    navigator.geolocation.getCurrentPosition(function(position) {
		if( tbConfig.dropoff_in_area_operation==1 || tbConfig.pickup_dropoff_in_area_operation==1) {
		    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(position.coords.latitude,position.coords.longitude), areaOfOperation)) {
			showAreaOperationPopup();
			return false;
		    }
		}
		tbjQuery('#address_to_lat').val(position.coords.latitude);
		tbjQuery('#address_to_lng').val(position.coords.longitude);
		tbjQuery.fn.unsetRoute();
		tbjQuery.fn.unsetHourlyHire();
		// set booking type
		tbjQuery('div#dropoff_extra_wrapper').html('');
		tbjQuery('#booking_type').val('address');
		tbjQuery("#address_to").removeClass('incorrect');
		// regenerate return route with extra if Return Journey is selected
		if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
		    tbjQuery.fn.getReturnExtras();
		}
		tbjQuery.fn.getExtras('address_dropoff');
		var latlng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
		geocoder.geocode({'latLng': latlng}, function(results, status) {
		    if (status == google.maps.GeocoderStatus.OK) {
			if (results[0]) {
			    tbjQuery('#address_to').val(results[0].formatted_address);
			} else {
			    alert('We could not detect your location');
			}
		    } else {
			alert('Geocoder failed due to: ' + status);
		    }
		});
	    }, function() {
	    });
	}
    }
    if(scope=='waypoints'){
	var stop_parent = tbjQuery(obj).closest('div.stops_wrap');
	if(navigator.geolocation) {
	    navigator.geolocation.getCurrentPosition(function(position) {
		tbjQuery(stop_parent).find('#waypoint_lat').val(position.coords.latitude);
		tbjQuery(stop_parent).find('#waypoint_lng').val(position.coords.longitude);
		tbjQuery.fn.unsetRoute();
		tbjQuery.fn.unsetHourlyHire();
		tbjQuery('#booking_type').val('address');
		var latlng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
		geocoder.geocode({'latLng': latlng}, function(results, status) {
		    if (status == google.maps.GeocoderStatus.OK) {
			if (results[0]) {
			    tbjQuery(stop_parent).find('.waypoints').val(results[0].formatted_address);
			} else {
			    alert('We could not detect your location');
			}
		    } else {
			alert('Geocoder failed due to: ' + status);
		    }
		});
	    }, function() {
	    });
	}
    }
}
function check_user_details_fields(err)
{
    tbjQuery('#user_form .extra.required').each(function(){
	if(tbjQuery(this).val().length == 0)
	{
	    err = err+1;
	    tbjQuery(this).addClass('incorrect');
	    tbjQuery(this).next('span.error').remove();
	    tbjQuery(this).after('<span class="error">'+ERR_MESSAGE_FIELD_REQUIRED+'</span>');
	}
	else if(tbjQuery(this).hasClass('numeric') && !tbjQuery.isNumeric(tbjQuery(this).val()))
	{
	    err = err+1;
	    tbjQuery(this).addClass('incorrect');
	    tbjQuery(this).next('span.error').remove();
	    tbjQuery(this).after('<span class="error">'+ERR_MESSAGE_FIELD_REQUIRED+'</span>');
	}
	else {
	    tbjQuery(this).removeClass('incorrect');
	    tbjQuery(this).next('span.error').remove();
	}
    })
    return err;
}
function check_order_copy_fields(err)
{
    tbjQuery('#ordercopy_wrap .required').each(function(){
	if(tbjQuery(this).val().length == 0)
	{
	    err = err+1;
	    tbjQuery(this).addClass('incorrect');
	    tbjQuery(this).next('span.error').remove();
	    tbjQuery(this).after('<span class="error">'+ERR_MESSAGE_FIELD_REQUIRED+'</span>');
	}
	else if(tbjQuery(this).hasClass('email') && !tbjQuery.fn.isValidEmailAddress(tbjQuery(this).val()))
	{
	    err = err+1;
	    tbjQuery(this).addClass('incorrect');
	    tbjQuery(this).next('span.error').remove();
	    tbjQuery(this).after('<span class="error">'+ERR_MESSAGE_VALID_EMAIL+'</span>');
	}
	else if(tbjQuery(this).hasClass('numeric') && !tbjQuery.isNumeric(tbjQuery(this).val()))
	{
	    err = err+1;
	    tbjQuery(this).addClass('incorrect');
	    tbjQuery(this).next('span.error').remove();
	    tbjQuery(this).after('<span class="error">'+ERR_MESSAGE_FIELD_REQUIRED+'</span>');
	}
	else {
	    tbjQuery(this).removeClass('incorrect');
	    tbjQuery(this).next('span.error').remove();
	}
    })
    return err;
}
function selectAddress(address_id, address_title, address_lat, address_lng, section){
    tbjQuery.fn.unsetPoiAddress();
    if(section=='pickup'){
	tbjQuery('#address_from').val(address_title);
	tbjQuery('#address_from_lat').val(address_lat);
	tbjQuery('#address_from_lng').val(address_lng);
    }
    else if(section=='dropoff'){
	tbjQuery('#address_to').val(address_title);
	tbjQuery('#address_to_lat').val(address_lat);
	tbjQuery('#address_to_lng').val(address_lng);
    }
    else if(section=='stops'){
	tbjQuery('div.stops_wrap.addressbook-active .waypoints').val(address_title);
	tbjQuery('div.stops_wrap.addressbook-active #waypoint_lat').val(address_lat);
	tbjQuery('div.stops_wrap.addressbook-active #waypoint_lng').val(address_lng);
	tbjQuery('div.stops_wrap').removeClass('addressbook-active');
    }
    tbjQuery.fancybox.close();
}
function showAreaOperationPopup(){
    if (isTouchSupported || isTouchSupportedIE10) {
	// this is a mobile device
	tbjQuery.fancybox({
	    fitToView	: true,
	    autoCenter	: true,
	    autoSize	: false,
	    autoHeight	: false,
	    autoWidth	: false,
	    transitionIn	: 'none',
	    transitionOut	: 'none',
	    type		: 'iframe',
	    href		: BASE_URL+'index.php?option=com_taxibooking&view=taxibooking&layout=areaoperation&tmpl=component',
	    hideOnOverlayClick	: false,
	    helpers: {
		    overlay: {
			    locked: true
		    }
	    }
	});
    } else {
	// this is desktop device
	tbjQuery.fancybox({
		width		: '100%',
		height		: '80%',
		autoScale	: false,
		transitionIn	: 'none',
		transitionOut	: 'none',
		type		: 'iframe',
		href		: BASE_URL+'index.php?option=com_taxibooking&view=taxibooking&layout=areaoperation&tmpl=component',
		hideOnOverlayClick	: false
	});
    }
}