tbjQuery(document).ready(function(){
    var default_tab = 0;
    tbjQuery('div#verticle_booking_wrap ul.tab_wrapper li a').each(function(index){
	if(tbjQuery(this).attr('id')==url_booking_type){
	    default_tab = index;
	}
    })
    tbjQuery( "#verticle_booking_wrap" ).tabs( "option", "active", default_tab );
    if(url_booking_type=='address')
    {
	if(pickup_type=='address'){
	    tbjQuery('#address_from').val(pickup_address);
	    tbjQuery('#address_from_lat').val(pickup_lat);
	    tbjQuery('#address_from_lng').val(pickup_lng);
	    if(pickup_address!=""){
		tbjQuery.fn.getExtras('address_pickup');
	    }	    
	}
	else {
	    tbjQuery.ajax({
		type: "POST",
		url: BASE_URL+'index.php?option=com_taxibooking&task=getPOIDetailsAjax',
		data: 'poiid='+pickup_poi,
		dataType: 'json',
		//async: false,
		beforeSend: function(){
		},
		complete: function(){
		    if(pickup_poi!=0){
			tbjQuery.fn.getExtras('pickup', pickup_poi);
		    }
		},
		success: function(response){
		    if(response.error==0){
			tbjQuery('#address_from').val(response.poi.title);
			tbjQuery('#address_from_lat').val(response.poi.lat);
			tbjQuery('#address_from_lng').val(response.poi.long);
		    }
		}
	    });
	}
	if(dropoff_type=='address'){
	    tbjQuery('#address_to').val(dropoff_address);
	    tbjQuery('#address_to_lat').val(dropoff_lat);
	    tbjQuery('#address_to_lng').val(dropoff_lng);
	    if(dropoff_address!=""){
		tbjQuery.fn.getExtras('address_dropoff');
	    }
	}
	else {
	    tbjQuery.ajax({
		type: "POST",
		url: BASE_URL+'index.php?option=com_taxibooking&task=getPOIDetailsAjax',
		data: 'poiid='+dropoff_poi,
		dataType: 'json',
		//async: false,
		beforeSend: function(){
		},
		complete: function(){
		    if(dropoff_poi!=0){
			tbjQuery.fn.getExtras('dropoff', dropoff_poi);
			tbjQuery.fn.getReturnExtras();
		    }
		},
		success: function(response){
		    if(response.error==0){
			tbjQuery('#address_to').val(response.poi.title);
			tbjQuery('#address_to_lat').val(response.poi.lat);
			tbjQuery('#address_to_lng').val(response.poi.long);
		    }
		}
	    });
	}
    }
    else if (url_booking_type=='offers')
    {
	if(tbjQuery('#show_poi_categories').val()==1)
	{
	    tbjQuery.ajax({
		type: "POST",
		url: BASE_URL+'index.php?option=com_taxibooking&task=getPOICategoryDetailsAjax',
		data: 'cid='+route_pickup_category,
		dataType: 'json',
		//async: false,
		beforeSend: function(){
		},
		complete: function(){
		},
		success: function(response){
		    if(response.error==0){
			tbjQuery('#route_category').val(response.catObj.id);
			tbjQuery('#route_category_fld').val(response.catObj.title);
		    }
		}
	    });
	}
	tbjQuery.ajax({
	    type: "POST",
	    url: BASE_URL+'index.php?option=com_taxibooking&task=getPOIDetailsAjax',
	    data: 'poiid='+route_pickup_poi,
	    dataType: 'json',
	    //async: false,
	    beforeSend: function(){
		tbjQuery('div.routes_wrapper_from div.routes_from_inner').show();
	    },
	    complete: function(){
		if(route_pickup_poi!=0){
		    tbjQuery.fn.getExtras('route_pickup');
		}
		// if show_route_category enabled, collect dropoff route category
		if(tbjQuery('#show_poi_categories').val()==1)
		{
		    tbjQuery.fn.collectDropoffRouteCategory();
		    tbjQuery.ajax({
			type: "POST",
			url: BASE_URL+'index.php?option=com_taxibooking&task=getPOICategoryDetailsAjax',
			data: 'cid='+route_dropoff_category,
			dataType: 'json',
			//async: false,
			beforeSend: function(){
			},
			complete: function(){
			    if(route_pickup_poi!=0){
				tbjQuery.fn.collectRouteTo();
			    }
			    if(route_dropoff_poi!=0){
				tbjQuery.ajax({
				    type: "POST",
				    url: BASE_URL+'index.php?option=com_taxibooking&task=getPOIDetailsAjax',
				    data: 'poiid='+route_dropoff_poi,
				    dataType: 'json',
				    //async: false,
				    beforeSend: function(){
					tbjQuery('div.routes_wrapper_to').show();
					tbjQuery('div.routes_wrapper_to div.routes_to_inner').show();
				    },
				    complete: function(){
					tbjQuery.fn.getExtras('route_dropoff');
					tbjQuery.fn.getReturnExtras();
				    },
				    success: function(response){
					if(response.error==0){
					    tbjQuery('#route_to').val(response.poi.id);
					    tbjQuery('#route_to_fld').val(response.poi.title);
					}
				    }
				});
			    }
			},
			success: function(response){
			    if(response.error==0){
				tbjQuery('#route_category_dropoff').val(response.catObj.id);
				tbjQuery('#route_category_dropoff_fld').val(response.catObj.title);
			    }
			}
		    });
		}
		else { // if show_route_category disabled, collect dropoff routes list
		    if(route_pickup_poi!=0){
			tbjQuery.fn.collectRouteTo();
		    }
		    if(route_dropoff_poi!=0){
			tbjQuery.ajax({
			    type: "POST",
			    url: BASE_URL+'index.php?option=com_taxibooking&task=getPOIDetailsAjax',
			    data: 'poiid='+route_dropoff_poi,
			    dataType: 'json',
			    //async: false,
			    beforeSend: function(){
				tbjQuery('div.routes_wrapper_to').show();
				tbjQuery('div.routes_wrapper_to div.routes_to_inner').show();
			    },
			    complete: function(){
				tbjQuery.fn.getExtras('route_dropoff');
				tbjQuery.fn.getReturnExtras();
			    },
			    success: function(response){
				if(response.error==0){
				    tbjQuery('#route_to').val(response.poi.id);
				    tbjQuery('#route_to_fld').val(response.poi.title);
				}
			    }
			});
		    }
		}
	    },
	    success: function(response){
		if(response.error==0){
		    tbjQuery('#route_from').val(response.poi.id);
		    tbjQuery('#route_from_fld').val(response.poi.title);
		}
	    }
	});
    }
    else if (url_booking_type=='hourly')
    {
	tbjQuery('#hourly_hr').selectbox('detach');
	tbjQuery('#hourly_hr').val(hourly_hr);
	tbjQuery('#hourly_hr').selectbox({
	    onOpen: function (inst){},
	    onClose: function (inst){},
	    onChange: function (val, inst) {
		tbjQuery('#hourly_hr').selectbox('close');
		tbjQuery('#booking_type').val('hourly');
		tbjQuery.fn.unsetPoiAddress();
		tbjQuery.fn.unsetRoute();
		tbjQuery.fn.unsetShuttle();
		tbjQuery.fn.getExtras('hourly_hire');
	    }
	});
	tbjQuery('#hourly_min').selectbox('detach').val(hourly_min).selectbox('attach');
	if(hourly_hr!=0 || hourly_min!=0){
	    tbjQuery.fn.getExtras('hourly_hire');
	}
    }
    else if (url_booking_type=='shuttle')
    {
	tbjQuery.ajax({
	    type: "POST",
	    url: BASE_URL+'index.php?option=com_taxibooking&task=getPOIDetailsAjax',
	    data: 'poiid='+shuttle_pickup_poi,
	    dataType: 'json',
	    //async: false,
	    beforeSend: function(){
	    },
	    complete: function(){
		tbjQuery('#shuttle_dropoff').val("");
		tbjQuery('#shuttle_dropoff_poi').val(0);
		if(shuttle_pickup_poi!=0 && shuttle_dropoff_poi!=0)
		{
		    tbjQuery.fn.getShuttleDropoffPOIs(shuttle_pickup_poi);
		    tbjQuery.ajax({
			type: "POST",
			url: BASE_URL+'index.php?option=com_taxibooking&task=getPOIDetailsAjax',
			data: 'poiid='+shuttle_dropoff_poi,
			dataType: 'json',
			//async: false,
			beforeSend: function(){
			},
			complete: function(){
			    tbjQuery.fn.getShuttleTimeOptions(0); // clear_previous_selection = 0
			    tbjQuery('[name="shuttletime"][value="'+shuttle_pickup_time+'"]').attr('checked', true);
			    // show passenger list
			    tbjQuery('div.verticl_booking_bottompart.shuttle').show();
			    tbjQuery('span#selected_seat').html(shuttle_passengers);
			    tbjQuery('input#shuttle_passengers').val(shuttle_passengers);
			},
			success: function(response){
			    if(response.error==0){
				tbjQuery('#shuttle_dropoff').val(response.poi.title);
				tbjQuery('#shuttle_dropoff_poi').val(response.poi.id);
			    }
			}
		    });
		}
	    },
	    success: function(response){
		if(response.error==0){
		    tbjQuery('#shuttle_pickup').val(response.poi.title);
		    tbjQuery('#shuttle_pickup_poi').val(response.poi.id);
		}
	    }
	});
    }
    else {
	return false;
    }
})