<?php

defined('_JEXEC') or die('Restricted access');

class TBAdminBooking{

	function getAvailableCars($order_data)
	{
		$json_data = array('error' => 0, 'msg' => '', 'available_cars' => array(), 'additional_params' => array());
		
		$db = JFactory::getDBO();
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->toSql(true);
		
		$lang = JFactory::getLanguage();
		$lang->load('com_taxibooking');
		
		// Get the component configuration
		require_once (JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'booking.helper.php');
		$elsettings =  booking_helper::config();
		
		if(empty($order_data)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Order data is empty!';
		}
		elseif(empty($order_data->pickup_date)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Pickup Date is not defined!';
		}
		else {
			
			$booking_type 	= !empty($order_data->booking_type) ? $order_data->booking_type : 'address';
			$pickup_poi 	= !empty($order_data->pickup_poi) ? $order_data->pickup_poi : 0;
			$pickup_address	= !empty($order_data->pickup_address) ? $order_data->pickup_address : '';
			$pickup_coords 	= !empty($order_data->pickup_coords) ? $order_data->pickup_coords : array();
			$dropoff_poi 	= !empty($order_data->dropoff_poi) ? $order_data->dropoff_poi : 0;
			$dropoff_address= !empty($order_data->dropoff_address) ? $order_data->dropoff_address : '';
			$dropoff_coords = !empty($order_data->dropoff_coords) ? $order_data->dropoff_coords : array();
			
			$route_id 	= !empty($order_data->route_id) ? $order_data->route_id : 0;
			$route_from 	= !empty($order_data->route_from) ? $order_data->route_from : 0;
			$route_to 	= !empty($order_data->route_to) ? $order_data->route_to : 0;
			
			$hourly_hr 	= !empty($order_data->hourly_hr) ? $order_data->hourly_hr : 0;
			$hourly_min 	= !empty($order_data->hourly_min) ? $order_data->hourly_min : 0;
			
			$shuttle_pickup_poi 	= !empty($order_data->shuttle_pickup_poi) ? $order_data->shuttle_pickup_poi : 0;
			$shuttle_dropoff_poi 	= !empty($order_data->shuttle_dropoff_poi) ? $order_data->shuttle_dropoff_poi : 0;
			$shuttle_pickup_date 	= !empty($order_data->shuttle_pickup_date) ? $order_data->shuttle_pickup_date : 0;
			$shuttletime 	= !empty($order_data->shuttletime) ? $order_data->shuttletime : 0;
			$shuttle_passengers 	= !empty($order_data->shuttle_passengers) ? $order_data->shuttle_passengers : 0;
			$shuttle_route_id 	= !empty($order_data->shuttle_route_id) ? $order_data->shuttle_route_id : 0;
			
			if($booking_type=='shuttle'){
				$adultseats 	= $order_data->shuttle_passengers;
				$order_date_time_str = strtotime($shuttle_pickup_date.' '.$shuttletime);
			}
			else {
				$adultseats 	= $order_data->adultseats;
				$order_date_time_str = strtotime($order_data->pickup_date);
			}
			
		    
			$suitcases 	= !empty($order_data->suitcases) ? $order_data->suitcases : 0;
			$boosterseats 	= !empty($order_data->boosterseats) ? $order_data->boosterseats : 0;
			$infantseats 	= !empty($order_data->infantseats) ? $order_data->infantseats : 0;
			$chseats 	= !empty($order_data->childseats) ? $order_data->childseats : 0;
			$extras 	= !empty($order_data->extras) ? $order_data->extras : array();
			
			$waypoint_coords 	= !empty($order_data->waypoint_coords) ? $order_data->waypoint_coords : array();
			$total_waypoint_duration 	= !empty($order_data->total_waypoint_duration) ? $order_data->total_waypoint_duration : 0;
			$returnjurney 	= !empty($order_data->returntrip) ? $order_data->returntrip : 0;
			$editing_order_id 	= !empty($order_data->editing_order_id) ? $order_data->editing_order_id : 0;
			
			$distance = 0;
			$duration = '';
			if(!empty($pickup_coords) && !empty($dropoff_coords))
			{
				$call_gapi = true;
				if($booking_type=='shuttle'){
					$call_gapi = false;
					$gapi_status = "OK";
					$distance = $duration_seconds = 0;
				}
				
				if($call_gapi){
					list($distance,$duration_seconds,$gapi_status,$gapi_msg) = booking_helper::calculateDistance($pickup_coords[0], $pickup_coords[1], $dropoff_coords[0], $dropoff_coords[1],$elsettings->distance_unit,$waypoint_coords,$elsettings);
				}
				
				if($gapi_status=="OK")
				{
					if($call_gapi && $distance==0)
					{
						$result['error'] = 1;
						$result['msg'] = JText::_('SESSION_EXPIRED');
					}
					else
					{
						//$distance = number_format($distance,2);
						$distance_text = number_format($distance,2).' '.$elsettings->distance_unit.'s';
						
						// waypoint time 
						$duration_seconds += $total_waypoint_duration*60;
						
						$duration_text = booking_helper::secondsToTime($duration_seconds);
						
						if($returnjurney == 1){
							$distance_text .= ' '.JText::_('EACH_WAY');
						}
					}
				}
				elseif ($gapi_status=="ZERO_RESULTS") {
					//indicates that the geocode was successful but returned no results. This may occur if the geocode was passed a non-existent address or a latlng in a remote location.
					$result['error'] = 1;
					$result['msg'] = 'The geocode was successful but returned no results. This may occur if the geocoder was passed a non-existent address.';
				}
				elseif ($gapi_status=="OVER_QUERY_LIMIT") {
					//indicates that you are over your quota of geocode requests against the google api
					$result['error'] = 1;
					$result['msg'] = $gapi_msg;
				}
				elseif ($gapi_status=="REQUEST_DENIED") {
					//indicates that your request was denied, generally because of lack of a sensor parameter.
					$result['error'] = 1;
					$result['msg'] = $gapi_msg;
				}
				elseif ($gapi_status=="INVALID_REQUEST" || $gapi_status=="NOT_FOUND") {
					//generally indicates that the query (address or latlng) is missing.
					$result['error'] = 1;
					$result['msg'] = 'The query (address or latlng) is missing.';
				}
				else {
					$result['error'] = 1;
					$result['msg'] = $gapi_msg;
				}
			}
			
			$price = 0;
			
			if($booking_type=='shuttle'){
				$pickup_poi = $shuttle_pickup_poi;
				$dropoff_poi = $shuttle_dropoff_poi;
			}
			
			if($booking_type=='offers'){
				$route_from = $pickup_poi;
				$route_to = $dropoff_poi;
			}
			
			$price = 0;
			$booking_data = array('booking_type' => $booking_type,
					'pickup_poi' => $pickup_poi,
					'dropoff_poi' => $dropoff_poi,
					'route_from' => $route_from,
					'route_to' => $route_to,
					'lat_long_from' => $pickup_coords,
					'lat_long_to' => $dropoff_coords,
					'adultseats' => $adultseats,
					'suitcases' => $suitcases,
					'boosterseats' => $boosterseats,
					'infantseats' => $infantseats,
					'chseats' => $chseats,
					'hourly_hr' => $hourly_hr,
					'hourly_min' => $hourly_min
					);
		    
			// calculate extras price
			list($selected_extras, $total_extra_price) = booking_helper::process_extras($extras);
			
			$separate_car_price = 0;
			$route_price = 0;
			$fixed_car_prices = '';
			if($booking_type=='offers' && $route_from > 0 && $route_to > 0)  // customer selected fixed route
			{
			    $route_swapped = 0;
			    
			    $query = $db->getQuery(true);
			    $query->select('price, separate_car_price, car_prices');
			    $query->from('#__taxibooking_routes');
			    
			    if($route_swapped==1){ // if route swapped, then interchange the route
				$query->where('route_from = '.(int) $route_to.' AND route_to = '.(int) $route_from);
			    }
			    else {
				$query->where('route_from = '.(int) $route_from.' AND route_to = '.(int) $route_to);
			    }
			    $query->where('published = 1');
			    $db->setQuery((string)$query);
			    $route_obj = $db->loadObject();
			    
			    $route_price = $route_obj->price;
			    $separate_car_price = $route_obj->separate_car_price;
			    $fixed_car_prices = $route_obj->car_prices;
			    
			    // check whether this fixed route has separate car price enabled and has a set of car with price
			    // if yes, the just show the list of cars with price - no calculation requried
			    // if not, then route price will be considered
			    if($separate_car_price==0)  
			    {
				$price += $route_price;
			    }
			}
			
			if($booking_type=='hourly')
			{
				$duration_seconds = $hourly_hr*3600 + $hourly_min*60;
				$duration_text = booking_helper::secondsToTime($duration_seconds);
			}
			
			// collect additional charge for POIs if booking type is not HOURLY_HIRE and Shuttle
			if(!in_array($booking_type, array('hourly', 'shuttle')))
			{
			    $poi_additional_charges = booking_helper::get_poi_additional_charge($booking_data);
			    $price += $poi_additional_charges['total_additional_price'];
			}
			
			if ($boosterseats > 0) {
				$price_to_added = (float)($boosterseats * $elsettings->booster_seat_price);
				$price += $price_to_added;
			}
			if ($infantseats > 0) {
				$price_to_added = (float)($infantseats * $elsettings->infant_seat_price);
				$price += $price_to_added;
			}
			if ($chseats > 0) {
				$price_to_added = (float)($chseats * $elsettings->child_seat_price);
				$price += $price_to_added;
			}
			    
			if($booking_type=='offers' && $separate_car_price==1)
			{
				$cars = booking_helper::get_fixed_route_car_set($fixed_car_prices, $booking_data);
			}
			elseif($booking_type=='shuttle')
			{
				// calculate time differnce between pickup and dropoff points
				$query = 'SELECT t1.arrival_time AS `pickup_arrival`, t2.arrival_time AS `dropoff_arrival`, '
					. ' (TIME_TO_SEC( t2.arrival_time ) - TIME_TO_SEC( t1.arrival_time )) AS `difference`'
					. ' FROM (
						SELECT arrival_time
						FROM `#__taxibooking_shuttle_route_stops` rs
						WHERE rs.route_id = '.(int)$shuttle_route_id
					. ' 	AND rs.poi_id = '.(int)$shuttle_pickup_poi
					. ' 	)t1
						JOIN (
						
						SELECT arrival_time
						FROM `#__taxibooking_shuttle_route_stops` rs
						WHERE rs.route_id = '.(int)$shuttle_route_id
					. ' 	AND rs.poi_id = '.(int)$shuttle_dropoff_poi
					. ' 	)t2'
				;
				//echo str_replace('#__', 'nfgwj_', $query);
				$db->setQuery($query);
				$journey_duration = $db->loadObject();
				
				$duration_seconds = $journey_duration->difference;
				$duration_text = booking_helper::secondsToTime($duration_seconds);
				
				// get already booked seats on current date for this route
				$shuttle_data = array('route_id' => $shuttle_route_id,
						      'order_date' => date("Y-m-d", $order_date_time_str)
						      );
				$total_seats_booked = booking_helper::shuttle_booking_count($shuttle_data);
				
				$query = $db->getQuery(true);
				$query->select('c.*');
				$query->from($db->quoteName('#__taxibooking_cars') . ' AS c');
				$query->join('LEFT', $db->quoteName('#__taxibooking_shuttle_routes') . ' AS r ON r.car_id = c.id');
				$query->where('r.id = '.(int)$shuttle_route_id);
				$query->where('c.published = 1');
				$query->where('c.use_as_shuttle != 0');
				$query->where('c.passenger_no > '.(int)$total_seats_booked);
				$db->setQuery((string)$query);
				$cars = $db->loadObjectList();
			}
			else // usual car price calculation for POI and address
			{
				// now list cars
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_cars');
				$query->where('published = "1"');
				$query->where('use_as_shuttle != 2'); // cars used only as shuttle will not be listed in other booking types
				
				if($booking_type=='address'){
					$query->where('use_in_address = 1');
				}
				if($booking_type=='offers'){
					$query->where('use_in_offers = 1');
				}
		    
				if($adultseats > 0)
				{
				    $query->where('passenger_no >= '.(int)$adultseats);
				}
				if($suitcases > 0)
				{
				    $query->where('suitcase_no >= '.(int)$suitcases);
				}
				if($boosterseats > 0)
				{
				    $query->where('booster_seat_no >= '.(int)$boosterseats);
				}
				if($infantseats > 0)
				{
				    $query->where('infant_seat_no >= '.(int)$infantseats);
				}
				if($chseats > 0)
				{
				    $query->where('child_seat_no  >= '.(int)$chseats);
				}
				
				if($booking_type=='hourly')
				{
				    $query->where('hourly_hire_enabled  = 1');
				    $query->where('hourly_hire_min_hr <= '.($hourly_hr+($hourly_min/100)) );
				    $query->where('hourly_hire_max_hr >= '.($hourly_hr+($hourly_min/100)) );
				}
				
				// adult + booster + child + infant must be less than the maximum passenger seats for a car
				$total_passengers = (int)$adultseats+(int)$infantseats+(int)$boosterseats+(int)$chseats;
				
				//Hourly and Shuttle have no use of Min passengers.
				if($booking_type!='hourly'){
					$query->where('min_passenger_no <= '.$total_passengers);
				}
				
				$query->where('passenger_no >= '.$total_passengers);
				
				$query->order('price ASC');
				$db->setQuery((string)$query);
				$cars = $db->loadObjectList();
			}
			
			// consider base if its not shuttle booking
			if(!in_array($booking_type, array('shuttle')))
			{
				list($base_pickup_distance,
				     $base_pickup_duration,
				     $base_pickup_price,
				     $base_pickup_price_calc,
				     $dropoff_base_distance,
				     $dropoff_base_duration,
				     $dropoff_base_price,
				     $dropoff_base_price_calc) = booking_helper::considerBase($elsettings, $booking_data);
				
				if($booking_type=='offers'){
					if($elsettings->base_pickup_special_routes=='price_time'){
					}
					elseif($elsettings->base_pickup_special_routes=='time'){
						$base_pickup_distance = 0;
					}
					else {
						$base_pickup_distance = $base_pickup_duration = 0;
					}
					
					if($elsettings->base_dropoff_special_routes=='price_time'){
					}
					elseif($elsettings->base_dropoff_special_routes=='time'){
						$dropoff_base_distance = 0;
					}
					else {
						$dropoff_base_distance = $dropoff_base_duration = 0;
					}
				}
			}
			
			if($booking_type=='shuttle')
			{
				list($base_pickup_distance,
				     $base_pickup_duration,
				     $base_pickup_price,
				     $base_pickup_price_calc,
				     $dropoff_base_distance,
				     $dropoff_base_duration,
				     $dropoff_base_price,
				     $dropoff_base_price_calc) = array(0,0,0,'',0,0,0,'');
				if(!empty($cars))
				{
					foreach($cars as $key => $car)
					{
					    // first check today is a blocked date or not for this car
					    if(booking_helper::check_car_block_dates($car, $order_date_time_str)===FALSE){
						unset($cars[$key]);
					    }
					    elseif(booking_helper::check_todays_availability($car, $order_date_time_str)===FALSE) { // check todays opening/closing time and compare with current time
						unset($cars[$key]);
					    }
					    else {
						// round price based on configuration
						$car_price = 0;
						$query = 'SELECT SUM( `price_per_passenger` ) AS price_per_passenger'
							. ' FROM #__taxibooking_shuttle_route_stops'
							. ' WHERE `route_id` = '.(int)$shuttle_route_id
							. ' AND `ordering` > '
							. '            (SELECT `ordering` FROM `#__taxibooking_shuttle_route_stops`'
							. '            WHERE `poi_id` = '.(int)$shuttle_pickup_poi
							. '            AND `route_id` = '.(int)$shuttle_route_id.')'
							. ' AND `ordering` <= '
							. '            (SELECT `ordering` FROM `#__taxibooking_shuttle_route_stops`'
							. '            WHERE `poi_id` = '.(int)$shuttle_dropoff_poi
							. '            AND `route_id` = '.(int)$shuttle_route_id.')'
						;
						//echo str_replace('#__', 'nfgwj_', $query);
						$db->setQuery($query);
						$price_per_passenger = $db->loadResult();
						
						$car_price = (float)$price_per_passenger * (int)$adultseats;
						
						$car_price = booking_helper::round_price($car_price, $elsettings);
						$car->car_price = $car_price;
						
					    }
					}
				}
			}
			else {
				// collect all available tariffs for pickup
				$tariffs = array();
				if($booking_type=='address'){
					$tariffs = booking_helper::getCurrentTariffs($order_date_time_str);
				}
				if(!empty($cars))
				{
				    foreach($cars as $key => $car)
				    {
					// first check today is a blocked date or not for this car
					if(booking_helper::check_car_block_dates($car, $order_date_time_str)===FALSE){
					    unset($cars[$key]);
					}
					elseif(booking_helper::check_todays_availability($car,$order_date_time_str)===FALSE) { // check todays opening/closing time and compare with current time
					    unset($cars[$key]);
					}
					elseif(booking_helper::check_car_previous_bookings($car,$order_date_time_str,$editing_order_id,$duration_seconds)===FALSE) { // check this car previous booking journey
					    unset($cars[$key]);
					}
					elseif(booking_helper::check_car_shuttle_route($car, $shuttletime, $elsettings)===FALSE) { // check if this car is assigned to any shuttle route between the booking time
					    unset($cars[$key]);
					}
					else {
					    $car_price = 0;
					    
					    // every car has it's own price model, but that own price will not be applied for fixed route
					    if($booking_type!='offers')
					    {
						    if($booking_type=='hourly')
						    {
							    $hourly_charge = $car->hourly_rate*($hourly_hr+($hourly_min/60));
							    $car_price += $hourly_charge;
							    
							    if((float)$car->hourly_hire_fee > 0){
								$car_price += (float)$car->hourly_hire_fee;
							    }
						    }
						    else {
							    if($car->price_calculation_cumulative==1 || $elsettings->price_calculation_cumulative==1) // if car has cumulative price enabled
							    {
								    list($cum_car_price,$unit_price,$price_calculation_debug_str,$applied_tariff) = booking_helper::get_car_cumulative_price($car, $distance, $tariffs, $elsettings);
								    $car_price += $cum_car_price;
							    }
							    else {  // non-cumulative price calculation
								    list($unit_price, $applied_tariff) = booking_helper::get_car_unit_price($car, $distance, $tariffs, $elsettings);
								    $car_price += $distance * $unit_price;
								    if($applied_tariff){
									$car_price += (float)$applied_tariff->initial_price;
								    }
							    }
							    
								// we have 2 conditions for min distance
								// first if minimum distance > 0, price will be min.price if journey distance is less than min distance
								// if Minimum distance 0 or empty, then Price will be Min price if calculated price is less than Min price
								if((float)$elsettings->minmil > 0){
								    if($distance < (float)$elsettings->minmil && $car_price < (float)$elsettings->minprice){
									    $car_price = (float)$elsettings->minprice;
								    }
								}
								else {
								    if ((float)$elsettings->minprice > 0 && $car_price < (float)$elsettings->minprice){
									    $car_price = (float)$elsettings->minprice;
								    }
								}
						    }
					    }
					    
					    $car_price += $elsettings->cost_per_call; // initial call charge
					    
					    // add car flat price
					    if($booking_type!='hourly')
					    {
						    if($booking_type=='offers'){
							if($separate_car_price==0){
								$car->price = 0; // If separate car price = NO, addiotnal car charge/car price will not be added
							}
						    }
						    
						    $car_price += $car->price;
					    }
					    
					    // waypoint time charge
					    if($elsettings->stops_charge_per_min!="")
					    {
						    $car_price += $total_waypoint_duration* (float) $elsettings->stops_charge_per_min;
					    }
					    
					    // add seats + poi additional charge
					    $car_price += $price;
					    
					    // add extra price
					    $car_price += $total_extra_price;
					    
					    // add base price
					    if($booking_type=='offers'){
							if($elsettings->base_pickup_special_routes=='price_time'){
								$car_price += $base_pickup_price;
							}
							if($elsettings->base_dropoff_special_routes=='price_time'){
								$car_price += $dropoff_base_price;
							}
						}
						else {
							$car_price += ($base_pickup_price+$dropoff_base_price);
						}
					    
					    // charge per min will be applied for Address booking only
					    if($booking_type=='address'){
						list($duration_charge,$unit_charge) = booking_helper::calculate_charge_per_min($duration_seconds, $car, $elsettings, $applied_tariff);
						$car_price += $duration_charge;
					    }
					    
					    // calculate distance sectors discounts for Address booking only
					    $distance_sector_outbound_discount = 0;
					    $distance_sector_return_discount = 0;
					    if($booking_type=='address'){
						    list($distance_sector_outbound_discount,$distance_sector_return_discount) = booking_helper::get_distance_sector_discounts($car, $elsettings, $distance);
						    if($distance_sector_outbound_discount!=0){
							    $car_price -= (float)$distance_sector_outbound_discount;
						    }
					    }
					    
					    $outbound_price = $car_price;
					    
					    // return journey price
					    // consider return discount hour
					$return_wait_discount = 0;
					$return_wait_hr = -1;
					    if ($returnjurney == 1)
					    {
						// If add_price_return = NO, additional car type charge will not be applied for return journey
						if(($booking_type=='address') || ($booking_type=='offers' && $separate_car_price==0)) {
						    if($car->add_price_return==0) {
							    $outbound_price -= (float)$car->price;
						    }
						}
						
						// initial charge will be applied once per order
						$outbound_price -= (float)$elsettings->cost_per_call;
						
						    $discounts = array('return_wait_discount' => $return_wait_discount,
								       'distance_sector_return_discount' => $distance_sector_return_discount
								       );
						    list($return_price,$return_discounts,$return_discounts_calc) = booking_helper::calculate_return_price($outbound_price, $elsettings, $discounts);
						    $car_price += (float)$return_price;
						    
					    }
					    
					    // round price based on configuration
					    $car_price = booking_helper::round_price($car_price, $elsettings);
					    $car->car_price = $car_price;
					}
				    }
				}
				
				// combine cars by type
				if($elsettings->combine_car_type==1)
				{
				    // first sort cars array by lowest id first
				    require_once (JPATH_COMPONENT_SITE.DS.'helpers'.DS.'sort_helper.php');
				    $cars = sort_stack($cars, 'itemid', 'ASC');
				    
				    $temp = array();
				    $car_available_counter = array();
				    foreach($cars as $key => $car)
				    {
					if(isset($car_available_counter[$car->car_price] )){
					    $car_available_counter[$car->car_price]++;
					}
					else {
					    $car_available_counter[$car->car_price] = 1;
					}
				    }
				    
				    for($i=0;$i<count($cars);$i++)
				    {
					$found = false;
					for($j=0;$j< count($temp);$j++)
					{
					    if( ($temp[$j]->alias==$cars[$i]->alias)
					       && ($temp[$j]->passenger_no==$cars[$i]->passenger_no)
					       && ($temp[$j]->suitcase_no==$cars[$i]->suitcase_no)
					       && ($temp[$j]->booster_seat_no==$cars[$i]->booster_seat_no)
					       && ($temp[$j]->infant_seat_no==$cars[$i]->infant_seat_no)
					       && ($temp[$j]->child_seat_no==$cars[$i]->child_seat_no)
					       && ($temp[$j]->car_price==$cars[$i]->car_price)
					    ){
						$found = true;
						break;
					    }
					}
					
					if(!$found){
					    $temp[] = $cars[$i];
					}
				    }
				    
				    $cars = $temp;
				}
			}
		    
			// sort car
			$sort_by = JRequest::getVar('sort_by', 'car_price');
			$sort_dir = JRequest::getVar('sort_dir', 'ASC');
			
			require_once (JPATH_COMPONENT_SITE.DS.'helpers'.DS.'sort_helper.php');
			$cars = sort_stack($cars, $sort_by, $sort_dir);
			
			// now generate car list html
			if(!empty($cars))
			{
				$json_data['available_cars'] = $cars;
				$json_data['additional_params'] = array('distance' => $distance,
									'duration_seconds' => $duration_seconds,
									'base_pickup_distance' => $base_pickup_distance,
									'base_pickup_duration' => $base_pickup_duration,
									'dropoff_base_distance' => $dropoff_base_distance,
									'dropoff_base_duration' => $dropoff_base_duration,
									'total_extra_price' => $total_extra_price);
			}
			else {
				$json_data['error'] = 1;
				$json_data['msg'] = JText::_('COM_TBSAAS_NO_VEHICLE_DATETIME');
			}
		}
		
		return $json_data;
	}
}
