<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

class CouponCode{

	public $_code = null;
	public $_coupon = null;
	public $_couponId = 0;
	
	public function __construct($coupon_code, $coupon_id)
	{
		$this->_code = $coupon_code;
		$this->_couponId = $coupon_id;
	}
	
	public function get_coupon($booking_data = array())
	{
		$db = JFactory::getDBO();
		
		$lang_tag = !empty($booking_data['lang_tag']) ? $booking_data['lang_tag'] : 'en-GB';
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_coupons');
		$query->where('code = '.$db->Quote($this->_code));
		$query->where('published=1');
		$query->where('(language = "*" OR language = '.$db->Quote($lang_tag).')');
		$db->setQuery((string)$query);
		$this->_coupon = $db->loadObject();
		
		return $this->_coupon;
	}
	
	public function get_coupon_by_id($booking_data = array())
	{
		$db = JFactory::getDBO();
		
		$lang_tag = !empty($booking_data['lang_tag']) ? $booking_data['lang_tag'] : 'en-GB';
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_coupons');
		$query->where('id = '.$db->Quote($this->_couponId));
		$query->where('(language = "*" OR language = '.$db->Quote($lang_tag).')');
		$db->setQuery((string)$query);
		$this->_coupon = $db->loadObject();
		
		return $this->_coupon;
	}
	
	public function validate($booking_data)
	{
		if($this->_couponId>0){
			$coupon_obj = $this->get_coupon_by_id($booking_data);
		}
		else {
			$coupon_obj = $this->get_coupon($booking_data);
		}
		
		$is_valid = FALSE;
		$msg = '';
		
		if(is_null($coupon_obj) || $coupon_obj->published==0){
			$msg = JText::_( 'COUPON_VALIDATE_CODE_NOT_FOUND');
		}
		elseif($this->_validate_start_date($booking_data)===FALSE){
			$msg = JText::_( 'COUPON_VALIDATE_CODE_NOT_ACTIVE');
		}
		elseif($this->_validate_end_date($booking_data)===FALSE){
			$msg = JText::_( 'COUPON_VALIDATE_CODE_EXPIRED');
		}
		elseif($this->_validate_coupon_user()===FALSE){
			$msg = JText::_( 'COUPON_VALIDATE_CODE_USER_NOT_ALLOWED');
		}
		elseif($this->_validate_coupon_email($booking_data)===FALSE){
			$msg = JText::_( 'COUPON_VALIDATE_CODE_EMAIL_NOT_ALLOWED');
		}
		elseif($this->_validate_coupon_user_group()===FALSE){
			$msg = JText::_( 'COUPON_VALIDATE_CODE_USERGROUP_NOT_ALLOWED');
		}
		elseif($this->_validate_booking_type($booking_data)===FALSE){
			$msg = JText::_( 'COUPON_VALIDATE_CODE_BOOKING_TYPE_NOT_ALLOWED');
		}
		elseif($this->_validate_special_routes($booking_data)===FALSE){
			$msg = JText::_( 'COUPON_VALIDATE_CODE_SPECIAL_ROUTE_NOT_ALLOWED');
		}
		elseif($this->_validate_hits_limit()===FALSE){
			$msg = JText::_( 'COUPON_VALIDATE_CODE_USED_MAXIMUM');
		}
		elseif($this->_validate_max_user_hits($booking_data)===FALSE){
			$msg = JText::_( 'COUPON_VALIDATE_CODE_USED_MAXIMUM_PER_USER');
		}
		else {
			$is_valid = TRUE;
		}
		
		return array($is_valid, $msg);
	}
	
	public function apply($params)
	{
		$elsettings = booking_helper::config();
		$grand_total = $params['grand_total'];
		if($this->_coupon->discount_type=='percent'){
			$new_total = $grand_total - ( $grand_total * (float)$this->_coupon->discount_value / 100);
		}
		else{
			$new_total = $grand_total - (float)$this->_coupon->discount_value;
		}
		
		$new_total = booking_helper::round_price($new_total, $elsettings);
		
		return $new_total;
	}
	
	private function _validate_start_date($booking_data)
	{
		if($this->_coupon->valid_from=="0000-00-00 00:00:00"){
			return TRUE;
		}
		else {
			if($booking_data['pickup_date'] > $this->_coupon->valid_from){
				return TRUE;
			}
			else {
				return FALSE;
			}
		}
	}
	
	private function _validate_end_date($booking_data)
	{
		if($this->_coupon->valid_to=="0000-00-00 00:00:00"){
			return TRUE;
		}
		else {
			if($booking_data['pickup_date'] <= $this->_coupon->valid_to){
				return TRUE;
			}
			else {
				return FALSE;
			}
		}
	}
	
	private function _validate_coupon_user()
	{
		if($this->_coupon->coupon_user==0 || $this->_coupon->coupon_user==""){
			return TRUE;
		}
		
		$user =  JFactory::getUser();
		if($this->_coupon->coupon_user==$user->get('id')){
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
	
	private function _validate_coupon_email($booking_data)
	{
		if($this->_coupon->coupon_email==""){
			return TRUE;
		}
		
		if($this->_coupon->coupon_email==$booking_data['email']){
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
	
	private function _validate_coupon_user_group()
	{
		if($this->_coupon->coupon_user_group==""){
			return TRUE;
		}
		
		$user =  JFactory::getUser();
		$usergroups = JAccess::getGroupsByUser($user->get('id'));
		
		$allowed_groups = explode(',',$this->_coupon->coupon_user_group);
		$temp = array_intersect( $allowed_groups, $usergroups );
		
		if(!empty($temp)){
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
	
	private function _validate_booking_type($booking_data)
	{
		if($this->_coupon->booking_types==""){
			return TRUE;
		}
		
		$allowed_booking_types = explode(',',$this->_coupon->booking_types);
		
		if(in_array($booking_data['booking_type'], (array)$allowed_booking_types)){
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
	
	// Coupon will be applied for selected route from backend
	// if no route selected, this coupon will not be applied for any route
	private function _validate_special_routes($booking_data)
	{
		if($booking_data['booking_type']=='offers'){
			if($this->_coupon->special_routes==""){
				return FALSE;
			}
			else {
				$special_routes = explode(',', $this->_coupon->special_routes);
				$db = JFactory::getDBO();
		
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_routes');
				$query->where('route_from = '.$db->Quote($booking_data['route_from']));
				$query->where('route_to = '.$db->Quote($booking_data['route_to']));
				$db->setQuery((string)$query);
				$route = $db->loadObject();
				
				if($route){
					if(in_array($route->id, $special_routes)){
						return TRUE;
					}
					else {
						return FALSE;
					}
				}
				else {
					return FALSE;
				}
			}
		}
		else {
			return TRUE;
		}
	}
	
	private function _validate_hits_limit()
	{
		if($this->_coupon->hits_limit==0){
			return TRUE;
		}
		
		if($this->_coupon->hits < $this->_coupon->hits_limit){
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
	
	private function _validate_max_user_hits($booking_data)
	{
		if($this->_coupon->max_hits_user==0){
			return TRUE;
		}
		
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		$query->select('hits');
		$query->from('#__taxibooking_coupons_user_record');
		$query->where('coupon_id = '.$db->Quote($this->_coupon->id));
		$query->where('user_email = '.$db->Quote($booking_data['email']));
		$db->setQuery((string)$query);
		$hits_this_user = $db->loadResult();
		
		if($hits_this_user && $hits_this_user >= $this->_coupon->max_hits_user){
			return FALSE;
		}
		else {
			return TRUE;
		}
	}
	
	private function _get_current_date()
	{
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->toSql(true);
		
		return $now;
	}
}