<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

if(!defined("DS")){
	define( 'DS', DIRECTORY_SEPARATOR );
}

$path = JPATH_COMPONENT_SITE.DS."google-api-php-client-master".DS."src".DS."Google";
set_include_path(get_include_path() . PATH_SEPARATOR . $path);
//echo $path;
if(!file_exists ( $path.DS.'Client.php' )){
	//echo 'Taxibooking set to use Google Calendar but the Google Library is not installed. See <a href="http://kanev.com/docs/taxi-booking/google-calendar" target="_blank">Tutorial</a>';
	//exit;
	return false;
}

// require autoloader if it exists
// Later versions of google-api-php-client-master has a autoloader.php in src/Google directory
// for later versions, this autoload.php should be loaded
if(file_exists ($path.DS.'autoload.php')){
	require_once $path.DS.'autoload.php';
}
else {
	require_once $path.DS."Client.php";
	require_once $path.DS."Service.php";
}

class GoogleCalendar
{
	var $client = null;
	var $tzOffset = "0";
	var $cal_id = "";
	var $username = "";
	
	function login($gcal_config)
	{
		$app = JFactory::getApplication();
		if ($app->isAdmin()){
			$path = JPATH_COMPONENT_SITE.DS."google-api-php-client-master".DS."src".DS."Google";
			if(!file_exists ( $path.DS.'Client.php' )){
				return false;
			}

			$p12_file = JPATH_COMPONENT_SITE.DS.$gcal_config->google_p12_key_filename;
		}
		else{
			$path = JPATH_COMPONENT.DS."google-api-php-client-master".DS."src".DS."Google";
			if(!file_exists ( $path.DS.'Client.php' )){
				return false;
			}
			
			$p12_file = JPATH_COMPONENT.DS.$gcal_config->google_p12_key_filename;
		}
		
		try {
			$this->client = new Google_Client();
			$this->client->setApplicationName($gcal_config->google_app_name);
			$this->client->setClientId($gcal_config->google_client_id);
			$this->client->setAssertionCredentials( 
				new Google_Auth_AssertionCredentials(
					$gcal_config->google_app_email_address,
					array("https://www.googleapis.com/auth/calendar"),
					file_get_contents($p12_file),
					'notasecret','http://oauth.net/grant_type/jwt/1.0/bearer',false,false
				)
			);
		}
		catch (RuntimeException $e) {
		    return 'Problem authenticating Google Calendar:'.$e->getMessage();
		}
		return "ok";	
	}

	function setTZOffset($value){
		$this->tzOffset = $value;		
	}

	function setCalID($value){
		$this->cal_id = $value;		
	}

	function getClient(){
		return $this->client;
	}
	
	function createEvent ($title='', $desc='Taxi Transfer Service', $where='',  $startDate='', $startTime='', $endDate='', $endTime='')
	{
		if($this->client == null){
			echo "Not Logged in";
			return -1;
		}		
		$service = new Google_Service_Calendar($this->client);		
		$newEvent = new Google_Service_Calendar_Event();
		$newEvent->setSummary($title);
		$newEvent->setLocation($where);
		$newEvent->setDescription($desc);
		$event_start = new Google_Service_Calendar_EventDateTime();
		$event_start->setDateTime("{$startDate}T{$startTime}{$this->tzOffset}");
		$newEvent->setStart($event_start);
		$event_end = new Google_Service_Calendar_EventDateTime();
		$event_end->setDateTime("{$endDate}T{$endTime}{$this->tzOffset}");
		$newEvent->setEnd($event_end);
	
		// Upload the event to the calendar server
		// A copy of the event as it is recorded on the server is returned
			
		$createdEvent = null;
		if($this->cal_id != ""){
			try {
				$createdEvent = $service->events->insert($this->cal_id, $newEvent);
				$createdEvent_id= $createdEvent->getId();
			} catch (Google_ServiceException $e) {
				tberror_log("Create calendar,".$e->getMessage()); 
			}			
		} else {
			tberror_log("svgcal_v3, No calendar ID specified in the resource setup screen."); 
			return null;
		}
		return $createdEvent_id;
	}

	function deleteEventById ($client, $eventId) 
	{
		$service = new Google_Service_Calendar($this->client);
		$event = $service->events->get($client, $eventId);
		if($event != null){
			try {
				$service->events->delete('primary', $eventId);
				$event->delete();
			} catch (Exception $e) {
				tberror_log("Delete calendar (del 1),".$e->getMessage()); 
			}
		}
	}
	
	function deleteEvent ($client, $eventId, $cal_id='primary') 
	{
		$service = new Google_Service_Calendar($this->client);		
		try {
			$service->events->delete($cal_id, $eventId);
		} catch (Exception $e) {
			tberror_log("Delete calendar (del 2),".$e->getMessage()); 
		}
		return "ok";
	}
	
	function getEvent($client, $eventId, $cal_id='default'){ 
		$service = new Google_Service_Calendar($this->client);		
		$query = $gdataCal->newEventQuery(); 
		$query->setUser($cal_id); 
		$query->setVisibility('private'); 
		$query->setProjection('full'); 
		$query->setEvent($eventId); 
		
		try { 
			$eventEntry = $gdataCal->getCalendarEventEntry($query); 
			return $eventEntry; 
		} catch (Zend_Gdata_App_Exception $e) { 
			echo $e->getMessage();
			return null; 
		} 
	}
}