<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

/**
* Google URL shorten API
* @version API V1
*/
class GoogleURL
{
    /**
     * API URL
     * @var string
     */
    private $apiURL = 'https://www.googleapis.com/urlshortener/v1/url';

    /**
     * Google URL shorten Constructor
     * @param string $apiKey
     * @return void
     */
    public function __construct()
    {
    }

    public function httpsPost($postData)
    {
        $curlObj = curl_init();
         
        $jsonData = json_encode($postData);
         
        curl_setopt($curlObj, CURLOPT_URL, $this->apiURL);
        curl_setopt($curlObj, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curlObj, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curlObj, CURLOPT_HEADER, 0);
        curl_setopt($curlObj, CURLOPT_HTTPHEADER, array('Content-type:application/json'));
        curl_setopt($curlObj, CURLOPT_POST, 1);
        curl_setopt($curlObj, CURLOPT_POSTFIELDS, $jsonData);
         
        $response = curl_exec($curlObj);
         
        //change the response json string to object
        $json = json_decode($response);
        curl_close($curlObj);
         
        return $json;
    }
     
    public function httpGet($params)
    {
        $final_url = $this->apiURL.'?'.http_build_query($params);
         
        $curlObj = curl_init();
        
        curl_setopt($curlObj, CURLOPT_URL, $final_url);
        curl_setopt($curlObj, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curlObj, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curlObj, CURLOPT_HEADER, 0);
        curl_setopt($curlObj, CURLOPT_HTTPHEADER, array('Content-type:application/json'));
         
        $response = curl_exec($curlObj);
        
        //change the response json string to object
        $json = json_decode($response);
        curl_close($curlObj);
         
        return $json;
    }
}