<?php

defined('_JEXEC') or die('Restricted access');

class orderClass extends taxibookingClass{

	var $tables = array('orders');
	var $pkey = 'id';
	var $namekey = 'alias';
	var $newlist = false;

	function getLists($data, $filters = array(), $index = ''){
		$json_data = array('error' => 0, 'msg' => '', 'count' => 0, 'rows' => array());
		
		if(empty($data->username) || empty($data->password)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Username or Password was not found!';
		}
		elseif($this->_is_user_allowed($data)===FALSE){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Public Users are not allowed to export orders!';
		}
		else {
			$config   = JFactory::getConfig();
			$siteOffset = $config->get('offset');
			date_default_timezone_set($siteOffset);
			$dtnow = JFactory::getDate('now', $siteOffset);
		
			$query = $this->database->getQuery(true);
	 
			// Select the required fields from the table.
			$query->select('a.id AS order_id, a.order_number, a.names AS customer_name, a.gender, a.email, a.phone, a.booking_type,
				a.selpassengers AS passengers, a.selinfantseats AS infantseats, a.selchildseats AS chseats, a.selboosterseats AS boosterseats,
				a.selluggage AS suitcases, a.hourly_hr, a.hourly_min,
				a.PickupAddr1 AS pickup_additional_information, a.PickupAddr4 AS dropoff_additional_information, a.message AS customer_note,
				a.begin AS pickup, a.stops, a.end AS dropoff, a.datetime1 AS pickup_date, a.returntrip, a.return_wait_hr, a.return_wait_discount,
				a.datetime2 AS return_date, a.duration, a.duration_text, a.sub_total, a.flat_cost, a.percentage_cost, a.cprice AS order_total, a.poi_additional_charges,
				a.extras AS custom_fields, a.state AS order_status, a.created AS created_date, a.invoice_title');
			
			$query->from($this->database->quoteName('#__taxibooking_orders') . ' AS a');
			
			 // Join over the driver 
			$query->select('a.driver_id, u.name AS drivername')
				->join('LEFT', $this->database->quoteName('#__users') . ' AS u ON u.id = a.driver_id');
				
			// Join over the car 
			$query->select('a.vehicletype AS vehicle_id, car.title AS vehicle_title')
				->join('LEFT', $this->database->quoteName('#__taxibooking_cars') . ' AS car ON car.id = a.vehicletype');
				
			// Join over the payment methods 
			$query->select('pm.title AS payment_method')
				->join('LEFT', $this->database->quoteName('#__taxibooking_paymentmethods') . ' AS pm ON pm.id = a.payment');
				
			if(!empty($filters['orderids'])){
				if(!is_array($filters['orderids'])){
					$filters['orderids'] = array($filters['orderids']);
				}
				JArrayHelper::toInteger($filters['orderids']);
				$query->where('a.id IN ('.implode(',',$filters['orderids']).')');
			}
			if(!empty($filters['order_numbers'])){
				if(!is_array($filters['order_numbers'])){
					$filters['order_numbers'] = array($filters['order_numbers']);
				}
				
				$query->where('a.order_number IN ('.implode(',',$this->database->Quote($filters['order_numbers'])).')');
			}
			if(!empty($filters['booking_type'])){
				$query->where('a.booking_type = ' . $this->database->Quote($filters['booking_type']));
			}
			if(!empty($filters['order_status'])){
				if ($filters['order_status'] == 'Accepted') {
					$query->where('a.state = 1');
				}
				else if ($filters['order_status'] == 'Rejected') {
					$query->where('a.state = 0');
				}
				else if ($filters['order_status'] == 'Archived') {
					$query->where('a.state = -1');
				}
				else if ($filters['order_status'] == 'Waiting') {
					$query->where('a.state = -2');
				}
			}
			if(!empty($filters['start_date'])){
				$start_date_stamp = strtotime($filters['start_date']);
				$query->where('a.datetime1 >= ' . $this->database->Quote($start_date_stamp));
			}
			if(!empty($filters['end_date'])){
				$end_date_stamp = strtotime($filters['end_date']);
				$query->where('a.datetime1 <= ' . $this->database->Quote($end_date_stamp));
			}
			
			// Add the list ordering clause.
			$orderCol = 'a.id';
			$orderDirn = 'DESC';
			$query->order($this->database->escape($orderCol . ' ' . $orderDirn));
			//die(print $query);
			$this->database->setQuery($query);
			$rows = $this->database->loadObjectList($index);
			
			if(!empty($rows))
			{
				$json_data['count'] = count($rows);
				foreach($rows as $row)
				{
					$row->stops = $this->_get_stops_details($row->stops);
					$row->poi_additional_charges = unserialize($row->poi_additional_charges);
					$row->custom_fields = unserialize($row->custom_fields);
					$row->order_status = $this->_get_status_text($row->order_status);
					
					if($row->pickup_date!=""){
						$row->pickup_date = date("Y-m-d H:i:s", $row->pickup_date);
					}
					
					if($row->returntrip==1 && $row->return_wait_hr==-1)
					{
						$row->return_date = date("Y-m-d H:i:s", $row->return_date);
					}
				}
				$json_data['rows'] = $rows;
			}
		}
		echo json_encode($json_data);
		exit();
	}
	
	function get($data){
		
		$json_data = array('error' => 0, 'msg' => '', 'row' => array());
		
		if(empty($data->username) || empty($data->password)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Username or Password was not found!';
		}
		elseif($this->_is_user_allowed($data)===FALSE){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Public Users are not allowed to export orders!';
		}
		if(empty($data->order_number) || $data->order_number==0){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Order was not found!';
		}
		else {
			$config   = JFactory::getConfig();
			$siteOffset = $config->get('offset');
			date_default_timezone_set($siteOffset);
			$dtnow = JFactory::getDate('now', $siteOffset);
			
			$order_number = $data->order_number;
			$query = $this->database->getQuery(true);
 
			// Select the required fields from the table.
			$query->select('a.id AS order_id, a.order_number, a.names AS customer_name, a.gender, a.email, a.phone, a.booking_type,
				a.selpassengers AS passengers, a.selinfantseats AS infantseats, a.selchildseats AS chseats, a.selboosterseats AS boosterseats,
				a.selluggage AS suitcases, a.hourly_hr, a.hourly_min,
				a.PickupAddr1 AS pickup_additional_information, a.PickupAddr4 AS dropoff_additional_information, a.message AS customer_note,
				a.begin AS pickup, a.stops, a.end AS dropoff, a.datetime1 AS pickup_date, a.returntrip, a.return_wait_hr, a.return_wait_discount,
				a.datetime2 AS return_date, a.duration, a.duration_text, a.sub_total, a.flat_cost, a.percentage_cost, a.cprice AS order_total, a.poi_additional_charges,
				a.extras AS custom_fields, a.state AS order_status, a.created AS created_date, a.invoice_title');
			
			$query->from($this->database->quoteName('#__taxibooking_orders') . ' AS a');
			
			 // Join over the driver 
			$query->select('a.driver_id, u.name AS drivername')
				->join('LEFT', $this->database->quoteName('#__users') . ' AS u ON u.id = a.driver_id');
				
			// Join over the car 
			$query->select('a.vehicletype AS vehicle_id, car.title AS vehicle_title')
				->join('LEFT', $this->database->quoteName('#__taxibooking_cars') . ' AS car ON car.id = a.vehicletype');
				
			// Join over the payment methods 
			$query->select('pm.title AS payment_method')
				->join('LEFT', $this->database->quoteName('#__taxibooking_paymentmethods') . ' AS pm ON pm.id = a.payment');
				
			$query->where('a.order_number = ' . $this->database->Quote($order_number));
			
			$this->database->setQuery($query);
			$row = $this->database->loadObject();
			
			if($row)
			{
				$row->stops = $this->_get_stops_details($row->stops);
				$row->poi_additional_charges = unserialize($row->poi_additional_charges);
				$row->custom_fields = unserialize($row->custom_fields);
				$row->order_status = $this->_get_status_text($row->order_status);
				$row->pickup_date = date("Y-m-d H:i:s", $row->pickup_date);
				if($row->returntrip==1 && $row->return_wait_hr==-1)
				{
					$row->return_date = date("Y-m-d H:i:s", $row->return_date);
				}
				
				$json_data['row'] = $row;
			}
			else {
				$json_data['error'] = 1;
				$json_data['msg'] = 'Order was not found!';
			}
		}
		
		echo json_encode($json_data);
		exit();
	}
	
	function getAvailableCars($order_data)
	{
		$json_data = array('error' => 0, 'msg' => '', 'available_cars' => array());
		
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->toSql(true);
		
		$lang = JFactory::getLanguage();
		$lang->load('com_taxibooking');
		
		// Get the component configuration
		require_once (JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'booking.helper.php');
		$elsettings =  booking_helper::config();
		
		$allowed_booking_types = array('address', 'offers', 'hourly');
		
		if(empty($order_data)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Order data is empty!';
		}
		elseif(empty($order_data->username) || empty($order_data->password)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Username or Password was not found!';
		}
		elseif($this->_is_user_allowed($order_data)===FALSE){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Public Users are not allowed to export orders!';
		}
		elseif(empty($order_data->booking_type) || !in_array($order_data->booking_type, $allowed_booking_types)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Booking Type must be either address or offers or hourly!';
		}
		elseif($order_data->booking_type!='hourly' && (empty($order_data->pickup) || empty($order_data->pickup_coords))){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Pickup is not defined!';
		}
		elseif($order_data->booking_type!='hourly' && (empty($order_data->dropoff) || empty($order_data->dropoff_coords))){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Dropoff is not defined!';
		}
		elseif(empty($order_data->pickup_date)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Pickup Date is not defined!';
		}
		elseif(booking_helper::calculate_time_difference($dtnow, $order_data->pickup_date, 'hr') < $elsettings->restrict_time)
		{
			$json_data['error'] = 1;
			$json_data['msg'] = $order_data->pickup_date . ' ('.JText::sprintf('INSUFFICIENT_TIME', $elsettings->restrict_time).')';
		}
		elseif(empty($order_data->adultseats) || $order_data->adultseats==0){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Passengers is not defined!';
		}
		else {
			$booking_type 	= $order_data->booking_type;
			$pickup 	= !empty($order_data->pickup) ? $order_data->pickup : '';
			$pickup_coords 	= !empty($order_data->pickup_coords) ? $order_data->pickup_coords : array();
			$dropoff 	= !empty($order_data->dropoff) ? $order_data->dropoff : '';
			$dropoff_coords = !empty($order_data->dropoff_coords) ? $order_data->dropoff_coords : array();
			$route_from 	= !empty($order_data->route_from) ? $order_data->route_from : 0;
			$route_to 	= !empty($order_data->route_to) ? $order_data->route_to : 0;
			$route_swapped 	= !empty($order_data->route_swapped) ? $order_data->route_swapped : 0;
			$adultseats 	= $order_data->adultseats;
			$suitcases 	= !empty($order_data->suitcases) ? $order_data->suitcases : 0;
			$boosterseats 	= !empty($order_data->boosterseats) ? $order_data->boosterseats : 0;
			$infantseats 	= !empty($order_data->infantseats) ? $order_data->infantseats : 0;
			$chseats 	= !empty($order_data->childseats) ? $order_data->childseats : 0;
			$extras 	= !empty($order_data->extras) ? $order_data->extras : array();
			$hourly_hr 	= !empty($order_data->hourly_hr) ? $order_data->hourly_hr : 0;
			$hourly_min 	= !empty($order_data->hourly_min) ? $order_data->hourly_min : 0;
			$returnjurney 	= !empty($order_data->returnjurney) ? $order_data->returnjurney : 0;
			
			$poi_id = booking_helper::get_place_field(JFilterOutput::stringURLSafe($pickup), 'id');
			if($poi_id!="") // user chose POI
			{
				if($booking_type=='address')
				{
					$pickup_poi = $poi_id;
				}
				elseif($booking_type=='offers')
				{
					$route_from = $poi_id;
				}
			}
			else { // user chose google address
				$pickup_poi = 0;
				$route_from = 0;
			}
			
			$poi_id = booking_helper::get_place_field(JFilterOutput::stringURLSafe($dropoff), 'id');
			if($poi_id!="") // user chose POI
			{
				if($booking_type=='address')
				{
					$dropoff_poi = $poi_id;
				}
				elseif($booking_type=='offers')
				{
					$route_to = $poi_id;
				}
			}
			else { // user chose google address
				$dropoff_poi = 0;
				$route_to = 0;
			}
			
			if ($booking_type!='hourly')
			{
				$distance = 0;
				$duration = '';
				list($distance,$duration_seconds,$gapi_status,$gapi_msg) = booking_helper::calculateDistance($order_data->pickup_coords[0], $order_data->pickup_coords[1], $order_data->dropoff_coords[0], $order_data->dropoff_coords[1],$elsettings->distance_unit);
			    
				if($gapi_status=="OK")
				{
					if($distance==0)
					{
						$json_data['error'] = 1;
						$json_data['msg'] = JText::_('SESSION_EXPIRED');
					}
					else
					{
						$distance = number_format($distance,2);
					}
				}
				elseif ($gapi_status=="ZERO_RESULTS") {
					//indicates that the geocode was successful but returned no results. This may occur if the geocode was passed a non-existent address or a latlng in a remote location.
					$json_data['error'] = 1;
					$json_data['msg'] = 'The geocode was successful but returned no results. This may occur if the geocoder was passed a non-existent address.';
				}
				elseif ($gapi_status=="OVER_QUERY_LIMIT") {
					//indicates that you are over your quota of geocode requests against the google api
					$json_data['error'] = 1;
					$json_data['msg'] = $gapi_msg;
				}
				elseif ($gapi_status=="REQUEST_DENIED") {
					//indicates that your request was denied, generally because of lack of a sensor parameter.
					$json_data['error'] = 1;
					$json_data['msg'] = $gapi_msg;
				}
				elseif ($gapi_status=="INVALID_REQUEST") {
					//generally indicates that the query (address or latlng) is missing.
					$json_data['error'] = 1;
					$json_data['msg'] = 'The query (address or latlng) is missing.';
				}
				else {
					$json_data['error'] = 1;
					$json_data['msg'] = $gapi_msg;
				}
				
				if($gapi_status!="OK" || $distance==0){
					echo json_encode($json_data);
					exit();
				}
			}
			
			$price = 0;
			
			$booking_data = array('booking_type' => $booking_type,
						'pickup_poi' => $pickup_poi,
						'dropoff_poi' => $dropoff_poi,
						'route_from' => $route_from,
						'route_to' => $route_to,
						'adultseats' => $adultseats,
						'suitcases' => $suitcases,
						'boosterseats' => $boosterseats,
						'infantseats' => $infantseats,
						'chseats' => $chseats
					);
			
			// calculate extras price
			list($selected_extras, $total_extra_price) = booking_helper::process_extras($extras);
			
			$separate_car_price = 0;
			$route_price = 0;
			$fixed_car_prices = '';
			if($booking_type=='offers' && $route_from > 0 && $route_to > 0)  // customer selected fixed route
			{
			    $query = $this->database->getQuery(true);
			    $query->select('price, separate_car_price, car_prices');
			    $query->from('#__taxibooking_routes');
			    
			    if($route_swapped==1){ // if route swapped, then interchange the route
				$query->where('route_from = '.(int) $route_to.' AND route_to = '.(int) $route_from);
			    }
			    else {
				$query->where('route_from = '.(int) $route_from.' AND route_to = '.(int) $route_to);
			    }
			    $query->where('published = 1');
			    $this->database->setQuery((string)$query);
			    $route_obj = $this->database->loadObject();
			    
			    $route_price = $route_obj->price;
			    $separate_car_price = $route_obj->separate_car_price;
			    $fixed_car_prices = $route_obj->car_prices;
			    
			    // check whether this fixed route has separate car price enabled and has a set of car with price
			    // if yes, the just show the list of cars with price - no calculation requried
			    // if not, then route price will be considered
			    if($separate_car_price==0)  
			    {
				$price += $route_price;
			    }
			}
			
			// collect additional charge for POIs if booking type is not HOURLY_HIRE
			if($booking_type!='hourly')
			{
				$poi_additional_charges = booking_helper::get_poi_additional_charge($booking_data);
				$price += $poi_additional_charges['total_additional_price'];
			}
			
			if ($infantseats > 0) {
			    $price += $infantseats * $elsettings->infant_seat_price;
			}
			if ($chseats > 0) {
			    $price += $chseats * $elsettings->child_seat_price;
			}
			if ($boosterseats > 0) {
			    $price += $boosterseats * $elsettings->booster_seat_price;
			}
			    
			if($booking_type=='offers' && $separate_car_price==1)
			{
			    $cars = booking_helper::get_fixed_route_car_set($fixed_car_prices);
			}
			else // usual car price calculation for POI and address
			{
			    // now list cars
			    $query = $this->database->getQuery(true);
			    $query->select('*');
			    $query->from('#__taxibooking_cars');
			    $query->where('published = "1"');
		
			    if($adultseats > 0)
			    {
				$query->where('passenger_no >= '.(int)$adultseats);
			    }
			    if($suitcases > 0)
			    {
				$query->where('suitcase_no >= '.(int)$suitcases);
			    }
			    if($boosterseats > 0)
			    {
				$query->where('booster_seat_no >= '.(int)$boosterseats);
			    }
			    if($infantseats > 0)
			    {
				$query->where('infant_seat_no >= '.(int)$infantseats);
			    }
			    if($chseats > 0)
			    {
				$query->where('child_seat_no  >= '.(int)$chseats);
			    }
			    
			    if($booking_type=='hourly')
			    {
				$query->where('hourly_hire_enabled  = 1');
				$query->where('hourly_hire_min_hr <= '.($hourly_hr+($hourly_min/100)) );
				$query->where('hourly_hire_max_hr >= '.($hourly_hr+($hourly_min/100)) );
			    }
			    
			    // adult + booster + child + infant must be less than the maximum passenger seats for a car
			    $total_passengers = (int)$adultseats+(int)$infantseats+(int)$boosterseats+(int)$chseats;
			    
				//Hourly and Shuttle have no use of Min passengers.
				if($booking_type!='hourly'){
					$query->where('min_passenger_no <= '.$total_passengers);
				}
				
			    $query->where('passenger_no >= '.$total_passengers);
			    
			    $query->order('price ASC');
			    $this->database->setQuery((string)$query);
			    $cars = $this->database->loadObjectList();
			}
			
			$order_date_time_str = strtotime($order_data->pickup_date);
			
			// consider base
			list($base_pickup_distance,
			     $base_pickup_duration,
			     $base_pickup_price,
			     $base_pickup_price_calc,
			     $dropoff_base_distance,
			     $dropoff_base_duration,
			     $dropoff_base_price,
			     $dropoff_base_price_calc) = booking_helper::considerBase($elsettings, $booking_type);
			
			if(!empty($cars))
			{
			    foreach($cars as $key => $car)
			    {
				// first check today is a blocked date or not for this car
				if(booking_helper::check_car_block_dates($car, $order_date_time_str)===FALSE){
				    unset($cars[$key]);
				}
				elseif(booking_helper::check_todays_availability($car, $order_date_time_str)===FALSE) { // check todays opening/closing time and compare with current time
				    unset($cars[$key]);
				}
				elseif(booking_helper::check_car_previous_bookings($car, $order_date_time_str)===FALSE) { // check this car previous booking journey
				    unset($cars[$key]);
				}
				else {
					$car_price = 0;
				
					// every car has it's own price model, but that own price will not be applied for fixed route
					if($booking_type!='offers')
					{
						if($booking_type=='hourly')
						{
							$car_price += $car->hourly_rate*($hourly_hr+($hourly_min/60));
						}
						else {
							if($car->price_calculation_cumulative==1 || $elsettings->price_calculation_cumulative==1) // if car has cumulative price enabled
							{
								list($cum_car_price,$unit_price,$price_calculation_debug_str) = booking_helper::get_car_cumulative_price($car, $distance);
								$car_price += $cum_car_price;
							}
							else {  // non-cumulative price calculation
							    $unit_price = booking_helper::get_car_unit_price($car, $distance);
							    $car_price += $distance * $unit_price;    
							}
							
							// we have 2 conditions for min distance
							// first if minimum distance > 0, price will be min.price if journey distance is less than min distance
							// if Minimum distance 0 or empty, then Price will be Min price if calculated price is less than Min price
							if((float)$elsettings->minmil > 0){
							    if($distance < (float)$elsettings->minmil && $car_price < (float)$elsettings->minprice){
								    $car_price = (float)$elsettings->minprice;
							    }
							}
							else {
							    if ((float)$elsettings->minprice > 0 && $car_price < (float)$elsettings->minprice){
								    $car_price = (float)$elsettings->minprice;
							    }
							}
						}
					}
					
					$car_price += $elsettings->cost_per_call; // initial call charge
					
					// add car flat price
					if($booking_type!='hourly')
					{
					    $car_price += $car->price;
					}
					//echo '<br>car price >>'.$car_price;
					
					// waypoint time charge
					if($elsettings->stops_charge_per_min!="")
					{
						$total_waypoint_duration = 0;
						$car_price += $total_waypoint_duration*$elsettings->stops_charge_per_min;
					}
					//echo '<br>waypoints >>'.$car_price;
					
					// add seats + poi additional charge
					$car_price += $price;
					//echo '<br>seats + poi >>'.$car_price;
					
					// add extra price
					$car_price += $total_extra_price;
					//echo '<br>extra >>'.$car_price;
					
					// add base price
					$car_price += ($base_pickup_price+$dropoff_base_price);
					//echo '<br>base >>'.$car_price;
					
					// calculate distance sectors discounts for Address booking only
					$distance_sector_outbound_discount = 0;
					$distance_sector_return_discount = 0;
					if($booking_type=='address'){
						list($distance_sector_outbound_discount,$distance_sector_return_discount) = booking_helper::get_distance_sector_discounts($car, $elsettings, $distance);
						if($distance_sector_outbound_discount!=0){
							$car_price -= $distance_sector_outbound_discount;
						}
					}
					
					if ($returnjurney == 1)
					{
						// additional car type charge will not be applied for return journey
						$outbound_price = $car_price;
						if($booking_type!='hourly') {
							$outbound_price -= $car->price;
						}
						$discounts = array('return_wait_discount' => $order_data->return_wait_discount,
								   'distance_sector_return_discount' => $distance_sector_return_discount
								   );
						list($return_price,$return_discounts,$return_discounts_calc) = booking_helper::calculate_return_price($outbound_price, $elsettings, $discounts);
						//echo '<br>return >>'.$return_price;
						$car_price += $return_price;
					}
					
					// round price based on configuration
					$car_price = booking_helper::round_price($car_price, $elsettings);
					$car->car_price = $car_price;
				}
			    }
			}
			
			// sort car
			$sort_by = 'car_price';
			$sort_dir = 'ASC';
			
			require_once (JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'helpers'.DS.'sort_helper.php');
			$cars = sort_stack($cars, $sort_by, $sort_dir);
			
			// now generate car list
			$available_cars = array();
			if(!empty($cars))
			{
			    foreach($cars as $car)
			    {
				$available_cars[] = array('id' => $car->id,
							  'title' => $car->title,
							  'image' => ($car->image!="") ? JURI::base().$car->image : '',
							  'text' => strip_tags($car->text),
							  'passenger' => $car->passenger_no,
							  'price' => $car->car_price
							  );
				}
			}
			else {
				$json_data['err'] = 1;
				$json_data['msg'] = JText::_('COM_TAXIBOOKING_NO_VEHICLE_DATETIME');
			}
		    
			$json_data['available_cars'] = $available_cars;
		}
		
		echo json_encode($json_data);
		exit();
	}
	
	function save($order_data)
	{
		$json_data = array('error' => 0, 'msg' => '');
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->toSql(true);
		
		$lang = JFactory::getLanguage();
		$lang->load('com_taxibooking');
		
		// Get the component configuration
		require_once (JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'booking.helper.php');
		$elsettings =  booking_helper::config();
		
		$allowed_booking_types = array('address', 'offers', 'hourly');
		
		if(empty($order_data)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Order data is empty!';
		}
		elseif(empty($order_data->username) || empty($order_data->password)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Username or Password was not found!';
		}
		elseif($this->_is_user_allowed($order_data)===FALSE){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Public Users are not allowed to export orders!';
		}
		elseif(empty($order_data->booking_type) || !in_array($order_data->booking_type, $allowed_booking_types)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Booking Type must be either address or offers or hourly!';
		}
		elseif($order_data->booking_type!='hourly' && (empty($order_data->pickup) || empty($order_data->pickup_coords))){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Pickup is not defined!';
		}
		elseif($order_data->booking_type!='hourly' && (empty($order_data->dropoff) || empty($order_data->dropoff_coords))){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Dropoff is not defined!';
		}
		elseif(empty($order_data->pickup_date)){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Pickup Date is not defined!';
		}
		elseif(booking_helper::calculate_time_difference($dtnow, $order_data->pickup_date, 'hr') < $elsettings->restrict_time) {
			$json_data['error'] = 1;
			$json_data['msg'] = $order_data->pickup_date . ' ('.JText::sprintf('INSUFFICIENT_TIME', $elsettings->restrict_time).')';
		}
		elseif(empty($order_data->adultseats) || $order_data->adultseats==0){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Passengers is not defined!';
		}
		elseif(empty($order_data->vehicle_id) || $order_data->vehicle_id==0){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Vehicle is not defined!';
		}
		elseif(booking_helper::check_car_block_dates($order_data->vehicle_id, strtotime($order_data->pickup_date))===FALSE
		       || booking_helper::check_todays_availability($order_data->vehicle_id, strtotime($order_data->pickup_date))===FALSE
		       || booking_helper::check_car_previous_bookings($order_data->vehicle_id, strtotime($order_data->pickup_date))===FALSE
		       ){
			$json_data['error'] = 1;
			$json_data['msg'] = 'Vehicle is not available on this pickup date!';
		}
		else {
			$booking_type 	= $order_data->booking_type;
			$pickup 	= !empty($order_data->pickup) ? $order_data->pickup : '';
			$pickup_coords 	= !empty($order_data->pickup_coords) ? $order_data->pickup_coords : array();
			$dropoff 	= !empty($order_data->dropoff) ? $order_data->dropoff : '';
			$dropoff_coords = !empty($order_data->dropoff_coords) ? $order_data->dropoff_coords : array();
			$route_from 	= !empty($order_data->route_from) ? $order_data->route_from : 0;
			$route_to 	= !empty($order_data->route_to) ? $order_data->route_to : 0;
			$route_swapped 	= !empty($order_data->route_swapped) ? $order_data->route_swapped : 0;
			$pickup_date 	= !empty($order_data->pickup_date) ? $order_data->pickup_date : '';
			$stops 		= !empty($order_data->stops) ? $order_data->stops : array();
			
			$adultseats 	= $order_data->adultseats;
			$suitcases 	= !empty($order_data->suitcases) ? $order_data->suitcases : 0;
			$boosterseats 	= !empty($order_data->boosterseats) ? $order_data->boosterseats : 0;
			$infantseats 	= !empty($order_data->infantseats) ? $order_data->infantseats : 0;
			$chseats 	= !empty($order_data->childseats) ? $order_data->childseats : 0;
			$extras 	= !empty($order_data->extras) ? $order_data->extras : array();
			$hourly_hr 	= !empty($order_data->hourly_hr) ? $order_data->hourly_hr : 0;
			$hourly_min 	= !empty($order_data->hourly_min) ? $order_data->hourly_min : 0;
			$returnjurney 	= !empty($order_data->returnjurney) ? $order_data->returnjurney : 0;
			$return_date 	= !empty($order_data->return_date) ? $order_data->return_date : '';
			$return_wait_hr = !empty($order_data->return_wait_hr) ? $order_data->return_wait_hr : -1;
			$return_wait_discount 	= !empty($order_data->return_wait_discount) ? $order_data->return_wait_discount : 0;
			
			$customer_name 	= !empty($order_data->customer_name) ? $order_data->customer_name : '';
			$email 		= !empty($order_data->email) ? $order_data->email : '';
			$phone 		= !empty($order_data->phone) ? $order_data->phone : '';
			$pickup_additional_information 	= !empty($order_data->pickup_additional_information) ? $order_data->pickup_additional_information : '';
			$dropoff_additional_information	= !empty($order_data->dropoff_additional_information) ? $order_data->dropoff_additional_information : '';
			$flat_cost 	= !empty($order_data->flat_cost) ? $order_data->flat_cost : 0;
			$percentage_cost= !empty($order_data->percentage_cost) ? $order_data->percentage_cost : 0;
			$customer_note 	= !empty($order_data->customer_note) ? $order_data->customer_note : '';
			
			$poi_id = booking_helper::get_place_field(JFilterOutput::stringURLSafe($pickup), 'id');
			if($poi_id!="") // user chose POI
			{
				if($booking_type=='address') {
					$pickup_poi = $poi_id;
				}
				elseif($booking_type=='offers') {
					$route_from = $poi_id;
				}
			}
			else { // user chose google address
				$pickup_poi = 0;
				$route_from = 0;
			}
			
			$poi_id = booking_helper::get_place_field(JFilterOutput::stringURLSafe($dropoff), 'id');
			if($poi_id!="") // user chose POI
			{
				if($booking_type=='address') {
					$dropoff_poi = $poi_id;
				}
				elseif($booking_type=='offers') {
					$route_to = $poi_id;
				}
			}
			else { // user chose google address
				$dropoff_poi = 0;
				$route_to = 0;
			}
			
			if ($booking_type!='hourly')
			{
				$distance = 0;
				$duration = '';
				list($distance,$duration_seconds,$gapi_status,$gapi_msg) = booking_helper::calculateDistance($order_data->pickup_coords[0], $order_data->pickup_coords[1], $order_data->dropoff_coords[0], $order_data->dropoff_coords[1],$elsettings->distance_unit);
			    
				if($gapi_status=="OK")
				{
					if($distance==0) {
						$json_data['error'] = 1;
						$json_data['msg'] = JText::_('SESSION_EXPIRED');
					}
					else {
						$distance = number_format($distance,2);
						$duration_text = booking_helper::secondsToTime($duration_seconds);
					}
				}
				elseif ($gapi_status=="ZERO_RESULTS") {
					//indicates that the geocode was successful but returned no results. This may occur if the geocode was passed a non-existent address or a latlng in a remote location.
					$json_data['error'] = 1;
					$json_data['msg'] = 'The geocode was successful but returned no results. This may occur if the geocoder was passed a non-existent address.';
				}
				elseif ($gapi_status=="OVER_QUERY_LIMIT") {
					//indicates that you are over your quota of geocode requests against the google api
					$json_data['error'] = 1;
					$json_data['msg'] = $gapi_msg;
				}
				elseif ($gapi_status=="REQUEST_DENIED") {
					//indicates that your request was denied, generally because of lack of a sensor parameter.
					$json_data['error'] = 1;
					$json_data['msg'] = $gapi_msg;
				}
				elseif ($gapi_status=="INVALID_REQUEST") {
					//generally indicates that the query (address or latlng) is missing.
					$json_data['error'] = 1;
					$json_data['msg'] = 'The query (address or latlng) is missing.';
				}
				else {
					$json_data['error'] = 1;
					$json_data['msg'] = $gapi_msg;
				}
				
				if($gapi_status!="OK" || $distance==0){
					echo json_encode($json_data);
					exit();
				}
			}
			
			$price = 0;
			
			$booking_data = array('booking_type' => $booking_type,
						'pickup_poi' => $pickup_poi,
						'dropoff_poi' => $dropoff_poi,
						'route_from' => $route_from,
						'route_to' => $route_to,
						'adultseats' => $adultseats,
						'suitcases' => $suitcases,
						'boosterseats' => $boosterseats,
						'infantseats' => $infantseats,
						'chseats' => $chseats
					);
			
			// calculate extras price
			list($selected_extras, $total_extra_price) = booking_helper::process_extras($extras);
			
			$separate_car_price = 0;
			$route_price = 0;
			$fixed_car_prices = '';
			if($booking_type=='offers' && $route_from > 0 && $route_to > 0)  // customer selected fixed route
			{
				$query = $this->database->getQuery(true);
				$query->select('price, separate_car_price, car_prices');
				$query->from('#__taxibooking_routes');
				
				if($route_swapped==1){ // if route swapped, then interchange the route
				    $query->where('route_from = '.(int) $route_to.' AND route_to = '.(int) $route_from);
				}
				else {
				    $query->where('route_from = '.(int) $route_from.' AND route_to = '.(int) $route_to);
				}
				$query->where('published = 1');
				$this->database->setQuery((string)$query);
				$route_obj = $this->database->loadObject();
				
				$route_price = $route_obj->price;
				$separate_car_price = $route_obj->separate_car_price;
				$fixed_car_prices = $route_obj->car_prices;
				
				// check whether this fixed route has separate car price enabled and has a set of car with price
				// if yes, the just show the list of cars with price - no calculation requried
				// if not, then route price will be considered
				if($separate_car_price==0)  
				{
				    $price += $route_price;
				}
			}
			
			// collect additional charge for POIs if booking type is not HOURLY_HIRE
			$poi_additional_charges = array();
			if($booking_type!='hourly')
			{
				$poi_additional_charges = booking_helper::get_poi_additional_charge($booking_data);
				$price += $poi_additional_charges['total_additional_price'];
			}
			
			if ($infantseats > 0) {
				$price += $infantseats * $elsettings->infant_seat_price;
			}
			if ($chseats > 0) {
				$price += $chseats * $elsettings->child_seat_price;
			}
			if ($boosterseats > 0) {
				$price += $boosterseats * $elsettings->booster_seat_price;
			}
			
			if($booking_type=='offers' && $separate_car_price==1)
			{
				$cars = booking_helper::get_fixed_route_car_set($fixed_car_prices);
			}
			else // usual car price calculation for POI and address
			{
				// now list cars
				$query = $this->database->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_cars');
				$query->where('published = "1"');
		    
				if($adultseats > 0)
				{
					$query->where('passenger_no >= '.(int)$adultseats);
				}
				if($suitcases > 0)
				{
					$query->where('suitcase_no >= '.(int)$suitcases);
				}
				if($boosterseats > 0)
				{
					$query->where('booster_seat_no >= '.(int)$boosterseats);
				}
				if($infantseats > 0)
				{
					$query->where('infant_seat_no >= '.(int)$infantseats);
				}
				if($chseats > 0)
				{
					$query->where('child_seat_no  >= '.(int)$chseats);
				}
				
				if($booking_type=='hourly')
				{
					$query->where('hourly_hire_enabled  = 1');
					$query->where('hourly_hire_min_hr <= '.($hourly_hr+($hourly_min/100)) );
					$query->where('hourly_hire_max_hr >= '.($hourly_hr+($hourly_min/100)) );
				}
				
				// adult + booster + child + infant must be less than the maximum passenger seats for a car
				$total_passengers = (int)$adultseats+(int)$infantseats+(int)$boosterseats+(int)$chseats;
				$query->where('passenger_no >= '.$total_passengers);
				
				$query->order('price ASC');
				$this->database->setQuery((string)$query);
				$cars = $this->database->loadObjectList();
			}
			
			$order_date_time_str = strtotime($order_data->pickup_date);
			$orderreturn_date_time_str = strtotime($order_data->return_date);
			
			// consider base
			list($base_pickup_distance,
			     $base_pickup_duration,
			     $base_pickup_price,
			     $dropoff_base_distance,
			     $dropoff_base_duration,
			     $dropoff_base_price) = booking_helper::considerBase($elsettings, $booking_type);
			
			if(!empty($cars))
			{
				$vehicle_found = false;	
				foreach($cars as $key => $car)
				{
					if($car->id == $order_data->vehicle_id)
					{
						$car_price = 0;
			
						// every car has it's own price model, but that own price will not be applied for fixed route
						if($booking_type!='offers')
						{
							if($booking_type=='hourly')
							{
								$car_price += $car->hourly_rate*($hourly_hr+($hourly_min/60));
							}
							else {
								if($car->price_calculation_cumulative==1 || $elsettings->price_calculation_cumulative==1) // if car has cumulative price enabled
								{
								    $car_price += booking_helper::get_car_cumulative_price($car, $distance);
								}
								else {  // non-cumulative price calculation
								    $unit_price = booking_helper::get_car_unit_price($car, $distance);
								    $car_price += $distance * $unit_price;    
								}
							}
						}
						//echo '<br>'.$car->title.' distance >>'.$car_price;
						
						// minimum. price comparison
						if ($elsettings->minprice > 0 && $car_price < $elsettings->minprice)
						{
							$car_price = $elsettings->minprice;
						}
						
						$car_price += $elsettings->cost_per_call; // initial call charge
						//echo '<br>initial >>'.$car_price;
						
						// add car flat price
						if($booking_type!='hourly')
						{
							$car_price += $car->price;
						}
						//echo '<br>car price >>'.$car_price;
						
						// waypoint time charge
						if($elsettings->stops_charge_per_min!="")
						{
							$total_waypoint_duration = 0;
							$car_price += $total_waypoint_duration*$elsettings->stops_charge_per_min;
						}
						//echo '<br>waypoints >>'.$car_price;
						
						// add seats + poi additional charge
						$car_price += $price;
						//echo '<br>seats + poi >>'.$car_price;
						
						// add extra price
						$car_price += $total_extra_price;
						//echo '<br>extra >>'.$car_price;
						
						// add base price
						$car_price += ($base_pickup_price+$dropoff_base_price);
						//echo '<br>base >>'.$car_price;
						
						if ($returnjurney == 1) {
							if(!empty($order_data->return_wait_discount) && $order_data->return_wait_discount>0){
								$return_price = (1-$order_data->return_wait_discount/100)*$car_price;
							}
							else {
								$return_price = (1-$elsettings->discount/100)*$car_price;
							}
						    
							$car_price += $return_price;
						}
						//echo '<br>return >>'.$car_price;
						
						$car_price = round($car_price);
						$car->car_price = $car_price;
						
						$vehicle_found = $car;
					}
				}
				
				// if vehicle found, lets store new order entry
				if($vehicle_found!==false)
				{
					// total cost
					$grand_total = $vehicle_found->car_price+$flat_cost+$percentage_cost;
					
					$order = new stdClass();
					$order->order_number = uniqid();
					$order->names = $customer_name;
					$order->gender = '';
					$order->email = $email;
					$order->phone = $phone;
					$order->booking_type = $booking_type;
					$order->returntrip = $returnjurney;
					$order->return_wait_hr = $return_wait_hr;
					$order->return_wait_discount = $return_wait_discount;
					$order->sub_total = $vehicle_found->car_price;
					$order->flat_cost = $flat_cost;
					$order->percentage_cost = $percentage_cost;
					$order->poi_additional_charges = serialize($poi_additional_charges);
					$order->cprice = $grand_total;
					$order->extras = serialize($selected_extras);
					$order->selpassengers = $adultseats;
					$order->selinfantseats = $infantseats;
					$order->selchildseats = $chseats;
					$order->selboosterseats = $boosterseats;
					$order->selluggage = $suitcases;
					$order->hourly_hr = $hourly_hr;
					$order->hourly_min = $hourly_min;
					$order->PickupAddr1 = $pickup_additional_information;
					$order->PickupAddr4 = $dropoff_additional_information;
					$order->datetime1 = strtotime($order_data->pickup_date);
					$order->datetime2 = ($order_data->return_date!="") ? strtotime($order_data->return_date) : "";
					$order->duration = $duration_seconds;
					$order->duration_text = $duration_text;            
					$order->message = $customer_note;
					$order->begin = $pickup;
					$order->stops = serialize($stops);
					$order->end = $dropoff;
					$order->state = '-2';
					$order->driver_id = '';
					$order->payment = 1;
					$order->vehicletype = $order_data->vehicle_id;
					$order->created = $now;
			       
					if (!$this->database->insertObject('#__taxibooking_orders', $order)) {
					    exit($this->database->stderr());
					}
					$order_id = $this->database->insertid();
					
					// store order vehicle booking time data if track_availability is set YES for the booked car
					$track_availability = booking_helper::get_car_field($vehicletype, 'track_availability');
					if((int)$track_availability==1)
					{
					    $booking_time_start = $order_date_time_str;
					    $booking_time_end = $order_date_time_str+$duration_seconds;
					    
					    $booking_time_end += (int) $elsettings->time_after_each_booking;
					    
					    if($elsettings->calculate_base_pickup==1)
					    {
						$base_pickup_duration_seconds = $base_pickup_duration;
						$booking_time_start -= $base_pickup_duration_seconds;
					    }
					    if($elsettings->calculate_dropoff_base==1)
					    {
						$dropoff_base_duration_seconds = $dropoff_base_duration;
						$booking_time_end += $dropoff_base_duration_seconds;
					    }
					    
					    $order_car = new stdClass();
					    $order_car->order_id = $order_id;
					    $order_car->vehicle_id = $vehicletype;
					    $order_car->booking_time_start = $booking_time_start;
					    $order_car->booking_time_end = $booking_time_end;
					    $order_car->created_date = $now;
					    
					    if (!$this->database->insertObject('#__taxibooking_order_car_rel', $order_car)) {
						exit($this->database->stderr());
					    }
					    
					    // enter another entry for return journey
					    if($returntrip==1 && $orderreturn_date_time_str!="")
					    {
						$booking_time_start = $orderreturn_date_time_str;
						$booking_time_end = $orderreturn_date_time_str+$duration_seconds;
						
						$order_car = new stdClass();
						$order_car->order_id = $order_id;
						$order_car->vehicle_id = $vehicletype;
						$order_car->booking_time_start = $booking_time_start;
						$order_car->booking_time_end = $booking_time_end;
						$order_car->created_date = $now;
						
						if (!$this->database->insertObject('#__taxibooking_order_car_rel', $order_car)) {
						    exit($this->database->stderr());
						}
					    }
					}
					
					// trigger order submit action for payment gateways
					$order = booking_helper::get_order_by_id($order_id);
					JPluginHelper::importPlugin('tbpayment');
					$dispatcher = JDispatcher::getInstance();
					$returnValues = $dispatcher->trigger('plgTbOrderSubmit', array($order));
			    
					$this->_sendMailDetailsToOwner($order_id);
					
					$json_data['msg'] = 'OrderId - '.$order_id;
				}
			}
		}
		echo json_encode($json_data);
		exit();
	}
	
	/**
	* Send Email to owner of the order
	*
	* @access	public
	* @since	1.0
	*/
	private function _sendMailDetailsToOwner($order_id)
	{
		//initialise variables
		$app = JFactory::getApplication();
		$site_name = $app->getCfg('sitename');
		$elsettings =  booking_helper::config();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();
	
		// get the order info
		$query = $this->database->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_orders');
		$query->where('id = '.(int)$order_id);
		$this->database->setQuery((string)$query);
		$row_queue = $this->database->loadObject();
		
		if ($row_queue->state == '1') {
		    $row_queue->order_status .= '<span style="color:green;">'.JText::_('NEW_ORDER_STATUS_ACCEPTED').'</span>';
		} elseif ($row_queue->state == '0') {
		    $row_queue->order_status .= '<span style="color:red;">'.JText::_('NEW_ORDER_STATUS_REJECTED').'</span>';
		} elseif ($row_queue->state == '-1') {
		    $row_queue->order_status .= '<span style="color:yellow;">'.JText::_('NEW_ORDER_STATUS_ARCHIVED').'</span>';
		} elseif ($row_queue->state == '-2') {
		    $row_queue->order_status .= '<span style="color:green;">'.JText::_('NEW_ORDER_STATUS_WAITING').'</span>';
		}
		
		$payment_data = '';
		JPluginHelper::importPlugin('tbpayment');
		$_dispatcher = JDispatcher::getInstance();
		$_returnValues = $_dispatcher->trigger('plgTbOnShowOrderEmailsInvoice',array( $row_queue->id,$row_queue->payment));
		foreach ($_returnValues as $_returnValue) {
			if ($_returnValue !== null) {
				$payment_data .= $_returnValue;
			}
		}
		
		// glean language specific header and footer info
		$header_info = $elsettings->header_info;
		$header_info = $header_info[$lang_tag];
		
		$contact_info = $elsettings->contact_info;
		$contact_info = $contact_info[$lang_tag];
		
		// now get the email template
		ob_start();
		include( JPATH_COMPONENT.DS .'templates'.DS.'order_emails'.DS.'confirmation_email.tpl.php' );
		$mailbody = ob_get_contents();
		ob_end_clean();
	
		// now send the email
		$mail =  JFactory::getMailer();
		$jconfig = new JConfig();
		$MailFrom = $jconfig->mailfrom;
		$FromName = JText::sprintf("NEW_ORDER_EMAIL_YOUR_WEBSITE_NAME", $jconfig->fromname);
		$mail->setSender(array($MailFrom, $FromName));
		$mail->setSubject(JText::sprintf('NEW_ORDER_EMAIL_SUBJECT_ORDER_NUMBER', $order_id));
		$mail->setBody($mailbody);
		$mail->IsHTML(true);
		$mail->addRecipient($row_queue->email);
	
		$sent = $mail->Send();
		
		// send emails to all admin
		$query = 'SELECT u.id, u.email, u.name' .
			' FROM #__users AS u' .
			' LEFT JOIN #__user_usergroup_map AS gu ON gu.user_id = u.id' .
			' WHERE (gu.group_id = 8 OR gu.group_id = 7) ' .
			' AND u.sendEmail = 1 AND u.block = 0';
		$this->database->setQuery($query);
		if (!$this->database->query()) {
		    JError::raiseError(500, $this->database->stderr(true));
		    return;
		}
		$adminRows = $this->database->loadObjectList();
	
		// send email notification to admins
		foreach ($adminRows as $adminRow) {
	
		    $mail =  JFactory::getMailer();
	
		    $mail->setSender(array($MailFrom, $FromName));
		    $mail->setSubject(JText::sprintf('NEW_ORDER_EMAIL_SUBJECT_ORDER_NUMBER', $order_id));
		    $mail->setBody($mailbody);
		    $mail->IsHTML(true);
	
		    $mail->addRecipient($adminRow->email);
	
		    $sent = $mail->Send();
		}
	
		return true;
	}
	
	private function _is_user_allowed($user)
	{
		// Get the component configuration
		require_once (JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'booking.helper.php');
		$elsettings =  booking_helper::config();
		$usergroups_allowed_import_orders = $elsettings->usergroups_allowed_import_orders;
		
		$query  = $this->database->getQuery(true)
			->select('id, password')
			->from('#__users')
			->where('username =' . $this->database->quote($user->username));
	 
		$this->database->setQuery($query);
		$result = $this->database->loadObject();
		
		if ($result)
		{
			$match = JUserHelper::verifyPassword($user->password, $result->password, $result->id);

                        if ($match === true)
                        {
                                $user = JFactory::getUser($result->id);
                                $user_groups = $user->get('groups');
                                
                                $temp = array_intersect($user_groups, $usergroups_allowed_import_orders);
                                if(!empty($temp)){
                                        return TRUE;
                                }
                                else {
                                        return FALSE;
                                }
                        }
                        else {
                                return FALSE;
                        }
		}
		else {
			return FALSE;
		}
	}

	private function _get_stops_details($stops_str)
	{
		$waypoints = unserialize($stops_str);
		$order_stops = array();
		for($i = 0; $i < count($waypoints); $i++){
			$order_stops[$i] = array('stop' => $waypoints[$i]['stop'],
					   'coords' => array($waypoints[$i]['stop_lat'], $waypoints[$i]['stop_lng']),
					   'stop_interval' => $waypoints[$i]['stop_interval']
					   );
		}
		
		return $order_stops;
	}
	
	private function _get_status_text($order_status)
	{
		if ($order_status == '1') {
			return 'Accepted';
		}
		else if ($order_status == '0') {
			return 'Rejected';
		}
		else if ($order_status == '-1') {
			return 'Archived';
		}
		else if ($order_status == '-2') {
			return 'Waiting';
		}
		else {
			return 'Unknown';
		}
	}
}
