<?php

defined ('_JEXEC') or die('Restricted access');

// Get the plugin library
jimport ('joomla.plugin.plugin');

abstract class tbPaymentPlugin extends JPlugin {
	
	protected $_vmpItable = 0;
	//the name of the table to store plugin internal data, like payment logs
	protected $_tablename = 0;
	protected $_tableId = 'id';
	//Name of the primary key of this table, for exampel virtuemart_calc_id or virtuemart_order_id
	protected $_tablepkey = 0;
	protected $_vmpCtable = 0;
	//the name of the table which holds the configuration like paymentmethods, shipmentmethods, customs
	protected $_configTable = 0;
	protected $_configTableFileName = 0;
	protected $_configTableClassName = 0;
	//id field of the config table
	protected $_idName = 0;
	//Name of the field in the configtable, which holds the parameters of the pluginmethod
	protected $_configTableFieldName = 0;
	protected $_loggable = FALSE;
	
	/**
	 * Constructor
	 *
	 * @param object $subject The object to observe
	 * @param array  $config  An array that holds the plugin configuration
	 * @since 1.5
	 */
	function __construct (& $subject, $config) {

		parent::__construct ($subject, $config);

		$this->_tablepkey = 'id'; //order_id';
		$this->_idName = 'id';
		$this->_configTable = '#__taxibooking_paymentmethods';
		$this->_configTableFieldName = 'payment_params';
		$this->_configTableFileName = 'paymentmethods';
		$this->_configTableClassName = 'TablePaymentmethods'; //TablePaymentmethods
		// 		$this->_configTableIdName = $this->_psType.'_jplugin_id';
		$this->_loggable = TRUE;
		$this->_tablename = '#__taxibooking_payment_plg_' . $this->_name;
		$this->_tableChecked = FALSE;
		
		$lang = JFactory::getLanguage();
		$lang->load('plg_tbpayment_' . $this->_name,JPATH_ADMINISTRATOR);
		$lang->load('com_taxibooking');
	}

	/**
	 * displayListFE
	 * This event is fired to display the pluginmethods
	 *
	 * @param integer $selected ID of the method selected
	 * @return boolean True on success, false on failures, null when this plugin was not selected.
	 * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
	 */
	public function displayListFE ($selected = 0, &$htmlIn) {
		
		$session =  JFactory::getSession();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();
		
		if ($this->getPluginMethods () === 0) {
			return FALSE;
		}

		$html = array();
		$method_name = 'payment_name';
		
		foreach ($this->methods as $method) {
			if ($this->checkConditions ($method, $session->get('price', 0))
			    && $this->checkLanguage ($method, $lang_tag)
			    ) {
				$methodSalesPrice = $this->calculateSalesPrice ($method, $session->get('price', 0));
				$method->$method_name = $this->renderPluginName ($method);
				$html[] = $this->getPluginHtml($method, $selected, $methodSalesPrice);
			}
		}
		if (!empty($html)) {
			$htmlIn[] = $html;
			return TRUE;
		}

		return FALSE;
	}
	
	/**
	 * Check if the active language are fulfilled for this payment method
	 *
	 */
	protected function checkLanguage ($method, $lang_tag) {

		if($method->language == "*" OR $method->language == $lang_tag){
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
	
	/**
	 * Fill the array with all plugins found with this plugin for the current vendor
	 *
	 * @return True when plugins(s) was (were) found for this vendor, false otherwise
	 */
	protected function getPluginMethods () {

		$db = JFactory::getDBO ();

		$select = 'SELECT  v.*, ';

		$extPlgTable = '#__extensions';
		$extField1 = 'extension_id';
		$extField2 = 'element';

		$select .= 'j.`' . $extField1 . '`,j.`name`, j.`type`, j.`element`, j.`folder`, j.`client_id`, j.`enabled`, j.`access`, j.`protected`, j.`manifest_cache`,
			j.`params`, j.`custom_data`, j.`system_data`, j.`checked_out`, j.`checked_out_time`, j.`state` ';

		$q = $select . ' FROM  `#__taxibooking_paymentmethods` as v ';
		$q .= ' LEFT JOIN `' . $extPlgTable . '` as j ON j.`' . $extField1 . '` =  v.`payment_plugin_id` ';
		$q .= ' WHERE v.`published` = "1" AND j.`folder` = "tbpayment" AND j.`' . $extField2 . '` = "' . $this->_name . '"';
		$q .= ' ORDER BY v.`ordering`';

		$db->setQuery ($q);

		$this->methods = $db->loadObjectList();
		
		// process params
		if ($this->methods) {
			foreach ($this->methods as $method) {
				$params = explode('|', $method->payment_params);
				foreach($params as $item){
		
					$item = explode('=',$item);
					$key = $item[0];
					unset($item[0]);
		
					$item = implode('=',$item);
		
					if(!empty($item)){
						$method->$key = json_decode($item);
					}
				}
			}
		}
		
		return count ($this->methods);
	}
	
	/**
	 * calculateSalesPrice
	 *
	 * @param $value
	 * @return $salesPrice
	 */
	protected function calculateSalesPrice ($method, $cart_price) {

		$value = $this->getCosts ($method, $cart_price);

		return $value;
	}
	/**
	 * @param $plugin plugin
	 */
	protected function renderPluginName ($plugin) {

		$return = '';
		$plugin_name = 'title';
		$plugin_desc = 'text';
		$description = '';
		
		if (!empty($plugin->$plugin_desc)) {
			$description = '<span class="payment_description">' . $plugin->$plugin_desc . '</span>';
		}
		$pluginName = $return . '<span class="payment_name">' . $plugin->$plugin_name . '</span>' . $description;
		return $pluginName;
	}

	protected function getPluginHtml ($plugin, $selectedPlugin, $pluginSalesPrice) {

		$pluginmethod_id = $this->_idName;
		$pluginName = 'title';
		if ($selectedPlugin == $plugin->$pluginmethod_id) {
			$checked = 'checked="checked"';
		} else {
			$checked = '';
		}

		$costDisplay = "";
		if ($pluginSalesPrice) {
			$costDisplay = '<span class="payment_cost">('.booking_helper::price_display($pluginSalesPrice). ')</span>';
		}
		if ($plugin->$pluginmethod_id == 7) {
			return;
		}
		// show grand total
		$grandTotalDisplay = ' - <span class="grand_total">' . $this->getGrandTotalLabel($plugin, $selectedPlugin, $pluginSalesPrice). '</span>';

		$html = '<div style="width: 100%;float: left; margin-bottom: 5px;"><input type="radio" name="tb_paymentmethod_id" class="tb_paymentmethods" id="payment_id_' . $plugin->$pluginmethod_id . '"   value="' . $plugin->$pluginmethod_id . '" ' . $checked . ">\n"
			. '<label for="payment_id_' . $plugin->$pluginmethod_id . '">' . '<span class="payment">' . $plugin->$pluginName . $costDisplay . $grandTotalDisplay."</span></label></div>";

		return $html;
	}
	
	protected function getGrandTotalLabel ($method, $selectedPlugin, $pluginSalesPrice) {
		
		$session =  JFactory::getSession();
		$pluginmethod_id = $this->_idName;
		$sub_total = $session->get('price', 0);
		
		if (preg_match ('/%$/', $method->cost_percent_total)) {
			$cost_percent_total = substr ($method->cost_percent_total, 0, -1);
		} else {
			$cost_percent_total = $method->cost_percent_total;
		}
		$flat_fee = $method->cost_per_transaction;
		$percentage_fee = $sub_total * $cost_percent_total * 0.01;
		
		$grand_total = $sub_total + $flat_fee + $percentage_fee;

		$html = JText::sprintf('USER_DETAILS_PAYMENTS_GRAND_TOTAL_TXT', booking_helper::price_display($grand_total));

		return $html;
	}
	
	/*
	 * onSelectedCalculatePrice
	*/
	public function onSelectedCalculatePrice ($method_id, $cart_prices, &$cart_prices_name) {

		$id = $this->_idName;
		if (!($method = $this->selectedThisByMethodId ($method_id))) {
			return NULL; // Another method was selected, do nothing
		}
		$cart_prices_name = '';

		if (!$this->checkConditions ($method, $cart_prices)) {
			return FALSE;
		}
		$paramsName = 'payment_params';
		$cart_prices_name = $this->renderPluginName ($method);
		
		$this->setCartPrices ($cart_prices, $method);

		return TRUE;
	}
	
	/**
	 * update the plugin cart_prices
	 */
	function setCartPrices (&$cart_price, $method) {
		
		$session =  JFactory::getSession();
		
		if (preg_match ('/%$/', $method->cost_percent_total)) {
			$cost_percent_total = substr ($method->cost_percent_total, 0, -1);
		} else {
			$cost_percent_total = $method->cost_percent_total;
		}
		$flat_fee = $method->cost_per_transaction;
		$percentage_fee = $cart_price * $cost_percent_total * 0.01;
		
		$session->set('flat_cost', $flat_fee);
		$session->set('percentage_cost', $percentage_fee);
	}
	/**
	 * Checks if this plugin should be active by the trigger
	 *
	 * @param int/array $id the registered plugin id(s) of the joomla table
	 */
	protected function selectedThisByMethodId ($id = 'type') {

		if ($id === 'type') {
			return TRUE;
		}
		else {
			$db = JFactory::getDBO ();

			$q = 'SELECT tb.* FROM `' . $this->_configTable . '` AS tb,
				#__extensions AS j WHERE tb.`' . $this->_idName . '` = "' . $id . '"
				AND tb.payment_plugin_id = j.extension_id
				AND j.element = "' . $this->_name . '"
				AND j.folder = "tbpayment"';

			$db->setQuery ($q);
			if (!$res = $db->loadObject ()) {
				return FALSE;
			}
			else {
				// process params
				$params = explode('|', $res->payment_params);
				foreach($params as $item){
		
					$item = explode('=',$item);
					$key = $item[0];
					unset($item[0]);
		
					$item = implode('=',$item);
		
					if(!empty($item)){
						$res->$key = json_decode($item);
					}
				}
				return $res;
			}
		}
	}
	
	/**
	 * check if it is the correct element
	 *
	 * @param string $element either standard or paypal
	 * @return boolean
	 */
	public function selectedThisElement ($element) {

		if ($this->_name <> $element) {
			return FALSE;
		} else {
			return TRUE;
		}
	}
	
	/**
	 * Get Plugin Data for a go given plugin ID
	 *
	 * @param int $pluginmethod_id The method ID
	 * @return  method data
	 */
	protected function getPluginMethod ($method_id) {
		
		$method = $this->selectedThisByMethodId ($method_id);
		if (!$method) {
			return NULL; // Another method was selected, do nothing
		}
		else {
			return $method;
		}
	}
	/**
	 * getThisName
	 * Get the name of the method
	 *
	 * @param int $id The method ID
	 * @author Valérie Isaksen
	 * @return string Shipment name
	 */
	protected function getThisName ($method_id) {

		$db = JFactory::getDBO ();
		$q = 'SELECT `' . $this->_psType . '_name` '
			. 'FROM #__taxibooking_paymentmethods '
			. 'WHERE ' . $this->_idName . ' = "' . $method_id . '" ';
		$db->setQuery ($q);
		return $db->loadResult (); // TODO Error check
	}

	/**
	 * @param      $tableName
	 * @param      $tableFields
	 * @param      $primaryKey
	 * @param      $tableId
	 * @param bool $loggable
	 * @return VmTableData
	 */
	protected function createPluginTableObject ($tableName, $tableFields, $primaryKey, $tableId, $loggable = FALSE) {
		
		if (!$this->_tableChecked) {
			$this->onStoreInstallPluginTable ();
			$this->_tableChecked = TRUE;
		}
		
		require_once (JPATH_COMPONENT.DS.'classes'.DS.'tbtabledata.php');
		
		$db = JFactory::getDBO ();
		$table = new TbTableData($tableName, $tableId, $db);
		
		foreach ($tableFields as $field) {
			$table->$field = 0;
		}

		if ($primaryKey !== 0) {
			$table->setPrimaryKey ($primaryKey);
		}
		if ($loggable) {
			$table->setLoggable ();
		}

		return $table;
	}
	/**
	 * Extends the standard function in vmplugin. Extendst the input data by virtuemart_order_id
	 * Calls the parent to execute the write operation
	 *
	 * @param array  $_values
	 * @param string $_table
	 */
	protected function storePluginInternalData ($values, $primaryKey = 0, $preload = FALSE) {
		
		$this->_vmpItable = $this->createPluginTableObject ($this->_tablename, $this->tableFields, $primaryKey, $this->_tableId, $this->_loggable);
		
		// Bind the data.
		if (!$this->_vmpItable->bind($values))
		{
			exit($this->_vmpItable->getError());
		}

		// Check the data.
		if (!$this->_vmpItable->check())
		{
			exit($this->_vmpItable->getError());
		}
		
		// Store the data.
		if (!$this->_vmpItable->store())
		{
			exit($this->_vmpItable->getError());
		}

		return $values;
	}
	/**
	 * Create the table for this plugin if it does not yet exist.
	 *
	 * @param string $psType shipment,payment,custom
	 * @author Valérie Isaksen
	 * @author Max Milbers
	 */
	protected function onStoreInstallPluginTable() {
		
		$query = $this->getTbPluginCreateTableSQL();
		if(empty($query)){
			return false;
		} else {
		//if ($query !== 0) {
		// 	vmdebug('onStoreInstallPluginTable '.$query);
			$db = JFactory::getDBO ();
			$db->setQuery ($query);
			if (!$db->execute ()) {
				JError::raiseWarning (1, $this->_name . '::onStoreInstallPluginTable: ' . JText::_ ('COM_TAXIBOOKING_SQL_ERROR') . ' ' . $db->stderr (TRUE));
				echo $this->_name . '::onStoreInstallPluginTable: ' . JText::_ ('COM_TAXIBOOKING_SQL_ERROR') . ' ' . $db->stderr (TRUE);
			} else {
				
				// check if the payment table has all the updated fields
				// as plugin table may have new fields in future
				$SQLfields = $this->getTableSQLFields ();
				
				$current_fields = array();
				$db->setQuery('SHOW COLUMNS FROM '.$db->quoteName($this->_tablename));
				$rows = $db->loadObjectList();
				if(!empty($rows))
				{
					foreach($rows as $row){
						$current_fields[] = $row->Field;
					}
				}
				
				foreach ($SQLfields as $fieldname => $fieldtype)
				{
					if(!in_array($fieldname,$current_fields))
					{
						$query = "ALTER TABLE " . $db->quoteName($this->_tablename) . " ADD " . $db->quoteName($fieldname) . " $fieldtype";
						$db->setQuery($query);
						$db->execute();
					}
				}
				// end
				
				return true;
			}
		}
		return false;
	}
	
	/**
	 * adds loggable fields to the table
	 *
	 * @return array
	 */
	function getTableSQLLoggablefields () {
		return array(
			'created_on'  => 'datetime NOT NULL default \'0000-00-00 00:00:00\'',
			'created_by'  => "int(11) NOT NULL DEFAULT '0'",
			'modified_on' => 'datetime NOT NULL DEFAULT \'0000-00-00 00:00:00\'',
			'modified_by' => "int(11) NOT NULL DEFAULT '0'"
		);
	}
	/**
	 * @param $tableComment
	 * @return string
	 */
	protected function createTableSQL ($tableComment,$tablesFields=0) {
		
		// Drop the payment table if needed
		//$db = JFactory::getDBO ();
		//$db->setQuery('DROP TABLE IF EXISTS '.$db->quoteName($this->_tablename));
		//$db->execute();

		$query = "CREATE TABLE IF NOT EXISTS `" . $this->_tablename . "` (";
		if(!empty($tablesFields)){
			foreach ($tablesFields as $fieldname => $fieldtype) {
				$query .= '`' . $fieldname . '` ' . $fieldtype . " , ";
			}
		} else {
			$SQLfields = $this->getTableSQLFields ();
			$loggablefields = $this->getTableSQLLoggablefields ();
			foreach ($SQLfields as $fieldname => $fieldtype) {
				$query .= '`' . $fieldname . '` ' . $fieldtype . " , ";
			}
			foreach ($loggablefields as $fieldname => $fieldtype) {
				$query .= '`' . $fieldname . '` ' . $fieldtype . ", ";
			}
		}

		$query .= "	      PRIMARY KEY (`id`)
	    ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='" . $tableComment . "' AUTO_INCREMENT=1 ;";
		return $query;
	}
	
	/**
	 * Get Method Data for a given Payment ID
	 * @param int $order_id The order ID
	 * @return  $methodData
	 */
	protected function getDataByOrderId ($order_id) {

		$db = JFactory::getDBO ();
		$query = 'SELECT * FROM `' . $this->_tablename . '` '
			. 'WHERE `order_id` = ' . $order_id;

		$db->setQuery($query);
		
		// loadObjectList should be used, loadObject was used here and this is a bug
		// for now, we will just fix for Paypal
		// later we will fix for other payment plugin
		if($this->_name=='paypal' || $this->_name=='stripe'){
			$methodData = $db->loadObjectList();
		}
		else {
			$methodData = $db->loadObject();
		}

		return $methodData;
	}
	
	function handlePaymentUserCancel ($order_id=0) {

		if ($order_id>0) {
			$order['order_status'] = '0';
			booking_helper::update_order_status($order_id, $order);
		}
	}
}
