<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 * Component Controller
 * @since 1.0
 */
class TaxiBookingController extends JControllerLegacy {

    /**
     * Constructor
     *
     * @since 1.0
     */
    function __construct() {

        parent::__construct();
    }

    /**
     * Collect user's choice from TB module and redirect component page
     *
     * @access	public
     * @since	1.0
     */
    public function getDistancePrice()
    {
        // Initialize variables
        $db =  JFactory::getDBO();
        $user =  JFactory::getUser();
        $session =  JFactory::getSession();
	$lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();

        // Get the component configuration
        $elsettings =  booking_helper::config();

        //get data from request
        $post = JRequest::get('post');
        
        if (isset($post['from_dest'])) {
            $from_dest_val = $post['from_dest'];
        } else{
            $from_dest_val = -1;
        }
        $session->set('from_dest', $from_dest_val);
        
        if (isset($post['to_dest'])) {
            $to_dest_val = $post['to_dest'];
        } else {
            $to_dest_val = -1;
        }
        $session->set('to_dest', $to_dest_val);
        
        $begin = $end = '';
	$lat_long_from = $lat_long_to = array();
        
        $route_swapped = JRequest::getInt('route_swapped', 0);
        $session->set('route_swapped', $route_swapped);
            
        // check route selection        
        $route_category_fld = JRequest::getVar('route_category_fld', 0);
        $route_category_dropoff_fld = JRequest::getVar('route_category_dropoff_fld', 0);
        $route_from_fld = JRequest::getVar('route_from_fld', 0);
        $route_to_fld = JRequest::getVar('route_to_fld', 0);
        
        $route_category = JRequest::getInt('route_category', 0);
        $route_category_dropoff = JRequest::getInt('route_category_dropoff', 0);
        $route_from = JRequest::getInt('route_from', 0);
        $route_to = JRequest::getInt('route_to', 0);
        
        $booking_type = JRequest::getVar('booking_type', 'address');
        $datepicker_type = JRequest::getVar('datepicker_type', 'jquery');
        $hourly_hr = JRequest::getInt('hourly_hr', 0);
        $hourly_min = JRequest::getInt('hourly_min', 0);
	
	$shuttle_pickup = JRequest::getVar('shuttle_pickup', '');
	$shuttle_pickup_poi = JRequest::getInt('shuttle_pickup_poi', 0);
	$shuttle_dropoff = JRequest::getVar('shuttle_dropoff', '');
	$shuttle_dropoff_poi = JRequest::getInt('shuttle_dropoff_poi', 0);
	$shuttletime = JRequest::getVar('shuttletime', 0);
	$shuttle_route_id = JRequest::getInt('shuttle_route_id', 0);
	$shuttle_passengers = JRequest::getInt('shuttle_passengers', 0);
        
        $session->set('booking_type', $booking_type);
	$session->set('data_source', 'module');
        
        // clears previous session
	booking_helper::clear_booking_data();
        
        $waypoint_coords = array();
        
        if($booking_type=='offers')  // customer selected fixed route
        {
            $session->set('route_category_fld', $route_category_fld);
            $session->set('route_category', $route_category);
            $session->set('route_category_dropoff_fld', $route_category_dropoff_fld);
            $session->set('route_category_dropoff', $route_category_dropoff);
            $session->set('route_from_fld', $route_from_fld);
            $session->set('route_to_fld', $route_to_fld);
            $session->set('route_from', $route_from);
            $session->set('route_to', $route_to);
            
	    $begin = booking_helper::get_place_field_by_id($route_from);
	    $poi_where = array('p.id = '.$db->Quote($route_from));
	    $poiObj = booking_helper::get_specific_place_details($poi_where);
	    if($poiObj){
		$lat_long_from = array($poiObj->lat, $poiObj->long);
	    }
	    
	    $end = booking_helper::get_place_field_by_id($route_to);
	    $poi_where = array('p.id = '.$db->Quote($route_to));
	    $poiObj = booking_helper::get_specific_place_details($poi_where);
	    if($poiObj){
		$lat_long_to = array($poiObj->lat, $poiObj->long);
	    }
        }
        elseif($booking_type=='hourly')  // customer selected fixed route
        {
            $session->set('hourly_hr', $hourly_hr);
            $session->set('hourly_min', $hourly_min);
        }
	elseif($booking_type=='shuttle')  // customer selected shuttle
        {
	    $begin = $shuttle_pickup;
	    $end = $shuttle_dropoff;
            $session->set('shuttle_pickup', $shuttle_pickup);
	    $session->set('shuttle_pickup_poi', $shuttle_pickup_poi);
	    $session->set('shuttle_dropoff', $shuttle_dropoff);
	    $session->set('shuttle_dropoff_poi', $shuttle_dropoff_poi);
	    $session->set('shuttletime', $shuttletime);
	    $session->set('shuttle_route_id', $shuttle_route_id);
	    $session->set('shuttle_passengers', $shuttle_passengers);
	    $post['passengers'] = $shuttle_passengers;
	    
	    $poi_where = array('p.id = '.$db->Quote($shuttle_pickup_poi));
	    $poiObj = booking_helper::get_specific_place_details($poi_where);
	    if($poiObj){
		$lat_long_from = array($poiObj->lat, $poiObj->long);
	    }
	    
	    $poi_where = array('p.id = '.$db->Quote($shuttle_dropoff_poi));
	    $poiObj = booking_helper::get_specific_place_details($poi_where);
	    if($poiObj){
		$lat_long_to = array($poiObj->lat, $poiObj->long);
	    }
        }
        elseif($booking_type=='address') 
        {
            $begin = JRequest::getVar('address_from', '');
            $address_from_lat = JRequest::getVar('address_from_lat', '');
            $address_from_lng = JRequest::getVar('address_from_lng', '');
	    $pickup_poi = JRequest::getInt('pickup_poi', 0);
            
            $end = JRequest::getVar('address_to', '');
            $address_to_lat = JRequest::getVar('address_to_lat', '');
            $address_to_lng = JRequest::getVar('address_to_lng', '');
	    $dropoff_poi = JRequest::getInt('dropoff_poi', 0);
            
            $session->set('address_from', $begin);
            $session->set('address_from_lat', $address_from_lat);
            $session->set('address_from_lng', $address_from_lng);
	    $session->set('pickup_poi', $pickup_poi);
            $lat_long_from = array($address_from_lat, $address_from_lng);
            
            $session->set('address_to', $end);
            $session->set('address_to_lat', $address_to_lat);
            $session->set('address_to_lng', $address_to_lng);
	    $session->set('dropoff_poi', $dropoff_poi);
            $lat_long_to = array($address_to_lat, $address_to_lng);
            
            // waypoints
            $waypoints_post = JRequest::getVar('waypoints', array(), 'post', 'array');
            $waypoints_lat_post = JRequest::getVar('waypoints_lat', array(), 'post', 'array');
            $waypoints_lng_post = JRequest::getVar('waypoints_lng', array(), 'post', 'array');
            $waypoints_stop_duration_post = JRequest::getVar('waypoints_stop_duration', array(), 'post', 'array');
            
            $waypoints = array();
            $waypoints_lat = array();
            $waypoints_lng = array();
            $waypoints_stop_duration = array();
            
            $total_waypoint_duration = 0;
            for($i=0;$i<count($waypoints_post);$i++)
            {
                    if($waypoints_post[$i]!="" && $waypoints_lat_post[$i]!="" && $waypoints_lng_post[$i]!="")
                    {
                            $waypoints[] = $waypoints_post[$i];
                            $waypoints_lat[] = $waypoints_lat_post[$i];
                            $waypoints_lng[] = $waypoints_lng_post[$i];
                            $waypoints_stop_duration[] = $waypoints_stop_duration_post[$i];
                            
                            $total_waypoint_duration += $waypoints_stop_duration_post[$i];
                            
                            $waypoint_coords[] = array($waypoints_lat_post[$i], $waypoints_lng_post[$i]);
                    }
            }
            
            $session->set('waypoints', $waypoints);
            $session->set('waypoints_lat', $waypoints_lat);
            $session->set('waypoints_lng', $waypoints_lng);
            $session->set('waypoints_stop_duration', $waypoints_stop_duration);
            $session->set('total_waypoint_duration', $total_waypoint_duration);            
        }
        
        $session->set('begin', $begin);
        $session->set('end', $end);
	$session->set('lat_long_from', $lat_long_from);
	$session->set('lat_long_to', $lat_long_to);
	
	$distance = $duration_seconds = 0;
	$distance_text = $duration_text = '';
	if(!empty($lat_long_from) && !empty($lat_long_to))
	{
	    $call_gapi = true;
	    // if show map in shuttle is NO, no need to use google API to collect distance and duration
	    $booking_maps = booking_helper::getBookingMapsState($elsettings);
	    if($booking_type=='shuttle' && $booking_maps['shuttle']==0){
		$call_gapi = false;
		$gapi_status = "OK";
		$distance = $duration_seconds = 0;
	    }
	    
	    if($call_gapi){
		list($distance,$duration_seconds,$gapi_status,$gapi_msg) = booking_helper::calculateDistance($lat_long_from[0], $lat_long_from[1], $lat_long_to[0], $lat_long_to[1],$elsettings->distance_unit,$waypoint_coords);
	    }
	    
	    if($gapi_status=="OK")
	    {
		if($call_gapi && $distance==0)
		{
		}
		else
		{
		    $distance_text = number_format($distance,2).' '.$elsettings->distance_unit.'s';
				
		    // waypoint time 
		    $total_waypoint_duration = $session->get('total_waypoint_duration', 0);
		    $duration_seconds += $total_waypoint_duration*60;
		    
		    $duration_text = booking_helper::secondsToTime($duration_seconds);
		}
	    }
	}
        
	$session->set('distance', $distance); // distance ins KM or Mile
	$session->set('duration', $duration_text);
	$session->set('duration_seconds', $duration_seconds);
	
        $extras = JRequest::getVar('extras', array(), 'post', 'array');
        // calculate extras price
        list($selected_extras, $total_extra_price) = booking_helper::process_extras($extras);
        $session->set('selected_extras', $selected_extras);
        $session->set('total_extra_price', $total_extra_price);
	    
        if (isset($post['passengers']) && ($post['passengers'] > 0)) {
            $session->set('passengers', $post['passengers']);
            $passengers = $post['passengers'];
            $session->set('passenger_error', '');
        } else {
            $session->set('passenger_error', 'Passengers number is 0!');
            $passengers = "";
        }

        if (isset($post['infantseats'])) {
            $session->set('infantseats', $post['infantseats']);
            $infantseats = $post['infantseats'];
        } else
            $infantseats = "";

        if (isset($post['chseats'])) {
            $session->set('chseats', $post['chseats']);
            $chseats = $post['chseats'];
        } else
            $chseats = "";

        if (isset($post['boosterseats'])) {
            $session->set('boosterseats', $post['boosterseats']);
            $boosterseats = $post['boosterseats'];
        } else
            $boosterseats = "";

        if (isset($post['suitcases'])) {
            $session->set('suitcases', $post['suitcases']);
            $suitcases = $post['suitcases'];
        } else {
            $suitcases = "";
        }
        
        $date1 = $time1 = $date2 = $time2 = "";
        
	if($booking_type=='shuttle')
	{
		$post["orderdate"] = $post["orderdate_shuttle"];
		$date1 = $this->check_input($post["orderdate"]);
		if($elsettings->date_format=='mm-dd-yy') {
		    $date1_arr = explode('-',$date1);
		    $date1 =  $date1_arr[1].'-'.$date1_arr[0].'-'.$date1_arr[2];
		}
	}
	else {
	    if($datepicker_type=='jquery') // jquery datepicker
	    {
		if(!empty($post["orderdate"]))
		{
		    if($post["orderdate"]!='' && $post["orderdate"]!='Date')
		    {
			$date1 = $this->check_input($post["orderdate"]);
		    
			if($elsettings->date_format=='mm-dd-yy') {
			    $date1_arr = explode('-',$date1);
			    $date1 =  $date1_arr[1].'-'.$date1_arr[0].'-'.$date1_arr[2];
			}
		    }
		}
	    }
	    elseif($datepicker_type=='inline') // simple dropdown datepicker
	    {
		$date1 =  $post['pickup_day'].'-'.$post['pickup_month'].'-'.$post['pickup_year'];
	    }
	}
        
        if (isset($post['returnjurney'])) {
	    $returnjurney = 1;
	}
	else {
	    $returnjurney = 0;
	}
	
	if(in_array($booking_type, array('hourly', 'shuttle'))){
		$returnjurney = 0;
	}
	$session->set('returnjurney', $returnjurney);
        
	// consider return discount hour
	if(!empty($post["return_wait_hr"]) && (int)$post["return_wait_hr"] > 0)
	{
		$return_wait_hr = $post['return_wait_hr'];
		$session->set('return_wait_hr', $return_wait_hr);
	}
	
        $date2 = "";
        $time2 = "";
        
        if($datepicker_type=='jquery') // jquery datepicker
        {
            if(!empty($post["orderdatereturn"]))
            {
                if ($post["orderdatereturn"]!='' && $post["orderdatereturn"]!='Return Date')
                {
                    $date2 = $this->check_input($post["orderdatereturn"]);
                    
                    if($elsettings->date_format=='mm-dd-yy') {
                        $date2_arr = explode('-',$date2);
                        $date2 =  $date2_arr[1].'-'.$date2_arr[0].'-'.$date2_arr[2];
                    }
                }
            }
        }
        elseif($datepicker_type=='inline') // simple dropdown datepicker
        {
            $date2 =  $post['return_day'].'-'.$post['return_month'].'-'.$post['return_year'];
        }
        
        if($booking_type=='shuttle')
	{
		$time1 = $shuttletime;
	}
	else {
		if(isset($post["selPtHr1"]) && ($post["selPtHr1"]!='') && isset($post["selPtMn1"]) && ($post["selPtMn1"]!=''))
		{
		    $time1 = $this->check_input($post['selPtHr1']) . ":" . $this->check_input($post['selPtMn1']);
		    
		    if($elsettings->time_format=='12hr') {
			$time1 .=  $post["seltimeformat1"];
		    }
		}
		
		if (isset($post["selPtHr2"]) && ($post["selPtHr2"]!='') && isset($post["selPtMn2"]) && ($post["selPtMn2"]!='')) {
		    $time2 = $this->check_input($post['selPtHr2']) . ":" . $this->check_input($post['selPtMn2']);
		    
		    if($elsettings->time_format=='12hr') {
			$time2 .=  $post["seltimeformat2"];
		    }
		}
	}
        
        $session->set('date1', $date1);
        $session->set('time1', $time1);
        $session->set('date2', $date2);
        $session->set('time2', $time2);
        
        if($date1!="" && $time1!="")
        {
            $order_date_time_str = strtotime($date1.' '.$time1);
            $order_date_time = date("Y-m-d H:i:s", $order_date_time_str);
            $session->set('timestr1', $order_date_time_str);
        }
        
        if($date2!="" && $time2!="")
        {
            $orderreturn_date_time_str = strtotime($date2.' '.$time2);
            $orderreturn_date_time = date("Y-m-d H:i:s", $orderreturn_date_time_str);
            $session->set('timestr2', $orderreturn_date_time_str);
        }
        
        $this->setRedirect(JRoute::_(TaxibookingHelperRoute::getBookingFormRoute($lang_tag), false));
    }
    
    /**
    * Check all the input values
    */
    public function check_input($data) {
	    $data = trim($data);
	    $data = stripslashes($data);
	    $data = htmlspecialchars($data, ENT_QUOTES);
	    //no	$data = htmlentities($data);
	    return $data;
    }
    
    public function getRouteCategory()
    {
        $result = array('err' => 0, 'msg' => '', 'route_categories_html'=>'', 'route_categories_data'=>array());
        $db = JFactory::getDBO();
        $session = JFactory::getSession();
        $elsettings = booking_helper::config();
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();
        
        $route_category_pickup = JRequest::getInt('route_category', 0);
        $route_from = JRequest::getInt('route_from', 0);
        $sel_route_category = $session->get('route_category_dropoff', 0);
        
        $route_category_arr = array();
        if($elsettings->show_poi_categories==1)
        {
            $query = 'SELECT DISTINCT poi.title, poi.id, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image, poi_cat.language AS cat_language'
                    . ' FROM #__taxibooking_points AS poi'
                    . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                    . ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
                    . ' WHERE r.published = 1'
		    . ' AND poi.published = 1 AND poi.show_on_offers_dropoff = 1'
                    . ' AND r.route_from = '.$db->Quote($route_from)
                    . ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
                    . ' ORDER BY poi_cat.title ASC'
            ;
            $db->setQuery($query);
            $db->query();
            $rows = $db->loadObjectList();
            
            if (!empty($rows))
            {
                foreach ($rows as $row)
                {
                    if($row->cat_language=="*" || $row->cat_language==$lang_tag)
                    {
                        $route_category_arr[$row->catid] = array('cattitle' => $row->cattitle,
                                                            'catimage' => $row->cat_image);
                    }
                }
            }
        }
        
        $route_categories_html = '';
        $route_categories_data = array();
        if(!empty($route_category_arr))
        {
            $i = 0;
            foreach($route_category_arr as $catid => $catobj)
            {
                $route_categories_html .= '<div class="poi_link" id="'.$catid.'">';
                $route_categories_html .= ($catobj['catimage']!="") ? '<img src="'.JURI::base().$catobj['catimage'].'" alt="'.$catobj['cattitle'].'" title="'.$catobj['cattitle'].'" class="poicat_icon" />&nbsp;' : '';
                $route_categories_html .= '<span>'.$catobj['cattitle'].'</span></div>'."\n";
                
                $route_categories_data[$i]['label'] = $catobj['cattitle'];
                $route_categories_data[$i]['value'] = $catobj['cattitle'];
                $route_categories_data[$i]['id'] = $catid;
                
                $i++;
            }
        }
        
        $result['route_categories_html'] = $route_categories_html;
        $result['route_categories_data'] = $route_categories_data;
        //$result['msg'] =  JHTML::_('select.genericlist', $route_options, 'route_to', 'class="seat_options span2 select"', 'value', 'text', 0);
        echo json_encode($result);
        exit();
    }
    /**
     * Get route list
     *
     * @access	public
     */
    public function getRouteList()
    {
        $result = array('err' => 0, 'msg' => '');
        $db = JFactory::getDBO();
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();
        
        $route_category = JRequest::getInt('route_category', 0);
        $route_category_dropoff = JRequest::getInt('route_category_dropoff', 0);
        $route_from = JRequest::getInt('route_from', 0);
        
        if($route_category_dropoff > 0 && $route_from > 0) { // user chose routecategory dropoff, so get the dropoff route list for this selected category
            $query = 'SELECT DISTINCT poi.id, poi.title, poi_cat.image AS cat_image, poi_cat.title AS cattitle'
                    . ' FROM #__taxibooking_points AS poi'
                    . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                    . ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
                    . ' WHERE r.published = 1'
		    . ' AND poi.published = 1 AND poi.show_on_offers_dropoff = 1'
                    . ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
                    . ' AND r.route_from = '.$db->Quote($route_from)
                    . ' AND poi_cat.id = '.$db->Quote($route_category_dropoff)
                    . ' ORDER BY poi.title ASC'
            ;
        }
        elseif($route_category > 0 && $route_from > 0){ // user chose RouteCategory and RouteFrom, so system will collect routeto list
            $query = 'SELECT DISTINCT poi.id, poi.title, poi_cat.image AS cat_image, poi_cat.title AS cattitle'
                    . ' FROM #__taxibooking_points AS poi'
                    . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                    . ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
                    . ' WHERE r.published = 1'
		    . ' AND poi.published = 1 AND poi.show_on_offers_dropoff = 1'
                    . ' AND r.route_from = '.$db->Quote($route_from)
                    . ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
                    . ' ORDER BY poi.title ASC'
            ;
        }
        elseif($route_category > 0 && $route_from == 0) { // user chose routecategory, so get the routefrom list for this selected category
            $query = 'SELECT DISTINCT poi.id, poi.title, poi_cat.image AS cat_image, poi_cat.title AS cattitle'
                    . ' FROM #__taxibooking_points AS poi'
                    . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                    . ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_from'
                    . ' WHERE r.published = 1'
		    . ' AND poi.published = 1 AND poi.show_on_offers_pickup = 1'
                    . ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
                    . ' AND poi_cat.id = '.$db->Quote($route_category)
                    . ' ORDER BY poi.title ASC'
            ;
        }
        else {
            $query = 'SELECT DISTINCT poi.id, poi.title, poi_cat.image AS cat_image, poi_cat.title AS cattitle'
                    . ' FROM #__taxibooking_points AS poi'
                    . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                    . ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
                    . ' WHERE r.published = 1'
		    . ' AND poi.published = 1 AND poi.show_on_offers_dropoff = 1'
                    . ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
                    . ' AND r.route_from = '.$db->Quote($route_from)
                    . ' ORDER BY poi.title ASC'
            ;
        }
        $db->setQuery($query);
        $db->query();
        $rows = $db->loadObjectList();
        
        $route_poi_data = array();
        $route_options = array();
        $route_options[] = JHTML::_('select.option', 0, JText::_('SELECT_ROUTE'));
        $route_options_html = '';
        
        if (!empty($rows))
        {
            $i = 0;
            foreach ($rows as $row)
            {
                $row->title = htmlspecialchars($row->title);
		// In case htmlspecialchars misses these.
		$row->title = str_replace(array("'", '"'), array("&#39;", "&quot;"), $row->title);
                $route_options[] = JHTML::_('select.option', $row->id, $row->title);
                
                $route_options_html .= '<div class="poi_link" id="'.$row->id.'">';
                $route_options_html .= ($row->cat_image!="") ? '<img src="'.JURI::base().$row->cat_image.'" alt="'.$row->cattitle.'" title="'.$row->cattitle.'" class="poicat_icon" />&nbsp;' : '';
                $route_options_html .= '<span>'.$row->title.'</span></div>'."\n";
                
                $route_poi_data[$i]['label'] = $row->title;
                $route_poi_data[$i]['value'] = $row->title;
                $route_poi_data[$i]['id'] = $row->id;
                
                $i++;
            }
        }
        
        $result['route_options_html'] = $route_options_html;
        $result['route_poi_data'] = $route_poi_data;
        //$result['msg'] =  JHTML::_('select.genericlist', $route_options, 'route_to', 'class="seat_options span2 select"', 'value', 'text', 0);
        echo json_encode($result);
        exit();
    }
    
    /**
     * Get extras according to the user's choice Pickup and dropoff
     *
     * @access	public
     */
    public function getExtraList()
    {
        $result = array('error' => 0, 'msg' => '');
        $db = JFactory::getDBO();
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();
        
        $route_from = JRequest::getInt('route_from', 0);
        $route_to = JRequest::getInt('route_to', 0);
        $airports1 = JRequest::getVar('airports1', '');
        $airports2 = JRequest::getVar('airports2', '');
        $type = JRequest::getVar('type', 'pickup');
        
        $where = array();
        $where[] = 'f.published = 1';
        $where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';
        
        switch($type){
            
            case 'pickup':
                if($airports1!='')
                {
                    $poi_id = booking_helper::get_place_field(JFilterOutput::stringURLSafe($airports1), 'id');
                    $poi_obj = booking_helper::point_details($poi_id);
                    
                    $pickup_poicat = $poi_obj->catid;
                    $where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
                    $where[] = 'f.show_on_pickup = 1';
                }
                break;
            
            case 'dropoff':
                if($airports2!='')
                {
                    $poi_id = booking_helper::get_place_field(JFilterOutput::stringURLSafe($airports2), 'id');
                    $poi_obj = booking_helper::point_details($poi_id);
                    
                    $dropoff_poicat = $poi_obj->catid;
                    $where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
                    $where[] = 'f.show_on_dropoff = 1';
                }
                break;
            
            case 'route_pickup':
                if($route_from > 0)  // customer choose special route
                {
                    $poi_obj = booking_helper::point_details($route_from);
                    $pickup_poicat = $poi_obj->catid;
                    
                    $where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
                    $where[] = 'f.show_on_pickup = 1';
                }
                break;
            
            case 'route_dropoff':
                if($route_to > 0)
                {
                    $poi_obj = booking_helper::point_details($route_to);
                    $dropoff_poicat = $poi_obj->catid;
                    
                    $where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
                    $where[] = 'f.show_on_dropoff = 1';
                }
                break;
            
            case 'hourly_hire':
                
                $where[] = 'f.show_on_hourly = 1';
                break;
        }
        
        $where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
        $query = 'SELECT f.* '
                . ' FROM #__taxibooking_fields AS f'
                . $where
                . ' ORDER BY f.ordering ASC'
        ;
        
        $db->setQuery($query);
        $db->query();
        $rows = $db->loadObjectList();
        
        $html = '';
        
        if(!empty($poi_obj)){
            $html .='<div class="ver_input_wrap clearfix"><label>'.$poi_obj->text.'</label></div>';
        }
        
        if(!empty($rows))
        {
            foreach($rows as $row)
            {
                if($row->text!=""){
                    $field_title = '<a href="javascript:void(0);" class="field_desc" title="'.$row->text.'">'.$row->title.'</a>';
                }
                else {
                    $field_title = $row->title;
                }
                
                $html .= '<div class="ver_input_wrap clearfix">
                            <label>'.$field_title.'</label>';
                
                if($row->field_type=='input'){
                    $additional_class = ($row->is_mandatory==1) ? ' required' : '';
                    $html .=    '<input class="ver_inputbox extra'.$additional_class.'" type="text" value="" name="extras['.$type.']['.$row->id.']" />';
                }
                elseif($row->field_type=='extra'){
                    $html .=    '<select class="seat_options select extra" name="extras['.$type.']['.$row->id.']">';
                    
                    $start = ($row->allow_zero==1) ? 0 : 1;
                    for($i = $start; $i <= $row->quantity; $i++){
                        $html .= '<option value="'.$i.'">'.$i.'</option>';
                    }
                    
                    $html .=    '</select>';
                }
                $html .=    '</div>';
            }
        }
        
        $result['msg'] = $html;
        echo json_encode($result);
        exit();
    }
    /**
     * Get extras according to the user's choice Pickup and dropoff
     *
     * @access	public
     */
    public function getSwappedExtraList()
    {
        $result = array('error' => 0, 'pickupextra' => '', 'dropoffextra' => '');
        $db = JFactory::getDBO();
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();
        
        $route_from = JRequest::getInt('route_from', 0);
        $route_to = JRequest::getInt('route_to', 0);
        
        if($route_from > 0)
        {
            $where = array();
            $where[] = 'f.published = 1';
            
            $poi_obj = booking_helper::point_details($route_from);
            $pickup_poicat = $poi_obj->catid;
            
            $where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
            $where[] = 'f.show_on_pickup = 1';
            $where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';
            
            $where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
            $query = 'SELECT f.* '
                    . ' FROM #__taxibooking_fields AS f'
                    . $where
                    . ' ORDER BY f.ordering ASC'
            ;
            
            $db->setQuery($query);
            $db->query();
            $rows = $db->loadObjectList();
            
            $html = '';
            
            if(!empty($poi_obj)){
                $html .='<div class="ver_input_wrap clearfix"><label>'.$poi_obj->text.'</label></div>';
            }
            
            if(!empty($rows))
            {
                foreach($rows as $row)
                {
                    if($row->text!=""){
                        $field_title = '<a href="javascript:void(0);" class="field_desc" title="'.$row->text.'">'.$row->title.'</a>';
                    }
                    else {
                        $field_title = $row->title;
                    }
                    $html .= '<div class="ver_input_wrap clearfix">
                                <label>'.$field_title.'</label>';
                    
                    if($row->field_type=='input'){
                        $additional_class = ($row->is_mandatory==1) ? ' required' : '';
                        $html .=    '<input class="ver_inputbox extra'.$additional_class.'" type="text" value="" name="extras[route_pickup]['.$row->id.']" />';
                    }
                    elseif($row->field_type=='extra'){
                        $html .=    '<select class="seat_options select extra" name="extras[route_pickup]['.$row->id.']">';
                        
                        $start = ($row->allow_zero==1) ? 0 : 1;
                        for($i = $start; $i <= $row->quantity; $i++){
                            $html .= '<option value="'.$i.'">'.$i.'</option>';
                        }
                        
                        $html .=    '</select>';
                    }
                    $html .=    '</div>';
                }
            }
            
            $result['pickupextra'] = $html;
        }
        
        if($route_to > 0)
        {
            $where = array();
            $where[] = 'f.published = 1';
            
            $poi_obj = booking_helper::point_details($route_to);
            $dropoff_poicat = $poi_obj->catid;
            
            $where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
            $where[] = 'f.show_on_dropoff = 1';
            $where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';
            
            $where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
            $query = 'SELECT f.* '
                    . ' FROM #__taxibooking_fields AS f'
                    . $where
                    . ' ORDER BY f.ordering ASC'
            ;
            
            $db->setQuery($query);
            $db->query();
            $rows = $db->loadObjectList();
            
            $html = '';
            
            if(!empty($poi_obj)){
                $html .='<div class="ver_input_wrap clearfix"><label>'.$poi_obj->text.'</label></div>';
            }
            
            if(!empty($rows))
            {
                foreach($rows as $row)
                {
                    if($row->text!=""){
                        $field_title = '<a href="javascript:void(0);" class="field_desc" title="'.$row->text.'">'.$row->title.'</a>';
                    }
                    else {
                        $field_title = $row->title;
                    }
                    
                    $html .= '<div class="ver_input_wrap clearfix">
                                <label>'.$field_title.'</label>';
                    
                    if($row->field_type=='input'){
                        $additional_class = ($row->is_mandatory==1) ? ' required' : '';
                        $html .=    '<input class="ver_inputbox extra'.$additional_class.'" type="text" value="" name="extras[route_dropoff]['.$row->id.']" />';
                    }
                    elseif($row->field_type=='extra'){
                        $html .=    '<select class="seat_options select extra" name="extras[route_dropoff]['.$row->id.']">';
                        
                        $start = ($row->allow_zero==1) ? 0 : 1;
                        for($i = $start; $i <= $row->quantity; $i++){
                            $html .= '<option value="'.$i.'">'.$i.'</option>';
                        }
                        
                        $html .=    '</select>';
                    }
                    $html .=    '</div>';
                }
            }
            
            $result['dropoffextra'] = $html;
        }
        
        echo json_encode($result);
        exit();
    }
    
    /**
     * Get extras for return section
     *
     * @access	public
     */
    public function getReturnExtraList()
    {
        $result = array('error' => 0, 'msg' => '');
        $db = JFactory::getDBO();
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();
        
        $route_from_fld = JRequest::getVar('route_from_fld', '');
        $route_from = JRequest::getInt('route_from', 0);
        $route_to_fld = JRequest::getVar('route_to_fld', '');
        $route_to = JRequest::getInt('route_to', 0);
        
        $airports1 = JRequest::getVar('airports1', '');
        $airports2 = JRequest::getVar('airports2', '');
        $booking_type = JRequest::getVar('booking_type', 'address');
        
        $pickup_extras = array();
        $dropoff_extras = array();
        
        if($booking_type=='address')
        {
            $return_pickup = $airports2;
            $return_dropoff = $airports1;
            
            if($airports2!='')
            {
                $where = array();
                $where[] = 'f.published = 1';
                $where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';
                
                $pickup_poicat = booking_helper::get_place_field(JFilterOutput::stringURLSafe($airports2), 'catid');
                $where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
                $where[] = 'f.show_on_pickup = 1';
                $where[] = 'f.show_on_return = 1';
                
                $where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
                $query = 'SELECT f.* '
                        . ' FROM #__taxibooking_fields AS f'
                        . $where
                        . ' ORDER BY f.ordering ASC'
                ;
                $db->setQuery($query);
                $db->query();
                $pickup_extras = $db->loadObjectList();
            }
            if($airports1!='')
            {
                $where = array();
                $where[] = 'f.published = 1';
                $where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';
                
                $dropoff_poicat = booking_helper::get_place_field(JFilterOutput::stringURLSafe($airports1), 'catid');
                $where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
                $where[] = 'f.show_on_dropoff = 1';
                $where[] = 'f.show_on_return = 1';
                
                $where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
                $query = 'SELECT f.* '
                        . ' FROM #__taxibooking_fields AS f'
                        . $where
                        . ' ORDER BY f.ordering ASC'
                ;
                
                $db->setQuery($query);
                $db->query();
                $dropoff_extras = $db->loadObjectList();
            }
        }
        elseif($booking_type=='offers')
        {
            $return_pickup = $route_to_fld;
            $return_dropoff = $route_from_fld;
            
            if($route_to > 0) 
            {
                $where = array();
                $where[] = 'f.published = 1';
                $where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';
                
                $pickup_poicat = booking_helper::get_place_field_by_id($route_to, 'catid');
                $where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
                $where[] = 'f.show_on_pickup = 1';
                $where[] = 'f.show_on_return = 1';
                
                $where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
                $query = 'SELECT f.* '
                        . ' FROM #__taxibooking_fields AS f'
                        . $where
                        . ' ORDER BY f.ordering ASC'
                ;
                $db->setQuery($query);
                $db->query();
                $pickup_extras = $db->loadObjectList();
            }
            
            if($route_from > 0)
            {
                $where = array();
                $where[] = 'f.published = 1';
                $where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';
                
                $dropoff_poicat = booking_helper::get_place_field_by_id($route_from, 'catid');
                $where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
                $where[] = 'f.show_on_dropoff = 1';
                $where[] = 'f.show_on_return = 1';
                
                $where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
                $query = 'SELECT f.* '
                        . ' FROM #__taxibooking_fields AS f'
                        . $where
                        . ' ORDER BY f.ordering ASC'
                ;
                
                $db->setQuery($query);
                $db->query();
                $dropoff_extras = $db->loadObjectList();
            }
        }
        
        $html = '';
        if(($airports1!="" || $route_from>0) && ($airports2!="" || $route_to>0) )
        {
            ob_start();
            include( JPATH_COMPONENT.DS .'templates'.DS.'return_extras.tpl.php' );
            $html = ob_get_contents();
            ob_end_clean();
        }
        
        $result['msg'] = $html;
        echo json_encode($result);
        exit();
    }
    /**
     * Show settings panel
     *
     * @access	public
     * @since	1.0
     */
    function showParams() {
        JRequest::setVar('tmpl', 'component'); //force the component template
        $component = JRequest::getCmd('component');

        if (empty($component)) {
            JError::raiseWarning(500, 'Not a valid component');
            return false;
        }

        // load the component's language file
        $lang = & JFactory::getLanguage();
        $lang->load($component);

        $model = $this->getModel('Params');
        $table = & JTable::getInstance('component');

        if (!$table->loadByOption($component)) {
            JError::raiseWarning(500, 'Not a valid component');
            return false;
        }

        require_once( JPATH_COMPONENT . DS . 'views' . DS . 'params' . DS . 'view.php' );

        $view = new TaxiBookingViewParams( );
        $view->assignRef('component', $table);
        $view->setModel($model, true);
        $view->display();
    }

    /**
     * Save the configuration
     */
    function saveParams() {
        // Check for request forgeries
        JRequest::checkToken() or jexit('Invalid Token');

        $component = JRequest::getCmd('component');

        $table = & JTable::getInstance('component');
        if (!$table->loadByOption($component)) {
            JError::raiseWarning(500, 'Not a valid component');
            return false;
        }

        $post = JRequest::get('post');
        $post['option'] = $component;
        $table->bind($post);

        // pre-save checks
        if (!$table->check()) {
            JError::raiseWarning(500, $table->getError());
            return false;
        }

        // save the changes
        if (!$table->store()) {
            JError::raiseWarning(500, $table->getError());
            return false;
        }

        //$this->setRedirect( 'index.php?option=com_config', $msg );
        $this->showParams();
    }
    
    /**
    * Logic to download invoice for an order
    *
    * @access public
    * @return void
    * @since 1.0
    */
    public function pdf_invoice()
    {
	// Check for request forgeries
	//JRequest::checkToken() or jexit('Invalid Token');
	$db 	= JFactory::getDBO();
	$cid	= JRequest::getInt( 'cid', 0 );
       
	if($cid>0)
	{
	    $query = $db->getQuery(true);
	    $query->select('*');
	    $query->from('#__taxibooking_orders');
	    $query->where('id = '.(int)$cid);
	    $db->setQuery((string)$query);
	    $row = $db->loadObject();
	    
	    if($row){
		$invoice_file = JPATH_BASE.DS.'administrator'.DS.'components'.DS.'com_taxibooking'.DS.'documents'.DS.$row->invoice_title;
		booking_helper::outputStoredPDF($invoice_file);
	    }
	    
	}
	exit();
    }
    
    /**
    * Logic to validate coupon code and apply if valid
    *
    * @access public
    * @return void
    * @since 1.0
    */
    public function coupon_is_valid()
    {
	$json_result = array('error' => 0, 'msg' => '', 'new_total' => 0, 'prepayment' => 100, 'due_now' => 0, 'due_later' => 0, 'aup_required' => 0);
	
	$coupon_id= JRequest::getVar( 'coupon_id', 0 );
	$code	= JRequest::getVar( 'coupon_code', '' );
	
	$user =  JFactory::getUser();
	$elsettings = booking_helper::config();
	$session =  JFactory::getSession();
	$lang =  JFactory::getLanguage();
	$lang_tag = $lang->getTag();
	
	// first reset service charge/gratuity amount in session
	$gratuity_amt = 0;
	$session->set('gratuity_amt', $gratuity_amt);
	$session->set('gratuity_percent_value', 0);
	
	$tb_paymentmethod_id = $session->get('tb_paymentmethod_id', 0);
	$cprice = $session->get("price", "");
	$flat_cost = $session->get('flat_cost', 0);
	$percentage_cost = $session->get('percentage_cost', 0);
	
	$user_group_discount = 0;
	if(!class_exists('tbPaymentPlugin')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbpayment_plugin_helper.php');
	JPluginHelper::importPlugin('tbpayment');
	$dispatcher = JDispatcher::getInstance();
	$returnValues = $dispatcher->trigger('plgTbonSelectedCalculateUserGroupDiscount', array($tb_paymentmethod_id, $cprice, &$user_group_discount));
	
	$grand_total = $cprice+$flat_cost+$percentage_cost-$user_group_discount;
	
	$booking_data = array('booking_type' => $session->get('booking_type', 'address'),
			      'email' => $session->get('email'),
			      'route_from' => $session->get('route_from', 0),
			      'route_to' => $session->get('route_to', 0),
			      'grand_total' => $grand_total,
			      'selected_payment' => $tb_paymentmethod_id,
			      'lang_tag' => $lang_tag,
			      'pickup_date' => date("Y-m-d", $session->get('timestr1', ''))
			    );
	
	// fetch 
	$payment_method = booking_helper::get_payment_details($booking_data['selected_payment']);
	$prepayment = isset($payment_method->prepayment_percent) ? $payment_method->prepayment_percent : 0;
	$json_result['prepayment'] = $prepayment;
	    
	require_once (JPATH_COMPONENT.DS.'classes'.DS.'coupon_code.php');
	$cc = new CouponCode($code, $coupon_id);
	list($is_valid, $msg) = $cc->validate($booking_data);
	
	if($is_valid)
	{
	    $new_total = $cc->apply($booking_data);
	    $json_result['new_total'] = booking_helper::price_display($new_total,$elsettings);
	    list($due_now, $due_later) = $this->calculate_prepayment($new_total, $prepayment);
	    
	    $json_result['code'] = $cc->_coupon->code;
	    
	    // calculate AUP for this new total
	    $api_AUP = JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php';
	    if ( file_exists($api_AUP) && isset($payment_method->aup_per_currency) && $user->get('id') > 0)
	    {
		$aup_per_currency = (float)$payment_method->aup_per_currency;
		$aup_total = $new_total * $aup_per_currency;
		$json_result['aup_required'] = $aup_total;
	    }
	}
	else {
	    $json_result['error'] = 1;
	    $json_result['msg'] = $msg;
	    
	    $json_result['new_total'] = booking_helper::price_display($grand_total,$elsettings);
	    list($due_now, $due_later) = $this->calculate_prepayment($grand_total, $prepayment);
	}
	
	$json_result['due_now'] = booking_helper::price_display($due_now,$elsettings);
	$json_result['due_later'] = booking_helper::price_display($due_later,$elsettings);
	
	echo json_encode($json_result);
	exit();
    }
    /**
    * Logic to apply gratuity
    *
    * @access public
    * @return void
    * @since 1.0
    */
    public function applyGratuityAjax()
    {
	$json_result = array('error' => 0, 'msg' => '', 'new_total' => 0, 'prepayment' => 100, 'due_now' => 0, 'due_later' => 0, 'aup_required' => 0);
	
	$amt	= JRequest::getVar( 'amt', 0 );
	$amttype	= JRequest::getVar( 'amttype', '' );
	$action	= JRequest::getVar( 'action', '' );
	$coupon_code	= JRequest::getVar( 'coupon_code', '' );
	$coupon_id= JRequest::getVar( 'coupon_id', 0 );
	
	$user =  JFactory::getUser();
	$elsettings = booking_helper::config();
	$session =  JFactory::getSession();
	$lang =  JFactory::getLanguage();
	$lang_tag = $lang->getTag();
	
	$tb_paymentmethod_id = $session->get('tb_paymentmethod_id', 0);
	$cprice = $session->get("price", 0);
	$flat_cost = $session->get('flat_cost', 0);
	$percentage_cost = $session->get('percentage_cost', 0);
	
	$user_group_discount = 0;
	if(!class_exists('tbPaymentPlugin')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbpayment_plugin_helper.php');
	JPluginHelper::importPlugin('tbpayment');
	$dispatcher = JDispatcher::getInstance();
	$returnValues = $dispatcher->trigger('plgTbonSelectedCalculateUserGroupDiscount', array($tb_paymentmethod_id, $cprice, &$user_group_discount));
	
	$grand_total = $cprice+$flat_cost+$percentage_cost-$user_group_discount;
	
	$booking_data = array('booking_type' => $session->get('booking_type', 'address'),
			      'email' => $session->get('email'),
			      'route_from' => $session->get('route_from', 0),
			      'route_to' => $session->get('route_to', 0),
			      'grand_total' => $grand_total,
			      'selected_payment' => $tb_paymentmethod_id,
			      'lang_tag' => $lang_tag,
			      'pickup_date' => date("Y-m-d", $session->get('timestr1', ''))
			    );
	// fetch 
	$payment_method = booking_helper::get_payment_details($booking_data['selected_payment']);
	$prepayment = isset($payment_method->prepayment_percent) ? $payment_method->prepayment_percent : 0;
	$json_result['prepayment'] = $prepayment;
	
	// gratuity will be applied on couponed total if any coupon code present
	require_once (JPATH_COMPONENT.DS.'classes'.DS.'coupon_code.php');
	$cc = new CouponCode($coupon_code, $coupon_id);
	list($is_valid, $msg) = $cc->validate($booking_data);
	
	if($is_valid)
	{
	    $new_total = $cc->apply($booking_data);
	    $grand_total = $new_total;
	}
	
	if($amttype=='flat' || $amttype=='percent'){
	    if($action=='add')
	    {
		if($amttype=='percent'){
		    $new_total = $grand_total + ( $grand_total * (float)$amt / 100);
		    
		    $session->set('gratuity_percent_value', $amt);
		    
		    $amt = ($grand_total * (float)$amt) / 100;
		}
		else{
		    $new_total = $grand_total + (float)$amt;
		}
	    }
	    elseif($action=='deduce'){
		$new_total = $grand_total;
	    }
	    
	    // calculate AUP for this new total
	    $api_AUP = JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php';
	    if ( file_exists($api_AUP) && isset($payment_method->aup_per_currency) && $user->get('id') > 0)
	    {
		$aup_per_currency = (float)$payment_method->aup_per_currency;
		$aup_total = $new_total * $aup_per_currency;
		$json_result['aup_required'] = $aup_total;
	    }
	    
	    // set gratuity in session
	    $session->set('gratuity_amt', $amt);
	    $session->set('gratuity_amttype', $amttype);
	    
	    list($due_now, $due_later) = $this->calculate_prepayment($new_total, $prepayment);
	    
	    // for paypal currency conversion 
	    $converted_currency_lbl = '';
	    if(isset($payment_method->convert_currency))
	    {
		if((int)$payment_method->convert_currency==1 && $payment_method->convert_to!="")
		{
		    $currencies = array(
			    'AUD' => array(
				    'label' => 'Australian Dollar',
				    'format' => ' ($%s)',
			    ),
			    'CAD' => array(
				    'label' => 'Canadian Dollar',
				    'format' => ' ($%s)',
			    ),
			    'EUR' => array(
				    'label' => 'Euro',
				    'format' => ' (€%s)',
			    ),
			    'GBP' => array(
				    'label' => 'Pound Sterling',
				    'format' => ' (£%s)',
			    ),
			    'JPY' => array(
				    'label' => 'Japanese Yen',
				    'format' => ' (¥%s)',
			    ),
			    'USD' => array(
				    'label' => 'U.S. Dollar',
				    'format' => ' ($%s)',
			    ),
			    'NZD' => array(
				    'label' => 'N.Z. Dollar',
				    'format' => ' ($%s)',
			    ),
			    'CHF' => array(
				    'label' => 'Swiss Franc',
				    'format' => ' (%s Fr)',
			    ),
			    'HKD' => array(
				    'label' => 'Hong Kong Dollar',
				    'format' => ' ($%s)',
			    ),
			    'SGD' => array(
				    'label' => 'Singapore Dollar',
				    'format' => ' ($%s)',
			    ),
			    'SEK' => array(
				    'label' => 'Swedish Krona',
				    'format' => ' (%s kr)',
			    ),
			    'DKK' => array(
				    'label' => 'Danish Krone',
				    'format' => ' (%s kr)',
			    ),
			    'PLN' => array(
				    'label' => 'Polish Zloty',
				    'format' => ' (%s zł)',
			    ),
			    'NOK' => array(
				    'label' => 'Norwegian Krone',
				    'format' => ' (%s kr)',
			    ),
			    'HUF' => array(
				    'label' => 'Hungarian Forint',
				    'format' => ' (%s Ft)',
			    ),
			    'CZK' => array(
				    'label' => 'Czech Koruna',
				    'format' => ' (%s Kč)',
			    ),
			    'ILS' => array(
				    'label' => 'Israeli New Sheqel',
				    'format' => ' (₪ %s)',
			    ),
			    'MXN' => array(
				    'label' => 'Mexican Peso',
				    'format' => ' ($%s)',
			    ),
			    'BRL' => array(
				    'label' => 'Brazilian Real',
				    'format' => ' (R$ %s)',
			    ),
			    'MYR' => array(
				    'label' => 'Malaysian Ringgit',
				    'format' => ' (RM %s)',
			    ),
			    'PHP' => array(
				    'label' => 'Philippine Peso',
				    'format' => ' (₱ %s)',
			    ),
			    'RUB' => array(
				    'label' => 'Russian Ruble',
				    'format' => ' (%s руб)',
			    ),
			    'TWD' => array(
				    'label' => 'New Taiwan Dollar',
				    'format' => ' (NT$ %s)',
			    ),
			    'THB' => array(
				    'label' => 'Thai Baht',
				    'format' => ' (฿ %s)',
			    ),
			    'TRY' => array(
				    'label' => 'Turkish Lira',
				    'format' => ' (TRY %s)', // Unicode is ₺ but this doesn't seem to be widely supported yet (introduced Sep 2012)
			    ),
		    );
		    
		    if($prepayment==100){
			$converted = $new_total * (float)$payment_method->conversion_index;
		    }
		    else {
			$converted = $due_now * (float)$payment_method->conversion_index;
		    }
		    
		    $payment_currency = $payment_method->convert_to;
		    
		    // Hungarian Forint = HUF, Japanese Yen = JPY, Taiwan New Dolla = TWD 
		    // Note Decimal amounts are not supported for these currency. Passing a decimal amount will throw an error.
		    $special = array('HUF', 'JPY', 'TWD');
		    if(in_array($payment_method->convert_to, $special)){
			    $converted = round($converted);
		    }
		    else {
			    $converted = number_format($converted, 2);
		    }
		    $converted_currency_lbl .= JText::sprintf($currencies[$payment_currency]['format'], $converted);
		}
	    }
	    
	    //$new_total = booking_helper::round_price($new_total, $elsettings);
	    if($prepayment<100){
		$json_result['new_total'] = booking_helper::price_display($new_total,$elsettings);
		$due_now = booking_helper::price_display($due_now,$elsettings).$converted_currency_lbl;
	    }
	    
	    if($prepayment==100){
		$json_result['new_total'] = booking_helper::price_display($new_total,$elsettings).$converted_currency_lbl;
		$due_now = booking_helper::price_display($due_now,$elsettings);
	    }
	}
	else {
	    $json_result['error'] = 1;
	    $json_result['msg'] = 'Something went wrong';
	    
	    $json_result['new_total'] = booking_helper::price_display($grand_total,$elsettings);
	    list($due_now, $due_later) = $this->calculate_prepayment($grand_total, $prepayment);
	}
	
	$json_result['due_now'] = $due_now;
	$json_result['due_later'] = booking_helper::price_display($due_later,$elsettings);
	
	echo json_encode($json_result);
	exit();
    }
        
    public function calculate_prepayment($total, $prepayment)
    {
	if(is_null($prepayment)){
	    $prepayment = 100;
	}
	if($prepayment < 100)
	{
	    $due_now = $total * $prepayment / 100;
	    $due_later = $total - $due_now;
	}
	else {
	    $due_now = $total;
	    $due_later = 0;
	}
	
	return array($due_now, $due_later);
    }
    
    /**
    * Get POI details ccording to the POI ID
    *
    * @access	public
    */
    public function getPOIDetailsAjax()
    {
	    $result = array('error' => 0, 'poi' => array(), 'msg' => '');
	    $db = JFactory::getDBO();
	    $lang =  JFactory::getLanguage();
	    $lang_tag = $lang->getTag();
	    
	    $poi_id = JRequest::getInt('poiid', 0);
	    
	    $poi_obj = booking_helper::point_details($poi_id);
	    if($poi_obj){
		$result['poi']=$poi_obj;
	    }
	    else {
		$result['error'] = 1;
		$result['msg'] = 'POI not found';
	    }
	    
	    echo json_encode($result);
	    exit();
    }
    /**
    * Get POI details ccording to the POI ID
    *
    * @access	public
    */
    public function getPOICategoryDetailsAjax()
    {
	    $result = array('error' => 0, 'catObj' => array(), 'msg' => '');
	    $db = JFactory::getDBO();
	    $lang =  JFactory::getLanguage();
	    $lang_tag = $lang->getTag();
	    
	    $cid = JRequest::getInt('cid', 0);
	    
	    $query = $db->getQuery(true);
	    $query->select('*');
	    $query->from('#__taxibooking_poicats');
	    $query->where('id = '.(int)$cid);
	    $db->setQuery((string)$query);
	    $row = $db->loadObject();
	    
	    if($row){
		$result['catObj']=$row;
	    }
	    else {
		$result['error'] = 1;
		$result['msg'] = 'Category not found';
	    }
	    
	    echo json_encode($result);
	    exit();
    }
    public function loginAjax()
    {
	//JSession::checkToken('post') or jexit(JText::_('JInvalid_Token'));

	$app = JFactory::getApplication();
	$db = JFactory::getDBO();
	$date = JFactory::getDate();
	
	$json_result = array('error' => 0, 'msg' => '', 'redirect_url' => '');

	// Populate the data array:
	$data = array();
	$data['return'] = base64_decode(JRequest::getVar('return', '', 'POST', 'BASE64'));
	$data['username'] = JRequest::getVar('tborders_username', '', 'method', 'username');
	$data['password'] = JRequest::getString('tborders_password', '', 'post', JREQUEST_ALLOWRAW);

	// Set the return URL if empty.
	if (empty($data['return'])) {
		$data['return'] = 'index.php?option=com_users&view=profile';
	}

	// Set the return URL in the user state to allow modification by plugins
	$app->setUserState('users.login.form.return', $data['return']);

	// Get the log in options.
	$options = array();
	$options['remember'] = JRequest::getBool('remember', false);
	$options['return'] = $data['return'];

	// Get the log in credentials.
	$credentials = array();
	$credentials['username'] = $data['username'];
	$credentials['password'] = $data['password'];

	// Perform the log in.
	if (true === $app->login($credentials, $options)) {
		// Success
		$json_result['error'] = 0;
		$json_result['redirect_url'] = JRoute::_($app->getUserState('users.login.form.return'), false);
		
		// create TB user if its not created for this user already
		$user = JFactory::getUser();
		if($user->get('id', 0) > 0)
		{
		    $query = $db->getQuery(true);
		    $query->select('*');
		    $query->from('#__taxibooking_users');
		    $query->where('user_id = '.(int)$user->get('id'));
		    $db->setQuery((string)$query);
		    $tbuser = $db->loadObject();
		    
		    if(!$tbuser)
		    {
			$temp = new stdClass();
			$temp->user_id = $user->get('id');
			$temp->name = $user->get('name');
			$temp->email = $user->get('email');
			$temp->created = $date->toSql();
			$temp->created_by = $user->get('id');
			$temp->published = 1;
			
			$db->insertObject('#__taxibooking_users', $temp);
		    }
		}
	} else {
		// Login failed !
		$json_result['error'] = 1;
		$json_result['msg'] = JText::_('JLIB_LOGIN_AUTHENTICATE');
	}
	
	echo json_encode($json_result);
	exit();
    }
    public function getOrdersAjax()
    {
	$app = JFactory::getApplication();
	$db = JFactory::getDBO();
	$date = JFactory::getDate();
        $user = JFactory::getUser();
        $isAdmin = booking_helper::userIsInAdminGroups($user->get('id'));
	$elsettings =  booking_helper::config();
	
	jimport( 'joomla.html.html' );
	$now =  JHtml::date('now', 'Y-m-d H:i:s');
	
	$post = JRequest::get('post');
	
	/*
	 * Ordering
	 */
	$columns = array(
	    array( 'db' => 'datetime1',  'dt' => 0 ),
	    array( 'db' => 'begin',   'dt' => 1 ),
	    array( 'db' => 'end',     'dt' => 2 ),
	    array( 'db' => 'returntrip',  'dt' => 3 ),
	    array( 'db' => 'names', 'dt' => 4 ),
	    array( 'db' => 'selpassengers',  'dt' => 5 ),
	    array( 'db' => 'vehicletype',  'dt' => 6 ),
	    array( 'db' => 'driver_id',  'dt' => 7 ),
	    array( 'db' => 'cprice',  'dt' => 8 ),
	    array( 'db' => 'payment',  'dt' => 9 ),
	    array( 'db' => 'state',  'dt' => 10 ),
	    array( 'db' => 'order_number',  'dt' => 11 ),
	    array( 'db' => 'invoice',  'dt' => 12 )
	);
	
	require_once (JPATH_COMPONENT.DS.'classes'.DS.'ssp.class.php');
	
	$bindings = array();
	$order = SSP::order( $post, $columns );
	//$where = SSP::filter( $post, $columns, $bindings );
	
	$order = str_replace('ORDER BY ', '', $order);
	//echo $order;
	//$where = str_replace('WHERE ', '', $where);
	
	// collect copied users orders
	$copy_orders_sql = '';
	$copy_order_ids = array();
	if (!$isAdmin) {
	    $query = $db->getQuery(true);
	    $query->select('DISTINCT order_id');
	    $query->from('#__taxibooking_order_copyusers');
	    $query->where('user_id = '.(int)$user->get('id'));
	    $db->setQuery((string)$query);
	    $copy_order_ids = $db->loadColumn();
	    if(!empty($copy_order_ids)){
		$copy_orders_sql = ' OR a.id IN ('.implode(',',$copy_order_ids).')';
	    }
	}
	
	// prepare where conditions
	$whereStr = array();
	if ( isset($post['search']) && $post['search']['value'] != '' )
	{
	    $search = $post['search']['value'];
	    $search = $db->quote('%' . $db->escape($search, true) . '%');
	    $whereStr[] = '(a.begin LIKE ' . $search . ' OR a.end LIKE ' . $search .  ' OR a.names LIKE ' . $search
	    . ' OR u.name LIKE ' . $search .  ' OR pm.title LIKE ' . $search. ' OR c.title LIKE ' . $search .  ' OR a.cprice LIKE ' . $search. ')';
	}
	
	if ( isset($post['search']) && $post['search']['start_date'] != '' )
	{
	    $search = strtotime($post['search']['start_date'].' 00:00:00');
	    $search = $db->quote($db->escape($search, true));
	    $whereStr[] = '(a.datetime1 >= ' . $search . ')';
	}
	
	if ( isset($post['search']) && $post['search']['end_date'] != '' )
	{
	    $search = strtotime($post['search']['end_date'].' 23:59:59');
	    $search = $db->quote($db->escape($search, true));
	    $whereStr[] = '(a.datetime1 <= ' . $search . ')';
	}
	
	// Total data set length
        $query = $db->getQuery(true);
        $query->select('a.*');
        $query->from($db->quoteName('#__taxibooking_orders') . ' AS a');
	
        if (!$isAdmin) {
            $user_email = $user->get('email');
            $query->where('(a.email = ' . $db->Quote($user_email). $copy_orders_sql.')');
        }

	$db->setQuery((string)$query);
	$db->query();
	$recordsTotal = $db->getNumRows();
	
	// Main query to actually get the data
	$query = $db->getQuery(true);
        $query->select('a.*');
        $query->from($db->quoteName('#__taxibooking_orders') . ' AS a');
        
	// Join over the driver 
        $query->select('c.title AS vehicle_name')
                ->join('LEFT', $db->quoteName('#__taxibooking_cars') . ' AS c ON c.id = a.vehicletype');
		
         // Join over the driver 
        $query->select('u.name AS drivername')
                ->join('LEFT', $db->quoteName('#__users') . ' AS u ON u.id = a.driver_id');
                
        // Join over the payment methods 
        $query->select('pm.title AS payment_method')
                ->join('LEFT', $db->quoteName('#__taxibooking_paymentmethods') . ' AS pm ON pm.id = a.payment');
        
        if (!$isAdmin) {
            $user_email = $user->get('email');
	    $query->where('(a.email = ' . $db->Quote($user_email). $copy_orders_sql.')');
        }
	if(!empty($whereStr)){
	    $query->where(implode(' AND ', $whereStr));
	}

	// Data set length after filtering
	$db->setQuery((string)$query);
	$db->query();
        $recordsFiltered = $db->getNumRows();
	
        // Main query to actually get the data
	$query = $db->getQuery(true);
        $query->select('a.*');
        $query->from($db->quoteName('#__taxibooking_orders') . ' AS a');
        
	// Join over the driver 
        $query->select('c.title AS vehicle_name')
                ->join('LEFT', $db->quoteName('#__taxibooking_cars') . ' AS c ON c.id = a.vehicletype');
		
         // Join over the driver 
        $query->select('u.name AS drivername')
                ->join('LEFT', $db->quoteName('#__users') . ' AS u ON u.id = a.driver_id');
                
        // Join over the payment methods 
        $query->select('pm.title AS payment_method')
                ->join('LEFT', $db->quoteName('#__taxibooking_paymentmethods') . ' AS pm ON pm.id = a.payment');
        
        if (!$isAdmin) {
            $user_email = $user->get('email');
	    $query->where('(a.email = ' . $db->Quote($user_email). $copy_orders_sql.')');
        }
	if(!empty($whereStr)){
	    $query->where(implode(' AND ', $whereStr));
	}
	$query->order($order);
	
	if ( isset($post['start']) && $post['length'] != -1 ) {
	    $db->setQuery((string)$query, intval( $post['start'] ), intval( $post['length'] ));
	}
	else {
	    $db->setQuery((string)$query);
	}
        
        $db->query();
        $rows = $db->loadObjectList();
	
	$table_data = array();
	if(!empty($rows))
	{
	    foreach($rows as $row)
	    {
		if ($row->state == 1) {
			$img = 'tick.png';
			$inv_img = 'j_button2_readmore.png';
			$alt = JText::_('ACCEPTED');
			$inv_alt = JText::_('Invoice');
			$state = 1;
		} else if ($row->state == 0) {
			$img = 'publish_x.png';
			$alt = JText::_('REJECTED');
			$state = 0;
		} else if ($row->state == -1) {
			$img = 'disabled.png';
			$alt = JText::_('ARCHIVED');
			$state = -1;
		} else if ($row->state == -2) {
			$img = 'publish_r.png';
			$alt = JText::_('WAITING');
			$state = -2;
		}
		
		$pdf_invoice = JPATH_COMPONENT_ADMINISTRATOR . DS . "documents".DS.$row->invoice_title;
		if ($row->state == 1 && ($row->invoice_title!="") && file_exists($pdf_invoice)){
		    $invoice_html = '<a href="javascript:void(0);" class="invoice_download_trigger" data-cid="'.$row->id.'">
			<img src="'.JURI::root().'components/com_taxibooking/assets/images/pdf.png" width="25" height="25" title="'.$inv_alt.'" alt="'.$inv_alt.'" />
		    </a>';
		}
		else {
		    $invoice_html = '&nbsp;';
		    
		    // orders with paypal and stripe payment only will have Pay Now button
		    // only Pending orders have this button
		    $paymentObj = booking_helper::get_payment_details($row->payment);
		    if($paymentObj && ($paymentObj->payment_element=='stripe' || $paymentObj->payment_element=='paypal') && $row->state == -2){
			if($paymentObj->payment_element=='stripe'){
			    $invoice_html = '<a href="javascript:void(0);" class="myorders_btn_paynow stripe btn btn-small" data-cid="'.$row->order_number.'">'.JText::_('ORDERS_TABLE_BTN_PAY_NOW').'</a>';
			}
			elseif($paymentObj->payment_element=='paypal'){
			    $invoice_html = '<a href="'.JURI::root().'index.php?option=com_taxibooking&view=payment&cid=' . $row->order_number.'&tmpl=component" class="myorders_btn_paynow btn btn-small" target="_blank">'.JText::_('ORDERS_TABLE_BTN_PAY_NOW').'</a>';
			}
		    }
		}
		
		$link = 'index.php?option=com_taxibooking&view=order&cid=' . $row->id.'&tmpl=component';
		
		// order cancel button
		$details_btn = '<a href="javascript:void(0);" class="myorders_order_details btn btn-small" data-cid="'.$row->id.'">'.JText::_('ORDERS_TABLE_MORE_DETAILS').'</a>';
		
		$booking_cancellation_prior_sec = (float)$elsettings->booking_cancellation_prior_hrs*3600;
		$min_time = $row->datetime1 - $booking_cancellation_prior_sec;
		
		if((int)$row->state==0 || (int)$row->state==-1 || (int)$elsettings->booking_cancellation_allowed==0){
		    $cancel_btn = '';
		}
		else {
		    if(strtotime($now) > $min_time){
			$cancel_btn = '';
		    }
		    else {
			$cancel_btn = '&nbsp;<a href="javascript:void(0);" class="myorders_order_cancel btn btn-small" data-cid="'.$row->id.'">'.JText::_('ORDERS_TABLE_CANCEL_BOOKING').'</a>';
		    }
		}
		
		// check if this order is copied order for current user as copied user can not cancel order
		if(!empty($copy_order_ids) && in_array($row->id, $copy_order_ids)){
		    $cancel_btn = '';
		}
		
		$table_data[] = array(
		    booking_helper::get_order_pickup_date($row),
		    ($row->begin!='') ? $row->begin : '&nbsp;',
		    ($row->end!='') ? $row->end : '&nbsp;',
		    ($row->datetime2=="") ? JText::_('JNO') : booking_helper::get_order_return_date($row),
		    $row->names,
		    $row->selpassengers,
		    booking_helper::get_order_car($row),
		    ($row->drivername!='') ? $row->drivername : '&nbsp;',
		    booking_helper::price_display($row->cprice,$elsettings),
		    booking_helper::get_order_payment($row),
		    '<img src="'.JURI::root().'components/com_taxibooking/assets/images/'.$img.'" width="16" height="16" border="0" title="'.$alt.'" alt="'.$alt.'" />',
		    $row->order_number,
		    $invoice_html,
		    $details_btn.$cancel_btn
		);
	    }
	}
	
	/*
	* Output
	*/
	$output = array(
		"draw"            => intval( $_POST['draw'] ),
		"recordsTotal"    => intval( $recordsTotal ),
		"recordsFiltered" => intval( $recordsFiltered ),
		"data"            => $table_data
	);
	
	echo json_encode($output);
	exit();
    }
    public function getCorporateInvoicesAjax()
    {
	$app = JFactory::getApplication();
	$db = JFactory::getDBO();
	$date = JFactory::getDate();
        $user = JFactory::getUser();
	$userId = $user->get('id');
        $isAdmin = booking_helper::userIsInAdminGroups($userId);
	$elsettings = booking_helper::config();
	$post = JRequest::get('post');
	
	/*
	 * Ordering
	 */
	$columns = array(
	    array( 'db' => 'invoice_number',  'dt' => 2 ),
	    array( 'db' => 'client_id',   'dt' => 1 ),
	    array( 'db' => 'invoice_month',     'dt' => 3 ),
	    array( 'db' => 'invoice_total',  'dt' => 4 ),
	    array( 'db' => 'id',  'dt' => 10 ),
	    array( 'db' => 'status',  'dt' => 11 )
	);
	
	require_once (JPATH_COMPONENT.DS.'classes'.DS.'ssp.class.php');
	require_once (JPATH_ROOT.DS.'components'.DS.'com_tbcorporate'.DS.'helpers'.DS.'tbcorporate.php');
	
	$bindings = array();
	$order = SSP::order( $post, $columns );
	//$where = SSP::filter( $post, $columns, $bindings );
	
	$order = str_replace('ORDER BY ', '', $order);
	//echo $order;
	//$where = str_replace('WHERE ', '', $where);
	
	// prepare where conditions
	$whereStr = array();
	if ( isset($post['search']) && $post['search']['value'] != '' )
	{
	    $search = $post['search']['value'];
	    $search = $db->quote('%' . $db->escape($search, true) . '%');
	    $whereStr[] = '(a.invoice_number LIKE ' . $search . ')';
	}
	
	// Total data set length
        $query = $db->getQuery(true);
        $query->select('a.*');
        $query->from($db->quoteName('#__tbcorporate_client_invoices') . ' AS a');
	
	if(!$isAdmin){
	    $clientObj = TbcorporateHelperFront::getClientByUserId($userId);
	    if($clientObj){
		$query->where('a.client_id = '.$clientObj->id);
	    }
	}

	$db->setQuery((string)$query);
	$db->query();
	$recordsTotal = $db->getNumRows();
	
	// Main query to actually get the data
	$query = $db->getQuery(true);
        $query->select('a.*');
        $query->from($db->quoteName('#__tbcorporate_client_invoices') . ' AS a');
	
	// Join over clients to get client name.
	$query->select('c.name AS client_name');
	$query->join('LEFT', '#__tbcorporate_clients AS c ON c.id=a.client_id');
        
        if(!$isAdmin){
	    $clientObj = TbcorporateHelperFront::getClientByUserId($userId);
	    if($clientObj){
		$query->where('a.client_id = '.$clientObj->id);
	    }
	}
	if(!empty($whereStr)){
	    $query->where(implode(' AND ', $whereStr));
	}

	// Data set length after filtering
	$db->setQuery((string)$query);
	$db->query();
        $recordsFiltered = $db->getNumRows();
	
        // Main query to actually get the data
	$query = $db->getQuery(true);
        $query->select('a.*');
        $query->from($db->quoteName('#__tbcorporate_client_invoices') . ' AS a');
        
	// Join over the users for the checked out user.
	$query->select('c.name AS client_name');
	$query->join('LEFT', '#__tbcorporate_clients AS c ON c.id=a.client_id');
	
        if(!$isAdmin){
	    $clientObj = TbcorporateHelperFront::getClientByUserId($userId);
	    if($clientObj){
		$query->where('a.client_id = '.$clientObj->id);
	    }
	}
	if(!empty($whereStr)){
	    $query->where(implode(' AND ', $whereStr));
	}
	$query->order($order);
	
	if ( isset($post['start']) && $post['length'] != -1 ) {
	    $db->setQuery((string)$query, intval( $post['start'] ), intval( $post['length'] ));
	}
	else {
	    $db->setQuery((string)$query);
	}
        
        $db->query();
        $rows = $db->loadObjectList();
	
	$table_data = array();
	if(!empty($rows))
	{
	    foreach($rows as $row)
	    {
		$first_date = $row->invoice_year.'-'.str_pad($row->invoice_month, 2, '0', STR_PAD_LEFT).'-01';
		$row->due_date = date("Y-m-t", strtotime($first_date));
	
		$row->total_paid = $this->_getTotalPayments($row);
		$row->total_due = (float)$row->invoice_total - (float)$row->total_paid;
		
		$table_data[] = array(
		    $row->client_name.' / '.$row->month_name.', '.$row->invoice_year,
		    $row->client_name,
		    $row->invoice_number,
		    $row->month_name.', '.$row->invoice_year,
		    booking_helper::price_display($row->invoice_total,$elsettings),
		    booking_helper::price_display($row->total_paid,$elsettings),
		    booking_helper::price_display($row->total_due,$elsettings),
		    $row->due_date,
		    booking_helper::calculate_time_difference(date('Y-m-d'), $row->due_date, 'day'),
		    ($row->status==1) ? JText::_('MYORDERS_CORPORATE_INVOICES_INVOICE_STATUS_PAID') : JText::_('MYORDERS_CORPORATE_INVOICES_INVOICE_STATUS_PENDING'),
		    $row->id,
		    '<a href="javascript:void(0);" class="myorders_order_details" data-cid="'.$row->id.'">'.JText::_('ORDERS_TABLE_MORE_DETAILS').'</a>'
		);
	    }
	}
	
	/*
	* Output
	*/
	$output = array(
		"draw"            => intval( $_POST['draw'] ),
		"recordsTotal"    => intval( $recordsTotal ),
		"recordsFiltered" => intval( $recordsFiltered ),
		"data"            => $table_data
	);
	
	echo json_encode($output);
	exit();
    }
    
    private function _getTotalPayments($item)
    {
	    $db = JFactory::getDBO();
	    
	    $query = $db->getQuery(true);
	    $query->select('SUM(a.amount) AS total_paid');
	    $query->from('#__tbcorporate_invoice_payments AS a');
	    $query->where('invoice_id = '.(int)$item->id);
	    $db->setQuery((string)$query);
	    $total_paid = $db->loadResult();
	    
	    return $total_paid;
    }
    
    public function getUserAddressesAjax()
    {
	$app = JFactory::getApplication();
	$db = JFactory::getDBO();
	$date = JFactory::getDate();
        $user = JFactory::getUser();
	
	$json_result = array('error' => 0, 'msg' => '');
        
	$action = JRequest::getVar('action', 'list');
	
	if($action=='add' && $user->get('id') > 0)
	{
	    $title = JRequest::getVar('new_address_title', '');
	    $organization = JRequest::getVar('new_address_organization', '');
	    $lat = JRequest::getVar('new_address_lat', '');
	    $lng = JRequest::getVar('new_address_lng', '');
	    $alias = JFilterOutput::stringURLSafe($title);
	    
	    $temp = new stdClass();
	    $temp->user_id = $user->get('id');
	    $temp->user_name = $user->get('name');
	    $temp->title = $title;
	    $temp->alias = $alias;
	    $temp->lat = $lat;
	    $temp->lng = $lng;
	    $temp->organization = $organization;
	    $temp->created = $date->toSql();
	    $temp->created_by = $user->get('id');
	    $temp->published = 1;
	    
	    $db->insertObject('#__taxibooking_user_addresses', $temp);
	}
	elseif($action=='update' && $user->get('id') > 0)
	{
	    $address_id = JRequest::getInt('new_address_id', 0);
	    $title = JRequest::getVar('new_address_title', '');
	    $organization = JRequest::getVar('new_address_organization', '');
	    $lat = JRequest::getVar('new_address_lat', '');
	    $lng = JRequest::getVar('new_address_lng', '');
	    $alias = JFilterOutput::stringURLSafe($title);
	    
	    $temp = new stdClass();
	    $temp->id = $address_id;
	    $temp->user_id = $user->get('id');
	    $temp->user_name = $user->get('name');
	    $temp->title = $title;
	    $temp->alias = $alias;
	    $temp->lat = $lat;
	    $temp->lng = $lng;
	    $temp->organization = $organization;
	    $temp->created = $date->toSql();
	    $temp->created_by = $user->get('id');
	    $temp->published = 1;
	    
	    $db->updateObject('#__taxibooking_user_addresses', $temp, 'id');
	}
	elseif($action=='delete' && $user->get('id') > 0)
	{
	    $address_id = JRequest::getInt('address_id', 0);
	    
	    if($address_id > 0)
	    {
		$query = $db->getQuery(true);
		$query = 'DELETE FROM `#__taxibooking_user_addresses` WHERE `id` = '.$db->quote($address_id);
		$db->setQuery($query);
		$db->execute();
	    }
	}
	
        $query = $db->getQuery(true);
 
        // Select the required fields from the table.
        $query->select('a.*');
        $query->from($db->quoteName('#__taxibooking_user_addresses') . ' AS a');
        $query->where('a.user_id = '. (int)$user->get('id'));
	$query->where('a.published = 1');
        $query->order('a.id ASC');
        
        $db->setQuery($query);
        $db->query();
        $rows = $db->loadObjectList();
	
	if(empty($rows)){
	    $json_result['msg'] = '<div class="book_message">'.JText::_('MYORDERS_USER_NO_ADDRESS').'</div>';
	}
	else
	{
	    $html = '
<table>
<thead>
<tr>
<th>'.JText::_('MYORDERS_USER_ADDRESS_TITLE').'</th>
<th>'.JText::_('MYORDERS_USER_ADDRESS_ORGANIZATION').'</th>
<th class="numeric">'.JText::_('MYORDERS_USER_ADDRESS_LATITUDE').'</th>
<th class="numeric">'.JText::_('MYORDERS_USER_ADDRESS_LONGITUDE').'</th>
<th class="numeric">'.JText::_('MYORDERS_USER_ADDRESS_ACTION').'</th>
</tr>
</thead>
<tbody>';
	    
	    foreach($rows as $row)
	    {
		$html .= '
<tr data-cid="'.$row->id.'">
<td data-title="Title">'.$row->title.'</td>
<td data-title="Company">'.$row->organization.'</td>
<td data-title="Latitude">'.$row->lat.'</td>
<td data-title="Longitude">'.$row->lng.'</td>
<td data-title="Action">
	<a href="javascript:void(0);" class="tborders_address_edit">'.JText::_('MYORDERS_USER_ADDRESS_EDIT').'</a> / <a href="javascript:void(0);" class="tborders_address_delete">'.JText::_('MYORDERS_USER_ADDRESS_DELETE').'</a>	
</td>
</tr>';
	    }

$html .= '</tbody>
</table>';
	    $json_result['msg'] = $html;
	}
        
	echo json_encode($json_result);
	exit();
    }
    public function getAddressDetailsAjax()
    {
	$app = JFactory::getApplication();
	$db = JFactory::getDBO();
	$date = JFactory::getDate();
        $user = JFactory::getUser();
	
	$json_result = array('error' => 0, 'msg' => '');
        $address_id = JRequest::getInt('address_id', 0);
	
	if($address_id > 0 && $user->get('id') > 0)
	{
	    $query = $db->getQuery(true);
	    $query->select('a.*');
	    $query->from($db->quoteName('#__taxibooking_user_addresses') . ' AS a');
	    $query->where('a.id = '. (int)$address_id);
	    
	    $db->setQuery($query);
	    $db->query();
	    $row = $db->loadObject();
	    
	    if($row){
		$json_result['msg'] = $row;
	    }
	}
	
	echo json_encode($json_result);
	exit();
    }
    public function saveProfilePictureAjax()
    {
	$app = JFactory::getApplication();
	$db = JFactory::getDBO();
	$date = JFactory::getDate();
        $user = JFactory::getUser();
	$session = JFactory::getSession();
	
	$json_result = array('error' => 0, 'msg' => '');
        
	$cropped_data  = JRequest::getVar('cropped_data', array(), 'post', 'array');
	$file_name   = $cropped_data['new_photo'];
	if($file_name!="")
	{
	    require_once (JPATH_COMPONENT.DS.'classes'.DS.'simpleimage.php');
	    $targetFile = JPATH_COMPONENT.DS.'uploads'.DS.'medium'.DS.$file_name;
	    $image = new SimpleImage();
	    $image->load($targetFile);
	    $image->crop($cropped_data['x1'], $cropped_data['y1'], $cropped_data['w'], $cropped_data['h']);
	    $image->save($targetFile);
	    
	    //if (!file_exists(implode(DIRECTORY_SEPARATOR, array(JPATH_ROOT, 'images', 'taxibooking', 'userphoto')))) {
		//mkdir(implode(DIRECTORY_SEPARATOR, array(JPATH_ROOT, 'images', 'taxibooking', 'userphoto')), 0777, true);
	    //}
	    
	    jimport( 'joomla.filesystem.folder' );
	    JFolder::create(JPATH_ROOT.DS."images".DS."taxibooking".DS."userphoto");
	    
	    //Import filesystem libraries. Perhaps not necessary, but does not hurt
	    jimport('joomla.filesystem.file');
	    
	    $user_photo = 'images/taxibooking/userphoto/'.$file_name;
	    
	    $new_filepath = JPath::clean(implode(DIRECTORY_SEPARATOR, array(JPATH_ROOT, 'images', 'taxibooking', 'userphoto', $file_name)));
	    JFile::move($targetFile, $new_filepath);
	    JFile::delete(JPATH_COMPONENT.DS.'uploads'.DS.$file_name);
	    
	    $sql = $db->getQuery(true)
		    ->update($db->qn('#__taxibooking_users'))
		    ->set('`photo` = '.$db->Quote($user_photo))
		    ->where('user_id = '. (int)$user->get('id'));
	    $db->setQuery($sql);
	    $db->execute();
	    
	    $json_result['msg'] = 'success';
	    $json_result['fileUrl'] = JURI::root().'images/taxibooking/userphoto/'.$file_name;
	    
	    $session->set('new_photo_uploaded', 1);
	}
	
	echo json_encode($json_result);
	exit();
    }
    public function updateProfileAjax()
    {
	$app = JFactory::getApplication();
	$db = JFactory::getDBO();
	$date = JFactory::getDate();
        $user = JFactory::getUser();
	$userId = $user->get('id');
	
	$json_result = array('error' => 0, 'msg' => '');
        
	$profile_title  = JRequest::getVar('profile_title', '');
	$profile_phone  = JRequest::getVar('profile_phone', '');
	
	if($userId > 0){
	    if($profile_title!=""){
		$sql = $db->getQuery(true)
			->update($db->qn('#__taxibooking_users'))
			->set('`name` = '.$db->Quote($profile_title))
			->where('user_id = '. (int)$userId);
		$db->setQuery($sql);
		$db->execute();
		
		$json_result['msg'] = $profile_title;
	    }
	    elseif($profile_phone!=""){
		$sql = $db->getQuery(true)
			->update($db->qn('#__taxibooking_users'))
			->set('`phone` = '.$db->Quote($profile_phone))
			->where('user_id = '. (int)$userId);
		$db->setQuery($sql);
		$db->execute();
		
		$json_result['msg'] = $profile_phone;
	    }
	}
	else {
	    $json_result = array('error' => 1, 'msg' => 'User is not logged in.');
	}
	
	echo json_encode($json_result);
	exit();
    }
    public function cancelOrderAjax()
    {
	$app = JFactory::getApplication();
	$db = JFactory::getDBO();
	$date = JFactory::getDate();
        $user = JFactory::getUser();
	$userId = $user->get('id');
	$elsettings =  booking_helper::config();
	
	jimport( 'joomla.html.html' );
	$now =  JHtml::date('now', 'Y-m-d H:i:s');
	
	$json_result = array('error' => 0, 'msg' => '');
        
	$order_id  = JRequest::getInt('cid', 0, 'post');
	$order_number  = JRequest::getVar('code', '', 'post');
	
	if( ($order_id > 0 || $order_number!="") && (int)$elsettings->booking_cancellation_allowed==1)
	{
	    $query = $db->getQuery(true);
	    $query->select('a.*');
	    $query->from($db->quoteName('#__taxibooking_orders') . ' AS a');
	    if($order_id>0){
		$query->where('a.id = '. (int)$order_id);
	    }
	    if($order_number!=""){
		$query->where('a.order_number = '. $db->Quote($order_number));
	    }
	    //$query->where('a.datetime1 > '. strtotime($now));
	    //$query->where('a.state != -1');
	    
	    $db->setQuery($query);
	    $db->query();
	    $order = $db->loadObject();
	    
	    if($order)
	    {
		$query = $db->getQuery(true);
		$query->select('DISTINCT order_id');
		$query->from('#__taxibooking_order_copyusers');
		$query->where('user_id = '.(int)$userId);
		$db->setQuery((string)$query);
		$copy_order_ids = $db->loadColumn();
		
		$booking_cancellation_prior_sec = (float)$elsettings->booking_cancellation_prior_hrs*3600;
		
		$min_time = $order->datetime1 - $booking_cancellation_prior_sec;
		//echo date('Y-m-d H:i:s', $min_time);
		
		if((int)$order->state==0){
		    $json_result = array('error' => 1, 'msg' => JText::_('ORDERS_TABLE_CANCEL_BOOKING_ALREADY_CANCELLED'));
		}
		elseif(!empty($copy_order_ids) && in_array($order->id, $copy_order_ids)){ // copied user can not cancel order
		    $json_result = array('error' => 1, 'msg' => JText::_('ORDERS_TABLE_CANCEL_COPY_ORDER_NOT_ALLOWED'));
		}
		elseif(strtotime($now) > $min_time || (int)$order->state==-1 || $order->datetime1 < strtotime($now)){
		    $json_result = array('error' => 1, 'msg' => JText::sprintf('ORDERS_TABLE_CANCEL_BOOKING_NOT_ALLOWED', $elsettings->booking_cancellation_prior_hrs));
		}
		else {
		    booking_helper::update_order_status($order->id, array('order_status'=>0), true);
		    $json_result = array('error' => 0, 'msg' => JText::_('ORDERS_TABLE_CANCEL_BOOKING_SUCCESS'));
		}
	    }
	    else {
		$json_result = array('error' => 1, 'msg' => 'Order not found!');
	    }
	}
	else {
	    $json_result = array('error' => 1, 'msg' => 'Order not found!');
	}
	
	echo json_encode($json_result);
	exit();
    }
}