<?php

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

/**
 * Component Item Controller
 */
class TaxiBookingControllerFlightcheck extends TaxiBookingController
{
	const API_KEY = '8c7eb3-984d2e';
	/**
	 * Constructor
	 *
	 * @since 1.0
	 */
	function __construct()
	{
		parent::__construct();
	}

	function check() 
	{
		$orders = $this->getOrders();
		foreach ($orders as $key => $value) {
			if (!$value->driver_notified) {
				$this->notifyUpcomingDriver($value);
				$this->notifyUpcomingClient($value);
			}
			if ($flightInfo = $this->getEtaForFlight($value->flightno)) {
				$this->sendNotification($value->driver_id, $value->names, $flightInfo);
			}

			
		}
		// debug:
		// $this->sendPush('b2af7a5f-5667-41ef-8826-dca1f62d5a4c', 'name', 'subject', 'message', 'something-flight');

		// 1. get all orders from db with flight number and start date less than 4 hours from now.
		// 2. match flight number with pickup address (optional check) // also validate flight number in application
		// 3. get flight ETA from api.
		// 4. if ETA is different than schedule, send notifications and private message to driver.
		return;
	}

	function notifyUpcomingDriver($order)
	{
		$deviceTokens = $this->getDeviceTokens($order->driver_id);
		$subject = 'Upcoming booking';
		$message = 'Hello! You have an upcoming booking, pickup at ' . $order->begin . ' for client ' . $order->names . ' at ' . date('Y-m-d H:i', $order->datetime1) . '. We will notify you if there is a change in the scheduled arrival time.';
		try {
			foreach ($deviceTokens as $token) {
				$this->sendPush($token, 'Flight Tracker Kabsky', $subject, $message, $order->driver_id);
			}
			$update = new stdClass();
			$update->id = $order->id;
			$update->driver_notified = 1;
			return JFactory::getDbo()->updateObject('#__taxibooking_orders', $update, 'id');
		} catch(\Exception $e) {
			// nothing
		}

	}

	function notifyUpcomingClient($order)
	{
		$user_id = $this->getUserFromEmail($order->email);
		$deviceTokens = $this->getDeviceTokens($user_id);
		$subject = 'Upcoming trip from ' . $order->begin;
		$message = 'Hello! You have an upcoming trip, pickup at ' . $order->begin . ' at ' . date('Y-m-d H:i', $order->datetime1) . '. We will notify you if there is a change in the scheduled arrival time.';
		try {
			foreach ($deviceTokens as $token) {
				$this->sendPush($token, 'Kabsky Customer Support', $subject, $message, $user_id);
			}
			$update = new stdClass();
			$update->id = $order->id;
			$update->driver_notified = 1;
			return JFactory::getDbo()->updateObject('#__taxibooking_orders', $update, 'id');
		} catch(\Exception $e) {
			// nothing
		}

	}

	function getUserFromEmail($email)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id');
		$query->from($db->quoteName('#__users'));
		$query->where($db->quoteName('email')." = ".$db->quote($email));
		$db->setQuery($query);

		return $db->loadResult();
	}

	function getOrders()
	{
		$now = time() - 14400; // 4 hours ago >> 14.400 seconds
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'names', 'email', 'driver_id', 'message', 'begin', 'extras', 'driver_notified', 'datetime1')));
		$query->from($db->quoteName('#__taxibooking_orders'));
		$query->where($db->quoteName('datetime1')." >= ".$db->quote($now));
		$query->order('datetime1 DESC');
		$db->setQuery($query);
		$results = $db->loadObjectList();
		$cleanResults = $this->removeNoFlightNumbers($results);

		return $cleanResults;
	}

	function removeNoFlightNumbers($orders)
	{
		$cleanOrders = [];
		foreach ($orders as $key => $value) {
			$extras = unserialize($value->extras);
			if (!empty($extras['user_details'][2]['value']) && $extras['user_details'][2]['value'] != 'null' && $extras['user_details'][2]['value'] != 'None') {
				$value->flightno = str_replace(' ', '', $extras['user_details'][2]['value']);
				unset($orders[$key]->extras);
			}
			$cleanOrders[] = $value;
		}

		return $cleanOrders;
	}

	function checkOrderWithFlightAndLocation($flightNo, $location)
	{

	}

	function getEtaForFlight($flightNo)
	{
		// todo: check if status active is needed and also arrival.
		$endpoint = 'http://aviation-edge.com/v2/public/timetable?key=' . self::API_KEY .'&status=active&type=arrival&flight_iata=' . $flightNo;
		$ch = curl_init($endpoint);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		$data = curl_exec($ch);
		curl_close($ch);
		$data2 = json_decode($data, true);
		
		if (!isset($data2['error']) && $data2[0]['status'] == 'active') {

			$scheduled = $data2[0]['arrival']['scheduledTime'];
			$estimated = $data2[0]['arrival']['estimatedTime'];
			$minimum = strtotime("-3 minutes", strtotime($scheduled));
			$maximum = strtotime("+3 minutes", strtotime($scheduled));
			if (strtotime($estimated) > $maximum || strtotime($estimated) < $minimum) {
				$flightInfo = [];
				$flightInfo['number'] = $flightNo;
				$flightInfo['scheduled'] = $scheduled;
				$flightInfo['estimated'] = $estimated;
				return $flightInfo;
			}
		}
		
		return false;
	}

	function sendNotification($driver_id, $names, $flightInfo) 
	{
		$deviceTokens = $this->getDeviceTokens($driver_id);
		$subject = 'Flight schedule changed for ' . $names;
		$message = 'The flight number ' . $flightInfo['number'] . ' scheduled to land at ' . $flightInfo['scheduled'] . ' was rescheduled. Estimated time for landing: ' . $flightInfo['estimated'];
		foreach ($deviceTokens as $token) {
			$this->sendPush($token, 'Flight Tracker Kabsky', $subject, $message, $driver_id); // todo check if those notifications are sent.
		}
	}

	function getDeviceTokens($id) 
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('token');
		$query->from($db->quoteName('#__user_tokens'));
		$query->where($db->quoteName('user_id')." = ".$db->quote($id));
		$db->setQuery($query);
		$result = $db->loadAssocList();
		$cleanResults = [];
		foreach ($result as $key => $value) {
			$cleanResults[] = $value['token'];
		}

		return $cleanResults;
	}

	function sendPush($token, $name, $subject, $message, $uid)
	{
		$content = array(
			"en" => $message
		);
		
		$headings = array(
			"en" => 'New message from ' . $name . ': ' . $subject
		);
		
		$payload = array(
			'app_id' => "f9a18580-b00f-40fb-aab0-e8f449c01e7b",
			'include_player_ids' => array($token),
			'headings' => $headings,
			'contents' => $content
		);
		
		$fields = json_encode($payload);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8'));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

		$result = curl_exec($ch);
		$res = json_decode($result);

		if ($res->data->status == 'ok') {
			return true;
		}
		return false;
	}

}