<?php
/**
 * Last edited 10/10/2019 at 11:30
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

/**
 * Component Item Controller
 */
class TaxiBookingControllerOnepage extends TaxiBookingController
{
	/**
	 * Constructor
	 *
	 * @since 1.0
	 */
	function __construct()
	{
		parent::__construct();
	}

	/**
	* Get price according to the user's choice
	*
	* @access	public
	*/
	public function getPrice()
	{
		// Initialize variables
		$db = JFactory::getDBO();
		$user =  JFactory::getUser();
		$session =  JFactory::getSession();

		// Get the component configuration
		$elsettings =  booking_helper::config();

		//get data from request
		$post = JRequest::get('post');

		$booking_type = JRequest::getVar('booking_type', 'address');
		$session->set('booking_type', $booking_type);


		if (isset($post['from_dest'])) {
		    $from_dest_val = $post['from_dest'];
		} else{
		    $from_dest_val = -1;
		}
		$session->set('from_dest', $from_dest_val);

		if (isset($post['to_dest'])) {
		    $to_dest_val = $post['to_dest'];
		} else {
		    $to_dest_val = -1;
		}
		$session->set('to_dest', $to_dest_val);

		$begin = $end = '';
		$lat_long_from = $lat_long_to = array();

		$route_swapped = JRequest::getInt('route_swapped', 0);
		$session->set('route_swapped', $route_swapped);

		$data_source = JRequest::getVar('data_source', 'component');

		// check route selection
		$route_category_fld = JRequest::getVar('route_category_fld', 0);
		$route_category_dropoff_fld = JRequest::getVar('route_category_dropoff_fld', 0);
		$route_from_fld = JRequest::getVar('route_from_fld', 0);
		$route_to_fld = JRequest::getVar('route_to_fld', 0);

		$route_category = JRequest::getInt('route_category', 0);
		$route_category_dropoff = JRequest::getInt('route_category_dropoff', 0);
		$route_from = JRequest::getInt('route_from', 0);
		$route_to = JRequest::getInt('route_to', 0);

		$shuttle_pickup = JRequest::getVar('shuttle_pickup', '');
		$shuttle_pickup_poi = JRequest::getInt('shuttle_pickup_poi', 0);
		$shuttle_dropoff = JRequest::getVar('shuttle_dropoff', '');
		$shuttle_dropoff_poi = JRequest::getInt('shuttle_dropoff_poi', 0);
		$shuttletime = JRequest::getVar('shuttletime', 0);
		$shuttle_route_id = JRequest::getInt('shuttle_route_id', 0);
		$shuttle_passengers = JRequest::getInt('shuttle_passengers', 0);

		$waypoint_coords = array();

		// clears previous session
		booking_helper::clear_booking_data();

		// if module booking form submitted,
		// booking form pickup/dropoff data has already stored in current session
		if($data_source=='component')
		{
			if($booking_type=='offers')  // customer selected fixed route
			{
				if($route_to<=0) {
					$result['error'] = 1;
					$result['msg'] = JText::_('CHOOSE_ROUTE_TO');
					echo json_encode($result);
					exit();
				}
				else {
					$session->set('route_category_fld', $route_category_fld);
					$session->set('route_category', $route_category);
					$session->set('route_category_dropoff_fld', $route_category_dropoff_fld);
					$session->set('route_category_dropoff', $route_category_dropoff);
					$session->set('route_from_fld', $route_from_fld);
					$session->set('route_to_fld', $route_to_fld);
					$session->set('route_from', $route_from);
					$session->set('route_to', $route_to);

					$begin = booking_helper::get_place_field_by_id($route_from);
					$poi_where = array('p.id = '.$db->Quote($route_from));
					$poiObj = booking_helper::get_specific_place_details($poi_where);
					if($poiObj){
						$lat_long_from = array($poiObj->lat, $poiObj->long);
					}

					$end = booking_helper::get_place_field_by_id($route_to);
					$poi_where = array('p.id = '.$db->Quote($route_to));
					$poiObj = booking_helper::get_specific_place_details($poi_where);
					if($poiObj){
						$lat_long_to = array($poiObj->lat, $poiObj->long);
					}
				}
			}
			elseif($booking_type=='address')
			{
				$pickup_poi = JRequest::getInt('pickup_poi', 0);
				$begin = JRequest::getVar('address_from', '');
				$address_from_lat = JRequest::getVar('address_from_lat', '');
				$address_from_lng = JRequest::getVar('address_from_lng', '');

				$dropoff_poi = JRequest::getInt('dropoff_poi', 0);
				$end = JRequest::getVar('address_to', '');
				$address_to_lat = JRequest::getVar('address_to_lat', '');
				$address_to_lng = JRequest::getVar('address_to_lng', '');

				if($address_from_lat=="" || $address_from_lng=="") {
					$result['error'] = 1;
					$result['msg'] = JText::_('SELECT_COLLECTION_PLACE');
					echo json_encode($result);
					exit();
				}
				elseif($address_to_lat=="" || $address_to_lng=="" ){
					$result['error'] = 1;
					$result['msg'] = JText::_('SELECT_DESTINATION_PLACE');
					echo json_encode($result);
					exit();
				}

				$session->set('pickup_poi', $pickup_poi);
				$session->set('address_from', $begin);
				$session->set('address_from_lat', $address_from_lat);
				$session->set('address_from_lng', $address_from_lng);
				$lat_long_from = array($address_from_lat, $address_from_lng);

				$session->set('dropoff_poi', $dropoff_poi);
				$session->set('address_to', $end);
				$session->set('address_to_lat', $address_to_lat);
				$session->set('address_to_lng', $address_to_lng);
				$lat_long_to = array($address_to_lat, $address_to_lng);

				// waypoints
				$waypoints_post = JRequest::getVar('waypoints', array(), 'post', 'array');
				$waypoints_lat_post = JRequest::getVar('waypoints_lat', array(), 'post', 'array');
				$waypoints_lng_post = JRequest::getVar('waypoints_lng', array(), 'post', 'array');
				$waypoints_stop_duration_post = JRequest::getVar('waypoints_stop_duration', array(), 'post', 'array');

				$waypoints = array();
				$waypoints_lat = array();
				$waypoints_lng = array();
				$waypoints_stop_duration = array();

				$total_waypoint_duration = 0;
				for($i=0;$i<count($waypoints_post);$i++)
				{
					if($waypoints_post[$i]!="" && $waypoints_lat_post[$i]!="" && $waypoints_lng_post[$i]!="")
					{
						$waypoints[] = $waypoints_post[$i];
						$waypoints_lat[] = $waypoints_lat_post[$i];
						$waypoints_lng[] = $waypoints_lng_post[$i];
						$waypoints_stop_duration[] = $waypoints_stop_duration_post[$i];

						$total_waypoint_duration += $waypoints_stop_duration_post[$i];

						$waypoint_coords[] = array($waypoints_lat_post[$i], $waypoints_lng_post[$i]);
					}
				}

				$session->set('waypoints', $waypoints);
				$session->set('waypoints_lat', $waypoints_lat);
				$session->set('waypoints_lng', $waypoints_lng);
				$session->set('waypoints_stop_duration', $waypoints_stop_duration);
				$session->set('total_waypoint_duration', $total_waypoint_duration);
			}
			elseif($booking_type=='shuttle')
			{
				$session->set('shuttle_pickup', $shuttle_pickup);
				$session->set('shuttle_pickup_poi', $shuttle_pickup_poi);
				$session->set('shuttle_dropoff', $shuttle_dropoff);
				$session->set('shuttle_dropoff_poi', $shuttle_dropoff_poi);
				$session->set('shuttletime', $shuttletime);
				$session->set('shuttle_passengers', $shuttle_passengers);
				$session->set('shuttle_route_id', $shuttle_route_id);

				$begin = $shuttle_pickup;
				$end = $shuttle_dropoff;

				$poi_where = array('p.id = '.$db->Quote($shuttle_pickup_poi));
				$poiObj = booking_helper::get_specific_place_details($poi_where);
				if($poiObj){
					$this->logReturn('lat_long_from', [$poiObj->lat, $poiObj->long]);
					$lat_long_from = array($poiObj->lat, $poiObj->long);
				}

				$poi_where = array('p.id = '.$db->Quote($shuttle_dropoff_poi));
				$poiObj = booking_helper::get_specific_place_details($poi_where);
				if($poiObj){
					$this->logReturn('lat_long_to', [$poiObj->lat, $poiObj->long]);
					$lat_long_to = array($poiObj->lat, $poiObj->long);
				}
			}

			$session->set('begin', $begin);
			$session->set('end', $end);
			$session->set('lat_long_from', $lat_long_from);
			$session->set('lat_long_to', $lat_long_to);

			if (isset($post['returnjurney'])) {
			    $session->set('returnjurney', 1);
			    $returnjurney = 1;
			} else {
			    $returnjurney = 0;
			    $session->set('returnjurney', 0);
			}

			$distance = 0;
			$duration = '';
			if(!empty($lat_long_from) && !empty($lat_long_to))
			{
				$call_gapi = true;
				// if show map in shuttle is NO, no need to use google API to collect distance and duration
				$booking_maps = booking_helper::getBookingMapsState($elsettings);
				if($booking_type=='shuttle' && $booking_maps['shuttle']==0){
					$call_gapi = false;
					$gapi_status = "OK";
					$distance = $duration_seconds = 0;
				}

				if($call_gapi){
					list($distance,$duration_seconds,$gapi_status,$gapi_msg) = booking_helper::calculateDistance($lat_long_from[0], $lat_long_from[1], $lat_long_to[0], $lat_long_to[1],$elsettings->distance_unit,$waypoint_coords);
				}

				if($gapi_status=="OK")
				{
					if($call_gapi && $distance==0)
					{
						$result['error'] = 1;
						$result['msg'] = JText::_('SESSION_EXPIRED');
					}
					else
					{
						//$distance = number_format($distance,2);
						$distance_text = number_format($distance,2).' '.$elsettings->distance_unit.'s';

						// waypoint time
						$total_waypoint_duration = $session->get('total_waypoint_duration', 0);
						$duration_seconds += $total_waypoint_duration*60;

						$duration_text = booking_helper::secondsToTime($duration_seconds);
						//$distance = ceil($distance);
						$session->set('distance', $distance); // distance ins KM or Mile
						$session->set('duration', $duration_text);
						$session->set('duration_seconds', $duration_seconds);

						if($returnjurney == 1){
							$end .= ' '.JText::_('AND_RETURN');
							$distance_text .= ' '.JText::_('EACH_WAY');
						}

						$result['msg'] = array( 'begin' => $begin,
									'end' => $end,
									'lat_long_from' => $lat_long_from,
									'lat_long_to' => $lat_long_to,
									'distance' => $distance_text,
									'duration' => $duration_text,
									'map_zoom' => $elsettings->map_zoom,
									'show_map' => $booking_maps[$booking_type],
									'show_direction' => ($elsettings->dir_height > 0 ) ? 1 : 0,
									'returnjurney' => $returnjurney,
									'data_source' => $data_source
								    );
					}
				}
				elseif ($gapi_status=="ZERO_RESULTS") {
					//indicates that the geocode was successful but returned no results. This may occur if the geocode was passed a non-existent address or a latlng in a remote location.
					$result['error'] = 1;
					$result['msg'] = 'The geocode was successful but returned no results. This may occur if the geocoder was passed a non-existent address.';
				}
				elseif ($gapi_status=="OVER_QUERY_LIMIT") {
					//indicates that you are over your quota of geocode requests against the google api
					$result['error'] = 1;
					$result['msg'] = $gapi_msg;
				}
				elseif ($gapi_status=="REQUEST_DENIED") {
					//indicates that your request was denied, generally because of lack of a sensor parameter.
					$result['error'] = 1;
					$result['msg'] = $gapi_msg;
				}
				elseif ($gapi_status=="INVALID_REQUEST" || $gapi_status=="NOT_FOUND") {
					//generally indicates that the query (address or latlng) is missing.
					$result['error'] = 1;
					$result['msg'] = 'The query (address or latlng) is missing.';
				}
				else {
					$result['error'] = 1;
					$result['msg'] = $gapi_msg;
				}
			}
			else
			{
				$result['error'] = 1;
				$result['msg'] = JText::_('SESSION_EXPIRED');
			}
		}
		elseif($data_source=='module')
		{
			$booking_maps = booking_helper::getBookingMapsState($elsettings);

			$begin = $session->get('begin', '');
			$end = $session->get('end', '');
			$lat_long_from = $session->get('lat_long_from', array());
			$lat_long_to = $session->get('lat_long_to', array());
			$returnjurney = $session->get('returnjurney', 0);
			$distance = $session->get('distance', 0); // distance ins KM or Mile
			$duration_text = $session->get('duration', '');
			$duration_seconds = $session->get('duration_seconds', 0);

			$distance_text = number_format($distance,2).' '.$elsettings->distance_unit.'s';

			// waypoint time
			$total_waypoint_duration = $session->get('total_waypoint_duration', 0);
			$duration_seconds += $total_waypoint_duration*60;

			$duration_text = booking_helper::secondsToTime($duration_seconds);

			if($returnjurney == 1){
				$end .= ' '.JText::_('AND_RETURN');
				$distance_text .= ' '.JText::_('EACH_WAY');
			}

			$result['msg'] = array( 'begin' => $begin,
						'end' => $end,
						'lat_long_from' => $lat_long_from,
						'lat_long_to' => $lat_long_to,
						'distance' => $distance_text,
						'duration' => $duration_text,
						'map_zoom' => $elsettings->map_zoom,
						'show_map' => $booking_maps[$booking_type],
						'show_direction' => ($elsettings->dir_height > 0 ) ? 1 : 0,
						'returnjurney' => $returnjurney,
						'data_source' => $data_source,
					    );
		}
		$this->logReturn('getPrices', $result);
		echo json_encode($result);
		exit();
	}

	public function logReturn($topic, $return)
	{
		$log  = $topic . "  User: ".$_SERVER['REMOTE_ADDR'].' - '.date("F j, Y, g:i a").PHP_EOL.
        json_encode($return).PHP_EOL.PHP_EOL;
		//Save string to log, use FILE_APPEND to append.
		file_put_contents('./log_'.date("j.n.Y").'.log', $log, FILE_APPEND);
	}

	// get vehicle list according to the customer's choice
	public function getVehicles()
	{
		$result = array('error' => 0, 'msg' => '');
		$db = JFactory::getDBO();
		$session =  JFactory::getSession();
		$user =  JFactory::getUser();

		$siteOffset = booking_helper::set_tbtimezone();
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = strtotime($dtnow->format('Y-m-d H:i:s', true));

		$booking_type = JRequest::getVar('booking_type', 'address');
		$session->set('booking_type', $booking_type);

		// Get the component configuration
		$elsettings =  booking_helper::config();

		// clears previous session
		booking_helper::clear_booking_data();

		$post = JRequest::get('post');

		//$postcode1='PO9'; //fuck googleapis
		// $postcode1 = 'PO95TL';
        $base_address = '50.8510,-0.9797'; //Thanks, google.

        $query = $db->getQuery(true);
        $query->select('text');
        $query->from('#__taxibooking_configs');
        $query->where('id = 4');
        $db->setQuery($query);
        $conf_obj = $db->loadObject();
        $conf_arr = unserialize($conf_obj->text);

        $apikey = $conf_arr['distance_api_key'];
		$address_to = $post['address_to_lat'] . ',' . $post['address_to_lng'];
		$address_from = $post['address_from_lat'] . ',' . $post['address_from_lng'];
    	$result1 = array();
		$result2 = array();
		$result3 = array();
		$result4 = array();
		$result5 = array();
		$result6 = array();

		//postcode for Goodwood Racecourse
    	$goodwood_racecourse = '50.8692906,-0.7533467';
		//postcode for London Congestion charge
		$london_congestion_charge = '51.5114864,-0.1181857';


		//for calculating from base
		$url1 = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=$base_address&destinations=$address_to&mode=car&language=en-EN&sensor=false&key=$apikey";
		$url2 = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=$base_address&destinations=$address_from&mode=car&language=en-EN&sensor=false&key=$apikey";
		//for calculating from Goodwood
		$url3 = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=$goodwood_racecourse&destinations=$address_to&mode=car&language=en-EN&sensor=false&key=$apikey";
		$url4 = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=$goodwood_racecourse&destinations=$address_from&mode=car&language=en-EN&sensor=false&key=$apikey";
		//for calculating from LCCZ
		$url5 = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=$london_congestion_charge&destinations=$address_to&mode=car&language=en-EN&sensor=false&key=$apikey";
		$url6 = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=$london_congestion_charge&destinations=$address_from&mode=car&language=en-EN&sensor=false&key=$apikey";

    // $data1 = @file_get_contents($url1);
    // $data2 = @file_get_contents($url2); //well this shit is not working on this piece of shit server.
		function curl_get_contents($url)
							{
							    $ch = curl_init();

							    curl_setopt($ch, CURLOPT_HEADER, 0);
							    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
							    curl_setopt($ch, CURLOPT_URL, $url);

							    $data = curl_exec($ch);
							    curl_close($ch);

							    return $data;
							}
				$data1 = curl_get_contents($url1);
				$data2 = curl_get_contents($url2);
				$data3 = curl_get_contents($url3);
				$data4 = curl_get_contents($url4);
				$data5 = curl_get_contents($url5);
				$data6 = curl_get_contents($url6);

		$result1 = json_decode($data1, true);
		$result2 = json_decode($data2, true);
		$result3 = json_decode($data3, true);
		$result4 = json_decode($data4, true);
		$result5 = json_decode($data5, true);
		$result6 = json_decode($data6, true);

		$distance1 = $result1['rows'][0]['elements'][0]['distance']['value'] / 1000; // distance between base and "to" address
		$distance2 = $result2['rows'][0]['elements'][0]['distance']['value'] / 1000; // distance between base and "from" address
		$distance3 = $result3['rows'][0]['elements'][0]['distance']['value'] / 1000; // distance between goodwood_racecourse and "to" address
		$distance4 = $result4['rows'][0]['elements'][0]['distance']['value'] / 1000; // distance between goodwood_racecourse and "from" address
		$distance5 = $result5['rows'][0]['elements'][0]['distance']['value'] / 1000; // distance between london_congestion_charge and "to" address
		$distance6 = $result6['rows'][0]['elements'][0]['distance']['value'] / 1000; // distance between london_congestion_charge and "from" address


		$booking_type = JRequest::getVar('booking_type', 'address');
		$session->set('booking_type', $booking_type);

		$result = array('error' => 0, 'msg' => '');


		$result['distances'] = array(
			'distance1'=> $distance1,
			'distance2'=> $distance2
		);

		$datepicker_type = JRequest::getVar('datepicker_type', 'jquery');
		$route_from		 = $session->get('route_from', 0);
        $route_to 		 = $session->get('route_to', 0);
		$airports1		 = $session->get('address_from', '');
		$airports2 		 = $session->get('address_to', '');
		$pickup_poi 	 = $session->get('pickup_poi', 0);
		$dropoff_poi	 = $session->get('dropoff_poi', 0);
		$adultseats		 = JRequest::getInt('passengers', 0);
		$suitcases 		 = JRequest::getInt('suitcases', 0);
		$boosterseats	 = JRequest::getInt('boosterseats', 0);
		$boosterseats2 	 = JRequest::getInt('boosterseats2', 0);
		$infantseats	 = JRequest::getInt('infantseats', 0);
		$chseats 		 = JRequest::getInt('chseats', 0);
		$chseats2		 = JRequest::getInt('chseats2', 0);
		$chseats3 		 = JRequest::getInt('chseats3', 0);
		$extras 		 = JRequest::getVar('extras', array(), 'post', 'array');
		$hourly_hr		 = JRequest::getInt('hourly_hr', 0);
		$hourly_min		 = JRequest::getInt('hourly_min', 0);

		$tmpl = JRequest::getVar('tmpl', '');
		$session->set('tmpl', $tmpl);

		// shuttle session data
		$shuttle_pickup = $session->get('shuttle_pickup', '');
		$shuttle_pickup_poi = $session->get('shuttle_pickup_poi', 0);
		$shuttle_dropoff = $session->get('shuttle_dropoff', '');
		$shuttle_dropoff_poi = $session->get('shuttle_dropoff_poi', 0);
		$shuttletime = $session->get('shuttletime', 0);
		$shuttle_route_id = $session->get('shuttle_route_id', 0);
		$shuttle_passengers = $session->get('shuttle_passengers', 0);

		if($booking_type=='shuttle'){
			$adultseats = $shuttle_passengers;
		}

		$session->set('passengers', $adultseats);
		$session->set('suitcases', $suitcases);
		$session->set('infantseats', $infantseats);
		$session->set('chseats', $chseats);
		$session->set('chseats2', $chseats2);
		$session->set('chseats3', $chseats3);
		$session->set('boosterseats', $boosterseats);
		$session->set('boosterseats2', $boosterseats2);

		$session->set('hourly_hr', $hourly_hr);
		$session->set('hourly_min', $hourly_min);

		$date1 = $time1 = $date2 = $time2 = "";

		if($booking_type=='shuttle')
		{
			$post["orderdate"] = $post["orderdate_shuttle"];
			$date1 = $this->check_input($post["orderdate"]);
			if($elsettings->date_format=='mm-dd-yy') {
			    $date1_arr = explode('-',$date1);
			    $date1 =  $date1_arr[1].'-'.$date1_arr[0].'-'.$date1_arr[2];
			}
		}
		else {
			if($datepicker_type=='jquery') // jquery datepicker
			{
			    if(!empty($post["orderdate"]))
			    {
				if($post["orderdate"]!='' && $post["orderdate"]!='Date')
				{
				    $date1 = $this->check_input($post["orderdate"]);

				    if($elsettings->date_format=='mm-dd-yy') {
					$date1_arr = explode('-',$date1);
					$date1 =  $date1_arr[1].'-'.$date1_arr[0].'-'.$date1_arr[2];
				    }
				}
			    }
			}
			elseif($datepicker_type=='inline') // simple dropdown datepicker
			{
			    $date1 =  $post['pickup_day'].'-'.$post['pickup_month'].'-'.$post['pickup_year'];
			}
		}

		if (isset($post['returnjurney'])) {
		    $returnjurney = 1;
		}
		else {
		    $returnjurney = 0;
		}

		if(in_array($booking_type, array('hourly', 'shuttle'))){
			$returnjurney = 0;
		}
		$session->set('returnjurney', $returnjurney);

		// consider return discount hour
		$return_wait_discount = 0;
		$return_wait_hr = -1;
		if(!empty($post["return_wait_hr"]) && (int)$post["return_wait_hr"] > 0)
		{
			$return_wait_hr = $post['return_wait_hr'];
			$return_wait_discount = booking_helper::calculate_wait_time_discount($return_wait_hr);

			$session->set('return_wait_hr', $return_wait_hr);
			$session->set('return_wait_discount', $return_wait_discount);
		}

		if($datepicker_type=='jquery') // jquery datepicker
		{
		    if(!empty($post["orderdatereturn"]))
		    {
			if ($post["orderdatereturn"]!='' && $post["orderdatereturn"]!='Return Date')
			{
			    $date2 = $this->check_input($post["orderdatereturn"]);

			    if($elsettings->date_format=='mm-dd-yy') {
				$date2_arr = explode('-',$date2);
				$date2 =  $date2_arr[1].'-'.$date2_arr[0].'-'.$date2_arr[2];
			    }
			}
		    }
		}
		elseif($datepicker_type=='inline') // simple dropdown datepicker
		{
			if(!empty($post["return_day"]))
			{
				$date2 =  $post['return_day'].'-'.$post['return_month'].'-'.$post['return_year'];
			}
		}

		if($booking_type=='shuttle')
		{
			$time1 = $shuttletime;
		}
		else {
			if(isset($post["selPtHr1"]) && ($post["selPtHr1"]!='') && isset($post["selPtMn1"]) && ($post["selPtMn1"]!=''))
			{
			    $time1 = $this->check_input($post['selPtHr1']) . ":" . $this->check_input($post['selPtMn1']);

			    if($elsettings->time_format=='12hr') {
				$time1 .=  $post["seltimeformat1"];
			    }
			}

			if (isset($post["selPtHr2"]) && ($post["selPtHr2"]!='') && isset($post["selPtMn2"]) && ($post["selPtMn2"]!='')) {
			    $time2 = $this->check_input($post['selPtHr2']) . ":" . $this->check_input($post['selPtMn2']);

			    if($elsettings->time_format=='12hr') {
				$time2 .=  $post["seltimeformat2"];
			    }
			}
		}

		$session->set('date1', $date1);
		$session->set('time1', $time1);
		$session->set('date2', $date2);
		$session->set('time2', $time2);

		if($date1!="" && $time1!="")
		{
			$order_date_time_str = strtotime($date1.' '.$time1);
			$order_date_time = date("Y-m-d H:i:s", $order_date_time_str);
			$session->set('timestr1', $order_date_time_str);
		}

		if($date2!="" && $time2!="")
		{
		    $orderreturn_date_time_str = strtotime($date2.' '.$time2);
		    $orderreturn_date_time = date("Y-m-d H:i:s", $orderreturn_date_time_str);
		    $session->set('timestr2', $orderreturn_date_time_str);

            $pickTimeFirst = strtotime($date1.' '.$time1);
			$pickupBackTime = strtotime($date2.' '.$time2);
            $session->set('pickupFromStart', $pickTimeFirst);
            $session->set('pickupBackTime', $pickupBackTime);
		}

		if($adultseats == 0)
		{
			$result['error'] = 1;
			if($booking_type=='shuttle'){
				$result['msg'] = JText::_('COM_TAXIBOOKING_NO_SHUTTLE_FOUND');
			}
			else {
				$result['msg'] = JText::_('COM_TAXIBOOKING_NO_VEHICLE');
			}
		}
		elseif($session->get('date1', '') == '' || $session->get('time1', '') == '' )
		{
		    $result['error'] = 1;
		    $result['msg'] = JText::_('ENTER_DEPARTING_DATE_WARN_MSG');
		}
		elseif($booking_type!="shuttle" && booking_helper::calculate_time_difference($dtnow, $order_date_time, 'hr') < $elsettings->restrict_time)
		{
		    $result['error'] = 1;
		    $result['msg'] = booking_helper::date_format($session->get('timestr1', ''), 'Y-m-d H:i:s', $elsettings) . ' ('.JText::sprintf('INSUFFICIENT_TIME', $elsettings->restrict_time).')';
		}
		elseif ($returnjurney==1 && ($return_wait_hr==-1) && ( $session->get('date2', '') == '' || $session->get('time2', '') == '' ) )
		{
			$result['error'] = 1;
			$result['msg'] = JText::_('ENTER_RETURN_DATE_WARN_MSG');
		}
		elseif($booking_type=='offers' && $route_from > 0 && $route_to <= 0)  // customer selected fixed route
		{
		    $result['error'] = 1;
		    $result['msg'] = JText::_('CHOOSE_ROUTE_TO');
		}

		if($result['error']==0)
		{
			$debug_array = array(
				'initial_charge' => array('title'=>'Initial Call Charge', 'total_unit'=>'none', 'charge_per_unit'=>(int)$elsettings->cost_per_call),
				'base_pickup' => array('title'=>'Base to Pickup Charge', 'total_unit'=>'string', 'charge_string'=>0),
				'dropoff_base' => array('title'=>'Dropoff to Base Charge', 'total_unit'=>'string', 'charge_string'=>0),
				'stops_charge' => array('title'=>'Stops Charge', 'total_unit'=>'', 'charge_per_unit'=>0),
				'booster_seats' => array('title'=>'Booster Seats Charge', 'total_unit'=>'string', 'charge_string'=>0),
				'infant_seats' => array('title'=>'Infant Seats Charge', 'total_unit'=>'string', 'charge_string'=>0),
				'child_seats' => array('title'=>'Child Seats Charge', 'total_unit'=>'string', 'charge_string'=>0),
				'poi_charge' => array('title'=>'POI Additional Charge', 'total_unit'=>'none', 'charge_per_unit'=>0),
				'extras_charge' => array('title'=>'Extras Charge', 'total_unit'=>'none', 'charge_per_unit'=>0),
				'fixed_route_charge' => array('title'=>'Special Route Fixed Charge', 'total_unit'=>'none', 'charge_per_unit'=>0),
			);

			$distance = $session->get('distance', 0);
			$duration = $session->get('duration', '');
			$duration_seconds = $session->get('duration_seconds', 0);

			if($booking_type=='shuttle'){
				$pickup_poi = $shuttle_pickup_poi;
				$dropoff_poi = $shuttle_dropoff_poi;
			}

		    $price = 0;
		    $booking_data = array('booking_type' => $booking_type,
					'pickup_poi' => $pickup_poi,
					'dropoff_poi' => $dropoff_poi,
					'route_from' => $route_from,
					'route_to' => $route_to,
					'lat_long_from' => $session->get('lat_long_from', array()),
					'lat_long_to' => $session->get('lat_long_to', array()),
					'adultseats' => $adultseats,
					'suitcases' => $suitcases,
					'boosterseats' => $boosterseats,
					'boosterseats2' => $boosterseats2,
					'infantseats' => $infantseats,
					'chseats' => $chseats,
					'chseats3' => $chseats3,
					'chseats2' => $chseats2,
					'hourly_hr' => $hourly_hr,
					'hourly_min' => $hourly_min
					);

			// calculate extras price
			list($selected_extras, $total_extra_price) = booking_helper::process_extras($extras);
			$session->set('selected_extras', $selected_extras);
			$session->set('total_extra_price', $total_extra_price);
			$debug_array['extras_charge']['charge_per_unit'] = $total_extra_price;

			$separate_car_price = 0;
			$route_price = 0;
			$fixed_car_prices = '';
			if($booking_type=='offers' && $route_from > 0 && $route_to > 0)  // customer selected fixed route
			{
			    $route_swapped = $session->get('route_swapped', 0);

			    $query = $db->getQuery(true);
			    $query->select('price, separate_car_price, car_prices');
			    $query->from('#__taxibooking_routes');

			    if($route_swapped==1){ // if route swapped, then interchange the route
				$query->where('route_from = '.(int) $route_to.' AND route_to = '.(int) $route_from);
			    }
			    else {
				$query->where('route_from = '.(int) $route_from.' AND route_to = '.(int) $route_to);
			    }
			    $query->where('published = 1');
			    $db->setQuery((string)$query);
			    $route_obj = $db->loadObject();

			    $route_price = $route_obj->price;
			    $separate_car_price = $route_obj->separate_car_price;
			    $fixed_car_prices = $route_obj->car_prices;

			    // check whether this fixed route has separate car price enabled and has a set of car with price
			    // if yes, the just show the list of cars with price - no calculation requried
			    // if not, then route price will be considered
			    if($separate_car_price==0)
			    {
				$price += $route_price;
				$debug_array['fixed_route_charge']['charge_per_unit'] = $route_price;
			    }
			}

			if($booking_type=='hourly')
			{
				$duration_seconds = $hourly_hr*3600 + $hourly_min*60;
				$duration_text = booking_helper::secondsToTime($duration_seconds);

				$session->set('duration', $duration_text);
				$session->set('duration_seconds', $duration_seconds);

				$duration = $session->get('duration', '');
				$duration_seconds = $session->get('duration_seconds', 0);
			}

			// collect additional charge for POIs if booking type is not HOURLY_HIRE and Shuttle
			if(!in_array($booking_type, array('hourly', 'shuttle')))
			{
			    $poi_additional_charges = booking_helper::get_poi_additional_charge($booking_data);
			    $price += $poi_additional_charges['total_additional_price'];
			    $session->set('poi_additional_charges', $poi_additional_charges);
			    $debug_array['poi_charge']['charge_per_unit'] = $poi_additional_charges['total_additional_price'];
			}
			if($boosterseats2 > 0) {
				$boosterseats = $boosterseats2;
			}
			if($infantseats3 > 0) {
				$infantseats = $infantseats3;
			} elseif($infantseats2 > 0) {
				$infantseats = $infantseats2;
			}
			if ($boosterseats > 0) {
				$price_to_added = (float)($boosterseats * $elsettings->booster_seat_price);
			    $price += $price_to_added;
			    $debug_array['booster_seats']['charge_string'] = $boosterseats .' X '.booking_helper::price_display((float)$elsettings->booster_seat_price,$elsettings) .' = '.booking_helper::price_display($price_to_added,$elsettings);
			}
			if ($infantseats > 0) {
				$price_to_added = (float)($infantseats * $elsettings->infant_seat_price);
			    $price += $price_to_added;
			    $debug_array['infant_seats']['charge_string'] = $infantseats .' X '.booking_helper::price_display((float)$elsettings->infant_seat_price,$elsettings).' = '.booking_helper::price_display($price_to_added,$elsettings);
			}
			if ($chseats > 0) {
				$price_to_added = (float)($chseats * $elsettings->child_seat_price);
			    $price += $price_to_added;
			    $debug_array['child_seats']['charge_string'] = $chseats .' X '.booking_helper::price_display((float)$elsettings->child_seat_price,$elsettings).' = '.booking_helper::price_display($price_to_added,$elsettings);
			}

			if($booking_type=='offers' && $separate_car_price==1)
			{
				$cars = booking_helper::get_fixed_route_car_set($fixed_car_prices, $booking_data);
			}
			elseif($booking_type=='shuttle')
			{
				// calculate time differnce between pickup and dropoff points
				$query = 'SELECT t1.arrival_time AS `pickup_arrival`, t2.arrival_time AS `dropoff_arrival`, '
					. ' (TIME_TO_SEC( t2.arrival_time ) - TIME_TO_SEC( t1.arrival_time )) AS `difference`'
					. ' FROM (
						SELECT arrival_time
						FROM `#__taxibooking_shuttle_route_stops` rs
						WHERE rs.route_id = '.(int)$shuttle_route_id
					. ' 	AND rs.poi_id = '.(int)$shuttle_pickup_poi
					. ' 	)t1
						JOIN (

						SELECT arrival_time
						FROM `#__taxibooking_shuttle_route_stops` rs
						WHERE rs.route_id = '.(int)$shuttle_route_id
					. ' 	AND rs.poi_id = '.(int)$shuttle_dropoff_poi
					. ' 	)t2'
				;
				//echo str_replace('#__', 'nfgwj_', $query);
				$db->setQuery($query);
				$db->query();
				$journey_duration = $db->loadObject();

				$duration_seconds = $journey_duration->difference;
				$duration_text = booking_helper::secondsToTime($duration_seconds);

				$session->set('duration', $duration_text);
				$session->set('duration_seconds', $duration_seconds);

				$duration = $session->get('duration', '');
				$duration_seconds = $session->get('duration_seconds', 0);

				// get already booked seats on current date for this route
				$shuttle_data = array('route_id' => $shuttle_route_id,
						      'order_date' => date("Y-m-d", $order_date_time_str)
						      );
				$total_seats_booked = booking_helper::shuttle_booking_count($shuttle_data);

				$query = $db->getQuery(true);
				$query->select('c.*');
				$query->from($db->quoteName('#__taxibooking_cars') . ' AS c');
				$query->join('LEFT', $db->quoteName('#__taxibooking_shuttle_routes') . ' AS r ON r.car_id = c.id');
				$query->where('r.id = '.(int)$shuttle_route_id);
				$query->where('c.published = 1');
				$query->where('c.use_as_shuttle != 0');
				$query->where('c.passenger_no > '.(int)$total_seats_booked);
				$db->setQuery((string)$query);
				$cars = $db->loadObjectList();
			}
			else // usual car price calculation for POI and address
			{
				// now list cars
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_cars');
				$query->where('published = "1"');
				$query->where('use_as_shuttle != 2'); // cars used only as shuttle will not be listed in other booking types

				if($booking_type=='address'){
					$query->where('use_in_address = 1');
				}
				if($booking_type=='offers'){
					$query->where('use_in_offers = 1');
				}

				if($adultseats > 0)
				{
				    $query->where('passenger_no >= '.(int)$adultseats);
				}
				if($suitcases > 0)
				{
				    $query->where('suitcase_no >= '.(int)$suitcases);
				}
				if($boosterseats > 0)
				{
				    $query->where('booster_seat_no >= '.(int)$boosterseats);
				}
				if($infantseats > 0)
				{
				    $query->where('infant_seat_no >= '.(int)$infantseats);
				}
				if($chseats > 0)
				{
				    $query->where('child_seat_no  >= '.(int)$chseats);
				}

				if($booking_type=='hourly')
				{
				    $query->where('hourly_hire_enabled  = 1');
				    $query->where('hourly_hire_min_hr <= '.($hourly_hr+($hourly_min/100)) );
				    $query->where('hourly_hire_max_hr >= '.($hourly_hr+($hourly_min/100)) );
				}

				// adult + booster + child + infant must be less than the maximum passenger seats for a car
				$total_passengers = (int)$adultseats+(int)$infantseats+(int)$boosterseats+(int)$chseats;

				//Hourly and Shuttle have no use of Min passengers.
				if($booking_type!='hourly'){
					$query->where('min_passenger_no <= '.$total_passengers);
				}

				$query->where('passenger_no >= '.$total_passengers);

				$query->order('price ASC');
				$db->setQuery((string)$query);
				$cars = $db->loadObjectList();
			}

			// consider base if its not shuttle booking
			if(!in_array($booking_type, array('shuttle')))
			{
				list($base_pickup_distance,
				     $base_pickup_duration,
				     $base_pickup_price,
				     $base_pickup_price_calc,
				     $dropoff_base_distance,
				     $dropoff_base_duration,
				     $dropoff_base_price,
				     $dropoff_base_price_calc) = booking_helper::considerBase($elsettings, $booking_data);

				if($booking_type=='offers'){
					if($elsettings->base_pickup_special_routes=='price_time'){
						$session->set('base_pickup_distance', $base_pickup_distance);
						$session->set('base_pickup_duration', $base_pickup_duration);
						$debug_array['base_pickup']['charge_string'] = $base_pickup_price_calc;
					}
					elseif($elsettings->base_pickup_special_routes=='time'){
						$session->set('base_pickup_distance', 0);
						$session->set('base_pickup_duration', $base_pickup_duration);
					}
					else {
						$session->set('base_pickup_distance', 0);
						$session->set('base_pickup_duration', 0);
					}

					if($elsettings->base_dropoff_special_routes=='price_time'){
						$session->set('dropoff_base_distance', $dropoff_base_distance);
						$session->set('dropoff_base_duration', $dropoff_base_duration);
						$debug_array['dropoff_base']['charge_string'] = $dropoff_base_price_calc;
					}
					elseif($elsettings->base_dropoff_special_routes=='time'){
						$session->set('dropoff_base_distance', 0);
						$session->set('dropoff_base_duration', $dropoff_base_duration);
					}
					else {
						$session->set('dropoff_base_distance', 0);
						$session->set('dropoff_base_duration', 0);
					}
				}
				else {
					$session->set('base_pickup_distance', $base_pickup_distance);
					$session->set('base_pickup_duration', $base_pickup_duration);
					$session->set('dropoff_base_distance', $dropoff_base_distance);
					$session->set('dropoff_base_duration', $dropoff_base_duration);

					$debug_array['base_pickup']['charge_string'] = $base_pickup_price_calc;
					$debug_array['dropoff_base']['charge_string'] = $dropoff_base_price_calc;
				}
			}

			if($booking_type=='shuttle')
			{
				$debug_array['initial_charge']['charge_per_unit'] = 0;

				if(!empty($cars))
				{
					foreach($cars as $key => $car)
					{
					    // first check today is a blocked date or not for this car
					    if(booking_helper::check_car_block_dates($car)===FALSE){
						unset($cars[$key]);
					    }
					    elseif(booking_helper::check_todays_availability($car)===FALSE) { // check todays opening/closing time and compare with current time
						unset($cars[$key]);
					    }
					    else {

						$debug_cars_array[$car->id] = array(
							'applied_tariff' => array('title'=>'Applied Tariff', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							    'pickup_dropoff' => array('title'=>'Pickup to Dropoff Charge', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							    'additional_car_charge' => array('title'=>'Additional Car Charge', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							    'hourly_charge' => array('title'=>'Hourly Charge', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							    'hourly_hire_fee' => array('title'=>'Hourly Hire Fee', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							    'duration_charge' => array('title'=>'Duration Charge', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							    'outbound_discount' => array('title'=>'Outbound Discount', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							    'outbound_price' => array('title'=>'Outbound Price', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							    'return_discount' => array('title'=>'Return Discount', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							    'return_price' => array('title'=>'Return Price', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
						);

						// round price based on configuration
						$car_price = 0;
						$query = 'SELECT SUM( `price_per_passenger` ) AS price_per_passenger'
							. ' FROM #__taxibooking_shuttle_route_stops'
							. ' WHERE `route_id` = '.(int)$shuttle_route_id
							. ' AND `ordering` > '
							. '            (SELECT `ordering` FROM `#__taxibooking_shuttle_route_stops`'
							. '            WHERE `poi_id` = '.(int)$shuttle_pickup_poi
							. '            AND `route_id` = '.(int)$shuttle_route_id.')'
							. ' AND `ordering` <= '
							. '            (SELECT `ordering` FROM `#__taxibooking_shuttle_route_stops`'
							. '            WHERE `poi_id` = '.(int)$shuttle_dropoff_poi
							. '            AND `route_id` = '.(int)$shuttle_route_id.')'
						;
						//echo str_replace('#__', 'nfgwj_', $query);
						$db->setQuery($query);
						$db->query();
						$price_per_passenger = $db->loadResult();

						$car_price = (float)$price_per_passenger * (int)$adultseats;

						$car_price = booking_helper::round_price($car_price, $elsettings);
						$car->car_price = $car_price;

						$debug_cars_array[$car->id]['pickup_dropoff']['charge_string'] = booking_helper::price_display($car_price,$elsettings);
					    }
					}
				}
			}
			else {
				// collect all available tariffs for pickup
				$tariffs = array();
				if($booking_type=='address'){
					$tariffs = booking_helper::getCurrentTariffs($order_date_time_str, $orderreturn_date_time_str);
				}

				if(!empty($cars))
				{
				    $debug_cars_array = array();
				    foreach($cars as $key => $car)
				    {
					// first check today is a blocked date or not for this car
					if(booking_helper::check_car_block_dates($car)===FALSE){
					    unset($cars[$key]);
					}
					elseif(booking_helper::check_todays_availability($car)===FALSE) { // check todays opening/closing time and compare with current time
					    unset($cars[$key]);
					}
					elseif(booking_helper::check_car_previous_bookings($car,$order_date_time_str,0,$duration_seconds)===FALSE) { // check this car previous booking journey
					    unset($cars[$key]);
					}
					elseif(booking_helper::check_car_shuttle_route($car, $time1, $elsettings)===FALSE) { // check if this car is assigned to any shuttle route between the booking time
					    unset($cars[$key]);
					}
					else {
						$car_price = 0;

						$debug_cars_array[$car->id] = array(
							'fixed_route_charge' => array('title'=>'Special Route Fixed Charge', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'applied_tariff' => array('title'=>'Applied Tariff', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'pickup_dropoff' => array('title'=>'Pickup to Dropoff calculation', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'additional_car_charge' => array('title'=>'Additional Car type Charge', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'hourly_charge' => array('title'=>'Hourly Charge', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'hourly_hire_fee' => array('title'=>'Hourly Hire Fee', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'duration_charge' => array('title'=>'Duration Charge', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'outbound_discount' => array('title'=>'Outbound Discount', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'outbound_price' => array('title'=>'Outbound Price', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'return_additional_car_charge' => array('title'=>'Additional Car type Charge on Return', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'return_discount' => array('title'=>'Return Discount', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
							'return_price' => array('title'=>'Return Total', 'charge_string'=>booking_helper::price_display(0,$elsettings)),
						);

						// every car has it's own price model, but that own price will not be applied for fixed route
						if($booking_type!='offers')
						{
							unset($debug_array['fixed_route_charge']);
							if($booking_type=='hourly')
							{
								$hourly_charge = $car->hourly_rate*($hourly_hr+($hourly_min/60));
								$car_price += $hourly_charge;
								$debug_cars_array[$car->id]['hourly_charge']['charge_string'] = ($hourly_hr+($hourly_min/60)).'hrs X '.booking_helper::price_display($car->hourly_rate,$elsettings);

								if((float)$car->hourly_hire_fee > 0){
								    $car_price += (float)$car->hourly_hire_fee;
								    $debug_cars_array[$car->id]['hourly_hire_fee']['charge_string'] = booking_helper::price_display($car->hourly_hire_fee,$elsettings);
								}
							}
							else {
								if($car->price_calculation_cumulative==1 || $elsettings->price_calculation_cumulative==1) // if car has cumulative price enabled
								{
									list($cum_car_price,$unit_price,$price_calculation_debug_str,$applied_tariff) = booking_helper::get_car_cumulative_price($car, $distance, $tariffs);
									$car_price += $cum_car_price;
									if($applied_tariff){
									    $debug_cars_array[$car->id]['applied_tariff']['charge_string'] = $applied_tariff->title.' - Initial Charge - '.booking_helper::price_display((float)$applied_tariff->initial_price,$elsettings);
									}
									$debug_cars_array[$car->id]['pickup_dropoff']['charge_string'] = $price_calculation_debug_str;
								}
								else {  // non-cumulative price calculation
									list($unit_price, $applied_tariff) = booking_helper::get_car_unit_price($car, $distance, $tariffs);
									$car_price += $distance * $unit_price;
									$charge_string = booking_helper::distance_display($distance,$elsettings).' X '.booking_helper::price_display($unit_price,$elsettings);
									if($applied_tariff){
									    $car_price += (float)$applied_tariff->initial_price;
									    $debug_cars_array[$car->id]['applied_tariff']['charge_string'] = $applied_tariff->title.' - Initial Charge - '.booking_helper::price_display((float)$applied_tariff->initial_price,$elsettings);
									    $charge_string .= ' + '.booking_helper::price_display((float)$applied_tariff->initial_price,$elsettings);
									}
									$debug_cars_array[$car->id]['pickup_dropoff']['charge_string'] = $charge_string.' = '.booking_helper::price_display($car_price,$elsettings);
								}

								// we have 2 conditions for min distance
								// first if minimum distance > 0, price will be min.price if journey distance is less than min distance
								// if Minimum distance 0 or empty, then Price will be Min price if calculated price is less than Min price
								if((float)$elsettings->minmil > 0){
								    if($distance < (float)$elsettings->minmil && $car_price < (float)$elsettings->minprice){
									    $car_price = (float)$elsettings->minprice;
								    }
								}
								else {
								    if ((float)$elsettings->minprice > 0 && $car_price < (float)$elsettings->minprice){
									    $car_price = (float)$elsettings->minprice;
								    }
								}
							}
						}

						$car_price += $elsettings->cost_per_call; // initial call charge

						// add car flat price
						if($booking_type!='hourly')
						{
							if($booking_type=='offers'){
								if($separate_car_price==0){
									$car->price = 0; // If separate car price = NO, addiotnal car charge/car price will not be added
									unset($debug_cars_array[$car->id]['fixed_route_charge']);
								}
								else {
									$debug_cars_array[$car->id]['fixed_route_charge']['charge_string'] = booking_helper::price_display($car->price,$elsettings);
									unset($debug_array['fixed_route_charge']);
								}
							}
							else {
								$debug_cars_array[$car->id]['additional_car_charge']['charge_string'] = booking_helper::price_display($car->price,$elsettings);
							}

							$car_price += $car->price;
						}

						// waypoint time charge
						if($elsettings->stops_charge_per_min!="")
						{
							$total_waypoint_duration = $session->get('total_waypoint_duration', 0);
							$car_price += $total_waypoint_duration* (float) $elsettings->stops_charge_per_min;
							$debug_array['stops_charge']['total_unit'] = $total_waypoint_duration.'mins';
							$debug_array['stops_charge']['charge_per_unit'] = $elsettings->stops_charge_per_min;
						}

						// add seats + poi additional charge
						$car_price += $price;

						// add extra price
						$car_price += $total_extra_price;

						$query = $db->getQuery(true);
						$query->select('*');
						$query->from('#__taxibooking_configs');
						$query->where('alias = '.$db->Quote('base-settings'));
						$db->setQuery((string)$query);
						$row = $db->loadAssoc();

                        $query = $db->getQuery(true);
						$query->select('*');
						$query->from('#__taxibooking_configs');
						$query->where('alias = '.$db->Quote('price-settings'));
						$db->setQuery((string)$query);
						$row2 = $db->loadAssoc();

                        $price_settings = unserialize($row2['text']);

						if($row){
							$zones = unserialize($row['text']);

							// if($distance1 > $zones['zonedist_4'] and $distance2 > $zones['zonedist_4']) {
							// 	$car_price += $zones['zoneprice_4'];
							// } elseif($distance1 > $zones['zonedist_3'] and $distance2 > $zones['zonedist_3']) {
							// 	$car_price += $zones['zoneprice_3'];
							// } elseif($distance1 > $zones['zonedist_2'] and $distance2 > $zones['zonedist_2']) {
							// 	$car_price += $zones['zoneprice_2'];
							// } elseif($distance1 > $zones['zonedist_1'] and $distance2 > $zones['zonedist_1']) {
							// 	$car_price += $zones['zoneprice_1'];
                            // } else {
                            //     // Zone 0
							// 	$car_price += $zones['zoneprice_0'];
                            //     if ($distance > $price_settings['zone_zero_max']) {
                            //         $car_price += $distance * $price_settings['zone_zero_price_mile'];
                            //     }
							// }
							if($distance1 > $zones['zonedist_4'] and $distance2 > $zones['zonedist_4']) {
								$car_price += $zones['zoneprice_4'];
								$this->logReturn('zoneprice_4', ['distance1' => $distance1, 'distance2' => $distance2, 'car price' => $car_price, 'zone extraprice' => $zones['zoneprice_4']]);
							} elseif($distance1 > $zones['zonedist_3'] and $distance2 > $zones['zonedist_3']) {
								$car_price += $zones['zoneprice_3'];
								$this->logReturn('zoneprice_3', ['distance1' => $distance1, 'distance2' => $distance2, 'car price' => $car_price, 'zone extraprice' => $zones['zoneprice_3']]);
							} elseif($distance1 > $zones['zonedist_2'] and $distance2 > $zones['zonedist_2']) {
								$car_price += $zones['zoneprice_2'];
								$this->logReturn('zoneprice_2', ['distance1' => $distance1, 'distance2' => $distance2, 'car price' => $car_price, 'zone extraprice' => $zones['zoneprice_2']]);
							} elseif($distance1 > $zones['zonedist_1'] and $distance2 > $zones['zonedist_1']) {
								$car_price += $zones['zoneprice_1'];
								$this->logReturn('zoneprice_1', ['distance1' => $distance1, 'distance2' => $distance2, 'car price' => $car_price, 'zone extraprice' => $zones['zoneprice_1']]);
							} elseif($distance1 > $zones['zonedist_0'] and $distance2 > $zones['zonedist_0']) {
								$car_price += $zones['zoneprice_0'];
								$this->logReturn('zoneprice_0', ['distance1' => $distance1, 'distance2' => $distance2, 'car price' => $car_price, 'zone extraprice' => $zones['zoneprice_0']]);
							}
							
							if(($distance1 > $zones['zonedist_0']) or ($distance2 > $zones['zonedist_0']))
							{
								if ($distance > $price_settings['zone_zero_max']) {
								   $car_price += $distance * $price_settings['zone_zero_price_mile'];
								   $this->logReturn('zone_zero_price_mile', ['distance1' => $distance1, 'distance2' => $distance2, 'car price' => $car_price, 'zone extraprice' => $zones['zone_zero_price_mile']]);
								}
							}

							if ($distance3 < $zones['zonedist_5'] or $distance4 < $zones['zonedist_5'])
							{
								$car_price += $zones['zoneprice_5'];
								$this->logReturn('zoneprice_5', ['distance1' => $distance1, 'distance2' => $distance2, 'car price' => $car_price, 'zone extraprice' => $zones['zoneprice_5']]);
							} elseif ($distance5 < $zones['zonedist_6'] or $distance6 < $zones['zonedist_6'])
							{
								$car_price += $zones['zoneprice_6'];
								$this->logReturn('zoneprice_6', ['distance1' => $distance1, 'distance2' => $distance2, 'car price' => $car_price, 'zone extraprice' => $zones['zoneprice_6']]);
							}
						}

						// add base price
						if($booking_type=='offers'){
							if($elsettings->base_pickup_special_routes=='price_time'){
								$car_price += $base_pickup_price;
							}
							if($elsettings->base_dropoff_special_routes=='price_time'){
								$car_price += $dropoff_base_price;
							}
						}
						else {
							$car_price += ($base_pickup_price+$dropoff_base_price);
						}

						// charge per min will be applied for Address booking only
						if($booking_type=='address'){
							list($duration_charge,$unit_charge) = booking_helper::calculate_charge_per_min($duration_seconds, $car, $elsettings, $applied_tariff);
							$car_price += $duration_charge;
							$debug_cars_array[$car->id]['duration_charge']['charge_string'] = ceil($duration_seconds/60).'mins X '.$unit_charge.' = '.booking_helper::price_display($duration_charge,$elsettings);
						}

						// calculate distance sectors discounts for Address booking only
						$distance_sector_outbound_discount = 0;
						$distance_sector_return_discount = 0;
						if($booking_type=='address'){
							list($distance_sector_outbound_discount,$distance_sector_return_discount) = booking_helper::get_distance_sector_discounts($car, $elsettings, $distance);
							if($distance_sector_outbound_discount!=0){
								$car_price -= (float)$distance_sector_outbound_discount;
							}
						}
						$debug_cars_array[$car->id]['outbound_discount']['charge_string'] = booking_helper::price_display($distance_sector_outbound_discount,$elsettings);

						$outbound_price = $car_price;
						$debug_cars_array[$car->id]['outbound_price']['charge_string'] = booking_helper::price_display($outbound_price,$elsettings);

						// return journey price
						$returnjurney = $session->get('returnjurney', 0);
						if ($returnjurney == 1)
						{
                             /** Return journey, waiting hours settings will apply.
                            * $driveTime = time to get to destination. we will substract this from the waiting hours
                            * $waitingHours = the amount of waiting hours that are free. everything over this will cost:
                            * $waitingPrice = this price per hour. these 2 settings come from the db.
                            * $timeToReturn = the time between the dropoff and pickup. we will substract from this the
                            * $waitingHours and $driveTime
                            * $pickUpStart | $pickUpBack | $dropOffStart
                            **/
                            $driveTime = $duration_seconds; // driving time in seconds
                            $waitingHours = $elsettings->wait_time_min * 3600; // waiting hours for free in seconds
                            $waitingTimeMax = $elsettings->wait_time_max * 3600; // no charge if waiting time is bigger than this.
                            $waitingHours -= $driveTime;

                            $pickUpStart = $session->get('pickupFromStart');
                            $pickUpBack = $session->get('pickupBackTime');

                            // echo date('Y-m-d H:i', $pickUpStart); // 15.04 18.00
                            // echo date('Y-m-d H:i', $pickUpBack); // 16.04. 18.00 // 24hrs diff
                            $dropOffStart = $pickUpStart + $driveTime; // 24 hrs + driving time, 1.43. 25.3hrs
                            $extraWaitingHours = $pickUpBack - $dropOffStart - $waitingHours; // should be: 25.3 - 3 - 1.5 = 21

                            $waitingPrice = $elsettings->return_time_price_hour;
                            $actualWaitingTime = $extraWaitingHours / 3600; // back to hours
                            $actualWaitingPrice = 0;

                            if ($extraWaitingHours < $waitingTimeMax) {
								$actualWaitingPrice = $waitingPrice * $actualWaitingTime;
								$this->logReturn('waitinghoursadded', [$actualWaitingTime]);
                            }

							// If add_price_return = NO, additional car type charge will not be applied for return journey
							if(($booking_type=='address') || ($booking_type=='offers' && $separate_car_price==0)) {
								if($car->add_price_return==0) {
									$outbound_price -= (float)$car->price;
								}
								else {
									$debug_cars_array[$car->id]['return_additional_car_charge']['charge_string'] = booking_helper::price_display((float)$car->price,$elsettings);
								}
							}

							// initial charge will be applied once per order
							$outbound_price -= (float)$elsettings->cost_per_call;

							$discounts = array('return_wait_discount' => $return_wait_discount,
									   'distance_sector_return_discount' => $distance_sector_return_discount
									   );
							list($return_price,$return_discounts,$return_discounts_calc) = booking_helper::calculate_return_price($outbound_price, $elsettings, $discounts);
							$car_price += (float)$return_price;
                            if ($actualWaitingPrice > 0) {
                                $car_price += $actualWaitingPrice;
                            }

							$debug_cars_array[$car->id]['return_discount']['charge_string'] = $return_discounts_calc;
							$debug_cars_array[$car->id]['return_price']['charge_string'] = $outbound_price.' - '.$return_discounts.' (discount) = '.booking_helper::price_display($return_price,$elsettings);
						}

						// round price based on configuration
						$car_price = booking_helper::round_price($car_price, $elsettings);
						$car->car_price = $car_price;
					}
				    }
				}

				// combine cars by type
				if($elsettings->combine_car_type==1)
				{
				    // first sort cars array by lowest id first
				    require_once (JPATH_COMPONENT.DS.'helpers'.DS.'sort_helper.php');
				    $cars = sort_stack($cars, 'itemid', 'ASC');

				    $temp = array();
				    $car_available_counter = array();
				    foreach($cars as $key => $car)
				    {
					if(isset($car_available_counter[$car->car_price] )){
					    $car_available_counter[$car->car_price]++;
					}
					else {
					    $car_available_counter[$car->car_price] = 1;
					}
				    }

				    for($i=0;$i<count($cars);$i++)
				    {
					$found = false;
					for($j=0;$j< count($temp);$j++)
					{
					    if( ($temp[$j]->alias==$cars[$i]->alias)
					       && ($temp[$j]->passenger_no==$cars[$i]->passenger_no)
					       && ($temp[$j]->suitcase_no==$cars[$i]->suitcase_no)
					       && ($temp[$j]->booster_seat_no==$cars[$i]->booster_seat_no)
					       && ($temp[$j]->infant_seat_no==$cars[$i]->infant_seat_no)
					       && ($temp[$j]->child_seat_no==$cars[$i]->child_seat_no)
					       && ($temp[$j]->car_price==$cars[$i]->car_price)
					    ){
						$found = true;
						break;
					    }
					}

					if(!$found){
					    $temp[] = $cars[$i];
					}
				    }

				    $cars = $temp;
				}
			}

			// sort car
			$sort_by = JRequest::getVar('sort_by', 'car_price');
			$sort_dir = JRequest::getVar('sort_dir', 'ASC');

			require_once (JPATH_COMPONENT.DS.'helpers'.DS.'sort_helper.php');
			$cars = sort_stack($cars, $sort_by, $sort_dir);

		    // now generate car list html
		    $html = '';
		    $car_prices = array();

		    if(!empty($cars))
		    {
			$counter = 0;
			foreach($cars as $car)
			{
				$image = ($car->image != "") ? '<img src="'.JURI::base().$car->image .'" alt="'.$car->title.'" title="'.$car->title.'" />' : "";
				if($car->text!="")
				{
				    $image .=   '<br/><a href="javascript:void();" class="car_desc" title="'.strip_tags($car->text).'">'.JText::_('VEHICLE_DESCRIPTION').'</a>';
				}

				$car_price = $car->car_price;
				$car_prices[$car->id] = $car_price;

				// display available car types
				$available_car_type = '';
				if($elsettings->display_car_types==1)
				{
				    if(!empty($car_available_counter) && isset($car_available_counter[$car->car_price]) && ($car_available_counter[$car->car_price]>0) )
				    {
					$available_car_type .= '<br>'.JText::sprintf('AVAILABLE_CAR_TYPES', $car_available_counter[$car->car_price]);
				    }
				}

				// show booked seats status for shuttle bookings
				$booked_seats_stats = '';
				if($booking_type=='shuttle')
				{
					$remaining_seats = $car->passenger_no - (int)$total_seats_booked;
					$booked_seats_stats = '<br>'.JText::sprintf('SHUTTLES_CAR_TABLE_BOOKED_REMAINING_SEATS', (int)$total_seats_booked, (int)$remaining_seats);
				}

				// now get the car row template - if template exitss
				/*$templateDir = JPATH_THEMES.DS.JFactory::getApplication()->getTemplate();
				if(file_exists($templateDir.DS .'html'.DS.'com_taxibooking'.DS.'cars'.DS.'default.php')) { // first search in template directory
				    ob_start();
				    include( $templateDir.DS .'html'.DS.'com_taxibooking'.DS.'cars'.DS.'default.php' );
				    $html .= ob_get_contents();
				    ob_end_clean();
				}
				elseif(file_exists(JPATH_COMPONENT.DS .'templates'.DS.'car_row.tpl.php')) {
				    ob_start();
				    include( JPATH_COMPONENT.DS .'templates'.DS.'car_row.tpl.php' );
				    $html .= ob_get_contents();
				    ob_end_clean();
				}
				else {*/
				    $html .= '
				    <table class="cars">
					<tbody>
					    <tr>
						<td class="car_wrap">
						    <center>'.$image.'</center>
						</td>
						<td class="vehicle_type">
						    <center><h5>'.JText::_('VEHICLE_TYPE').'</h5>
						    <p>'.$car->title.'<br>'.JText::sprintf('CAR_TABLE_PASSENGERS', $car->min_passenger_no, $car->passenger_no.$available_car_type).$booked_seats_stats.'</p></center>
						</td>';
				if(!in_array($booking_type, array('hourly'))){
				$html .=    '<td class="vehicle_time">
						    <center><h5>'.JText::_('EST_TIME').'</h5>
						    <p>'.$duration.'</p></center>
						</td>';
				}
				    if($elsettings->show_price==1){

				        if ($actualWaitingPrice > 0) {
                            $html .=    '<td class="vehicle_price">
        						    <center><h5>'.JText::_('PRICE').'</h5>
        						    <p>'.booking_helper::price_display($car_price,$elsettings). '<br>(' . round($actualWaitingTime, 1) . ' hrs waiting time included)</p></center>
        						</td>';
                        } else {
                            $html .=    '<td class="vehicle_price">
        						    <center><h5>'.JText::_('PRICE').'</h5>
        						    <p>'.booking_helper::price_display($car_price,$elsettings).'</p></center>
        						</td>';
                        }

				    }
				    $html .=    '<td class="vehicle_booking">
						    <center>
							<a class="car_booking" data-carid="'.$car->id.'" href="javascript:void(0);">'.JText::_('BOOK_NOW').'</a>
						    </center>
						</td>
					    </tr>';

					// only admins can see debug price calculation
					$groups = $user->get('groups');
					$gid = array_keys($groups);
					$admin_groups = array(7, 8);
					$temp = array_intersect( $admin_groups, $gid );
					if ( !empty( $temp) && $elsettings->debug_price_calculation==1)
					{
						$html .= '<tr class="debug_price"><td colspan="5">';
						foreach($debug_array as $debug_item)
						{
							if($debug_item['total_unit']=='none'){
								$html .= '>> '.$debug_item['title'].': '.booking_helper::price_display($debug_item['charge_per_unit'],$elsettings).'<br/>';
							}
							elseif($debug_item['total_unit']=='string'){
								$html .= '>> '.$debug_item['title'].': '.$debug_item['charge_string'].'<br/>';
							}
							else {
								$html .= '>> '.$debug_item['title'].': '.$debug_item['total_unit'].' X '.booking_helper::price_display($debug_item['charge_per_unit'],$elsettings).'<br/>';
							}
						}
						foreach($debug_cars_array[$car->id] as $debug_item)
						{
							$html .= '>> '.$debug_item['title'].': '.$debug_item['charge_string'].'<br/>';
						}

						if($elsettings->roundup_price=='nearest5'){
							$html .= '>> Total Price Round Up: Nearest 5 upwards';
						}
						elseif($elsettings->roundup_price=='whole') {
							$html .= '>> Total Price Round Up: Whole Number';
						}
						else {
							$html .= '>> Total Price Round Up: No';
						}
						$html .= '</td></tr>';
					}

					$html .= '</tbody></table>';
				//}
			}

			$result['msg'] = $html;
			$session->set('car_prices', $car_prices);
		    }
		    else {
			$result['error'] = 1;
			if($booking_type=='shuttle'){
				$result['msg'] = '<div class="cars">'.JText::_('COM_TAXIBOOKING_NO_SHUTTLE_FOUND').'</div>';
			}
			else {
				$result['msg'] = '<div class="cars">'.JText::_('COM_TAXIBOOKING_NO_VEHICLE_DATETIME').'</div>';
			}
		    }
		}

		// $result['msg'] = '';
		$result['cars'] = $cars;
		$result['tariffs'] = $tariffs;

		$this->logReturn('getVehicles', [$result['error'], $result['distances']]);
		echo json_encode($result);
		exit();
	}

	public function bookNow()
	{
		$result = array('error' => 0, 'msg' => '');
		$db = JFactory::getDBO();
		$elsettings =  booking_helper::config();
		$session =  JFactory::getSession();

		$siteOffset = booking_helper::set_tbtimezone();
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = strtotime($dtnow->format('Y-m-d H:i:s', true));

		$vehicle_id = JRequest::getInt('vehicle_id', 0);
		$car = booking_helper::get_car_details($vehicle_id);
		$car_prices = $session->get('car_prices', array());

		$booking_type = $session->get('booking_type', '');
		$returnjurney = $session->get('returnjurney', 0);
		$return_wait_hr = $session->get('return_wait_hr', -1);

		$order_date_time_str = $session->get('timestr1', '');
		$order_date_time = date("Y-m-d H:i:s", $order_date_time_str);

		$orderreturn_date_time = '';
		if($returnjurney==1 && $return_wait_hr==-1)
		{
		    $orderreturn_date_time_str = $session->get('timestr2', '');
		    $orderreturn_date_time = date("Y-m-d H:i:s", $orderreturn_date_time_str);
		}

		$error = 0;
		if(empty($car_prices)) {
		    $result['error'] = 1;
		    $result['msg'] = JText::_('SESSION_EXPIRED');
		}
		elseif ($session->get('date1', '') == '' || $session->get('time1', '') == '' ) {
		    $result['error'] = 1;
		    $result['msg'] = JText::_('ENTER_DEPARTING_DATE_WARN_MSG');
		}
		elseif($booking_type!="shuttle" && booking_helper::calculate_time_difference($dtnow, $order_date_time, 'hr') < $elsettings->restrict_time) {
		    $result['error'] = 1;
		    $result['msg'] = booking_helper::date_format($session->get('timestr1', '')).' ('.JText::sprintf('INSUFFICIENT_TIME', $elsettings->restrict_time).')';
		}
		elseif ($returnjurney==1 && $return_wait_hr==-1 && ( $session->get('date2', '') == '' || $session->get('time2', '') == '' ) ) {
			$result['error'] = 1;
			$result['msg'] = JText::_('ENTER_RETURN_DATE_WARN_MSG');
		}
		elseif(!booking_helper::check_car_block_dates($car)){
		    $result['error'] = 1;
		    $result['msg'] = JText::_('BOOKING_DATE_BLOCKED_WARN_MSG');
		}
		elseif(!booking_helper::check_todays_availability($car)) { // check todays opening/closing time and compare with current time
		    $result['error'] = 1;
		    $result['msg'] = JText::_('BOOKING_DATETIME_NOT_AVAIL_WARN_MSG');
		}
		elseif ($vehicle_id > 0 && isset($car_prices[$vehicle_id])) {  // vehicle validation
			$price = $car_prices[$vehicle_id];
			$session->set('vehicle_id', $vehicle_id);
			$session->set('price', $price);

			// payment methods list
			$payment_not_found_text='';
			$selectedPayment = $session->get('tb_paymentmethod_id', 0);

			$paymentplugins_payments = array();
			if(!class_exists('tbPaymentPlugin')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbpayment_plugin_helper.php');
			JPluginHelper::importPlugin('tbpayment');
			$dispatcher = JDispatcher::getInstance();
			$returnValues = $dispatcher->trigger('plgTbDisplayListFEPayment', array($selectedPayment, &$paymentplugins_payments));

			// if no payment defined
			$found_payment_method =count($paymentplugins_payments);
			$payment_html = '';
			if($found_payment_method>0)
			{
				foreach ($paymentplugins_payments as $paymentplugin_payments)
				{
				    if (is_array($paymentplugin_payments))
				    {
					foreach ($paymentplugin_payments as $paymentplugin_payment)
					{
					    $payment_html .= $paymentplugin_payment;
					}
				    }
				}
			}

			$waypoints = $session->get('waypoints', array());
			$show_stops = !empty($waypoints) ? 1 : 0;
			$stop_text = implode('<br/>', $waypoints);

			$booking_data = array('booking_type' => $session->get('booking_type'),
					      'returnjurney' => $session->get('returnjurney', 0),
					      'show_price' => (int)$elsettings->show_price,
					      'begin' => $session->get('begin', ''),
					      'show_stops' => $show_stops,
					      'stop_text' => $stop_text,
					      'end' => $session->get('end', ''),
					      'price' => booking_helper::price_display($session->get('price', 0),$elsettings),
					      'payment_html' => $payment_html,
					      'found_payment_method' => $found_payment_method
					      );

			$result['msg'] = $booking_data;
		}

		echo json_encode($result);
		exit();
	}

	/**
	* Get the personal details and proceed to preview order
	*/
	public function previewOrder()
	{
		$result = array('error' => 0, 'msg' => '');

		// Initialize variables
		$db =  JFactory::getDBO();
		$user =  JFactory::getUser();
		$session =  JFactory::getSession();

		$siteOffset = booking_helper::set_tbtimezone();
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = strtotime($dtnow->format('Y-m-d H:i:s', true));

		// Get the page/component configuration
		$elsettings =  booking_helper::config();

		//get data from request
		$post = JRequest::get('post');
		$tb_paymentmethod_id = JRequest::getInt('tb_paymentmethod_id', 0);
		$user_details_extras = JRequest::getVar('extras', array(), 'post', 'array');
		$receive_sms = JRequest::getInt('receive_sms', 0);
		$session->set('receive_sms', $receive_sms);

		if (isset($post['name']) && $post['name'] == "") {
		    $name_val = $post['name'];
		    $session->set('name_error', JText::_('NAME_ERROR'));
		    $session->set('name', '');
		} elseif (isset($post['name']) && $post['name'] != "") {
		    $name_val = $post['name'];
		    $session->set('name', $post['name']);
		    $session->set('name_error', '');
		}
		if (isset($post['email']) && $post['email'] == "") {
		    $email_val = $post['email'];
		    $session->set('email', $post['email']);
		    $session->set('email_error', JText::_('EMAIL_ERROR'));
		} elseif (isset($post['email']) && !booking_helper::is_valid_email($post['email'])) {
		    $email_val = $post['email'];
		    $session->set('email', $post['email']);
		    $session->set('email_error', JText::_('VALID_EMAIL_ERROR'));
		} elseif (isset($post['email']) && $post['email'] != "") {
		    $email_val = $post['email'];
		    $session->set('email', $post['email']);
		    $session->set('email_error', '');
		}
		if (isset($post['phone']) && $post['phone'] == "") {
		    $phone_val = $post['phone'];
		    $session->set('phone', $post['phone']);
		    $session->set('phone_error', JText::_('PHONE_ERROR'));
		} elseif (!booking_helper::is_valid_phone($post['phone'])) {
		    $phone_val = $post['phone'];
		    $session->set('phone', $post['phone']);
		    $session->set('phone_error', JText::_('VALID_PHONE_ERROR'));
		} elseif (isset($post['phone']) && $post['phone'] != "") {
		    $phone_val = $post['phone'];
		    $session->set('phone', $post['phone']);
		    $session->set('phone_error', '');
		}

		if ($tb_paymentmethod_id == 0) {
		    $session->set('payment_error', JText::_('PAYMENT_METHOD_ERROR'));
		} else {
		    $session->set('payment_error', '');
		}

		// process extras price
		list($selected_user_details_extras, $total_user_details_extra_price) = booking_helper::process_user_details_extras($user_details_extras);
		$selected_extras = array_merge($session->get('selected_extras', array()), $selected_user_details_extras);
		$session->set('selected_extras', $selected_extras);

		// process order copy users
		$order_copy = JRequest::getVar('order_copy', array(), 'post', 'array');
		$order_copy_html = '';
		$order_copy_users = array();
		if((int)$elsettings->send_order_copy==1)
		{
			for($i=0;$i<count($order_copy);$i++){
				if($order_copy[$i]['name']!="" && $order_copy[$i]['email']!="" && booking_helper::is_valid_email($order_copy[$i]['email']))
				{
					$order_copy_html .= $order_copy[$i]['name'].', '.$order_copy[$i]['email'].'</br>';
					$order_copy_users[] = array('name' => $order_copy[$i]['name'],
								  'email' => $order_copy[$i]['email']
								  );
				}
			}
		}
		$session->set('order_copy_users', $order_copy_users);

		$message = "";
		$session->set('message', $message);

		$title = '';
		$name = $this->check_input($post["name"]);
		$surname = '';
		$email = $this->check_input($post["email"]);
		$phone = $this->check_input($post["phone"]);
		//$tb_paymentmethod_id = $this->check_input($post["tb_paymentmethod_id"]);
		$PickupAddr1 = '';
		$PickupAddr4 = '';

		$begin = $session->get('begin', '');
		$end = $session->get('end', '');
		$from_dest = $session->get('from_dest', -1);
		$to_dest = $session->get('to_dest', -1);

		$session->set('temp1', $from_dest);
		$session->set('temp2', $to_dest);

		$session->set('gender', $title);
		$session->set('name', $name);
		$session->set('surname', $surname);
		$session->set('email', $email);
		$session->set('phone', $phone);
		$session->set('tb_paymentmethod_id', $tb_paymentmethod_id);
		$session->set('PickupAddr1', $PickupAddr1);
		$session->set('PickupAddr4', $PickupAddr4);

		$extras = $session->get('selected_extras', array());
		$pickup_extra_html = booking_helper::extra_html_preview($extras, 'pickup');
		$dropoff_extra_html = booking_helper::extra_html_preview($extras, 'dropoff');
		$hourly_extra_html = booking_helper::extra_html_preview($extras, 'hourly_hire');
		$return_extra_html = booking_helper::extra_html_preview($extras, 'return_pickup');
		$return_extra_html .= booking_helper::extra_html_preview($extras, 'return_dropoff');
		$user_details_extra_html = booking_helper::extra_html_preview($extras, 'user_details');

		$poi_additional_charges = $session->get('poi_additional_charges', array());

		$pickup_poi_additional_html = '';
		if(!empty($poi_additional_charges['pickup']))
		{
		$pickup_poi_additional_html .= '<div class="check_box_wrap clearfix">
		    <div class="check_name">'.$poi_additional_charges['pickup']['fld_label'].':</div>
		    <div class="check_desc">'.booking_helper::price_display($poi_additional_charges['pickup']['charge'],$elsettings).'</div>
		</div>';
		}

		$dropoff_poi_additional_html = '';
		if(!empty($poi_additional_charges['dropoff']))
		{
		$dropoff_poi_additional_html .= '<div class="check_box_wrap clearfix">
		    <div class="check_name">'.$poi_additional_charges['dropoff']['fld_label'].':</div>
		    <div class="check_desc">'.booking_helper::price_display($poi_additional_charges['dropoff']['charge'],$elsettings).'</div>
		</div>';
		}

		$hourly_hired_text = $session->get('hourly_hr', '').':'.$session->get('hourly_min', '').' hours';
		$pickup_date = booking_helper::date_format($session->get('timestr1', ''), 'Y-m-d H:i:s', $elsettings);
		$return_trip_text = ($session->get('returnjurney', 0)==1)? JText::_('JYES'):JText::_('JNO');
		$return_wait_hr = $session->get('return_wait_hr', -1);
		$return_wait_discount = $session->get('return_wait_discount', 0);
		$return_date = booking_helper::date_format($session->get('timestr2', ''), 'Y-m-d H:i:s', $elsettings);

		$additional_seats_html = '';
		$suitcases = $session->get('suitcases', 0);
		$infantseats = $session->get('infantseats', 0);
		$chseats = $session->get('chseats', 0);
		$boosterseats = $session->get('boosterseats', 0);

		if($suitcases > 0){
			$additional_seats_html .= '<div class="check_box_wrap clearfix">
			    <div class="check_name">'.JText::_('SUITCASE_NO').':</div>
			    <div class="check_desc">'.$suitcases.'</div>
			</div>';
		}
		if ($boosterseats > 0) {
			$price_to_added = (float)($boosterseats * $elsettings->booster_seat_price);
			$price_to_added = ($price_to_added>0) ? ' ('.booking_helper::price_display($price_to_added,$elsettings).')' : '';
			$additional_seats_html .= '<div class="check_box_wrap clearfix">
			    <div class="check_name">'.JText::_('BOOSTER_SEATS').':</div>
			    <div class="check_desc">'.$boosterseats.$price_to_added.'</div>
			</div>';
		}
		if ($infantseats > 0) {
			$price_to_added = (float)($infantseats * $elsettings->infant_seat_price);
			$price_to_added = ($price_to_added>0) ? ' ('.booking_helper::price_display($price_to_added,$elsettings).')' : '';
			$additional_seats_html .= '<div class="check_box_wrap clearfix">
			    <div class="check_name">'.JText::_('INFANT_SEATS').':</div>
			    <div class="check_desc">'.$infantseats.($price_to_added).'</div>
			</div>';
		}
		if ($chseats > 0) {
			$price_to_added = (float)($chseats * $elsettings->child_seat_price);
			$price_to_added = ($price_to_added>0) ? ' ('.booking_helper::price_display($price_to_added,$elsettings).')' : '';
			$additional_seats_html .= '<div class="check_box_wrap clearfix">
			    <div class="check_name">'.JText::_('CHILD_SEATS').':</div>
			    <div class="check_desc">'.$chseats.$price_to_added.'</div>
			</div>';
		}

		// collect selected payment method name
		$selectedPayment = $tb_paymentmethod_id;

		$price = $session->get('price', 0);
		$price += (float)$total_user_details_extra_price;
		$session->set("price", $price);

		// trigger calculating payment plugin fees
		$payment_name = '';
		if(!class_exists('tbPaymentPlugin')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbpayment_plugin_helper.php');
		JPluginHelper::importPlugin('tbpayment');
		$dispatcher = JDispatcher::getInstance();
		$returnValues = $dispatcher->trigger('plgTbonSelectedCalculatePricePayment', array(&$selectedPayment, $price, &$payment_name));

		$user_group_discount = 0;
		$returnValues = $dispatcher->trigger('plgTbonSelectedCalculateUserGroupDiscount', array(&$selectedPayment, $price, &$user_group_discount));

		// process user payment data like credit card data
		$payment_post_data = isset($post['payment_data']) ? $post['payment_data'] : array();
		$session->set("payment_post_data", $payment_post_data);

		$flat_cost = $session->get('flat_cost', 0);
		$percentage_cost = $session->get('percentage_cost', 0);
		$grand_total = $price+$flat_cost+$percentage_cost-$user_group_discount;

		$payment_labels = '';
		$returnValues = $dispatcher->trigger('plgTbonSelectedShowPriceLabel', array(&$selectedPayment, $price, &$payment_labels));

		$converted_currency_label = '';
		$returnValues = $dispatcher->trigger('plgTbonShowConvertedPriceLabel', array(&$selectedPayment, $grand_total, &$converted_currency_label));

		$code = booking_helper::generateCode(5);
		$session->set('security_code', $code);

		$waypoints = $session->get('waypoints', array());
		$show_stops = !empty($waypoints) ? 1 : 0;
		$stop_text = implode('<br/>', $waypoints);

		// if gratuities enabled
		$gratuity_html = '';
		if((int)$elsettings->enable_gratuity==1){

			$gratuity_html = '';
			require_once (JPATH_COMPONENT.DS.'helpers'.DS.'gratuity_helper.php');
			$gratuities_arr = gratuity_helper::get_all();

			for($i = 0; $i < count($gratuities_arr); $i++)
			{
				$gratuity_type = !empty($gratuities_arr[$i][1]) ? $gratuities_arr[$i][1] : 'flat';

				if($gratuities_arr[$i][0]!="" && $gratuities_arr[$i][0]!=0){
					if($gratuity_type=='percent'){
						$gratuity_html .= '<div class="gratuities_btn" data-amt="'.(float)$gratuities_arr[$i][0].'" data-amttype="percent">'.$gratuities_arr[$i][0].'%';
					}
					else {
						$gratuity_html .= '<div class="gratuities_btn" data-amt="'.(float)$gratuities_arr[$i][0].'" data-amttype="flat">'.booking_helper::price_display((float)$gratuities_arr[$i][0],$elsettings);
					}
					$gratuity_html .= '</div>';
				}
			}

			if((int)$elsettings->enable_gratuity_flat==1){
				$gratuity_html .= '<div class="gratuities_flat"><input type="text" name="flat_gratuity" id="flat_gratuity" value="" /><div class="explanation gratuity_lbl" title="'.JText::_('BOOKING_FORM_GRATUITY_FLAT_INPUT_EXPLAIN').'">'.JText::sprintf('BOOKING_FORM_GRATUITY_FLAT_INPUT_LABEL', $elsettings->currency_symbol).'</div></div>';
			}
		}

		$result['msg'] = array('booking_type' => $session->get('booking_type'),
				       'gender' => $title,
					'name' => $name,
					'surname' => $surname,
					'email' => $email,
					'phone' => $phone,
					'order_copy_html' => $order_copy_html,
					'tb_paymentmethod_id' => $tb_paymentmethod_id,
					'PickupAddr1' => $PickupAddr1,
					'PickupAddr4'=> $PickupAddr4,
					'customer_note' => $session->get('message', ''),
					'vehicle_type'=> booking_helper::get_car_field($session->get('vehicle_id', '')),
					'begin'=> $begin,
					'show_stops' => $show_stops,
					'stop_text' => $stop_text,
					'end'=> $end,
					'pickup_poi_additional_html' => $pickup_poi_additional_html,
					'dropoff_poi_additional_html' => $dropoff_poi_additional_html,
					'pickup_extra_html'=> $pickup_extra_html,
					'dropoff_extra_html'=> $dropoff_extra_html,
					'hourly_extra_html'=> $hourly_extra_html,
					'return_extra_html'=> $return_extra_html,
					'hourly_hired_text' => $hourly_hired_text,
					'user_details_extra_html' => $user_details_extra_html,
					'return_trip' => $session->get('returnjurney', 0),
					'return_trip_text' => $return_trip_text,
					'return_wait_hr' => $return_wait_hr,
					'return_wait_discount' => ($return_wait_discount>0) ? $return_wait_discount.'%' : 0,
					'pickup_date' => $pickup_date,
					'return_date' => $return_date,
					'show_price' => (int)$elsettings->show_price,
					'enable_captcha' => (int)$elsettings->enable_captcha,
					'captcha_code' => $code,
					'additional_seats_html' => $additional_seats_html,
					'captcha_image' => '<img src="'.JURI::base().'components/com_taxibooking/helpers/captchaSecurityImages.php?code='.$code.'&width=100&height=40&characters=5" alt="'.$code.'" title="Security Code" />',
					'sub_total' => booking_helper::price_display($price,$elsettings),
					'show_flat_cost' => ($flat_cost>0) ? 1 : 0,
					'flat_cost' => ($flat_cost>0) ? booking_helper::price_display($flat_cost,$elsettings) : 0,
					'show_percentage_cost' => ($percentage_cost>0) ? 1 : 0,
					'percentage_cost' => ($percentage_cost>0) ? booking_helper::price_display($percentage_cost,$elsettings) : 0,
					'grand_total' => booking_helper::price_display($grand_total,$elsettings).$converted_currency_label,
					'payment_method_name' => $payment_name,
					'payment_labels' => $payment_labels,
					'payment_labels' => $payment_labels,
					'show_user_group_discount' => ($user_group_discount>0) ? 1 : 0,
					'user_group_discount' => ($user_group_discount>0) ? booking_helper::price_display('-'.$user_group_discount,$elsettings) : 0,
					'enable_gratuity' => (int)$elsettings->enable_gratuity,
					'gratuity_html' => $gratuity_html
				);

		echo json_encode($result);
		exit();
	}

	/**
	* Check all the input values
	*/
	public function check_input($data) {
		$data = trim($data);
		$data = stripslashes($data);
		$data = htmlspecialchars($data, ENT_QUOTES);
		//no	$data = htmlentities($data);
		return $data;
	}

	public function checkCaptcha()
	{
		$json_result = array('error' => 0, 'msg' => '');

		// Initialize variables
		$db =  JFactory::getDBO();
		$user =  JFactory::getUser();
		$session =  JFactory::getSession();

		// Get the page/component configuration
		$elsettings =  booking_helper::config();

		//get data from request
		$security_code = $session->get('security_code', '');
		$post_security_code = JRequest::getVar('security_code', '');

		if ($elsettings->enable_captcha==1)
		{
			if($post_security_code=='' || $security_code==''){
				$json_result['error'] = 1;
				$json_result['msg'] = JText::_('ENTER_SECURITY_CODE');
			}
			elseif ($security_code != $post_security_code){
				$json_result['error'] = 1;
				$json_result['msg'] = JText::_('INVALID_SECURITY_CODE');
			}
			else {
				$json_result['error'] = 0;
			}
		}

		echo json_encode($json_result);
		exit();
	}

	/**
	* Submit the order info into database
	*
	* @access	public
	* @since	1.0
	*/
	public function submitOrder()
	{
		// Check for request forgeries
		// JRequest::checkToken() or jexit('Invalid Token');

		$json_result = array('error' => 0, 'msg' => '', 'redirect_url' => '');

		$app = JFactory::getApplication();
		// Initialize variables
		$db =  JFactory::getDBO();
		$user =  JFactory::getUser();
		$session =  JFactory::getSession();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();

		// Get the page/component configuration
		$elsettings = booking_helper::config();

		$siteOffset = booking_helper::set_tbtimezone();
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->toSql(true);

		//get data from request
		$post = JRequest::get('post');
		$security_code = $session->get('security_code', '');

		$booking_type = $session->get('booking_type');
		$returnjurney = $session->get('returnjurney', 0);
		$return_wait_hr = $session->get('return_wait_hr', -1);
		$return_wait_discount = $session->get('return_wait_discount', 0);
		$tb_paymentmethod_id = $session->get("tb_paymentmethod_id", 0);

		$order_date_time_str = $session->get('timestr1', '');
		$order_date_time = date("Y-m-d H:i:s", $order_date_time_str);
		$orderreturn_date_time = '';
		if($returnjurney==1 && $return_wait_hr==-1)
		{
		    $orderreturn_date_time_str = $session->get('timestr2', '');
		    $orderreturn_date_time = date("Y-m-d H:i:s", $orderreturn_date_time_str);
		}

		if($booking_type!="shuttle" && booking_helper::calculate_time_difference($dtnow, $order_date_time, 'hr') < $elsettings->restrict_time)
		{
			$err_msg = booking_helper::date_format($session->get('timestr1', '')).' ('.JText::sprintf('INSUFFICIENT_TIME', $elsettings->restrict_time).')';
			$json_result['msg'] = $err_msg;
			$json_result['error'] = 1;
		}
		elseif ($tb_paymentmethod_id==0)
		{
			$err_msg = 'No payment method is set!';
			$json_result['msg'] = $err_msg;
			$json_result['error'] = 1;
		}
		else
		{
			$session->clear('security_code_error');
			$title = $session->get("gender", "");
			$name = $session->get("name", "");
			$surname = $session->get("surname", "");
			$email = $session->get("email", "");
			$phone = $session->get("phone", "");
			$returntrip = $session->get("returnjurney", "");
			$cprice = $session->get("price", "");
			$prepay = $session->get("prepay", "");
			$flat_cost = $session->get('flat_cost', 0);
			$percentage_cost = $session->get('percentage_cost', 0);
			$selpassengers = $session->get('passengers', 0);
			$selsuitcases = $session->get('suitcases', 0);
			$selinfantseats = $session->get('infantseats', 0);
			$selchildseats = $session->get('chseats', 0);
			$selboosterseats = $session->get('boosterseats', 0);
			$selcarry = $session->get("selcarry", "");
			$vehicletype = $session->get("vehicle_id", "");
			$tb_paymentmethod_id = $session->get("tb_paymentmethod_id", 0);

			$hourly_hr = $session->get('hourly_hr', '');
			$hourly_min = $session->get('hourly_min', '');
			$PickupAddr1 = $session->get("PickupAddr1", "");
			$PickupAddr4 = $session->get("PickupAddr4", "");

			$order_date_time_str = $session->get('timestr1', '');
			$orderreturn_date_time_str = '';
			if($returntrip==1)
			{
			    $orderreturn_date_time_str = $session->get('timestr2', '');
			}

			$distance = $session->get('distance', 0);  // distance in KM or Mile
			$duration_seconds = $session->get('duration_seconds', 0);
			$duration_text = $session->get('duration', '');
			$message = $session->get("message", "");
			$begin = $session->get("begin", "");
			$end = $session->get("end", "");
			$from_dest = $session->get("temp1", "");
			$to_dest = $session->get("temp2", "");

			if($booking_type=='hourly'){
			    $begin = $end = '';
			}

			$pickup_lat = $pickup_lng = $dropoff_lat = $dropoff_lng = '';
			$lat_long_from = $session->get('lat_long_from', array());
			$lat_long_to = $session->get('lat_long_to', array());
			if(!empty($lat_long_from)){
				$pickup_lat = $lat_long_from[0];
				$pickup_lng = $lat_long_from[1];
			}
			if(!empty($lat_long_to)){
				$dropoff_lat = $lat_long_to[0];
				$dropoff_lng = $lat_long_to[1];
			}

			$selected_extras = $session->get('selected_extras', array());
			$poi_additional_charges = $session->get('poi_additional_charges', array());

			$stops = array();
			$waypoints = $session->get('waypoints', array());
			$waypoints_lat = $session->get('waypoints_lat', array());
			$waypoints_lng = $session->get('waypoints_lng', array());
			$waypoints_stop_duration = $session->get('waypoints_stop_duration', array());
			for($i = 0; $i < count($waypoints); $i++){
				$stops[$i] = array('stop' => $waypoints[$i],
						   'stop_lat' => $waypoints_lat[$i],
						   'stop_lng' => $waypoints_lng[$i],
						   'stop_interval' => $waypoints_stop_duration[$i]
						   );
			}

			$user_group_discount = 0;
			if(!class_exists('tbPaymentPlugin')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbpayment_plugin_helper.php');
			JPluginHelper::importPlugin('tbpayment');
			$dispatcher = JDispatcher::getInstance();
			$returnValues = $dispatcher->trigger('plgTbonSelectedCalculateUserGroupDiscount', array($tb_paymentmethod_id, $cprice, &$user_group_discount));

			// total cost
			$grand_total = $cprice+$flat_cost+$percentage_cost-$user_group_discount;

			// apply coupon code discount if any
			$coupon_used = 0;
			$coupon_code = JRequest::getVar('coupon_code', '');
			if($coupon_code != "")
			{
				$booking_data = array('booking_type' => $booking_type,
							'email' => $email,
							'route_from' => $session->get('route_from', 0),
							'route_to' => $session->get('route_to', 0),
							'grand_total' => $grand_total,
							'selected_payment' => $tb_paymentmethod_id,
							'lang_tag' => $lang_tag,
							'pickup_date' => date("Y-m-d", $session->get('timestr1', ''))
						      );
				require_once (JPATH_COMPONENT.DS.'classes'.DS.'coupon_code.php');
				$cc = new CouponCode($coupon_code,0);
				list($is_valid, $msg) = $cc->validate($booking_data);

				if($is_valid)
				{
					$grand_total = $cc->apply($booking_data);
					$coupon_used = $cc->_coupon->id;
				}
			}

			// add gratuity/tips
			$gratuity_amt = $session->get('gratuity_amt', 0);
			$grand_total += $gratuity_amt;

			// auto approve free orders if backend setting is set to YES
			if(((int)$elsettings->show_price==0) || ($grand_total<=0 && (int)$elsettings->auto_approve_free_order==1) ){
				$new_order_status = 1;
			}
			else {
				$new_order_status = -2; // WAITING
			}

			if($booking_type=='address'){
				$pickup_poi = $session->get('pickup_poi', 0);
				$dropoff_poi = $session->get('dropoff_poi', 0);
			}
			elseif($booking_type=='offers'){
				$pickup_poi = $session->get('route_from', 0);
				$dropoff_poi = $session->get('route_to', 0);
			}
			elseif($booking_type=="shuttle"){
				$pickup_poi = $session->get('shuttle_pickup_poi', 0);
				$dropoff_poi = $session->get('shuttle_dropoff_poi', 0);
			}
			else {
				$pickup_poi = $dropoff_poi = 0;
			}

			// if payment method is AU Points
			// order status will be Default order status set from plugin params
			$paymentObj = booking_helper::get_payment_details($tb_paymentmethod_id);

			if(isset($paymentObj->default_status))
			{
				// AUP payment
				$api_AUP = JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php';
				if ( file_exists($api_AUP) && isset($paymentObj->aup_per_currency) && $user->get('id') > 0)
				{
					$lang->load('plg_tbpayment_alphauserpoints',JPATH_ADMINISTRATOR);

					require_once ($api_AUP);
					$current_total_points = AlphaUserPointsHelper::getCurrentTotalPoints( 0, $user->get('id') );

					// check if final total can be paid with current total points
					$aup_per_currency = (float)$paymentObj->aup_per_currency;
					$aup_total = $grand_total * $aup_per_currency;
					//print $grand_total.'--'.$aup_total.'--'.$current_total_points;
					if($aup_total > $current_total_points){
						$json_result['msg'] = JText::_('TBPAYMENT_AUP_NOT_ENOUGH_POINTS_TO_PAY');
						$json_result['error'] = 1;
						echo json_encode($json_result);
						exit();
					}
					else {
						$new_order_status = $paymentObj->default_status;
					}
				}
			}

			// now prepare order data
			$order = new stdClass();
			$order->order_number = uniqid();
			$order->names = $name;
			$order->gender = $title;
			$order->email = $email;
			$order->phone = $phone;
			$order->booking_type = $booking_type;
			$order->returntrip = $returntrip;
			$order->return_wait_hr = $return_wait_hr;
			$order->return_wait_discount = $return_wait_discount;
			$order->sub_total = $cprice;
			$order->flat_cost = $flat_cost;
			$order->percentage_cost = $percentage_cost;
			$order->poi_additional_charges = serialize($poi_additional_charges);
			$order->cprice = $grand_total;
			$order->prepay = $prepay;
			$order->extras = serialize($selected_extras);
			$order->selpassengers = $selpassengers;
			$order->selinfantseats = $selinfantseats;
			$order->selchildseats = $selchildseats;
			$order->selboosterseats = $selboosterseats;
			$order->selluggage = $selsuitcases;
			$order->selcarry = $selcarry;
			$order->hourly_hr = $hourly_hr;
			$order->hourly_min = $hourly_min;
			$order->PickupAddr1 = $PickupAddr1;
			$order->PickupAddr4 = $PickupAddr4;
			$order->datetime1 = $order_date_time_str;
			$order->datetime2 = $orderreturn_date_time_str;
			$order->distance = $distance;
			$order->duration = $duration_seconds;
			$order->duration_text = $duration_text;
			$order->message = $message;
			$order->begin = $begin;
			$order->stops = serialize($stops);
			$order->end = $end;
			$order->from_dest = $from_dest;
			$order->to_dest = $to_dest;
			$order->state = $new_order_status;
			$order->driver_id = 0;
			$order->payment = $tb_paymentmethod_id;
			$order->vehicletype = $vehicletype;
			$order->created = $now;
			$order->coupon_used = $coupon_used;
			$order->shuttle_route_id = $session->get('shuttle_route_id', 0);
			$order->source = 'frontend';
			$order->pickup_poi = $pickup_poi;
			$order->pickup_lat = $pickup_lat;
			$order->pickup_lng = $pickup_lng;
			$order->dropoff_poi = $dropoff_poi;
			$order->dropoff_lat = $dropoff_lat;
			$order->dropoff_lng = $dropoff_lng;
			$order->ip_address = $_SERVER['REMOTE_ADDR'];
			$order->gratuity_amt = $gratuity_amt;
			$order->gratuity_amttype = $session->get('gratuity_amttype', '');
			$order->gratuity_percent_value = $session->get('gratuity_percent_value', 0);
			$order->language = $lang_tag;

			if (!$db->insertObject('#__taxibooking_orders', $order)) {
				echo json_encode(array('error' => 1, 'msg' => $db->stderr()));
				exit();
			}
			$order_id = $db->insertid();
			$order = booking_helper::get_order_by_id($order_id);

			// store order vehicle booking time data if track_availability is set YES for the booked car
			$car = booking_helper::get_car_details($order->vehicletype);
			$track_availability = $car->track_availability;

			if((int)$track_availability==1)
			{
				$booking_time_start = $order_date_time_str;
				$booking_time_end = $order_date_time_str+$duration_seconds;

				$booking_time_end += (int) $elsettings->time_after_each_booking;

				if($elsettings->calculate_base_pickup==1)
				{
					$base_pickup_distance = $session->get('base_pickup_distance', 0);
					$base_pickup_duration_seconds = $session->get('base_pickup_duration', 0);

					if($booking_type=='offers'){
						if($elsettings->base_pickup_special_routes=='price_time' || $elsettings->base_pickup_special_routes=='time'){
							$booking_time_start -= $base_pickup_duration_seconds;
						}
					}
					else {
						$booking_time_start -= $base_pickup_duration_seconds;
					}
				}
				if($elsettings->calculate_dropoff_base==1)
				{
					$dropoff_base_distance = $session->get('dropoff_base_distance', 0);
					$dropoff_base_duration_seconds = $session->get('dropoff_base_duration', 0);

					if($booking_type=='offers'){
						if($elsettings->base_dropoff_special_routes=='price_time' || $elsettings->base_dropoff_special_routes=='time'){
							$booking_time_end += $dropoff_base_duration_seconds;
						}
					}
					else {
						$booking_time_end += $dropoff_base_duration_seconds;
					}
				}

				$order_car = new stdClass();
				$order_car->order_id = $order_id;
				$order_car->vehicle_id = $vehicletype;
				$order_car->journey_type = 'outbound';
				$order_car->booking_time_start = $booking_time_start;
				$order_car->booking_time_end = $booking_time_end;
				$order_car->created_date = $now;

				if (!$db->insertObject('#__taxibooking_order_car_rel', $order_car)) {
				    echo json_encode(array('error' => 1, 'msg' => $db->stderr()));
				    exit();
				}
				$order_car_rel_id = $db->insertid();

				if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
				{
					$event_id = booking_helper::createCalendarEvent($order,$car,$order_car_rel_id,$booking_time_start,$booking_time_end);
				}

				// enter another entry for return journey
				if($returntrip==1 && $orderreturn_date_time_str!="")
				{
					$booking_time_start = $orderreturn_date_time_str;
					$booking_time_end = $orderreturn_date_time_str+$duration_seconds;

					$order_car = new stdClass();
					$order_car->order_id = $order_id;
					$order_car->vehicle_id = $vehicletype;
					$order_car->journey_type = 'return';
					$order_car->booking_time_start = $booking_time_start;
					$order_car->booking_time_end = $booking_time_end;
					$order_car->created_date = $now;

					if (!$db->insertObject('#__taxibooking_order_car_rel', $order_car)) {
						echo json_encode(array('error' => 1, 'msg' => $db->stderr()));
						exit();
					}
					$order_car_rel_id = $db->insertid();

					if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
					{
						$event_id = booking_helper::createCalendarEvent($order,$car,$order_car_rel_id,$booking_time_start,$booking_time_end);
					}
				}
			}

			// trigger order submit action for payment gateways
			JPluginHelper::importPlugin('tbpayment');
			$dispatcher = JDispatcher::getInstance();
			$returnValues = $dispatcher->trigger('plgTbOrderSubmit', array($order));

			// if this is user is not registered yet, create an account silently
			$juserObj = $this->_createUserAccount($order);
			$this->_createUserProfile($order, $juserObj);

			// register order copy users silently
			$send_copy_order_email = false;
			$order_copy_users = $session->get('order_copy_users', array());
			if(!empty($order_copy_users))
			{
				$copyUserIds = booking_helper::createOrderCopyUser($order_copy_users, $elsettings);

				// insert into order copy user relation table
				if(!empty($copyUserIds)){
					$send_copy_order_email = true;
					$copyUserIds = array_unique($copyUserIds, SORT_NUMERIC);
					$query = 'INSERT INTO #__taxibooking_order_copyusers (`order_id` ,`user_id` ,`created`)
						VALUES ';

					foreach($copyUserIds as $copyUserId){
						$query .= '('.(int)$order->id.','.(int)$copyUserId.','.$db->Quote(JFactory::getDate()->toSQL()).' ),';
					}
					// Remove last commaa
					$query = substr( $query, 0, -1 );
					$db->setQuery($query);
					$db->execute();
				}
			}

			// assign AUP to order user if user is logged in
			if($user->get('id') > 0)
			{
				$api_AUP = JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php';
				if ( file_exists($api_AUP))
				{
					require_once ($api_AUP);
					AlphaUserPointsHelper::newpoints( 'plgaup_taxibooking_new_order' );
				}
			}

			// if selected payment method has send email for Pending status to YES,
			// then send email for new orders
			$paymentObj = booking_helper::get_payment_details($order->payment);

			// For Offline payments, user is not leaving TB website
			// so, order status will be updated instantly right after payment captured silently
			// and for this, system will collect order details again with updated order status
			if($paymentObj->payment_element=='stripe'){
				$order = booking_helper::get_order_by_id($order_id);
			}

			if(isset($paymentObj->send_email_pending_status) && isset($paymentObj->send_email_approved_status)){
				if( ($new_order_status == -2 && $paymentObj->send_email_pending_status==1)
				   || ($new_order_status == 1 && $paymentObj->send_email_approved_status==1)
				){
					$this->sendMailDetailsToOwner($order,$send_copy_order_email);
				}
			}
			else {
				$this->sendMailDetailsToOwner($order,$send_copy_order_email);
			}

			// send sms
			$receive_sms = $session->get('receive_sms', 0);
			if((int)$elsettings->send_user_sms==1 && $receive_sms==1 && $order->phone!="")
			{
				$response = booking_helper::send_order_sms($order, $elsettings);
				$app->enqueueMessage($response, 'notice');
			}

			// confirm booked seats if this is shuttle booking
			if($order->booking_type=='shuttle'){
			    booking_helper::confirm_shuttle_booking($order);
			}

			// track user coupon record
			if($coupon_used > 0 ){
				booking_helper::track_user_coupon($order, $elsettings);
			}

			// unset all the values
			$this->clear_session();

			// set last order Id to show in thanks page
			$session->set('tb_last_order_id', $order_id);

			$booking_form_itemid = JRequest::getInt('booking_form_itemid', 0);
			$redirect_url = 'index.php?option=com_taxibooking&view=thanks&Itemid='.$booking_form_itemid;
			//$redirect_url = TaxibookingHelperRoute::getBookingThanksRoute($lang_tag);

			if($session->get('tmpl','')=='component'){
				$redirect_url .= '&tmpl=component';
			}
			$json_result['redirect_url'] = JRoute::_($redirect_url, false);
		}

		echo json_encode($json_result);
		exit();
       }

	public function clear_session()
	{
	    $session = JFactory::getSession();
	    $session->clear('from_dest');
	    $session->clear('to_dest');
	    $session->clear('booking_type');

	    $session->clear('address_from');
	    $session->clear('address_from_lat');
	    $session->clear('address_from_lng');
	    $session->clear('address_to');
	    $session->clear('address_to_lat');
	    $session->clear('address_to_lng');
	    $session->clear('pickup_poi');
	    $session->clear('dropoff_poi');

	    $session->clear('route_category_fld');
	    $session->clear('route_category');
	    $session->clear('route_category_dropoff_fld');
	    $session->clear('route_category_dropoff');
	    $session->clear('route_from');
	    $session->clear('route_to');
	    $session->clear('route_from_fld');
	    $session->clear('route_to_fld');
	    $session->clear('route_swapped');

	    $session->clear('hourly_hr');
	    $session->clear('hourly_min');

	    $session->clear('shuttle_pickup');
		$session->clear('shuttle_pickup_poi');
		$session->clear('shuttle_dropoff');
		$session->clear('shuttle_dropoff_poi');
		$session->clear('shuttletime');
		$session->clear('shuttle_route_id');
		$session->clear('shuttle_passengers');

	    $session->clear('date1');
	    $session->clear('time1');
	    $session->clear('date2');
	    $session->clear('time2');
	    $session->clear('timestr1');
	    $session->clear('timestr2');
	    $session->clear('distance');
	    $session->clear('duration');
	    $session->clear('duration_seconds');
	    $session->clear('message');

	    $session->clear('begin');
	    $session->clear('end');
	    $session->clear('temp1');
	    $session->clear('temp2');
	    $session->clear('lat_long_from');
	    $session->clear('lat_long_to');

	    $session->clear('waypoints');
	    $session->clear('waypoints_lat');
	    $session->clear('waypoints_lng');
	    $session->clear('waypoints_stop_duration');

	    $session->clear('title');
	    $session->clear('name');
	    $session->clear('surname');
	    $session->clear('email');
	    $session->clear('phone');
	    $session->clear('receive_sms');
	    $session->clear('returnjurney');
	    $session->clear('return_wait_hr');
		$session->clear('return_wait_discount');
	    $session->clear('price');
	    $session->clear('prepay');
	    $session->clear('flat_cost');
	    $session->clear('percentage_cost');
	    $session->clear('selected_extras');
	    $session->clear('total_extra_price');
	    $session->clear('poi_additional_charges');

	    $session->clear('passengers');
	    $session->clear('infantseats');
	    $session->clear('chseats');
	    $session->clear('chseats2');
	    $session->clear('chseats3');
	    $session->clear('boosterseats');
	    $session->clear('boosterseats2');
	    $session->clear('suitcases');
	    $session->clear('selpassengers');
	    $session->clear('selsuitcases');
	    $session->clear('selinfantseats');
	    $session->clear('selchildseats');
	    $session->clear('selboosterseats');
	    $session->clear('selluggage');
	    $session->clear('selcarry');
	    $session->clear('vehicle_id');
	    $session->clear('vehicletype');
	    $session->clear('tb_paymentmethod_id');
	    $session->clear('payment_post_data');

	    $session->clear('PickupAddr1');
	    $session->clear('PickupAddr4');
	    $session->clear('order_copy_users');
	    $session->clear('gratuity_amt');
	    $session->clear('gratuity_amttype');
	    $session->clear('gratuity_percent_value');
	    $session->clear('data_source');
	}

       /**
	* Create user account silently
	*
	* @access	public
	* @since	1.0
	*/
	private function _createUserAccount($order)
	{
		//initialise variables
		$app = JFactory::getApplication();
		$db =  JFactory::getDBO();
		$elsettings =  booking_helper::config();
		$config = JFactory::getConfig();
		$user_params	= JComponentHelper::getParams('com_users');

		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__users');
		$query->where('email = '.$db->Quote($order->email));
		$db->setQuery((string)$query);
		$row = $db->loadObject();

		if($row){
			return $row;
		}
		else {
			// Initialise the table with JUser.
			$user = new JUser;

			// Prepare the data for the user object.
			$data = array();
			$data['name']	        = $order->names;
			$data['username']	= $order->email;
			$data['email']		= $order->email;
			$data['password']	= JUserHelper::genRandomPassword();
			$data['activation'] = '';
			$data['block'] = 0;

			// Get the groups the user should be added to after registration.
			$data['groups'] = array();

			// Get the default new user group, Registered if not specified.
			$data['groups'][] = $user_params->get('new_usertype', 2);

			// Bind the data.
			if (!$user->bind($data)) {
			    return false;
			}

			// Store the data.
			if (!$user->save()) {
			    return false;
			}

			// Compile the notification mail values.
			$data['fromname']	= $config->get('fromname');
			$data['mailfrom']	= $config->get('mailfrom');
			$data['sitename']	= $config->get('sitename');
			$data['siteurl']	= JUri::root();
			$data['password_clear']	= $user->password_clear;

			$emailSubject	= JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_ACCOUNT_DETAILS',
				$data['name'],
				$data['sitename']
			);

			$emailBody = JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_REGISTERED_BODY',
				$data['name'],
				$data['sitename'],
				$data['siteurl'],
				$data['username'],
				$data['password_clear']
			);

			// Send the registration email.
			$return = JFactory::getMailer()->sendMail($data['mailfrom'], $data['fromname'], $data['email'], $emailSubject, $emailBody);

			//Send Notification mail to administrators
			$emailSubject = JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_ACCOUNT_DETAILS',
				$data['name'],
				$data['sitename']
			);

			$emailBodyAdmin = JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY',
				$data['name'],
				$data['username'],
				$data['siteurl']
			);

			// get all admin users
			$query = 'SELECT name, email, sendEmail' .
				' FROM #__users' .
				' WHERE sendEmail=1';
			$db->setQuery( $query );
			$rows = $db->loadObjectList();

			// Send mail to all superadministrators id
			foreach( $rows as $row )
			{
			    $return = JFactory::getMailer()->sendMail($data['mailfrom'], $data['fromname'], $row->email, $emailSubject, $emailBodyAdmin);
			}
			return $user;
		}
	}

	/**
	* Create user entry in Appregulator database
	*
	* @access	public
	*/
	private function _createUserProfile($order, $jUserObj = false)
	{
		//initialise variables
		$app = JFactory::getApplication();
		$db =  JFactory::getDBO();
		$date = JFactory::getDate();

		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_users');
		$query->where('email = '.$db->Quote($order->email));
		$db->setQuery((string)$query);
		$tbUser = $db->loadObject();

		if($tbUser){
			$tbUserId = $tbUser->id;
		}
		else {
			if($jUserObj){
				$temp = new stdClass();
				$temp->user_id = $jUserObj->id;
				$temp->name = $order->names;
				$temp->email = $order->email;
				$temp->phone = $order->phone;
				$temp->created = $date->toSql();
				$temp->published = 1;

				$db->insertObject('#__taxibooking_users', $temp);
				$tbUserId = $db->insertid();
			}
		}

		return true;
	}

       /**
	* Send Email to owner of the order
	*
	* @access	public
	* @since	1.0
	*/
	public function sendMailDetailsToOwner($row_queue,$send_copy_order_email=false)
	{
		//initialise variables
		$app = JFactory::getApplication();
		$site_name = $app->getCfg('sitename');
		$db =  JFactory::getDBO();
		$elsettings =  booking_helper::config();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();

		if ($row_queue->state == 1) {
		    $row_queue->order_status .= '<span style="color:green;">'.JText::_('NEW_ORDER_STATUS_ACCEPTED').'</span>';
		}
		elseif ($row_queue->state == 0) {
		    $row_queue->order_status .= '<span style="color:red;">'.JText::_('NEW_ORDER_STATUS_REJECTED').'</span>';
		}
		elseif ($row_queue->state == -1) {
		    $row_queue->order_status .= '<span style="color:yellow;">'.JText::_('NEW_ORDER_STATUS_ARCHIVED').'</span>';
		}
		elseif ($row_queue->state == -2) {
		    $row_queue->order_status .= '<span style="color:green;">'.JText::_('NEW_ORDER_STATUS_WAITING').'</span>';
		}

		$payment_data = '';
		JPluginHelper::importPlugin('tbpayment');
		$_dispatcher = JDispatcher::getInstance();
		$_returnValues = $_dispatcher->trigger('plgTbOnShowOrderEmailsInvoice',array( $row_queue->id,$row_queue->payment));
		foreach ($_returnValues as $_returnValue) {
			if ($_returnValue !== null) {
				$payment_data .= $_returnValue;
			}
		}

		$converted_currency_label = '';
		     $returnValues = $_dispatcher->trigger('plgTbonShowConvertedPriceLabel', array(&$row_queue->payment, $row_queue->cprice, &$converted_currency_label));

		// glean language specific header and footer info
		$header_info = $elsettings->header_info;
		$header_info = isset($header_info[$lang_tag]) ? changeEditorImageUrl($header_info[$lang_tag]) : '';

		$contact_info = $elsettings->contact_info;
		$contact_info = isset($contact_info[$lang_tag]) ? changeEditorImageUrl($contact_info[$lang_tag]) : '';

		// now get the email template
		ob_start();
		include( JPATH_COMPONENT.DS .'templates'.DS.'order_emails'.DS.'confirmation_email.tpl.php' );
		$mailbody = ob_get_contents();
		ob_end_clean();

		$pdf_file = '';
		if ($row_queue->state==1)
		{
			// confirm booked seats if this is shuttle booking
			if($row_queue->booking_type=='shuttle'){
			    booking_helper::confirm_shuttle_booking($row_queue);
			}

			// glean language specific header and footer info
			$header_info_arr = $elsettings->header_info;
			$header_info_pdf = changeEditorImagePath($header_info_arr[$lang_tag]);

			$contact_info_arr = $elsettings->contact_info;
			$contact_info_pdf = changeEditorImagePath($contact_info_arr[$lang_tag]);

			ob_start();
			include( JPATH_COMPONENT.DS .'templates'.DS.'order_invoice.tpl.php' );
			$invoice_template = ob_get_contents();
			ob_end_clean();

			require_once(JPATH_COMPONENT_ADMINISTRATOR."/classes/dompdf_lib.php");
			$dompdf_lib = new Dompdf_lib;
			$dompdf_lib->set_custom_paper('A4');
			$pdfoutput = $dompdf_lib->convert_html_to_pdf($invoice_template, '', false);

			$invoice_title = ($elsettings->invoice_title!="") ? $elsettings->invoice_title."_".$row_queue->id.".pdf" : "taxi_reservation_$row_queue->id.pdf";

			$pdf_file = JPATH_COMPONENT_ADMINISTRATOR . DS . "documents".DS.$invoice_title;
			file_put_contents($pdf_file, $pdfoutput);

			// update order invoice title
			$query = 'UPDATE #__taxibooking_orders SET'
				.' invoice_title = ' . $db->Quote($invoice_title)
				.' WHERE id = ' . $row_queue->id;
			$db->setQuery($query);
			$db->execute();
		}

		// now send the email
		$mail =  JFactory::getMailer();
		$jconfig = new JConfig();
		$MailFrom = $jconfig->mailfrom;
		$FromName = JText::sprintf("NEW_ORDER_EMAIL_YOUR_WEBSITE_NAME", $jconfig->fromname);
		$mail->setSender(array($MailFrom, $FromName));
		$mail->setSubject(JText::sprintf('NEW_ORDER_EMAIL_SUBJECT_ORDER_NUMBER', $row_queue->order_number));
		$mail->setBody($mailbody);
		$mail->IsHTML(true);
		$mail->addRecipient($row_queue->email);

		if($pdf_file!=""&&$elsettings->show_price==1)
		{
		    $mail->addAttachment($pdf_file);
		}

		if(explode(',',$elsettings->additional_emails)){
		     $additional_emails = explode(',',$elsettings->additional_emails);
		     if(!empty($additional_emails)){
			     $mail->addBCC($additional_emails);
		     }
		}

		// send a copy to Parent User
		$parentClient = booking_helper::getParentClient($row_queue->email);
		if($parentClient){
			$mail->addBCC($parentClient->email);
		}

		$sent = $mail->Send();

		// send emails to all admin
		$query = 'SELECT u.id, u.email, u.name' .
			' FROM #__users AS u' .
			' LEFT JOIN #__user_usergroup_map AS gu ON gu.user_id = u.id' .
			' WHERE (gu.group_id = 8 OR gu.group_id = 7) ' .
			' AND u.sendEmail = 1 AND u.block = 0';
		$db->setQuery($query);
		$adminRows = $db->loadObjectList();

		$receiver='admins';
		// now get the email template
		ob_start();
		include( JPATH_COMPONENT.DS .'templates'.DS.'order_emails'.DS.'confirmation_email.tpl.php' );
		$admin_mail_body = ob_get_contents();
		ob_end_clean();

		// order submitter IP in only admin email
		$admin_mail_body .= '<br/>Order submitted from IP: '.$row_queue->ip_address.' - <a href="http://ip-lookup.net/index.php?ip='.$row_queue->ip_address.'" target="blank">Look it up</a>';

		$admin_emails = array();
		// send email notification to admins
		foreach ($adminRows as $adminRow) {

			$admin_emails[] = $adminRow->email;

			$mail =  JFactory::getMailer();
			$mail->setSender(array($MailFrom, $FromName));
			$mail->setSubject(JText::sprintf('NEW_ORDER_EMAIL_SUBJECT_ORDER_NUMBER', $row_queue->order_number));
			$mail->setBody($admin_mail_body);
			$mail->IsHTML(true);
			$mail->addRecipient($adminRow->email);
			$mail->addReplyTo($row_queue->email, $row_queue->names);

			$sent = $mail->Send();
		}

		// Booking notification email will also receive a copy if it is not any admins email
		if($elsettings->booking_notification_email!="" && !in_array($elsettings->booking_notification_email, $admin_emails)){
			$mail =  JFactory::getMailer();
			$mail->setSender(array($MailFrom, $FromName));
			$mail->setSubject(JText::sprintf('NEW_ORDER_EMAIL_SUBJECT_ORDER_NUMBER', $row_queue->order_number));
			$mail->setBody($admin_mail_body);
			$mail->IsHTML(true);
			$mail->addRecipient($elsettings->booking_notification_email);
			$mail->addReplyTo($row_queue->email, $row_queue->names);

			$sent = $mail->Send();
		}

		// sent order copy email
		if($send_copy_order_email)
		{
			$query = $db->getQuery(true);
			$query->select('DISTINCT a.user_id');
			$query->from('#__taxibooking_order_copyusers AS a');
			$query->select('u.name, u.email')
				->join('LEFT', $db->quoteName('#__users') . ' AS u ON u.id = a.user_id');
			$query->where('a.order_id = '.(int)$row_queue->id);
			$db->setQuery((string)$query);
			$copy_users = $db->loadObjectList();

			if(!empty($copy_users)){
				foreach($copy_users as $copy_user){
					$mail =  JFactory::getMailer();
					$mail->setSender(array($MailFrom, $FromName));
					$mail->setSubject(JText::sprintf('NEW_ORDER_EMAIL_COPY_USER_SUBJECT', $row_queue->names, $site_name ));
					$mail->setBody($mailbody);
					$mail->IsHTML(true);
					$mail->addRecipient($copy_user->email, $copy_user->name);

					$sent = $mail->Send();
				}
			}
		}

		return true;
	}

	/**
	* Get extras according to the user's choice Pickup and dropoff
	*
	* @access	public
	*/
	public function getExtraList()
	{
		$result = array('error' => 0, 'msg' => '');
		$db = JFactory::getDBO();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();

		$poi_id = JRequest::getInt('poiid', 0);
		$route_from = JRequest::getInt('route_from', 0);
		$route_to = JRequest::getInt('route_to', 0);
		$airports1 = JRequest::getVar('address_from', '');
		$airports2 = JRequest::getVar('address_to', '');
		$type = JRequest::getVar('type', 'pickup');

		$where = array();
		$where[] = 'f.published = 1';
		$where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';

		switch($type){

		    case 'pickup':
			if($airports1!='')
			{
			    $poi_obj = booking_helper::point_details($poi_id);

			    $pickup_poicat = $poi_obj->catid;
			    $where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
			    $where[] = 'f.show_on_pickup = 1';
			    $where[] = 'f.show_on_user_details = 0';
			    $where[] = 'f.show_on_shuttles = 0';
			}
			break;

		    case 'dropoff':
			if($airports2!='')
			{
			    $poi_obj = booking_helper::point_details($poi_id);

			    $dropoff_poicat = $poi_obj->catid;
			    $where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
			    $where[] = 'f.show_on_dropoff = 1';
			    $where[] = 'f.show_on_user_details = 0';
			    $where[] = 'f.show_on_shuttles = 0';
			}
			break;

		    case 'route_pickup':
			if($route_from > 0)  // customer choose special route
			{
			    $poi_obj = booking_helper::point_details($route_from);
			    $pickup_poicat = $poi_obj->catid;

			    $where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
			    $where[] = 'f.show_on_pickup = 1';
			    $where[] = 'f.show_on_user_details = 0';
			    $where[] = 'f.show_on_shuttles = 0';
			}
			break;

		    case 'route_dropoff':
			if($route_to > 0)
			{
			    $poi_obj = booking_helper::point_details($route_to);
			    $dropoff_poicat = $poi_obj->catid;

			    $where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
			    $where[] = 'f.show_on_dropoff = 1';
			    $where[] = 'f.show_on_user_details = 0';
			    $where[] = 'f.show_on_shuttles = 0';
			}
			break;

			case 'hourly_hire':

				$where[] = 'f.show_on_hourly = 1';
				$where[] = 'f.show_on_user_details = 0';
				break;

			case 'user_details':

				$where[] = 'f.show_on_user_details = 1';
				break;

			case 'address_pickup':

				$where[] = 'f.show_on_pickup = 1';
				$where[] = 'f.show_on_address = 1';
				$where[] = 'f.show_on_user_details = 0';
				$where[] = 'f.show_on_shuttles = 0';
				$type = 'pickup';
				break;

			case 'address_dropoff':

				$where[] = 'f.show_on_dropoff = 1';
				$where[] = 'f.show_on_address = 1';
				$where[] = 'f.show_on_user_details = 0';
				$where[] = 'f.show_on_shuttles = 0';
				$type = 'dropoff';
				break;

			case 'shuttle_pickup':

				$where[] = 'f.show_on_pickup = 1';
				$where[] = 'f.show_on_shuttles = 1';
				$where[] = 'f.show_on_user_details = 0';
				break;

			case 'shuttle_dropoff':

				$where[] = 'f.show_on_dropoff = 1';
				$where[] = 'f.show_on_shuttles = 1';
				$where[] = 'f.show_on_user_details = 0';
				break;

			default:
				break;
		}

		$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
		$query = 'SELECT f.* '
			. ' FROM #__taxibooking_fields AS f'
			. $where
			. ' ORDER BY f.ordering ASC'
		;

		$db->setQuery($query);
		$db->query();
		$rows = $db->loadObjectList();

		$html = '';

		if(!empty($poi_obj->text)){
		    $html .='<div class="ver_input_wrap clearfix"><label>'.$poi_obj->text.'</label></div>';
		}

		if(!empty($rows))
		{
		    foreach($rows as $row)
		    {
			if($row->text!=""){
			    $field_title = '<a href="javascript:void(0);" class="field_desc" title="'.strip_tags($row->text).'">'.$row->title.'</a>';
			}
			else {
			    $field_title = $row->title;
			}

			if($type=="user_details"){
				$additional_class = ($row->field_type!='input' && $row->field_type!='textarea') ? ' select' : '';
				$html .= '<div class="info_input_wrap'.$additional_class.' clearfix">
					<label>'.$field_title.'</label>
					<div class="info_inputbox">';

				if($row->field_type=='input'){
				    $additional_class = ($row->is_mandatory==1) ? ' required' : '';
				    $html .=    '<input class="ver_inputbox extra'.$additional_class.'" type="text" value="" name="extras['.$type.']['.$row->id.']" />';
				}
				elseif($row->field_type=='textarea'){
				    $additional_class = ($row->is_mandatory==1) ? ' required' : '';
				    $html .=    '<textarea class="ver_inputbox extra'.$additional_class.'" name="extras['.$type.']['.$row->id.']"></textarea>';
				}
				elseif($row->field_type=='extra'){
				    $html .=    '<select class="seat_options select extra" name="extras['.$type.']['.$row->id.']">';
				    $html .= '<option value="">'.JText::_('SELECT_OPTION').'</option>';
				    $start = ($row->allow_zero==1) ? 0 : 1;
				    for($i = $start; $i <= $row->quantity; $i++){
					$html .= '<option value="'.$i.'">'.$i.'</option>';
				    }
				    $html .=    '</select>';
				}
				elseif($row->field_type=='optionlist'){
				    $html .=    '<select class="seat_options select extra" name="extras['.$type.']['.$row->id.']">';
				    $html .= '<option value="">'.JText::_('SELECT_OPTION').'</option>';
				    $field_options = unserialize($row->field_options);
				    for($i = 0; $i < count($field_options); $i++){
					$html .= '<option value="'.htmlspecialchars($field_options[$i]).'">'.$field_options[$i].'</option>';
				    }
				    $html .=    '</select>';
				}
				$html .=    '</div></div>';
			}
			else {
				$html .= '<div class="ver_input_wrap clearfix">
					<label>'.$field_title.'</label>';

				if($row->field_type=='input'){
				    $additional_class = ($row->is_mandatory==1) ? ' required' : '';
				    $html .=    '<input class="ver_inputbox extra'.$additional_class.'" type="text" value="" name="extras['.$type.']['.$row->id.']" />';
				}
				elseif($row->field_type=='textarea'){
				    $additional_class = ($row->is_mandatory==1) ? ' required' : '';
				    $html .=    '<textarea class="ver_inputbox extra'.$additional_class.'" name="extras['.$type.']['.$row->id.']"></textarea>';
				}
				elseif($row->field_type=='extra'){
				    $html .=    '<select class="seat_options select extra" name="extras['.$type.']['.$row->id.']">';
				    $html .= '<option value="">'.JText::_('SELECT_OPTION').'</option>';
				    $start = ($row->allow_zero==1) ? 0 : 1;
				    for($i = $start; $i <= $row->quantity; $i++){
					$html .= '<option value="'.$i.'">'.$i.'</option>';
				    }
				    $html .=    '</select>';
				}
				elseif($row->field_type=='optionlist'){
				    $html .=    '<select class="seat_options select extra" name="extras['.$type.']['.$row->id.']">';
				    $html .= '<option value="">'.JText::_('SELECT_OPTION').'</option>';
				    $field_options = unserialize($row->field_options);
				    for($i = 0; $i < count($field_options); $i++){
					$html .= '<option value="'.htmlspecialchars($field_options[$i]).'">'.$field_options[$i].'</option>';
				    }
				    $html .=    '</select>';
				}
				$html .=    '</div>';
			}

		    }
		}

		$result['msg'] = $html;
		echo json_encode($result);
		exit();
	}

	/**
	* Get extras for return section
	*
	* @access	public
	*/
	public function getReturnExtraList()
	{
		$result = array('error' => 0, 'msg' => '');
		$db = JFactory::getDBO();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();

		$route_from_fld = JRequest::getVar('route_from_fld', '');
		$route_from = JRequest::getInt('route_from', 0);
		$route_to_fld = JRequest::getVar('route_to_fld', '');
		$route_to = JRequest::getInt('route_to', 0);

		$airports1 = JRequest::getVar('address_from', '');
		$address_from_lat = JRequest::getVar('address_from_lat', '');
		$address_from_lng = JRequest::getVar('address_from_lng', '');

		$airports2 = JRequest::getVar('address_to', '');
		$address_to_lat = JRequest::getVar('address_to_lat', '');
		$address_to_lng = JRequest::getVar('address_to_lng', '');

		$booking_type = JRequest::getVar('booking_type', 'address');

		$pickup_extras = array();
		$dropoff_extras = array();

		if($booking_type=='address')
		{
		    $return_pickup = $airports2;
		    $return_dropoff = $airports1;

		    if($airports2!='')
		    {
			$where = array();
			$where[] = 'f.published = 1';
			$where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';

			$poi_where = array('p.lat = "'.$address_to_lat.'"', 'p.long = "'.$address_to_lng.'"');
			$poiObj = booking_helper::get_specific_place_details($poi_where);
			if($poiObj) // user chose POI
			{
				$pickup_poicat = $poiObj->catid;
				if($pickup_poicat!=""){
					$where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
				}
				$where[] = 'f.show_on_pickup = 1';
			}
			else { // user chose google address
				$where[] = 'f.show_on_address = 1';
			}

			$where[] = 'f.show_on_return = 1';
			$where[] = 'f.show_on_user_details = 0';

			$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
			$query = 'SELECT f.* '
				. ' FROM #__taxibooking_fields AS f'
				. $where
				. ' ORDER BY f.ordering ASC'
			;
			$db->setQuery($query);
			$db->query();
			$pickup_extras = $db->loadObjectList();
		    }
		    if($airports1!='')
		    {
			$where = array();
			$where[] = 'f.published = 1';
			$where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';

			$poi_where = array('p.lat = "'.$address_from_lat.'"', 'p.long = "'.$address_from_lng.'"');
			$poiObj = booking_helper::get_specific_place_details($poi_where);
			if($poiObj) // user chose POI
			{
				$dropoff_poicat = $poiObj->catid;
				if($dropoff_poicat!=""){
					$where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
				}
				$where[] = 'f.show_on_dropoff = 1';
			}
			else { // user chose google address
				$where[] = 'f.show_on_address = 1';
			}

			$where[] = 'f.show_on_return = 1';
			$where[] = 'f.show_on_user_details = 0';

			$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
			$query = 'SELECT f.* '
				. ' FROM #__taxibooking_fields AS f'
				. $where
				. ' ORDER BY f.ordering ASC'
			;
			$db->setQuery($query);
			$db->query();
			$dropoff_extras = $db->loadObjectList();
		    }
		}
		elseif($booking_type=='offers')
		{
		    $return_pickup = $route_to_fld;
		    $return_dropoff = $route_from_fld;

		    if($route_to > 0)
		    {
			$where = array();
			$where[] = 'f.published = 1';
			$where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';

			$pickup_poicat = booking_helper::get_place_field_by_id($route_to, 'catid');
			if($pickup_poicat!=""){
				$where[] = "(f.catid='$pickup_poicat' OR f.catid LIKE '$pickup_poicat,%' OR f.catid LIKE '%,$pickup_poicat' OR f.catid LIKE '%,$pickup_poicat,%')";
			}
			$where[] = 'f.show_on_pickup = 1';
			$where[] = 'f.show_on_return = 1';
			$where[] = 'f.show_on_user_details = 0';

			$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
			$query = 'SELECT f.* '
				. ' FROM #__taxibooking_fields AS f'
				. $where
				. ' ORDER BY f.ordering ASC'
			;
			$db->setQuery($query);
			$db->query();
			$pickup_extras = $db->loadObjectList();
		    }

		    if($route_from > 0)
		    {
			$where = array();
			$where[] = 'f.published = 1';
			$where[] = '(f.language = "*" OR f.language = "'.$lang_tag.'")';

			$dropoff_poicat = booking_helper::get_place_field_by_id($route_from, 'catid');
			if($dropoff_poicat!=""){
				$where[] = "(f.catid='$dropoff_poicat' OR f.catid LIKE '$dropoff_poicat,%' OR f.catid LIKE '%,$dropoff_poicat' OR f.catid LIKE '%,$dropoff_poicat,%')";
			}
			$where[] = 'f.show_on_dropoff = 1';
			$where[] = 'f.show_on_return = 1';
			$where[] = 'f.show_on_user_details = 0';

			$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
			$query = 'SELECT f.* '
				. ' FROM #__taxibooking_fields AS f'
				. $where
				. ' ORDER BY f.ordering ASC'
			;

			$db->setQuery($query);
			$db->query();
			$dropoff_extras = $db->loadObjectList();
		    }
		}

		$html = '';
		if(($airports1!="" || $route_from>0) && ($airports2!="" || $route_to>0) )
		{
		    ob_start();
		    include( JPATH_COMPONENT.DS .'templates'.DS.'return_extras.tpl.php' );
		    $html = ob_get_contents();
		    ob_end_clean();
		}

		$result['msg'] = $html;
		echo json_encode($result);
		exit();
	}

	/**
	* Get shuttle dropoff POIs
	*
	* @access	public
	*/
	public function getShuttleDropoffPOIs()
	{
		$result = array('error' => 0, 'msg' => '');
		$db = JFactory::getDBO();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();

		$shuttle_pickup_poi = JRequest::getInt('shuttle_pickup_poi', 0);

		$shuttle_dropoff_pois = array();

		// first collect routes associated with this pickup POI
		$where = array();
		$where[] = 'r.published = 1';
		$where[] = '(r.language = "*" OR r.language = "'.$lang_tag.'")';
		$where[] = 'rs.poi_id = '.$db->Quote($shuttle_pickup_poi);

		$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
		$query = 'SELECT rs.*'
			. ' FROM #__taxibooking_shuttle_route_stops AS rs'
			. ' LEFT JOIN #__taxibooking_shuttle_routes AS r ON r.id = rs.route_id'
			. $where
		;
		$db->setQuery($query);
		$db->query();
		$routes = $db->loadObjectList();

		if(!empty($routes))
		{
			foreach($routes as $route)
			{
				$pickup_poi_order = $route->ordering;

				$where = array();
				$where[] = 'rs.route_id = '.$route->route_id;
				$where[] = 'rs.ordering > '.(int)$pickup_poi_order;

				$where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );
				$query = 'SELECT p.title AS poi_title, p.id AS poiid, p.lat AS poilat, p.long AS poilng, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image'
					. ' FROM #__taxibooking_shuttle_route_stops AS rs'
					. ' LEFT JOIN #__taxibooking_points AS p ON p.id = rs.poi_id'
					. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = p.catid'
					. $where
					. ' ORDER BY p.title ASC'
				;
				$db->setQuery($query);
				$db->query();
				$rows = $db->loadObjectList();

				if(!empty($rows))
				{
					foreach($rows as $row)
					{
						$shuttle_dropoff_pois[$row->poiid] = $row;
					}
				}
			}
		}

		$html = '';

		if (!empty($shuttle_dropoff_pois))
		{
			$i = 0;
			foreach ($shuttle_dropoff_pois as $poiid => $row)
			{
				$html .= '<div class="poi_link" data-poiid="'.$row->poiid.'">';
				$html .= ($row->cat_image!="") ? '<img src="'.JURI::base().$row->cat_image.'" alt="'.$row->cattitle.'" title="'.$row->cattitle.'" class="poicat_icon" />&nbsp;' : '';
				$html .= '<span>'.$row->poi_title.'</span></div>'."\n";

				$i++;
			}
		}

		$result['msg'] = $html;
		echo json_encode($result);
		exit();
	}

	/**
	* Get shuttle dropoff POIs
	*
	* @access	public
	*/
	public function getShuttleTimeOptions()
	{
		$result = array('error' => 0, 'msg' => '');
		$db = JFactory::getDBO();
		$session =  JFactory::getSession();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();

		$elsettings =  booking_helper::config();

		$siteOffset = booking_helper::set_tbtimezone();
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->format('YmdHi', true);

		$orderdate = JRequest::getVar('orderdate_shuttle', '');
		$shuttle_pickup_poi = JRequest::getInt('shuttle_pickup_poi', 0);
		$shuttle_dropoff_poi = JRequest::getInt('shuttle_dropoff_poi', 0);
		$clear_previous_selection = JRequest::getInt('clear_previous_selection', 1);

		if($elsettings->date_format=='mm-dd-yy') {
			$date1_arr = explode('-',$orderdate);
			$orderdate =  $date1_arr[2].$date1_arr[0].$date1_arr[1];
		}
		else {
			$date1_arr = explode('-',$orderdate);
			$orderdate =  $date1_arr[2].$date1_arr[1].$date1_arr[0];
		}
		$shuttle_dropoff_pois = array();

		$query = 'SELECT DISTINCT t1.route_id, t1.arrival_time'
			. ' FROM (
				SELECT route_id, arrival_time, ordering
				FROM `#__taxibooking_shuttle_route_stops` rs
				WHERE rs.poi_id = '.(int)$shuttle_pickup_poi
			. ' 	)t1
				JOIN (
				SELECT route_id, arrival_time, ordering
				FROM `#__taxibooking_shuttle_route_stops` rs
				WHERE rs.poi_id = '.(int)$shuttle_dropoff_poi
			. ' 	)t2'
			. ' WHERE t1.ordering < t2.ordering'
			. ' AND t1.route_id = t2.route_id'
			. ' ORDER BY t1.arrival_time'
		;
		//echo str_replace('#__', 'nfgwj_', $query);
		$db->setQuery($query);
		$db->query();
		$routes = $db->loadObjectList();

		$html = '';
		if(!empty($routes))
		{
			foreach($routes as $route)
			{
				// check order date availability for the car associated to this route
				$query = $db->getQuery(true);
				$query->select('c.*');
				$query->from('#__taxibooking_cars AS c');
				$query->join('LEFT', '#__taxibooking_shuttle_routes AS r ON r.car_id = c.id');
				$query->where('r.id = '.(int)$route->route_id);
				$db->setQuery((string)$query);
				$car = $db->loadObject();

				if($car)
				{
					$total_seats = $car->passenger_no;
					$temp = explode(':', $route->arrival_time);
					//echo $orderdate.$temp[0].$temp[1].'---'.$now.'<br>';
					if($orderdate.$temp[0].$temp[1] > $now) // hide past times
					{
						$order_date_time_str = strtotime($orderdate.' '.$route->arrival_time);

						if(booking_helper::check_car_block_dates($car,$order_date_time_str)===FALSE){
							continue;
						}
						elseif(booking_helper::check_todays_availability($car,$order_date_time_str)===FALSE) { // check todays opening/closing time and compare with current time
							continue;
						}
						else {
							if($elsettings->time_format=='12hr'){
								$shuttle_time = date("g:i A", strtotime($route->arrival_time));
							}
							else {
								$shuttle_time = $temp[0].':'.$temp[1];
							}

							// get total booked seats today of the shuttle associated with this route
							$query = 'SELECT SUM(b.booked_seats) AS booked_seats'
								. ' FROM #__taxibooking_shuttle_bookings AS b'
								. ' WHERE b.route_id = '.(int)$route->route_id
								. ' AND b.order_date = '.$db->Quote($orderdate)
							;
							//echo str_replace('#__', 'nfgwj_', $query);
							$db->setQuery($query);
							$db->query();
							$booked_seats = $db->loadResult();

							$available_seats = $total_seats - $booked_seats;

							if($clear_previous_selection==1){
								$checked = '';
							}
							else {
								$checked = ($session->get('shuttletime', '')==$route->arrival_time) ? ' checked="checked"' : '';
							}

							// we have to show a message if this route has no available seats
							if($available_seats > 0){
								$html .= '<div class="shuttletime_wrap" data-routeid="'.$route->route_id.'" data-seats="'.$available_seats.'">
								<input type="radio" name="shuttletime" id="shuttletime_'.$route->route_id.'" value="'.$route->arrival_time.'"'.$checked.' />
								<label for="shuttletime_'.$route->route_id.'">'.$shuttle_time.'</label>
								</div>';
							}
						}
					}
				}
			}
		}

		if($html==""){
			$result['msg'] = JText::_('COM_TAXIBOOKING_NO_SHUTTLE_FOUND');
			$result['error'] = 1;
		}
		else {
			$result['msg'] = $html;
			$result['error'] = 0;
		}
		echo json_encode($result);
		exit();
	}
}
