<?php

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

/**
 * Component Item Controller
 */
class TaxiBookingControllerOrders extends TaxiBookingController
{
	/**
	 * Constructor
	 *
	 * @since 1.0
	 */
	function __construct()
	{
		parent::__construct();
	}

	/**
	 * logic for cancel an action
	 *
	 * @access public
	 * @return void
	 * @since 1.0
	 */
	function cancel()
	{
                $this->setRedirect( JRoute::_('index.php?option=com_taxibooking&view=orders', false) );
	}

	/**
	 * Logic to create the view for the edit categoryscreen
	 *
	 * @access public
	 * @return void
	 * @since 1.0
	 */
	function edit( )
	{		
		JRequest::setVar( 'view', 'order' );

		$model 	= $this->getModel('order');
		
		parent::display();
	}

        /**
	 * Logic to save an order
	 *
	 * @access public
	 * @return void
	 * @since 1.0
	 */
	function save()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$task		= JRequest::getVar('task');
		$tmpl		= JRequest::getVar('tmpl', '');

		//Sanitize
		$post = JRequest::get( 'post' );
		
		$model = $this->getModel('order');

		if ( $model->store($post) ) {
			$msg = JText::_( 'ITEM_SAVED' );
			$cache = JFactory::getCache('com_taxibooking');
			$cache->clean();
		} else {
			$msg = JText::_( 'ERROR SAVING ITEM' );
			//JError::raiseError( 500, $model->getError() );
		}
		
		if($tmpl=='component'){
			$link = 'index.php?option=com_taxibooking&view=order&layout=modal&tmpl=component&cid='.$post['id'];
		}
		else {
			$link = JRoute::_('index.php?option=com_taxibooking&view=orders', false);
		}

		$this->setRedirect($link, $msg);
	}
}