<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

/**
 * Controller for the payment response view
 */
class TaxibookingControllerPluginresponse extends TaxiBookingController {

    /**
     * Construct the cart
     *
     * @access public
     */
    public function __construct() {
	parent::__construct();
    }

    /**
     * ResponseReceived()
     */
    function pluginresponsereceived() {

	if(!class_exists('tbPaymentPlugin')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbpayment_plugin_helper.php');
	    
	JPluginHelper::importPlugin('tbpayment');

	$return_context = "";
	$dispatcher = JDispatcher::getInstance();
	$html = "";
	$paymentResponse = JText::_('THANKS_MESSAGE') . ' <br><a href="https://kabsky.co.uk">Home</a>';
	$returnValues = $dispatcher->trigger('plgTbOnPaymentResponseReceived', array( 'html' => &$html,&$paymentResponse));
	
	$view = $this->getView('pluginresponse', 'html');
	$layoutName = JRequest::getVar('layout', 'default');
	$view->setLayout($layoutName);

	$view->assignRef('paymentResponse', $paymentResponse);
	$view->assignRef('paymentResponseHtml', $html);

	// Display it all
	$view->display();
    }
    /**
     * PaymentUserCancel()
     * From the payment page, the user has cancelled the order. The order previousy created is deleted.
     * then delete the order
     */
    function pluginuserpaymentcancel() {
	
	$app = JFactory::getApplication();
	
	if(!class_exists('tbPaymentPlugin')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbpayment_plugin_helper.php');

	JPluginHelper::importPlugin('tbpayment');
	$dispatcher = JDispatcher::getInstance();
	$dispatcher->trigger('plgTbOnUserPaymentCancel', array());
	
	$msg = JText::_('You have cancelled your transaction!');
        $this->setRedirect(JRoute::_('index.php?option=com_taxibooking', false), $msg);
    }

    /**
     * Attention this is the function which processs the response of the payment plugin
     *
     * @return success of update
     */
    function pluginnotification() {

	if(!class_exists('tbPaymentPlugin')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbpayment_plugin_helper.php');

	JPluginHelper::importPlugin('tbpayment');
	$dispatcher = JDispatcher::getInstance();
	$returnValues = $dispatcher->trigger('plgTbOnPaymentNotification', array());
	
	$view = $this->getView('pluginresponse', 'html');
	$layoutName = JRequest::getVar('layout', 'default');
	$view->setLayout($layoutName);
	
	$html = JRequest::getVar('html', JText::_('COM_TAXIBOOKING_ORDER_PROCESSED'), 'default', 'STRING', JREQUEST_ALLOWRAW);

	$view->assignRef('paymentResponse', $paymentResponse);
	$view->assignRef('paymentResponseHtml', $html);

	// Display it all
	$view->display();
    }
}