<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

class sms_helper {
	
	var $_username = '';
	var $_password = '';
        var $_api_id = '';
	var $_sender_id = '';
        var $_to = '';
        var $_text = '';
	
        function __construct($options)
        {
            $this->_username = $options['username'];
            $this->_password = $options['password'];
            $this->_api_id = $options['api_id'];
	    $this->_sender_id = $options['sender_id'];
            $this->_to = $options['to'];
        }
        
        function getURL()
        {
            return 'http://api.clickatell.com/http/sendmsg';
        }
	
	function prepare_text($order, $elsettings)
	{
		$lang = JFactory::getLanguage();
		$lang->load('com_taxibooking');
		
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		
		$text = date('d/M H:i', (int)$order->datetime1);
		$text .= ' '.$order->begin;
		$text .= ' to '.$order->end;
		
		$stops = unserialize($order->stops);
		if(!empty($stops)) {
			$text .= ', '.count($stops);
			$text .= ' Stop';
			$text .= count($stops) > 1 ? 's':'';
			$text .= ' on the way,';
		}
		$tmp = ($text.' ');
		$tmp .= $elsettings->currency.$order->cprice;
		$tmp .= ' '.JText::sprintf('SMS_ORDER_STATUS', $this->get_status_text($order->state));
		$tmp .= ' '.JText::_('SMS_ORDER_DETAILS_VIA_EMAIL');
		
		$HexText = $this->utf8_to_unicode($tmp); 
		$text = implode("",$HexText);

		$this->_text = $text;
	}
	
	function get_status_text($order_status)
	{
		if ($order_status == '1') {
			return JText::_('Accepted');
		} else if ($order_status == '0') {
			return JText::_('Rejected');
		} else if ($order_status == '-1') {
			return JText::_('Archived');
		} else {
			return JText::_('Waiting');
		}
	}
        
        function call()
        {
		// auth call
		$url = $this->getURL().'?';
		$url .= 'user='.$this->_username;
		$url .= '&password='.$this->_password;
		$url .= '&api_id='.$this->_api_id;
		$url .= '&to='.$this->_to;
		//$url .= '&concat=2';  // Specifies the maximum number of message parts available for the message. default value = 3
		$url .= '&unicode=1';
		$url .= '&text='.$this->_text;
		
		if($this->_sender_id!=""){
			$url .= '&mo=1&from='.$this->_sender_id;
		}

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$response = curl_exec($ch);
		$curl_errno = curl_errno($ch);
		$curl_error = curl_error($ch);
		if ($curl_errno > 0) {
			echo "cURL Error ($curl_errno): $curl_error\n";
			exit();
		} 
		curl_close($ch);
		$send = explode(":",$response);
		
		//$response = file($url);
		//$send = explode(":",$response[0]);
		
		if ($send[0] == "ID") {
			return "SMS Success - ID: ". $send[1];
		} else {
			return "SMS Error: ".$send[1];
		}
        }
	
	function utf8_to_unicode($str)
	{
		$unicode = array(); 
		$values = array(); 
		$lookingFor = 1; 
		
		for ($i = 0; $i < strlen($str); $i++)
		{
			$thisValue = ord($str[$i]); 
			
			if ($thisValue < 128){
				$unicode[] = str_pad(dechex($thisValue), 4, "0", STR_PAD_LEFT);
			}
			else {
				if (count($values) == 0) $lookingFor = ($thisValue < 224) ? 2 : 3; 
				$values[] = $thisValue; 
				if (count($values) == $lookingFor)
				{
					$number = ($lookingFor == 3) ? 
					(($values[0] % 16) * 4096) + (($values[1] % 64) * 64) + ($values[2] % 64): 
					(($values[0] % 32) * 64) + ($values[1] % 64); 
					$number = strtoupper(dechex($number)); 
					$unicode[] = str_pad($number, 4, "0", STR_PAD_LEFT); 
					$values = array(); 
					$lookingFor = 1; 
				}
			}
		}
		return ($unicode); 
	}
}