<?php

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');

/**
 * Component Model
 */
class TaxiBookingModelOrder extends JModelList {

    /**
     * Item data
     *
     * @var object
     */
    var $_item = null;

    /**
     * Constructor
     *
     * @since 1.0
     */
    function __construct() {
        parent::__construct();

        //$cid = JRequest::getVar( 'cid', array(0), '', 'array' );
        $cid = JRequest::getVar('cid', 0);
        //JArrayHelper::toInteger($cid, array(0));
        $this->setId($cid);
    }

    /**
     * Method to set the identifier
     *
     * @access	public
     * @param	int item identifier
     */
    function setId($id) {
        // Set item id and wipe data
        $this->_id = $id;
        $this->_item = null;
    }

    /**
     * Method to load item data
     *
     * @access	private
     * @return	boolean	True on success
     * @since	1.0
     */
    function &getItem() {
        $query = 'SELECT *'
                . ' FROM #__taxibooking_orders'
                . ' WHERE id = ' . $this->_id
        ;
        $this->_db->setQuery($query);
        $this->_item = $this->_db->loadObject();

        return $this->_item;
    }
    
    /**
     * Method to store the order
     *
     * @access	public
     * @return	boolean	True on success
     * @since	1.0
     */
    function store($data)
    {
        // Check for request forgeries
        JRequest::checkToken() or jexit('Invalid Token');
        $app = JFactory::getApplication();
        // Get the page/component configuration
        $params =  JComponentHelper::getParams('com_taxibooking');
        $elsettings =  booking_helper::config();
        
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();

        //Get mailinformation
        $SiteName = $app->getCfg('sitename');
        $MailFrom = $app->getCfg('mailfrom');
        $FromName = $app->getCfg('fromname');
        $tzoffset = $app->getCfg('offset');
        $FromName = JText::sprintf("NEW_ORDER_EMAIL_YOUR_WEBSITE_NAME", $FromName);
        
        // get the order info
        $row_queue = booking_helper::get_order_by_id($data['id']);
        
        // update order status
        $temp = new stdClass();
        $temp->id = $data['id'];
        $temp->state = $data['state'];
        $temp->driver_id = $data['driverid'];
        
        $this->_db->updateObject('#__taxibooking_orders', $temp, 'id');
        
        $mail = JFactory::getMailer();
        
        $states = array(1 => JText::_('ACCEPTED'),
            0 => JText::_('REJECTED'),
            -1 => JText::_('ARCHIVED'),
            -2 => JText::_('WAITING'));

        $order_id = $row_queue->id;
        /**
         * New mail interface
         */
        if ($data['state'] == '1') {
            $row_queue->order_status .= '<span style="color:green;">'.JText::_('NEW_ORDER_STATUS_ACCEPTED').'</span>';
        }
        elseif ($data['state'] == '0') {
            $row_queue->order_status .= '<span style="color:red;">'.JText::_('NEW_ORDER_STATUS_REJECTED').'</span>';
        }
        elseif ($data['state'] == '-1') {
            $row_queue->order_status .= '<span style="color:yellow;">'.JText::_('NEW_ORDER_STATUS_ARCHIVED').'</span>';
        }
        elseif ($data['state'] == '-2') {
            $row_queue->order_status .= '<span style="color:green;">'.JText::_('NEW_ORDER_STATUS_WAITING').'</span>';
        }
        
        $payment_data = '';
        JPluginHelper::importPlugin('tbpayment');
        $_dispatcher = JDispatcher::getInstance();
        $_returnValues = $_dispatcher->trigger('plgTbOnShowOrderEmailsInvoice',array( $row_queue->id,$row_queue->payment));
        foreach ($_returnValues as $_returnValue) {
                if ($_returnValue !== null) {
                        $payment_data .= $_returnValue;
                }
        }
        
        $converted_currency_label = '';
        $returnValues = $_dispatcher->trigger('plgTbonShowConvertedPriceLabel', array(&$row_queue->payment, $row_queue->cprice, &$converted_currency_label));
        
        if($data['driverid'] > 0){
            $driverObj = booking_helper::getDriverInfo($data['driverid']);
        }
        
        if($data['state'] == -1) // Archived email
        {
            booking_helper::sendOrderArchiveEmail($row_queue, $elsettings);
        }
        else {
            /**
            * Creating a pdf file only for Accepted orders
            */
            $pdf_file = '';
            if ($data['state'] == '1')
            {
                $header_info = $elsettings->header_info;
                $header_info_pdf = isset($header_info[$lang_tag]) ? changeEditorImagePath($header_info[$lang_tag]) : '';
                
                $contact_info = $elsettings->contact_info;
                $contact_info_pdf = isset($contact_info[$lang_tag]) ? changeEditorImagePath($contact_info[$lang_tag]) : '';
                
                ob_start();
                include( JPATH_COMPONENT_SITE.DS .'templates'.DS.'order_invoice.tpl.php' );
                $invoice_template = ob_get_contents();
                ob_end_clean();
                
                require_once(JPATH_COMPONENT_ADMINISTRATOR.DS ."/classes/dompdf_lib.php");
                $dompdf_lib = new Dompdf_lib;
                $dompdf_lib->set_custom_paper('A4');
                $pdfoutput = $dompdf_lib->convert_html_to_pdf($invoice_template, '', false);
                
                $invoice_title = ($elsettings->invoice_title!="") ? $elsettings->invoice_title."_".$order_id.".pdf" : "taxi_reservation_$order_id.pdf";
            
                $pdf_file = JPATH_COMPONENT_ADMINISTRATOR . DS . "documents".DS.$invoice_title;
                file_put_contents($pdf_file, $pdfoutput);
                
                // update order invoice title
                $query = 'UPDATE #__taxibooking_orders SET'
                        .' invoice_title =' . $this->_db->Quote($invoice_title)
                        .' WHERE id = ' . $data['id'];
                $this->_db->setQuery($query);
                if (!$this->_db->query()) {
                    $this->setError($this->_db->getErrorMsg());
                    return false;
                }
            }
            
            // glean language specific header and footer info
            $header_info = $elsettings->header_info;
            $header_info = isset($header_info[$lang_tag]) ? changeEditorImageUrl($header_info[$lang_tag]) : '';
            
            $contact_info = $elsettings->contact_info;
            $contact_info = isset($contact_info[$lang_tag]) ? changeEditorImageUrl($contact_info[$lang_tag]) : '';
            
            // now get the email template
            ob_start();
            include( JPATH_COMPONENT.DS .'templates'.DS.'order_emails'.DS.'confirmation_email.tpl.php' );
            $mailbody = ob_get_contents();
            ob_end_clean();
           
            // send email to owner if order status changes
            if ($row_queue->state != $data['state'])
            {
                $mail->setSender(array($MailFrom, $FromName));
                $mail->setSubject(JText::sprintf('BOOKING_STATUS_CHANGED_ORDER', $row_queue->order_number));
                $mail->setBody($mailbody);
                if($pdf_file!=""&&$elsettings->show_price==1)
                {
                    $mail->addAttachment($pdf_file);    
                }            
                $mail->IsHTML(true);
                $mail->addRecipient($row_queue->email);
                $sent = $mail->Send();
            }
            
            /**
            * Sending mail to driver if driver is selected 
            */
            if ($data['driverid'] > 0 && ($row_queue->driver_id != $data['driverid']))
            {
                if(isset($driverObj))
                {
                    $driver_name = $driverObj->name;
                    $driver_email = $driverObj->email;
                    
                    $receiver='driver';
                    // now get the email template
                    ob_start();
                    include( JPATH_COMPONENT.DS .'templates'.DS.'order_emails'.DS.'confirmation_email.tpl.php' );
                    $mailbody = ob_get_contents();
                    ob_end_clean();
                
                    $mail->ClearAllRecipients();
                    $mail->ClearAttachments();
                    $mail->setSender(array($MailFrom, $FromName));
                    $mail->setSubject(JText::sprintf('DRIVER_BOOKING_NOTIFICATION', $driver_email) .' '.JText::sprintf('BOOKING_STATUS_CHANGED_ORDER', $row_queue->order_number));
                    $mail->setBody($mailbody);
                    if($pdf_file!=""&&$elsettings->show_price==1)
                    {
                        $mail->addAttachment($pdf_file);    
                    }
                    $mail->IsHTML(true);
                    $mail->addRecipient($driver_email);
                    $sent = $mail->Send();
                }
            }
            
            /**
            * Remove car booking data if order status is rejected
            */
            if ($data['state'] == 0)
            {
                booking_helper::cancel_car_bookings($order_id);
            }
        }

        return true;
    }
}